/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.worker;

import ch.cyberduck.core.Local;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.ProgressListener;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.transfer.Transfer;
import ch.cyberduck.core.transfer.TransferItem;
import ch.cyberduck.core.worker.Worker;
import ch.cyberduck.core.worker.WorkerListProgressListener;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.log4j.Logger;

public class TransferPromptListWorker
extends Worker<List<TransferItem>> {
    private static final Logger log = Logger.getLogger(TransferPromptListWorker.class);
    private final Path directory;
    private final Local local;
    private final Transfer transfer;
    private final ProgressListener listener;

    public TransferPromptListWorker(Transfer transfer, Path directory, Local local, ProgressListener listener) {
        this.directory = directory;
        this.local = local;
        this.transfer = transfer;
        this.listener = listener;
    }

    @Override
    public List<TransferItem> run(Session<?> session) throws BackgroundException {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("List directory %s", this.directory));
        }
        return this.transfer.list(session, this.directory, this.local, new WorkerListProgressListener(this, this.listener));
    }

    @Override
    public String getActivity() {
        return MessageFormat.format(LocaleFactory.localizedString("Listing directory {0}", "Status"), this.directory.getName());
    }

    @Override
    public List<TransferItem> initialize() {
        return Collections.emptyList();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransferPromptListWorker that = (TransferPromptListWorker)o;
        if (!Objects.equals(this.directory, that.directory)) {
            return false;
        }
        return Objects.equals(this.transfer, that.transfer);
    }

    public int hashCode() {
        int result = this.directory != null ? this.directory.hashCode() : 0;
        result = 31 * result + (this.transfer != null ? this.transfer.hashCode() : 0);
        return result;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("TransferPromptListWorker{");
        sb.append("transfer=").append(this.transfer);
        sb.append('}');
        return sb.toString();
    }
}

