/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.googlestorage;

import ch.cyberduck.core.Cache;
import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.VersionId;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.AttributesFinder;
import ch.cyberduck.core.features.Find;
import ch.cyberduck.core.features.Write;
import ch.cyberduck.core.googlestorage.GoogleStorageExceptionMappingService;
import ch.cyberduck.core.googlestorage.GoogleStoragePathContainerService;
import ch.cyberduck.core.googlestorage.GoogleStorageSession;
import ch.cyberduck.core.http.AbstractHttpWriteFeature;
import ch.cyberduck.core.http.DefaultHttpResponseExceptionMappingService;
import ch.cyberduck.core.http.DelayedHttpEntityCallable;
import ch.cyberduck.core.http.HttpResponseOutputStream;
import ch.cyberduck.core.io.ChecksumCompute;
import ch.cyberduck.core.io.ChecksumComputeFactory;
import ch.cyberduck.core.io.HashAlgorithm;
import ch.cyberduck.core.shared.DefaultAttributesFinderFeature;
import ch.cyberduck.core.shared.DefaultFindFeature;
import ch.cyberduck.core.transfer.TransferStatus;
import com.google.api.services.storage.Storage;
import com.google.gson.stream.JsonReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.HttpResponseException;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.AbstractHttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.util.EntityUtils;

public class GoogleStorageWriteFeature
extends AbstractHttpWriteFeature<VersionId>
implements Write<VersionId> {
    private final PathContainerService containerService = new GoogleStoragePathContainerService();
    private final GoogleStorageSession session;
    private final Find finder;
    private final AttributesFinder attributes;

    public GoogleStorageWriteFeature(GoogleStorageSession session) {
        this(session, (Find)new DefaultFindFeature((Session)session), (AttributesFinder)new DefaultAttributesFinderFeature((Session)session));
    }

    public GoogleStorageWriteFeature(GoogleStorageSession session, Find finder, AttributesFinder attributes) {
        super(finder, attributes);
        this.session = session;
        this.finder = finder;
        this.attributes = attributes;
    }

    public HttpResponseOutputStream<VersionId> write(final Path file, final TransferStatus status, ConnectionCallback callback) throws BackgroundException {
        DelayedHttpEntityCallable<VersionId> command = new DelayedHttpEntityCallable<VersionId>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Unable to fully structure code
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public VersionId call(AbstractHttpEntity entity) throws BackgroundException {
                try {
                    request = new HttpPost(String.format("%supload/storage/v1/b/%s/o?uploadType=resumable", new Object[]{((Storage)GoogleStorageWriteFeature.access$000(GoogleStorageWriteFeature.this).getClient()).getRootUrl(), GoogleStorageWriteFeature.access$100(GoogleStorageWriteFeature.this).getContainer(file).getName()}));
                    metadata = new StringBuilder();
                    metadata.append(String.format("{\"name\": \"%s\"", new Object[]{GoogleStorageWriteFeature.access$100(GoogleStorageWriteFeature.this).getKey(file)}));
                    metadata.append(",\"metadata\": {");
                    for (Map.Entry<K, V> item : status.getMetadata().entrySet()) {
                        metadata.append(String.format("\"%s\": \"%s\"", new Object[]{item.getKey(), item.getValue()}));
                    }
                    metadata.append("}");
                    if (StringUtils.isNotBlank((CharSequence)status.getMime())) {
                        metadata.append(String.format(", \"contentType\": \"%s\"", new Object[]{status.getMime()}));
                    }
                    if (StringUtils.isNotBlank((CharSequence)status.getStorageClass())) {
                        metadata.append(String.format(", \"storageClass\": \"%s\"", new Object[]{status.getStorageClass()}));
                    }
                    metadata.append("}");
                    request.setEntity((HttpEntity)new StringEntity(metadata.toString(), ContentType.create((String)"application/json", (String)StandardCharsets.UTF_8.name())));
                    if (StringUtils.isNotBlank((CharSequence)status.getMime())) {
                        request.addHeader("X-Upload-Content-Type", status.getMime());
                    }
                    request.addHeader("Content-Type", "application/json; charset=UTF-8");
                    client = GoogleStorageWriteFeature.access$000(GoogleStorageWriteFeature.this).getHttpClient();
                    response = client.execute((HttpUriRequest)request);
                    try {
                        switch (response.getStatusLine().getStatusCode()) {
                            case 200: {
                                ** break;
lbl32:
                                // 1 sources

                                break;
                            }
                            default: {
                                throw new DefaultHttpResponseExceptionMappingService().map(new HttpResponseException(response.getStatusLine().getStatusCode(), response.getStatusLine().getReasonPhrase()));
                            }
                        }
                    }
                    finally {
                        EntityUtils.consume((HttpEntity)response.getEntity());
                    }
                    if (response.containsHeader("Location") == false) throw new DefaultHttpResponseExceptionMappingService().map(new HttpResponseException(response.getStatusLine().getStatusCode(), response.getStatusLine().getReasonPhrase()));
                    putTarget = response.getFirstHeader("Location").getValue();
                    put = new HttpPut(putTarget);
                    put.setEntity((HttpEntity)entity);
                    putResponse = client.execute((HttpUriRequest)put);
                    try {
                        switch (putResponse.getStatusLine().getStatusCode()) {
                            case 200: 
                            case 201: {
                                reader = new JsonReader((Reader)new InputStreamReader(putResponse.getEntity().getContent(), StandardCharsets.UTF_8));
                                try {
                                    reader.beginObject();
                                    while (reader.hasNext()) {
                                        name = reader.nextName();
                                        value = reader.nextString();
                                        var12_16 = name;
                                        var13_17 = -1;
                                        switch (var12_16.hashCode()) {
                                            case 305703192: {
                                                if (!var12_16.equals("generation")) break;
                                                var13_17 = 0;
                                                break;
                                            }
                                        }
                                        switch (var13_17) {
                                            case 0: {
                                                version = new VersionId(value);
                                                status.setVersion(version);
                                                var15_19 = version;
                                                return var15_19;
                                            }
                                        }
                                    }
                                    reader.endObject();
                                    return new VersionId(null);
                                }
                                finally {
                                    reader.close();
                                }
                            }
                        }
                        throw new DefaultHttpResponseExceptionMappingService().map(new HttpResponseException(response.getStatusLine().getStatusCode(), response.getStatusLine().getReasonPhrase()));
                    }
                    finally {
                        EntityUtils.consume((HttpEntity)putResponse.getEntity());
                    }
                }
                catch (IOException e) {
                    throw new GoogleStorageExceptionMappingService().map("Upload failed", e, file);
                }
            }

            public long getContentLength() {
                return status.getLength();
            }
        };
        return this.write(file, status, (DelayedHttpEntityCallable)command);
    }

    public Write.Append append(Path file, Long length, Cache<Path> cache) throws BackgroundException {
        if (this.finder.withCache(cache).find(file)) {
            PathAttributes attr = this.attributes.withCache(cache).find(file);
            return new Write.Append(false, true).withSize(Long.valueOf(attr.getSize())).withChecksum(attr.getChecksum());
        }
        return Write.notfound;
    }

    public boolean temporary() {
        return false;
    }

    public boolean random() {
        return false;
    }

    public ChecksumCompute checksum(Path file, TransferStatus status) {
        return ChecksumComputeFactory.get((HashAlgorithm)HashAlgorithm.sha256);
    }

    static /* synthetic */ GoogleStorageSession access$000(GoogleStorageWriteFeature x0) {
        return x0.session;
    }

    static /* synthetic */ PathContainerService access$100(GoogleStorageWriteFeature x0) {
        return x0.containerService;
    }
}

