/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.onedrive.features;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.PasswordCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Copy;
import ch.cyberduck.core.features.Delete;
import ch.cyberduck.core.onedrive.GraphExceptionMappingService;
import ch.cyberduck.core.onedrive.GraphSession;
import ch.cyberduck.core.onedrive.features.GraphAttributesFinderFeature;
import ch.cyberduck.core.onedrive.features.GraphDeleteFeature;
import ch.cyberduck.core.transfer.TransferStatus;
import java.io.IOException;
import java.util.Collections;
import org.apache.commons.codec.binary.StringUtils;
import org.apache.log4j.Logger;
import org.nuxeo.onedrive.client.CopyOperation;
import org.nuxeo.onedrive.client.Files;
import org.nuxeo.onedrive.client.OneDriveAPIException;
import org.nuxeo.onedrive.client.types.DriveItem;

public class GraphCopyFeature
implements Copy {
    private static final Logger logger = Logger.getLogger(GraphCopyFeature.class);
    private final GraphSession session;

    public GraphCopyFeature(GraphSession session) {
        this.session = session;
    }

    public Path copy(Path source, Path target, TransferStatus status, ConnectionCallback callback) throws BackgroundException {
        CopyOperation copyOperation = new CopyOperation();
        if (!StringUtils.equals((CharSequence)source.getName(), (CharSequence)target.getName())) {
            copyOperation.rename(target.getName());
        }
        if (status.isExists()) {
            new GraphDeleteFeature(this.session).delete(Collections.singletonMap(target, status), (PasswordCallback)callback, (Delete.Callback)new Delete.DisabledCallback());
        }
        DriveItem targetItem = this.session.toFolder(target.getParent());
        copyOperation.copy(targetItem);
        DriveItem item = this.session.toItem(source);
        try {
            Files.copy((DriveItem)item, (CopyOperation)copyOperation).await(statusObject -> logger.info((Object)String.format("Copy Progress Operation %s progress %f status %s", statusObject.getOperation(), Float.valueOf(statusObject.getPercentage()), statusObject.getStatus())));
            target.attributes().setVersionId(null);
            target.attributes().setFileId(null);
            return new Path(target.getParent(), target.getName(), target.getType(), new GraphAttributesFinderFeature(this.session).find(target));
        }
        catch (OneDriveAPIException e) {
            throw new GraphExceptionMappingService().map("Cannot copy {0}", e, source);
        }
        catch (IOException e) {
            throw new DefaultIOExceptionMappingService().map("Cannot copy {0}", (Throwable)e, source);
        }
    }

    public boolean isRecursive(Path source, Path target) {
        return true;
    }

    public boolean isSupported(Path source, Path target) {
        if (!this.session.isAccessible(source, false)) {
            return false;
        }
        if (!this.session.getContainer(source).equals(this.session.getContainer(target))) {
            return false;
        }
        return !source.getType().contains(AbstractPath.Type.shared);
    }
}

