/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.onedrive.features;

import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Home;
import ch.cyberduck.core.features.Quota;
import ch.cyberduck.core.onedrive.GraphExceptionMappingService;
import ch.cyberduck.core.onedrive.GraphSession;
import java.io.IOException;
import org.nuxeo.onedrive.client.OneDriveAPIException;
import org.nuxeo.onedrive.client.types.Drive;
import org.nuxeo.onedrive.client.types.DriveItem;
import org.nuxeo.onedrive.client.types.Quota;

public class GraphQuotaFeature
implements ch.cyberduck.core.features.Quota {
    private final GraphSession session;
    private final Home home;

    public GraphQuotaFeature(GraphSession session, Home home) {
        this.session = session;
        this.home = home;
    }

    public Quota.Space get() throws BackgroundException {
        Long used;
        Drive.Metadata metadata;
        Path home = this.home.find();
        if (!this.session.isAccessible(home)) {
            return unknown;
        }
        try {
            DriveItem item = this.session.toItem(home, true);
            metadata = item.getDrive().getMetadata();
        }
        catch (OneDriveAPIException e) {
            throw new GraphExceptionMappingService().map("Failure to read attributes of {0}", e, home);
        }
        catch (IOException e) {
            throw new DefaultIOExceptionMappingService().map("Failure to read attributes of {0}", (Throwable)e, home);
        }
        Quota quota = metadata.getQuota();
        if (quota != null && (used = quota.getUsed()) != null) {
            Long remaining = quota.getRemaining();
            if (remaining != null && (used != 0L || remaining != 0L)) {
                return new Quota.Space(used, remaining);
            }
            Long total = quota.getTotal();
            if (total != null && (used != 0L || total != 0L)) {
                return new Quota.Space(used, Long.valueOf(total - used));
            }
        }
        return unknown;
    }
}

