/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.onedrive.features;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.Cache;
import ch.cyberduck.core.Filter;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.Referenceable;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Search;
import ch.cyberduck.core.onedrive.GraphSession;
import ch.cyberduck.core.onedrive.features.GraphAttributesFinderFeature;
import java.util.EnumSet;
import java.util.Iterator;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.nuxeo.onedrive.client.Files;
import org.nuxeo.onedrive.client.OneDriveRuntimeException;
import org.nuxeo.onedrive.client.types.DriveItem;

public class GraphSearchFeature
implements Search {
    private static final Logger log = Logger.getLogger(GraphSearchFeature.class);
    private final GraphSession session;
    private final GraphAttributesFinderFeature attributes;

    public GraphSearchFeature(GraphSession session) {
        this.session = session;
        this.attributes = new GraphAttributesFinderFeature(session);
    }

    public AttributedList<Path> search(Path workdir, Filter<Path> regex, ListProgressListener listener) throws BackgroundException {
        AttributedList list = new AttributedList();
        DriveItem folder = this.session.toFolder(workdir);
        Iterator iterator = Files.search((DriveItem)folder, (String)regex.toPattern().pattern());
        while (iterator.hasNext()) {
            DriveItem.Metadata metadata;
            try {
                metadata = (DriveItem.Metadata)iterator.next();
            }
            catch (OneDriveRuntimeException e) {
                log.warn((Object)e);
                continue;
            }
            list.add((Referenceable)new Path(String.format("/%s/%s/%s", metadata.getParentReference().getDriveId(), StringUtils.removeStart((String)metadata.getParentReference().getPath(), (String)"/drive/root:"), metadata.getName()), metadata.isFolder() ? EnumSet.of(AbstractPath.Type.directory) : EnumSet.of(AbstractPath.Type.file), this.attributes.toAttributes(metadata)));
        }
        return list;
    }

    public boolean isRecursive() {
        return true;
    }

    public Search withCache(Cache<Path> cache) {
        return this;
    }
}

