/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.onedrive.features;

import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.URIEncoder;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Touch;
import ch.cyberduck.core.features.Write;
import ch.cyberduck.core.onedrive.GraphExceptionMappingService;
import ch.cyberduck.core.onedrive.GraphSession;
import ch.cyberduck.core.onedrive.features.GraphAttributesFinderFeature;
import ch.cyberduck.core.transfer.TransferStatus;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.nuxeo.onedrive.client.Files;
import org.nuxeo.onedrive.client.OneDriveAPIException;
import org.nuxeo.onedrive.client.types.DriveItem;

public class GraphTouchFeature
implements Touch<Void> {
    private final GraphSession session;

    public GraphTouchFeature(GraphSession session) {
        this.session = session;
    }

    public Path touch(Path file, TransferStatus status) throws BackgroundException {
        try {
            DriveItem folder = this.session.toFolder(file.getParent());
            DriveItem.Metadata metadata = Files.createFile((DriveItem)folder, (String)URIEncoder.encode((String)file.getName()), (String)(StringUtils.isNotBlank((CharSequence)status.getMime()) ? status.getMime() : "application/octet-stream"));
            return new Path(file.getParent(), file.getName(), file.getType(), new GraphAttributesFinderFeature(this.session).toAttributes(metadata));
        }
        catch (OneDriveAPIException e) {
            throw new GraphExceptionMappingService().map("Cannot create {0}", e, file);
        }
        catch (IOException e) {
            throw new DefaultIOExceptionMappingService().map("Cannot create {0}", (Throwable)e, file);
        }
    }

    public boolean isSupported(Path workdir, String filename) {
        return this.session.isAccessible(workdir);
    }

    public Touch<Void> withWriter(Write writer) {
        return this;
    }
}

