/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.s3;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.Acl;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.InteroperabilityException;
import ch.cyberduck.core.exception.NotfoundException;
import ch.cyberduck.core.features.AclPermission;
import ch.cyberduck.core.s3.RequestEntityRestStorageService;
import ch.cyberduck.core.s3.S3ExceptionMappingService;
import ch.cyberduck.core.s3.S3PathContainerService;
import ch.cyberduck.core.s3.S3Session;
import ch.cyberduck.core.shared.DefaultAclFeature;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.log4j.Logger;
import org.jets3t.service.ServiceException;
import org.jets3t.service.acl.AccessControlList;
import org.jets3t.service.acl.CanonicalGrantee;
import org.jets3t.service.acl.EmailAddressGrantee;
import org.jets3t.service.acl.GrantAndPermission;
import org.jets3t.service.acl.GranteeInterface;
import org.jets3t.service.acl.GroupGrantee;
import org.jets3t.service.acl.Permission;
import org.jets3t.service.model.S3Owner;
import org.jets3t.service.model.StorageOwner;

public class S3AccessControlListFeature
extends DefaultAclFeature
implements AclPermission {
    private static final Logger log = Logger.getLogger(S3AccessControlListFeature.class);
    private final S3Session session;
    private final PathContainerService containerService = new S3PathContainerService();

    public S3AccessControlListFeature(S3Session session) {
        this.session = session;
    }

    public Acl getPermission(Path file) throws BackgroundException {
        try {
            if (file.getType().contains(AbstractPath.Type.upload)) {
                return Acl.EMPTY;
            }
            if (this.containerService.isContainer(file)) {
                return this.convert(((RequestEntityRestStorageService)((Object)this.session.getClient())).getBucketAcl(this.containerService.getContainer(file).getName()));
            }
            if (file.isFile() || file.isPlaceholder()) {
                return this.convert(((RequestEntityRestStorageService)((Object)this.session.getClient())).getVersionedObjectAcl(file.attributes().getVersionId(), this.containerService.getContainer(file).getName(), this.containerService.getKey(file)));
            }
            return Acl.EMPTY;
        }
        catch (ServiceException e) {
            BackgroundException failure = new S3ExceptionMappingService().map("Failure to read attributes of {0}", e, file);
            if (file.isPlaceholder() && failure instanceof NotfoundException) {
                return Acl.EMPTY;
            }
            if (failure instanceof InteroperabilityException) {
                return Acl.EMPTY;
            }
            throw failure;
        }
    }

    public void setPermission(Path file, Acl acl) throws BackgroundException {
        try {
            Path container = this.containerService.getContainer(file);
            if (null == acl.getOwner()) {
                acl.setOwner(file.attributes().getAcl().getOwner());
            }
            if (null == acl.getOwner()) {
                Acl permission = this.getPermission(container);
                acl.setOwner(permission.getOwner());
            }
            if (this.containerService.isContainer(file)) {
                ((RequestEntityRestStorageService)((Object)this.session.getClient())).putBucketAcl(container.getName(), this.convert(acl));
            } else if (file.isFile() || file.isPlaceholder()) {
                ((RequestEntityRestStorageService)((Object)this.session.getClient())).putObjectAcl(container.getName(), this.containerService.getKey(file), this.convert(acl));
            }
        }
        catch (ServiceException e) {
            BackgroundException failure = new S3ExceptionMappingService().map("Cannot change permissions of {0}", e, file);
            if (file.isPlaceholder() && failure instanceof NotfoundException) {
                return;
            }
            throw failure;
        }
    }

    protected AccessControlList convert(Acl acl) {
        if (Acl.EMPTY.equals((Object)acl)) {
            return null;
        }
        AccessControlList list = new AccessControlList();
        Acl.CanonicalUser owner = acl.getOwner();
        if (null != owner) {
            list.setOwner((StorageOwner)new S3Owner(owner.getIdentifier(), owner.getDisplayName()));
            list.grantPermission((GranteeInterface)new CanonicalGrantee(owner.getIdentifier()), Permission.PERMISSION_FULL_CONTROL);
        }
        for (Acl.UserAndRole userAndRole : acl.asList()) {
            if (!userAndRole.isValid()) continue;
            if (userAndRole.getUser() instanceof Acl.EmailUser) {
                list.grantPermission((GranteeInterface)new EmailAddressGrantee(userAndRole.getUser().getIdentifier()), Permission.parsePermission((String)userAndRole.getRole().getName()));
                continue;
            }
            if (userAndRole.getUser() instanceof Acl.GroupUser) {
                if (userAndRole.getUser().getIdentifier().equals(GroupGrantee.ALL_USERS.getIdentifier()) || userAndRole.getUser().getIdentifier().equals("AllUsers")) {
                    list.grantPermission((GranteeInterface)GroupGrantee.ALL_USERS, Permission.parsePermission((String)userAndRole.getRole().getName()));
                    continue;
                }
                if (userAndRole.getUser().getIdentifier().equals("AllAuthenticatedUsers")) {
                    list.grantPermission((GranteeInterface)GroupGrantee.AUTHENTICATED_USERS, Permission.parsePermission((String)userAndRole.getRole().getName()));
                    continue;
                }
                list.grantPermission((GranteeInterface)new GroupGrantee(userAndRole.getUser().getIdentifier()), Permission.parsePermission((String)userAndRole.getRole().getName()));
                continue;
            }
            if (userAndRole.getUser() instanceof Acl.CanonicalUser) {
                list.grantPermission((GranteeInterface)new CanonicalGrantee(userAndRole.getUser().getIdentifier()), Permission.parsePermission((String)userAndRole.getRole().getName()));
                continue;
            }
            log.warn((Object)String.format("Unsupported user %s", userAndRole.getUser()));
        }
        if (log.isDebugEnabled()) {
            try {
                log.debug((Object)list.toXml());
            }
            catch (ServiceException e) {
                log.error((Object)e.getMessage());
            }
        }
        return list;
    }

    protected Acl convert(AccessControlList list) {
        if (log.isDebugEnabled()) {
            try {
                log.debug((Object)list.toXml());
            }
            catch (ServiceException e) {
                log.error((Object)e.getMessage());
            }
        }
        Acl acl = new Acl();
        acl.setOwner(new Acl.CanonicalUser(list.getOwner().getId(), list.getOwner().getDisplayName()));
        for (GrantAndPermission grant : list.getGrantAndPermissions()) {
            Acl.Role role = new Acl.Role(grant.getPermission().toString());
            if (grant.getGrantee() instanceof CanonicalGrantee) {
                acl.addAll((Acl.User)new Acl.CanonicalUser(grant.getGrantee().getIdentifier(), ((CanonicalGrantee)grant.getGrantee()).getDisplayName(), false), new Acl.Role[]{role});
                continue;
            }
            if (grant.getGrantee() instanceof EmailAddressGrantee) {
                acl.addAll((Acl.User)new Acl.EmailUser(grant.getGrantee().getIdentifier()), new Acl.Role[]{role});
                continue;
            }
            if (!(grant.getGrantee() instanceof GroupGrantee)) continue;
            acl.addAll((Acl.User)new Acl.GroupUser(grant.getGrantee().getIdentifier()), new Acl.Role[]{role});
        }
        return acl;
    }

    public List<Acl.Role> getAvailableAclRoles(List<Path> files) {
        return Arrays.asList(new Acl.Role(Permission.PERMISSION_FULL_CONTROL.toString()), new Acl.Role(Permission.PERMISSION_READ.toString()), new Acl.Role(Permission.PERMISSION_WRITE.toString()), new Acl.Role(Permission.PERMISSION_READ_ACP.toString()), new Acl.Role(Permission.PERMISSION_WRITE_ACP.toString()));
    }

    public List<Acl.User> getAvailableAclUsers() {
        return new ArrayList<Acl.User>(Arrays.asList(new Acl.CanonicalUser(), new Acl.GroupUser("AllUsers", false), new Acl.EmailUser(){

            public String getPlaceholder() {
                return LocaleFactory.localizedString((String)"Amazon Customer Email Address", (String)"S3");
            }
        }));
    }
}

