/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.s3;

import ch.cyberduck.core.Cache;
import ch.cyberduck.core.DisabledListProgressListener;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.exception.AccessDeniedException;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.NotfoundException;
import ch.cyberduck.core.features.Find;
import ch.cyberduck.core.s3.RequestEntityRestStorageService;
import ch.cyberduck.core.s3.S3AttributesFinderFeature;
import ch.cyberduck.core.s3.S3ExceptionMappingService;
import ch.cyberduck.core.s3.S3ObjectListService;
import ch.cyberduck.core.s3.S3PathContainerService;
import ch.cyberduck.core.s3.S3Session;
import org.jets3t.service.ServiceException;

public class S3FindFeature
implements Find {
    private final PathContainerService containerService = new S3PathContainerService();
    private final S3Session session;
    private final S3AttributesFinderFeature attributes;

    public S3FindFeature(S3Session session) {
        this.session = session;
        this.attributes = new S3AttributesFinderFeature(session);
    }

    /*
     * Loose catch block
     */
    public boolean find(Path file) throws BackgroundException {
        if (file.isRoot()) {
            return true;
        }
        try {
            block11: {
                if (this.containerService.isContainer(file)) {
                    try {
                        return ((RequestEntityRestStorageService)((Object)this.session.getClient())).isBucketAccessible(this.containerService.getContainer(file).getName());
                    }
                    catch (ServiceException e) {
                        throw new S3ExceptionMappingService().map("Failure to read attributes of {0}", e, file);
                    }
                }
                if (!file.isFile() && !file.isPlaceholder()) break block11;
                this.attributes.find(file);
                return true;
                {
                    catch (NotfoundException e) {
                        return false;
                    }
                }
            }
            new S3ObjectListService(this.session).list(file, (ListProgressListener)new DisabledListProgressListener(), this.containerService.getKey(file), 1);
            return true;
        }
        catch (AccessDeniedException e) {
            return true;
        }
    }

    public Find withCache(Cache<Path> cache) {
        this.attributes.withCache(cache);
        return this;
    }
}

