/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.cli;

import ch.cyberduck.cli.DownloadGlobFilter;
import ch.cyberduck.cli.TerminalAction;
import ch.cyberduck.cli.TerminalActionFinder;
import ch.cyberduck.cli.TerminalOptionsBuilder;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.transfer.DownloadTransfer;
import ch.cyberduck.core.transfer.SyncTransfer;
import ch.cyberduck.core.transfer.Transfer;
import ch.cyberduck.core.transfer.TransferItem;
import ch.cyberduck.core.transfer.UploadTransfer;
import ch.cyberduck.core.transfer.download.DownloadFilterOptions;
import ch.cyberduck.core.transfer.upload.UploadFilterOptions;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.lang3.StringUtils;

public final class TerminalTransferFactory {
    public Transfer create(CommandLine input, Host host, Path remote, List<TransferItem> items) throws BackgroundException {
        Transfer transfer;
        TerminalAction type = TerminalActionFinder.get(input);
        if (null == type) {
            throw new BackgroundException(LocaleFactory.localizedString("Unknown"), "Unknown transfer type");
        }
        switch (type) {
            case download: {
                transfer = StringUtils.containsAny((CharSequence)remote.getName(), (char[])new char[]{'*'}) ? new DownloadTransfer(host, items, new DownloadGlobFilter(remote.getName())) : new DownloadTransfer(host, items);
                if (!input.hasOption(TerminalOptionsBuilder.Params.nochecksum.name())) break;
                DownloadFilterOptions options = new DownloadFilterOptions();
                options.checksum = Boolean.parseBoolean(input.getOptionValue(TerminalOptionsBuilder.Params.nochecksum.name()));
                ((DownloadTransfer)transfer).withOptions(options);
                break;
            }
            case upload: {
                transfer = new UploadTransfer(host, items);
                if (!input.hasOption(TerminalOptionsBuilder.Params.nochecksum.name())) break;
                UploadFilterOptions options = new UploadFilterOptions();
                options.checksum = Boolean.parseBoolean(input.getOptionValue(TerminalOptionsBuilder.Params.nochecksum.name()));
                ((UploadTransfer)transfer).withOptions(options);
                break;
            }
            case synchronize: {
                transfer = new SyncTransfer(host, items.iterator().next());
                break;
            }
            default: {
                throw new BackgroundException(LocaleFactory.localizedString("Unknown"), String.format("Unknown transfer type %s", type.name()));
            }
        }
        if (input.hasOption(TerminalOptionsBuilder.Params.throttle.name())) {
            try {
                transfer.setBandwidth(Float.parseFloat(input.getOptionValue(TerminalOptionsBuilder.Params.throttle.name())));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return transfer;
    }
}

