/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.teamcommon;

import com.dropbox.core.stone.StoneDeserializerLogger;
import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.StructSerializer;
import com.dropbox.core.util.LangUtil;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;
import java.util.Date;

public class TimeRange {
    protected final Date startTime;
    protected final Date endTime;

    public TimeRange(Date startTime, Date endTime) {
        this.startTime = LangUtil.truncateMillis(startTime);
        this.endTime = LangUtil.truncateMillis(endTime);
    }

    public TimeRange() {
        this(null, null);
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.startTime, this.endTime});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass().equals(this.getClass())) {
            TimeRange other = (TimeRange)obj;
            return (this.startTime == other.startTime || this.startTime != null && this.startTime.equals(other.startTime)) && (this.endTime == other.endTime || this.endTime != null && this.endTime.equals(other.endTime));
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    public static class Serializer
    extends StructSerializer<TimeRange> {
        public static final Serializer INSTANCE = new Serializer();

        @Override
        public void serialize(TimeRange value, JsonGenerator g, boolean collapse) throws IOException, JsonGenerationException {
            if (!collapse) {
                g.writeStartObject();
            }
            if (value.startTime != null) {
                g.writeFieldName("start_time");
                StoneSerializers.nullable(StoneSerializers.timestamp()).serialize(value.startTime, g);
            }
            if (value.endTime != null) {
                g.writeFieldName("end_time");
                StoneSerializers.nullable(StoneSerializers.timestamp()).serialize(value.endTime, g);
            }
            if (!collapse) {
                g.writeEndObject();
            }
        }

        @Override
        public TimeRange deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            Date f_endTime;
            Date f_startTime;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                f_startTime = null;
                f_endTime = null;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("start_time".equals(field)) {
                        f_startTime = StoneSerializers.nullable(StoneSerializers.timestamp()).deserialize(p);
                        continue;
                    }
                    if ("end_time".equals(field)) {
                        f_endTime = StoneSerializers.nullable(StoneSerializers.timestamp()).deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            TimeRange value = new TimeRange(f_startTime, f_endTime);
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            StoneDeserializerLogger.log(value, value.toStringMultiline());
            return value;
        }
    }

    public static class Builder {
        protected Date startTime = null;
        protected Date endTime = null;

        protected Builder() {
        }

        public Builder withStartTime(Date startTime) {
            this.startTime = LangUtil.truncateMillis(startTime);
            return this;
        }

        public Builder withEndTime(Date endTime) {
            this.endTime = LangUtil.truncateMillis(endTime);
            return this;
        }

        public TimeRange build() {
            return new TimeRange(this.startTime, this.endTime);
        }
    }
}

