/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.commands.parsers;

import com.spectralogic.ds3client.commands.parsers.interfaces.AbstractResponseParser;
import com.spectralogic.ds3client.commands.parsers.utils.ResponseParserUtils;
import com.spectralogic.ds3client.commands.spectrads3.PutAzureTargetReadPreferenceSpectraS3Response;
import com.spectralogic.ds3client.models.AzureTargetReadPreference;
import com.spectralogic.ds3client.networking.WebResponse;
import com.spectralogic.ds3client.serializer.XmlOutput;
import java.io.IOException;
import java.io.InputStream;

public class PutAzureTargetReadPreferenceSpectraS3ResponseParser
extends AbstractResponseParser<PutAzureTargetReadPreferenceSpectraS3Response> {
    private final int[] expectedStatusCodes = new int[]{201};

    @Override
    public PutAzureTargetReadPreferenceSpectraS3Response parseXmlResponse(WebResponse response) throws IOException {
        int statusCode = response.getStatusCode();
        if (ResponseParserUtils.validateStatusCode(statusCode, this.expectedStatusCodes)) {
            switch (statusCode) {
                case 201: {
                    try (InputStream inputStream = response.getResponseStream();){
                        AzureTargetReadPreference result = XmlOutput.fromXml(inputStream, AzureTargetReadPreference.class);
                        PutAzureTargetReadPreferenceSpectraS3Response putAzureTargetReadPreferenceSpectraS3Response = new PutAzureTargetReadPreferenceSpectraS3Response(result, this.getChecksum(), this.getChecksumType());
                        return putAzureTargetReadPreferenceSpectraS3Response;
                    }
                }
            }
            assert (false) : "validateStatusCode should have made it impossible to reach this line";
        }
        throw ResponseParserUtils.createFailedRequest(response, this.expectedStatusCodes);
    }
}

