/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.commands.parsers;

import com.spectralogic.ds3client.commands.parsers.interfaces.AbstractResponseParser;
import com.spectralogic.ds3client.commands.parsers.utils.ResponseParserUtils;
import com.spectralogic.ds3client.commands.spectrads3.PutBucketAclForGroupSpectraS3Response;
import com.spectralogic.ds3client.models.BucketAcl;
import com.spectralogic.ds3client.networking.WebResponse;
import com.spectralogic.ds3client.serializer.XmlOutput;
import java.io.IOException;
import java.io.InputStream;

public class PutBucketAclForGroupSpectraS3ResponseParser
extends AbstractResponseParser<PutBucketAclForGroupSpectraS3Response> {
    private final int[] expectedStatusCodes = new int[]{201};

    @Override
    public PutBucketAclForGroupSpectraS3Response parseXmlResponse(WebResponse response) throws IOException {
        int statusCode = response.getStatusCode();
        if (ResponseParserUtils.validateStatusCode(statusCode, this.expectedStatusCodes)) {
            switch (statusCode) {
                case 201: {
                    try (InputStream inputStream = response.getResponseStream();){
                        BucketAcl result = XmlOutput.fromXml(inputStream, BucketAcl.class);
                        PutBucketAclForGroupSpectraS3Response putBucketAclForGroupSpectraS3Response = new PutBucketAclForGroupSpectraS3Response(result, this.getChecksum(), this.getChecksumType());
                        return putBucketAclForGroupSpectraS3Response;
                    }
                }
            }
            assert (false) : "validateStatusCode should have made it impossible to reach this line";
        }
        throw ResponseParserUtils.createFailedRequest(response, this.expectedStatusCodes);
    }
}

