/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.commands.parsers;

import com.spectralogic.ds3client.commands.parsers.interfaces.AbstractResponseParser;
import com.spectralogic.ds3client.commands.parsers.utils.ResponseParserUtils;
import com.spectralogic.ds3client.commands.spectrads3.PutDataPersistenceRuleSpectraS3Response;
import com.spectralogic.ds3client.models.DataPersistenceRule;
import com.spectralogic.ds3client.networking.WebResponse;
import com.spectralogic.ds3client.serializer.XmlOutput;
import java.io.IOException;
import java.io.InputStream;

public class PutDataPersistenceRuleSpectraS3ResponseParser
extends AbstractResponseParser<PutDataPersistenceRuleSpectraS3Response> {
    private final int[] expectedStatusCodes = new int[]{201};

    @Override
    public PutDataPersistenceRuleSpectraS3Response parseXmlResponse(WebResponse response) throws IOException {
        int statusCode = response.getStatusCode();
        if (ResponseParserUtils.validateStatusCode(statusCode, this.expectedStatusCodes)) {
            switch (statusCode) {
                case 201: {
                    try (InputStream inputStream = response.getResponseStream();){
                        DataPersistenceRule result = XmlOutput.fromXml(inputStream, DataPersistenceRule.class);
                        PutDataPersistenceRuleSpectraS3Response putDataPersistenceRuleSpectraS3Response = new PutDataPersistenceRuleSpectraS3Response(result, this.getChecksum(), this.getChecksumType());
                        return putDataPersistenceRuleSpectraS3Response;
                    }
                }
            }
            assert (false) : "validateStatusCode should have made it impossible to reach this line";
        }
        throw ResponseParserUtils.createFailedRequest(response, this.expectedStatusCodes);
    }
}

