/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.helpers;

import com.google.common.util.concurrent.Striped;
import com.spectralogic.ds3client.helpers.Ds3ClientHelpers;
import com.spectralogic.ds3client.helpers.UnrecoverableIOException;
import com.spectralogic.ds3client.utils.FileUtils;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.locks.Lock;

public class FileObjectGetter
implements Ds3ClientHelpers.ObjectChannelBuilder {
    private final Path root;
    private final Striped<Lock> striped;

    public FileObjectGetter(Path root) {
        this.root = root;
        this.striped = Striped.lazyWeakLock((int)10);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SeekableByteChannel buildChannel(String key) throws IOException {
        Path objectPath = this.root.resolve(key);
        Path parentPath = objectPath.getParent();
        if (parentPath != null) {
            Files.createDirectories(FileUtils.resolveForSymbolic((Path)parentPath), new FileAttribute[0]);
        }
        if (!FileUtils.isTransferablePath((Path)objectPath)) {
            throw new UnrecoverableIOException(objectPath + " is not a regular file.");
        }
        Lock lock = (Lock)this.striped.get((Object)key);
        try {
            lock.lock();
            if (Files.notExists(objectPath, new LinkOption[0])) {
                Files.createDirectories(objectPath.getParent(), new FileAttribute[0]);
                FileChannel fileChannel = FileChannel.open(objectPath, StandardOpenOption.SPARSE, StandardOpenOption.WRITE, StandardOpenOption.CREATE_NEW);
                return fileChannel;
            }
        }
        finally {
            lock.unlock();
        }
        return FileChannel.open(objectPath, StandardOpenOption.WRITE);
    }
}

