/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.helpers.strategy.channelstrategy;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;

class SeekableByteChannelDecorator
implements SeekableByteChannel {
    private final Object lock = new Object();
    private final SeekableByteChannel seekableByteChannel;
    private final long blobOffset;
    private final long blobLength;
    private long nextAvailableByteOffset = 0L;

    SeekableByteChannelDecorator(SeekableByteChannel seekableByteChannel, long blobOffset, long blobLength) throws IOException {
        Preconditions.checkNotNull((Object)seekableByteChannel, (Object)"seekableByteChannel may not be null.");
        Preconditions.checkArgument((blobOffset >= 0L ? 1 : 0) != 0, (Object)"blobOffset must be >= 0.");
        Preconditions.checkArgument((blobLength >= 0L ? 1 : 0) != 0, (Object)"blobLength must be >= 0.");
        this.seekableByteChannel = seekableByteChannel;
        this.blobOffset = blobOffset;
        this.blobLength = blobLength;
        seekableByteChannel.position(blobOffset);
    }

    public SeekableByteChannel wrappedSeekableByteChannel() {
        return this.seekableByteChannel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(ByteBuffer dst) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            int numBytesRead;
            long remainingInWindow = this.blobLength - this.nextAvailableByteOffset;
            long numBytesWeCanRead = Math.min((long)dst.remaining(), remainingInWindow);
            if (numBytesWeCanRead <= 0L) {
                return 0;
            }
            if (numBytesWeCanRead != (long)dst.remaining()) {
                ByteBuffer byteBuffer = ByteBuffer.wrap(new byte[(int)numBytesWeCanRead]);
                numBytesRead = this.seekableByteChannel.read(byteBuffer);
                byteBuffer.flip();
                dst.put(byteBuffer);
            } else {
                numBytesRead = this.seekableByteChannel.read(dst);
            }
            this.nextAvailableByteOffset += (long)numBytesRead;
            return numBytesRead;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int write(ByteBuffer src) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            int numBytesWritten;
            long remainingInWindow = this.blobLength - this.nextAvailableByteOffset;
            long numBytesWeCanWrite = Math.min((long)src.remaining(), remainingInWindow);
            if (numBytesWeCanWrite <= 0L) {
                return 0;
            }
            if (numBytesWeCanWrite != (long)src.remaining()) {
                ByteBuffer byteBuffer = ByteBuffer.wrap(new byte[(int)numBytesWeCanWrite]);
                byteBuffer.put(src);
                byteBuffer.flip();
                numBytesWritten = this.seekableByteChannel.write(byteBuffer);
            } else {
                numBytesWritten = this.seekableByteChannel.write(src);
            }
            this.nextAvailableByteOffset += (long)numBytesWritten;
            return numBytesWritten;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long position() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            return this.seekableByteChannel.position();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SeekableByteChannel position(long newPosition) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            long greatestPossiblePosition = this.blobLength - 1L;
            this.nextAvailableByteOffset = Math.min(newPosition, greatestPossiblePosition);
            this.seekableByteChannel.position(this.blobOffset + this.nextAvailableByteOffset);
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long size() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            return this.seekableByteChannel.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SeekableByteChannel truncate(long size) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            return this.seekableByteChannel.truncate(size);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isOpen() {
        Object object = this.lock;
        synchronized (object) {
            return this.seekableByteChannel.isOpen();
        }
    }

    @Override
    public void close() throws IOException {
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SeekableByteChannelDecorator)) {
            return false;
        }
        SeekableByteChannelDecorator that = (SeekableByteChannelDecorator)o;
        return this.seekableByteChannel.equals(that.seekableByteChannel);
    }

    public int hashCode() {
        return this.seekableByteChannel.hashCode();
    }
}

