/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.binding.application;

import ch.cyberduck.binding.application.NSButton;
import ch.cyberduck.binding.application.NSImage;
import ch.cyberduck.binding.application.NSView;
import ch.cyberduck.binding.application.NSWindow;
import ch.cyberduck.binding.foundation.NSArray;
import ch.cyberduck.binding.foundation.NSObject;
import ch.cyberduck.core.StringAppender;
import org.apache.commons.lang3.StringUtils;
import org.rococoa.ID;
import org.rococoa.ObjCClass;
import org.rococoa.Rococoa;
import org.rococoa.Selector;
import org.rococoa.cocoa.foundation.NSError;

public abstract class NSAlert
extends NSObject {
    private static final _Class CLASS = (_Class)Rococoa.createClass((String)"NSAlert", _Class.class);
    public static final int NSAlertFirstButtonReturn = 1000;
    public static final int NSAlertSecondButtonReturn = 1001;
    public static final int NSAlertThirdButtonReturn = 1002;
    public static final int NSAlertDefaultReturn = 1;
    public static final int NSAlertAlternateReturn = 0;
    public static final int NSAlertOtherReturn = -1;
    public static final int NSAlertErrorReturn = -2;
    public static final int NSWarningAlertStyle = 0;
    public static final int NSInformationalAlertStyle = 1;
    public static final int NSCriticalAlertStyle = 2;

    public static NSAlert alert() {
        return CLASS.alloc().init();
    }

    public static NSAlert alertWithError(NSError error) {
        return CLASS.alertWithError(error);
    }

    public static NSAlert alert(String title, String message, String defaultButton, String alternateButton, String otherButton) {
        NSAlert alert = NSAlert.alert();
        alert.setMessageText(title);
        alert.setInformativeText(new StringAppender().append(message).toString());
        if (StringUtils.isNotBlank((CharSequence)defaultButton)) {
            alert.addButtonWithTitle(defaultButton);
        }
        if (StringUtils.isNotBlank((CharSequence)otherButton)) {
            alert.addButtonWithTitle(otherButton);
        }
        if (StringUtils.isNotBlank((CharSequence)alternateButton)) {
            alert.addButtonWithTitle(alternateButton);
        }
        return alert;
    }

    public abstract NSAlert init();

    public abstract void setMessageText(String var1);

    public abstract void setInformativeText(String var1);

    public abstract String messageText();

    public abstract String informativeText();

    public abstract void setIcon(NSImage var1);

    public abstract NSImage icon();

    public abstract NSButton addButtonWithTitle(String var1);

    public abstract NSArray buttons();

    public abstract void setShowsHelp(boolean var1);

    public abstract boolean showsHelp();

    public abstract void setHelpAnchor(String var1);

    public abstract String helpAnchor();

    public abstract void setAlertStyle(int var1);

    public abstract int alertStyle();

    public abstract void setDelegate(ID var1);

    public abstract ID delegate();

    public abstract void setShowsSuppressionButton(boolean var1);

    public abstract boolean showsSuppressionButton();

    public abstract NSButton suppressionButton();

    public abstract void setAccessoryView(NSView var1);

    public abstract NSView accessoryView();

    public abstract void layout();

    public abstract int runModal();

    public abstract void beginSheetModalForWindow_modalDelegate_didEndSelector_contextInfo(NSWindow var1, ID var2, Selector var3, ID var4);

    public void beginSheet(NSWindow window, ID delegate, Selector didEndSelector, ID contextInfo) {
        this.beginSheetModalForWindow_modalDelegate_didEndSelector_contextInfo(window, delegate, didEndSelector, contextInfo);
    }

    public abstract NSWindow window();

    public static interface _Class
    extends ObjCClass {
        public NSAlert alloc();

        public NSAlert alertWithError(NSError var1);

        public NSAlert alertWithMessageText_defaultButton_alternateButton_otherButton_informativeTextWithFormat(String var1, String var2, String var3, String var4, String var5);
    }
}

