/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.cryptomator.features;

import ch.cyberduck.core.Local;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Headers;
import ch.cyberduck.core.features.Vault;
import ch.cyberduck.core.transfer.TransferStatus;
import java.util.Map;

public class CryptoHeadersFeature
implements Headers {
    private final Session<?> session;
    private final Headers delegate;
    private final Vault vault;

    public CryptoHeadersFeature(Session<?> session, Headers delegate, Vault vault) {
        this.session = session;
        this.delegate = delegate;
        this.vault = vault;
    }

    public Map<String, String> getDefault(Local local) {
        return this.delegate.getDefault(local);
    }

    public Map<String, String> getMetadata(Path file) throws BackgroundException {
        return this.delegate.getMetadata(this.vault.encrypt(this.session, file));
    }

    public void setMetadata(Path file, TransferStatus status) throws BackgroundException {
        this.delegate.setMetadata(this.vault.encrypt(this.session, file), status);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("CryptoHeadersFeature{");
        sb.append("delegate=").append(this.delegate);
        sb.append('}');
        return sb.toString();
    }
}

