/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.openstack.swift.exception;

import ch.iterate.openstack.swift.Response;
import org.apache.http.Header;
import org.apache.http.StatusLine;
import org.apache.http.client.ClientProtocolException;

public class GenericException
extends ClientProtocolException {
    private static final long serialVersionUID = -3302541176431848365L;
    private Header[] httpHeaders;
    private StatusLine httpStatusLine;

    public GenericException(String message, Header[] httpHeaders, StatusLine httpStatusLine) {
        super(message);
        this.httpHeaders = httpHeaders;
        this.httpStatusLine = httpStatusLine;
    }

    public GenericException(String message, Throwable cause) {
        super(message, cause);
    }

    public GenericException(Response response) {
        this(response.getStatusLine().getReasonPhrase(), response.getResponseHeaders(), response.getStatusLine());
    }

    public Header[] getHttpHeaders() {
        return this.httpHeaders;
    }

    public String getHttpHeadersAsString() {
        StringBuilder httpHeaderString = new StringBuilder();
        for (Header h : this.httpHeaders) {
            httpHeaderString.append(h.getName()).append(": ").append(h.getValue()).append("\n");
        }
        return httpHeaderString.toString();
    }

    public StatusLine getHttpStatusLine() {
        return this.httpStatusLine;
    }

    public int getHttpStatusCode() {
        return this.httpStatusLine.getStatusCode();
    }

    public String getHttpStatusMessage() {
        return this.httpStatusLine.getReasonPhrase();
    }

    public String getHttpVersion() {
        return this.httpStatusLine.getProtocolVersion().toString();
    }
}

