/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.dropbox;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.dropbox.DropboxExceptionMappingService;
import ch.cyberduck.core.dropbox.DropboxPathContainerService;
import ch.cyberduck.core.dropbox.DropboxSession;
import ch.cyberduck.core.exception.AccessDeniedException;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.InteroperabilityException;
import ch.cyberduck.core.exception.LockedException;
import ch.cyberduck.core.exception.NotfoundException;
import ch.cyberduck.core.exception.UnsupportedException;
import ch.cyberduck.core.features.Lock;
import com.dropbox.core.DbxException;
import com.dropbox.core.v2.DbxRawClientV2;
import com.dropbox.core.v2.files.DbxUserFilesRequests;
import com.dropbox.core.v2.files.LockFileArg;
import com.dropbox.core.v2.files.LockFileResultEntry;
import com.dropbox.core.v2.files.UnlockFileArg;
import java.util.Collections;
import org.apache.log4j.Logger;

public class DropboxLockFeature
implements Lock<String> {
    private static final Logger log = Logger.getLogger(DropboxSession.class);
    private final DropboxSession session;
    private final PathContainerService containerService = new DropboxPathContainerService();

    public DropboxLockFeature(DropboxSession session) {
        this.session = session;
    }

    public String lock(Path file) throws BackgroundException {
        if (!this.containerService.getContainer(file).getType().contains(AbstractPath.Type.shared)) {
            log.warn((Object)String.format("Skip attempting to lock file %s not in shared folder", file));
            throw new UnsupportedException();
        }
        try {
            for (LockFileResultEntry result : new DbxUserFilesRequests((DbxRawClientV2)this.session.getClient(file)).lockFileBatch(Collections.singletonList(new LockFileArg(this.containerService.getKey(file)))).getEntries()) {
                if (result.isFailure()) {
                    throw this.failure(result);
                }
                if (!result.isSuccess()) continue;
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Locked file %s with result %s", file, result.getSuccessValue()));
                }
                return String.valueOf(true);
            }
            return null;
        }
        catch (DbxException e) {
            throw new DropboxExceptionMappingService().map("Failure to write attributes of {0}", e, file);
        }
    }

    public void unlock(Path file, String token) throws BackgroundException {
        try {
            for (LockFileResultEntry result : new DbxUserFilesRequests((DbxRawClientV2)this.session.getClient(file)).unlockFileBatch(Collections.singletonList(new UnlockFileArg(this.containerService.getKey(file)))).getEntries()) {
                if (result.isFailure()) {
                    throw this.failure(result);
                }
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)String.format("Unlocked file %s with result %s", file, result.getSuccessValue()));
            }
        }
        catch (DbxException e) {
            throw new DropboxExceptionMappingService().map("Failure to write attributes of {0}", e, file);
        }
    }

    protected BackgroundException failure(LockFileResultEntry result) {
        log.warn((Object)String.format("Lock failure %s", result.getFailureValue()));
        switch (result.getFailureValue().tag()) {
            case PATH_LOOKUP: {
                return new NotfoundException(result.getFailureValue().toString());
            }
            case NO_WRITE_PERMISSION: 
            case CANNOT_BE_LOCKED: {
                return new AccessDeniedException(result.getFailureValue().toString());
            }
            case FILE_NOT_SHARED: {
                return new UnsupportedException(result.getFailureValue().toString());
            }
            case LOCK_CONFLICT: {
                return new LockedException(result.getFailureValue().getLockConflictValue().toString());
            }
        }
        return new InteroperabilityException(result.getFailureValue().toString());
    }
}

