/*
 * (C) Copyright 2011- ECMWF.
 *
 * This software is licensed under the terms of the Apache Licence Version 2.0
 * which can be obtained at http://www.apache.org/licenses/LICENSE-2.0.
 * In applying this licence, ECMWF does not waive the privileges and immunities
 * granted to it by virtue of its status as an intergovernmental organisation nor
 * does it submit to any jurisdiction.
 */

#ifndef ECCODES_ecbuild_config_h
#define ECCODES_ecbuild_config_h

/* ecbuild info */

#ifndef ECBUILD_VERSION_STR
#define ECBUILD_VERSION_STR "3.13.1"
#endif
#ifndef ECBUILD_VERSION
#define ECBUILD_VERSION "3.13.1"
#endif
#ifndef ECBUILD_MACROS_DIR
#define ECBUILD_MACROS_DIR  "/opt/local/var/macports/build/ecCodes-5968d902/work/eccodes-2.46.0-Source/cmake"
#endif

/* config info */

#define ECCODES_OS_NAME          "Darwin-12.6.0"
#define ECCODES_OS_BITS          64
#define ECCODES_OS_BITS_STR      "64"
#define ECCODES_OS_STR           "macosx.64"
#define ECCODES_OS_VERSION       "12.6.0"
#define ECCODES_SYS_PROCESSOR    "x86_64"

#define ECCODES_BUILD_TIMESTAMP  "20260302153748"
#define ECCODES_BUILD_TYPE       "Release"

#define ECCODES_C_COMPILER_ID      "Clang"
#define ECCODES_C_COMPILER_VERSION "16.0.6"

#define ECCODES_CXX_COMPILER_ID      "Clang"
#define ECCODES_CXX_COMPILER_VERSION "16.0.6"

#define ECCODES_C_COMPILER       "/opt/local/bin/clang-mp-16"
#define ECCODES_C_FLAGS          "-pipe -Os -DNDEBUG -isystem/opt/local/include/libcxx/v1 -nostdinc++ -isystem/opt/local/include/LegacySupport -I/opt/local/include -pipe -O3 -DNDEBUG"

#define ECCODES_CXX_COMPILER     "/opt/local/bin/clang++-mp-16"
#define ECCODES_CXX_FLAGS        "-pipe -Os -DNDEBUG -isystem/opt/local/include/libcxx/v1 -nostdinc++ -isystem/opt/local/include/LegacySupport -I/opt/local/include -stdlib=libc++ -pipe -O3 -DNDEBUG"

/* Needed for finding per package config files */

#define ECCODES_INSTALL_DIR       "/opt/local"
#define ECCODES_INSTALL_BIN_DIR   "/opt/local/bin"
#define ECCODES_INSTALL_LIB_DIR   "/opt/local/lib"
#define ECCODES_INSTALL_DATA_DIR  "/opt/local/share/eccodes"

#define ECCODES_DEVELOPER_SRC_DIR "/opt/local/var/macports/build/ecCodes-5968d902/work/eccodes-2.46.0-Source"
#define ECCODES_DEVELOPER_BIN_DIR "/opt/local/var/macports/build/ecCodes-5968d902/work/build"

/* Fortran support */

#if 1

#define ECCODES_Fortran_COMPILER_ID      "GNU"
#define ECCODES_Fortran_COMPILER_VERSION "15.2.0"

#define ECCODES_Fortran_COMPILER "/opt/local/bin/gfortran-mp-15"
#define ECCODES_Fortran_FLAGS    "-pipe -Os -fallow-argument-mismatch -m64 -O3 -DNDEBUG -funroll-all-loops -finline-functions"

#endif

#endif /* ECCODES_ecbuild_config_h */
