/*===- TableGen'erated file -------------------------------------*- C++ -*-===*\
|*                                                                            *|
|* Op Declarations                                                            *|
|*                                                                            *|
|* Automatically generated file, do not edit!                                 *|
|* From: FIROps.td                                                            *|
|*                                                                            *|
\*===----------------------------------------------------------------------===*/

namespace fir {

/// loop yield and termination operation
/// "fir.yield" yields SSA values from a fir dialect op region and
///     terminates the region. The semantics of how the values are yielded is
///     defined by the parent operation.
class YieldOp;

} // namespace fir
namespace fir {

/// create value to be passed for absent optional function argument
/// Given the type of a function argument, create a value that will signal that
///     an optional argument is absent in the call. On the caller side, fir.is_present
///     can be used to query if the value of an optional argument was created with
///     a fir.absent operation.
///     It is undefined to use a value that was created by a fir.absent op in any other
///     operation than fir.call and fir.is_present.
///     ```
///       %1 = fir.absent fir.box<fir.array<?xf32>>
///       fir.call @_QPfoo(%1) : (fir.box<fir.array<?xf32>>) -> ()
///     ```
class AbsentOp;

} // namespace fir
namespace fir {

class AddcOp;

} // namespace fir
namespace fir {

/// convert a symbol to an SSA value
/// Convert a symbol (a function or global reference) to an SSA-value to be
///     used in other operations. References to Fortran symbols are distinguished
///     via this operation from other arbitrary constant values.
/// 
///     ```
///       %p = fir.address_of(@symbol) : !fir.ref<f64>
///     ```
class AddrOfOp;

} // namespace fir
namespace fir {

/// allocate storage on the heap for an object of a given type
/// Creates a heap memory reference suitable for storing a value of the
///     given type, T.  The heap refernce returned has type `!fir.heap<T>`.
///     The memory object is in an undefined state.  `allocmem` operations must
///     be paired with `freemem` operations to avoid memory leaks.
/// 
///     ```
///       %0 = fir.allocmem !fir.array<10 x f32>
///       fir.freemem %0 : !fir.heap<!fir.array<10 x f32>>
///     ```
class AllocMemOp;

} // namespace fir
namespace fir {

/// allocate storage for a temporary on the stack given a type
/// This primitive operation is used to allocate an object on the stack.  A
///     reference to the object of type `!fir.ref<T>` is returned.  The returned
///     object has an undefined/uninitialized state.  The allocation can be given
///     an optional name.  The allocation may have a dynamic repetition count
///     for allocating a sequence of locations for the specified type.
/// 
///     ```
///       %c = ... : i64
///       %x = fir.alloca i32
///       %y = fir.alloca !fir.array<8 x i64>
///       %z = fir.alloca f32, %c
/// 
///       %i = ... : i16
///       %j = ... : i32
///       %w = fir.alloca !fir.type<PT(len1:i16, len2:i32)> (%i, %j : i16, i32)
///     ```
/// 
///     Note that in the case of `%z`, a contiguous block of memory is allocated
///     and its size is a runtime multiple of a 32-bit REAL value.
/// 
///     In the case of `%w`, the arguments `%i` and `%j` are LEN parameters
///     (`len1`, `len2`) to the type `PT`.
/// 
///     Finally, the operation is undefined if the ssa-value `%c` is negative.
/// 
///     Fortran Semantics:
///     There is no language mechanism in Fortran to allocate space on the stack
///     like C's `alloca()` function. Therefore fir.alloca is not control-flow
///     dependent. However, the lifetime of a stack allocation is often limited to
///     a small region and a legal implementation may reuse stack storage in other
///     regions when there is no conflict. For example, take the following code
///     fragment.
/// 
///     ```fortran
///       CALL foo(1)
///       CALL foo(2)
///       CALL foo(3)
///     ```
/// 
///     A legal implementation can allocate a stack slot and initialize it with the
///     constant `1`, then pass that by reference to foo. Likewise for the second
///     and third calls to foo, each stack slot being initialized accordingly. It is
///     also a conforming implementation to reuse the same stack slot for all three
///     calls, just initializing each in turn. This is possible as the lifetime of
///     the copy of each constant need not exceed that of the CALL statement.
///     Indeed, a user would likely expect a good Fortran compiler to perform such
///     an optimization.
/// 
///     Stack allocations have a maximum lifetime concept: their uses must not
///     exceed the lifetime of the closest parent operation with the
///     AutomaticAllocationScope trait, IsIsolatedFromAbove trait, or
///     LoopLikeOpInterface trait. This restriction is meant to ease the
///     insertion of stack save and restore operations, and to ease the conversion
///     of stack allocation into heap allocation.
/// 
///     Until Fortran 2018, procedures defaulted to non-recursive. A legal
///     implementation could therefore convert stack allocations to global
///     allocations. Such a conversion effectively adds the SAVE attribute to all
///     variables.
/// 
///     Some temporary entities (large arrays) probably should not be stack
///     allocated as stack space can often be limited. A legal implementation can
///     convert these large stack allocations to heap allocations regardless of
///     whether the procedure is recursive or not.
/// 
///     The pinned attribute is used to flag fir.alloca operation in a specific
///     region and avoid them being hoisted in an alloca hoisting pass.
class AllocaOp;

} // namespace fir
namespace fir {

/// Fetch the reference of an element of an array value
/// The `array_access` provides a reference to a single element from an array
///     value. This is *not* a view in the immutable array, otherwise it couldn't
///     be stored to. It can be see as a logical copy of the element and its
///     position in the array. This reference can be written to and modified without
///     changing the original array.
/// 
///     The `array_access` operation is used to fetch the memory reference of an
///     element in an array value.
/// 
///     ```fortran
///       real :: a(n,m)
///       ...
///       ... a ...
///       ... a(r,s+1) ...
///     ```
/// 
///     One can use `fir.array_access` to recover the implied memory reference to
///     the element `a(i,j)` in an array expression `a` as shown above. It can also
///     be used to recover the reference element `a(r,s+1)` in the second
///     expression.
/// 
///     ```
///       %s = fir.shape %n, %m : (index, index) -> !fir.shape<2>
///       // load the entire array 'a'
///       %v = fir.array_load %a(%s) : (!fir.ref<!fir.array<?x?xf32>>, !fir.shape<2>) -> !fir.array<?x?xf32>
///       // fetch the value of one of the array value's elements
///       %1 = fir.array_access %v, %i, %j : (!fir.array<?x?xf32>, index, index) -> !fir.ref<f32>
///     ```
/// 
///     It is only possible to use `array_access` on an `array_load` result value or
///     a value that can be trace back transitively to an `array_load` as the
///     dominating source. Other array operations such as `array_amend` can be in
///     between.
/// 
///     TODO: The above restriction is not enforced. The design of the operation
///     might need to be revisited to avoid such restrictions.
/// 
///     More information about `array_access` and other array operations can be
///     found in flang/docs/FIRArrayOperations.md.
class ArrayAccessOp;

} // namespace fir
namespace fir {

/// Mark an array value as having been changed by reference.
/// The `array_amend` operation marks an array value as having been changed via
///     a reference obtained by an `array_access`. It acts as a logical transaction
///     log that is used to merge the final result back with an `array_merge_store`
///     operation.
/// 
///     ```
///       // fetch the value of one of the array value's elements
///       %1 = fir.array_access %v, %i, %j : (!fir.array<?x?xT>, index, index) -> !fir.ref<T>
///       // modify the element by storing data using %1 as a reference
///       %2 = ... %1 ...
///       // mark the array value
///       %new_v = fir.array_amend %v, %2 : (!fir.array<?x?xT>, !fir.ref<T>) -> !fir.array<?x?xT>
///     ```
/// 
///     More information about `array_amend` and other array operations can be
///     found in flang/docs/FIRArrayOperations.md.
class ArrayAmendOp;

} // namespace fir
namespace fir {

/// Find the coordinate of an element of an array
/// Compute the location of an element in an array when the shape of the
///     array is only known at runtime.
/// 
///     This operation is intended to capture all the runtime values needed to
///     compute the address of an array reference in a single high-level op. Given
///     the following Fortran input:
/// 
///     ```fortran
///       real :: a(n,m)
///       ...
///       ... a(i,j) ...
///     ```
/// 
///     One can use `fir.array_coor` to determine the address of `a(i,j)`.
/// 
///     ```
///       %s = fir.shape %n, %m : (index, index) -> !fir.shape<2>
///       %1 = fir.array_coor %a(%s) %i, %j : (!fir.ref<!fir.array<?x?xf32>>, !fir.shape<2>, index, index) -> !fir.ref<f32>
///     ```
class ArrayCoorOp;

} // namespace fir
namespace fir {

/// Fetch the value of an element of an array value
/// Fetch the value of an element in an array value.
/// 
///     ```fortran
///       real :: a(n,m)
///       ...
///       ... a ...
///       ... a(r,s+1) ...
///     ```
/// 
///     One can use `fir.array_fetch` to fetch the (implied) value of `a(i,j)` in
///     an array expression as shown above. It can also be used to extract the
///     element `a(r,s+1)` in the second expression.
/// 
///     ```
///       %s = fir.shape %n, %m : (index, index) -> !fir.shape<2>
///       // load the entire array 'a'
///       %v = fir.array_load %a(%s) : (!fir.ref<!fir.array<?x?xf32>>, !fir.shape<2>) -> !fir.array<?x?xf32>
///       // fetch the value of one of the array value's elements
///       %1 = fir.array_fetch %v, %i, %j : (!fir.array<?x?xf32>, index, index) -> f32
///     ```
/// 
///     It is only possible to use `array_fetch` on an `array_load` result value.
class ArrayFetchOp;

} // namespace fir
namespace fir {

/// Load an array as a value.
/// This operation taken with array_merge_store captures Fortran's
///     copy-in/copy-out semantics. One way to think of this is that array_load
///     creates a snapshot copy of the entire array. This copy can then be used
///     as the "original value" of the array while the array's new value is
///     computed. The array_merge_store operation is the copy-out semantics, which
///     merge the updates with the original array value to produce the final array
///     result. This abstracts the copy operations as opposed to always creating
///     copies or requiring dependence analysis be performed on the syntax trees
///     and before lowering to the IR.
/// 
///     Load an entire array as a single SSA value.
/// 
///     ```fortran
///       real :: a(o:n,p:m)
///       ...
///       ... = ... a ...
///     ```
/// 
///     One can use `fir.array_load` to produce an ssa-value that captures an
///     immutable value of the entire array `a`, as in the Fortran array expression
///     shown above. Subsequent changes to the memory containing the array do not
///     alter its composite value. This operation lets one load an array as a
///     value while applying a runtime shape, shift, or slice to the memory
///     reference, and its semantics guarantee immutability.
/// 
///     ```
///       %s = fir.shape_shift %o, %n, %p, %m : (index, index, index, index) -> !fir.shapeshift<2>
///       // load the entire array 'a'
///       %v = fir.array_load %a(%s) : (!fir.ref<!fir.array<?x?xf32>>, !fir.shapeshift<2>) -> !fir.array<?x?xf32>
///       // a fir.store here into array %a does not change %v
///     ```
class ArrayLoadOp;

} // namespace fir
namespace fir {

/// Store merged array value to memory.
/// Store a merged array value to memory.
/// 
///     ```fortran
///       real :: a(n,m)
///       ...
///       a = ...
///     ```
/// 
///     One can use `fir.array_merge_store` to merge/copy the value of `a` in an
///     array expression as shown above.
/// 
///     ```
///       %v = fir.array_load %a(%shape) : ...
///       %r = fir.array_update %v, %f, %i, %j : (!fir.array<?x?xf32>, f32, index, index) -> !fir.array<?x?xf32>
///       fir.array_merge_store %v, %r to %a : !fir.ref<!fir.array<?x?xf32>>
///     ```
/// 
///     This operation merges the original loaded array value, `%v`, with the
///     chained updates, `%r`, and stores the result to the array at address, `%a`.
class ArrayMergeStoreOp;

} // namespace fir
namespace fir {

/// Get an address for an array value to modify it.
/// Modify the value of an element in an array value through actions done
///     on the returned address. A new array value is also
///     returned where all element values of the input array are identical except
///     for the selected element which is the value after the modification done
///     on the element address.
/// 
///     ```fortran
///       real :: a(n)
///       ...
///       ! Elemental user defined assignment from type(SomeType) to real.
///       a = value_of_some_type
///     ```
/// 
///     One can use `fir.array_modify` to update the (implied) value of `a(i)`
///     in an array expression as shown above.
/// 
///     ```
///       %s = fir.shape %n : (index) -> !fir.shape<1>
///       // Load the entire array 'a'.
///       %v = fir.array_load %a(%s) : (!fir.ref<!fir.array<?xf32>>, !fir.shape<1>) -> !fir.array<?xf32>
///       // Update the value of one of the array value's elements with a user
///       // defined assignment from %rhs.
///       %new = fir.do_loop %i = ... (%inner = %v) {
///         %rhs = ...
///         %addr, %r = fir.array_modify %inner, %i : (!fir.array<?xf32>, index) -> (fir.ref<f32>, !fir.array<?xf32>)
///         fir.call @user_def_assign(%addr, %rhs) (fir.ref<f32>, fir.ref<!fir.type<SomeType>>) -> ()
///         fir.result %r : !fir.ref<!fir.array<?xf32>>
///       }
///       fir.array_merge_store %v, %new to %a : !fir.ref<!fir.array<?xf32>>
///     ```
/// 
///     An array value modification behaves as if a mapping function from the indices
///     to the new value has been added, replacing the previous mapping. These
///     mappings can be added to the ssa-value, but will not be materialized in
///     memory until the `fir.array_merge_store` is performed.
class ArrayModifyOp;

} // namespace fir
namespace fir {

/// Update the value of an element of an array value
/// Updates the value of an element in an array value. A new array value is
///     returned where all element values of the input array are identical except
///     for the selected element which is the value passed in the update.
/// 
///     ```fortran
///       real :: a(n,m)
///       ...
///       a = ...
///     ```
/// 
///     One can use `fir.array_update` to update the (implied) value of `a(i,j)`
///     in an array expression as shown above.
/// 
///     ```
///       %s = fir.shape %n, %m : (index, index) -> !fir.shape<2>
///       // load the entire array 'a'
///       %v = fir.array_load %a(%s) : (!fir.ref<!fir.array<?x?xf32>>, !fir.shape<2>) -> !fir.array<?x?xf32>
///       // update the value of one of the array value's elements
///       // %r_{ij} = %f  if (i,j) = (%i,%j),   %v_{ij} otherwise
///       %r = fir.array_update %v, %f, %i, %j : (!fir.array<?x?xf32>, f32, index, index) -> !fir.array<?x?xf32>
///       fir.array_merge_store %v, %r to %a : !fir.ref<!fir.array<?x?xf32>>
///     ```
/// 
///     An array value update behaves as if a mapping function from the indices
///     to the new value has been added, replacing the previous mapping. These
///     mappings can be added to the ssa-value, but will not be materialized in
///     memory until the `fir.array_merge_store` is performed.
class ArrayUpdateOp;

} // namespace fir
namespace fir {

/// get the assumed-size last extent sentinel
/// Returns the special extent value representing the last dimension of an
///     assumed-size array. This is used to model the semantics in FIR without
///     directly materializing the sentinel value. The concrete encoding is
///     introduced during FIR to LLVM lowering.
/// 
///     ```
///       %e = fir.assumed_size_extent : index
///     ```
class AssumedSizeExtentOp;

} // namespace fir
namespace fir {

/// return a memory reference to the boxed value
/// This operator is overloaded to work with values of type `box`,
///     `boxchar`, and `boxproc`.  The result for each of these
///     cases, respectively, is the address of the data, the address of the
///     `CHARACTER` data, and the address of the procedure.
/// 
///     ```
///       %51 = fir.box_addr %box : (!fir.box<f64>) -> !fir.ref<f64>
///       %52 = fir.box_addr %boxchar : (!fir.boxchar<1>) -> !fir.ref<!fir.char<1>>
///       %53 = fir.box_addr %boxproc : (!fir.boxproc<!P>) -> !P
///     ```
class BoxAddrOp;

} // namespace fir
namespace fir {

/// return the LEN type parameter from a boxchar value
/// Extracts the LEN type parameter from a `boxchar` value.
/// 
///     ```
///       %45 = ... : !boxchar<1>  // CHARACTER(20)
///       %59 = fir.boxchar_len %45 : (!fir.boxchar<1>) -> i64  // len=20
///     ```
class BoxCharLenOp;

} // namespace fir
namespace fir {

/// return the dynamic dimension information for the boxed value
/// Returns the triple of lower bound, extent, and stride for `dim` dimension
///     of `val`, which must have a `box` type.  The dimensions are enumerated from
///     left to right from 0 to rank-1. This operation has undefined behavior if
///     `dim` is out of bounds.
/// 
///     ```
///       %c1   = arith.constant 0 : i32
///       %52:3 = fir.box_dims %40, %c1 : (!fir.box<!fir.array<*:f64>>, i32) -> (index, index, index)
///     ```
/// 
///     The above is a request to return the left most row (at index 0) triple from
///     the box. The triple will be the lower bound, extent, and byte-stride, which
///     are the values encoded in a standard descriptor.
class BoxDimsOp;

} // namespace fir
namespace fir {

/// return the size of an element of the boxed value
/// Returns the size of an element in an entity of `box` type.  This size may
///     not be known until runtime.
/// 
///     ```
///       %53 = fir.box_elesize %40 : (!fir.box<f32>) -> i32  // size=4
///       %54 = fir.box_elesize %40 : (!fir.box<!fir.array<*:f32>>) -> i32
///     ```
/// 
///     In the above example, `%53` may box an array of REAL values while `%54`
///     must box an array of REAL values (with dynamic rank and extent).
class BoxEleSizeOp;

} // namespace fir
namespace fir {

/// is the boxed value an ALLOCATABLE?
/// Determine if the boxed value was from an ALLOCATABLE entity. This will
///     return true if the originating box value was from a `fir.embox` op
///     with a mem-ref value that had the type !fir.heap<T>.
/// 
///     ```
///       %r = ... : !fir.heap<i64>
///       %b = fir.embox %r : (!fir.heap<i64>) -> !fir.box<i64>
///       %a = fir.box_isalloc %b : (!fir.box<i64>) -> i1  // true
///     ```
/// 
///     The canonical descriptor implementation will carry a flag to record if the
///     variable is an `ALLOCATABLE`.
class BoxIsAllocOp;

} // namespace fir
namespace fir {

/// is the boxed value an array?
/// Determine if the boxed value has a positive (> 0) rank. This will return
///     true if the originating box value was from a fir.embox with a memory
///     reference value that had the type !fir.array<T> and/or a shape argument.
/// 
///     ```
///       %r = ... : !fir.ref<i64>
///       %c_100 = arith.constant 100 : index
///       %d = fir.shape %c_100 : (index) -> !fir.shape<1>
///       %b = fir.embox %r(%d) : (!fir.ref<i64>, !fir.shape<1>) -> !fir.box<i64>
///       %a = fir.box_isarray %b : (!fir.box<i64>) -> i1  // true
///     ```
class BoxIsArrayOp;

} // namespace fir
namespace fir {

/// is the boxed value a POINTER?
/// Determine if the boxed value was from a POINTER entity.
/// 
///     ```
///       %p = ... : !fir.ptr<i64>
///       %b = fir.embox %p : (!fir.ptr<i64>) -> !fir.box<i64>
///       %a = fir.box_isptr %b : (!fir.box<i64>) -> i1  // true
///     ```
class BoxIsPtrOp;

} // namespace fir
namespace fir {

/// Get the address of a field in a fir.ref<fir.box>
/// Given the address of a fir.box, compute the address of a field inside
///     the fir.box.
///     This allows keeping the actual runtime descriptor layout abstract in
///     FIR while providing access to the pointer addresses in the runtime
///     descriptor for OpenMP/OpenACC target mapping.
/// 
///     To avoid requiring too much information about the fields that the runtime
///     descriptor implementation must have, only the base_addr and derived_type
///     descriptor fields can be addressed.
/// 
///     It also accepts the address of a fir.boxchar and returns
///     address of the data pointer encapsulated by the fir.boxchar.
/// 
///     ```
///         %addr = fir.box_offset %box base_addr : (!fir.ref<!fir.box<!fir.array<?xi32>>>) -> !fir.llvm_ptr<!fir.ref<!fir.array<?xi32>>>
///         %tdesc = fir.box_offset %box derived_type : (!fir.ref<!fir.box<!fir.type<t>>>) -> !fir.llvm_ptr<!fir.tdesc<!fir.type<t>>>
/// 
///         %addr1 = fir.box_offset %boxchar base_addr : (!fir.ref<!fir.boxchar<1>>) -> !fir.llvm_ptr<!fir.ref<fir.char<1,?>>>
///     ```
/// 
///     The derived_type field cannot be used when the input to this op is a reference to a fir.boxchar.
class BoxOffsetOp;

} // namespace fir
namespace fir {

/// returns the host instance pointer (or null)
/// Extract the host context pointer from a boxproc value.
/// 
///     ```
///       %8 = ... : !fir.boxproc<(!fir.ref<!fir.type<T>>) -> i32>
///       %9 = fir.boxproc_host %8 : (!fir.boxproc<(!fir.ref<!fir.type<T>>) -> i32>) -> !fir.ref<tuple<i32, i32>>
///     ```
/// 
///     In the example, the reference to the closure over the host procedure's
///     variables is returned. This allows an internal procedure to access the
///     host's variables. It is up to lowering to determine the contract between
///     the host and the internal procedure.
class BoxProcHostOp;

} // namespace fir
namespace fir {

/// return the number of dimensions for the boxed value
/// Return the rank of a value of `box` type.  If the value is scalar, the
///     rank is 0.
/// 
///     ```
///       %57 = fir.box_rank %40 : (!fir.box<!fir.array<*:f64>>) -> i32
///       %58 = fir.box_rank %41 : (!fir.box<f64>) -> i32
///     ```
/// 
///     The example `%57` shows how one would determine the rank of an array that
///     has deferred rank at runtime. This rank should be at least 1. In %58, the
///     descriptor may be either an array or a scalar, so the value is nonnegative.
class BoxRankOp;

} // namespace fir
namespace fir {

/// Returns the boxed entity's total size in elements
/// Returns the boxed entity's total size in elements.
///     The input box cannot be absent.
class BoxTotalElementsOp;

} // namespace fir
namespace fir {

/// return the type code the boxed value
/// Returns the descriptor type code of an entity of `box` type.
/// 
///     ```
///       %1 = fir.box_typecode %0 : (!fir.box<T>) -> i32
///     ```
class BoxTypeCodeOp;

} // namespace fir
namespace fir {

/// return the type descriptor for the boxed value
/// Return the opaque type descriptor of a value of `box` type. A type
///     descriptor is an implementation defined value that fully describes a type
///     to the Fortran runtime.
/// 
///     ```
///       %7 = fir.box_tdesc %41 : (!fir.box<f64>) -> !fir.tdesc<f64>
///     ```
class BoxTypeDescOp;

} // namespace fir
namespace fir {

/// call a procedure
/// Call the specified function or function reference.
/// 
///     Provides a custom parser and pretty printer to allow a more readable syntax
///     in the FIR dialect, e.g. `fir.call @sub(%12)` or `fir.call %20(%22,%23)`.
/// 
///     ```
///       %a = fir.call %funcref(%arg0) : (!fir.ref<f32>) -> f32
///       %b = fir.call @function(%arg1, %arg2) : (!fir.ref<f32>, !fir.ref<f32>) -> f32
///     ```
class CallOp;

} // namespace fir
namespace fir {

/// Primitive to convert an entity of type CHARACTER from one KIND to a
///     different KIND.
/// Copy a CHARACTER (must be in memory) of KIND _k1_ to a CHARACTER (also must
///     be in memory) of KIND _k2_ where _k1_ != _k2_ and the buffers do not
///     overlap. This latter restriction is unchecked, as the Fortran language
///     definition eliminates the overlapping in memory case.
/// 
///     The number of code points copied is specified explicitly as the second
///     argument. The length of the !fir.char type is ignored.
/// 
///     ```
///       fir.char_convert %1 for %2 to %3 : !fir.ref<!fir.char<1,?>>, i32,
///           !fir.ref<!fir.char<2,20>>
///     ```
/// 
///     Should future support for encodings other than ASCII be supported, codegen
///     can generate a call to a runtime helper routine which will map the code
///     points from UTF-8 to UCS-2, for example. Such remappings may not always
///     be possible as they may involve the creation of more code points than the
///     `count` limit. These details are left as future to-dos.
class CharConvertOp;

} // namespace fir
namespace fir {

/// complex floating-point comparison operator
/// A complex comparison to handle complex types found in FIR.
class CmpcOp;

} // namespace fir
namespace fir {

/// encapsulates all Fortran entity type conversions
/// Generalized type conversion. Convert the ssa-value from type T to type U.
///     Not all pairs of types have conversions. When types T and U are the same
///     type, this instruction is a NOP and may be folded away. This also supports
///     integer to pointer conversion and pointer to integer conversion.
/// 
///     This operation also allows limited interaction between FIR and LLVM
///     dialects by allowing conversion between FIR pointer types and llvm.ptr type.
/// 
///     ```
///       %v = ... : i64
///       %w = fir.convert %v : (i64) -> i32
///     ```
/// 
///     The example truncates the value `%v` from an i64 to an i32.
class ConvertOp;

} // namespace fir
namespace fir {

/// Finds the coordinate (location) of a value in memory
/// Compute the internal coordinate address starting from a boxed value or
///     unboxed memory reference. Returns a memory reference. When computing the
///     coordinate of an array element, the rank of the array must be known and
///     the number of indexing expressions must not exceed the rank of the array.
/// 
///     This operation will apply the access map from a boxed value implicitly.
/// 
///     Unlike LLVM's GEP instruction, one cannot stride over the outermost
///     reference; therefore, the leading 0 index must be omitted.
/// 
///     This operation can be used to index derived type fields, in which case
///     the operand is the name of the index field.
/// 
///     ```
///       %i = ... : index
///       %h = ... : !fir.heap<!fir.array<100 x f32>>
///       %p = fir.coordinate_of %h, %i : (!fir.heap<!fir.array<100 x f32>>, index) -> !fir.ref<f32>
/// 
///       %d = ... : !fir.ref<!fir.type<t{field1:i32, field2:f32}>>
///       %f = fir.coordinate_of %d, field2 : (!fir.ref<!fir.type<t{field1:i32, field2:f32}>>) -> !fir.ref<f32>
///     ```
/// 
///     In the example, `%p` will be a pointer to the `%i`-th f32 value in the
///     array `%h`.
class CoordinateOp;

} // namespace fir
namespace fir {

/// copy constant size memory
/// Copy the memory from a source with compile time constant size to
///     a destination of the same type.
/// 
///     This is meant to be used for aggregate types where load and store
///     are not appropriate to make a copy because LLVM is not meant to
///     handle load and store of "big" aggregates.
/// 
///     Its "no_overlap" attribute allows indicating that the source and destination
///     are known to not overlap at compile time.
/// 
///     ```
///       !t =!fir.type<t{x:!fir.array<1000xi32>}>
///       fir.copy %x to %y : !fir.ref<!t>, !fir.ref<!t>
///     ```
///     TODO: add FirAliasTagOpInterface to carry TBAA.
class CopyOp;

} // namespace fir
namespace fir {

/// define extra information about a component inside fir.type_info
/// ```
///       fir.dt_component i lbs [-1,2] init @init_val
///     ```
class DTComponentOp;

} // namespace fir
namespace fir {

/// map entry in a dispatch table
/// An entry in a dispatch table. Allows a function symbol to be bound
///     to a specifier method identifier. A dispatch operation uses the dynamic
///     type of a distinguished argument to determine an exact dispatch table
///     and uses the method identifier to select the type-bound procedure to
///     be called.
/// 
///     The optional "deferred" flag indicates that the binding is a DEFERRED
///     type-bound procedure (declared but without an implementation at this
///     type level).
/// 
///     ```
///       // Non-deferred binding
///       fir.dt_entry method_name, @uniquedProcedure
/// 
///       // Deferred binding
///       fir.dt_entry method_name, @uniquedProcedure deferred
///     ```
class DTEntryOp;

} // namespace fir
namespace fir {

/// declare a variable
/// Tie the properties of a Fortran variable to an address. The properties
///     include bounds, length parameters, and Fortran attributes.
/// 
///     The memref argument describes the storage of the variable. It may be a
///     raw address (fir.ref<T>), or a box or class value or address (fir.box<T>,
///     fir.ref<fir.box<T>>, fir.class<T>, fir.ref<fir.class<T>>).
/// 
///     The shape argument encodes explicit extents and lower bounds. It must be
///     provided if the memref is the raw address of an array.
///     The shape argument must not be provided if memref operand is a box or
///     class value or address, unless the shape is a shift (encodes lower bounds)
///     and the memref if a box value (this covers assumed shapes with local lower
///     bounds).
/// 
///     The typeparams values are meant to carry the non-deferred length parameters
///     (this includes both Fortran assumed and explicit length parameters).
///     It must always be provided for characters and parametrized derived types
///     when memref is not a box value or address.
/// 
///     The storage and storage_offset operands are optional and are required
///     for FortranVariableStorageOpInterface, where they are documented.
///     If these operands are absent, then the storage of the declared variable
///     is only known to start where the memref operand points to.
/// 
///     Example:
/// 
///     CHARACTER(n), OPTIONAL, TARGET :: c(10:, 20:)
/// 
///     Can be represented as:
///     ```
///     func.func @foo(%arg0: !fir.box<!fir.array<?x?x!fir.char<1,?>>>, %arg1: !fir.ref<i64>) {
///       %c10 = arith.constant 10 : index
///       %c20 = arith.constant 20 : index
///       %1 = fir.load %ag1 : fir.ref<i64>
///       %2 = fir.shift %c10, %c20 : (index, index) -> !fir.shift<2>
///       %3 = fir.declare %arg0(%2) typeparams %1 {fortran_attrs = #fir.var_attrs<optional, target>, uniq_name = "c"}
///       // ... uses %3 as "c"
///     }
///    ```
class DeclareOp;

} // namespace fir
namespace fir {

/// declares a reduction kind
/// Note: this operation is adapted from omp::DeclareReductionOp. There is a lot
///     duplication at the moment. TODO Combine both ops into one. See:
///     https://discourse.llvm.org/t/dialect-for-data-locality-sharing-specifiers-clauses-in-openmp-openacc-and-do-concurrent/86108.
/// 
///     Declares a `do concurrent` reduction. This requires two mandatory and four 
///     optional regions.
/// 
///       1. The optional alloc region specifies how to allocate the thread-local
///          reduction value. This region should not contain control flow and all
///          IR should be suitable for inlining straight into an entry block. In
///          the common case this is expected to contain only allocas. It is
///          expected to `fir.yield` the allocated value on all control paths.
///          If allocation is conditional (e.g. only allocate if the mold is
///          allocated), this should be done in the initilizer region and this
///          region not included. The alloc region is not used for by-value
///          reductions (where allocation is implicit).
///       2. The initializer region specifies how to initialize the thread-local
///          reduction value. This is usually the neutral element of the reduction.
///          For convenience, the region has an argument that contains the value
///          of the reduction accumulator at the start of the reduction. If an alloc
///          region is specified, there is a second block argument containing the
///          address of the allocated memory. The initializer region is expected to
///          `fir.yield` the new value on all control flow paths.
///       3. The reduction region specifies how to combine two values into one, i.e.
///          the reduction operator. It accepts the two values as arguments and is
///          expected to `fir.yield` the combined value on all control flow paths.
///       4. The atomic reduction region is optional and specifies how two values
///          can be combined atomically given local accumulator variables. It is
///          expected to store the combined value in the first accumulator variable.
///       5. The cleanup region is optional and specifies how to clean up any memory
///          allocated by the initializer region. The region has an argument that
///          contains the value of the thread-local reduction accumulator. This will
///          be executed after the reduction has completed.
///       6. The DataPtrPtr region specifies how to access the base address of a
///          boxed-value. This is used, in particular, for GPU reductions in order
///          know where partial reduction results are stored in remote lanes.
/// 
///     Note that the MLIR type system does not allow for type-polymorphic
///     reductions. Separate reduction declarations should be created for different
///     element and accumulator types.
/// 
///     For initializer and reduction regions, the operand to `fir.yield` must
///     match the parent operation's results.
/// 
///     * `$byref_element_type`: For by-ref reductions, we want to keep track of the
///       boxed/allocated type.  For example, for a `real, allocatable` variable, 
///       `real` should be stored in this attribute.
class DeclareReductionOp;

} // namespace fir
namespace fir {

/// call a type-bound procedure
/// Perform a dynamic dispatch on the method name via the dispatch table
///     associated with the first operand.  The attribute `pass_arg_pos` can be
///     used to select a dispatch operand other than the first one.  The absence of
///     `pass_arg_pos` attribute means nopass.
/// 
///     ```
///       // fir.dispatch with no attribute.
///       %r = fir.dispatch "methodA"(%o) : (!fir.class<T>) -> i32
/// 
///       // fir.dispatch with the `pass_arg_pos` attribute.
///       %r = fir.dispatch "methodA"(%o : !fir.class<T>) (%o : !fir.class<T>) -> i32 {pass_arg_pos = 0 : i32}
///     ```
class DispatchOp;

} // namespace fir
namespace fir {

class DivcOp;

} // namespace fir
namespace fir {

/// do concurrent loop
/// An operation that models a Fortran `do concurrent` loop's header and block.
///     This is a single-region single-block terminator op that is expected to
///     terminate the region of a `fir.do_concurrent` wrapper op.
/// 
///     This op borrows from both `scf.parallel` and `fir.do_loop` ops. Similar to
///     `scf.parallel`, a loop nest takes 3 groups of SSA values as operands that
///     represent the lower bounds, upper bounds, and steps. Similar to `fir.do_loop`
///     the op takes one additional group of SSA values to represent reductions.
/// 
///     The body region **does not** have a terminator.
/// 
///     For example, a 2D loop nest with 2 reductions (sum and max) would be
///     represented as follows:
///     ```
///     // The wrapper of the loop
///     fir.do_concurrent {
///       %i = fir.alloca i32
///       %j = fir.alloca i32
/// 
///       // The actual `do concurrent` loop
///       fir.do_concurrent.loop
///         (%i_iv, %j_iv) = (%i_lb, %j_lb) to (%i_ub, %j_ub) step (%i_st, %j_st)
///         reduce(#fir.reduce_attr<add> -> %sum : !fir.ref<i32>,
///                #fir.reduce_attr<max> -> %max : !fir.ref<f32>) {
/// 
///         %0 = fir.convert %i_iv : (index) -> i32
///         fir.store %0 to %i : !fir.ref<i32>
/// 
///         %1 = fir.convert %j_iv : (index) -> i32
///         fir.store %1 to %j : !fir.ref<i32>
/// 
///         // ... loop body goes here ...
///       }
///     }
///     ```
/// 
///     Description of arguments:
///     - `lowerBound`: The group of SSA values for the nest's lower bounds.
///     - `upperBound`: The group of SSA values for the nest's upper bounds.
///     - `step`: The group of SSA values for the nest's steps.
///     - `loopAnnotation`: Loop metadata to be passed down the compiler pipeline to
///       LLVM.
class DoConcurrentLoopOp;

} // namespace fir
namespace fir {

/// do concurrent loop wrapper
/// A wrapper operation for the actual op modeling `do concurrent` loops:
///     `fir.do_concurrent.loop` (see op declaration below for more info about it).
/// 
///     The `fir.do_concurrent` wrapper op consists of one single-block region with
///     the following properties:
///     - The first ops in the region are responsible for allocating storage for the
///       loop's iteration variables. This is property is **not** enforced by the op
///       verifier, but expected to be respected when building the op.
///     - The terminator of the region is an instance of `fir.do_concurrent.loop`.
/// 
///     For example, a 2D loop nest would be represented as follows:
///     ```
///     fir.do_concurrent {
///       %i = fir.alloca i32
///       %j = fir.alloca i32
///       fir.do_concurrent.loop ...
///     }
///     ```
class DoConcurrentOp;

} // namespace fir
namespace fir {

/// generalized loop operation
/// Generalized high-level looping construct. This operation is similar to
///     MLIR's `scf.for`.
/// 
///     ```
///       %l = arith.constant 0 : index
///       %u = arith.constant 9 : index
///       %s = arith.constant 1 : index
///       fir.do_loop %i = %l to %u step %s unordered {
///         %x = fir.convert %i : (index) -> i32
///         %v = fir.call @compute(%x) : (i32) -> f32
///         %p = fir.coordinate_of %A, %i : (!fir.ref<!fir.array<?xf32>>, index) -> !fir.ref<f32>
///         fir.store %v to %p : !fir.ref<f32>
///       }
///     ```
/// 
///     The above example iterates over the interval `[%l, %u]`. The unordered
///     keyword indicates that the iterations can be executed in any order.
class DoLoopOp;

} // namespace fir
namespace fir {

/// Define a scope for dummy arguments
/// An abstract handle to be used to associate dummy arguments of the same
///     subroutine between each other. By lowering, all [hl]fir.declare
///     operations representing declarations of dummy arguments of a subroutine
///     use the result of this operation. This allows recognizing the references
///     of these dummy arguments as belonging to the same runtime instance
///     of the subroutine even after MLIR inlining. Thus, the Fortran aliasing
///     rules might be applied to those references based on the original
///     declarations of the dummy arguments.
///     For example:
///     ```
///       subroutine test(x, y)
///         real, target :: x, y
///         x = y ! may alias
///         call inner(x, y)
///       contains
///         subroutine inner(x, y)
///           real :: x, y
///           x = y ! may not alias
///         end subroutine inner
///       end subroutine test
///     ```
///     After MLIR inlining this may look like this:
///     ```
///       func.func @_QPtest(
///           %arg0: !fir.ref<f32> {fir.target},
///           %arg1: !fir.ref<f32> {fir.target}) {
///         %0 = fir.declare %arg0 {fortran_attrs = #fir.var_attrs<target>} :
///             (!fir.ref<f32>) -> !fir.ref<f32>
///         %1 = fir.declare %arg1 {fortran_attrs = #fir.var_attrs<target>} :
///             (!fir.ref<f32>) -> !fir.ref<f32>
///         %2 = fir.load %1 : !fir.ref<f32>
///         fir.store %2 to %0 : !fir.ref<f32>
///         %3 = fir.declare %0 : (!fir.ref<f32>) -> !fir.ref<f32>
///         %4 = fir.declare %1 : (!fir.ref<f32>) -> !fir.ref<f32>
///         %5 = fir.load %4 : !fir.ref<f32>
///         fir.store %5 to %3 : !fir.ref<f32>
///         return
///       }
///     ```
///     Without marking %3 and %4 as declaring the dummy arguments
///     of the same runtime instance of `inner` subroutine the FIR
///     AliasAnalysis cannot deduce non-aliasing for the second load/store pair.
///     This information may be preserved by using fir.dummy_scope operation:
///     ```
///       func.func @_QPtest(
///           %arg0: !fir.ref<f32> {fir.target},
///           %arg1: !fir.ref<f32> {fir.target}) {
///         %h1 = fir.dummy_scope : i1
///         %0 = fir.declare %arg0 dummy_scope(%h1)
///             {fortran_attrs = #fir.var_attrs<target>} :
///             (!fir.ref<f32>) -> !fir.ref<f32>
///         %1 = fir.declare %arg1 dummy_scope(%h1)
///             {fortran_attrs = #fir.var_attrs<target>} :
///             (!fir.ref<f32>) -> !fir.ref<f32>
///         %2 = fir.load %1 : !fir.ref<f32>
///         fir.store %2 to %0 : !fir.ref<f32>
///         %h2 = fir.dummy_scope : i1
///         %3 = fir.declare %0 dummy_scope(%h2) : (!fir.ref<f32>) -> !fir.ref<f32>
///         %4 = fir.declare %1 dummy_scope(%h2) : (!fir.ref<f32>) -> !fir.ref<f32>
///         %5 = fir.load %4 : !fir.ref<f32>
///         fir.store %5 to %3 : !fir.ref<f32>
///         return
///       }
///     ```
///     Note that even if `inner` is called and inlined twice inside
///     `test`, the two inlined instances of `inner` must use two different
///     fir.dummy_scope operations for their fir.declare ops. This
///     two distinct fir.dummy_scope must remain distinct during the optimizations.
///     This is guaranteed by the write memory effect on the DebuggingResource.
class DummyScopeOp;

} // namespace fir
namespace fir {

/// boxes a given CHARACTER reference and its LEN parameter
/// Create a boxed CHARACTER value. The CHARACTER type has the LEN type
///     parameter, the value of which may only be known at runtime.  Therefore,
///     a variable of type CHARACTER has both its data reference as well as a
///     LEN type parameter.
/// 
///     ```fortran
///       CHARACTER(LEN=10) :: var
///     ```
///     ```
///       %4 = ...         : !fir.ref<!fir.array<10 x !fir.char<1>>>
///       %5 = arith.constant 10 : i32
///       %6 = fir.emboxchar %4, %5 : (!fir.ref<!fir.array<10 x !fir.char<1>>>, i32) -> !fir.boxchar<1>
///     ```
/// 
///     In the above `%4` is a memory reference to a buffer of 10 CHARACTER units.
///     This buffer and its LEN value (10) are wrapped into a pair in `%6`.
class EmboxCharOp;

} // namespace fir
namespace fir {

/// boxes a given reference and (optional) dimension information
/// Create a boxed reference value. In Fortran, the implementation can require
///     extra information about an entity, such as its type, rank, etc.  This
///     auxiliary information is packaged and abstracted as a value with box type
///     by the calling routine. (In Fortran, these are called descriptors.)
/// 
///     ```
///       %c1 = arith.constant 1 : index
///       %c10 = arith.constant 10 : index
///       %5 = ... : !fir.ref<!fir.array<10 x i32>>
///       %6 = fir.embox %5 : (!fir.ref<!fir.array<10 x i32>>) -> !fir.box<!fir.array<10 x i32>>
///     ```
/// 
///     The descriptor tuple may contain additional implementation-specific
///     information through the use of additional attributes.
///     Specifically,
///         - shape: emboxing an array may require shape information (an array's
///           lower bounds and extents may not be known until runtime),
///         - slice: an array section can be described with a slice triple,
///         - typeparams: for emboxing a derived type with LEN type parameters,
///         - sourceBox: A box to read information from such as CFI type,
///           type descriptor or element size to populate the new descriptor.
///         - accessMap: unused/experimental.
///         - allocator_idx: specify special allocator to use.
class EmboxOp;

} // namespace fir
namespace fir {

/// boxes a given procedure and optional host context
/// Creates an abstract encapsulation of a PROCEDURE POINTER along with an
///     optional pointer to a host instance context. If the pointer is not to an
///     internal procedure or the internal procedure does not need a host context
///     then the form takes only the procedure's symbol.
/// 
///     ```
///       %f = ... : (i32) -> i32
///       %0 = fir.emboxproc %f : ((i32) -> i32) -> !fir.boxproc<(i32) -> i32>
///     ```
/// 
///     An internal procedure requiring a host instance for correct execution uses
///     the second form. The closure of the host procedure's state is passed as a
///     reference to a tuple. It is the responsibility of the host to manage the
///     context's values accordingly, up to and including inhibiting register
///     promotion of local values.
/// 
///     ```
///       %4 = ... : !fir.ref<tuple<!fir.ref<i32>, !fir.ref<i32>>>
///       %g = ... : (i32) -> i32
///       %5 = fir.emboxproc %g, %4 : ((i32) -> i32, !fir.ref<tuple<!fir.ref<i32>, !fir.ref<i32>>>) -> !fir.boxproc<(i32) -> i32>
///     ```
class EmboxProcOp;

} // namespace fir
namespace fir {

/// Extract a value from an aggregate SSA-value
/// Extract a value from an entity with a type composed of tuples, arrays,
///     and/or derived types. Returns the value from entity with the type of the
///     specified component. Cannot be used on values of `!fir.box` type.
///     It can also be used to access complex parts and elements of a character
///     string.
/// 
///     Note that the entity ssa-value must be of compile-time known size in order
///     to use this operation.
/// 
///     ```
///       %f = fir.field_index field, !fir.type<X{field:i32}>
///       %s = ... : !fir.type<X>
///       %v = fir.extract_value %s, %f : (!fir.type<X>, !fir.field) -> i32
///     ```
class ExtractValueOp;

} // namespace fir
namespace fir {

/// create a field index value from a field identifier
/// Generate a field (offset) value from an identifier.  Field values may be
///     lowered into exact offsets when the layout of a Fortran derived type is
///     known at compile-time. The type of a field value is `!fir.field` and
///     these values can be used with the `fir.coordinate_of`, `fir.extract_value`,
///     or `fir.insert_value` instructions to compute (abstract) addresses of
///     subobjects.
/// 
///     ```
///       %f = fir.field_index field, !fir.type<X{field:i32}>
///     ```
class FieldIndexOp;

} // namespace fir
namespace fir {

/// the end instruction
/// The end terminator is a special terminator used inside various FIR
///     operations that have regions.  End is thus the custom invisible terminator
///     for these operations.  It is implicit and need not appear in the textual
///     representation.
class FirEndOp;

} // namespace fir
namespace fir {

/// free a heap object
/// Deallocates a heap memory reference that was allocated by an `allocmem`.
///     The memory object that is deallocated is placed in an undefined state
///     after `fir.freemem`.  Optimizations may treat the loading of an object
///     in the undefined state as undefined behavior.  This includes aliasing
///     references, such as the result of an `fir.embox`.
/// 
///     ```
///       %21 = fir.allocmem !fir.type<ZT(p:i32){field:i32}>
///       ...
///       fir.freemem %21 : !fir.heap<!fir.type<ZT>>
///     ```
class FreeMemOp;

} // namespace fir
namespace fir {

/// map a LEN parameter to a global
/// A global entity (that is not an automatic data object) can have extra LEN
///     parameter (compile-time) constants associated with the instance's type.
///     These values can be bound to the global instance used `fir.global_len`.
/// 
///     ```
///       global @g : !fir.type<t(len1:i32)> {
///         fir.global_len len1, 10 : i32
///         %1 = fir.undefined !fir.type<t(len1:i32)>
///         fir.has_value %1 : !fir.type<t(len1:i32)>
///       }
///     ```
class GlobalLenOp;

} // namespace fir
namespace fir {

/// Global data
/// A global variable or constant with initial values.
/// 
///     The example creates a global variable (writable) named
///     `@_QV_Mquark_Vvarble` with some initial values. The initializer should
///     conform to the variable's type.
/// 
///     ```
///       fir.global @_QV_Mquark_Vvarble : tuple<i32, f32> {
///         %1 = arith.constant 1 : i32
///         %2 = arith.constant 2.0 : f32
///         %3 = fir.undefined tuple<i32, f32>
///         %z = arith.constant 0 : index
///         %o = arith.constant 1 : index
///         %4 = fir.insert_value %3, %1, %z : (tuple<i32, f32>, i32, index) -> tuple<i32, f32>
///         %5 = fir.insert_value %4, %2, %o : (tuple<i32, f32>, f32, index) -> tuple<i32, f32>
///         fir.has_value %5 : tuple<i32, f32>
///       }
///     ```
class GlobalOp;

} // namespace fir
namespace fir {

/// terminator for GlobalOp
/// The terminator for a GlobalOp with a body.
/// 
///     ```
///       global @variable : tuple<i32, f32> {
///         %0 = arith.constant 45 : i32
///         %1 = arith.constant 100.0 : f32
///         %2 = fir.undefined tuple<i32, f32>
///         %3 = arith.constant 0 : index
///         %4 = fir.insert_value %2, %0, %3 : (tuple<i32, f32>, i32, index) -> tuple<i32, f32>
///         %5 = arith.constant 1 : index
///         %6 = fir.insert_value %4, %1, %5 : (tuple<i32, f32>, f32, index) -> tuple<i32, f32>
///         fir.has_value %6 : tuple<i32, f32>
///       }
///     ```
class HasValueOp;

} // namespace fir
namespace fir {

/// if-then-else conditional operation
/// Used to conditionally execute operations. This operation is the FIR
///     dialect's version of `loop.if`.
/// 
///     ```
///       %56 = ... : i1
///       %78 = ... : !fir.ref<!T>
///       fir.if %56 {
///         fir.store %76 to %78 : !fir.ref<!T>
///       } else {
///         fir.store %77 to %78 : !fir.ref<!T>
///       }
///     ```
class IfOp;

} // namespace fir
namespace fir {

/// insert sub-value into a range on an existing sequence
/// Insert copies of a value into an entity with an array type of constant shape
///     and size.
///     Returns a new ssa-value with the same type as the original entity.
///     The values are inserted at a contiguous range of indices in Fortran
///     row-to-column element order as specified by lower and upper bound
///     coordinates.
/// 
///     ```
///       %a = fir.undefined !fir.array<10x10xf32>
///       %c = arith.constant 3.0 : f32
///       %1 = fir.insert_on_range %a, %c from (0, 0) to (7, 2) : (!fir.array<10x10xf32>, f32) -> !fir.array<10x10xf32>
///     ```
/// 
///     The first 28 elements of %1, with coordinates from (0,0) to (7,2), have
///     the value 3.0.
class InsertOnRangeOp;

} // namespace fir
namespace fir {

/// insert a new sub-value into a copy of an existing aggregate
/// Insert a value into an entity with a type composed of tuples, arrays,
///     and/or derived types. Returns a new ssa-value with the same type as the
///     original entity. Cannot be used on values of `!fir.box` type.
///     It can also be used to set complex parts and elements of a character
///     string.
/// 
///     Note that the entity ssa-value must be of compile-time known size in order
///     to use this operation.
/// 
///     ```
///       %a = ... : !fir.array<10xtuple<i32, f32>>
///       %f = ... : f32
///       %o = ... : i32
///       %c = arith.constant 1 : i32
///       %b = fir.insert_value %a, %f, %o, %c : (!fir.array<10x20xtuple<i32, f32>>, f32, i32, i32) -> !fir.array<10x20xtuple<i32, f32>>
///     ```
class InsertValueOp;

} // namespace fir
namespace fir {

/// is value the assumed-size last extent sentinel
/// Returns true iff the given integer equals the assumed-size extent sentinel.
/// 
///     ```
///       %t = fir.is_assumed_size_extent %v : (index) -> i1
///       %c = fir.is_assumed_size_extent %x : (i32) -> i1
///     ```
class IsAssumedSizeExtentOp;

} // namespace fir
namespace fir {

/// detect if a boxed value is an assumed-size array
/// Fir box SSA values may describe assumed-size arrays. This operation
///     allows detecting this, even for assumed-rank box.
/// 
///     ```
///       %a = fir.is_assumed_size %b : (!fir.box<!fir.array<*:f64>>) -> i1
///     ```
class IsAssumedSizeOp;

} // namespace fir
namespace fir {

/// Returns true if the boxed entity is contiguous
/// Returns true iff the boxed entity is contiguous:
///       * in the leading dimension (if `innermost` attribute is set),
///       * in all dimensions (if `innermost` attribute is not set).
/// 
///     The input box cannot be absent.
class IsContiguousBoxOp;

} // namespace fir
namespace fir {

/// is this optional function argument present?
/// Determine if an optional function argument is PRESENT (i.e. that it was not
///     created by a fir.absent op on the caller side).
///     ```
///       func @_QPfoo(%arg0: !fir.box<!fir.array<?xf32>>) {
///         %0 = fir.is_present %arg0 : (!fir.box<!fir.array<?xf32>>) -> i1
///         ...
///     ```
class IsPresentOp;

} // namespace fir
namespace fir {

/// DO loop with early exit condition
/// This single-entry, single-exit looping construct is useful for lowering
///     counted loops that can exit early such as, for instance, implied-DO loops.
///     It is very similar to `fir::DoLoopOp` with the addition that it requires
///     a single loop-carried bool value that signals an early exit condition to
///     the operation. A `true` disposition means the next loop iteration should
///     proceed. A `false` indicates that the `fir.iterate_while` operation should
///     terminate and return its iteration arguments. This is a degenerate counted
///     loop in that the loop is not guaranteed to execute all iterations.
/// 
///     An example iterate_while that returns the counter value, the early
///     termination condition, and an extra loop-carried value is shown here. This
///     loop counts from %lo to %up (inclusive), stepping by %c1, so long as the
///     early exit (%ok) is true. The iter_args %sh value is also carried by the
///     loop. The result triple is the values of %i=phi(%lo,%i+%c1),
///     %ok=phi(%okIn,%okNew), and %sh=phi(%shIn,%shNew) from the last executed
///     iteration.
/// 
///     ```
///       %v:3 = fir.iterate_while (%i = %lo to %up step %c1) and (%ok = %okIn) iter_args(%sh = %shIn) -> (index, i1, i16) {
///         %shNew = fir.call @bar(%sh) : (i16) -> i16
///         %okNew = fir.call @foo(%sh) : (i16) -> i1
///         fir.result %i, %okNew, %shNew : index, i1, i16
///       }
///     ```
class IterWhileOp;

} // namespace fir
namespace fir {

/// create a field index value from a LEN type parameter identifier
/// Generate a LEN parameter (offset) value from a LEN parameter identifier.
///     The type of a LEN parameter value is `!fir.len` and these values can be
///     used with the `fir.coordinate_of` instructions to compute (abstract)
///     addresses of LEN parameters.
/// 
///     ```
///       %e = fir.len_param_index len1, !fir.type<X(len1:i32)>
///       %p = ... : !fir.box<!fir.type<X>>
///       %q = fir.coordinate_of %p, %e : (!fir.box<!fir.type<X>>, !fir.len) -> !fir.ref<i32>
///     ```
class LenParamIndexOp;

} // namespace fir
namespace fir {

/// load a value from a memory reference
/// Load a value from a memory reference into an ssa-value (virtual register).
///     Produces an immutable ssa-value of the referent type. A memory reference
///     has type `!fir.ref<T>`, `!fir.heap<T>`, or `!fir.ptr<T>`.
/// 
///     ```
///       %a = fir.alloca i32
///       %l = fir.load %a : !fir.ref<i32>
///     ```
/// 
///     The ssa-value has an undefined value if the memory reference is undefined
///     or null.
class LoadOp;

} // namespace fir
namespace fir {

/// Provides declaration of local and local_init logic.
/// This operation provides a declaration of how to implement the
///     localization of a variable. The dialect users should provide
///     which type should be allocated for this variable. The allocated (usually by
///     alloca) variable is passed to the initialization region which does everything
///     else (e.g. initialization of Fortran runtime descriptors). Information about
///     how to initialize the copy from the original item should be given in the
///     copy region, and if needed, how to deallocate memory (allocated by the
///     initialization region) in the dealloc region.
/// 
///     Examples:
/// 
///     * `local(x)` would not need any regions because no initialization is
///       required by the standard for i32 variables and this is not local_init.
///     ```
///     fir.local {type = local} @x.localizer : i32
///     ```
/// 
///     * `local_init(x)` would be emitted as:
///     ```
///     fir.local {type = local_init} @x.localizer : i32 copy {
///     ^bb0(%arg0: !fir.ref<i32>, %arg1: !fir.ref<i32>):
///     // %arg0 is the original host variable.
///     // %arg1 represents the memory allocated for this private variable.
///     ... copy from host to the localized clone ....
///     fir.yield(%arg1 : !fir.ref<i32>)
///     }
///     ```
/// 
///     * `local(x)` for "allocatables" would be emitted as:
///     ```
///     fir.local {type = local} @x.localizer : !some.type init {
///     ^bb0(%arg0: !fir.ref<!some.type>, %arg1: !fir.ref<!some.type>):
///     // initialize %arg1, using %arg0 as a mold for allocations.
///     // For example if %arg0 is a heap allocated array with a runtime determined
///     // length and !some.type is a runtime type descriptor, the init region
///     // will read the array length from %arg0, and heap allocate an array of the
///     // right length and initialize %arg1 to contain the array allocation and
///     // length.
///     fir.yield(%arg1 : !fir.ref<!some.type>)
///     } dealloc {
///     ^bb0(%arg0: !fir.ref<!some.type>):
///     // ... deallocate memory allocated by the init region...
///     // In the example above, this will free the heap allocated array data.
///     fir.yield
///     }
///     ```
/// 
///     There are no restrictions on the body except for:
///     - The `dealloc` regions has a single argument.
///     - The `init` & `copy` regions have 2 arguments.
///     - All three regions are terminated by `fir.yield` ops.
///     The above restrictions and other obvious restrictions (e.g. verifying the
///     type of yielded values) are verified by the custom op verifier. The actual
///     contents of the blocks inside all regions are not verified.
/// 
///     Instances of this op would then be used by ops that model directives that
///     accept data-sharing attribute clauses.
/// 
///     The `sym_name` attribute provides a symbol by which the privatizer op can be
///     referenced by other dialect ops.
/// 
///     The `type` attribute is the type of the value being localized. This type
///     will be implicitly allocated in MLIR->LLVMIR conversion and passed as the
///     second argument to the init region. Therefore the type of arguments to
///     the regions should be a type which represents a pointer to `type`.
/// 
///     The `locality_specifier_type` attribute specifies whether the localized
///     corresponds to a `local` or a `local_init` specifier.
class LocalitySpecifierOp;

} // namespace fir
namespace fir {

class MulcOp;

} // namespace fir
namespace fir {

class NegcOp;

} // namespace fir
namespace fir {

/// synthetic op to prevent reassociation
/// Primitive operation meant to intrusively prevent operator reassociation.
///     The operation is otherwise a nop and the value returned is the same as the
///     argument.
/// 
///     The presence of this operation prevents any local optimizations. In the
///     example below, this would prevent possibly replacing the multiply and add
///     operations with a single FMA operation.
/// 
///     ```
///       %98 = arith.mulf %96, %97 : f32
///       %99 = fir.no_reassoc %98 : f32
///       %a0 = arith.addf %99, %95 : f32
///     ```
class NoReassocOp;

} // namespace fir
namespace fir {

/// Pack non-contiguous array into a temporary
/// The operation creates a new !fir.box/class<!fir.array<>> value
///     to represent either the original array or a newly allocated
///     temporary array, maybe identical to the original array by value.
/// 
///     Arguments:
///       - array is the original array.
///         It must have !fir.box/class<!fir.array<>> type.
///       - stack/heap attribute indicates where the temporary array
///         needs to be allocated.
///       - innermost/whole attribute identifies the contiguity mode.
///         innermost means that the repacking has to be done iff the original
///         array is not contiguous in the leading dimension.
///         whole means that the repacking has to be done iff the original
///         array is not contiguous in any dimension.
///         innermost is disallowed for 1D arrays in favor of whole.
///       - no_copy attribute indicates that the original array
///         is not copied into the temporary.
///       - typeparams specify the length parameters of the original array.
///         Even though the array is fully represented with a box, the explicit
///         length parameters might be specified to simplify computing
///         the size of the array's element in compilation time (e.g. constant
///         length parameters might be propagated after MLIR inlining).
///       - optional constraints attributes:
///         * max_size is an unsigned integer attribute specifying the maximum
///           byte size of an array that is eligible for repacking.
///         * max_element_size is an unsigned integer attribute specifying
///           the maximum byte element-size of an array that is eligible
///           for repacking.
///         * min_stride is an unsigned integer attribute specifying
///           the minimum byte stride of the innermost dimension of an array
///           that is eligible for repacking.
///       - heuristics attribute specifies conditions when the array repacking
///         may be optimized.
///       - is_safe is an optional non-empty array of SafeTempArrayCopyAttr
///         attributes. Each attribute implements SafeTempArrayCopyAttrInterface
///         that is used to generate a dynamic predicate value identifying
///         whether the creation of the temporary array copy is safe.
///         For example, if omp.fortran_safe_temp_array_copy attribute
///         is attached, its implementation may generate special code
///         to check if fir.pack_array may be executed by multiple
///         threads, and disallow repacking in this case.
class PackArrayOp;

} // namespace fir
namespace fir {

/// prefetch a memory reference
/// The prefetch is a hint to the code generator that the memory reference will
///     be used in the near future. The prefetch is not guaranteed to be executed.
/// 
///     ```
///       %a = ... -> !fir.ref<i32>
///       fir.prefetch %a {read, data, localityHint = 3 : i32} : !fir.ref<i32>
///       // ...
///       fir.load %a : !fir.ref<i32> // use the prefetched value
///     ```
///     Here,
///     `memref'      : address to be prefetched
///     `rw'          : rw specifier >
///                      represented as read (default) or write with values
///                      0 and 1, respectively
///     `localityHint': temporal locality specifier >
///                      value ranging from 0 - no locality to 3 - extremely local
///     `cacheType'   : cache type specifier >
///                      represented as instruction or data (default) with values
///                      0 and 1, respectively
class PrefetchOp;

} // namespace fir
namespace fir {

/// create an assumed-rank box given another assumed-rank box
/// Limited version of fir.rebox for assumed-rank. Only the lower bounds,
///     attribute, and element type may change.
/// 
///     The input may be a box or a reference to a box, in which case the operation
///     reads the incoming reference.
///     Since a fir.shift cannot be built without knowing the rank statically,
///     lower bound changes are encoded via a LowerBoundModifierAttribute.
///     Attribute and element type change are encoded in the result type.
///     Changing the element type is only allowed if the input type is a derived
///     type that extends the output element type.
/// 
///     Example:
///     ```
///       fir.rebox_assumed_rank %1 lbs zeroes : (!fir.box<!fir.array<*:f32>>) -> !fir.box<!fir.array<*:f32>>
///     ```
class ReboxAssumedRankOp;

} // namespace fir
namespace fir {

/// create a box given another box and (optional) dimension information
/// Create a new boxed reference value from another box. This is meant to be
///     used when the taking a reference to part of a boxed value, or to an entire
///     boxed value with new shape or type information.
/// 
///     The new extra information can be:
///       - new shape information (new lower bounds, new rank, or new extents.
///         New rank/extents can only be provided if the original fir.box is
///         contiguous in all dimension but maybe the first row). The shape
///         operand must be provided to set new shape information.
///       - new type (only for derived types). It is possible to set the dynamic
///         type of the new box to one of the parent types of the input box dynamic
///         type. Type parameters cannot be changed. This change is reflected in
///         the requested result type of the new box.
/// 
///     A slice argument can be provided to build a reference to part of a boxed
///     value. In this case, the shape operand must be absent or be a fir.shift
///     that can be used to provide a non default origin for the slice.
/// 
///     The following example illustrates creating a fir.box for x(10:33:2)
///     where x is described by a fir.box and has non default lower bounds,
///     and then applying a new 2-dimension shape to this fir.box.
/// 
///     ```
///       %0 = fir.slice %c10, %c33, %c2 : (index, index, index) -> !fir.slice<1>
///       %1 = fir.shift %c0 : (index) -> !fir.shift<1>
///       %2 = fir.rebox %x(%1) [%0] : (!fir.box<!fir.array<?xf32>>, !fir.shift<1>, !fir.slice<1>) -> !fir.box<!fir.array<?xf32>>
///       %3 = fir.shape %c3, %c4 : (index, index) -> !fir.shape<2>
///       %4 = fir.rebox %2(%3) : (!fir.box<!fir.array<?xf32>>, !fir.shape<2>) -> !fir.box<!fir.array<?x?xf32>>
///     ```
class ReboxOp;

} // namespace fir
namespace fir {

/// special terminator for use in fir region operations
/// Result takes a list of ssa-values produced in the block and forwards them
///     as a result to the operation that owns the region of the block. The
///     operation can retain the values or return them to its parent block
///     depending upon its semantics.
class ResultOp;

} // namespace fir
namespace fir {

/// save an array, box, or record function result SSA-value to a memory location
/// Save the result of a function returning an array, box, or record type value
///     into a memory location given the shape and LEN parameters of the result.
/// 
///     Function results of type fir.box, fir.array, or fir.rec are abstract values
///     that require a storage to be manipulated on the caller side. This operation
///     allows associating such abstract result to a storage. In later lowering of
///     the function interfaces, this storage might be used to pass the result in
///     memory.
/// 
///     For arrays, result, it is required to provide the shape of the result. For
///     character arrays and derived types with LEN parameters, the LEN parameter
///     values must be provided.
/// 
///     The fir.save_result associated to a function call must immediately follow
///     the call and be in the same block.
/// 
///     ```
///       %buffer = fir.alloca fir.array<?xf32>, %c100
///       %shape = fir.shape %c100
///       %array_result = fir.call @foo() : () -> fir.array<?xf32>
///       fir.save_result %array_result to %buffer(%shape)
///       %coor = fir.array_coor %buffer%(%shape), %c5
///       %fifth_element = fir.load %coor : f32
///     ```
/// 
///     The above fir.save_result allows saving a fir.array function result into
///     a buffer to later access its 5th element.
class SaveResultOp;

} // namespace fir
namespace fir {

/// Fortran's SELECT CASE statement
/// Similar to `select`, `select_case` provides a way to express Fortran's
///     SELECT CASE construct.  In this case, the selector value is matched
///     against variables (not just constants) and ranges.  The structure is
///     the same as `select`, but `select_case` allows for the expression of
///     more complex match conditions.
/// 
///     ```
///       fir.select_case %arg : i32 [
///             #fir.point, %0, ^bb1(%0 : i32),
///             #fir.lower, %1, ^bb2(%2,%arg,%arg2,%1 : i32,i32,i32,i32),
///             #fir.interval, %2, %3, ^bb3(%2,%arg2 : i32,i32),
///             #fir.upper, %arg, ^bb4(%1 : i32),
///             unit, ^bb5]
///     ```
class SelectCaseOp;

} // namespace fir
namespace fir {

/// a multiway branch
/// A multiway branch terminator with similar semantics to C's `switch`
///     statement.  A selector value is matched against a list of constants
///     of the same type for a match.  When a match is found, control is
///     transferred to the corresponding basic block.  A `select` must have
///     at least one basic block with a corresponding `unit` match, and
///     that block will be selected when all other conditions fail to match.
/// 
///     ```
///       fir.select %arg:i32 [1, ^bb1(%0 : i32),
///                            2, ^bb2(%2,%arg,%arg2 : i32,i32,i32),
///                           -3, ^bb3(%arg2,%2 : i32,i32),
///                            4, ^bb4(%1 : i32),
///                         unit, ^bb5]
///     ```
class SelectOp;

} // namespace fir
namespace fir {

/// Fortran's SELECT RANK statement
/// Similar to `select`, `select_rank` provides a way to express Fortran's
///     SELECT RANK construct.  In this case, the rank of the selector value
///     is matched against constants of integer type.  The structure is the
///     same as `select`, but `select_rank` determines the rank of the selector
///     variable at runtime to determine the best match.
/// 
///     ```
///       fir.select_rank %arg:i32 [1, ^bb1(%0 : i32),
///                                 2, ^bb2(%2,%arg,%arg2 : i32,i32,i32),
///                                 3, ^bb3(%arg2,%2 : i32,i32),
///                                -1, ^bb4(%1 : i32),
///                              unit, ^bb5]
///     ```
class SelectRankOp;

} // namespace fir
namespace fir {

/// Fortran's SELECT TYPE statement
/// Similar to `select`, `select_type` provides a way to express Fortran's
///     SELECT TYPE construct.  In this case, the type of the selector value
///     is matched against a list of type descriptors.  The structure is the
///     same as `select`, but `select_type` determines the type of the selector
///     variable at runtime to determine the best match.
/// 
///     ```
///       fir.select_type %arg : !fir.box<()> [
///           #fir.type_is<!fir.type<type1>>, ^bb1(%0 : i32),
///           #fir.type_is<!fir.type<type2>>, ^bb2(%2 : i32),
///           #fir.class_is<!fir.type<type3>>, ^bb3(%2 : i32),
///           #fir.type_is<!fir.type<type4>>, ^bb4(%1,%3 : i32,f32),
///           unit, ^bb5]
///     ```
class SelectTypeOp;

} // namespace fir
namespace fir {

/// generate an abstract shape vector of type `!fir.shape`
/// The arguments are an ordered list of integral type values that define the
///     runtime extent of each dimension of an array. The shape information is
///     given in the same row-to-column order as Fortran. This abstract shape value
///     must be applied to a reified object, so all shape information must be
///     specified.  The extent must be nonnegative.
/// 
///     ```
///       %d = fir.shape %row_sz, %col_sz : (index, index) -> !fir.shape<2>
///     ```
class ShapeOp;

} // namespace fir
namespace fir {

/// generate an abstract shape and shift vector of type `!fir.shapeshift`
/// The arguments are an ordered list of integral type values that is a multiple
///     of 2 in length. Each such pair is defined as: the lower bound and the
///     extent for that dimension. The shifted shape information is given in the
///     same row-to-column order as Fortran. This abstract shifted shape value must
///     be applied to a reified object, so all shifted shape information must be
///     specified.  The extent must be nonnegative.
/// 
///     ```
///       %d = fir.shape_shift %lo, %extent : (index, index) -> !fir.shapeshift<1>
///     ```
class ShapeShiftOp;

} // namespace fir
namespace fir {

/// generate an abstract shift vector of type `!fir.shift`
/// The arguments are an ordered list of integral type values that define the
///     runtime lower bound of each dimension of an array. The shape information is
///     given in the same row-to-column order as Fortran. This abstract shift value
///     must be applied to a reified object, so all shift information must be
///     specified.
/// 
///     ```
///       %d = fir.shift %row_lb, %col_lb : (index, index) -> !fir.shift<2>
///     ```
class ShiftOp;

} // namespace fir
namespace fir {

/// generate an abstract slice vector of type `!fir.slice`
/// The array slicing arguments are an ordered list of integral type values
///     that must be a multiple of 3 in length.  Each such triple is defined as:
///     the lower bound, the upper bound, and the stride for that dimension, as in
///     Fortran syntax. Both bounds are inclusive. The array slice information is
///     given in the same row-to-column order as Fortran. This abstract slice value
///     must be applied to a reified object, so all slice information must be
///     specified.  The extent must be nonnegative and the stride must not be zero.
/// 
///     ```
///       %d = fir.slice %lo, %hi, %step : (index, index, index) -> !fir.slice<1>
///     ```
/// 
///     To support generalized slicing of Fortran's dynamic derived types, a slice
///     op can be given a component path (narrowing from the product type of the
///     original array to the specific elemental type of the sliced projection).
/// 
///     ```
///       %fld = fir.field_index component, !fir.type<t{...component:ct...}>
///       %d = fir.slice %lo, %hi, %step path %fld :
///           (index, index, index, !fir.field) -> !fir.slice<1>
///     ```
/// 
///     Projections of `!fir.char` type can be further narrowed to invariant
///     substrings.
/// 
///     ```
///       %d = fir.slice %lo, %hi, %step substr %offset, %width :
///           (index, index, index, index, index) -> !fir.slice<1>
///     ```
class SliceOp;

} // namespace fir
namespace fir {

/// store an SSA-value to a memory location
/// Store an ssa-value (virtual register) to a memory reference.  The stored
///     value must be of the same type as the referent type of the memory
///     reference.
/// 
///     ```
///       %v = ... : f64
///       %p = ... : !fir.ptr<f64>
///       fir.store %v to %p : !fir.ptr<f64>
///     ```
/// 
///     The above store changes the value to which the pointer is pointing and not
///     the pointer itself. The operation is undefined if the memory reference,
///     `%p`, is undefined or null.
class StoreOp;

} // namespace fir
namespace fir {

/// create a string literal constant
/// An FIR constant that represents a sequence of characters that correspond
///     to Fortran's CHARACTER type, including a LEN.  We support CHARACTER values
///     of different KINDs (different constant sizes).
/// 
///     ```
///       %1 = fir.string_lit "Hello, World!"(13) : !fir.char<1> // ASCII
///       %2 = fir.string_lit [158, 2345](2) : !fir.char<2>      // Wide chars
///     ```
class StringLitOp;

} // namespace fir
namespace fir {

class SubcOp;

} // namespace fir
namespace fir {

/// get type descriptor for a given type
/// Generates a constant object that is an abstract type descriptor of the
///     specified type.  The meta-type of a type descriptor for the type `T`
///     is `!fir.tdesc<T>`.
/// 
///     ```
///       %t = fir.type_desc !fir.type<> // returns value of !fir.tdesc<!T>
///     ```
class TypeDescOp;

} // namespace fir
namespace fir {

/// Derived type information
/// Define extra information about a !fir.type<> that represents
///     a Fortran derived type.
/// 
///     The optional dispatch table region defines a dispatch table with the derived
///     type type-bound procedures. It contains a list of associations
///     between method identifiers and corresponding `FuncOp` symbols.
///     The ordering of associations in the map is determined by the front end.
/// 
///     The "abstract" flag indicates that this type is an ABSTRACT derived type and
///     that it cannot be instantiated.
/// 
///     The "no_init" flag indicates that this type has no components requiring
///     default initialization (including setting allocatable component to a clean
///     deallocated state).
/// 
///     The "no_destroy" flag indicates that there are no allocatable components
///     that require deallocation.
/// 
///     The "no_final" flag indicates that there are no final methods for this type,
///     for its parents ,or for components.
/// 
///     ```
///       fir.type_info @_QMquuzTfoo abstract noinit nofinal
///         : !fir.type<_QMquuzTfoo{i:i32}> dispatch_table {
///         fir.dt_entry method1, @_QFNMquuzTfooPmethod1AfooR
///         fir.dt_entry method2, @_QFNMquuzTfooPmethod2AfooII
///       }
///     ```
class TypeInfoOp;

} // namespace fir
namespace fir {

/// unbox a boxchar value into a pair value
/// Unboxes a value of `boxchar` type into a pair consisting of a memory
///     reference to the CHARACTER data and the LEN type parameter.
/// 
///     ```
///       %45   = ... : !fir.boxchar<1>
///       %46:2 = fir.unboxchar %45 : (!fir.boxchar<1>) -> (!fir.ref<!fir.char<1>>, i32)
///     ```
class UnboxCharOp;

} // namespace fir
namespace fir {

/// unbox a boxproc value into a pair value
/// Unboxes a value of `boxproc` type into a pair consisting of a procedure
///     pointer and a pointer to a host context.
/// 
///     ```
///       %47   = ... : !fir.boxproc<() -> i32>
///       %48:2 = fir.unboxproc %47 : (!fir.ref<() -> i32>, !fir.ref<tuple<f32, i32>>)
///     ```
class UnboxProcOp;

} // namespace fir
namespace fir {

/// explicit undefined value of some type
/// Constructs an ssa-value of the specified type with an undefined value.
///     This operation is typically created internally by the mem2reg conversion
///     pass. An undefined value can be of any type except `!fir.ref<T>`.
/// 
///     ```
///       %a = fir.undefined !fir.array<10 x !fir.type<T>>
///     ```
/// 
///     The example creates an array shaped ssa-value. The array is rank 1, extent
///     10, and each element has type `!fir.type<T>`.
class UndefOp;

} // namespace fir
namespace fir {

/// Unpack values from temporary array into original array
/// The operation is either a no-op or deallocates the temporary array,
///     and maybe copies the temporary array into the original array.
/// 
///     Arguments:
///       - temp is a fir.box/fir.class value produced by fir.pack_array.
///         It describes either the original array or the temporary array.
///       - original is the original array descriptor.
///       - stack/heap attribute indicates where the temporary array
///         was allocated.
///       - no_copy attribute indicates that the temporary array
///         is not copied into the original temporary array.
///       - is_safe is an optional non-empty array of SafeTempArrayCopyAttr
///         attributes. Each attribute implements SafeTempArrayCopyAttrInterface
///         that is used to generate extra code before any copy-out or
///         deallocation of the temporary happens.
///         For example, if acc.fortran_safe_temp_array_copy attribute
///         is attached, its implementation may generate special code
///         to check if the temporary has been transferred to OpenACC device
///         data environment, and issue a runtime error that the temporary
///         is present on the device while it is about to be deallocated
///         on the host.
class UnpackArrayOp;

} // namespace fir
namespace fir {

/// the unreachable instruction
/// Terminates a basic block with the assertion that the end of the block
///     will never be reached at runtime.  This instruction can be used
///     immediately after a call to the Fortran runtime to terminate the
///     program, for example.  This instruction corresponds to the LLVM IR
///     instruction `unreachable`.
/// 
///     ```
///       fir.unreachable
///     ```
class UnreachableOp;

} // namespace fir
namespace fir {

/// Represents a Fortran USE statement
/// This operation records a Fortran USE statement with its associated only/rename
///     information. It has no runtime effect but preserves semantic information for
///     debug information generation.
/// 
///     The operation captures:
///     - The module being used (via module_name string)
///     - Symbol references to symbols imported via the ONLY clause (if present)
///     - Symbol renames (local_name and symbol reference)
/// 
///     Examples:
///     ```
///       // USE mod1
///       fir.use_stmt "mod1"
/// 
///       // USE mod1, ONLY: var2
///       fir.use_stmt "mod1" only_symbols [@_QMmod1Evar2]
/// 
///       // USE mod2, var4 => var3
///       fir.use_stmt "mod2" renames [#fir.use_rename<"var4", @_QMmod2Evar3>]
/// 
///       // USE mod2, ONLY: var1, renamed => original
///       fir.use_stmt "mod2" only_symbols [@_QMmod2Evar1]
///                    renames [#fir.use_rename<"renamed", @_QMmod2Eoriginal>]
///     ```
class UseStmtOp;

} // namespace fir
namespace fir {

/// cast between volatile and non-volatile types
/// Cast between volatile and non-volatile types. The types must be otherwise
///     identical. A value's volatility cannot be changed by a fir.convert operation.
///     Reinterpreting a value as volatile must be done explicitly using this operation.
class VolatileCastOp;

} // namespace fir
namespace fir {

/// explicit polymorphic zero value of some type
/// Constructs an ssa-value of the specified type with a value of zero for all
///     bits.
/// 
///     ```
///       %a = fir.zero_bits !fir.box<!fir.array<10 x !fir.type<T>>>
///     ```
/// 
///     The example creates a value of type box where all bits are zero.
class ZeroOp;

} // namespace fir
#ifdef GET_OP_CLASSES
#undef GET_OP_CLASSES

namespace fir {


//===----------------------------------------------------------------------===//
// ::fir::YieldOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class YieldOpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  YieldOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("fir.yield", odsAttrs.getContext());
  }

  YieldOpGenericAdaptorBase(YieldOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize);
  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};

} // namespace detail
template <typename RangeT>
class YieldOpGenericAdaptor : public detail::YieldOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::YieldOpGenericAdaptorBase;
  static constexpr int odsIndex_results = 0;
public:
  YieldOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  YieldOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : YieldOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  YieldOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : YieldOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  YieldOpGenericAdaptor(RangeT values, const YieldOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = YieldOp, typename = std::enable_if_t<std::is_same_v<LateInst, YieldOp>>>
  YieldOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  RangeT getResults() {
    return getODSOperands(0);
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class YieldOpAdaptor : public YieldOpGenericAdaptor<::mlir::ValueRange> {
public:
  using YieldOpGenericAdaptor::YieldOpGenericAdaptor;
  YieldOpAdaptor(YieldOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class YieldOp : public ::mlir::Op<YieldOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::ZeroResults, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::VariadicOperands, ::mlir::OpTrait::HasParent<LocalitySpecifierOp, DeclareReductionOp>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::RegionBranchTerminatorOpInterface::Trait, ::mlir::OpTrait::ReturnLike, ::mlir::OpTrait::IsTerminator> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = YieldOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = YieldOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_results = 0;
  using Properties = FoldAdaptor::Properties;
  using ::mlir::RegionBranchTerminatorOpInterface::Trait<YieldOp>::getSuccessorRegions;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    return {};
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("fir.yield");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index);
  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::Operation::operand_range getResults() {
    return getODSOperands(0);
  }

  ::mlir::MutableOperandRange getResultsMutable();
  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState);
  static YieldOp create(::mlir::OpBuilder &builder, ::mlir::Location location);
  static YieldOp create(::mlir::ImplicitLocOpBuilder &builder);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange results);
  static YieldOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange results);
  static YieldOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange results);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static YieldOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static YieldOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static YieldOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static YieldOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::mlir::MutableOperandRange getMutableSuccessorOperands(::mlir::RegionSuccessor point);
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
public:
};

} // namespace fir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::fir::YieldOp)

namespace fir {


//===----------------------------------------------------------------------===//
// ::fir::AbsentOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class AbsentOpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  AbsentOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("fir.absent", odsAttrs.getContext());
  }

  AbsentOpGenericAdaptorBase(AbsentOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};

} // namespace detail
template <typename RangeT>
class AbsentOpGenericAdaptor : public detail::AbsentOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::AbsentOpGenericAdaptorBase;
public:
  AbsentOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  AbsentOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : AbsentOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  AbsentOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : AbsentOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  AbsentOpGenericAdaptor(RangeT values, const AbsentOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = AbsentOp, typename = std::enable_if_t<std::is_same_v<LateInst, AbsentOp>>>
  AbsentOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class AbsentOpAdaptor : public AbsentOpGenericAdaptor<::mlir::ValueRange> {
public:
  using AbsentOpGenericAdaptor::AbsentOpGenericAdaptor;
  AbsentOpAdaptor(AbsentOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class AbsentOp : public ::mlir::Op<AbsentOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::Type>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::ZeroOperands, ::mlir::OpTrait::OpInvariants, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = AbsentOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = AbsentOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    return {};
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("fir.absent");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getIntype() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, mlir::Type resultType, mlir::ValueRange operands, llvm::ArrayRef<mlir::NamedAttribute> attributes = {});
  static AbsentOp create(::mlir::OpBuilder &builder, ::mlir::Location location, mlir::Type resultType, mlir::ValueRange operands, llvm::ArrayRef<mlir::NamedAttribute> attributes = {});
  static AbsentOp create(::mlir::ImplicitLocOpBuilder &builder, mlir::Type resultType, mlir::ValueRange operands, llvm::ArrayRef<mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type intype);
  static AbsentOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type intype);
  static AbsentOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type intype);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes);
  static AbsentOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes);
  static AbsentOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static AbsentOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static AbsentOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static AbsentOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static AbsentOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
public:
};

} // namespace fir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::fir::AbsentOp)

namespace fir {


//===----------------------------------------------------------------------===//
// ::fir::AddcOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class AddcOpGenericAdaptorBase {
public:
  struct Properties {
    using fastmathTy = ::mlir::arith::FastMathFlagsAttr;
    fastmathTy fastmath;

    auto getFastmath() const {
      auto &propStorage = this->fastmath;
      return ::llvm::dyn_cast_or_null<::mlir::arith::FastMathFlagsAttr>(propStorage);
    }
    void setFastmath(const ::mlir::arith::FastMathFlagsAttr &propValue) {
      this->fastmath = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.fastmath == this->fastmath &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  AddcOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("fir.addc", odsAttrs.getContext());
  }

  AddcOpGenericAdaptorBase(AddcOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::arith::FastMathFlagsAttr getFastmathAttr();
  ::mlir::arith::FastMathFlags getFastmath();
};

} // namespace detail
template <typename RangeT>
class AddcOpGenericAdaptor : public detail::AddcOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::AddcOpGenericAdaptorBase;
  static constexpr int odsIndex_lhs = 0;
  static constexpr int odsIndex_rhs = 1;
public:
  AddcOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  AddcOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : AddcOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  AddcOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : AddcOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  AddcOpGenericAdaptor(RangeT values, const AddcOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = AddcOp, typename = std::enable_if_t<std::is_same_v<LateInst, AddcOp>>>
  AddcOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getLhs() {
    return (*getODSOperands(0).begin());
  }

  ValueT getRhs() {
    return (*getODSOperands(1).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class AddcOpAdaptor : public AddcOpGenericAdaptor<::mlir::ValueRange> {
public:
  using AddcOpGenericAdaptor::AddcOpGenericAdaptor;
  AddcOpAdaptor(AddcOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class AddcOp : public ::mlir::Op<AddcOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::Type>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<2>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::OpTrait::IsCommutative, ::mlir::arith::ArithFastMathInterface::Trait, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::OpTrait::SameOperandsAndResultType, ::mlir::InferTypeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = AddcOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = AddcOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_lhs = 0;
  static constexpr int odsIndex_rhs = 1;
  using Properties = FoldAdaptor::Properties;
  using ::mlir::arith::ArithFastMathInterface::Trait<AddcOp>::getFastMathFlagsAttr;
  using ::mlir::arith::ArithFastMathInterface::Trait<AddcOp>::getFastMathAttrName;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("fastmath")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getFastmathAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getFastmathAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("fir.addc");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getLhs() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::Type> getRhs() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(1).begin());
  }

  ::mlir::OpOperand &getLhsMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getRhsMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getResult() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::arith::FastMathFlagsAttr getFastmathAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::arith::FastMathFlagsAttr>(getProperties().fastmath);
  }

  ::mlir::arith::FastMathFlags getFastmath();
  void setFastmathAttr(::mlir::arith::FastMathFlagsAttr attr) {
    getProperties().fastmath = attr;
  }

  void setFastmath(::mlir::arith::FastMathFlags attrValue);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type result, ::mlir::Value lhs, ::mlir::Value rhs, ::mlir::arith::FastMathFlagsAttr fastmath);
  static AddcOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type result, ::mlir::Value lhs, ::mlir::Value rhs, ::mlir::arith::FastMathFlagsAttr fastmath);
  static AddcOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type result, ::mlir::Value lhs, ::mlir::Value rhs, ::mlir::arith::FastMathFlagsAttr fastmath);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value lhs, ::mlir::Value rhs, ::mlir::arith::FastMathFlagsAttr fastmath);
  static AddcOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value lhs, ::mlir::Value rhs, ::mlir::arith::FastMathFlagsAttr fastmath);
  static AddcOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value lhs, ::mlir::Value rhs, ::mlir::arith::FastMathFlagsAttr fastmath);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value lhs, ::mlir::Value rhs, ::mlir::arith::FastMathFlagsAttr fastmath);
  static AddcOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value lhs, ::mlir::Value rhs, ::mlir::arith::FastMathFlagsAttr fastmath);
  static AddcOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value lhs, ::mlir::Value rhs, ::mlir::arith::FastMathFlagsAttr fastmath);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type result, ::mlir::Value lhs, ::mlir::Value rhs, ::mlir::arith::FastMathFlags fastmath = ::mlir::arith::FastMathFlags::none);
  static AddcOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type result, ::mlir::Value lhs, ::mlir::Value rhs, ::mlir::arith::FastMathFlags fastmath = ::mlir::arith::FastMathFlags::none);
  static AddcOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type result, ::mlir::Value lhs, ::mlir::Value rhs, ::mlir::arith::FastMathFlags fastmath = ::mlir::arith::FastMathFlags::none);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value lhs, ::mlir::Value rhs, ::mlir::arith::FastMathFlags fastmath = ::mlir::arith::FastMathFlags::none);
  static AddcOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value lhs, ::mlir::Value rhs, ::mlir::arith::FastMathFlags fastmath = ::mlir::arith::FastMathFlags::none);
  static AddcOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value lhs, ::mlir::Value rhs, ::mlir::arith::FastMathFlags fastmath = ::mlir::arith::FastMathFlags::none);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value lhs, ::mlir::Value rhs, ::mlir::arith::FastMathFlags fastmath = ::mlir::arith::FastMathFlags::none);
  static AddcOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value lhs, ::mlir::Value rhs, ::mlir::arith::FastMathFlags fastmath = ::mlir::arith::FastMathFlags::none);
  static AddcOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value lhs, ::mlir::Value rhs, ::mlir::arith::FastMathFlags fastmath = ::mlir::arith::FastMathFlags::none);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static AddcOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static AddcOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static AddcOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static AddcOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static AddcOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static AddcOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static AddcOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static AddcOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static void populateDefaultProperties(::mlir::OperationName opName, Properties &properties);
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::llvm::LogicalResult inferReturnTypes(::mlir::MLIRContext *context, ::std::optional<::mlir::Location> location, ::mlir::ValueRange operands, ::mlir::DictionaryAttr attributes, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions, ::llvm::SmallVectorImpl<::mlir::Type>&inferredReturnTypes);
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};

} // namespace fir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::fir::AddcOp)

namespace fir {


//===----------------------------------------------------------------------===//
// ::fir::AddrOfOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class AddrOfOpGenericAdaptorBase {
public:
  struct Properties {
    using symbolTy = ::mlir::SymbolRefAttr;
    symbolTy symbol;

    auto getSymbol() const {
      auto &propStorage = this->symbol;
      return ::llvm::cast<::mlir::SymbolRefAttr>(propStorage);
    }
    void setSymbol(const ::mlir::SymbolRefAttr &propValue) {
      this->symbol = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.symbol == this->symbol &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  AddrOfOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("fir.address_of", odsAttrs.getContext());
  }

  AddrOfOpGenericAdaptorBase(AddrOfOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::SymbolRefAttr getSymbolAttr() {
    auto attr = ::llvm::cast<::mlir::SymbolRefAttr>(getProperties().symbol);
    return attr;
  }

  ::mlir::SymbolRefAttr getSymbol();
};

} // namespace detail
template <typename RangeT>
class AddrOfOpGenericAdaptor : public detail::AddrOfOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::AddrOfOpGenericAdaptorBase;
public:
  AddrOfOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  AddrOfOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : AddrOfOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  AddrOfOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : AddrOfOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  AddrOfOpGenericAdaptor(RangeT values, const AddrOfOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = AddrOfOp, typename = std::enable_if_t<std::is_same_v<LateInst, AddrOfOp>>>
  AddrOfOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class AddrOfOpAdaptor : public AddrOfOpGenericAdaptor<::mlir::ValueRange> {
public:
  using AddrOfOpGenericAdaptor::AddrOfOpGenericAdaptor;
  AddrOfOpAdaptor(AddrOfOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class AddrOfOp : public ::mlir::Op<AddrOfOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::Type>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::ZeroOperands, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = AddrOfOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = AddrOfOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("symbol")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getSymbolAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getSymbolAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("fir.address_of");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getResTy() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::SymbolRefAttr getSymbolAttr() {
    return ::llvm::cast<::mlir::SymbolRefAttr>(getProperties().symbol);
  }

  ::mlir::SymbolRefAttr getSymbol();
  void setSymbolAttr(::mlir::SymbolRefAttr attr) {
    getProperties().symbol = attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, mlir::Type resultType, mlir::ValueRange operands, llvm::ArrayRef<mlir::NamedAttribute> attributes = {});
  static AddrOfOp create(::mlir::OpBuilder &builder, ::mlir::Location location, mlir::Type resultType, mlir::ValueRange operands, llvm::ArrayRef<mlir::NamedAttribute> attributes = {});
  static AddrOfOp create(::mlir::ImplicitLocOpBuilder &builder, mlir::Type resultType, mlir::ValueRange operands, llvm::ArrayRef<mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type resTy, ::mlir::SymbolRefAttr symbol);
  static AddrOfOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type resTy, ::mlir::SymbolRefAttr symbol);
  static AddrOfOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type resTy, ::mlir::SymbolRefAttr symbol);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::SymbolRefAttr symbol);
  static AddrOfOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::SymbolRefAttr symbol);
  static AddrOfOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::SymbolRefAttr symbol);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static AddrOfOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static AddrOfOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static AddrOfOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static AddrOfOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};

} // namespace fir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::fir::AddrOfOp)

namespace fir {


//===----------------------------------------------------------------------===//
// ::fir::AllocMemOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class AllocMemOpGenericAdaptorBase {
public:
  struct Properties {
    using bindc_nameTy = ::mlir::StringAttr;
    bindc_nameTy bindc_name;

    auto getBindcName() const {
      auto &propStorage = this->bindc_name;
      return ::llvm::dyn_cast_or_null<::mlir::StringAttr>(propStorage);
    }
    void setBindcName(const ::mlir::StringAttr &propValue) {
      this->bindc_name = propValue;
    }
    using in_typeTy = ::mlir::TypeAttr;
    in_typeTy in_type;

    auto getInType() const {
      auto &propStorage = this->in_type;
      return ::llvm::cast<::mlir::TypeAttr>(propStorage);
    }
    void setInType(const ::mlir::TypeAttr &propValue) {
      this->in_type = propValue;
    }
    using uniq_nameTy = ::mlir::StringAttr;
    uniq_nameTy uniq_name;

    auto getUniqName() const {
      auto &propStorage = this->uniq_name;
      return ::llvm::dyn_cast_or_null<::mlir::StringAttr>(propStorage);
    }
    void setUniqName(const ::mlir::StringAttr &propValue) {
      this->uniq_name = propValue;
    }
    using operandSegmentSizesTy = std::array<int32_t, 2>;
    operandSegmentSizesTy operandSegmentSizes;
    ::llvm::ArrayRef<int32_t> getOperandSegmentSizes() const {
      auto &propStorage = this->operandSegmentSizes;
      return propStorage;
    }
    void setOperandSegmentSizes(::llvm::ArrayRef<int32_t> propValue) {
      auto &propStorage = this->operandSegmentSizes;
      ::llvm::copy(propValue, propStorage.begin());
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.bindc_name == this->bindc_name &&
        rhs.in_type == this->in_type &&
        rhs.uniq_name == this->uniq_name &&
        rhs.operandSegmentSizes == this->operandSegmentSizes &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  AllocMemOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("fir.allocmem", odsAttrs.getContext());
  }

  AllocMemOpGenericAdaptorBase(AllocMemOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize);
  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::TypeAttr getInTypeAttr() {
    auto attr = ::llvm::cast<::mlir::TypeAttr>(getProperties().in_type);
    return attr;
  }

  ::mlir::Type getInType();
  ::mlir::StringAttr getUniqNameAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::StringAttr>(getProperties().uniq_name);
    return attr;
  }

  ::std::optional< ::llvm::StringRef > getUniqName();
  ::mlir::StringAttr getBindcNameAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::StringAttr>(getProperties().bindc_name);
    return attr;
  }

  ::std::optional< ::llvm::StringRef > getBindcName();
};

} // namespace detail
template <typename RangeT>
class AllocMemOpGenericAdaptor : public detail::AllocMemOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::AllocMemOpGenericAdaptorBase;
  static constexpr int odsIndex_typeparams = 0;
  static constexpr int odsIndex_shape = 1;
public:
  AllocMemOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  AllocMemOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : AllocMemOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  AllocMemOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs) : AllocMemOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  AllocMemOpGenericAdaptor(RangeT values, const AllocMemOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = AllocMemOp, typename = std::enable_if_t<std::is_same_v<LateInst, AllocMemOp>>>
  AllocMemOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  RangeT getTypeparams() {
    return getODSOperands(0);
  }

  RangeT getShape() {
    return getODSOperands(1);
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class AllocMemOpAdaptor : public AllocMemOpGenericAdaptor<::mlir::ValueRange> {
public:
  using AllocMemOpGenericAdaptor::AllocMemOpGenericAdaptor;
  AllocMemOpAdaptor(AllocMemOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class AllocMemOp : public ::mlir::Op<AllocMemOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::fir::HeapType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::VariadicOperands, ::mlir::OpTrait::AttrSizedOperandSegments, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = AllocMemOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = AllocMemOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_typeparams = 0;
  static constexpr int odsIndex_shape = 1;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("bindc_name"), ::llvm::StringRef("in_type"), ::llvm::StringRef("uniq_name"), ::llvm::StringRef("operandSegmentSizes")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getBindcNameAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getBindcNameAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getInTypeAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getInTypeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  ::mlir::StringAttr getUniqNameAttrName() {
    return getAttributeNameForIndex(2);
  }

  static ::mlir::StringAttr getUniqNameAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 2);
  }

  ::mlir::StringAttr getOperandSegmentSizesAttrName() {
   return (*this)->getName().getAttributeNames().back();
  }

  static ::mlir::StringAttr getOperandSegmentSizesAttrName(::mlir::OperationName name) {
   return name.getAttributeNames().back();
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("fir.allocmem");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index);
  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::Operation::operand_range getTypeparams() {
    return getODSOperands(0);
  }

  ::mlir::Operation::operand_range getShape() {
    return getODSOperands(1);
  }

  ::mlir::MutableOperandRange getTypeparamsMutable();
  ::mlir::MutableOperandRange getShapeMutable();
  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::fir::HeapType> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::fir::HeapType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::TypeAttr getInTypeAttr() {
    return ::llvm::cast<::mlir::TypeAttr>(getProperties().in_type);
  }

  ::mlir::Type getInType();
  ::mlir::StringAttr getUniqNameAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::StringAttr>(getProperties().uniq_name);
  }

  ::std::optional< ::llvm::StringRef > getUniqName();
  ::mlir::StringAttr getBindcNameAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::StringAttr>(getProperties().bindc_name);
  }

  ::std::optional< ::llvm::StringRef > getBindcName();
  void setInTypeAttr(::mlir::TypeAttr attr) {
    getProperties().in_type = attr;
  }

  void setInType(::mlir::Type attrValue);
  void setUniqNameAttr(::mlir::StringAttr attr) {
    getProperties().uniq_name = attr;
  }

  void setUniqName(::std::optional<::llvm::StringRef> attrValue);
  void setBindcNameAttr(::mlir::StringAttr attr) {
    getProperties().bindc_name = attr;
  }

  void setBindcName(::std::optional<::llvm::StringRef> attrValue);
  ::mlir::Attribute removeUniqNameAttr() {
      auto attr = getProperties().uniq_name;
      getProperties().uniq_name = {};
      return attr;
  }

  ::mlir::Attribute removeBindcNameAttr() {
      auto attr = getProperties().bindc_name;
      getProperties().bindc_name = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, mlir::Type in_type, llvm::StringRef uniq_name, llvm::StringRef bindc_name, mlir::ValueRange typeparams = {}, mlir::ValueRange shape = {}, llvm::ArrayRef<mlir::NamedAttribute> attributes = {});
  static AllocMemOp create(::mlir::OpBuilder &builder, ::mlir::Location location, mlir::Type in_type, llvm::StringRef uniq_name, llvm::StringRef bindc_name, mlir::ValueRange typeparams = {}, mlir::ValueRange shape = {}, llvm::ArrayRef<mlir::NamedAttribute> attributes = {});
  static AllocMemOp create(::mlir::ImplicitLocOpBuilder &builder, mlir::Type in_type, llvm::StringRef uniq_name, llvm::StringRef bindc_name, mlir::ValueRange typeparams = {}, mlir::ValueRange shape = {}, llvm::ArrayRef<mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, mlir::Type in_type, llvm::StringRef uniq_name, mlir::ValueRange typeparams = {}, mlir::ValueRange shape = {}, llvm::ArrayRef<mlir::NamedAttribute> attributes = {});
  static AllocMemOp create(::mlir::OpBuilder &builder, ::mlir::Location location, mlir::Type in_type, llvm::StringRef uniq_name, mlir::ValueRange typeparams = {}, mlir::ValueRange shape = {}, llvm::ArrayRef<mlir::NamedAttribute> attributes = {});
  static AllocMemOp create(::mlir::ImplicitLocOpBuilder &builder, mlir::Type in_type, llvm::StringRef uniq_name, mlir::ValueRange typeparams = {}, mlir::ValueRange shape = {}, llvm::ArrayRef<mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, mlir::Type in_type, mlir::ValueRange typeparams = {}, mlir::ValueRange shape = {}, llvm::ArrayRef<mlir::NamedAttribute> attributes = {});
  static AllocMemOp create(::mlir::OpBuilder &builder, ::mlir::Location location, mlir::Type in_type, mlir::ValueRange typeparams = {}, mlir::ValueRange shape = {}, llvm::ArrayRef<mlir::NamedAttribute> attributes = {});
  static AllocMemOp create(::mlir::ImplicitLocOpBuilder &builder, mlir::Type in_type, mlir::ValueRange typeparams = {}, mlir::ValueRange shape = {}, llvm::ArrayRef<mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::TypeAttr in_type, /*optional*/::mlir::StringAttr uniq_name, /*optional*/::mlir::StringAttr bindc_name, ::mlir::ValueRange typeparams, ::mlir::ValueRange shape);
  static AllocMemOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::TypeAttr in_type, /*optional*/::mlir::StringAttr uniq_name, /*optional*/::mlir::StringAttr bindc_name, ::mlir::ValueRange typeparams, ::mlir::ValueRange shape);
  static AllocMemOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::TypeAttr in_type, /*optional*/::mlir::StringAttr uniq_name, /*optional*/::mlir::StringAttr bindc_name, ::mlir::ValueRange typeparams, ::mlir::ValueRange shape);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::TypeAttr in_type, /*optional*/::mlir::StringAttr uniq_name, /*optional*/::mlir::StringAttr bindc_name, ::mlir::ValueRange typeparams, ::mlir::ValueRange shape);
  static AllocMemOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::TypeAttr in_type, /*optional*/::mlir::StringAttr uniq_name, /*optional*/::mlir::StringAttr bindc_name, ::mlir::ValueRange typeparams, ::mlir::ValueRange shape);
  static AllocMemOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::TypeAttr in_type, /*optional*/::mlir::StringAttr uniq_name, /*optional*/::mlir::StringAttr bindc_name, ::mlir::ValueRange typeparams, ::mlir::ValueRange shape);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Type in_type, /*optional*/::mlir::StringAttr uniq_name, /*optional*/::mlir::StringAttr bindc_name, ::mlir::ValueRange typeparams, ::mlir::ValueRange shape);
  static AllocMemOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Type in_type, /*optional*/::mlir::StringAttr uniq_name, /*optional*/::mlir::StringAttr bindc_name, ::mlir::ValueRange typeparams, ::mlir::ValueRange shape);
  static AllocMemOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Type in_type, /*optional*/::mlir::StringAttr uniq_name, /*optional*/::mlir::StringAttr bindc_name, ::mlir::ValueRange typeparams, ::mlir::ValueRange shape);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Type in_type, /*optional*/::mlir::StringAttr uniq_name, /*optional*/::mlir::StringAttr bindc_name, ::mlir::ValueRange typeparams, ::mlir::ValueRange shape);
  static AllocMemOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Type in_type, /*optional*/::mlir::StringAttr uniq_name, /*optional*/::mlir::StringAttr bindc_name, ::mlir::ValueRange typeparams, ::mlir::ValueRange shape);
  static AllocMemOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Type in_type, /*optional*/::mlir::StringAttr uniq_name, /*optional*/::mlir::StringAttr bindc_name, ::mlir::ValueRange typeparams, ::mlir::ValueRange shape);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static AllocMemOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static AllocMemOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static AllocMemOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static AllocMemOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &p);
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  static ::llvm::LogicalResult setPropertiesFromParsedAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 3 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
  mlir::Type getAllocatedType();
  bool hasLenParams() { return !getTypeparams().empty(); }
  bool hasShapeOperands() { return !getShape().empty(); }
  unsigned numLenParams() { return getTypeparams().size(); }
  operand_range getLenParams() { return getTypeparams(); }
  unsigned numShapeOperands() { return getShape().size(); }
  operand_range getShapeOperands() { return getShape(); }
  static mlir::Type getRefTy(mlir::Type ty);
};

} // namespace fir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::fir::AllocMemOp)

namespace fir {


//===----------------------------------------------------------------------===//
// ::fir::AllocaOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class AllocaOpGenericAdaptorBase {
public:
  struct Properties {
    using bindc_nameTy = ::mlir::StringAttr;
    bindc_nameTy bindc_name;

    auto getBindcName() const {
      auto &propStorage = this->bindc_name;
      return ::llvm::dyn_cast_or_null<::mlir::StringAttr>(propStorage);
    }
    void setBindcName(const ::mlir::StringAttr &propValue) {
      this->bindc_name = propValue;
    }
    using in_typeTy = ::mlir::TypeAttr;
    in_typeTy in_type;

    auto getInType() const {
      auto &propStorage = this->in_type;
      return ::llvm::cast<::mlir::TypeAttr>(propStorage);
    }
    void setInType(const ::mlir::TypeAttr &propValue) {
      this->in_type = propValue;
    }
    using pinnedTy = ::mlir::UnitAttr;
    pinnedTy pinned;

    auto getPinned() const {
      auto &propStorage = this->pinned;
      return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(propStorage);
    }
    void setPinned(const ::mlir::UnitAttr &propValue) {
      this->pinned = propValue;
    }
    using uniq_nameTy = ::mlir::StringAttr;
    uniq_nameTy uniq_name;

    auto getUniqName() const {
      auto &propStorage = this->uniq_name;
      return ::llvm::dyn_cast_or_null<::mlir::StringAttr>(propStorage);
    }
    void setUniqName(const ::mlir::StringAttr &propValue) {
      this->uniq_name = propValue;
    }
    using operandSegmentSizesTy = std::array<int32_t, 2>;
    operandSegmentSizesTy operandSegmentSizes;
    ::llvm::ArrayRef<int32_t> getOperandSegmentSizes() const {
      auto &propStorage = this->operandSegmentSizes;
      return propStorage;
    }
    void setOperandSegmentSizes(::llvm::ArrayRef<int32_t> propValue) {
      auto &propStorage = this->operandSegmentSizes;
      ::llvm::copy(propValue, propStorage.begin());
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.bindc_name == this->bindc_name &&
        rhs.in_type == this->in_type &&
        rhs.pinned == this->pinned &&
        rhs.uniq_name == this->uniq_name &&
        rhs.operandSegmentSizes == this->operandSegmentSizes &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  AllocaOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("fir.alloca", odsAttrs.getContext());
  }

  AllocaOpGenericAdaptorBase(AllocaOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize);
  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::TypeAttr getInTypeAttr() {
    auto attr = ::llvm::cast<::mlir::TypeAttr>(getProperties().in_type);
    return attr;
  }

  ::mlir::Type getInType();
  ::mlir::StringAttr getUniqNameAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::StringAttr>(getProperties().uniq_name);
    return attr;
  }

  ::std::optional< ::llvm::StringRef > getUniqName();
  ::mlir::StringAttr getBindcNameAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::StringAttr>(getProperties().bindc_name);
    return attr;
  }

  ::std::optional< ::llvm::StringRef > getBindcName();
  ::mlir::UnitAttr getPinnedAttr();
  bool getPinned();
};

} // namespace detail
template <typename RangeT>
class AllocaOpGenericAdaptor : public detail::AllocaOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::AllocaOpGenericAdaptorBase;
  static constexpr int odsIndex_typeparams = 0;
  static constexpr int odsIndex_shape = 1;
public:
  AllocaOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  AllocaOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : AllocaOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  AllocaOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs) : AllocaOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  AllocaOpGenericAdaptor(RangeT values, const AllocaOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = AllocaOp, typename = std::enable_if_t<std::is_same_v<LateInst, AllocaOp>>>
  AllocaOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  RangeT getTypeparams() {
    return getODSOperands(0);
  }

  RangeT getShape() {
    return getODSOperands(1);
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class AllocaOpAdaptor : public AllocaOpGenericAdaptor<::mlir::ValueRange> {
public:
  using AllocaOpGenericAdaptor::AllocaOpGenericAdaptor;
  AllocaOpAdaptor(AllocaOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class AllocaOp : public ::mlir::Op<AllocaOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::fir::ReferenceType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::VariadicOperands, ::mlir::OpTrait::AttrSizedOperandSegments, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::PromotableAllocationOpInterface::Trait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = AllocaOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = AllocaOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_typeparams = 0;
  static constexpr int odsIndex_shape = 1;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("bindc_name"), ::llvm::StringRef("in_type"), ::llvm::StringRef("pinned"), ::llvm::StringRef("uniq_name"), ::llvm::StringRef("operandSegmentSizes")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getBindcNameAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getBindcNameAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getInTypeAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getInTypeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  ::mlir::StringAttr getPinnedAttrName() {
    return getAttributeNameForIndex(2);
  }

  static ::mlir::StringAttr getPinnedAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 2);
  }

  ::mlir::StringAttr getUniqNameAttrName() {
    return getAttributeNameForIndex(3);
  }

  static ::mlir::StringAttr getUniqNameAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 3);
  }

  ::mlir::StringAttr getOperandSegmentSizesAttrName() {
   return (*this)->getName().getAttributeNames().back();
  }

  static ::mlir::StringAttr getOperandSegmentSizesAttrName(::mlir::OperationName name) {
   return name.getAttributeNames().back();
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("fir.alloca");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index);
  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::Operation::operand_range getTypeparams() {
    return getODSOperands(0);
  }

  ::mlir::Operation::operand_range getShape() {
    return getODSOperands(1);
  }

  ::mlir::MutableOperandRange getTypeparamsMutable();
  ::mlir::MutableOperandRange getShapeMutable();
  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::fir::ReferenceType> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::fir::ReferenceType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::TypeAttr getInTypeAttr() {
    return ::llvm::cast<::mlir::TypeAttr>(getProperties().in_type);
  }

  ::mlir::Type getInType();
  ::mlir::StringAttr getUniqNameAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::StringAttr>(getProperties().uniq_name);
  }

  ::std::optional< ::llvm::StringRef > getUniqName();
  ::mlir::StringAttr getBindcNameAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::StringAttr>(getProperties().bindc_name);
  }

  ::std::optional< ::llvm::StringRef > getBindcName();
  ::mlir::UnitAttr getPinnedAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(getProperties().pinned);
  }

  bool getPinned();
  void setInTypeAttr(::mlir::TypeAttr attr) {
    getProperties().in_type = attr;
  }

  void setInType(::mlir::Type attrValue);
  void setUniqNameAttr(::mlir::StringAttr attr) {
    getProperties().uniq_name = attr;
  }

  void setUniqName(::std::optional<::llvm::StringRef> attrValue);
  void setBindcNameAttr(::mlir::StringAttr attr) {
    getProperties().bindc_name = attr;
  }

  void setBindcName(::std::optional<::llvm::StringRef> attrValue);
  void setPinnedAttr(::mlir::UnitAttr attr) {
    getProperties().pinned = attr;
  }

  void setPinned(bool attrValue);
  ::mlir::Attribute removeUniqNameAttr() {
      auto attr = getProperties().uniq_name;
      getProperties().uniq_name = {};
      return attr;
  }

  ::mlir::Attribute removeBindcNameAttr() {
      auto attr = getProperties().bindc_name;
      getProperties().bindc_name = {};
      return attr;
  }

  ::mlir::Attribute removePinnedAttr() {
      auto attr = getProperties().pinned;
      getProperties().pinned = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, mlir::Type inType, llvm::StringRef uniqName, llvm::StringRef bindcName, mlir::ValueRange typeparams = {}, mlir::ValueRange shape = {}, llvm::ArrayRef<mlir::NamedAttribute> attributes = {});
  static AllocaOp create(::mlir::OpBuilder &builder, ::mlir::Location location, mlir::Type inType, llvm::StringRef uniqName, llvm::StringRef bindcName, mlir::ValueRange typeparams = {}, mlir::ValueRange shape = {}, llvm::ArrayRef<mlir::NamedAttribute> attributes = {});
  static AllocaOp create(::mlir::ImplicitLocOpBuilder &builder, mlir::Type inType, llvm::StringRef uniqName, llvm::StringRef bindcName, mlir::ValueRange typeparams = {}, mlir::ValueRange shape = {}, llvm::ArrayRef<mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, mlir::Type inType, llvm::StringRef uniqName, llvm::StringRef bindcName, bool pinned, mlir::ValueRange typeparams = {}, mlir::ValueRange shape = {}, llvm::ArrayRef<mlir::NamedAttribute> attributes = {});
  static AllocaOp create(::mlir::OpBuilder &builder, ::mlir::Location location, mlir::Type inType, llvm::StringRef uniqName, llvm::StringRef bindcName, bool pinned, mlir::ValueRange typeparams = {}, mlir::ValueRange shape = {}, llvm::ArrayRef<mlir::NamedAttribute> attributes = {});
  static AllocaOp create(::mlir::ImplicitLocOpBuilder &builder, mlir::Type inType, llvm::StringRef uniqName, llvm::StringRef bindcName, bool pinned, mlir::ValueRange typeparams = {}, mlir::ValueRange shape = {}, llvm::ArrayRef<mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, mlir::Type inType, llvm::StringRef uniqName, mlir::ValueRange typeparams = {}, mlir::ValueRange shape = {}, llvm::ArrayRef<mlir::NamedAttribute> attributes = {});
  static AllocaOp create(::mlir::OpBuilder &builder, ::mlir::Location location, mlir::Type inType, llvm::StringRef uniqName, mlir::ValueRange typeparams = {}, mlir::ValueRange shape = {}, llvm::ArrayRef<mlir::NamedAttribute> attributes = {});
  static AllocaOp create(::mlir::ImplicitLocOpBuilder &builder, mlir::Type inType, llvm::StringRef uniqName, mlir::ValueRange typeparams = {}, mlir::ValueRange shape = {}, llvm::ArrayRef<mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, mlir::Type inType, llvm::StringRef uniqName, bool pinned, mlir::ValueRange typeparams = {}, mlir::ValueRange shape = {}, llvm::ArrayRef<mlir::NamedAttribute> attributes = {});
  static AllocaOp create(::mlir::OpBuilder &builder, ::mlir::Location location, mlir::Type inType, llvm::StringRef uniqName, bool pinned, mlir::ValueRange typeparams = {}, mlir::ValueRange shape = {}, llvm::ArrayRef<mlir::NamedAttribute> attributes = {});
  static AllocaOp create(::mlir::ImplicitLocOpBuilder &builder, mlir::Type inType, llvm::StringRef uniqName, bool pinned, mlir::ValueRange typeparams = {}, mlir::ValueRange shape = {}, llvm::ArrayRef<mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, mlir::Type inType, bool pinned, mlir::ValueRange typeparams = {}, mlir::ValueRange shape = {}, llvm::ArrayRef<mlir::NamedAttribute> attributes = {});
  static AllocaOp create(::mlir::OpBuilder &builder, ::mlir::Location location, mlir::Type inType, bool pinned, mlir::ValueRange typeparams = {}, mlir::ValueRange shape = {}, llvm::ArrayRef<mlir::NamedAttribute> attributes = {});
  static AllocaOp create(::mlir::ImplicitLocOpBuilder &builder, mlir::Type inType, bool pinned, mlir::ValueRange typeparams = {}, mlir::ValueRange shape = {}, llvm::ArrayRef<mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, mlir::Type inType, mlir::ValueRange typeparams = {}, mlir::ValueRange shape = {}, llvm::ArrayRef<mlir::NamedAttribute> attributes = {});
  static AllocaOp create(::mlir::OpBuilder &builder, ::mlir::Location location, mlir::Type inType, mlir::ValueRange typeparams = {}, mlir::ValueRange shape = {}, llvm::ArrayRef<mlir::NamedAttribute> attributes = {});
  static AllocaOp create(::mlir::ImplicitLocOpBuilder &builder, mlir::Type inType, mlir::ValueRange typeparams = {}, mlir::ValueRange shape = {}, llvm::ArrayRef<mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::TypeAttr in_type, /*optional*/::mlir::StringAttr uniq_name, /*optional*/::mlir::StringAttr bindc_name, /*optional*/::mlir::UnitAttr pinned, ::mlir::ValueRange typeparams, ::mlir::ValueRange shape);
  static AllocaOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::TypeAttr in_type, /*optional*/::mlir::StringAttr uniq_name, /*optional*/::mlir::StringAttr bindc_name, /*optional*/::mlir::UnitAttr pinned, ::mlir::ValueRange typeparams, ::mlir::ValueRange shape);
  static AllocaOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::TypeAttr in_type, /*optional*/::mlir::StringAttr uniq_name, /*optional*/::mlir::StringAttr bindc_name, /*optional*/::mlir::UnitAttr pinned, ::mlir::ValueRange typeparams, ::mlir::ValueRange shape);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::TypeAttr in_type, /*optional*/::mlir::StringAttr uniq_name, /*optional*/::mlir::StringAttr bindc_name, /*optional*/::mlir::UnitAttr pinned, ::mlir::ValueRange typeparams, ::mlir::ValueRange shape);
  static AllocaOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::TypeAttr in_type, /*optional*/::mlir::StringAttr uniq_name, /*optional*/::mlir::StringAttr bindc_name, /*optional*/::mlir::UnitAttr pinned, ::mlir::ValueRange typeparams, ::mlir::ValueRange shape);
  static AllocaOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::TypeAttr in_type, /*optional*/::mlir::StringAttr uniq_name, /*optional*/::mlir::StringAttr bindc_name, /*optional*/::mlir::UnitAttr pinned, ::mlir::ValueRange typeparams, ::mlir::ValueRange shape);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Type in_type, /*optional*/::mlir::StringAttr uniq_name, /*optional*/::mlir::StringAttr bindc_name, /*optional*/bool pinned, ::mlir::ValueRange typeparams, ::mlir::ValueRange shape);
  static AllocaOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Type in_type, /*optional*/::mlir::StringAttr uniq_name, /*optional*/::mlir::StringAttr bindc_name, /*optional*/bool pinned, ::mlir::ValueRange typeparams, ::mlir::ValueRange shape);
  static AllocaOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Type in_type, /*optional*/::mlir::StringAttr uniq_name, /*optional*/::mlir::StringAttr bindc_name, /*optional*/bool pinned, ::mlir::ValueRange typeparams, ::mlir::ValueRange shape);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Type in_type, /*optional*/::mlir::StringAttr uniq_name, /*optional*/::mlir::StringAttr bindc_name, /*optional*/bool pinned, ::mlir::ValueRange typeparams, ::mlir::ValueRange shape);
  static AllocaOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Type in_type, /*optional*/::mlir::StringAttr uniq_name, /*optional*/::mlir::StringAttr bindc_name, /*optional*/bool pinned, ::mlir::ValueRange typeparams, ::mlir::ValueRange shape);
  static AllocaOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Type in_type, /*optional*/::mlir::StringAttr uniq_name, /*optional*/::mlir::StringAttr bindc_name, /*optional*/bool pinned, ::mlir::ValueRange typeparams, ::mlir::ValueRange shape);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static AllocaOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static AllocaOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static AllocaOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static AllocaOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &p);
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  ::llvm::SmallVector<::mlir::MemorySlot> getPromotableSlots();
  ::mlir::Value getDefaultValue(const ::mlir::MemorySlot &slot, ::mlir::OpBuilder &builder);
  void handleBlockArgument(const ::mlir::MemorySlot &slot, ::mlir::BlockArgument argument, ::mlir::OpBuilder &builder);
  ::std::optional<::mlir::PromotableAllocationOpInterface> handlePromotionComplete(const ::mlir::MemorySlot &slot, ::mlir::Value defaultValue, ::mlir::OpBuilder &builder);
  static ::llvm::LogicalResult setPropertiesFromParsedAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 4 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
  mlir::Type getAllocatedType();
  bool hasLenParams() { return !getTypeparams().empty(); }
  bool hasShapeOperands() { return !getShape().empty(); }
  bool isDynamic() {return hasLenParams() || hasShapeOperands();}
  unsigned numLenParams() { return getTypeparams().size(); }
  operand_range getLenParams() { return getTypeparams(); }
  unsigned numShapeOperands() { return getShape().size(); }
  operand_range getShapeOperands() { return getShape(); }
  static mlir::Type getRefTy(mlir::Type ty);
  /// Is this an operation that owns the alloca directly made in its region?
  static bool ownsNestedAlloca(mlir::Operation* op);
  /// Get the parent region that owns this alloca. Nullptr if none can be
  /// identified.
  mlir::Region* getOwnerRegion();
};

} // namespace fir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::fir::AllocaOp)

namespace fir {


//===----------------------------------------------------------------------===//
// ::fir::ArrayAccessOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class ArrayAccessOpGenericAdaptorBase {
public:
  struct Properties {
    using operandSegmentSizesTy = std::array<int32_t, 3>;
    operandSegmentSizesTy operandSegmentSizes;
    ::llvm::ArrayRef<int32_t> getOperandSegmentSizes() const {
      auto &propStorage = this->operandSegmentSizes;
      return propStorage;
    }
    void setOperandSegmentSizes(::llvm::ArrayRef<int32_t> propValue) {
      auto &propStorage = this->operandSegmentSizes;
      ::llvm::copy(propValue, propStorage.begin());
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.operandSegmentSizes == this->operandSegmentSizes &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  ArrayAccessOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("fir.array_access", odsAttrs.getContext());
  }

  ArrayAccessOpGenericAdaptorBase(ArrayAccessOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize);
  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};

} // namespace detail
template <typename RangeT>
class ArrayAccessOpGenericAdaptor : public detail::ArrayAccessOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::ArrayAccessOpGenericAdaptorBase;
  static constexpr int odsIndex_sequence = 0;
  static constexpr int odsIndex_indices = 1;
  static constexpr int odsIndex_typeparams = 2;
public:
  ArrayAccessOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  ArrayAccessOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : ArrayAccessOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  ArrayAccessOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs) : ArrayAccessOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  ArrayAccessOpGenericAdaptor(RangeT values, const ArrayAccessOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = ArrayAccessOp, typename = std::enable_if_t<std::is_same_v<LateInst, ArrayAccessOp>>>
  ArrayAccessOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getSequence() {
    return (*getODSOperands(0).begin());
  }

  RangeT getIndices() {
    return getODSOperands(1);
  }

  RangeT getTypeparams() {
    return getODSOperands(2);
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class ArrayAccessOpAdaptor : public ArrayAccessOpGenericAdaptor<::mlir::ValueRange> {
public:
  using ArrayAccessOpGenericAdaptor::ArrayAccessOpGenericAdaptor;
  ArrayAccessOpAdaptor(ArrayAccessOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class ArrayAccessOp : public ::mlir::Op<ArrayAccessOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::fir::ReferenceType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::AtLeastNOperands<1>::Impl, ::mlir::OpTrait::AttrSizedOperandSegments, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = ArrayAccessOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = ArrayAccessOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_sequence = 0;
  static constexpr int odsIndex_indices = 1;
  static constexpr int odsIndex_typeparams = 2;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("operandSegmentSizes")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getOperandSegmentSizesAttrName() {
   return (*this)->getName().getAttributeNames().back();
  }

  static ::mlir::StringAttr getOperandSegmentSizesAttrName(::mlir::OperationName name) {
   return name.getAttributeNames().back();
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("fir.array_access");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index);
  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::fir::SequenceType> getSequence() {
    return ::llvm::cast<::mlir::TypedValue<::fir::SequenceType>>(*getODSOperands(0).begin());
  }

  ::mlir::Operation::operand_range getIndices() {
    return getODSOperands(1);
  }

  ::mlir::Operation::operand_range getTypeparams() {
    return getODSOperands(2);
  }

  ::mlir::OpOperand &getSequenceMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::MutableOperandRange getIndicesMutable();
  ::mlir::MutableOperandRange getTypeparamsMutable();
  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::fir::ReferenceType> getElement() {
    return ::llvm::cast<::mlir::TypedValue<::fir::ReferenceType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type element, ::mlir::Value sequence, ::mlir::ValueRange indices, ::mlir::ValueRange typeparams);
  static ArrayAccessOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type element, ::mlir::Value sequence, ::mlir::ValueRange indices, ::mlir::ValueRange typeparams);
  static ArrayAccessOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type element, ::mlir::Value sequence, ::mlir::ValueRange indices, ::mlir::ValueRange typeparams);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value sequence, ::mlir::ValueRange indices, ::mlir::ValueRange typeparams);
  static ArrayAccessOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value sequence, ::mlir::ValueRange indices, ::mlir::ValueRange typeparams);
  static ArrayAccessOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value sequence, ::mlir::ValueRange indices, ::mlir::ValueRange typeparams);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static ArrayAccessOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static ArrayAccessOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ArrayAccessOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ArrayAccessOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    return {};
  }

public:
};

} // namespace fir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::fir::ArrayAccessOp)

namespace fir {


//===----------------------------------------------------------------------===//
// ::fir::ArrayAmendOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class ArrayAmendOpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  ArrayAmendOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("fir.array_amend", odsAttrs.getContext());
  }

  ArrayAmendOpGenericAdaptorBase(ArrayAmendOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};

} // namespace detail
template <typename RangeT>
class ArrayAmendOpGenericAdaptor : public detail::ArrayAmendOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::ArrayAmendOpGenericAdaptorBase;
  static constexpr int odsIndex_sequence = 0;
  static constexpr int odsIndex_memref = 1;
public:
  ArrayAmendOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  ArrayAmendOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : ArrayAmendOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  ArrayAmendOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : ArrayAmendOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  ArrayAmendOpGenericAdaptor(RangeT values, const ArrayAmendOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = ArrayAmendOp, typename = std::enable_if_t<std::is_same_v<LateInst, ArrayAmendOp>>>
  ArrayAmendOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getSequence() {
    return (*getODSOperands(0).begin());
  }

  ValueT getMemref() {
    return (*getODSOperands(1).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class ArrayAmendOpAdaptor : public ArrayAmendOpGenericAdaptor<::mlir::ValueRange> {
public:
  using ArrayAmendOpGenericAdaptor::ArrayAmendOpGenericAdaptor;
  ArrayAmendOpAdaptor(ArrayAmendOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class ArrayAmendOp : public ::mlir::Op<ArrayAmendOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::fir::SequenceType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<2>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = ArrayAmendOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = ArrayAmendOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_sequence = 0;
  static constexpr int odsIndex_memref = 1;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    return {};
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("fir.array_amend");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::fir::SequenceType> getSequence() {
    return ::llvm::cast<::mlir::TypedValue<::fir::SequenceType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::fir::ReferenceType> getMemref() {
    return ::llvm::cast<::mlir::TypedValue<::fir::ReferenceType>>(*getODSOperands(1).begin());
  }

  ::mlir::OpOperand &getSequenceMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getMemrefMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type resultType0, ::mlir::Value sequence, ::mlir::Value memref);
  static ArrayAmendOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type resultType0, ::mlir::Value sequence, ::mlir::Value memref);
  static ArrayAmendOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type resultType0, ::mlir::Value sequence, ::mlir::Value memref);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value sequence, ::mlir::Value memref);
  static ArrayAmendOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value sequence, ::mlir::Value memref);
  static ArrayAmendOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value sequence, ::mlir::Value memref);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static ArrayAmendOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static ArrayAmendOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ArrayAmendOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ArrayAmendOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
public:
};

} // namespace fir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::fir::ArrayAmendOp)

namespace fir {


//===----------------------------------------------------------------------===//
// ::fir::ArrayCoorOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class ArrayCoorOpGenericAdaptorBase {
public:
  struct Properties {
    using operandSegmentSizesTy = std::array<int32_t, 5>;
    operandSegmentSizesTy operandSegmentSizes;
    ::llvm::ArrayRef<int32_t> getOperandSegmentSizes() const {
      auto &propStorage = this->operandSegmentSizes;
      return propStorage;
    }
    void setOperandSegmentSizes(::llvm::ArrayRef<int32_t> propValue) {
      auto &propStorage = this->operandSegmentSizes;
      ::llvm::copy(propValue, propStorage.begin());
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.operandSegmentSizes == this->operandSegmentSizes &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  ArrayCoorOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("fir.array_coor", odsAttrs.getContext());
  }

  ArrayCoorOpGenericAdaptorBase(ArrayCoorOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize);
  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};

} // namespace detail
template <typename RangeT>
class ArrayCoorOpGenericAdaptor : public detail::ArrayCoorOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::ArrayCoorOpGenericAdaptorBase;
  static constexpr int odsIndex_memref = 0;
  static constexpr int odsIndex_shape = 1;
  static constexpr int odsIndex_slice = 2;
  static constexpr int odsIndex_indices = 3;
  static constexpr int odsIndex_typeparams = 4;
public:
  ArrayCoorOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  ArrayCoorOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : ArrayCoorOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  ArrayCoorOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs) : ArrayCoorOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  ArrayCoorOpGenericAdaptor(RangeT values, const ArrayCoorOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = ArrayCoorOp, typename = std::enable_if_t<std::is_same_v<LateInst, ArrayCoorOp>>>
  ArrayCoorOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getMemref() {
    return (*getODSOperands(0).begin());
  }

  ValueT getShape() {
    auto operands = getODSOperands(1);
    return operands.empty() ? ValueT{} : (*operands.begin());
  }

  ValueT getSlice() {
    auto operands = getODSOperands(2);
    return operands.empty() ? ValueT{} : (*operands.begin());
  }

  RangeT getIndices() {
    return getODSOperands(3);
  }

  RangeT getTypeparams() {
    return getODSOperands(4);
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class ArrayCoorOpAdaptor : public ArrayCoorOpGenericAdaptor<::mlir::ValueRange> {
public:
  using ArrayCoorOpGenericAdaptor::ArrayCoorOpGenericAdaptor;
  ArrayCoorOpAdaptor(ArrayCoorOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class ArrayCoorOp : public ::mlir::Op<ArrayCoorOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::fir::ReferenceType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::AtLeastNOperands<1>::Impl, ::mlir::OpTrait::AttrSizedOperandSegments, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::MemoryEffectOpInterface::Trait, ::fir::FortranObjectViewOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = ArrayCoorOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = ArrayCoorOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_memref = 0;
  static constexpr int odsIndex_shape = 1;
  static constexpr int odsIndex_slice = 2;
  static constexpr int odsIndex_indices = 3;
  static constexpr int odsIndex_typeparams = 4;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("operandSegmentSizes")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getOperandSegmentSizesAttrName() {
   return (*this)->getName().getAttributeNames().back();
  }

  static ::mlir::StringAttr getOperandSegmentSizesAttrName(::mlir::OperationName name) {
   return name.getAttributeNames().back();
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("fir.array_coor");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index);
  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getMemref() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::Type> getShape() {
    auto operands = getODSOperands(1);
    return operands.empty() ? ::mlir::TypedValue<::mlir::Type>{} : ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*operands.begin());
  }

  ::mlir::TypedValue<::fir::SliceType> getSlice() {
    auto operands = getODSOperands(2);
    return operands.empty() ? ::mlir::TypedValue<::fir::SliceType>{} : ::llvm::cast<::mlir::TypedValue<::fir::SliceType>>(*operands.begin());
  }

  ::mlir::Operation::operand_range getIndices() {
    return getODSOperands(3);
  }

  ::mlir::Operation::operand_range getTypeparams() {
    return getODSOperands(4);
  }

  ::mlir::OpOperand &getMemrefMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::MutableOperandRange getShapeMutable();
  ::mlir::MutableOperandRange getSliceMutable();
  ::mlir::MutableOperandRange getIndicesMutable();
  ::mlir::MutableOperandRange getTypeparamsMutable();
  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type resultType0, ::mlir::Value memref, /*optional*/::mlir::Value shape, /*optional*/::mlir::Value slice, ::mlir::ValueRange indices, ::mlir::ValueRange typeparams);
  static ArrayCoorOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type resultType0, ::mlir::Value memref, /*optional*/::mlir::Value shape, /*optional*/::mlir::Value slice, ::mlir::ValueRange indices, ::mlir::ValueRange typeparams);
  static ArrayCoorOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type resultType0, ::mlir::Value memref, /*optional*/::mlir::Value shape, /*optional*/::mlir::Value slice, ::mlir::ValueRange indices, ::mlir::ValueRange typeparams);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value memref, /*optional*/::mlir::Value shape, /*optional*/::mlir::Value slice, ::mlir::ValueRange indices, ::mlir::ValueRange typeparams);
  static ArrayCoorOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value memref, /*optional*/::mlir::Value shape, /*optional*/::mlir::Value slice, ::mlir::ValueRange indices, ::mlir::ValueRange typeparams);
  static ArrayCoorOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value memref, /*optional*/::mlir::Value shape, /*optional*/::mlir::Value slice, ::mlir::ValueRange indices, ::mlir::ValueRange typeparams);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static ArrayCoorOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static ArrayCoorOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ArrayCoorOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ArrayCoorOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  static void getCanonicalizationPatterns(::mlir::RewritePatternSet &results, ::mlir::MLIRContext *context);
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    return {};
  }

public:
  // FortranObjectViewOpInterface methods:
  mlir::Value getViewSource(mlir::OpResult) { return getMemref(); }
  std::optional<std::int64_t> getViewOffset(mlir::OpResult);
};

} // namespace fir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::fir::ArrayCoorOp)

namespace fir {


//===----------------------------------------------------------------------===//
// ::fir::ArrayFetchOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class ArrayFetchOpGenericAdaptorBase {
public:
  struct Properties {
    using operandSegmentSizesTy = std::array<int32_t, 3>;
    operandSegmentSizesTy operandSegmentSizes;
    ::llvm::ArrayRef<int32_t> getOperandSegmentSizes() const {
      auto &propStorage = this->operandSegmentSizes;
      return propStorage;
    }
    void setOperandSegmentSizes(::llvm::ArrayRef<int32_t> propValue) {
      auto &propStorage = this->operandSegmentSizes;
      ::llvm::copy(propValue, propStorage.begin());
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.operandSegmentSizes == this->operandSegmentSizes &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  ArrayFetchOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("fir.array_fetch", odsAttrs.getContext());
  }

  ArrayFetchOpGenericAdaptorBase(ArrayFetchOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize);
  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};

} // namespace detail
template <typename RangeT>
class ArrayFetchOpGenericAdaptor : public detail::ArrayFetchOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::ArrayFetchOpGenericAdaptorBase;
  static constexpr int odsIndex_sequence = 0;
  static constexpr int odsIndex_indices = 1;
  static constexpr int odsIndex_typeparams = 2;
public:
  ArrayFetchOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  ArrayFetchOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : ArrayFetchOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  ArrayFetchOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs) : ArrayFetchOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  ArrayFetchOpGenericAdaptor(RangeT values, const ArrayFetchOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = ArrayFetchOp, typename = std::enable_if_t<std::is_same_v<LateInst, ArrayFetchOp>>>
  ArrayFetchOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getSequence() {
    return (*getODSOperands(0).begin());
  }

  RangeT getIndices() {
    return getODSOperands(1);
  }

  RangeT getTypeparams() {
    return getODSOperands(2);
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class ArrayFetchOpAdaptor : public ArrayFetchOpGenericAdaptor<::mlir::ValueRange> {
public:
  using ArrayFetchOpGenericAdaptor::ArrayFetchOpGenericAdaptor;
  ArrayFetchOpAdaptor(ArrayFetchOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class ArrayFetchOp : public ::mlir::Op<ArrayFetchOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::Type>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::AtLeastNOperands<1>::Impl, ::mlir::OpTrait::AttrSizedOperandSegments, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = ArrayFetchOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = ArrayFetchOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_sequence = 0;
  static constexpr int odsIndex_indices = 1;
  static constexpr int odsIndex_typeparams = 2;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("operandSegmentSizes")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getOperandSegmentSizesAttrName() {
   return (*this)->getName().getAttributeNames().back();
  }

  static ::mlir::StringAttr getOperandSegmentSizesAttrName(::mlir::OperationName name) {
   return name.getAttributeNames().back();
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("fir.array_fetch");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index);
  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::fir::SequenceType> getSequence() {
    return ::llvm::cast<::mlir::TypedValue<::fir::SequenceType>>(*getODSOperands(0).begin());
  }

  ::mlir::Operation::operand_range getIndices() {
    return getODSOperands(1);
  }

  ::mlir::Operation::operand_range getTypeparams() {
    return getODSOperands(2);
  }

  ::mlir::OpOperand &getSequenceMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::MutableOperandRange getIndicesMutable();
  ::mlir::MutableOperandRange getTypeparamsMutable();
  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getElement() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type element, ::mlir::Value sequence, ::mlir::ValueRange indices, ::mlir::ValueRange typeparams);
  static ArrayFetchOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type element, ::mlir::Value sequence, ::mlir::ValueRange indices, ::mlir::ValueRange typeparams);
  static ArrayFetchOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type element, ::mlir::Value sequence, ::mlir::ValueRange indices, ::mlir::ValueRange typeparams);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value sequence, ::mlir::ValueRange indices, ::mlir::ValueRange typeparams);
  static ArrayFetchOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value sequence, ::mlir::ValueRange indices, ::mlir::ValueRange typeparams);
  static ArrayFetchOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value sequence, ::mlir::ValueRange indices, ::mlir::ValueRange typeparams);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static ArrayFetchOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static ArrayFetchOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ArrayFetchOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ArrayFetchOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    return {};
  }

public:
};

} // namespace fir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::fir::ArrayFetchOp)

namespace fir {


//===----------------------------------------------------------------------===//
// ::fir::ArrayLoadOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class ArrayLoadOpGenericAdaptorBase {
public:
  struct Properties {
    using operandSegmentSizesTy = std::array<int32_t, 4>;
    operandSegmentSizesTy operandSegmentSizes;
    ::llvm::ArrayRef<int32_t> getOperandSegmentSizes() const {
      auto &propStorage = this->operandSegmentSizes;
      return propStorage;
    }
    void setOperandSegmentSizes(::llvm::ArrayRef<int32_t> propValue) {
      auto &propStorage = this->operandSegmentSizes;
      ::llvm::copy(propValue, propStorage.begin());
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.operandSegmentSizes == this->operandSegmentSizes &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  ArrayLoadOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("fir.array_load", odsAttrs.getContext());
  }

  ArrayLoadOpGenericAdaptorBase(ArrayLoadOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize);
  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};

} // namespace detail
template <typename RangeT>
class ArrayLoadOpGenericAdaptor : public detail::ArrayLoadOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::ArrayLoadOpGenericAdaptorBase;
  static constexpr int odsIndex_memref = 0;
  static constexpr int odsIndex_shape = 1;
  static constexpr int odsIndex_slice = 2;
  static constexpr int odsIndex_typeparams = 3;
public:
  ArrayLoadOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  ArrayLoadOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : ArrayLoadOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  ArrayLoadOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs) : ArrayLoadOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  ArrayLoadOpGenericAdaptor(RangeT values, const ArrayLoadOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = ArrayLoadOp, typename = std::enable_if_t<std::is_same_v<LateInst, ArrayLoadOp>>>
  ArrayLoadOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getMemref() {
    return (*getODSOperands(0).begin());
  }

  ValueT getShape() {
    auto operands = getODSOperands(1);
    return operands.empty() ? ValueT{} : (*operands.begin());
  }

  ValueT getSlice() {
    auto operands = getODSOperands(2);
    return operands.empty() ? ValueT{} : (*operands.begin());
  }

  RangeT getTypeparams() {
    return getODSOperands(3);
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class ArrayLoadOpAdaptor : public ArrayLoadOpGenericAdaptor<::mlir::ValueRange> {
public:
  using ArrayLoadOpGenericAdaptor::ArrayLoadOpGenericAdaptor;
  ArrayLoadOpAdaptor(ArrayLoadOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class ArrayLoadOp : public ::mlir::Op<ArrayLoadOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::fir::SequenceType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::AtLeastNOperands<1>::Impl, ::mlir::OpTrait::AttrSizedOperandSegments, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = ArrayLoadOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = ArrayLoadOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_memref = 0;
  static constexpr int odsIndex_shape = 1;
  static constexpr int odsIndex_slice = 2;
  static constexpr int odsIndex_typeparams = 3;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("operandSegmentSizes")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getOperandSegmentSizesAttrName() {
   return (*this)->getName().getAttributeNames().back();
  }

  static ::mlir::StringAttr getOperandSegmentSizesAttrName(::mlir::OperationName name) {
   return name.getAttributeNames().back();
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("fir.array_load");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index);
  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getMemref() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::Type> getShape() {
    auto operands = getODSOperands(1);
    return operands.empty() ? ::mlir::TypedValue<::mlir::Type>{} : ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*operands.begin());
  }

  ::mlir::TypedValue<::fir::SliceType> getSlice() {
    auto operands = getODSOperands(2);
    return operands.empty() ? ::mlir::TypedValue<::fir::SliceType>{} : ::llvm::cast<::mlir::TypedValue<::fir::SliceType>>(*operands.begin());
  }

  ::mlir::Operation::operand_range getTypeparams() {
    return getODSOperands(3);
  }

  ::mlir::OpOperand &getMemrefMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::MutableOperandRange getShapeMutable();
  ::mlir::MutableOperandRange getSliceMutable();
  ::mlir::MutableOperandRange getTypeparamsMutable();
  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type resultType0, ::mlir::Value memref, /*optional*/::mlir::Value shape, /*optional*/::mlir::Value slice, ::mlir::ValueRange typeparams);
  static ArrayLoadOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type resultType0, ::mlir::Value memref, /*optional*/::mlir::Value shape, /*optional*/::mlir::Value slice, ::mlir::ValueRange typeparams);
  static ArrayLoadOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type resultType0, ::mlir::Value memref, /*optional*/::mlir::Value shape, /*optional*/::mlir::Value slice, ::mlir::ValueRange typeparams);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value memref, /*optional*/::mlir::Value shape, /*optional*/::mlir::Value slice, ::mlir::ValueRange typeparams);
  static ArrayLoadOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value memref, /*optional*/::mlir::Value shape, /*optional*/::mlir::Value slice, ::mlir::ValueRange typeparams);
  static ArrayLoadOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value memref, /*optional*/::mlir::Value shape, /*optional*/::mlir::Value slice, ::mlir::ValueRange typeparams);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static ArrayLoadOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static ArrayLoadOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ArrayLoadOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ArrayLoadOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    return {};
  }

public:
  std::vector<mlir::Value> getExtents();
};

} // namespace fir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::fir::ArrayLoadOp)

namespace fir {


//===----------------------------------------------------------------------===//
// ::fir::ArrayMergeStoreOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class ArrayMergeStoreOpGenericAdaptorBase {
public:
  struct Properties {
    using operandSegmentSizesTy = std::array<int32_t, 5>;
    operandSegmentSizesTy operandSegmentSizes;
    ::llvm::ArrayRef<int32_t> getOperandSegmentSizes() const {
      auto &propStorage = this->operandSegmentSizes;
      return propStorage;
    }
    void setOperandSegmentSizes(::llvm::ArrayRef<int32_t> propValue) {
      auto &propStorage = this->operandSegmentSizes;
      ::llvm::copy(propValue, propStorage.begin());
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.operandSegmentSizes == this->operandSegmentSizes &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  ArrayMergeStoreOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("fir.array_merge_store", odsAttrs.getContext());
  }

  ArrayMergeStoreOpGenericAdaptorBase(ArrayMergeStoreOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize);
  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};

} // namespace detail
template <typename RangeT>
class ArrayMergeStoreOpGenericAdaptor : public detail::ArrayMergeStoreOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::ArrayMergeStoreOpGenericAdaptorBase;
  static constexpr int odsIndex_original = 0;
  static constexpr int odsIndex_sequence = 1;
  static constexpr int odsIndex_memref = 2;
  static constexpr int odsIndex_slice = 3;
  static constexpr int odsIndex_typeparams = 4;
public:
  ArrayMergeStoreOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  ArrayMergeStoreOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : ArrayMergeStoreOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  ArrayMergeStoreOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs) : ArrayMergeStoreOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  ArrayMergeStoreOpGenericAdaptor(RangeT values, const ArrayMergeStoreOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = ArrayMergeStoreOp, typename = std::enable_if_t<std::is_same_v<LateInst, ArrayMergeStoreOp>>>
  ArrayMergeStoreOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getOriginal() {
    return (*getODSOperands(0).begin());
  }

  ValueT getSequence() {
    return (*getODSOperands(1).begin());
  }

  ValueT getMemref() {
    return (*getODSOperands(2).begin());
  }

  ValueT getSlice() {
    auto operands = getODSOperands(3);
    return operands.empty() ? ValueT{} : (*operands.begin());
  }

  RangeT getTypeparams() {
    return getODSOperands(4);
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class ArrayMergeStoreOpAdaptor : public ArrayMergeStoreOpGenericAdaptor<::mlir::ValueRange> {
public:
  using ArrayMergeStoreOpGenericAdaptor::ArrayMergeStoreOpGenericAdaptor;
  ArrayMergeStoreOpAdaptor(ArrayMergeStoreOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class ArrayMergeStoreOp : public ::mlir::Op<ArrayMergeStoreOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::ZeroResults, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::AtLeastNOperands<3>::Impl, ::mlir::OpTrait::AttrSizedOperandSegments, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = ArrayMergeStoreOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = ArrayMergeStoreOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_original = 0;
  static constexpr int odsIndex_sequence = 1;
  static constexpr int odsIndex_memref = 2;
  static constexpr int odsIndex_slice = 3;
  static constexpr int odsIndex_typeparams = 4;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("operandSegmentSizes")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getOperandSegmentSizesAttrName() {
   return (*this)->getName().getAttributeNames().back();
  }

  static ::mlir::StringAttr getOperandSegmentSizesAttrName(::mlir::OperationName name) {
   return name.getAttributeNames().back();
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("fir.array_merge_store");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index);
  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::fir::SequenceType> getOriginal() {
    return ::llvm::cast<::mlir::TypedValue<::fir::SequenceType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::fir::SequenceType> getSequence() {
    return ::llvm::cast<::mlir::TypedValue<::fir::SequenceType>>(*getODSOperands(1).begin());
  }

  ::mlir::TypedValue<::mlir::Type> getMemref() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(2).begin());
  }

  ::mlir::TypedValue<::fir::SliceType> getSlice() {
    auto operands = getODSOperands(3);
    return operands.empty() ? ::mlir::TypedValue<::fir::SliceType>{} : ::llvm::cast<::mlir::TypedValue<::fir::SliceType>>(*operands.begin());
  }

  ::mlir::Operation::operand_range getTypeparams() {
    return getODSOperands(4);
  }

  ::mlir::OpOperand &getOriginalMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getSequenceMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getMemrefMutable() {
    auto range = getODSOperandIndexAndLength(2);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::MutableOperandRange getSliceMutable();
  ::mlir::MutableOperandRange getTypeparamsMutable();
  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value original, ::mlir::Value sequence, ::mlir::Value memref, /*optional*/::mlir::Value slice, ::mlir::ValueRange typeparams);
  static ArrayMergeStoreOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value original, ::mlir::Value sequence, ::mlir::Value memref, /*optional*/::mlir::Value slice, ::mlir::ValueRange typeparams);
  static ArrayMergeStoreOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value original, ::mlir::Value sequence, ::mlir::Value memref, /*optional*/::mlir::Value slice, ::mlir::ValueRange typeparams);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value original, ::mlir::Value sequence, ::mlir::Value memref, /*optional*/::mlir::Value slice, ::mlir::ValueRange typeparams);
  static ArrayMergeStoreOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value original, ::mlir::Value sequence, ::mlir::Value memref, /*optional*/::mlir::Value slice, ::mlir::ValueRange typeparams);
  static ArrayMergeStoreOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value original, ::mlir::Value sequence, ::mlir::Value memref, /*optional*/::mlir::Value slice, ::mlir::ValueRange typeparams);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static ArrayMergeStoreOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static ArrayMergeStoreOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ArrayMergeStoreOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ArrayMergeStoreOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    return {};
  }

public:
};

} // namespace fir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::fir::ArrayMergeStoreOp)

namespace fir {


//===----------------------------------------------------------------------===//
// ::fir::ArrayModifyOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class ArrayModifyOpGenericAdaptorBase {
public:
  struct Properties {
    using operandSegmentSizesTy = std::array<int32_t, 3>;
    operandSegmentSizesTy operandSegmentSizes;
    ::llvm::ArrayRef<int32_t> getOperandSegmentSizes() const {
      auto &propStorage = this->operandSegmentSizes;
      return propStorage;
    }
    void setOperandSegmentSizes(::llvm::ArrayRef<int32_t> propValue) {
      auto &propStorage = this->operandSegmentSizes;
      ::llvm::copy(propValue, propStorage.begin());
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.operandSegmentSizes == this->operandSegmentSizes &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  ArrayModifyOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("fir.array_modify", odsAttrs.getContext());
  }

  ArrayModifyOpGenericAdaptorBase(ArrayModifyOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize);
  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};

} // namespace detail
template <typename RangeT>
class ArrayModifyOpGenericAdaptor : public detail::ArrayModifyOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::ArrayModifyOpGenericAdaptorBase;
  static constexpr int odsIndex_sequence = 0;
  static constexpr int odsIndex_indices = 1;
  static constexpr int odsIndex_typeparams = 2;
public:
  ArrayModifyOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  ArrayModifyOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : ArrayModifyOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  ArrayModifyOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs) : ArrayModifyOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  ArrayModifyOpGenericAdaptor(RangeT values, const ArrayModifyOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = ArrayModifyOp, typename = std::enable_if_t<std::is_same_v<LateInst, ArrayModifyOp>>>
  ArrayModifyOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getSequence() {
    return (*getODSOperands(0).begin());
  }

  RangeT getIndices() {
    return getODSOperands(1);
  }

  RangeT getTypeparams() {
    return getODSOperands(2);
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class ArrayModifyOpAdaptor : public ArrayModifyOpGenericAdaptor<::mlir::ValueRange> {
public:
  using ArrayModifyOpGenericAdaptor::ArrayModifyOpGenericAdaptor;
  ArrayModifyOpAdaptor(ArrayModifyOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class ArrayModifyOp : public ::mlir::Op<ArrayModifyOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::NResults<2>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::AtLeastNOperands<1>::Impl, ::mlir::OpTrait::AttrSizedOperandSegments, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = ArrayModifyOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = ArrayModifyOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_sequence = 0;
  static constexpr int odsIndex_indices = 1;
  static constexpr int odsIndex_typeparams = 2;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("operandSegmentSizes")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getOperandSegmentSizesAttrName() {
   return (*this)->getName().getAttributeNames().back();
  }

  static ::mlir::StringAttr getOperandSegmentSizesAttrName(::mlir::OperationName name) {
   return name.getAttributeNames().back();
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("fir.array_modify");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index);
  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::fir::SequenceType> getSequence() {
    return ::llvm::cast<::mlir::TypedValue<::fir::SequenceType>>(*getODSOperands(0).begin());
  }

  ::mlir::Operation::operand_range getIndices() {
    return getODSOperands(1);
  }

  ::mlir::Operation::operand_range getTypeparams() {
    return getODSOperands(2);
  }

  ::mlir::OpOperand &getSequenceMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::MutableOperandRange getIndicesMutable();
  ::mlir::MutableOperandRange getTypeparamsMutable();
  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type resultType0, ::mlir::Type resultType1, ::mlir::Value sequence, ::mlir::ValueRange indices, ::mlir::ValueRange typeparams);
  static ArrayModifyOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type resultType0, ::mlir::Type resultType1, ::mlir::Value sequence, ::mlir::ValueRange indices, ::mlir::ValueRange typeparams);
  static ArrayModifyOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type resultType0, ::mlir::Type resultType1, ::mlir::Value sequence, ::mlir::ValueRange indices, ::mlir::ValueRange typeparams);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value sequence, ::mlir::ValueRange indices, ::mlir::ValueRange typeparams);
  static ArrayModifyOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value sequence, ::mlir::ValueRange indices, ::mlir::ValueRange typeparams);
  static ArrayModifyOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value sequence, ::mlir::ValueRange indices, ::mlir::ValueRange typeparams);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static ArrayModifyOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static ArrayModifyOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ArrayModifyOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ArrayModifyOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    return {};
  }

public:
};

} // namespace fir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::fir::ArrayModifyOp)

namespace fir {


//===----------------------------------------------------------------------===//
// ::fir::ArrayUpdateOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class ArrayUpdateOpGenericAdaptorBase {
public:
  struct Properties {
    using operandSegmentSizesTy = std::array<int32_t, 4>;
    operandSegmentSizesTy operandSegmentSizes;
    ::llvm::ArrayRef<int32_t> getOperandSegmentSizes() const {
      auto &propStorage = this->operandSegmentSizes;
      return propStorage;
    }
    void setOperandSegmentSizes(::llvm::ArrayRef<int32_t> propValue) {
      auto &propStorage = this->operandSegmentSizes;
      ::llvm::copy(propValue, propStorage.begin());
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.operandSegmentSizes == this->operandSegmentSizes &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  ArrayUpdateOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("fir.array_update", odsAttrs.getContext());
  }

  ArrayUpdateOpGenericAdaptorBase(ArrayUpdateOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize);
  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};

} // namespace detail
template <typename RangeT>
class ArrayUpdateOpGenericAdaptor : public detail::ArrayUpdateOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::ArrayUpdateOpGenericAdaptorBase;
  static constexpr int odsIndex_sequence = 0;
  static constexpr int odsIndex_merge = 1;
  static constexpr int odsIndex_indices = 2;
  static constexpr int odsIndex_typeparams = 3;
public:
  ArrayUpdateOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  ArrayUpdateOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : ArrayUpdateOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  ArrayUpdateOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs) : ArrayUpdateOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  ArrayUpdateOpGenericAdaptor(RangeT values, const ArrayUpdateOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = ArrayUpdateOp, typename = std::enable_if_t<std::is_same_v<LateInst, ArrayUpdateOp>>>
  ArrayUpdateOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getSequence() {
    return (*getODSOperands(0).begin());
  }

  ValueT getMerge() {
    return (*getODSOperands(1).begin());
  }

  RangeT getIndices() {
    return getODSOperands(2);
  }

  RangeT getTypeparams() {
    return getODSOperands(3);
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class ArrayUpdateOpAdaptor : public ArrayUpdateOpGenericAdaptor<::mlir::ValueRange> {
public:
  using ArrayUpdateOpGenericAdaptor::ArrayUpdateOpGenericAdaptor;
  ArrayUpdateOpAdaptor(ArrayUpdateOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class ArrayUpdateOp : public ::mlir::Op<ArrayUpdateOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::fir::SequenceType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::AtLeastNOperands<2>::Impl, ::mlir::OpTrait::AttrSizedOperandSegments, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = ArrayUpdateOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = ArrayUpdateOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_sequence = 0;
  static constexpr int odsIndex_merge = 1;
  static constexpr int odsIndex_indices = 2;
  static constexpr int odsIndex_typeparams = 3;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("operandSegmentSizes")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getOperandSegmentSizesAttrName() {
   return (*this)->getName().getAttributeNames().back();
  }

  static ::mlir::StringAttr getOperandSegmentSizesAttrName(::mlir::OperationName name) {
   return name.getAttributeNames().back();
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("fir.array_update");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index);
  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::fir::SequenceType> getSequence() {
    return ::llvm::cast<::mlir::TypedValue<::fir::SequenceType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::Type> getMerge() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(1).begin());
  }

  ::mlir::Operation::operand_range getIndices() {
    return getODSOperands(2);
  }

  ::mlir::Operation::operand_range getTypeparams() {
    return getODSOperands(3);
  }

  ::mlir::OpOperand &getSequenceMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getMergeMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::MutableOperandRange getIndicesMutable();
  ::mlir::MutableOperandRange getTypeparamsMutable();
  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type resultType0, ::mlir::Value sequence, ::mlir::Value merge, ::mlir::ValueRange indices, ::mlir::ValueRange typeparams);
  static ArrayUpdateOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type resultType0, ::mlir::Value sequence, ::mlir::Value merge, ::mlir::ValueRange indices, ::mlir::ValueRange typeparams);
  static ArrayUpdateOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type resultType0, ::mlir::Value sequence, ::mlir::Value merge, ::mlir::ValueRange indices, ::mlir::ValueRange typeparams);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value sequence, ::mlir::Value merge, ::mlir::ValueRange indices, ::mlir::ValueRange typeparams);
  static ArrayUpdateOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value sequence, ::mlir::Value merge, ::mlir::ValueRange indices, ::mlir::ValueRange typeparams);
  static ArrayUpdateOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value sequence, ::mlir::Value merge, ::mlir::ValueRange indices, ::mlir::ValueRange typeparams);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static ArrayUpdateOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static ArrayUpdateOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ArrayUpdateOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ArrayUpdateOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    return {};
  }

public:
};

} // namespace fir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::fir::ArrayUpdateOp)

namespace fir {


//===----------------------------------------------------------------------===//
// ::fir::AssumedSizeExtentOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class AssumedSizeExtentOpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  AssumedSizeExtentOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("fir.assumed_size_extent", odsAttrs.getContext());
  }

  AssumedSizeExtentOpGenericAdaptorBase(AssumedSizeExtentOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};

} // namespace detail
template <typename RangeT>
class AssumedSizeExtentOpGenericAdaptor : public detail::AssumedSizeExtentOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::AssumedSizeExtentOpGenericAdaptorBase;
public:
  AssumedSizeExtentOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  AssumedSizeExtentOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : AssumedSizeExtentOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  AssumedSizeExtentOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : AssumedSizeExtentOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  AssumedSizeExtentOpGenericAdaptor(RangeT values, const AssumedSizeExtentOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = AssumedSizeExtentOp, typename = std::enable_if_t<std::is_same_v<LateInst, AssumedSizeExtentOp>>>
  AssumedSizeExtentOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class AssumedSizeExtentOpAdaptor : public AssumedSizeExtentOpGenericAdaptor<::mlir::ValueRange> {
public:
  using AssumedSizeExtentOpGenericAdaptor::AssumedSizeExtentOpGenericAdaptor;
  AssumedSizeExtentOpAdaptor(AssumedSizeExtentOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class AssumedSizeExtentOp : public ::mlir::Op<AssumedSizeExtentOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::IndexType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::ZeroOperands, ::mlir::OpTrait::OpInvariants, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::InferTypeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = AssumedSizeExtentOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = AssumedSizeExtentOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    return {};
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("fir.assumed_size_extent");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, mlir::Type resultType, mlir::ValueRange operands, llvm::ArrayRef<mlir::NamedAttribute> attributes = {});
  static AssumedSizeExtentOp create(::mlir::OpBuilder &builder, ::mlir::Location location, mlir::Type resultType, mlir::ValueRange operands, llvm::ArrayRef<mlir::NamedAttribute> attributes = {});
  static AssumedSizeExtentOp create(::mlir::ImplicitLocOpBuilder &builder, mlir::Type resultType, mlir::ValueRange operands, llvm::ArrayRef<mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type resultType0);
  static AssumedSizeExtentOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type resultType0);
  static AssumedSizeExtentOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type resultType0);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState);
  static AssumedSizeExtentOp create(::mlir::OpBuilder &builder, ::mlir::Location location);
  static AssumedSizeExtentOp create(::mlir::ImplicitLocOpBuilder &builder);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes);
  static AssumedSizeExtentOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes);
  static AssumedSizeExtentOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static AssumedSizeExtentOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static AssumedSizeExtentOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static AssumedSizeExtentOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static AssumedSizeExtentOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static AssumedSizeExtentOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static AssumedSizeExtentOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static AssumedSizeExtentOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static AssumedSizeExtentOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::llvm::LogicalResult inferReturnTypes(::mlir::MLIRContext *context, ::std::optional<::mlir::Location> location, ::mlir::ValueRange operands, ::mlir::DictionaryAttr attributes, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions, ::llvm::SmallVectorImpl<::mlir::Type>&inferredReturnTypes);
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
public:
};

} // namespace fir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::fir::AssumedSizeExtentOp)

namespace fir {


//===----------------------------------------------------------------------===//
// ::fir::BoxAddrOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class BoxAddrOpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  BoxAddrOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("fir.box_addr", odsAttrs.getContext());
  }

  BoxAddrOpGenericAdaptorBase(BoxAddrOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};

} // namespace detail
template <typename RangeT>
class BoxAddrOpGenericAdaptor : public detail::BoxAddrOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::BoxAddrOpGenericAdaptorBase;
  static constexpr int odsIndex_val = 0;
public:
  BoxAddrOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  BoxAddrOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : BoxAddrOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  BoxAddrOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : BoxAddrOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  BoxAddrOpGenericAdaptor(RangeT values, const BoxAddrOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = BoxAddrOp, typename = std::enable_if_t<std::is_same_v<LateInst, BoxAddrOp>>>
  BoxAddrOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getVal() {
    return (*getODSOperands(0).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class BoxAddrOpAdaptor : public BoxAddrOpGenericAdaptor<::mlir::ValueRange> {
public:
  using BoxAddrOpGenericAdaptor::BoxAddrOpGenericAdaptor;
  BoxAddrOpAdaptor(BoxAddrOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class BoxAddrOp : public ::mlir::Op<BoxAddrOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::Type>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::OneOperand, ::mlir::OpTrait::OpInvariants, ::mlir::MemoryEffectOpInterface::Trait, ::fir::FortranObjectViewOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = BoxAddrOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = BoxAddrOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_val = 0;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    return {};
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("fir.box_addr");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getVal() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(0).begin());
  }

  ::mlir::OpOperand &getValMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, mlir::Value val);
  static BoxAddrOp create(::mlir::OpBuilder &builder, ::mlir::Location location, mlir::Value val);
  static BoxAddrOp create(::mlir::ImplicitLocOpBuilder &builder, mlir::Value val);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type resultType0, ::mlir::Value val);
  static BoxAddrOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type resultType0, ::mlir::Value val);
  static BoxAddrOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type resultType0, ::mlir::Value val);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value val);
  static BoxAddrOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value val);
  static BoxAddrOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value val);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static BoxAddrOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static BoxAddrOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static BoxAddrOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static BoxAddrOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::mlir::OpFoldResult fold(FoldAdaptor adaptor);
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
public:
  // FortranObjectViewOpInterface methods:
  mlir::Value getViewSource(mlir::OpResult) { return getVal(); }
  std::optional<std::int64_t> getViewOffset(mlir::OpResult);
};

} // namespace fir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::fir::BoxAddrOp)

namespace fir {


//===----------------------------------------------------------------------===//
// ::fir::BoxCharLenOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class BoxCharLenOpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  BoxCharLenOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("fir.boxchar_len", odsAttrs.getContext());
  }

  BoxCharLenOpGenericAdaptorBase(BoxCharLenOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};

} // namespace detail
template <typename RangeT>
class BoxCharLenOpGenericAdaptor : public detail::BoxCharLenOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::BoxCharLenOpGenericAdaptorBase;
  static constexpr int odsIndex_val = 0;
public:
  BoxCharLenOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  BoxCharLenOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : BoxCharLenOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  BoxCharLenOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : BoxCharLenOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  BoxCharLenOpGenericAdaptor(RangeT values, const BoxCharLenOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = BoxCharLenOp, typename = std::enable_if_t<std::is_same_v<LateInst, BoxCharLenOp>>>
  BoxCharLenOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getVal() {
    return (*getODSOperands(0).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class BoxCharLenOpAdaptor : public BoxCharLenOpGenericAdaptor<::mlir::ValueRange> {
public:
  using BoxCharLenOpGenericAdaptor::BoxCharLenOpGenericAdaptor;
  BoxCharLenOpAdaptor(BoxCharLenOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class BoxCharLenOp : public ::mlir::Op<BoxCharLenOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::Type>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::OneOperand, ::mlir::OpTrait::OpInvariants, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = BoxCharLenOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = BoxCharLenOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_val = 0;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    return {};
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("fir.boxchar_len");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::fir::BoxCharType> getVal() {
    return ::llvm::cast<::mlir::TypedValue<::fir::BoxCharType>>(*getODSOperands(0).begin());
  }

  ::mlir::OpOperand &getValMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type resultType0, ::mlir::Value val);
  static BoxCharLenOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type resultType0, ::mlir::Value val);
  static BoxCharLenOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type resultType0, ::mlir::Value val);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value val);
  static BoxCharLenOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value val);
  static BoxCharLenOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value val);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static BoxCharLenOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static BoxCharLenOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static BoxCharLenOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static BoxCharLenOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::mlir::OpFoldResult fold(FoldAdaptor adaptor);
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
public:
};

} // namespace fir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::fir::BoxCharLenOp)

namespace fir {


//===----------------------------------------------------------------------===//
// ::fir::BoxDimsOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class BoxDimsOpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  BoxDimsOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("fir.box_dims", odsAttrs.getContext());
  }

  BoxDimsOpGenericAdaptorBase(BoxDimsOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};

} // namespace detail
template <typename RangeT>
class BoxDimsOpGenericAdaptor : public detail::BoxDimsOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::BoxDimsOpGenericAdaptorBase;
  static constexpr int odsIndex_val = 0;
  static constexpr int odsIndex_dim = 1;
public:
  BoxDimsOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  BoxDimsOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : BoxDimsOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  BoxDimsOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : BoxDimsOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  BoxDimsOpGenericAdaptor(RangeT values, const BoxDimsOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = BoxDimsOp, typename = std::enable_if_t<std::is_same_v<LateInst, BoxDimsOp>>>
  BoxDimsOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getVal() {
    return (*getODSOperands(0).begin());
  }

  ValueT getDim() {
    return (*getODSOperands(1).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class BoxDimsOpAdaptor : public BoxDimsOpGenericAdaptor<::mlir::ValueRange> {
public:
  using BoxDimsOpGenericAdaptor::BoxDimsOpGenericAdaptor;
  BoxDimsOpAdaptor(BoxDimsOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class BoxDimsOp : public ::mlir::Op<BoxDimsOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::NResults<3>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<2>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::InferTypeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = BoxDimsOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = BoxDimsOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_val = 0;
  static constexpr int odsIndex_dim = 1;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    return {};
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("fir.box_dims");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getVal() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::Type> getDim() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(1).begin());
  }

  ::mlir::OpOperand &getValMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getDimMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type resultType0, ::mlir::Type resultType1, ::mlir::Type resultType2, ::mlir::Value val, ::mlir::Value dim);
  static BoxDimsOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type resultType0, ::mlir::Type resultType1, ::mlir::Type resultType2, ::mlir::Value val, ::mlir::Value dim);
  static BoxDimsOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type resultType0, ::mlir::Type resultType1, ::mlir::Type resultType2, ::mlir::Value val, ::mlir::Value dim);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value val, ::mlir::Value dim);
  static BoxDimsOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value val, ::mlir::Value dim);
  static BoxDimsOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value val, ::mlir::Value dim);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value val, ::mlir::Value dim);
  static BoxDimsOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value val, ::mlir::Value dim);
  static BoxDimsOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value val, ::mlir::Value dim);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static BoxDimsOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static BoxDimsOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static BoxDimsOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static BoxDimsOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static BoxDimsOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static BoxDimsOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static BoxDimsOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static BoxDimsOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::llvm::LogicalResult inferReturnTypes(::mlir::MLIRContext *context, ::std::optional<::mlir::Location> location, ::mlir::ValueRange operands, ::mlir::DictionaryAttr attributes, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions, ::llvm::SmallVectorImpl<::mlir::Type>&inferredReturnTypes);
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
public:
  mlir::Type getTupleType();
  mlir::Value getLowerBound() {return getResult(0);};
  mlir::Value getExtent() {return getResult(1);};
  mlir::Value getByteStride() {return getResult(2);};
};

} // namespace fir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::fir::BoxDimsOp)

namespace fir {


//===----------------------------------------------------------------------===//
// ::fir::BoxEleSizeOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class BoxEleSizeOpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  BoxEleSizeOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("fir.box_elesize", odsAttrs.getContext());
  }

  BoxEleSizeOpGenericAdaptorBase(BoxEleSizeOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};

} // namespace detail
template <typename RangeT>
class BoxEleSizeOpGenericAdaptor : public detail::BoxEleSizeOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::BoxEleSizeOpGenericAdaptorBase;
  static constexpr int odsIndex_val = 0;
public:
  BoxEleSizeOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  BoxEleSizeOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : BoxEleSizeOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  BoxEleSizeOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : BoxEleSizeOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  BoxEleSizeOpGenericAdaptor(RangeT values, const BoxEleSizeOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = BoxEleSizeOp, typename = std::enable_if_t<std::is_same_v<LateInst, BoxEleSizeOp>>>
  BoxEleSizeOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getVal() {
    return (*getODSOperands(0).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class BoxEleSizeOpAdaptor : public BoxEleSizeOpGenericAdaptor<::mlir::ValueRange> {
public:
  using BoxEleSizeOpGenericAdaptor::BoxEleSizeOpGenericAdaptor;
  BoxEleSizeOpAdaptor(BoxEleSizeOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class BoxEleSizeOp : public ::mlir::Op<BoxEleSizeOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::Type>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::OneOperand, ::mlir::OpTrait::OpInvariants, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = BoxEleSizeOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = BoxEleSizeOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_val = 0;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    return {};
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("fir.box_elesize");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getVal() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(0).begin());
  }

  ::mlir::OpOperand &getValMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, mlir::Type resultType, mlir::ValueRange operands, llvm::ArrayRef<mlir::NamedAttribute> attributes = {});
  static BoxEleSizeOp create(::mlir::OpBuilder &builder, ::mlir::Location location, mlir::Type resultType, mlir::ValueRange operands, llvm::ArrayRef<mlir::NamedAttribute> attributes = {});
  static BoxEleSizeOp create(::mlir::ImplicitLocOpBuilder &builder, mlir::Type resultType, mlir::ValueRange operands, llvm::ArrayRef<mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type resultType0, ::mlir::Value val);
  static BoxEleSizeOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type resultType0, ::mlir::Value val);
  static BoxEleSizeOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type resultType0, ::mlir::Value val);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value val);
  static BoxEleSizeOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value val);
  static BoxEleSizeOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value val);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static BoxEleSizeOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static BoxEleSizeOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static BoxEleSizeOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static BoxEleSizeOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
public:
};

} // namespace fir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::fir::BoxEleSizeOp)

namespace fir {


//===----------------------------------------------------------------------===//
// ::fir::BoxIsAllocOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class BoxIsAllocOpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  BoxIsAllocOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("fir.box_isalloc", odsAttrs.getContext());
  }

  BoxIsAllocOpGenericAdaptorBase(BoxIsAllocOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};

} // namespace detail
template <typename RangeT>
class BoxIsAllocOpGenericAdaptor : public detail::BoxIsAllocOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::BoxIsAllocOpGenericAdaptorBase;
  static constexpr int odsIndex_val = 0;
public:
  BoxIsAllocOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  BoxIsAllocOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : BoxIsAllocOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  BoxIsAllocOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : BoxIsAllocOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  BoxIsAllocOpGenericAdaptor(RangeT values, const BoxIsAllocOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = BoxIsAllocOp, typename = std::enable_if_t<std::is_same_v<LateInst, BoxIsAllocOp>>>
  BoxIsAllocOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getVal() {
    return (*getODSOperands(0).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class BoxIsAllocOpAdaptor : public BoxIsAllocOpGenericAdaptor<::mlir::ValueRange> {
public:
  using BoxIsAllocOpGenericAdaptor::BoxIsAllocOpGenericAdaptor;
  BoxIsAllocOpAdaptor(BoxIsAllocOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class BoxIsAllocOp : public ::mlir::Op<BoxIsAllocOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::Type>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::OneOperand, ::mlir::OpTrait::OpInvariants, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = BoxIsAllocOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = BoxIsAllocOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_val = 0;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    return {};
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("fir.box_isalloc");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::fir::BoxType> getVal() {
    return ::llvm::cast<::mlir::TypedValue<::fir::BoxType>>(*getODSOperands(0).begin());
  }

  ::mlir::OpOperand &getValMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type resultType0, ::mlir::Value val);
  static BoxIsAllocOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type resultType0, ::mlir::Value val);
  static BoxIsAllocOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type resultType0, ::mlir::Value val);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value val);
  static BoxIsAllocOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value val);
  static BoxIsAllocOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value val);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static BoxIsAllocOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static BoxIsAllocOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static BoxIsAllocOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static BoxIsAllocOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
public:
};

} // namespace fir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::fir::BoxIsAllocOp)

namespace fir {


//===----------------------------------------------------------------------===//
// ::fir::BoxIsArrayOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class BoxIsArrayOpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  BoxIsArrayOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("fir.box_isarray", odsAttrs.getContext());
  }

  BoxIsArrayOpGenericAdaptorBase(BoxIsArrayOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};

} // namespace detail
template <typename RangeT>
class BoxIsArrayOpGenericAdaptor : public detail::BoxIsArrayOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::BoxIsArrayOpGenericAdaptorBase;
  static constexpr int odsIndex_val = 0;
public:
  BoxIsArrayOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  BoxIsArrayOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : BoxIsArrayOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  BoxIsArrayOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : BoxIsArrayOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  BoxIsArrayOpGenericAdaptor(RangeT values, const BoxIsArrayOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = BoxIsArrayOp, typename = std::enable_if_t<std::is_same_v<LateInst, BoxIsArrayOp>>>
  BoxIsArrayOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getVal() {
    return (*getODSOperands(0).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class BoxIsArrayOpAdaptor : public BoxIsArrayOpGenericAdaptor<::mlir::ValueRange> {
public:
  using BoxIsArrayOpGenericAdaptor::BoxIsArrayOpGenericAdaptor;
  BoxIsArrayOpAdaptor(BoxIsArrayOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class BoxIsArrayOp : public ::mlir::Op<BoxIsArrayOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::Type>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::OneOperand, ::mlir::OpTrait::OpInvariants, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = BoxIsArrayOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = BoxIsArrayOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_val = 0;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    return {};
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("fir.box_isarray");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::fir::BoxType> getVal() {
    return ::llvm::cast<::mlir::TypedValue<::fir::BoxType>>(*getODSOperands(0).begin());
  }

  ::mlir::OpOperand &getValMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type resultType0, ::mlir::Value val);
  static BoxIsArrayOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type resultType0, ::mlir::Value val);
  static BoxIsArrayOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type resultType0, ::mlir::Value val);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value val);
  static BoxIsArrayOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value val);
  static BoxIsArrayOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value val);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static BoxIsArrayOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static BoxIsArrayOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static BoxIsArrayOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static BoxIsArrayOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
public:
};

} // namespace fir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::fir::BoxIsArrayOp)

namespace fir {


//===----------------------------------------------------------------------===//
// ::fir::BoxIsPtrOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class BoxIsPtrOpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  BoxIsPtrOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("fir.box_isptr", odsAttrs.getContext());
  }

  BoxIsPtrOpGenericAdaptorBase(BoxIsPtrOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};

} // namespace detail
template <typename RangeT>
class BoxIsPtrOpGenericAdaptor : public detail::BoxIsPtrOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::BoxIsPtrOpGenericAdaptorBase;
  static constexpr int odsIndex_val = 0;
public:
  BoxIsPtrOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  BoxIsPtrOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : BoxIsPtrOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  BoxIsPtrOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : BoxIsPtrOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  BoxIsPtrOpGenericAdaptor(RangeT values, const BoxIsPtrOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = BoxIsPtrOp, typename = std::enable_if_t<std::is_same_v<LateInst, BoxIsPtrOp>>>
  BoxIsPtrOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getVal() {
    return (*getODSOperands(0).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class BoxIsPtrOpAdaptor : public BoxIsPtrOpGenericAdaptor<::mlir::ValueRange> {
public:
  using BoxIsPtrOpGenericAdaptor::BoxIsPtrOpGenericAdaptor;
  BoxIsPtrOpAdaptor(BoxIsPtrOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class BoxIsPtrOp : public ::mlir::Op<BoxIsPtrOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::Type>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::OneOperand, ::mlir::OpTrait::OpInvariants, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = BoxIsPtrOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = BoxIsPtrOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_val = 0;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    return {};
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("fir.box_isptr");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::fir::BoxType> getVal() {
    return ::llvm::cast<::mlir::TypedValue<::fir::BoxType>>(*getODSOperands(0).begin());
  }

  ::mlir::OpOperand &getValMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type resultType0, ::mlir::Value val);
  static BoxIsPtrOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type resultType0, ::mlir::Value val);
  static BoxIsPtrOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type resultType0, ::mlir::Value val);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value val);
  static BoxIsPtrOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value val);
  static BoxIsPtrOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value val);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static BoxIsPtrOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static BoxIsPtrOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static BoxIsPtrOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static BoxIsPtrOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
public:
};

} // namespace fir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::fir::BoxIsPtrOp)

namespace fir {


//===----------------------------------------------------------------------===//
// ::fir::BoxOffsetOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class BoxOffsetOpGenericAdaptorBase {
public:
  struct Properties {
    using fieldTy = fir::BoxFieldAttrAttr;
    fieldTy field;

    auto getField() const {
      auto &propStorage = this->field;
      return ::llvm::cast<fir::BoxFieldAttrAttr>(propStorage);
    }
    void setField(const fir::BoxFieldAttrAttr &propValue) {
      this->field = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.field == this->field &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  BoxOffsetOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("fir.box_offset", odsAttrs.getContext());
  }

  BoxOffsetOpGenericAdaptorBase(BoxOffsetOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  fir::BoxFieldAttrAttr getFieldAttr() {
    auto attr = ::llvm::cast<fir::BoxFieldAttrAttr>(getProperties().field);
    return attr;
  }

  fir::BoxFieldAttr getField();
};

} // namespace detail
template <typename RangeT>
class BoxOffsetOpGenericAdaptor : public detail::BoxOffsetOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::BoxOffsetOpGenericAdaptorBase;
  static constexpr int odsIndex_box_ref = 0;
public:
  BoxOffsetOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  BoxOffsetOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : BoxOffsetOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  BoxOffsetOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : BoxOffsetOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  BoxOffsetOpGenericAdaptor(RangeT values, const BoxOffsetOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = BoxOffsetOp, typename = std::enable_if_t<std::is_same_v<LateInst, BoxOffsetOp>>>
  BoxOffsetOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getBoxRef() {
    return (*getODSOperands(0).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class BoxOffsetOpAdaptor : public BoxOffsetOpGenericAdaptor<::mlir::ValueRange> {
public:
  using BoxOffsetOpGenericAdaptor::BoxOffsetOpGenericAdaptor;
  BoxOffsetOpAdaptor(BoxOffsetOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class BoxOffsetOp : public ::mlir::Op<BoxOffsetOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::Type>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::OneOperand, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = BoxOffsetOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = BoxOffsetOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_box_ref = 0;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("field")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getFieldAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getFieldAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("fir.box_offset");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getBoxRef() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(0).begin());
  }

  ::mlir::OpOperand &getBoxRefMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  fir::BoxFieldAttrAttr getFieldAttr() {
    return ::llvm::cast<fir::BoxFieldAttrAttr>(getProperties().field);
  }

  fir::BoxFieldAttr getField();
  void setFieldAttr(fir::BoxFieldAttrAttr attr) {
    getProperties().field = attr;
  }

  void setField(fir::BoxFieldAttr attrValue);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, mlir::Value boxRef, fir::BoxFieldAttr field);
  static BoxOffsetOp create(::mlir::OpBuilder &builder, ::mlir::Location location, mlir::Value boxRef, fir::BoxFieldAttr field);
  static BoxOffsetOp create(::mlir::ImplicitLocOpBuilder &builder, mlir::Value boxRef, fir::BoxFieldAttr field);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type resultType0, ::mlir::Value box_ref, fir::BoxFieldAttrAttr field);
  static BoxOffsetOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type resultType0, ::mlir::Value box_ref, fir::BoxFieldAttrAttr field);
  static BoxOffsetOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type resultType0, ::mlir::Value box_ref, fir::BoxFieldAttrAttr field);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value box_ref, fir::BoxFieldAttrAttr field);
  static BoxOffsetOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value box_ref, fir::BoxFieldAttrAttr field);
  static BoxOffsetOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value box_ref, fir::BoxFieldAttrAttr field);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type resultType0, ::mlir::Value box_ref, fir::BoxFieldAttr field);
  static BoxOffsetOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type resultType0, ::mlir::Value box_ref, fir::BoxFieldAttr field);
  static BoxOffsetOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type resultType0, ::mlir::Value box_ref, fir::BoxFieldAttr field);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value box_ref, fir::BoxFieldAttr field);
  static BoxOffsetOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value box_ref, fir::BoxFieldAttr field);
  static BoxOffsetOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value box_ref, fir::BoxFieldAttr field);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static BoxOffsetOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static BoxOffsetOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static BoxOffsetOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static BoxOffsetOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};

} // namespace fir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::fir::BoxOffsetOp)

namespace fir {


//===----------------------------------------------------------------------===//
// ::fir::BoxProcHostOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class BoxProcHostOpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  BoxProcHostOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("fir.boxproc_host", odsAttrs.getContext());
  }

  BoxProcHostOpGenericAdaptorBase(BoxProcHostOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};

} // namespace detail
template <typename RangeT>
class BoxProcHostOpGenericAdaptor : public detail::BoxProcHostOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::BoxProcHostOpGenericAdaptorBase;
  static constexpr int odsIndex_val = 0;
public:
  BoxProcHostOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  BoxProcHostOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : BoxProcHostOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  BoxProcHostOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : BoxProcHostOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  BoxProcHostOpGenericAdaptor(RangeT values, const BoxProcHostOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = BoxProcHostOp, typename = std::enable_if_t<std::is_same_v<LateInst, BoxProcHostOp>>>
  BoxProcHostOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getVal() {
    return (*getODSOperands(0).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class BoxProcHostOpAdaptor : public BoxProcHostOpGenericAdaptor<::mlir::ValueRange> {
public:
  using BoxProcHostOpGenericAdaptor::BoxProcHostOpGenericAdaptor;
  BoxProcHostOpAdaptor(BoxProcHostOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class BoxProcHostOp : public ::mlir::Op<BoxProcHostOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::fir::ReferenceType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::OneOperand, ::mlir::OpTrait::OpInvariants, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = BoxProcHostOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = BoxProcHostOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_val = 0;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    return {};
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("fir.boxproc_host");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::fir::BoxProcType> getVal() {
    return ::llvm::cast<::mlir::TypedValue<::fir::BoxProcType>>(*getODSOperands(0).begin());
  }

  ::mlir::OpOperand &getValMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type resultType0, ::mlir::Value val);
  static BoxProcHostOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type resultType0, ::mlir::Value val);
  static BoxProcHostOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type resultType0, ::mlir::Value val);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value val);
  static BoxProcHostOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value val);
  static BoxProcHostOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value val);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static BoxProcHostOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static BoxProcHostOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static BoxProcHostOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static BoxProcHostOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
public:
};

} // namespace fir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::fir::BoxProcHostOp)

namespace fir {


//===----------------------------------------------------------------------===//
// ::fir::BoxRankOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class BoxRankOpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  BoxRankOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("fir.box_rank", odsAttrs.getContext());
  }

  BoxRankOpGenericAdaptorBase(BoxRankOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};

} // namespace detail
template <typename RangeT>
class BoxRankOpGenericAdaptor : public detail::BoxRankOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::BoxRankOpGenericAdaptorBase;
  static constexpr int odsIndex_box = 0;
public:
  BoxRankOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  BoxRankOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : BoxRankOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  BoxRankOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : BoxRankOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  BoxRankOpGenericAdaptor(RangeT values, const BoxRankOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = BoxRankOp, typename = std::enable_if_t<std::is_same_v<LateInst, BoxRankOp>>>
  BoxRankOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getBox() {
    return (*getODSOperands(0).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class BoxRankOpAdaptor : public BoxRankOpGenericAdaptor<::mlir::ValueRange> {
public:
  using BoxRankOpGenericAdaptor::BoxRankOpGenericAdaptor;
  BoxRankOpAdaptor(BoxRankOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class BoxRankOp : public ::mlir::Op<BoxRankOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::Type>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::OneOperand, ::mlir::OpTrait::OpInvariants, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = BoxRankOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = BoxRankOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_box = 0;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    return {};
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("fir.box_rank");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getBox() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(0).begin());
  }

  ::mlir::OpOperand &getBoxMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, mlir::Type resultType, mlir::ValueRange operands, llvm::ArrayRef<mlir::NamedAttribute> attributes = {});
  static BoxRankOp create(::mlir::OpBuilder &builder, ::mlir::Location location, mlir::Type resultType, mlir::ValueRange operands, llvm::ArrayRef<mlir::NamedAttribute> attributes = {});
  static BoxRankOp create(::mlir::ImplicitLocOpBuilder &builder, mlir::Type resultType, mlir::ValueRange operands, llvm::ArrayRef<mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type resultType0, ::mlir::Value box);
  static BoxRankOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type resultType0, ::mlir::Value box);
  static BoxRankOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type resultType0, ::mlir::Value box);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value box);
  static BoxRankOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value box);
  static BoxRankOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value box);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static BoxRankOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static BoxRankOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static BoxRankOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static BoxRankOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
public:
};

} // namespace fir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::fir::BoxRankOp)

namespace fir {


//===----------------------------------------------------------------------===//
// ::fir::BoxTotalElementsOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class BoxTotalElementsOpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  BoxTotalElementsOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("fir.box_total_elements", odsAttrs.getContext());
  }

  BoxTotalElementsOpGenericAdaptorBase(BoxTotalElementsOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};

} // namespace detail
template <typename RangeT>
class BoxTotalElementsOpGenericAdaptor : public detail::BoxTotalElementsOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::BoxTotalElementsOpGenericAdaptorBase;
  static constexpr int odsIndex_box = 0;
public:
  BoxTotalElementsOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  BoxTotalElementsOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : BoxTotalElementsOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  BoxTotalElementsOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : BoxTotalElementsOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  BoxTotalElementsOpGenericAdaptor(RangeT values, const BoxTotalElementsOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = BoxTotalElementsOp, typename = std::enable_if_t<std::is_same_v<LateInst, BoxTotalElementsOp>>>
  BoxTotalElementsOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getBox() {
    return (*getODSOperands(0).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class BoxTotalElementsOpAdaptor : public BoxTotalElementsOpGenericAdaptor<::mlir::ValueRange> {
public:
  using BoxTotalElementsOpGenericAdaptor::BoxTotalElementsOpGenericAdaptor;
  BoxTotalElementsOpAdaptor(BoxTotalElementsOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class BoxTotalElementsOp : public ::mlir::Op<BoxTotalElementsOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::Type>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::OneOperand, ::mlir::OpTrait::OpInvariants, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = BoxTotalElementsOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = BoxTotalElementsOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_box = 0;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    return {};
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("fir.box_total_elements");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getBox() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(0).begin());
  }

  ::mlir::OpOperand &getBoxMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, mlir::Type resultType, mlir::ValueRange operands, llvm::ArrayRef<mlir::NamedAttribute> attributes = {});
  static BoxTotalElementsOp create(::mlir::OpBuilder &builder, ::mlir::Location location, mlir::Type resultType, mlir::ValueRange operands, llvm::ArrayRef<mlir::NamedAttribute> attributes = {});
  static BoxTotalElementsOp create(::mlir::ImplicitLocOpBuilder &builder, mlir::Type resultType, mlir::ValueRange operands, llvm::ArrayRef<mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type resultType0, ::mlir::Value box);
  static BoxTotalElementsOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type resultType0, ::mlir::Value box);
  static BoxTotalElementsOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type resultType0, ::mlir::Value box);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value box);
  static BoxTotalElementsOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value box);
  static BoxTotalElementsOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value box);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static BoxTotalElementsOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static BoxTotalElementsOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static BoxTotalElementsOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static BoxTotalElementsOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static void getCanonicalizationPatterns(::mlir::RewritePatternSet &results, ::mlir::MLIRContext *context);
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
public:
};

} // namespace fir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::fir::BoxTotalElementsOp)

namespace fir {


//===----------------------------------------------------------------------===//
// ::fir::BoxTypeCodeOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class BoxTypeCodeOpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  BoxTypeCodeOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("fir.box_typecode", odsAttrs.getContext());
  }

  BoxTypeCodeOpGenericAdaptorBase(BoxTypeCodeOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};

} // namespace detail
template <typename RangeT>
class BoxTypeCodeOpGenericAdaptor : public detail::BoxTypeCodeOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::BoxTypeCodeOpGenericAdaptorBase;
  static constexpr int odsIndex_box = 0;
public:
  BoxTypeCodeOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  BoxTypeCodeOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : BoxTypeCodeOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  BoxTypeCodeOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : BoxTypeCodeOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  BoxTypeCodeOpGenericAdaptor(RangeT values, const BoxTypeCodeOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = BoxTypeCodeOp, typename = std::enable_if_t<std::is_same_v<LateInst, BoxTypeCodeOp>>>
  BoxTypeCodeOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getBox() {
    return (*getODSOperands(0).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class BoxTypeCodeOpAdaptor : public BoxTypeCodeOpGenericAdaptor<::mlir::ValueRange> {
public:
  using BoxTypeCodeOpGenericAdaptor::BoxTypeCodeOpGenericAdaptor;
  BoxTypeCodeOpAdaptor(BoxTypeCodeOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class BoxTypeCodeOp : public ::mlir::Op<BoxTypeCodeOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::Type>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::OneOperand, ::mlir::OpTrait::OpInvariants, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = BoxTypeCodeOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = BoxTypeCodeOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_box = 0;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    return {};
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("fir.box_typecode");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getBox() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(0).begin());
  }

  ::mlir::OpOperand &getBoxMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, mlir::Type resultType, mlir::ValueRange operands, llvm::ArrayRef<mlir::NamedAttribute> attributes = {});
  static BoxTypeCodeOp create(::mlir::OpBuilder &builder, ::mlir::Location location, mlir::Type resultType, mlir::ValueRange operands, llvm::ArrayRef<mlir::NamedAttribute> attributes = {});
  static BoxTypeCodeOp create(::mlir::ImplicitLocOpBuilder &builder, mlir::Type resultType, mlir::ValueRange operands, llvm::ArrayRef<mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type resultType0, ::mlir::Value box);
  static BoxTypeCodeOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type resultType0, ::mlir::Value box);
  static BoxTypeCodeOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type resultType0, ::mlir::Value box);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value box);
  static BoxTypeCodeOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value box);
  static BoxTypeCodeOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value box);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static BoxTypeCodeOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static BoxTypeCodeOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static BoxTypeCodeOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static BoxTypeCodeOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
public:
};

} // namespace fir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::fir::BoxTypeCodeOp)

namespace fir {


//===----------------------------------------------------------------------===//
// ::fir::BoxTypeDescOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class BoxTypeDescOpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  BoxTypeDescOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("fir.box_tdesc", odsAttrs.getContext());
  }

  BoxTypeDescOpGenericAdaptorBase(BoxTypeDescOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};

} // namespace detail
template <typename RangeT>
class BoxTypeDescOpGenericAdaptor : public detail::BoxTypeDescOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::BoxTypeDescOpGenericAdaptorBase;
  static constexpr int odsIndex_box = 0;
public:
  BoxTypeDescOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  BoxTypeDescOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : BoxTypeDescOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  BoxTypeDescOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : BoxTypeDescOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  BoxTypeDescOpGenericAdaptor(RangeT values, const BoxTypeDescOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = BoxTypeDescOp, typename = std::enable_if_t<std::is_same_v<LateInst, BoxTypeDescOp>>>
  BoxTypeDescOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getBox() {
    return (*getODSOperands(0).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class BoxTypeDescOpAdaptor : public BoxTypeDescOpGenericAdaptor<::mlir::ValueRange> {
public:
  using BoxTypeDescOpGenericAdaptor::BoxTypeDescOpGenericAdaptor;
  BoxTypeDescOpAdaptor(BoxTypeDescOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class BoxTypeDescOp : public ::mlir::Op<BoxTypeDescOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::fir::TypeDescType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::OneOperand, ::mlir::OpTrait::OpInvariants, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = BoxTypeDescOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = BoxTypeDescOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_box = 0;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    return {};
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("fir.box_tdesc");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getBox() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(0).begin());
  }

  ::mlir::OpOperand &getBoxMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, mlir::Type resultType, mlir::ValueRange operands, llvm::ArrayRef<mlir::NamedAttribute> attributes = {});
  static BoxTypeDescOp create(::mlir::OpBuilder &builder, ::mlir::Location location, mlir::Type resultType, mlir::ValueRange operands, llvm::ArrayRef<mlir::NamedAttribute> attributes = {});
  static BoxTypeDescOp create(::mlir::ImplicitLocOpBuilder &builder, mlir::Type resultType, mlir::ValueRange operands, llvm::ArrayRef<mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type resultType0, ::mlir::Value box);
  static BoxTypeDescOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type resultType0, ::mlir::Value box);
  static BoxTypeDescOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type resultType0, ::mlir::Value box);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value box);
  static BoxTypeDescOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value box);
  static BoxTypeDescOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value box);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static BoxTypeDescOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static BoxTypeDescOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static BoxTypeDescOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static BoxTypeDescOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
public:
};

} // namespace fir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::fir::BoxTypeDescOp)

namespace fir {


//===----------------------------------------------------------------------===//
// ::fir::CallOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class CallOpGenericAdaptorBase {
public:
  struct Properties {
    using accessGroupsTy = ::mlir::ArrayAttr;
    accessGroupsTy accessGroups;

    auto getAccessGroups() const {
      auto &propStorage = this->accessGroups;
      return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(propStorage);
    }
    void setAccessGroups(const ::mlir::ArrayAttr &propValue) {
      this->accessGroups = propValue;
    }
    using arg_attrsTy = ::mlir::ArrayAttr;
    arg_attrsTy arg_attrs;

    auto getArgAttrs() const {
      auto &propStorage = this->arg_attrs;
      return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(propStorage);
    }
    void setArgAttrs(const ::mlir::ArrayAttr &propValue) {
      this->arg_attrs = propValue;
    }
    using calleeTy = ::mlir::SymbolRefAttr;
    calleeTy callee;

    auto getCallee() const {
      auto &propStorage = this->callee;
      return ::llvm::dyn_cast_or_null<::mlir::SymbolRefAttr>(propStorage);
    }
    void setCallee(const ::mlir::SymbolRefAttr &propValue) {
      this->callee = propValue;
    }
    using fastmathTy = ::mlir::arith::FastMathFlagsAttr;
    fastmathTy fastmath;

    auto getFastmath() const {
      auto &propStorage = this->fastmath;
      return ::llvm::dyn_cast_or_null<::mlir::arith::FastMathFlagsAttr>(propStorage);
    }
    void setFastmath(const ::mlir::arith::FastMathFlagsAttr &propValue) {
      this->fastmath = propValue;
    }
    using inline_attrTy = ::fir::FortranInlineEnumAttr;
    inline_attrTy inline_attr;

    auto getInlineAttr() const {
      auto &propStorage = this->inline_attr;
      return ::llvm::dyn_cast_or_null<::fir::FortranInlineEnumAttr>(propStorage);
    }
    void setInlineAttr(const ::fir::FortranInlineEnumAttr &propValue) {
      this->inline_attr = propValue;
    }
    using procedure_attrsTy = ::fir::FortranProcedureFlagsEnumAttr;
    procedure_attrsTy procedure_attrs;

    auto getProcedureAttrs() const {
      auto &propStorage = this->procedure_attrs;
      return ::llvm::dyn_cast_or_null<::fir::FortranProcedureFlagsEnumAttr>(propStorage);
    }
    void setProcedureAttrs(const ::fir::FortranProcedureFlagsEnumAttr &propValue) {
      this->procedure_attrs = propValue;
    }
    using res_attrsTy = ::mlir::ArrayAttr;
    res_attrsTy res_attrs;

    auto getResAttrs() const {
      auto &propStorage = this->res_attrs;
      return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(propStorage);
    }
    void setResAttrs(const ::mlir::ArrayAttr &propValue) {
      this->res_attrs = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.accessGroups == this->accessGroups &&
        rhs.arg_attrs == this->arg_attrs &&
        rhs.callee == this->callee &&
        rhs.fastmath == this->fastmath &&
        rhs.inline_attr == this->inline_attr &&
        rhs.procedure_attrs == this->procedure_attrs &&
        rhs.res_attrs == this->res_attrs &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  CallOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("fir.call", odsAttrs.getContext());
  }

  CallOpGenericAdaptorBase(CallOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize);
  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::SymbolRefAttr getCalleeAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::SymbolRefAttr>(getProperties().callee);
    return attr;
  }

  ::std::optional< ::mlir::SymbolRefAttr > getCallee();
  ::mlir::ArrayAttr getArgAttrsAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().arg_attrs);
    return attr;
  }

  ::std::optional< ::mlir::ArrayAttr > getArgAttrs();
  ::mlir::ArrayAttr getResAttrsAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().res_attrs);
    return attr;
  }

  ::std::optional< ::mlir::ArrayAttr > getResAttrs();
  ::fir::FortranProcedureFlagsEnumAttr getProcedureAttrsAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::fir::FortranProcedureFlagsEnumAttr>(getProperties().procedure_attrs);
    return attr;
  }

  ::std::optional<::fir::FortranProcedureFlagsEnum> getProcedureAttrs();
  ::fir::FortranInlineEnumAttr getInlineAttrAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::fir::FortranInlineEnumAttr>(getProperties().inline_attr);
    return attr;
  }

  ::std::optional<::fir::FortranInlineEnum> getInlineAttr();
  ::mlir::ArrayAttr getAccessGroupsAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().accessGroups);
    return attr;
  }

  ::std::optional< ::mlir::ArrayAttr > getAccessGroups();
  ::mlir::arith::FastMathFlagsAttr getFastmathAttr();
  ::mlir::arith::FastMathFlags getFastmath();
};

} // namespace detail
template <typename RangeT>
class CallOpGenericAdaptor : public detail::CallOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::CallOpGenericAdaptorBase;
  static constexpr int odsIndex_args = 0;
public:
  CallOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  CallOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : CallOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  CallOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : CallOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  CallOpGenericAdaptor(RangeT values, const CallOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = CallOp, typename = std::enable_if_t<std::is_same_v<LateInst, CallOp>>>
  CallOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  RangeT getArgs() {
    return getODSOperands(0);
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class CallOpAdaptor : public CallOpGenericAdaptor<::mlir::ValueRange> {
public:
  using CallOpGenericAdaptor::CallOpGenericAdaptor;
  CallOpAdaptor(CallOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class CallOp : public ::mlir::Op<CallOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::VariadicResults, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::VariadicOperands, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::ArgAndResultAttrsOpInterface::Trait, ::mlir::CallOpInterface::Trait, ::mlir::arith::ArithFastMathInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = CallOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = CallOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_args = 0;
  using Properties = FoldAdaptor::Properties;
  using ::mlir::arith::ArithFastMathInterface::Trait<CallOp>::getFastMathFlagsAttr;
  using ::mlir::arith::ArithFastMathInterface::Trait<CallOp>::getFastMathAttrName;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("accessGroups"), ::llvm::StringRef("arg_attrs"), ::llvm::StringRef("callee"), ::llvm::StringRef("fastmath"), ::llvm::StringRef("inline_attr"), ::llvm::StringRef("procedure_attrs"), ::llvm::StringRef("res_attrs")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getAccessGroupsAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getAccessGroupsAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getArgAttrsAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getArgAttrsAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  ::mlir::StringAttr getCalleeAttrName() {
    return getAttributeNameForIndex(2);
  }

  static ::mlir::StringAttr getCalleeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 2);
  }

  ::mlir::StringAttr getFastmathAttrName() {
    return getAttributeNameForIndex(3);
  }

  static ::mlir::StringAttr getFastmathAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 3);
  }

  ::mlir::StringAttr getInlineAttrAttrName() {
    return getAttributeNameForIndex(4);
  }

  static ::mlir::StringAttr getInlineAttrAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 4);
  }

  ::mlir::StringAttr getProcedureAttrsAttrName() {
    return getAttributeNameForIndex(5);
  }

  static ::mlir::StringAttr getProcedureAttrsAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 5);
  }

  ::mlir::StringAttr getResAttrsAttrName() {
    return getAttributeNameForIndex(6);
  }

  static ::mlir::StringAttr getResAttrsAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 6);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("fir.call");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index);
  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::Operation::operand_range getArgs() {
    return getODSOperands(0);
  }

  ::mlir::MutableOperandRange getArgsMutable();
  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index);
  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::SymbolRefAttr getCalleeAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::SymbolRefAttr>(getProperties().callee);
  }

  ::std::optional< ::mlir::SymbolRefAttr > getCallee();
  ::mlir::ArrayAttr getArgAttrsAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().arg_attrs);
  }

  ::std::optional< ::mlir::ArrayAttr > getArgAttrs();
  ::mlir::ArrayAttr getResAttrsAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().res_attrs);
  }

  ::std::optional< ::mlir::ArrayAttr > getResAttrs();
  ::fir::FortranProcedureFlagsEnumAttr getProcedureAttrsAttr() {
    return ::llvm::dyn_cast_or_null<::fir::FortranProcedureFlagsEnumAttr>(getProperties().procedure_attrs);
  }

  ::std::optional<::fir::FortranProcedureFlagsEnum> getProcedureAttrs();
  ::fir::FortranInlineEnumAttr getInlineAttrAttr() {
    return ::llvm::dyn_cast_or_null<::fir::FortranInlineEnumAttr>(getProperties().inline_attr);
  }

  ::std::optional<::fir::FortranInlineEnum> getInlineAttr();
  ::mlir::ArrayAttr getAccessGroupsAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().accessGroups);
  }

  ::std::optional< ::mlir::ArrayAttr > getAccessGroups();
  ::mlir::arith::FastMathFlagsAttr getFastmathAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::arith::FastMathFlagsAttr>(getProperties().fastmath);
  }

  ::mlir::arith::FastMathFlags getFastmath();
  void setCalleeAttr(::mlir::SymbolRefAttr attr) {
    getProperties().callee = attr;
  }

  void setArgAttrsAttr(::mlir::ArrayAttr attr) {
    getProperties().arg_attrs = attr;
  }

  void setResAttrsAttr(::mlir::ArrayAttr attr) {
    getProperties().res_attrs = attr;
  }

  void setProcedureAttrsAttr(::fir::FortranProcedureFlagsEnumAttr attr) {
    getProperties().procedure_attrs = attr;
  }

  void setProcedureAttrs(::std::optional<::fir::FortranProcedureFlagsEnum> attrValue);
  void setInlineAttrAttr(::fir::FortranInlineEnumAttr attr) {
    getProperties().inline_attr = attr;
  }

  void setInlineAttr(::std::optional<::fir::FortranInlineEnum> attrValue);
  void setAccessGroupsAttr(::mlir::ArrayAttr attr) {
    getProperties().accessGroups = attr;
  }

  void setFastmathAttr(::mlir::arith::FastMathFlagsAttr attr) {
    getProperties().fastmath = attr;
  }

  void setFastmath(::mlir::arith::FastMathFlags attrValue);
  ::mlir::Attribute removeCalleeAttr() {
      auto attr = getProperties().callee;
      getProperties().callee = {};
      return attr;
  }

  ::mlir::Attribute removeArgAttrsAttr() {
      auto attr = getProperties().arg_attrs;
      getProperties().arg_attrs = {};
      return attr;
  }

  ::mlir::Attribute removeResAttrsAttr() {
      auto attr = getProperties().res_attrs;
      getProperties().res_attrs = {};
      return attr;
  }

  ::mlir::Attribute removeProcedureAttrsAttr() {
      auto attr = getProperties().procedure_attrs;
      getProperties().procedure_attrs = {};
      return attr;
  }

  ::mlir::Attribute removeInlineAttrAttr() {
      auto attr = getProperties().inline_attr;
      getProperties().inline_attr = {};
      return attr;
  }

  ::mlir::Attribute removeAccessGroupsAttr() {
      auto attr = getProperties().accessGroups;
      getProperties().accessGroups = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, mlir::func::FuncOp callee, mlir::ValueRange operands = {});
  static CallOp create(::mlir::OpBuilder &builder, ::mlir::Location location, mlir::func::FuncOp callee, mlir::ValueRange operands = {});
  static CallOp create(::mlir::ImplicitLocOpBuilder &builder, mlir::func::FuncOp callee, mlir::ValueRange operands = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, mlir::SymbolRefAttr callee, llvm::ArrayRef<mlir::Type> results, mlir::ValueRange operands = {});
  static CallOp create(::mlir::OpBuilder &builder, ::mlir::Location location, mlir::SymbolRefAttr callee, llvm::ArrayRef<mlir::Type> results, mlir::ValueRange operands = {});
  static CallOp create(::mlir::ImplicitLocOpBuilder &builder, mlir::SymbolRefAttr callee, llvm::ArrayRef<mlir::Type> results, mlir::ValueRange operands = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, llvm::StringRef callee, llvm::ArrayRef<mlir::Type> results, mlir::ValueRange operands = {});
  static CallOp create(::mlir::OpBuilder &builder, ::mlir::Location location, llvm::StringRef callee, llvm::ArrayRef<mlir::Type> results, mlir::ValueRange operands = {});
  static CallOp create(::mlir::ImplicitLocOpBuilder &builder, llvm::StringRef callee, llvm::ArrayRef<mlir::Type> results, mlir::ValueRange operands = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultType0, /*optional*/::mlir::SymbolRefAttr callee, ::mlir::ValueRange args, /*optional*/::mlir::ArrayAttr arg_attrs, /*optional*/::mlir::ArrayAttr res_attrs, /*optional*/::fir::FortranProcedureFlagsEnumAttr procedure_attrs, /*optional*/::fir::FortranInlineEnumAttr inline_attr, /*optional*/::mlir::ArrayAttr accessGroups, ::mlir::arith::FastMathFlagsAttr fastmath);
  static CallOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultType0, /*optional*/::mlir::SymbolRefAttr callee, ::mlir::ValueRange args, /*optional*/::mlir::ArrayAttr arg_attrs, /*optional*/::mlir::ArrayAttr res_attrs, /*optional*/::fir::FortranProcedureFlagsEnumAttr procedure_attrs, /*optional*/::fir::FortranInlineEnumAttr inline_attr, /*optional*/::mlir::ArrayAttr accessGroups, ::mlir::arith::FastMathFlagsAttr fastmath);
  static CallOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultType0, /*optional*/::mlir::SymbolRefAttr callee, ::mlir::ValueRange args, /*optional*/::mlir::ArrayAttr arg_attrs, /*optional*/::mlir::ArrayAttr res_attrs, /*optional*/::fir::FortranProcedureFlagsEnumAttr procedure_attrs, /*optional*/::fir::FortranInlineEnumAttr inline_attr, /*optional*/::mlir::ArrayAttr accessGroups, ::mlir::arith::FastMathFlagsAttr fastmath);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultType0, /*optional*/::mlir::SymbolRefAttr callee, ::mlir::ValueRange args, /*optional*/::mlir::ArrayAttr arg_attrs, /*optional*/::mlir::ArrayAttr res_attrs, /*optional*/::fir::FortranProcedureFlagsEnumAttr procedure_attrs, /*optional*/::fir::FortranInlineEnumAttr inline_attr, /*optional*/::mlir::ArrayAttr accessGroups, ::mlir::arith::FastMathFlags fastmath = ::mlir::arith::FastMathFlags::none);
  static CallOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultType0, /*optional*/::mlir::SymbolRefAttr callee, ::mlir::ValueRange args, /*optional*/::mlir::ArrayAttr arg_attrs, /*optional*/::mlir::ArrayAttr res_attrs, /*optional*/::fir::FortranProcedureFlagsEnumAttr procedure_attrs, /*optional*/::fir::FortranInlineEnumAttr inline_attr, /*optional*/::mlir::ArrayAttr accessGroups, ::mlir::arith::FastMathFlags fastmath = ::mlir::arith::FastMathFlags::none);
  static CallOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultType0, /*optional*/::mlir::SymbolRefAttr callee, ::mlir::ValueRange args, /*optional*/::mlir::ArrayAttr arg_attrs, /*optional*/::mlir::ArrayAttr res_attrs, /*optional*/::fir::FortranProcedureFlagsEnumAttr procedure_attrs, /*optional*/::fir::FortranInlineEnumAttr inline_attr, /*optional*/::mlir::ArrayAttr accessGroups, ::mlir::arith::FastMathFlags fastmath = ::mlir::arith::FastMathFlags::none);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CallOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CallOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CallOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CallOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static void populateDefaultProperties(::mlir::OperationName opName, Properties &properties);
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &p);
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::llvm::LogicalResult setPropertiesFromParsedAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 7 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
  static constexpr llvm::StringRef getCalleeAttrNameStr() { return "callee"; }

  mlir::FunctionType getFunctionType();

  /// Get the argument operands to the called function.
  operand_range getArgOperands() {
    if ((*this)->getAttrOfType<mlir::SymbolRefAttr>(getCalleeAttrName()))
      return {arg_operand_begin(), arg_operand_end()};
    return {arg_operand_begin() + 1, arg_operand_end()};
  }

  mlir::MutableOperandRange getArgOperandsMutable() {
    if ((*this)->getAttrOfType<mlir::SymbolRefAttr>(getCalleeAttrName()))
      return getArgsMutable();
    return mlir::MutableOperandRange(*this, 1, getArgs().size() - 1);
  }

  operand_iterator arg_operand_begin() { return operand_begin(); }
  operand_iterator arg_operand_end() { return operand_end(); }

  /// Return the callee of this operation.
  mlir::CallInterfaceCallable getCallableForCallee() {
    if (auto calling =
        (*this)->getAttrOfType<mlir::SymbolRefAttr>(getCalleeAttrName()))
      return calling;
    return getOperand(0);
  }

  /// Set the callee for this operation.
  void setCalleeFromCallable(mlir::CallInterfaceCallable callee) {
    if (auto calling =
        (*this)->getAttrOfType<mlir::SymbolRefAttr>(getCalleeAttrName()))
      (*this)->setAttr(getCalleeAttrName(),
                       llvm::cast<mlir::SymbolRefAttr>(callee));
    setOperand(0, llvm::cast<mlir::Value>(callee));
  }
};

} // namespace fir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::fir::CallOp)

namespace fir {


//===----------------------------------------------------------------------===//
// ::fir::CharConvertOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class CharConvertOpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  CharConvertOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("fir.char_convert", odsAttrs.getContext());
  }

  CharConvertOpGenericAdaptorBase(CharConvertOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};

} // namespace detail
template <typename RangeT>
class CharConvertOpGenericAdaptor : public detail::CharConvertOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::CharConvertOpGenericAdaptorBase;
  static constexpr int odsIndex_from = 0;
  static constexpr int odsIndex_count = 1;
  static constexpr int odsIndex_to = 2;
public:
  CharConvertOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  CharConvertOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : CharConvertOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  CharConvertOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : CharConvertOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  CharConvertOpGenericAdaptor(RangeT values, const CharConvertOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = CharConvertOp, typename = std::enable_if_t<std::is_same_v<LateInst, CharConvertOp>>>
  CharConvertOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getFrom() {
    return (*getODSOperands(0).begin());
  }

  ValueT getCount() {
    return (*getODSOperands(1).begin());
  }

  ValueT getTo() {
    return (*getODSOperands(2).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class CharConvertOpAdaptor : public CharConvertOpGenericAdaptor<::mlir::ValueRange> {
public:
  using CharConvertOpGenericAdaptor::CharConvertOpGenericAdaptor;
  CharConvertOpAdaptor(CharConvertOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class CharConvertOp : public ::mlir::Op<CharConvertOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::ZeroResults, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<3>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = CharConvertOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = CharConvertOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_from = 0;
  static constexpr int odsIndex_count = 1;
  static constexpr int odsIndex_to = 2;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    return {};
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("fir.char_convert");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getFrom() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::Type> getCount() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(1).begin());
  }

  ::mlir::TypedValue<::mlir::Type> getTo() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(2).begin());
  }

  ::mlir::OpOperand &getFromMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getCountMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getToMutable() {
    auto range = getODSOperandIndexAndLength(2);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value from, ::mlir::Value count, ::mlir::Value to);
  static CharConvertOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value from, ::mlir::Value count, ::mlir::Value to);
  static CharConvertOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value from, ::mlir::Value count, ::mlir::Value to);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value from, ::mlir::Value count, ::mlir::Value to);
  static CharConvertOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value from, ::mlir::Value count, ::mlir::Value to);
  static CharConvertOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value from, ::mlir::Value count, ::mlir::Value to);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CharConvertOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CharConvertOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CharConvertOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CharConvertOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
public:
};

} // namespace fir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::fir::CharConvertOp)

namespace fir {


//===----------------------------------------------------------------------===//
// ::fir::CmpcOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class CmpcOpGenericAdaptorBase {
public:
  struct Properties {
    using fastmathTy = ::mlir::arith::FastMathFlagsAttr;
    fastmathTy fastmath;

    auto getFastmath() const {
      auto &propStorage = this->fastmath;
      return ::llvm::dyn_cast_or_null<::mlir::arith::FastMathFlagsAttr>(propStorage);
    }
    void setFastmath(const ::mlir::arith::FastMathFlagsAttr &propValue) {
      this->fastmath = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.fastmath == this->fastmath &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  CmpcOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("fir.cmpc", odsAttrs.getContext());
  }

  CmpcOpGenericAdaptorBase(CmpcOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::arith::FastMathFlagsAttr getFastmathAttr();
  ::mlir::arith::FastMathFlags getFastmath();
};

} // namespace detail
template <typename RangeT>
class CmpcOpGenericAdaptor : public detail::CmpcOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::CmpcOpGenericAdaptorBase;
  static constexpr int odsIndex_lhs = 0;
  static constexpr int odsIndex_rhs = 1;
public:
  CmpcOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  CmpcOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : CmpcOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  CmpcOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : CmpcOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  CmpcOpGenericAdaptor(RangeT values, const CmpcOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = CmpcOp, typename = std::enable_if_t<std::is_same_v<LateInst, CmpcOp>>>
  CmpcOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getLhs() {
    return (*getODSOperands(0).begin());
  }

  ValueT getRhs() {
    return (*getODSOperands(1).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class CmpcOpAdaptor : public CmpcOpGenericAdaptor<::mlir::ValueRange> {
public:
  using CmpcOpGenericAdaptor::CmpcOpGenericAdaptor;
  CmpcOpAdaptor(CmpcOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class CmpcOp : public ::mlir::Op<CmpcOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::Type>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<2>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::OpTrait::SameTypeOperands, ::mlir::OpTrait::SameOperandsAndResultShape, ::mlir::arith::ArithFastMathInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = CmpcOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = CmpcOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_lhs = 0;
  static constexpr int odsIndex_rhs = 1;
  using Properties = FoldAdaptor::Properties;
  using ::mlir::arith::ArithFastMathInterface::Trait<CmpcOp>::getFastMathFlagsAttr;
  using ::mlir::arith::ArithFastMathInterface::Trait<CmpcOp>::getFastMathAttrName;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("fastmath")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getFastmathAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getFastmathAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("fir.cmpc");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getLhs() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::Type> getRhs() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(1).begin());
  }

  ::mlir::OpOperand &getLhsMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getRhsMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::arith::FastMathFlagsAttr getFastmathAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::arith::FastMathFlagsAttr>(getProperties().fastmath);
  }

  ::mlir::arith::FastMathFlags getFastmath();
  void setFastmathAttr(::mlir::arith::FastMathFlagsAttr attr) {
    getProperties().fastmath = attr;
  }

  void setFastmath(::mlir::arith::FastMathFlags attrValue);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, mlir::arith::CmpFPredicate predicate, mlir::Value lhs, mlir::Value rhs);
  static CmpcOp create(::mlir::OpBuilder &builder, ::mlir::Location location, mlir::arith::CmpFPredicate predicate, mlir::Value lhs, mlir::Value rhs);
  static CmpcOp create(::mlir::ImplicitLocOpBuilder &builder, mlir::arith::CmpFPredicate predicate, mlir::Value lhs, mlir::Value rhs);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type resultType0, ::mlir::Value lhs, ::mlir::Value rhs, ::mlir::arith::FastMathFlagsAttr fastmath);
  static CmpcOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type resultType0, ::mlir::Value lhs, ::mlir::Value rhs, ::mlir::arith::FastMathFlagsAttr fastmath);
  static CmpcOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type resultType0, ::mlir::Value lhs, ::mlir::Value rhs, ::mlir::arith::FastMathFlagsAttr fastmath);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value lhs, ::mlir::Value rhs, ::mlir::arith::FastMathFlagsAttr fastmath);
  static CmpcOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value lhs, ::mlir::Value rhs, ::mlir::arith::FastMathFlagsAttr fastmath);
  static CmpcOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value lhs, ::mlir::Value rhs, ::mlir::arith::FastMathFlagsAttr fastmath);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type resultType0, ::mlir::Value lhs, ::mlir::Value rhs, ::mlir::arith::FastMathFlags fastmath = ::mlir::arith::FastMathFlags::none);
  static CmpcOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type resultType0, ::mlir::Value lhs, ::mlir::Value rhs, ::mlir::arith::FastMathFlags fastmath = ::mlir::arith::FastMathFlags::none);
  static CmpcOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type resultType0, ::mlir::Value lhs, ::mlir::Value rhs, ::mlir::arith::FastMathFlags fastmath = ::mlir::arith::FastMathFlags::none);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value lhs, ::mlir::Value rhs, ::mlir::arith::FastMathFlags fastmath = ::mlir::arith::FastMathFlags::none);
  static CmpcOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value lhs, ::mlir::Value rhs, ::mlir::arith::FastMathFlags fastmath = ::mlir::arith::FastMathFlags::none);
  static CmpcOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value lhs, ::mlir::Value rhs, ::mlir::arith::FastMathFlags fastmath = ::mlir::arith::FastMathFlags::none);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CmpcOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CmpcOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CmpcOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CmpcOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static void populateDefaultProperties(::mlir::OperationName opName, Properties &properties);
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &p);
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::llvm::LogicalResult setPropertiesFromParsedAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
  static constexpr llvm::StringRef getPredicateAttrName() {
    return "predicate";
  }

  mlir::arith::CmpFPredicate getPredicate() {
    return (mlir::arith::CmpFPredicate)(*this)->getAttrOfType<mlir::IntegerAttr>(
        getPredicateAttrName()).getInt();
  }

  static mlir::arith::CmpFPredicate getPredicateByName(llvm::StringRef name);
};

} // namespace fir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::fir::CmpcOp)

namespace fir {


//===----------------------------------------------------------------------===//
// ::fir::ConvertOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class ConvertOpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  ConvertOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("fir.convert", odsAttrs.getContext());
  }

  ConvertOpGenericAdaptorBase(ConvertOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};

} // namespace detail
template <typename RangeT>
class ConvertOpGenericAdaptor : public detail::ConvertOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::ConvertOpGenericAdaptorBase;
  static constexpr int odsIndex_value = 0;
public:
  ConvertOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  ConvertOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : ConvertOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  ConvertOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : ConvertOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  ConvertOpGenericAdaptor(RangeT values, const ConvertOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = ConvertOp, typename = std::enable_if_t<std::is_same_v<LateInst, ConvertOp>>>
  ConvertOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getValue() {
    return (*getODSOperands(0).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class ConvertOpAdaptor : public ConvertOpGenericAdaptor<::mlir::ValueRange> {
public:
  using ConvertOpGenericAdaptor::ConvertOpGenericAdaptor;
  ConvertOpAdaptor(ConvertOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class ConvertOp : public ::mlir::Op<ConvertOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::Type>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::OneOperand, ::mlir::OpTrait::OpInvariants, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::ViewLikeOpInterface::Trait, ::fir::FortranObjectViewOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = ConvertOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = ConvertOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_value = 0;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    return {};
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("fir.convert");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getValue() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(0).begin());
  }

  ::mlir::OpOperand &getValueMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, mlir::Type resultType, mlir::ValueRange operands, llvm::ArrayRef<mlir::NamedAttribute> attributes = {});
  static ConvertOp create(::mlir::OpBuilder &builder, ::mlir::Location location, mlir::Type resultType, mlir::ValueRange operands, llvm::ArrayRef<mlir::NamedAttribute> attributes = {});
  static ConvertOp create(::mlir::ImplicitLocOpBuilder &builder, mlir::Type resultType, mlir::ValueRange operands, llvm::ArrayRef<mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value value);
  static ConvertOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value value);
  static ConvertOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value value);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value value);
  static ConvertOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value value);
  static ConvertOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value value);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static ConvertOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static ConvertOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ConvertOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ConvertOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  static void getCanonicalizationPatterns(::mlir::RewritePatternSet &results, ::mlir::MLIRContext *context);
  ::mlir::OpFoldResult fold(FoldAdaptor adaptor);
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
public:
  static bool isInteger(mlir::Type ty);
  static bool isIntegerCompatible(mlir::Type ty);
  static bool isFloatCompatible(mlir::Type ty);
  static bool isPointerCompatible(mlir::Type ty);
  static bool canBeConverted(mlir::Type inType, mlir::Type outType);
  static bool areVectorsCompatible(mlir::Type inTy, mlir::Type outTy);

  // ViewLikeOpInterface methods:
  mlir::Value getViewSource() { return getValue(); }

  // FortranObjectViewOpInterface methods:
  mlir::Value getViewSource(mlir::OpResult) { return getValue(); }
  std::optional<std::int64_t> getViewOffset(mlir::OpResult) { return 0; }
};

} // namespace fir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::fir::ConvertOp)

namespace fir {


//===----------------------------------------------------------------------===//
// ::fir::CoordinateOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class CoordinateOpGenericAdaptorBase {
public:
  struct Properties {
    using baseTypeTy = ::mlir::TypeAttr;
    baseTypeTy baseType;

    auto getBaseType() const {
      auto &propStorage = this->baseType;
      return ::llvm::cast<::mlir::TypeAttr>(propStorage);
    }
    void setBaseType(const ::mlir::TypeAttr &propValue) {
      this->baseType = propValue;
    }
    using field_indicesTy = ::mlir::DenseI32ArrayAttr;
    field_indicesTy field_indices;

    auto getFieldIndices() const {
      auto &propStorage = this->field_indices;
      return ::llvm::dyn_cast_or_null<::mlir::DenseI32ArrayAttr>(propStorage);
    }
    void setFieldIndices(const ::mlir::DenseI32ArrayAttr &propValue) {
      this->field_indices = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.baseType == this->baseType &&
        rhs.field_indices == this->field_indices &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  CoordinateOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("fir.coordinate_of", odsAttrs.getContext());
  }

  CoordinateOpGenericAdaptorBase(CoordinateOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize);
  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::TypeAttr getBaseTypeAttr() {
    auto attr = ::llvm::cast<::mlir::TypeAttr>(getProperties().baseType);
    return attr;
  }

  ::mlir::Type getBaseType();
  ::mlir::DenseI32ArrayAttr getFieldIndicesAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::DenseI32ArrayAttr>(getProperties().field_indices);
    return attr;
  }

  ::std::optional<::llvm::ArrayRef<int32_t>> getFieldIndices();
};

} // namespace detail
template <typename RangeT>
class CoordinateOpGenericAdaptor : public detail::CoordinateOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::CoordinateOpGenericAdaptorBase;
  static constexpr int odsIndex_ref = 0;
  static constexpr int odsIndex_coor = 1;
public:
  CoordinateOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  CoordinateOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : CoordinateOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  CoordinateOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : CoordinateOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  CoordinateOpGenericAdaptor(RangeT values, const CoordinateOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = CoordinateOp, typename = std::enable_if_t<std::is_same_v<LateInst, CoordinateOp>>>
  CoordinateOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getRef() {
    return (*getODSOperands(0).begin());
  }

  RangeT getCoor() {
    return getODSOperands(1);
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class CoordinateOpAdaptor : public CoordinateOpGenericAdaptor<::mlir::ValueRange> {
public:
  using CoordinateOpGenericAdaptor::CoordinateOpGenericAdaptor;
  CoordinateOpAdaptor(CoordinateOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class CoordinateOp : public ::mlir::Op<CoordinateOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::Type>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::AtLeastNOperands<1>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::MemoryEffectOpInterface::Trait, ::fir::FortranObjectViewOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = CoordinateOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = CoordinateOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_ref = 0;
  static constexpr int odsIndex_coor = 1;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("baseType"), ::llvm::StringRef("field_indices")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getBaseTypeAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getBaseTypeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getFieldIndicesAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getFieldIndicesAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("fir.coordinate_of");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index);
  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getRef() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(0).begin());
  }

  ::mlir::Operation::operand_range getCoor() {
    return getODSOperands(1);
  }

  ::mlir::OpOperand &getRefMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::MutableOperandRange getCoorMutable();
  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::TypeAttr getBaseTypeAttr() {
    return ::llvm::cast<::mlir::TypeAttr>(getProperties().baseType);
  }

  ::mlir::Type getBaseType();
  ::mlir::DenseI32ArrayAttr getFieldIndicesAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::DenseI32ArrayAttr>(getProperties().field_indices);
  }

  ::std::optional<::llvm::ArrayRef<int32_t>> getFieldIndices();
  void setBaseTypeAttr(::mlir::TypeAttr attr) {
    getProperties().baseType = attr;
  }

  void setBaseType(::mlir::Type attrValue);
  void setFieldIndicesAttr(::mlir::DenseI32ArrayAttr attr) {
    getProperties().field_indices = attr;
  }

  void setFieldIndices(::std::optional<::llvm::ArrayRef<int32_t>> attrValue);
  ::mlir::Attribute removeFieldIndicesAttr() {
      auto attr = getProperties().field_indices;
      getProperties().field_indices = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, mlir::Type resultType, mlir::Value ref, mlir::ValueRange coor);
  static CoordinateOp create(::mlir::OpBuilder &builder, ::mlir::Location location, mlir::Type resultType, mlir::Value ref, mlir::ValueRange coor);
  static CoordinateOp create(::mlir::ImplicitLocOpBuilder &builder, mlir::Type resultType, mlir::Value ref, mlir::ValueRange coor);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, mlir::Type resultType, mlir::Value ref, llvm::ArrayRef<fir::IntOrValue> coor);
  static CoordinateOp create(::mlir::OpBuilder &builder, ::mlir::Location location, mlir::Type resultType, mlir::Value ref, llvm::ArrayRef<fir::IntOrValue> coor);
  static CoordinateOp create(::mlir::ImplicitLocOpBuilder &builder, mlir::Type resultType, mlir::Value ref, llvm::ArrayRef<fir::IntOrValue> coor);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type resultType0, ::mlir::Value ref, ::mlir::ValueRange coor, ::mlir::TypeAttr baseType, /*optional*/::mlir::DenseI32ArrayAttr field_indices);
  static CoordinateOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type resultType0, ::mlir::Value ref, ::mlir::ValueRange coor, ::mlir::TypeAttr baseType, /*optional*/::mlir::DenseI32ArrayAttr field_indices);
  static CoordinateOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type resultType0, ::mlir::Value ref, ::mlir::ValueRange coor, ::mlir::TypeAttr baseType, /*optional*/::mlir::DenseI32ArrayAttr field_indices);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value ref, ::mlir::ValueRange coor, ::mlir::TypeAttr baseType, /*optional*/::mlir::DenseI32ArrayAttr field_indices);
  static CoordinateOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value ref, ::mlir::ValueRange coor, ::mlir::TypeAttr baseType, /*optional*/::mlir::DenseI32ArrayAttr field_indices);
  static CoordinateOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value ref, ::mlir::ValueRange coor, ::mlir::TypeAttr baseType, /*optional*/::mlir::DenseI32ArrayAttr field_indices);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type resultType0, ::mlir::Value ref, ::mlir::ValueRange coor, ::mlir::Type baseType, /*optional*/::mlir::DenseI32ArrayAttr field_indices);
  static CoordinateOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type resultType0, ::mlir::Value ref, ::mlir::ValueRange coor, ::mlir::Type baseType, /*optional*/::mlir::DenseI32ArrayAttr field_indices);
  static CoordinateOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type resultType0, ::mlir::Value ref, ::mlir::ValueRange coor, ::mlir::Type baseType, /*optional*/::mlir::DenseI32ArrayAttr field_indices);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value ref, ::mlir::ValueRange coor, ::mlir::Type baseType, /*optional*/::mlir::DenseI32ArrayAttr field_indices);
  static CoordinateOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value ref, ::mlir::ValueRange coor, ::mlir::Type baseType, /*optional*/::mlir::DenseI32ArrayAttr field_indices);
  static CoordinateOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value ref, ::mlir::ValueRange coor, ::mlir::Type baseType, /*optional*/::mlir::DenseI32ArrayAttr field_indices);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CoordinateOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CoordinateOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CoordinateOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CoordinateOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &p);
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  static ::llvm::LogicalResult setPropertiesFromParsedAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 2 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
  constexpr static int32_t kDynamicIndex = std::numeric_limits<int32_t>::min();
  CoordinateIndicesAdaptor getIndices();

  // FortranObjectViewOpInterface methods:
  mlir::Value getViewSource(mlir::OpResult) { return getRef(); }
  std::optional<std::int64_t> getViewOffset(mlir::OpResult);
};

} // namespace fir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::fir::CoordinateOp)

namespace fir {


//===----------------------------------------------------------------------===//
// ::fir::CopyOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class CopyOpGenericAdaptorBase {
public:
  struct Properties {
    using no_overlapTy = ::mlir::UnitAttr;
    no_overlapTy no_overlap;

    auto getNoOverlap() const {
      auto &propStorage = this->no_overlap;
      return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(propStorage);
    }
    void setNoOverlap(const ::mlir::UnitAttr &propValue) {
      this->no_overlap = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.no_overlap == this->no_overlap &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  CopyOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("fir.copy", odsAttrs.getContext());
  }

  CopyOpGenericAdaptorBase(CopyOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::UnitAttr getNoOverlapAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(getProperties().no_overlap);
    return attr;
  }

  ::std::optional<bool> getNoOverlap();
};

} // namespace detail
template <typename RangeT>
class CopyOpGenericAdaptor : public detail::CopyOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::CopyOpGenericAdaptorBase;
  static constexpr int odsIndex_source = 0;
  static constexpr int odsIndex_destination = 1;
public:
  CopyOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  CopyOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : CopyOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  CopyOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : CopyOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  CopyOpGenericAdaptor(RangeT values, const CopyOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = CopyOp, typename = std::enable_if_t<std::is_same_v<LateInst, CopyOp>>>
  CopyOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getSource() {
    return (*getODSOperands(0).begin());
  }

  ValueT getDestination() {
    return (*getODSOperands(1).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class CopyOpAdaptor : public CopyOpGenericAdaptor<::mlir::ValueRange> {
public:
  using CopyOpGenericAdaptor::CopyOpGenericAdaptor;
  CopyOpAdaptor(CopyOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class CopyOp : public ::mlir::Op<CopyOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::ZeroResults, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<2>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = CopyOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = CopyOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_source = 0;
  static constexpr int odsIndex_destination = 1;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("no_overlap")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getNoOverlapAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getNoOverlapAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("fir.copy");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getSource() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::Type> getDestination() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(1).begin());
  }

  ::mlir::OpOperand &getSourceMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getDestinationMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::UnitAttr getNoOverlapAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(getProperties().no_overlap);
  }

  ::std::optional<bool> getNoOverlap();
  void setNoOverlapAttr(::mlir::UnitAttr attr) {
    getProperties().no_overlap = attr;
  }

  void setNoOverlap(bool attrValue);
  ::mlir::Attribute removeNoOverlapAttr() {
      auto attr = getProperties().no_overlap;
      getProperties().no_overlap = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, mlir::Value source, mlir::Value destination, bool no_overlap = false);
  static CopyOp create(::mlir::OpBuilder &builder, ::mlir::Location location, mlir::Value source, mlir::Value destination, bool no_overlap = false);
  static CopyOp create(::mlir::ImplicitLocOpBuilder &builder, mlir::Value source, mlir::Value destination, bool no_overlap = false);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value source, ::mlir::Value destination, /*optional*/::mlir::UnitAttr no_overlap);
  static CopyOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value source, ::mlir::Value destination, /*optional*/::mlir::UnitAttr no_overlap);
  static CopyOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value source, ::mlir::Value destination, /*optional*/::mlir::UnitAttr no_overlap);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value source, ::mlir::Value destination, /*optional*/::mlir::UnitAttr no_overlap);
  static CopyOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value source, ::mlir::Value destination, /*optional*/::mlir::UnitAttr no_overlap);
  static CopyOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value source, ::mlir::Value destination, /*optional*/::mlir::UnitAttr no_overlap);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CopyOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static CopyOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CopyOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static CopyOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};

} // namespace fir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::fir::CopyOp)

namespace fir {


//===----------------------------------------------------------------------===//
// ::fir::DTComponentOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class DTComponentOpGenericAdaptorBase {
public:
  struct Properties {
    using init_valTy = ::mlir::FlatSymbolRefAttr;
    init_valTy init_val;

    auto getInitVal() const {
      auto &propStorage = this->init_val;
      return ::llvm::dyn_cast_or_null<::mlir::FlatSymbolRefAttr>(propStorage);
    }
    void setInitVal(const ::mlir::FlatSymbolRefAttr &propValue) {
      this->init_val = propValue;
    }
    using lower_boundsTy = ::mlir::DenseI64ArrayAttr;
    lower_boundsTy lower_bounds;

    auto getLowerBounds() const {
      auto &propStorage = this->lower_bounds;
      return ::llvm::dyn_cast_or_null<::mlir::DenseI64ArrayAttr>(propStorage);
    }
    void setLowerBounds(const ::mlir::DenseI64ArrayAttr &propValue) {
      this->lower_bounds = propValue;
    }
    using nameTy = ::mlir::StringAttr;
    nameTy name;

    auto getName() const {
      auto &propStorage = this->name;
      return ::llvm::cast<::mlir::StringAttr>(propStorage);
    }
    void setName(const ::mlir::StringAttr &propValue) {
      this->name = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.init_val == this->init_val &&
        rhs.lower_bounds == this->lower_bounds &&
        rhs.name == this->name &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  DTComponentOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("fir.dt_component", odsAttrs.getContext());
  }

  DTComponentOpGenericAdaptorBase(DTComponentOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::StringAttr getNameAttr() {
    auto attr = ::llvm::cast<::mlir::StringAttr>(getProperties().name);
    return attr;
  }

  ::llvm::StringRef getName();
  ::mlir::DenseI64ArrayAttr getLowerBoundsAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::DenseI64ArrayAttr>(getProperties().lower_bounds);
    return attr;
  }

  ::std::optional<::llvm::ArrayRef<int64_t>> getLowerBounds();
  ::mlir::FlatSymbolRefAttr getInitValAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::FlatSymbolRefAttr>(getProperties().init_val);
    return attr;
  }

  ::std::optional< ::llvm::StringRef > getInitVal();
};

} // namespace detail
template <typename RangeT>
class DTComponentOpGenericAdaptor : public detail::DTComponentOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::DTComponentOpGenericAdaptorBase;
public:
  DTComponentOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  DTComponentOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : DTComponentOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  DTComponentOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : DTComponentOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  DTComponentOpGenericAdaptor(RangeT values, const DTComponentOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = DTComponentOp, typename = std::enable_if_t<std::is_same_v<LateInst, DTComponentOp>>>
  DTComponentOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class DTComponentOpAdaptor : public DTComponentOpGenericAdaptor<::mlir::ValueRange> {
public:
  using DTComponentOpGenericAdaptor::DTComponentOpGenericAdaptor;
  DTComponentOpAdaptor(DTComponentOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class DTComponentOp : public ::mlir::Op<DTComponentOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::ZeroResults, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::ZeroOperands, ::mlir::OpTrait::HasParent<TypeInfoOp>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = DTComponentOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = DTComponentOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("init_val"), ::llvm::StringRef("lower_bounds"), ::llvm::StringRef("name")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getInitValAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getInitValAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getLowerBoundsAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getLowerBoundsAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  ::mlir::StringAttr getNameAttrName() {
    return getAttributeNameForIndex(2);
  }

  static ::mlir::StringAttr getNameAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 2);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("fir.dt_component");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::StringAttr getNameAttr() {
    return ::llvm::cast<::mlir::StringAttr>(getProperties().name);
  }

  ::llvm::StringRef getName();
  ::mlir::DenseI64ArrayAttr getLowerBoundsAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::DenseI64ArrayAttr>(getProperties().lower_bounds);
  }

  ::std::optional<::llvm::ArrayRef<int64_t>> getLowerBounds();
  ::mlir::FlatSymbolRefAttr getInitValAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::FlatSymbolRefAttr>(getProperties().init_val);
  }

  ::std::optional< ::llvm::StringRef > getInitVal();
  void setNameAttr(::mlir::StringAttr attr) {
    getProperties().name = attr;
  }

  void setName(::llvm::StringRef attrValue);
  void setLowerBoundsAttr(::mlir::DenseI64ArrayAttr attr) {
    getProperties().lower_bounds = attr;
  }

  void setLowerBounds(::std::optional<::llvm::ArrayRef<int64_t>> attrValue);
  void setInitValAttr(::mlir::FlatSymbolRefAttr attr) {
    getProperties().init_val = attr;
  }

  void setInitVal(::std::optional<::llvm::StringRef> attrValue);
  ::mlir::Attribute removeLowerBoundsAttr() {
      auto attr = getProperties().lower_bounds;
      getProperties().lower_bounds = {};
      return attr;
  }

  ::mlir::Attribute removeInitValAttr() {
      auto attr = getProperties().init_val;
      getProperties().init_val = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::StringAttr name, /*optional*/::mlir::DenseI64ArrayAttr lower_bounds, /*optional*/::mlir::FlatSymbolRefAttr init_val);
  static DTComponentOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::StringAttr name, /*optional*/::mlir::DenseI64ArrayAttr lower_bounds, /*optional*/::mlir::FlatSymbolRefAttr init_val);
  static DTComponentOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::StringAttr name, /*optional*/::mlir::DenseI64ArrayAttr lower_bounds, /*optional*/::mlir::FlatSymbolRefAttr init_val);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::StringAttr name, /*optional*/::mlir::DenseI64ArrayAttr lower_bounds, /*optional*/::mlir::FlatSymbolRefAttr init_val);
  static DTComponentOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::StringAttr name, /*optional*/::mlir::DenseI64ArrayAttr lower_bounds, /*optional*/::mlir::FlatSymbolRefAttr init_val);
  static DTComponentOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::StringAttr name, /*optional*/::mlir::DenseI64ArrayAttr lower_bounds, /*optional*/::mlir::FlatSymbolRefAttr init_val);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::llvm::StringRef name, /*optional*/::mlir::DenseI64ArrayAttr lower_bounds, /*optional*/::mlir::FlatSymbolRefAttr init_val);
  static DTComponentOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::llvm::StringRef name, /*optional*/::mlir::DenseI64ArrayAttr lower_bounds, /*optional*/::mlir::FlatSymbolRefAttr init_val);
  static DTComponentOp create(::mlir::ImplicitLocOpBuilder &builder, ::llvm::StringRef name, /*optional*/::mlir::DenseI64ArrayAttr lower_bounds, /*optional*/::mlir::FlatSymbolRefAttr init_val);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::llvm::StringRef name, /*optional*/::mlir::DenseI64ArrayAttr lower_bounds, /*optional*/::mlir::FlatSymbolRefAttr init_val);
  static DTComponentOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::llvm::StringRef name, /*optional*/::mlir::DenseI64ArrayAttr lower_bounds, /*optional*/::mlir::FlatSymbolRefAttr init_val);
  static DTComponentOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::llvm::StringRef name, /*optional*/::mlir::DenseI64ArrayAttr lower_bounds, /*optional*/::mlir::FlatSymbolRefAttr init_val);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static DTComponentOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static DTComponentOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static DTComponentOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static DTComponentOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 3 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};

} // namespace fir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::fir::DTComponentOp)

namespace fir {


//===----------------------------------------------------------------------===//
// ::fir::DTEntryOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class DTEntryOpGenericAdaptorBase {
public:
  struct Properties {
    using deferredTy = ::mlir::UnitAttr;
    deferredTy deferred;

    auto getDeferred() const {
      auto &propStorage = this->deferred;
      return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(propStorage);
    }
    void setDeferred(const ::mlir::UnitAttr &propValue) {
      this->deferred = propValue;
    }
    using methodTy = ::mlir::StringAttr;
    methodTy method;

    auto getMethod() const {
      auto &propStorage = this->method;
      return ::llvm::cast<::mlir::StringAttr>(propStorage);
    }
    void setMethod(const ::mlir::StringAttr &propValue) {
      this->method = propValue;
    }
    using procTy = ::mlir::SymbolRefAttr;
    procTy proc;

    auto getProc() const {
      auto &propStorage = this->proc;
      return ::llvm::cast<::mlir::SymbolRefAttr>(propStorage);
    }
    void setProc(const ::mlir::SymbolRefAttr &propValue) {
      this->proc = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.deferred == this->deferred &&
        rhs.method == this->method &&
        rhs.proc == this->proc &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  DTEntryOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("fir.dt_entry", odsAttrs.getContext());
  }

  DTEntryOpGenericAdaptorBase(DTEntryOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::StringAttr getMethodAttr() {
    auto attr = ::llvm::cast<::mlir::StringAttr>(getProperties().method);
    return attr;
  }

  ::llvm::StringRef getMethod();
  ::mlir::SymbolRefAttr getProcAttr() {
    auto attr = ::llvm::cast<::mlir::SymbolRefAttr>(getProperties().proc);
    return attr;
  }

  ::mlir::SymbolRefAttr getProc();
  ::mlir::UnitAttr getDeferredAttr();
  bool getDeferred();
};

} // namespace detail
template <typename RangeT>
class DTEntryOpGenericAdaptor : public detail::DTEntryOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::DTEntryOpGenericAdaptorBase;
public:
  DTEntryOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  DTEntryOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : DTEntryOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  DTEntryOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : DTEntryOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  DTEntryOpGenericAdaptor(RangeT values, const DTEntryOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = DTEntryOp, typename = std::enable_if_t<std::is_same_v<LateInst, DTEntryOp>>>
  DTEntryOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class DTEntryOpAdaptor : public DTEntryOpGenericAdaptor<::mlir::ValueRange> {
public:
  using DTEntryOpGenericAdaptor::DTEntryOpGenericAdaptor;
  DTEntryOpAdaptor(DTEntryOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class DTEntryOp : public ::mlir::Op<DTEntryOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::ZeroResults, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::ZeroOperands, ::mlir::OpTrait::HasParent<TypeInfoOp>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = DTEntryOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = DTEntryOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("deferred"), ::llvm::StringRef("method"), ::llvm::StringRef("proc")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getDeferredAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getDeferredAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getMethodAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getMethodAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  ::mlir::StringAttr getProcAttrName() {
    return getAttributeNameForIndex(2);
  }

  static ::mlir::StringAttr getProcAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 2);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("fir.dt_entry");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::StringAttr getMethodAttr() {
    return ::llvm::cast<::mlir::StringAttr>(getProperties().method);
  }

  ::llvm::StringRef getMethod();
  ::mlir::SymbolRefAttr getProcAttr() {
    return ::llvm::cast<::mlir::SymbolRefAttr>(getProperties().proc);
  }

  ::mlir::SymbolRefAttr getProc();
  ::mlir::UnitAttr getDeferredAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(getProperties().deferred);
  }

  bool getDeferred();
  void setMethodAttr(::mlir::StringAttr attr) {
    getProperties().method = attr;
  }

  void setMethod(::llvm::StringRef attrValue);
  void setProcAttr(::mlir::SymbolRefAttr attr) {
    getProperties().proc = attr;
  }

  void setDeferredAttr(::mlir::UnitAttr attr) {
    getProperties().deferred = attr;
  }

  void setDeferred(bool attrValue);
  ::mlir::Attribute removeDeferredAttr() {
      auto attr = getProperties().deferred;
      getProperties().deferred = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::StringAttr method, ::mlir::SymbolRefAttr proc, /*optional*/::mlir::UnitAttr deferred = nullptr);
  static DTEntryOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::StringAttr method, ::mlir::SymbolRefAttr proc, /*optional*/::mlir::UnitAttr deferred = nullptr);
  static DTEntryOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::StringAttr method, ::mlir::SymbolRefAttr proc, /*optional*/::mlir::UnitAttr deferred = nullptr);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::StringAttr method, ::mlir::SymbolRefAttr proc, /*optional*/::mlir::UnitAttr deferred = nullptr);
  static DTEntryOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::StringAttr method, ::mlir::SymbolRefAttr proc, /*optional*/::mlir::UnitAttr deferred = nullptr);
  static DTEntryOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::StringAttr method, ::mlir::SymbolRefAttr proc, /*optional*/::mlir::UnitAttr deferred = nullptr);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::llvm::StringRef method, ::mlir::SymbolRefAttr proc, /*optional*/bool deferred = false);
  static DTEntryOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::llvm::StringRef method, ::mlir::SymbolRefAttr proc, /*optional*/bool deferred = false);
  static DTEntryOp create(::mlir::ImplicitLocOpBuilder &builder, ::llvm::StringRef method, ::mlir::SymbolRefAttr proc, /*optional*/bool deferred = false);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::llvm::StringRef method, ::mlir::SymbolRefAttr proc, /*optional*/bool deferred = false);
  static DTEntryOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::llvm::StringRef method, ::mlir::SymbolRefAttr proc, /*optional*/bool deferred = false);
  static DTEntryOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::llvm::StringRef method, ::mlir::SymbolRefAttr proc, /*optional*/bool deferred = false);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static DTEntryOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static DTEntryOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static DTEntryOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static DTEntryOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &p);
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::llvm::LogicalResult setPropertiesFromParsedAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 3 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
  static constexpr llvm::StringRef getProcAttrNameStr() { return "proc"; }
  static constexpr llvm::StringRef getDeferredAttrNameStr() {
    return "deferred";
  }
};

} // namespace fir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::fir::DTEntryOp)

namespace fir {


//===----------------------------------------------------------------------===//
// ::fir::DeclareOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class DeclareOpGenericAdaptorBase {
public:
  struct Properties {
    using data_attrTy = ::cuf::DataAttributeAttr;
    data_attrTy data_attr;

    auto getDataAttr() const {
      auto &propStorage = this->data_attr;
      return ::llvm::dyn_cast_or_null<::cuf::DataAttributeAttr>(propStorage);
    }
    void setDataAttr(const ::cuf::DataAttributeAttr &propValue) {
      this->data_attr = propValue;
    }
    using dummy_arg_noTy = ::mlir::IntegerAttr;
    dummy_arg_noTy dummy_arg_no;

    auto getDummyArgNo() const {
      auto &propStorage = this->dummy_arg_no;
      return ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(propStorage);
    }
    void setDummyArgNo(const ::mlir::IntegerAttr &propValue) {
      this->dummy_arg_no = propValue;
    }
    using fortran_attrsTy = ::fir::FortranVariableFlagsAttr;
    fortran_attrsTy fortran_attrs;

    auto getFortranAttrs() const {
      auto &propStorage = this->fortran_attrs;
      return ::llvm::dyn_cast_or_null<::fir::FortranVariableFlagsAttr>(propStorage);
    }
    void setFortranAttrs(const ::fir::FortranVariableFlagsAttr &propValue) {
      this->fortran_attrs = propValue;
    }
    using storage_offsetTy = ::mlir::IntegerAttr;
    storage_offsetTy storage_offset;

    auto getStorageOffset() const {
      auto &propStorage = this->storage_offset;
      return ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(propStorage);
    }
    void setStorageOffset(const ::mlir::IntegerAttr &propValue) {
      this->storage_offset = propValue;
    }
    using uniq_nameTy = ::mlir::StringAttr;
    uniq_nameTy uniq_name;

    auto getUniqName() const {
      auto &propStorage = this->uniq_name;
      return ::llvm::cast<::mlir::StringAttr>(propStorage);
    }
    void setUniqName(const ::mlir::StringAttr &propValue) {
      this->uniq_name = propValue;
    }
    using operandSegmentSizesTy = std::array<int32_t, 5>;
    operandSegmentSizesTy operandSegmentSizes;
    ::llvm::ArrayRef<int32_t> getOperandSegmentSizes() const {
      auto &propStorage = this->operandSegmentSizes;
      return propStorage;
    }
    void setOperandSegmentSizes(::llvm::ArrayRef<int32_t> propValue) {
      auto &propStorage = this->operandSegmentSizes;
      ::llvm::copy(propValue, propStorage.begin());
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.data_attr == this->data_attr &&
        rhs.dummy_arg_no == this->dummy_arg_no &&
        rhs.fortran_attrs == this->fortran_attrs &&
        rhs.storage_offset == this->storage_offset &&
        rhs.uniq_name == this->uniq_name &&
        rhs.operandSegmentSizes == this->operandSegmentSizes &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  DeclareOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("fir.declare", odsAttrs.getContext());
  }

  DeclareOpGenericAdaptorBase(DeclareOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize);
  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::IntegerAttr getStorageOffsetAttr();
  uint64_t getStorageOffset();
  ::mlir::StringAttr getUniqNameAttr() {
    auto attr = ::llvm::cast<::mlir::StringAttr>(getProperties().uniq_name);
    return attr;
  }

  ::mlir::StringAttr getUniqName();
  ::fir::FortranVariableFlagsAttr getFortranAttrsAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::fir::FortranVariableFlagsAttr>(getProperties().fortran_attrs);
    return attr;
  }

  ::std::optional<::fir::FortranVariableFlagsEnum> getFortranAttrs();
  ::cuf::DataAttributeAttr getDataAttrAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::cuf::DataAttributeAttr>(getProperties().data_attr);
    return attr;
  }

  ::std::optional<::cuf::DataAttribute> getDataAttr();
  ::mlir::IntegerAttr getDummyArgNoAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(getProperties().dummy_arg_no);
    return attr;
  }

  ::std::optional<uint32_t> getDummyArgNo();
};

} // namespace detail
template <typename RangeT>
class DeclareOpGenericAdaptor : public detail::DeclareOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::DeclareOpGenericAdaptorBase;
  static constexpr int odsIndex_memref = 0;
  static constexpr int odsIndex_shape = 1;
  static constexpr int odsIndex_typeparams = 2;
  static constexpr int odsIndex_dummy_scope = 3;
  static constexpr int odsIndex_storage = 4;
public:
  DeclareOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  DeclareOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : DeclareOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  DeclareOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs) : DeclareOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  DeclareOpGenericAdaptor(RangeT values, const DeclareOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = DeclareOp, typename = std::enable_if_t<std::is_same_v<LateInst, DeclareOp>>>
  DeclareOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getMemref() {
    return (*getODSOperands(0).begin());
  }

  ValueT getShape() {
    auto operands = getODSOperands(1);
    return operands.empty() ? ValueT{} : (*operands.begin());
  }

  RangeT getTypeparams() {
    return getODSOperands(2);
  }

  ValueT getDummyScope() {
    auto operands = getODSOperands(3);
    return operands.empty() ? ValueT{} : (*operands.begin());
  }

  ValueT getStorage() {
    auto operands = getODSOperands(4);
    return operands.empty() ? ValueT{} : (*operands.begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class DeclareOpAdaptor : public DeclareOpGenericAdaptor<::mlir::ValueRange> {
public:
  using DeclareOpGenericAdaptor::DeclareOpGenericAdaptor;
  DeclareOpAdaptor(DeclareOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class DeclareOp : public ::mlir::Op<DeclareOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::Type>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::AtLeastNOperands<1>::Impl, ::mlir::OpTrait::AttrSizedOperandSegments, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::MemoryEffectOpInterface::Trait, fir::FortranVariableOpInterface::Trait, fir::FortranVariableStorageOpInterface::Trait, ::fir::FortranObjectViewOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = DeclareOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = DeclareOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_memref = 0;
  static constexpr int odsIndex_shape = 1;
  static constexpr int odsIndex_typeparams = 2;
  static constexpr int odsIndex_dummy_scope = 3;
  static constexpr int odsIndex_storage = 4;
  using Properties = FoldAdaptor::Properties;
  using fir::FortranVariableStorageOpInterface::Trait<DeclareOp>::getStorage;
  using fir::FortranVariableStorageOpInterface::Trait<DeclareOp>::getStorageOffset;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("data_attr"), ::llvm::StringRef("dummy_arg_no"), ::llvm::StringRef("fortran_attrs"), ::llvm::StringRef("storage_offset"), ::llvm::StringRef("uniq_name"), ::llvm::StringRef("operandSegmentSizes")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getDataAttrAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getDataAttrAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getDummyArgNoAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getDummyArgNoAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  ::mlir::StringAttr getFortranAttrsAttrName() {
    return getAttributeNameForIndex(2);
  }

  static ::mlir::StringAttr getFortranAttrsAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 2);
  }

  ::mlir::StringAttr getStorageOffsetAttrName() {
    return getAttributeNameForIndex(3);
  }

  static ::mlir::StringAttr getStorageOffsetAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 3);
  }

  ::mlir::StringAttr getUniqNameAttrName() {
    return getAttributeNameForIndex(4);
  }

  static ::mlir::StringAttr getUniqNameAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 4);
  }

  ::mlir::StringAttr getOperandSegmentSizesAttrName() {
   return (*this)->getName().getAttributeNames().back();
  }

  static ::mlir::StringAttr getOperandSegmentSizesAttrName(::mlir::OperationName name) {
   return name.getAttributeNames().back();
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("fir.declare");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index);
  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getMemref() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::Type> getShape() {
    auto operands = getODSOperands(1);
    return operands.empty() ? ::mlir::TypedValue<::mlir::Type>{} : ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*operands.begin());
  }

  ::mlir::Operation::operand_range getTypeparams() {
    return getODSOperands(2);
  }

  ::mlir::TypedValue<::fir::DummyScopeType> getDummyScope() {
    auto operands = getODSOperands(3);
    return operands.empty() ? ::mlir::TypedValue<::fir::DummyScopeType>{} : ::llvm::cast<::mlir::TypedValue<::fir::DummyScopeType>>(*operands.begin());
  }

  ::mlir::TypedValue<::mlir::Type> getStorage() {
    auto operands = getODSOperands(4);
    return operands.empty() ? ::mlir::TypedValue<::mlir::Type>{} : ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*operands.begin());
  }

  ::mlir::OpOperand &getMemrefMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::MutableOperandRange getShapeMutable();
  ::mlir::MutableOperandRange getTypeparamsMutable();
  ::mlir::MutableOperandRange getDummyScopeMutable();
  ::mlir::MutableOperandRange getStorageMutable();
  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::IntegerAttr getStorageOffsetAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(getProperties().storage_offset);
  }

  uint64_t getStorageOffset();
  ::mlir::StringAttr getUniqNameAttr() {
    return ::llvm::cast<::mlir::StringAttr>(getProperties().uniq_name);
  }

  ::mlir::StringAttr getUniqName();
  ::fir::FortranVariableFlagsAttr getFortranAttrsAttr() {
    return ::llvm::dyn_cast_or_null<::fir::FortranVariableFlagsAttr>(getProperties().fortran_attrs);
  }

  ::std::optional<::fir::FortranVariableFlagsEnum> getFortranAttrs();
  ::cuf::DataAttributeAttr getDataAttrAttr() {
    return ::llvm::dyn_cast_or_null<::cuf::DataAttributeAttr>(getProperties().data_attr);
  }

  ::std::optional<::cuf::DataAttribute> getDataAttr();
  ::mlir::IntegerAttr getDummyArgNoAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(getProperties().dummy_arg_no);
  }

  ::std::optional<uint32_t> getDummyArgNo();
  void setStorageOffsetAttr(::mlir::IntegerAttr attr) {
    getProperties().storage_offset = attr;
  }

  void setStorageOffset(uint64_t attrValue);
  void setUniqNameAttr(::mlir::StringAttr attr) {
    getProperties().uniq_name = attr;
  }

  void setFortranAttrsAttr(::fir::FortranVariableFlagsAttr attr) {
    getProperties().fortran_attrs = attr;
  }

  void setFortranAttrs(::std::optional<::fir::FortranVariableFlagsEnum> attrValue);
  void setDataAttrAttr(::cuf::DataAttributeAttr attr) {
    getProperties().data_attr = attr;
  }

  void setDataAttr(::std::optional<::cuf::DataAttribute> attrValue);
  void setDummyArgNoAttr(::mlir::IntegerAttr attr) {
    getProperties().dummy_arg_no = attr;
  }

  void setDummyArgNo(::std::optional<uint32_t> attrValue);
  ::mlir::Attribute removeFortranAttrsAttr() {
      auto attr = getProperties().fortran_attrs;
      getProperties().fortran_attrs = {};
      return attr;
  }

  ::mlir::Attribute removeDataAttrAttr() {
      auto attr = getProperties().data_attr;
      getProperties().data_attr = {};
      return attr;
  }

  ::mlir::Attribute removeDummyArgNoAttr() {
      auto attr = getProperties().dummy_arg_no;
      getProperties().dummy_arg_no = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type resultType0, ::mlir::Value memref, /*optional*/::mlir::Value shape, ::mlir::ValueRange typeparams, /*optional*/::mlir::Value dummy_scope, /*optional*/::mlir::Value storage, ::mlir::IntegerAttr storage_offset, ::mlir::StringAttr uniq_name, /*optional*/::fir::FortranVariableFlagsAttr fortran_attrs, /*optional*/::cuf::DataAttributeAttr data_attr, /*optional*/::mlir::IntegerAttr dummy_arg_no);
  static DeclareOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type resultType0, ::mlir::Value memref, /*optional*/::mlir::Value shape, ::mlir::ValueRange typeparams, /*optional*/::mlir::Value dummy_scope, /*optional*/::mlir::Value storage, ::mlir::IntegerAttr storage_offset, ::mlir::StringAttr uniq_name, /*optional*/::fir::FortranVariableFlagsAttr fortran_attrs, /*optional*/::cuf::DataAttributeAttr data_attr, /*optional*/::mlir::IntegerAttr dummy_arg_no);
  static DeclareOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type resultType0, ::mlir::Value memref, /*optional*/::mlir::Value shape, ::mlir::ValueRange typeparams, /*optional*/::mlir::Value dummy_scope, /*optional*/::mlir::Value storage, ::mlir::IntegerAttr storage_offset, ::mlir::StringAttr uniq_name, /*optional*/::fir::FortranVariableFlagsAttr fortran_attrs, /*optional*/::cuf::DataAttributeAttr data_attr, /*optional*/::mlir::IntegerAttr dummy_arg_no);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value memref, /*optional*/::mlir::Value shape, ::mlir::ValueRange typeparams, /*optional*/::mlir::Value dummy_scope, /*optional*/::mlir::Value storage, ::mlir::IntegerAttr storage_offset, ::mlir::StringAttr uniq_name, /*optional*/::fir::FortranVariableFlagsAttr fortran_attrs, /*optional*/::cuf::DataAttributeAttr data_attr, /*optional*/::mlir::IntegerAttr dummy_arg_no);
  static DeclareOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value memref, /*optional*/::mlir::Value shape, ::mlir::ValueRange typeparams, /*optional*/::mlir::Value dummy_scope, /*optional*/::mlir::Value storage, ::mlir::IntegerAttr storage_offset, ::mlir::StringAttr uniq_name, /*optional*/::fir::FortranVariableFlagsAttr fortran_attrs, /*optional*/::cuf::DataAttributeAttr data_attr, /*optional*/::mlir::IntegerAttr dummy_arg_no);
  static DeclareOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value memref, /*optional*/::mlir::Value shape, ::mlir::ValueRange typeparams, /*optional*/::mlir::Value dummy_scope, /*optional*/::mlir::Value storage, ::mlir::IntegerAttr storage_offset, ::mlir::StringAttr uniq_name, /*optional*/::fir::FortranVariableFlagsAttr fortran_attrs, /*optional*/::cuf::DataAttributeAttr data_attr, /*optional*/::mlir::IntegerAttr dummy_arg_no);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type resultType0, ::mlir::Value memref, /*optional*/::mlir::Value shape, ::mlir::ValueRange typeparams, /*optional*/::mlir::Value dummy_scope, /*optional*/::mlir::Value storage, uint64_t storage_offset, ::mlir::StringAttr uniq_name, /*optional*/::fir::FortranVariableFlagsAttr fortran_attrs, /*optional*/::cuf::DataAttributeAttr data_attr, /*optional*/::mlir::IntegerAttr dummy_arg_no);
  static DeclareOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type resultType0, ::mlir::Value memref, /*optional*/::mlir::Value shape, ::mlir::ValueRange typeparams, /*optional*/::mlir::Value dummy_scope, /*optional*/::mlir::Value storage, uint64_t storage_offset, ::mlir::StringAttr uniq_name, /*optional*/::fir::FortranVariableFlagsAttr fortran_attrs, /*optional*/::cuf::DataAttributeAttr data_attr, /*optional*/::mlir::IntegerAttr dummy_arg_no);
  static DeclareOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type resultType0, ::mlir::Value memref, /*optional*/::mlir::Value shape, ::mlir::ValueRange typeparams, /*optional*/::mlir::Value dummy_scope, /*optional*/::mlir::Value storage, uint64_t storage_offset, ::mlir::StringAttr uniq_name, /*optional*/::fir::FortranVariableFlagsAttr fortran_attrs, /*optional*/::cuf::DataAttributeAttr data_attr, /*optional*/::mlir::IntegerAttr dummy_arg_no);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value memref, /*optional*/::mlir::Value shape, ::mlir::ValueRange typeparams, /*optional*/::mlir::Value dummy_scope, /*optional*/::mlir::Value storage, uint64_t storage_offset, ::mlir::StringAttr uniq_name, /*optional*/::fir::FortranVariableFlagsAttr fortran_attrs, /*optional*/::cuf::DataAttributeAttr data_attr, /*optional*/::mlir::IntegerAttr dummy_arg_no);
  static DeclareOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value memref, /*optional*/::mlir::Value shape, ::mlir::ValueRange typeparams, /*optional*/::mlir::Value dummy_scope, /*optional*/::mlir::Value storage, uint64_t storage_offset, ::mlir::StringAttr uniq_name, /*optional*/::fir::FortranVariableFlagsAttr fortran_attrs, /*optional*/::cuf::DataAttributeAttr data_attr, /*optional*/::mlir::IntegerAttr dummy_arg_no);
  static DeclareOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value memref, /*optional*/::mlir::Value shape, ::mlir::ValueRange typeparams, /*optional*/::mlir::Value dummy_scope, /*optional*/::mlir::Value storage, uint64_t storage_offset, ::mlir::StringAttr uniq_name, /*optional*/::fir::FortranVariableFlagsAttr fortran_attrs, /*optional*/::cuf::DataAttributeAttr data_attr, /*optional*/::mlir::IntegerAttr dummy_arg_no);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static DeclareOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static DeclareOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static DeclareOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static DeclareOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static void populateDefaultProperties(::mlir::OperationName opName, Properties &properties);
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 5 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
  // FortranObjectViewOpInterface methods:
  mlir::Value getViewSource(mlir::OpResult) { return getMemref(); }
  std::optional<std::int64_t> getViewOffset(mlir::OpResult) { return 0; }
};

} // namespace fir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::fir::DeclareOp)

namespace fir {


//===----------------------------------------------------------------------===//
// ::fir::DeclareReductionOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class DeclareReductionOpGenericAdaptorBase {
public:
  struct Properties {
    using byref_element_typeTy = ::mlir::TypeAttr;
    byref_element_typeTy byref_element_type;

    auto getByrefElementType() const {
      auto &propStorage = this->byref_element_type;
      return ::llvm::dyn_cast_or_null<::mlir::TypeAttr>(propStorage);
    }
    void setByrefElementType(const ::mlir::TypeAttr &propValue) {
      this->byref_element_type = propValue;
    }
    using sym_nameTy = ::mlir::StringAttr;
    sym_nameTy sym_name;

    auto getSymName() const {
      auto &propStorage = this->sym_name;
      return ::llvm::cast<::mlir::StringAttr>(propStorage);
    }
    void setSymName(const ::mlir::StringAttr &propValue) {
      this->sym_name = propValue;
    }
    using typeTy = ::mlir::TypeAttr;
    typeTy type;

    auto getType() const {
      auto &propStorage = this->type;
      return ::llvm::cast<::mlir::TypeAttr>(propStorage);
    }
    void setType(const ::mlir::TypeAttr &propValue) {
      this->type = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.byref_element_type == this->byref_element_type &&
        rhs.sym_name == this->sym_name &&
        rhs.type == this->type &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  DeclareReductionOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("fir.declare_reduction", odsAttrs.getContext());
  }

  DeclareReductionOpGenericAdaptorBase(DeclareReductionOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::StringAttr getSymNameAttr() {
    auto attr = ::llvm::cast<::mlir::StringAttr>(getProperties().sym_name);
    return attr;
  }

  ::llvm::StringRef getSymName();
  ::mlir::TypeAttr getTypeAttr() {
    auto attr = ::llvm::cast<::mlir::TypeAttr>(getProperties().type);
    return attr;
  }

  ::mlir::Type getType();
  ::mlir::TypeAttr getByrefElementTypeAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::TypeAttr>(getProperties().byref_element_type);
    return attr;
  }

  ::std::optional<::mlir::Type> getByrefElementType();
  ::mlir::Region &getAllocRegion() {
    return *odsRegions[0];
  }

  ::mlir::Region &getInitializerRegion() {
    return *odsRegions[1];
  }

  ::mlir::Region &getReductionRegion() {
    return *odsRegions[2];
  }

  ::mlir::Region &getAtomicReductionRegion() {
    return *odsRegions[3];
  }

  ::mlir::Region &getCleanupRegion() {
    return *odsRegions[4];
  }

  ::mlir::Region &getDataPtrPtrRegion() {
    return *odsRegions[5];
  }

  ::mlir::RegionRange getRegions() {
    return odsRegions;
  }

};

} // namespace detail
template <typename RangeT>
class DeclareReductionOpGenericAdaptor : public detail::DeclareReductionOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::DeclareReductionOpGenericAdaptorBase;
public:
  DeclareReductionOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  DeclareReductionOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : DeclareReductionOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  DeclareReductionOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : DeclareReductionOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  DeclareReductionOpGenericAdaptor(RangeT values, const DeclareReductionOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = DeclareReductionOp, typename = std::enable_if_t<std::is_same_v<LateInst, DeclareReductionOp>>>
  DeclareReductionOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class DeclareReductionOpAdaptor : public DeclareReductionOpGenericAdaptor<::mlir::ValueRange> {
public:
  using DeclareReductionOpGenericAdaptor::DeclareReductionOpGenericAdaptor;
  DeclareReductionOpAdaptor(DeclareReductionOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class DeclareReductionOp : public ::mlir::Op<DeclareReductionOp, ::mlir::OpTrait::NRegions<6>::Impl, ::mlir::OpTrait::ZeroResults, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::ZeroOperands, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::OpTrait::IsIsolatedFromAbove, ::mlir::SymbolOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = DeclareReductionOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = DeclareReductionOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("byref_element_type"), ::llvm::StringRef("sym_name"), ::llvm::StringRef("type")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getByrefElementTypeAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getByrefElementTypeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getSymNameAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getSymNameAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  ::mlir::StringAttr getTypeAttrName() {
    return getAttributeNameForIndex(2);
  }

  static ::mlir::StringAttr getTypeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 2);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("fir.declare_reduction");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::Region &getAllocRegion() {
    return (*this)->getRegion(0);
  }

  ::mlir::Region &getInitializerRegion() {
    return (*this)->getRegion(1);
  }

  ::mlir::Region &getReductionRegion() {
    return (*this)->getRegion(2);
  }

  ::mlir::Region &getAtomicReductionRegion() {
    return (*this)->getRegion(3);
  }

  ::mlir::Region &getCleanupRegion() {
    return (*this)->getRegion(4);
  }

  ::mlir::Region &getDataPtrPtrRegion() {
    return (*this)->getRegion(5);
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::StringAttr getSymNameAttr() {
    return ::llvm::cast<::mlir::StringAttr>(getProperties().sym_name);
  }

  ::llvm::StringRef getSymName();
  ::mlir::TypeAttr getTypeAttr() {
    return ::llvm::cast<::mlir::TypeAttr>(getProperties().type);
  }

  ::mlir::Type getType();
  ::mlir::TypeAttr getByrefElementTypeAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::TypeAttr>(getProperties().byref_element_type);
  }

  ::std::optional<::mlir::Type> getByrefElementType();
  void setSymNameAttr(::mlir::StringAttr attr) {
    getProperties().sym_name = attr;
  }

  void setSymName(::llvm::StringRef attrValue);
  void setTypeAttr(::mlir::TypeAttr attr) {
    getProperties().type = attr;
  }

  void setType(::mlir::Type attrValue);
  void setByrefElementTypeAttr(::mlir::TypeAttr attr) {
    getProperties().byref_element_type = attr;
  }

  void setByrefElementType(::std::optional<::mlir::Type> attrValue);
  ::mlir::Attribute removeByrefElementTypeAttr() {
      auto attr = getProperties().byref_element_type;
      getProperties().byref_element_type = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::StringAttr sym_name, ::mlir::TypeAttr type, /*optional*/::mlir::TypeAttr byref_element_type);
  static DeclareReductionOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::StringAttr sym_name, ::mlir::TypeAttr type, /*optional*/::mlir::TypeAttr byref_element_type);
  static DeclareReductionOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::StringAttr sym_name, ::mlir::TypeAttr type, /*optional*/::mlir::TypeAttr byref_element_type);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::StringAttr sym_name, ::mlir::TypeAttr type, /*optional*/::mlir::TypeAttr byref_element_type);
  static DeclareReductionOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::StringAttr sym_name, ::mlir::TypeAttr type, /*optional*/::mlir::TypeAttr byref_element_type);
  static DeclareReductionOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::StringAttr sym_name, ::mlir::TypeAttr type, /*optional*/::mlir::TypeAttr byref_element_type);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::llvm::StringRef sym_name, ::mlir::Type type, /*optional*/::mlir::TypeAttr byref_element_type);
  static DeclareReductionOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::llvm::StringRef sym_name, ::mlir::Type type, /*optional*/::mlir::TypeAttr byref_element_type);
  static DeclareReductionOp create(::mlir::ImplicitLocOpBuilder &builder, ::llvm::StringRef sym_name, ::mlir::Type type, /*optional*/::mlir::TypeAttr byref_element_type);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::llvm::StringRef sym_name, ::mlir::Type type, /*optional*/::mlir::TypeAttr byref_element_type);
  static DeclareReductionOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::llvm::StringRef sym_name, ::mlir::Type type, /*optional*/::mlir::TypeAttr byref_element_type);
  static DeclareReductionOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::llvm::StringRef sym_name, ::mlir::Type type, /*optional*/::mlir::TypeAttr byref_element_type);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static DeclareReductionOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static DeclareReductionOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static DeclareReductionOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static DeclareReductionOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verifyRegions();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 3 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
  mlir::BlockArgument getAllocMoldArg() {
    auto &region = getAllocRegion();
    return region.empty() ? nullptr : region.getArgument(0);
  }
  mlir::BlockArgument getInitializerMoldArg() {
    return getInitializerRegion().getArgument(0);
  }
  mlir::BlockArgument getInitializerAllocArg() {
    return getAllocRegion().empty() ?
        nullptr : getInitializerRegion().getArgument(1);
  }
  mlir::BlockArgument getReductionLhsArg() {
    return getReductionRegion().getArgument(0);
  }
  mlir::BlockArgument getReductionRhsArg() {
    return getReductionRegion().getArgument(1);
  }
  mlir::BlockArgument getAtomicReductionLhsArg() {
    auto &region = getAtomicReductionRegion();
    return region.empty() ? nullptr : region.getArgument(0);
  }
  mlir::BlockArgument getAtomicReductionRhsArg() {
    auto &region = getAtomicReductionRegion();
    return region.empty() ? nullptr : region.getArgument(1);
  }
  mlir::BlockArgument getCleanupAllocArg() {
    auto &region = getCleanupRegion();
    return region.empty() ? nullptr : region.getArgument(0);
  }
};

} // namespace fir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::fir::DeclareReductionOp)

namespace fir {


//===----------------------------------------------------------------------===//
// ::fir::DispatchOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class DispatchOpGenericAdaptorBase {
public:
  struct Properties {
    using arg_attrsTy = ::mlir::ArrayAttr;
    arg_attrsTy arg_attrs;

    auto getArgAttrs() const {
      auto &propStorage = this->arg_attrs;
      return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(propStorage);
    }
    void setArgAttrs(const ::mlir::ArrayAttr &propValue) {
      this->arg_attrs = propValue;
    }
    using methodTy = ::mlir::StringAttr;
    methodTy method;

    auto getMethod() const {
      auto &propStorage = this->method;
      return ::llvm::cast<::mlir::StringAttr>(propStorage);
    }
    void setMethod(const ::mlir::StringAttr &propValue) {
      this->method = propValue;
    }
    using pass_arg_posTy = ::mlir::IntegerAttr;
    pass_arg_posTy pass_arg_pos;

    auto getPassArgPos() const {
      auto &propStorage = this->pass_arg_pos;
      return ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(propStorage);
    }
    void setPassArgPos(const ::mlir::IntegerAttr &propValue) {
      this->pass_arg_pos = propValue;
    }
    using procedure_attrsTy = ::fir::FortranProcedureFlagsEnumAttr;
    procedure_attrsTy procedure_attrs;

    auto getProcedureAttrs() const {
      auto &propStorage = this->procedure_attrs;
      return ::llvm::dyn_cast_or_null<::fir::FortranProcedureFlagsEnumAttr>(propStorage);
    }
    void setProcedureAttrs(const ::fir::FortranProcedureFlagsEnumAttr &propValue) {
      this->procedure_attrs = propValue;
    }
    using res_attrsTy = ::mlir::ArrayAttr;
    res_attrsTy res_attrs;

    auto getResAttrs() const {
      auto &propStorage = this->res_attrs;
      return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(propStorage);
    }
    void setResAttrs(const ::mlir::ArrayAttr &propValue) {
      this->res_attrs = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.arg_attrs == this->arg_attrs &&
        rhs.method == this->method &&
        rhs.pass_arg_pos == this->pass_arg_pos &&
        rhs.procedure_attrs == this->procedure_attrs &&
        rhs.res_attrs == this->res_attrs &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  DispatchOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("fir.dispatch", odsAttrs.getContext());
  }

  DispatchOpGenericAdaptorBase(DispatchOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize);
  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::StringAttr getMethodAttr() {
    auto attr = ::llvm::cast<::mlir::StringAttr>(getProperties().method);
    return attr;
  }

  ::llvm::StringRef getMethod();
  ::mlir::IntegerAttr getPassArgPosAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(getProperties().pass_arg_pos);
    return attr;
  }

  ::std::optional<uint32_t> getPassArgPos();
  ::mlir::ArrayAttr getArgAttrsAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().arg_attrs);
    return attr;
  }

  ::std::optional< ::mlir::ArrayAttr > getArgAttrs();
  ::mlir::ArrayAttr getResAttrsAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().res_attrs);
    return attr;
  }

  ::std::optional< ::mlir::ArrayAttr > getResAttrs();
  ::fir::FortranProcedureFlagsEnumAttr getProcedureAttrsAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::fir::FortranProcedureFlagsEnumAttr>(getProperties().procedure_attrs);
    return attr;
  }

  ::std::optional<::fir::FortranProcedureFlagsEnum> getProcedureAttrs();
};

} // namespace detail
template <typename RangeT>
class DispatchOpGenericAdaptor : public detail::DispatchOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::DispatchOpGenericAdaptorBase;
  static constexpr int odsIndex_object = 0;
  static constexpr int odsIndex_args = 1;
public:
  DispatchOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  DispatchOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : DispatchOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  DispatchOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : DispatchOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  DispatchOpGenericAdaptor(RangeT values, const DispatchOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = DispatchOp, typename = std::enable_if_t<std::is_same_v<LateInst, DispatchOp>>>
  DispatchOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getObject() {
    return (*getODSOperands(0).begin());
  }

  RangeT getArgs() {
    return getODSOperands(1);
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class DispatchOpAdaptor : public DispatchOpGenericAdaptor<::mlir::ValueRange> {
public:
  using DispatchOpGenericAdaptor::DispatchOpGenericAdaptor;
  DispatchOpAdaptor(DispatchOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class DispatchOp : public ::mlir::Op<DispatchOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::VariadicResults, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::AtLeastNOperands<1>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = DispatchOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = DispatchOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_object = 0;
  static constexpr int odsIndex_args = 1;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("arg_attrs"), ::llvm::StringRef("method"), ::llvm::StringRef("pass_arg_pos"), ::llvm::StringRef("procedure_attrs"), ::llvm::StringRef("res_attrs")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getArgAttrsAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getArgAttrsAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getMethodAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getMethodAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  ::mlir::StringAttr getPassArgPosAttrName() {
    return getAttributeNameForIndex(2);
  }

  static ::mlir::StringAttr getPassArgPosAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 2);
  }

  ::mlir::StringAttr getProcedureAttrsAttrName() {
    return getAttributeNameForIndex(3);
  }

  static ::mlir::StringAttr getProcedureAttrsAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 3);
  }

  ::mlir::StringAttr getResAttrsAttrName() {
    return getAttributeNameForIndex(4);
  }

  static ::mlir::StringAttr getResAttrsAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 4);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("fir.dispatch");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index);
  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::fir::ClassType> getObject() {
    return ::llvm::cast<::mlir::TypedValue<::fir::ClassType>>(*getODSOperands(0).begin());
  }

  ::mlir::Operation::operand_range getArgs() {
    return getODSOperands(1);
  }

  ::mlir::OpOperand &getObjectMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::MutableOperandRange getArgsMutable();
  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index);
  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::Operation::result_range getResults() {
    return getODSResults(0);
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::StringAttr getMethodAttr() {
    return ::llvm::cast<::mlir::StringAttr>(getProperties().method);
  }

  ::llvm::StringRef getMethod();
  ::mlir::IntegerAttr getPassArgPosAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(getProperties().pass_arg_pos);
  }

  ::std::optional<uint32_t> getPassArgPos();
  ::mlir::ArrayAttr getArgAttrsAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().arg_attrs);
  }

  ::std::optional< ::mlir::ArrayAttr > getArgAttrs();
  ::mlir::ArrayAttr getResAttrsAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().res_attrs);
  }

  ::std::optional< ::mlir::ArrayAttr > getResAttrs();
  ::fir::FortranProcedureFlagsEnumAttr getProcedureAttrsAttr() {
    return ::llvm::dyn_cast_or_null<::fir::FortranProcedureFlagsEnumAttr>(getProperties().procedure_attrs);
  }

  ::std::optional<::fir::FortranProcedureFlagsEnum> getProcedureAttrs();
  void setMethodAttr(::mlir::StringAttr attr) {
    getProperties().method = attr;
  }

  void setMethod(::llvm::StringRef attrValue);
  void setPassArgPosAttr(::mlir::IntegerAttr attr) {
    getProperties().pass_arg_pos = attr;
  }

  void setPassArgPos(::std::optional<uint32_t> attrValue);
  void setArgAttrsAttr(::mlir::ArrayAttr attr) {
    getProperties().arg_attrs = attr;
  }

  void setResAttrsAttr(::mlir::ArrayAttr attr) {
    getProperties().res_attrs = attr;
  }

  void setProcedureAttrsAttr(::fir::FortranProcedureFlagsEnumAttr attr) {
    getProperties().procedure_attrs = attr;
  }

  void setProcedureAttrs(::std::optional<::fir::FortranProcedureFlagsEnum> attrValue);
  ::mlir::Attribute removePassArgPosAttr() {
      auto attr = getProperties().pass_arg_pos;
      getProperties().pass_arg_pos = {};
      return attr;
  }

  ::mlir::Attribute removeArgAttrsAttr() {
      auto attr = getProperties().arg_attrs;
      getProperties().arg_attrs = {};
      return attr;
  }

  ::mlir::Attribute removeResAttrsAttr() {
      auto attr = getProperties().res_attrs;
      getProperties().res_attrs = {};
      return attr;
  }

  ::mlir::Attribute removeProcedureAttrsAttr() {
      auto attr = getProperties().procedure_attrs;
      getProperties().procedure_attrs = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange results, ::mlir::StringAttr method, ::mlir::Value object, ::mlir::ValueRange args, /*optional*/::mlir::IntegerAttr pass_arg_pos, /*optional*/::mlir::ArrayAttr arg_attrs, /*optional*/::mlir::ArrayAttr res_attrs, /*optional*/::fir::FortranProcedureFlagsEnumAttr procedure_attrs);
  static DispatchOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange results, ::mlir::StringAttr method, ::mlir::Value object, ::mlir::ValueRange args, /*optional*/::mlir::IntegerAttr pass_arg_pos, /*optional*/::mlir::ArrayAttr arg_attrs, /*optional*/::mlir::ArrayAttr res_attrs, /*optional*/::fir::FortranProcedureFlagsEnumAttr procedure_attrs);
  static DispatchOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange results, ::mlir::StringAttr method, ::mlir::Value object, ::mlir::ValueRange args, /*optional*/::mlir::IntegerAttr pass_arg_pos, /*optional*/::mlir::ArrayAttr arg_attrs, /*optional*/::mlir::ArrayAttr res_attrs, /*optional*/::fir::FortranProcedureFlagsEnumAttr procedure_attrs);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange results, ::llvm::StringRef method, ::mlir::Value object, ::mlir::ValueRange args, /*optional*/::mlir::IntegerAttr pass_arg_pos, /*optional*/::mlir::ArrayAttr arg_attrs, /*optional*/::mlir::ArrayAttr res_attrs, /*optional*/::fir::FortranProcedureFlagsEnumAttr procedure_attrs);
  static DispatchOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange results, ::llvm::StringRef method, ::mlir::Value object, ::mlir::ValueRange args, /*optional*/::mlir::IntegerAttr pass_arg_pos, /*optional*/::mlir::ArrayAttr arg_attrs, /*optional*/::mlir::ArrayAttr res_attrs, /*optional*/::fir::FortranProcedureFlagsEnumAttr procedure_attrs);
  static DispatchOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange results, ::llvm::StringRef method, ::mlir::Value object, ::mlir::ValueRange args, /*optional*/::mlir::IntegerAttr pass_arg_pos, /*optional*/::mlir::ArrayAttr arg_attrs, /*optional*/::mlir::ArrayAttr res_attrs, /*optional*/::fir::FortranProcedureFlagsEnumAttr procedure_attrs);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static DispatchOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static DispatchOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static DispatchOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static DispatchOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 5 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
  mlir::FunctionType getFunctionType();
  operand_range getArgOperands() {
    return {arg_operand_begin(), arg_operand_end()};
  }
  // operand[0] is the object (of class type)
  operand_iterator arg_operand_begin() { return operand_begin() + 1; }
  operand_iterator arg_operand_end() { return operand_end(); }
};

} // namespace fir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::fir::DispatchOp)

namespace fir {


//===----------------------------------------------------------------------===//
// ::fir::DivcOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class DivcOpGenericAdaptorBase {
public:
  struct Properties {
    using fastmathTy = ::mlir::arith::FastMathFlagsAttr;
    fastmathTy fastmath;

    auto getFastmath() const {
      auto &propStorage = this->fastmath;
      return ::llvm::dyn_cast_or_null<::mlir::arith::FastMathFlagsAttr>(propStorage);
    }
    void setFastmath(const ::mlir::arith::FastMathFlagsAttr &propValue) {
      this->fastmath = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.fastmath == this->fastmath &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  DivcOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("fir.divc", odsAttrs.getContext());
  }

  DivcOpGenericAdaptorBase(DivcOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::arith::FastMathFlagsAttr getFastmathAttr();
  ::mlir::arith::FastMathFlags getFastmath();
};

} // namespace detail
template <typename RangeT>
class DivcOpGenericAdaptor : public detail::DivcOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::DivcOpGenericAdaptorBase;
  static constexpr int odsIndex_lhs = 0;
  static constexpr int odsIndex_rhs = 1;
public:
  DivcOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  DivcOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : DivcOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  DivcOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : DivcOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  DivcOpGenericAdaptor(RangeT values, const DivcOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = DivcOp, typename = std::enable_if_t<std::is_same_v<LateInst, DivcOp>>>
  DivcOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getLhs() {
    return (*getODSOperands(0).begin());
  }

  ValueT getRhs() {
    return (*getODSOperands(1).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class DivcOpAdaptor : public DivcOpGenericAdaptor<::mlir::ValueRange> {
public:
  using DivcOpGenericAdaptor::DivcOpGenericAdaptor;
  DivcOpAdaptor(DivcOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class DivcOp : public ::mlir::Op<DivcOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::Type>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<2>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::arith::ArithFastMathInterface::Trait, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::OpTrait::SameOperandsAndResultType, ::mlir::InferTypeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = DivcOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = DivcOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_lhs = 0;
  static constexpr int odsIndex_rhs = 1;
  using Properties = FoldAdaptor::Properties;
  using ::mlir::arith::ArithFastMathInterface::Trait<DivcOp>::getFastMathFlagsAttr;
  using ::mlir::arith::ArithFastMathInterface::Trait<DivcOp>::getFastMathAttrName;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("fastmath")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getFastmathAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getFastmathAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("fir.divc");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getLhs() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::Type> getRhs() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(1).begin());
  }

  ::mlir::OpOperand &getLhsMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getRhsMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getResult() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::arith::FastMathFlagsAttr getFastmathAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::arith::FastMathFlagsAttr>(getProperties().fastmath);
  }

  ::mlir::arith::FastMathFlags getFastmath();
  void setFastmathAttr(::mlir::arith::FastMathFlagsAttr attr) {
    getProperties().fastmath = attr;
  }

  void setFastmath(::mlir::arith::FastMathFlags attrValue);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type result, ::mlir::Value lhs, ::mlir::Value rhs, ::mlir::arith::FastMathFlagsAttr fastmath);
  static DivcOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type result, ::mlir::Value lhs, ::mlir::Value rhs, ::mlir::arith::FastMathFlagsAttr fastmath);
  static DivcOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type result, ::mlir::Value lhs, ::mlir::Value rhs, ::mlir::arith::FastMathFlagsAttr fastmath);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value lhs, ::mlir::Value rhs, ::mlir::arith::FastMathFlagsAttr fastmath);
  static DivcOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value lhs, ::mlir::Value rhs, ::mlir::arith::FastMathFlagsAttr fastmath);
  static DivcOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value lhs, ::mlir::Value rhs, ::mlir::arith::FastMathFlagsAttr fastmath);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value lhs, ::mlir::Value rhs, ::mlir::arith::FastMathFlagsAttr fastmath);
  static DivcOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value lhs, ::mlir::Value rhs, ::mlir::arith::FastMathFlagsAttr fastmath);
  static DivcOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value lhs, ::mlir::Value rhs, ::mlir::arith::FastMathFlagsAttr fastmath);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type result, ::mlir::Value lhs, ::mlir::Value rhs, ::mlir::arith::FastMathFlags fastmath = ::mlir::arith::FastMathFlags::none);
  static DivcOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type result, ::mlir::Value lhs, ::mlir::Value rhs, ::mlir::arith::FastMathFlags fastmath = ::mlir::arith::FastMathFlags::none);
  static DivcOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type result, ::mlir::Value lhs, ::mlir::Value rhs, ::mlir::arith::FastMathFlags fastmath = ::mlir::arith::FastMathFlags::none);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value lhs, ::mlir::Value rhs, ::mlir::arith::FastMathFlags fastmath = ::mlir::arith::FastMathFlags::none);
  static DivcOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value lhs, ::mlir::Value rhs, ::mlir::arith::FastMathFlags fastmath = ::mlir::arith::FastMathFlags::none);
  static DivcOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value lhs, ::mlir::Value rhs, ::mlir::arith::FastMathFlags fastmath = ::mlir::arith::FastMathFlags::none);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value lhs, ::mlir::Value rhs, ::mlir::arith::FastMathFlags fastmath = ::mlir::arith::FastMathFlags::none);
  static DivcOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value lhs, ::mlir::Value rhs, ::mlir::arith::FastMathFlags fastmath = ::mlir::arith::FastMathFlags::none);
  static DivcOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value lhs, ::mlir::Value rhs, ::mlir::arith::FastMathFlags fastmath = ::mlir::arith::FastMathFlags::none);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static DivcOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static DivcOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static DivcOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static DivcOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static DivcOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static DivcOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static DivcOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static DivcOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static void populateDefaultProperties(::mlir::OperationName opName, Properties &properties);
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::llvm::LogicalResult inferReturnTypes(::mlir::MLIRContext *context, ::std::optional<::mlir::Location> location, ::mlir::ValueRange operands, ::mlir::DictionaryAttr attributes, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions, ::llvm::SmallVectorImpl<::mlir::Type>&inferredReturnTypes);
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};

} // namespace fir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::fir::DivcOp)

namespace fir {


//===----------------------------------------------------------------------===//
// ::fir::DoConcurrentLoopOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class DoConcurrentLoopOpGenericAdaptorBase {
public:
  struct Properties {
    using local_symsTy = ::mlir::ArrayAttr;
    local_symsTy local_syms;

    auto getLocalSyms() const {
      auto &propStorage = this->local_syms;
      return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(propStorage);
    }
    void setLocalSyms(const ::mlir::ArrayAttr &propValue) {
      this->local_syms = propValue;
    }
    using loopAnnotationTy = ::mlir::LLVM::LoopAnnotationAttr;
    loopAnnotationTy loopAnnotation;

    auto getLoopAnnotation() const {
      auto &propStorage = this->loopAnnotation;
      return ::llvm::dyn_cast_or_null<::mlir::LLVM::LoopAnnotationAttr>(propStorage);
    }
    void setLoopAnnotation(const ::mlir::LLVM::LoopAnnotationAttr &propValue) {
      this->loopAnnotation = propValue;
    }
    using reduce_attrsTy = ::mlir::ArrayAttr;
    reduce_attrsTy reduce_attrs;

    auto getReduceAttrs() const {
      auto &propStorage = this->reduce_attrs;
      return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(propStorage);
    }
    void setReduceAttrs(const ::mlir::ArrayAttr &propValue) {
      this->reduce_attrs = propValue;
    }
    using reduce_byrefTy = ::mlir::DenseBoolArrayAttr;
    reduce_byrefTy reduce_byref;

    auto getReduceByref() const {
      auto &propStorage = this->reduce_byref;
      return ::llvm::dyn_cast_or_null<::mlir::DenseBoolArrayAttr>(propStorage);
    }
    void setReduceByref(const ::mlir::DenseBoolArrayAttr &propValue) {
      this->reduce_byref = propValue;
    }
    using reduce_symsTy = ::mlir::ArrayAttr;
    reduce_symsTy reduce_syms;

    auto getReduceSyms() const {
      auto &propStorage = this->reduce_syms;
      return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(propStorage);
    }
    void setReduceSyms(const ::mlir::ArrayAttr &propValue) {
      this->reduce_syms = propValue;
    }
    using operandSegmentSizesTy = std::array<int32_t, 5>;
    operandSegmentSizesTy operandSegmentSizes;
    ::llvm::ArrayRef<int32_t> getOperandSegmentSizes() const {
      auto &propStorage = this->operandSegmentSizes;
      return propStorage;
    }
    void setOperandSegmentSizes(::llvm::ArrayRef<int32_t> propValue) {
      auto &propStorage = this->operandSegmentSizes;
      ::llvm::copy(propValue, propStorage.begin());
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.local_syms == this->local_syms &&
        rhs.loopAnnotation == this->loopAnnotation &&
        rhs.reduce_attrs == this->reduce_attrs &&
        rhs.reduce_byref == this->reduce_byref &&
        rhs.reduce_syms == this->reduce_syms &&
        rhs.operandSegmentSizes == this->operandSegmentSizes &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  DoConcurrentLoopOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("fir.do_concurrent.loop", odsAttrs.getContext());
  }

  DoConcurrentLoopOpGenericAdaptorBase(DoConcurrentLoopOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize);
  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::LLVM::LoopAnnotationAttr getLoopAnnotationAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::LLVM::LoopAnnotationAttr>(getProperties().loopAnnotation);
    return attr;
  }

  ::std::optional<::mlir::LLVM::LoopAnnotationAttr> getLoopAnnotation();
  ::mlir::ArrayAttr getLocalSymsAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().local_syms);
    return attr;
  }

  ::std::optional< ::mlir::ArrayAttr > getLocalSyms();
  ::mlir::DenseBoolArrayAttr getReduceByrefAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::DenseBoolArrayAttr>(getProperties().reduce_byref);
    return attr;
  }

  ::std::optional<::llvm::ArrayRef<bool>> getReduceByref();
  ::mlir::ArrayAttr getReduceSymsAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().reduce_syms);
    return attr;
  }

  ::std::optional< ::mlir::ArrayAttr > getReduceSyms();
  ::mlir::ArrayAttr getReduceAttrsAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().reduce_attrs);
    return attr;
  }

  ::std::optional< ::mlir::ArrayAttr > getReduceAttrs();
  ::mlir::Region &getRegion() {
    return *odsRegions[0];
  }

  ::mlir::RegionRange getRegions() {
    return odsRegions;
  }

};

} // namespace detail
template <typename RangeT>
class DoConcurrentLoopOpGenericAdaptor : public detail::DoConcurrentLoopOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::DoConcurrentLoopOpGenericAdaptorBase;
  static constexpr int odsIndex_lowerBound = 0;
  static constexpr int odsIndex_upperBound = 1;
  static constexpr int odsIndex_step = 2;
  static constexpr int odsIndex_local_vars = 3;
  static constexpr int odsIndex_reduce_vars = 4;
public:
  DoConcurrentLoopOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  DoConcurrentLoopOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : DoConcurrentLoopOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  DoConcurrentLoopOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs) : DoConcurrentLoopOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  DoConcurrentLoopOpGenericAdaptor(RangeT values, const DoConcurrentLoopOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = DoConcurrentLoopOp, typename = std::enable_if_t<std::is_same_v<LateInst, DoConcurrentLoopOp>>>
  DoConcurrentLoopOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  RangeT getLowerBound() {
    return getODSOperands(0);
  }

  RangeT getUpperBound() {
    return getODSOperands(1);
  }

  RangeT getStep() {
    return getODSOperands(2);
  }

  RangeT getLocalVars() {
    return getODSOperands(3);
  }

  RangeT getReduceVars() {
    return getODSOperands(4);
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class DoConcurrentLoopOpAdaptor : public DoConcurrentLoopOpGenericAdaptor<::mlir::ValueRange> {
public:
  using DoConcurrentLoopOpGenericAdaptor::DoConcurrentLoopOpGenericAdaptor;
  DoConcurrentLoopOpAdaptor(DoConcurrentLoopOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class DoConcurrentLoopOp : public ::mlir::Op<DoConcurrentLoopOp, ::mlir::OpTrait::OneRegion, ::mlir::OpTrait::ZeroResults, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::VariadicOperands, ::mlir::OpTrait::AttrSizedOperandSegments, ::mlir::OpTrait::NoTerminator, ::mlir::OpTrait::SingleBlock, ::mlir::OpTrait::HasParent<DoConcurrentOp>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::LoopLikeOpInterface::Trait, ::mlir::OpTrait::IsTerminator> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = DoConcurrentLoopOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = DoConcurrentLoopOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_lowerBound = 0;
  static constexpr int odsIndex_upperBound = 1;
  static constexpr int odsIndex_step = 2;
  static constexpr int odsIndex_local_vars = 3;
  static constexpr int odsIndex_reduce_vars = 4;
  using Properties = FoldAdaptor::Properties;
  using ::mlir::LoopLikeOpInterface::Trait<DoConcurrentLoopOp>::isDefinedOutsideOfLoop;
  using ::mlir::LoopLikeOpInterface::Trait<DoConcurrentLoopOp>::moveOutOfLoop;
  using ::mlir::LoopLikeOpInterface::Trait<DoConcurrentLoopOp>::promoteIfSingleIteration;
  using ::mlir::LoopLikeOpInterface::Trait<DoConcurrentLoopOp>::getLoopLowerBounds;
  using ::mlir::LoopLikeOpInterface::Trait<DoConcurrentLoopOp>::getLoopSteps;
  using ::mlir::LoopLikeOpInterface::Trait<DoConcurrentLoopOp>::getLoopUpperBounds;
  using ::mlir::LoopLikeOpInterface::Trait<DoConcurrentLoopOp>::getInitsMutable;
  using ::mlir::LoopLikeOpInterface::Trait<DoConcurrentLoopOp>::getRegionIterArgs;
  using ::mlir::LoopLikeOpInterface::Trait<DoConcurrentLoopOp>::getYieldedValuesMutable;
  using ::mlir::LoopLikeOpInterface::Trait<DoConcurrentLoopOp>::getLoopResults;
  using ::mlir::LoopLikeOpInterface::Trait<DoConcurrentLoopOp>::replaceWithAdditionalYields;
  using ::mlir::LoopLikeOpInterface::Trait<DoConcurrentLoopOp>::getStaticTripCount;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("local_syms"), ::llvm::StringRef("loopAnnotation"), ::llvm::StringRef("reduce_attrs"), ::llvm::StringRef("reduce_byref"), ::llvm::StringRef("reduce_syms"), ::llvm::StringRef("operandSegmentSizes")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getLocalSymsAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getLocalSymsAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getLoopAnnotationAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getLoopAnnotationAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  ::mlir::StringAttr getReduceAttrsAttrName() {
    return getAttributeNameForIndex(2);
  }

  static ::mlir::StringAttr getReduceAttrsAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 2);
  }

  ::mlir::StringAttr getReduceByrefAttrName() {
    return getAttributeNameForIndex(3);
  }

  static ::mlir::StringAttr getReduceByrefAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 3);
  }

  ::mlir::StringAttr getReduceSymsAttrName() {
    return getAttributeNameForIndex(4);
  }

  static ::mlir::StringAttr getReduceSymsAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 4);
  }

  ::mlir::StringAttr getOperandSegmentSizesAttrName() {
   return (*this)->getName().getAttributeNames().back();
  }

  static ::mlir::StringAttr getOperandSegmentSizesAttrName(::mlir::OperationName name) {
   return name.getAttributeNames().back();
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("fir.do_concurrent.loop");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index);
  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::Operation::operand_range getLowerBound() {
    return getODSOperands(0);
  }

  ::mlir::Operation::operand_range getUpperBound() {
    return getODSOperands(1);
  }

  ::mlir::Operation::operand_range getStep() {
    return getODSOperands(2);
  }

  ::mlir::Operation::operand_range getLocalVars() {
    return getODSOperands(3);
  }

  ::mlir::Operation::operand_range getReduceVars() {
    return getODSOperands(4);
  }

  ::mlir::MutableOperandRange getLowerBoundMutable();
  ::mlir::MutableOperandRange getUpperBoundMutable();
  ::mlir::MutableOperandRange getStepMutable();
  ::mlir::MutableOperandRange getLocalVarsMutable();
  ::mlir::MutableOperandRange getReduceVarsMutable();
  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::Region &getRegion() {
    return (*this)->getRegion(0);
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::LLVM::LoopAnnotationAttr getLoopAnnotationAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::LLVM::LoopAnnotationAttr>(getProperties().loopAnnotation);
  }

  ::std::optional<::mlir::LLVM::LoopAnnotationAttr> getLoopAnnotation();
  ::mlir::ArrayAttr getLocalSymsAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().local_syms);
  }

  ::std::optional< ::mlir::ArrayAttr > getLocalSyms();
  ::mlir::DenseBoolArrayAttr getReduceByrefAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::DenseBoolArrayAttr>(getProperties().reduce_byref);
  }

  ::std::optional<::llvm::ArrayRef<bool>> getReduceByref();
  ::mlir::ArrayAttr getReduceSymsAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().reduce_syms);
  }

  ::std::optional< ::mlir::ArrayAttr > getReduceSyms();
  ::mlir::ArrayAttr getReduceAttrsAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().reduce_attrs);
  }

  ::std::optional< ::mlir::ArrayAttr > getReduceAttrs();
  void setLoopAnnotationAttr(::mlir::LLVM::LoopAnnotationAttr attr) {
    getProperties().loopAnnotation = attr;
  }

  void setLocalSymsAttr(::mlir::ArrayAttr attr) {
    getProperties().local_syms = attr;
  }

  void setReduceByrefAttr(::mlir::DenseBoolArrayAttr attr) {
    getProperties().reduce_byref = attr;
  }

  void setReduceByref(::std::optional<::llvm::ArrayRef<bool>> attrValue);
  void setReduceSymsAttr(::mlir::ArrayAttr attr) {
    getProperties().reduce_syms = attr;
  }

  void setReduceAttrsAttr(::mlir::ArrayAttr attr) {
    getProperties().reduce_attrs = attr;
  }

  ::mlir::Attribute removeLoopAnnotationAttr() {
      auto attr = getProperties().loopAnnotation;
      getProperties().loopAnnotation = {};
      return attr;
  }

  ::mlir::Attribute removeLocalSymsAttr() {
      auto attr = getProperties().local_syms;
      getProperties().local_syms = {};
      return attr;
  }

  ::mlir::Attribute removeReduceByrefAttr() {
      auto attr = getProperties().reduce_byref;
      getProperties().reduce_byref = {};
      return attr;
  }

  ::mlir::Attribute removeReduceSymsAttr() {
      auto attr = getProperties().reduce_syms;
      getProperties().reduce_syms = {};
      return attr;
  }

  ::mlir::Attribute removeReduceAttrsAttr() {
      auto attr = getProperties().reduce_attrs;
      getProperties().reduce_attrs = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange lowerBound, ::mlir::ValueRange upperBound, ::mlir::ValueRange step, /*optional*/::mlir::LLVM::LoopAnnotationAttr loopAnnotation, ::mlir::ValueRange local_vars, /*optional*/::mlir::ArrayAttr local_syms, ::mlir::ValueRange reduce_vars, /*optional*/::mlir::DenseBoolArrayAttr reduce_byref, /*optional*/::mlir::ArrayAttr reduce_syms, /*optional*/::mlir::ArrayAttr reduce_attrs);
  static DoConcurrentLoopOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange lowerBound, ::mlir::ValueRange upperBound, ::mlir::ValueRange step, /*optional*/::mlir::LLVM::LoopAnnotationAttr loopAnnotation, ::mlir::ValueRange local_vars, /*optional*/::mlir::ArrayAttr local_syms, ::mlir::ValueRange reduce_vars, /*optional*/::mlir::DenseBoolArrayAttr reduce_byref, /*optional*/::mlir::ArrayAttr reduce_syms, /*optional*/::mlir::ArrayAttr reduce_attrs);
  static DoConcurrentLoopOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange lowerBound, ::mlir::ValueRange upperBound, ::mlir::ValueRange step, /*optional*/::mlir::LLVM::LoopAnnotationAttr loopAnnotation, ::mlir::ValueRange local_vars, /*optional*/::mlir::ArrayAttr local_syms, ::mlir::ValueRange reduce_vars, /*optional*/::mlir::DenseBoolArrayAttr reduce_byref, /*optional*/::mlir::ArrayAttr reduce_syms, /*optional*/::mlir::ArrayAttr reduce_attrs);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange lowerBound, ::mlir::ValueRange upperBound, ::mlir::ValueRange step, /*optional*/::mlir::LLVM::LoopAnnotationAttr loopAnnotation, ::mlir::ValueRange local_vars, /*optional*/::mlir::ArrayAttr local_syms, ::mlir::ValueRange reduce_vars, /*optional*/::mlir::DenseBoolArrayAttr reduce_byref, /*optional*/::mlir::ArrayAttr reduce_syms, /*optional*/::mlir::ArrayAttr reduce_attrs);
  static DoConcurrentLoopOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange lowerBound, ::mlir::ValueRange upperBound, ::mlir::ValueRange step, /*optional*/::mlir::LLVM::LoopAnnotationAttr loopAnnotation, ::mlir::ValueRange local_vars, /*optional*/::mlir::ArrayAttr local_syms, ::mlir::ValueRange reduce_vars, /*optional*/::mlir::DenseBoolArrayAttr reduce_byref, /*optional*/::mlir::ArrayAttr reduce_syms, /*optional*/::mlir::ArrayAttr reduce_attrs);
  static DoConcurrentLoopOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange lowerBound, ::mlir::ValueRange upperBound, ::mlir::ValueRange step, /*optional*/::mlir::LLVM::LoopAnnotationAttr loopAnnotation, ::mlir::ValueRange local_vars, /*optional*/::mlir::ArrayAttr local_syms, ::mlir::ValueRange reduce_vars, /*optional*/::mlir::DenseBoolArrayAttr reduce_byref, /*optional*/::mlir::ArrayAttr reduce_syms, /*optional*/::mlir::ArrayAttr reduce_attrs);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static DoConcurrentLoopOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static DoConcurrentLoopOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static DoConcurrentLoopOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static DoConcurrentLoopOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &p);
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  ::llvm::SmallVector<::mlir::Region *> getLoopRegions();
  ::std::optional<::llvm::SmallVector<::mlir::Value>> getLoopInductionVars();
  static ::llvm::LogicalResult setPropertiesFromParsedAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 5 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
  unsigned getNumInductionVars() {
    return getLowerBound().size();
  }

  unsigned getNumLocalOperands() {
    return getLocalVars().size();
  }

  unsigned getNumReduceOperands() {
    return getReduceVars().size();
  }

  unsigned getInductionVarsStart() {
    return 0;
  }

  unsigned getLocalOperandsStart() {
    return getNumInductionVars();
  }

  unsigned getReduceOperandsStart() {
    return getLocalOperandsStart() + getNumLocalOperands();
  }

  mlir::Block::BlockArgListType getInductionVars() {
    return getBody()->getArguments().slice(0, getNumInductionVars());
  }

  mlir::Block::BlockArgListType getRegionLocalArgs() {
    return getBody()->getArguments().slice(getNumInductionVars(),
                                           getNumLocalOperands());
  }

  mlir::Block::BlockArgListType getRegionReduceArgs() {
    return getBody()->getArguments().slice(getNumInductionVars()
                                             + getNumLocalOperands(),
                                           getNumReduceOperands());
  }

  /// Number of operands controlling the loop
  unsigned getNumControlOperands() { return getLowerBound().size() * 3; }

};

} // namespace fir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::fir::DoConcurrentLoopOp)

namespace fir {


//===----------------------------------------------------------------------===//
// ::fir::DoConcurrentOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class DoConcurrentOpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  DoConcurrentOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("fir.do_concurrent", odsAttrs.getContext());
  }

  DoConcurrentOpGenericAdaptorBase(DoConcurrentOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::Region &getRegion() {
    return *odsRegions[0];
  }

  ::mlir::RegionRange getRegions() {
    return odsRegions;
  }

};

} // namespace detail
template <typename RangeT>
class DoConcurrentOpGenericAdaptor : public detail::DoConcurrentOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::DoConcurrentOpGenericAdaptorBase;
public:
  DoConcurrentOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  DoConcurrentOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : DoConcurrentOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  DoConcurrentOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : DoConcurrentOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  DoConcurrentOpGenericAdaptor(RangeT values, const DoConcurrentOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = DoConcurrentOp, typename = std::enable_if_t<std::is_same_v<LateInst, DoConcurrentOp>>>
  DoConcurrentOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class DoConcurrentOpAdaptor : public DoConcurrentOpGenericAdaptor<::mlir::ValueRange> {
public:
  using DoConcurrentOpGenericAdaptor::DoConcurrentOpGenericAdaptor;
  DoConcurrentOpAdaptor(DoConcurrentOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class DoConcurrentOp : public ::mlir::Op<DoConcurrentOp, ::mlir::OpTrait::OneRegion, ::mlir::OpTrait::ZeroResults, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::ZeroOperands, ::mlir::OpTrait::SingleBlock, ::mlir::OpTrait::OpInvariants, ::mlir::OpTrait::AutomaticAllocationScope> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = DoConcurrentOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = DoConcurrentOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    return {};
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("fir.do_concurrent");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::Region &getRegion() {
    return (*this)->getRegion(0);
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState);
  static DoConcurrentOp create(::mlir::OpBuilder &builder, ::mlir::Location location);
  static DoConcurrentOp create(::mlir::ImplicitLocOpBuilder &builder);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes);
  static DoConcurrentOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes);
  static DoConcurrentOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static DoConcurrentOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static DoConcurrentOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static DoConcurrentOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static DoConcurrentOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
public:
};

} // namespace fir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::fir::DoConcurrentOp)

namespace fir {


//===----------------------------------------------------------------------===//
// ::fir::DoLoopOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class DoLoopOpGenericAdaptorBase {
public:
  struct Properties {
    using finalValueTy = ::mlir::UnitAttr;
    finalValueTy finalValue;

    auto getFinalValue() const {
      auto &propStorage = this->finalValue;
      return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(propStorage);
    }
    void setFinalValue(const ::mlir::UnitAttr &propValue) {
      this->finalValue = propValue;
    }
    using loopAnnotationTy = ::mlir::LLVM::LoopAnnotationAttr;
    loopAnnotationTy loopAnnotation;

    auto getLoopAnnotation() const {
      auto &propStorage = this->loopAnnotation;
      return ::llvm::dyn_cast_or_null<::mlir::LLVM::LoopAnnotationAttr>(propStorage);
    }
    void setLoopAnnotation(const ::mlir::LLVM::LoopAnnotationAttr &propValue) {
      this->loopAnnotation = propValue;
    }
    using reduceAttrsTy = ::mlir::ArrayAttr;
    reduceAttrsTy reduceAttrs;

    auto getReduceAttrs() const {
      auto &propStorage = this->reduceAttrs;
      return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(propStorage);
    }
    void setReduceAttrs(const ::mlir::ArrayAttr &propValue) {
      this->reduceAttrs = propValue;
    }
    using unorderedTy = ::mlir::UnitAttr;
    unorderedTy unordered;

    auto getUnordered() const {
      auto &propStorage = this->unordered;
      return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(propStorage);
    }
    void setUnordered(const ::mlir::UnitAttr &propValue) {
      this->unordered = propValue;
    }
    using operandSegmentSizesTy = std::array<int32_t, 5>;
    operandSegmentSizesTy operandSegmentSizes;
    ::llvm::ArrayRef<int32_t> getOperandSegmentSizes() const {
      auto &propStorage = this->operandSegmentSizes;
      return propStorage;
    }
    void setOperandSegmentSizes(::llvm::ArrayRef<int32_t> propValue) {
      auto &propStorage = this->operandSegmentSizes;
      ::llvm::copy(propValue, propStorage.begin());
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.finalValue == this->finalValue &&
        rhs.loopAnnotation == this->loopAnnotation &&
        rhs.reduceAttrs == this->reduceAttrs &&
        rhs.unordered == this->unordered &&
        rhs.operandSegmentSizes == this->operandSegmentSizes &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  DoLoopOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("fir.do_loop", odsAttrs.getContext());
  }

  DoLoopOpGenericAdaptorBase(DoLoopOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize);
  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::UnitAttr getUnorderedAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(getProperties().unordered);
    return attr;
  }

  ::std::optional<bool> getUnordered();
  ::mlir::UnitAttr getFinalValueAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(getProperties().finalValue);
    return attr;
  }

  ::std::optional<bool> getFinalValue();
  ::mlir::ArrayAttr getReduceAttrsAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().reduceAttrs);
    return attr;
  }

  ::std::optional< ::mlir::ArrayAttr > getReduceAttrs();
  ::mlir::LLVM::LoopAnnotationAttr getLoopAnnotationAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::LLVM::LoopAnnotationAttr>(getProperties().loopAnnotation);
    return attr;
  }

  ::std::optional<::mlir::LLVM::LoopAnnotationAttr> getLoopAnnotation();
  ::mlir::Region &getRegion() {
    return *odsRegions[0];
  }

  ::mlir::RegionRange getRegions() {
    return odsRegions;
  }

};

} // namespace detail
template <typename RangeT>
class DoLoopOpGenericAdaptor : public detail::DoLoopOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::DoLoopOpGenericAdaptorBase;
  static constexpr int odsIndex_lowerBound = 0;
  static constexpr int odsIndex_upperBound = 1;
  static constexpr int odsIndex_step = 2;
  static constexpr int odsIndex_reduceOperands = 3;
  static constexpr int odsIndex_initArgs = 4;
public:
  DoLoopOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  DoLoopOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : DoLoopOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  DoLoopOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs) : DoLoopOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  DoLoopOpGenericAdaptor(RangeT values, const DoLoopOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = DoLoopOp, typename = std::enable_if_t<std::is_same_v<LateInst, DoLoopOp>>>
  DoLoopOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getLowerBound() {
    return (*getODSOperands(0).begin());
  }

  ValueT getUpperBound() {
    return (*getODSOperands(1).begin());
  }

  ValueT getStep() {
    return (*getODSOperands(2).begin());
  }

  RangeT getReduceOperands() {
    return getODSOperands(3);
  }

  RangeT getInitArgs() {
    return getODSOperands(4);
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class DoLoopOpAdaptor : public DoLoopOpGenericAdaptor<::mlir::ValueRange> {
public:
  using DoLoopOpGenericAdaptor::DoLoopOpGenericAdaptor;
  DoLoopOpAdaptor(DoLoopOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class DoLoopOp : public ::mlir::Op<DoLoopOp, ::mlir::OpTrait::OneRegion, ::mlir::OpTrait::VariadicResults, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::AtLeastNOperands<3>::Impl, ::mlir::OpTrait::AttrSizedOperandSegments, ::mlir::OpTrait::SingleBlock, ::mlir::OpTrait::SingleBlockImplicitTerminator<ResultOp>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::LoopLikeOpInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::RecursivelySpeculatableImplTrait, ::mlir::OpTrait::HasRecursiveMemoryEffects> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = DoLoopOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = DoLoopOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_lowerBound = 0;
  static constexpr int odsIndex_upperBound = 1;
  static constexpr int odsIndex_step = 2;
  static constexpr int odsIndex_reduceOperands = 3;
  static constexpr int odsIndex_initArgs = 4;
  using Properties = FoldAdaptor::Properties;
  using ::mlir::LoopLikeOpInterface::Trait<DoLoopOp>::isDefinedOutsideOfLoop;
  using ::mlir::LoopLikeOpInterface::Trait<DoLoopOp>::moveOutOfLoop;
  using ::mlir::LoopLikeOpInterface::Trait<DoLoopOp>::promoteIfSingleIteration;
  using ::mlir::LoopLikeOpInterface::Trait<DoLoopOp>::getLoopInductionVars;
  using ::mlir::LoopLikeOpInterface::Trait<DoLoopOp>::getLoopLowerBounds;
  using ::mlir::LoopLikeOpInterface::Trait<DoLoopOp>::getLoopSteps;
  using ::mlir::LoopLikeOpInterface::Trait<DoLoopOp>::getLoopUpperBounds;
  using ::mlir::LoopLikeOpInterface::Trait<DoLoopOp>::getInitsMutable;
  using ::mlir::LoopLikeOpInterface::Trait<DoLoopOp>::getRegionIterArgs;
  using ::mlir::LoopLikeOpInterface::Trait<DoLoopOp>::getLoopResults;
  using ::mlir::LoopLikeOpInterface::Trait<DoLoopOp>::replaceWithAdditionalYields;
  using ::mlir::LoopLikeOpInterface::Trait<DoLoopOp>::getStaticTripCount;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("finalValue"), ::llvm::StringRef("loopAnnotation"), ::llvm::StringRef("reduceAttrs"), ::llvm::StringRef("unordered"), ::llvm::StringRef("operandSegmentSizes")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getFinalValueAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getFinalValueAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getLoopAnnotationAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getLoopAnnotationAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  ::mlir::StringAttr getReduceAttrsAttrName() {
    return getAttributeNameForIndex(2);
  }

  static ::mlir::StringAttr getReduceAttrsAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 2);
  }

  ::mlir::StringAttr getUnorderedAttrName() {
    return getAttributeNameForIndex(3);
  }

  static ::mlir::StringAttr getUnorderedAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 3);
  }

  ::mlir::StringAttr getOperandSegmentSizesAttrName() {
   return (*this)->getName().getAttributeNames().back();
  }

  static ::mlir::StringAttr getOperandSegmentSizesAttrName(::mlir::OperationName name) {
   return name.getAttributeNames().back();
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("fir.do_loop");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index);
  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::IndexType> getLowerBound() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::IndexType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::IndexType> getUpperBound() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::IndexType>>(*getODSOperands(1).begin());
  }

  ::mlir::TypedValue<::mlir::IndexType> getStep() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::IndexType>>(*getODSOperands(2).begin());
  }

  ::mlir::Operation::operand_range getReduceOperands() {
    return getODSOperands(3);
  }

  ::mlir::Operation::operand_range getInitArgs() {
    return getODSOperands(4);
  }

  ::mlir::OpOperand &getLowerBoundMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getUpperBoundMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getStepMutable() {
    auto range = getODSOperandIndexAndLength(2);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::MutableOperandRange getReduceOperandsMutable();
  ::mlir::MutableOperandRange getInitArgsMutable();
  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index);
  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::Operation::result_range getResults() {
    return getODSResults(0);
  }

  ::mlir::Region &getRegion() {
    return (*this)->getRegion(0);
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::UnitAttr getUnorderedAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(getProperties().unordered);
  }

  ::std::optional<bool> getUnordered();
  ::mlir::UnitAttr getFinalValueAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(getProperties().finalValue);
  }

  ::std::optional<bool> getFinalValue();
  ::mlir::ArrayAttr getReduceAttrsAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().reduceAttrs);
  }

  ::std::optional< ::mlir::ArrayAttr > getReduceAttrs();
  ::mlir::LLVM::LoopAnnotationAttr getLoopAnnotationAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::LLVM::LoopAnnotationAttr>(getProperties().loopAnnotation);
  }

  ::std::optional<::mlir::LLVM::LoopAnnotationAttr> getLoopAnnotation();
  void setUnorderedAttr(::mlir::UnitAttr attr) {
    getProperties().unordered = attr;
  }

  void setUnordered(bool attrValue);
  void setFinalValueAttr(::mlir::UnitAttr attr) {
    getProperties().finalValue = attr;
  }

  void setFinalValue(bool attrValue);
  void setReduceAttrsAttr(::mlir::ArrayAttr attr) {
    getProperties().reduceAttrs = attr;
  }

  void setLoopAnnotationAttr(::mlir::LLVM::LoopAnnotationAttr attr) {
    getProperties().loopAnnotation = attr;
  }

  ::mlir::Attribute removeUnorderedAttr() {
      auto attr = getProperties().unordered;
      getProperties().unordered = {};
      return attr;
  }

  ::mlir::Attribute removeFinalValueAttr() {
      auto attr = getProperties().finalValue;
      getProperties().finalValue = {};
      return attr;
  }

  ::mlir::Attribute removeReduceAttrsAttr() {
      auto attr = getProperties().reduceAttrs;
      getProperties().reduceAttrs = {};
      return attr;
  }

  ::mlir::Attribute removeLoopAnnotationAttr() {
      auto attr = getProperties().loopAnnotation;
      getProperties().loopAnnotation = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, mlir::Value lowerBound, mlir::Value upperBound, mlir::Value step, bool unordered = false, bool finalCountValue = false, mlir::ValueRange iterArgs = {}, mlir::ValueRange reduceOperands = {}, llvm::ArrayRef<mlir::Attribute> reduceAttrs = {}, llvm::ArrayRef<mlir::NamedAttribute> attributes = {});
  static DoLoopOp create(::mlir::OpBuilder &builder, ::mlir::Location location, mlir::Value lowerBound, mlir::Value upperBound, mlir::Value step, bool unordered = false, bool finalCountValue = false, mlir::ValueRange iterArgs = {}, mlir::ValueRange reduceOperands = {}, llvm::ArrayRef<mlir::Attribute> reduceAttrs = {}, llvm::ArrayRef<mlir::NamedAttribute> attributes = {});
  static DoLoopOp create(::mlir::ImplicitLocOpBuilder &builder, mlir::Value lowerBound, mlir::Value upperBound, mlir::Value step, bool unordered = false, bool finalCountValue = false, mlir::ValueRange iterArgs = {}, mlir::ValueRange reduceOperands = {}, llvm::ArrayRef<mlir::Attribute> reduceAttrs = {}, llvm::ArrayRef<mlir::NamedAttribute> attributes = {});
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &p);
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  ::llvm::SmallVector<::mlir::Region *> getLoopRegions();
  ::std::optional<::llvm::MutableArrayRef<::mlir::OpOperand>> getYieldedValuesMutable();
  static ::llvm::LogicalResult setPropertiesFromParsedAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 4 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
  mlir::Value getInductionVar() { return getBody()->getArgument(0); }
  mlir::OpBuilder getBodyBuilder() {
    return mlir::OpBuilder(getBody(), std::prev(getBody()->end()));
  }
  mlir::Block::BlockArgListType getRegionIterArgs() {
    return getBody()->getArguments().drop_front();
  }
  mlir::Operation::operand_range getIterOperands() {
    return getOperands()
        .drop_front(getNumControlOperands() + getNumReduceOperands());
  }
  llvm::MutableArrayRef<mlir::OpOperand> getInitsMutable() {
    return getOperation()->getOpOperands()
        .drop_front(getNumControlOperands() + getNumReduceOperands());
  }

  void setLowerBound(mlir::Value bound) { (*this)->setOperand(0, bound); }
  void setUpperBound(mlir::Value bound) { (*this)->setOperand(1, bound); }
  void setStep(mlir::Value step) { (*this)->setOperand(2, step); }

  /// Number of region arguments for loop-carried values
  unsigned getNumRegionIterArgs() {
    return getBody()->getNumArguments() - 1;
  }
  /// Number of operands controlling the loop: lb, ub, step
  unsigned getNumControlOperands() { return 3; }
  /// Does the operation hold operands for loop-carried values
  bool hasIterOperands() {
    return getNumIterOperands() > 0;
  }
  /// Does the operation hold operands for reduction variables
  bool hasReduceOperands() {
    return getNumReduceOperands() > 0;
  }
  /// Get Number of variadic operands
  unsigned getNumOperands(unsigned idx) {
    auto segments = (*this)->getAttrOfType<mlir::DenseI32ArrayAttr>(
      getOperandSegmentSizeAttr());
    return static_cast<unsigned>(segments[idx]);
  }
  // Get Number of reduction operands
  unsigned getNumReduceOperands() {
    return getNumOperands(3);
  }
  /// Get Number of loop-carried values
  unsigned getNumIterOperands() {
    return getNumOperands(4);
  }

  /// Get the body of the loop
  mlir::Block *getBody() { return &getRegion().front(); }

  void setUnordered() {
    setUnorderedAttr(mlir::UnitAttr::get(getContext()));
  }

  mlir::BlockArgument iterArgToBlockArg(mlir::Value iterArg);
  void resultToSourceOps(llvm::SmallVectorImpl<mlir::Value> &results,
                         unsigned resultNum);
  mlir::Value blockArgToSourceOp(unsigned blockArgNum);
};

} // namespace fir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::fir::DoLoopOp)

namespace fir {


//===----------------------------------------------------------------------===//
// ::fir::DummyScopeOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class DummyScopeOpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  DummyScopeOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("fir.dummy_scope", odsAttrs.getContext());
  }

  DummyScopeOpGenericAdaptorBase(DummyScopeOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};

} // namespace detail
template <typename RangeT>
class DummyScopeOpGenericAdaptor : public detail::DummyScopeOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::DummyScopeOpGenericAdaptorBase;
public:
  DummyScopeOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  DummyScopeOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : DummyScopeOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  DummyScopeOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : DummyScopeOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  DummyScopeOpGenericAdaptor(RangeT values, const DummyScopeOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = DummyScopeOp, typename = std::enable_if_t<std::is_same_v<LateInst, DummyScopeOp>>>
  DummyScopeOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class DummyScopeOpAdaptor : public DummyScopeOpGenericAdaptor<::mlir::ValueRange> {
public:
  using DummyScopeOpGenericAdaptor::DummyScopeOpGenericAdaptor;
  DummyScopeOpAdaptor(DummyScopeOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class DummyScopeOp : public ::mlir::Op<DummyScopeOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::fir::DummyScopeType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::ZeroOperands, ::mlir::OpTrait::OpInvariants, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::InferTypeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = DummyScopeOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = DummyScopeOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    return {};
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("fir.dummy_scope");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type resultType0);
  static DummyScopeOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type resultType0);
  static DummyScopeOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type resultType0);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState);
  static DummyScopeOp create(::mlir::OpBuilder &builder, ::mlir::Location location);
  static DummyScopeOp create(::mlir::ImplicitLocOpBuilder &builder);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes);
  static DummyScopeOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes);
  static DummyScopeOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static DummyScopeOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static DummyScopeOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static DummyScopeOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static DummyScopeOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static DummyScopeOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static DummyScopeOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static DummyScopeOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static DummyScopeOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::llvm::LogicalResult inferReturnTypes(::mlir::MLIRContext *context, ::std::optional<::mlir::Location> location, ::mlir::ValueRange operands, ::mlir::DictionaryAttr attributes, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions, ::llvm::SmallVectorImpl<::mlir::Type>&inferredReturnTypes);
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
public:
};

} // namespace fir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::fir::DummyScopeOp)

namespace fir {


//===----------------------------------------------------------------------===//
// ::fir::EmboxCharOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class EmboxCharOpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  EmboxCharOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("fir.emboxchar", odsAttrs.getContext());
  }

  EmboxCharOpGenericAdaptorBase(EmboxCharOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};

} // namespace detail
template <typename RangeT>
class EmboxCharOpGenericAdaptor : public detail::EmboxCharOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::EmboxCharOpGenericAdaptorBase;
  static constexpr int odsIndex_memref = 0;
  static constexpr int odsIndex_len = 1;
public:
  EmboxCharOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  EmboxCharOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : EmboxCharOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  EmboxCharOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : EmboxCharOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  EmboxCharOpGenericAdaptor(RangeT values, const EmboxCharOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = EmboxCharOp, typename = std::enable_if_t<std::is_same_v<LateInst, EmboxCharOp>>>
  EmboxCharOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getMemref() {
    return (*getODSOperands(0).begin());
  }

  ValueT getLen() {
    return (*getODSOperands(1).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class EmboxCharOpAdaptor : public EmboxCharOpGenericAdaptor<::mlir::ValueRange> {
public:
  using EmboxCharOpGenericAdaptor::EmboxCharOpGenericAdaptor;
  EmboxCharOpAdaptor(EmboxCharOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class EmboxCharOp : public ::mlir::Op<EmboxCharOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::fir::BoxCharType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<2>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = EmboxCharOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = EmboxCharOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_memref = 0;
  static constexpr int odsIndex_len = 1;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    return {};
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("fir.emboxchar");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getMemref() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::Type> getLen() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(1).begin());
  }

  ::mlir::OpOperand &getMemrefMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getLenMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type resultType0, ::mlir::Value memref, ::mlir::Value len);
  static EmboxCharOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type resultType0, ::mlir::Value memref, ::mlir::Value len);
  static EmboxCharOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type resultType0, ::mlir::Value memref, ::mlir::Value len);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value memref, ::mlir::Value len);
  static EmboxCharOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value memref, ::mlir::Value len);
  static EmboxCharOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value memref, ::mlir::Value len);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static EmboxCharOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static EmboxCharOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static EmboxCharOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static EmboxCharOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
public:
};

} // namespace fir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::fir::EmboxCharOp)

namespace fir {


//===----------------------------------------------------------------------===//
// ::fir::EmboxOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class EmboxOpGenericAdaptorBase {
public:
  struct Properties {
    using accessMapTy = ::mlir::AffineMapAttr;
    accessMapTy accessMap;

    auto getAccessMap() const {
      auto &propStorage = this->accessMap;
      return ::llvm::dyn_cast_or_null<::mlir::AffineMapAttr>(propStorage);
    }
    void setAccessMap(const ::mlir::AffineMapAttr &propValue) {
      this->accessMap = propValue;
    }
    using allocator_idxTy = ::mlir::IntegerAttr;
    allocator_idxTy allocator_idx;

    auto getAllocatorIdx() const {
      auto &propStorage = this->allocator_idx;
      return ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(propStorage);
    }
    void setAllocatorIdx(const ::mlir::IntegerAttr &propValue) {
      this->allocator_idx = propValue;
    }
    using operandSegmentSizesTy = std::array<int32_t, 5>;
    operandSegmentSizesTy operandSegmentSizes;
    ::llvm::ArrayRef<int32_t> getOperandSegmentSizes() const {
      auto &propStorage = this->operandSegmentSizes;
      return propStorage;
    }
    void setOperandSegmentSizes(::llvm::ArrayRef<int32_t> propValue) {
      auto &propStorage = this->operandSegmentSizes;
      ::llvm::copy(propValue, propStorage.begin());
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.accessMap == this->accessMap &&
        rhs.allocator_idx == this->allocator_idx &&
        rhs.operandSegmentSizes == this->operandSegmentSizes &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  EmboxOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("fir.embox", odsAttrs.getContext());
  }

  EmboxOpGenericAdaptorBase(EmboxOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize);
  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::AffineMapAttr getAccessMapAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::AffineMapAttr>(getProperties().accessMap);
    return attr;
  }

  ::std::optional< ::mlir::AffineMap > getAccessMap();
  ::mlir::IntegerAttr getAllocatorIdxAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(getProperties().allocator_idx);
    return attr;
  }

  ::std::optional<uint32_t> getAllocatorIdx();
};

} // namespace detail
template <typename RangeT>
class EmboxOpGenericAdaptor : public detail::EmboxOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::EmboxOpGenericAdaptorBase;
  static constexpr int odsIndex_memref = 0;
  static constexpr int odsIndex_shape = 1;
  static constexpr int odsIndex_slice = 2;
  static constexpr int odsIndex_typeparams = 3;
  static constexpr int odsIndex_sourceBox = 4;
public:
  EmboxOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  EmboxOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : EmboxOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  EmboxOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs) : EmboxOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  EmboxOpGenericAdaptor(RangeT values, const EmboxOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = EmboxOp, typename = std::enable_if_t<std::is_same_v<LateInst, EmboxOp>>>
  EmboxOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getMemref() {
    return (*getODSOperands(0).begin());
  }

  ValueT getShape() {
    auto operands = getODSOperands(1);
    return operands.empty() ? ValueT{} : (*operands.begin());
  }

  ValueT getSlice() {
    auto operands = getODSOperands(2);
    return operands.empty() ? ValueT{} : (*operands.begin());
  }

  RangeT getTypeparams() {
    return getODSOperands(3);
  }

  ValueT getSourceBox() {
    auto operands = getODSOperands(4);
    return operands.empty() ? ValueT{} : (*operands.begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class EmboxOpAdaptor : public EmboxOpGenericAdaptor<::mlir::ValueRange> {
public:
  using EmboxOpGenericAdaptor::EmboxOpGenericAdaptor;
  EmboxOpAdaptor(EmboxOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class EmboxOp : public ::mlir::Op<EmboxOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::Type>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::AtLeastNOperands<1>::Impl, ::mlir::OpTrait::AttrSizedOperandSegments, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::MemoryEffectOpInterface::Trait, ::fir::FortranObjectViewOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = EmboxOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = EmboxOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_memref = 0;
  static constexpr int odsIndex_shape = 1;
  static constexpr int odsIndex_slice = 2;
  static constexpr int odsIndex_typeparams = 3;
  static constexpr int odsIndex_sourceBox = 4;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("accessMap"), ::llvm::StringRef("allocator_idx"), ::llvm::StringRef("operandSegmentSizes")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getAccessMapAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getAccessMapAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getAllocatorIdxAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getAllocatorIdxAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  ::mlir::StringAttr getOperandSegmentSizesAttrName() {
   return (*this)->getName().getAttributeNames().back();
  }

  static ::mlir::StringAttr getOperandSegmentSizesAttrName(::mlir::OperationName name) {
   return name.getAttributeNames().back();
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("fir.embox");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index);
  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getMemref() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::Type> getShape() {
    auto operands = getODSOperands(1);
    return operands.empty() ? ::mlir::TypedValue<::mlir::Type>{} : ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*operands.begin());
  }

  ::mlir::TypedValue<::fir::SliceType> getSlice() {
    auto operands = getODSOperands(2);
    return operands.empty() ? ::mlir::TypedValue<::fir::SliceType>{} : ::llvm::cast<::mlir::TypedValue<::fir::SliceType>>(*operands.begin());
  }

  ::mlir::Operation::operand_range getTypeparams() {
    return getODSOperands(3);
  }

  ::mlir::TypedValue<::mlir::Type> getSourceBox() {
    auto operands = getODSOperands(4);
    return operands.empty() ? ::mlir::TypedValue<::mlir::Type>{} : ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*operands.begin());
  }

  ::mlir::OpOperand &getMemrefMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::MutableOperandRange getShapeMutable();
  ::mlir::MutableOperandRange getSliceMutable();
  ::mlir::MutableOperandRange getTypeparamsMutable();
  ::mlir::MutableOperandRange getSourceBoxMutable();
  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::AffineMapAttr getAccessMapAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::AffineMapAttr>(getProperties().accessMap);
  }

  ::std::optional< ::mlir::AffineMap > getAccessMap();
  ::mlir::IntegerAttr getAllocatorIdxAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(getProperties().allocator_idx);
  }

  ::std::optional<uint32_t> getAllocatorIdx();
  void setAccessMapAttr(::mlir::AffineMapAttr attr) {
    getProperties().accessMap = attr;
  }

  void setAccessMap(::std::optional<::mlir::AffineMap> attrValue);
  void setAllocatorIdxAttr(::mlir::IntegerAttr attr) {
    getProperties().allocator_idx = attr;
  }

  void setAllocatorIdx(::std::optional<uint32_t> attrValue);
  ::mlir::Attribute removeAccessMapAttr() {
      auto attr = getProperties().accessMap;
      getProperties().accessMap = {};
      return attr;
  }

  ::mlir::Attribute removeAllocatorIdxAttr() {
      auto attr = getProperties().allocator_idx;
      getProperties().allocator_idx = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, llvm::ArrayRef<mlir::Type> resultTypes, mlir::Value memref, mlir::Value shape = {}, mlir::Value slice = {}, mlir::ValueRange typeparams = {}, mlir::Value sourceBox = {}, mlir::IntegerAttr allocator_idx = {});
  static EmboxOp create(::mlir::OpBuilder &builder, ::mlir::Location location, llvm::ArrayRef<mlir::Type> resultTypes, mlir::Value memref, mlir::Value shape = {}, mlir::Value slice = {}, mlir::ValueRange typeparams = {}, mlir::Value sourceBox = {}, mlir::IntegerAttr allocator_idx = {});
  static EmboxOp create(::mlir::ImplicitLocOpBuilder &builder, llvm::ArrayRef<mlir::Type> resultTypes, mlir::Value memref, mlir::Value shape = {}, mlir::Value slice = {}, mlir::ValueRange typeparams = {}, mlir::Value sourceBox = {}, mlir::IntegerAttr allocator_idx = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type resultType0, ::mlir::Value memref, /*optional*/::mlir::Value shape, /*optional*/::mlir::Value slice, ::mlir::ValueRange typeparams, /*optional*/::mlir::Value sourceBox, /*optional*/::mlir::AffineMapAttr accessMap, /*optional*/::mlir::IntegerAttr allocator_idx);
  static EmboxOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type resultType0, ::mlir::Value memref, /*optional*/::mlir::Value shape, /*optional*/::mlir::Value slice, ::mlir::ValueRange typeparams, /*optional*/::mlir::Value sourceBox, /*optional*/::mlir::AffineMapAttr accessMap, /*optional*/::mlir::IntegerAttr allocator_idx);
  static EmboxOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type resultType0, ::mlir::Value memref, /*optional*/::mlir::Value shape, /*optional*/::mlir::Value slice, ::mlir::ValueRange typeparams, /*optional*/::mlir::Value sourceBox, /*optional*/::mlir::AffineMapAttr accessMap, /*optional*/::mlir::IntegerAttr allocator_idx);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value memref, /*optional*/::mlir::Value shape, /*optional*/::mlir::Value slice, ::mlir::ValueRange typeparams, /*optional*/::mlir::Value sourceBox, /*optional*/::mlir::AffineMapAttr accessMap, /*optional*/::mlir::IntegerAttr allocator_idx);
  static EmboxOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value memref, /*optional*/::mlir::Value shape, /*optional*/::mlir::Value slice, ::mlir::ValueRange typeparams, /*optional*/::mlir::Value sourceBox, /*optional*/::mlir::AffineMapAttr accessMap, /*optional*/::mlir::IntegerAttr allocator_idx);
  static EmboxOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value memref, /*optional*/::mlir::Value shape, /*optional*/::mlir::Value slice, ::mlir::ValueRange typeparams, /*optional*/::mlir::Value sourceBox, /*optional*/::mlir::AffineMapAttr accessMap, /*optional*/::mlir::IntegerAttr allocator_idx);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static EmboxOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static EmboxOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static EmboxOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static EmboxOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 2 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
  bool hasLenParams() { return !getTypeparams().empty(); }
  unsigned numLenParams() { return getTypeparams().size(); }
  unsigned getSourceBoxOperandIndex() {
    return 1 + (getShape() ? 1 : 0) + (getSlice() ? 1 : 0)
        + numLenParams();
  }
  // FortranObjectViewOpInterface methods:
  mlir::Value getViewSource(mlir::OpResult) { return getMemref(); }
  std::optional<std::int64_t> getViewOffset(mlir::OpResult);
};

} // namespace fir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::fir::EmboxOp)

namespace fir {


//===----------------------------------------------------------------------===//
// ::fir::EmboxProcOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class EmboxProcOpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  EmboxProcOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("fir.emboxproc", odsAttrs.getContext());
  }

  EmboxProcOpGenericAdaptorBase(EmboxProcOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize);
  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};

} // namespace detail
template <typename RangeT>
class EmboxProcOpGenericAdaptor : public detail::EmboxProcOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::EmboxProcOpGenericAdaptorBase;
  static constexpr int odsIndex_func = 0;
  static constexpr int odsIndex_host = 1;
public:
  EmboxProcOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  EmboxProcOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : EmboxProcOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  EmboxProcOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : EmboxProcOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  EmboxProcOpGenericAdaptor(RangeT values, const EmboxProcOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = EmboxProcOp, typename = std::enable_if_t<std::is_same_v<LateInst, EmboxProcOp>>>
  EmboxProcOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getFunc() {
    return (*getODSOperands(0).begin());
  }

  ValueT getHost() {
    auto operands = getODSOperands(1);
    return operands.empty() ? ValueT{} : (*operands.begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class EmboxProcOpAdaptor : public EmboxProcOpGenericAdaptor<::mlir::ValueRange> {
public:
  using EmboxProcOpGenericAdaptor::EmboxProcOpGenericAdaptor;
  EmboxProcOpAdaptor(EmboxProcOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class EmboxProcOp : public ::mlir::Op<EmboxProcOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::fir::BoxProcType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::AtLeastNOperands<1>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = EmboxProcOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = EmboxProcOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_func = 0;
  static constexpr int odsIndex_host = 1;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    return {};
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("fir.emboxproc");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index);
  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getFunc() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::fir::ReferenceType> getHost() {
    auto operands = getODSOperands(1);
    return operands.empty() ? ::mlir::TypedValue<::fir::ReferenceType>{} : ::llvm::cast<::mlir::TypedValue<::fir::ReferenceType>>(*operands.begin());
  }

  ::mlir::OpOperand &getFuncMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::MutableOperandRange getHostMutable();
  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type resultType0, ::mlir::Value func, /*optional*/::mlir::Value host);
  static EmboxProcOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type resultType0, ::mlir::Value func, /*optional*/::mlir::Value host);
  static EmboxProcOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type resultType0, ::mlir::Value func, /*optional*/::mlir::Value host);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value func, /*optional*/::mlir::Value host);
  static EmboxProcOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value func, /*optional*/::mlir::Value host);
  static EmboxProcOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value func, /*optional*/::mlir::Value host);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static EmboxProcOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static EmboxProcOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static EmboxProcOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static EmboxProcOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
public:
};

} // namespace fir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::fir::EmboxProcOp)

namespace fir {


//===----------------------------------------------------------------------===//
// ::fir::ExtractValueOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class ExtractValueOpGenericAdaptorBase {
public:
  struct Properties {
    using coorTy = ::mlir::ArrayAttr;
    coorTy coor;

    auto getCoor() const {
      auto &propStorage = this->coor;
      return ::llvm::cast<::mlir::ArrayAttr>(propStorage);
    }
    void setCoor(const ::mlir::ArrayAttr &propValue) {
      this->coor = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.coor == this->coor &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  ExtractValueOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("fir.extract_value", odsAttrs.getContext());
  }

  ExtractValueOpGenericAdaptorBase(ExtractValueOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::ArrayAttr getCoorAttr() {
    auto attr = ::llvm::cast<::mlir::ArrayAttr>(getProperties().coor);
    return attr;
  }

  ::mlir::ArrayAttr getCoor();
};

} // namespace detail
template <typename RangeT>
class ExtractValueOpGenericAdaptor : public detail::ExtractValueOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::ExtractValueOpGenericAdaptorBase;
  static constexpr int odsIndex_adt = 0;
public:
  ExtractValueOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  ExtractValueOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : ExtractValueOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  ExtractValueOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : ExtractValueOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  ExtractValueOpGenericAdaptor(RangeT values, const ExtractValueOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = ExtractValueOp, typename = std::enable_if_t<std::is_same_v<LateInst, ExtractValueOp>>>
  ExtractValueOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getAdt() {
    return (*getODSOperands(0).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class ExtractValueOpAdaptor : public ExtractValueOpGenericAdaptor<::mlir::ValueRange> {
public:
  using ExtractValueOpGenericAdaptor::ExtractValueOpGenericAdaptor;
  ExtractValueOpAdaptor(ExtractValueOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class ExtractValueOp : public ::mlir::Op<ExtractValueOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::Type>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::OneOperand, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = ExtractValueOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = ExtractValueOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_adt = 0;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("coor")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getCoorAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getCoorAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("fir.extract_value");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getAdt() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(0).begin());
  }

  ::mlir::OpOperand &getAdtMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::ArrayAttr getCoorAttr() {
    return ::llvm::cast<::mlir::ArrayAttr>(getProperties().coor);
  }

  ::mlir::ArrayAttr getCoor();
  void setCoorAttr(::mlir::ArrayAttr attr) {
    getProperties().coor = attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, mlir::Type resultType, mlir::ValueRange operands, llvm::ArrayRef<mlir::NamedAttribute> attributes = {});
  static ExtractValueOp create(::mlir::OpBuilder &builder, ::mlir::Location location, mlir::Type resultType, mlir::ValueRange operands, llvm::ArrayRef<mlir::NamedAttribute> attributes = {});
  static ExtractValueOp create(::mlir::ImplicitLocOpBuilder &builder, mlir::Type resultType, mlir::ValueRange operands, llvm::ArrayRef<mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value adt, ::mlir::ArrayAttr coor);
  static ExtractValueOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value adt, ::mlir::ArrayAttr coor);
  static ExtractValueOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value adt, ::mlir::ArrayAttr coor);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value adt, ::mlir::ArrayAttr coor);
  static ExtractValueOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value adt, ::mlir::ArrayAttr coor);
  static ExtractValueOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value adt, ::mlir::ArrayAttr coor);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static ExtractValueOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static ExtractValueOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ExtractValueOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ExtractValueOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};

} // namespace fir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::fir::ExtractValueOp)

namespace fir {


//===----------------------------------------------------------------------===//
// ::fir::FieldIndexOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class FieldIndexOpGenericAdaptorBase {
public:
  struct Properties {
    using field_idTy = ::mlir::StringAttr;
    field_idTy field_id;

    auto getFieldId() const {
      auto &propStorage = this->field_id;
      return ::llvm::cast<::mlir::StringAttr>(propStorage);
    }
    void setFieldId(const ::mlir::StringAttr &propValue) {
      this->field_id = propValue;
    }
    using on_typeTy = ::mlir::TypeAttr;
    on_typeTy on_type;

    auto getOnType() const {
      auto &propStorage = this->on_type;
      return ::llvm::cast<::mlir::TypeAttr>(propStorage);
    }
    void setOnType(const ::mlir::TypeAttr &propValue) {
      this->on_type = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.field_id == this->field_id &&
        rhs.on_type == this->on_type &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  FieldIndexOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("fir.field_index", odsAttrs.getContext());
  }

  FieldIndexOpGenericAdaptorBase(FieldIndexOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize);
  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::StringAttr getFieldIdAttr() {
    auto attr = ::llvm::cast<::mlir::StringAttr>(getProperties().field_id);
    return attr;
  }

  ::llvm::StringRef getFieldId();
  ::mlir::TypeAttr getOnTypeAttr() {
    auto attr = ::llvm::cast<::mlir::TypeAttr>(getProperties().on_type);
    return attr;
  }

  ::mlir::Type getOnType();
};

} // namespace detail
template <typename RangeT>
class FieldIndexOpGenericAdaptor : public detail::FieldIndexOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::FieldIndexOpGenericAdaptorBase;
  static constexpr int odsIndex_typeparams = 0;
public:
  FieldIndexOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  FieldIndexOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : FieldIndexOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  FieldIndexOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : FieldIndexOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  FieldIndexOpGenericAdaptor(RangeT values, const FieldIndexOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = FieldIndexOp, typename = std::enable_if_t<std::is_same_v<LateInst, FieldIndexOp>>>
  FieldIndexOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  RangeT getTypeparams() {
    return getODSOperands(0);
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class FieldIndexOpAdaptor : public FieldIndexOpGenericAdaptor<::mlir::ValueRange> {
public:
  using FieldIndexOpGenericAdaptor::FieldIndexOpGenericAdaptor;
  FieldIndexOpAdaptor(FieldIndexOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class FieldIndexOp : public ::mlir::Op<FieldIndexOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::Type>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::VariadicOperands, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = FieldIndexOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = FieldIndexOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_typeparams = 0;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("field_id"), ::llvm::StringRef("on_type")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getFieldIdAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getFieldIdAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getOnTypeAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getOnTypeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("fir.field_index");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index);
  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::Operation::operand_range getTypeparams() {
    return getODSOperands(0);
  }

  ::mlir::MutableOperandRange getTypeparamsMutable();
  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::StringAttr getFieldIdAttr() {
    return ::llvm::cast<::mlir::StringAttr>(getProperties().field_id);
  }

  ::llvm::StringRef getFieldId();
  ::mlir::TypeAttr getOnTypeAttr() {
    return ::llvm::cast<::mlir::TypeAttr>(getProperties().on_type);
  }

  ::mlir::Type getOnType();
  void setFieldIdAttr(::mlir::StringAttr attr) {
    getProperties().field_id = attr;
  }

  void setFieldId(::llvm::StringRef attrValue);
  void setOnTypeAttr(::mlir::TypeAttr attr) {
    getProperties().on_type = attr;
  }

  void setOnType(::mlir::Type attrValue);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, llvm::StringRef fieldName, mlir::Type recTy, mlir::ValueRange operands = {});
  static FieldIndexOp create(::mlir::OpBuilder &builder, ::mlir::Location location, llvm::StringRef fieldName, mlir::Type recTy, mlir::ValueRange operands = {});
  static FieldIndexOp create(::mlir::ImplicitLocOpBuilder &builder, llvm::StringRef fieldName, mlir::Type recTy, mlir::ValueRange operands = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::StringAttr field_id, ::mlir::TypeAttr on_type, ::mlir::ValueRange typeparams);
  static FieldIndexOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::StringAttr field_id, ::mlir::TypeAttr on_type, ::mlir::ValueRange typeparams);
  static FieldIndexOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::StringAttr field_id, ::mlir::TypeAttr on_type, ::mlir::ValueRange typeparams);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::StringAttr field_id, ::mlir::TypeAttr on_type, ::mlir::ValueRange typeparams);
  static FieldIndexOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::StringAttr field_id, ::mlir::TypeAttr on_type, ::mlir::ValueRange typeparams);
  static FieldIndexOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::StringAttr field_id, ::mlir::TypeAttr on_type, ::mlir::ValueRange typeparams);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::llvm::StringRef field_id, ::mlir::Type on_type, ::mlir::ValueRange typeparams);
  static FieldIndexOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::llvm::StringRef field_id, ::mlir::Type on_type, ::mlir::ValueRange typeparams);
  static FieldIndexOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::llvm::StringRef field_id, ::mlir::Type on_type, ::mlir::ValueRange typeparams);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::llvm::StringRef field_id, ::mlir::Type on_type, ::mlir::ValueRange typeparams);
  static FieldIndexOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::llvm::StringRef field_id, ::mlir::Type on_type, ::mlir::ValueRange typeparams);
  static FieldIndexOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::llvm::StringRef field_id, ::mlir::Type on_type, ::mlir::ValueRange typeparams);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static FieldIndexOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static FieldIndexOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static FieldIndexOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static FieldIndexOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &p);
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::llvm::LogicalResult setPropertiesFromParsedAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 2 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
  static constexpr llvm::StringRef getFieldAttrName() { return "field_id"; }
  static constexpr llvm::StringRef getTypeAttrName() { return "on_type"; }
  llvm::StringRef getFieldName() { return getFieldId(); }
  llvm::SmallVector<mlir::Attribute> getAttributes();
};

} // namespace fir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::fir::FieldIndexOp)

namespace fir {


//===----------------------------------------------------------------------===//
// ::fir::FirEndOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class FirEndOpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  FirEndOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("fir.end", odsAttrs.getContext());
  }

  FirEndOpGenericAdaptorBase(FirEndOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};

} // namespace detail
template <typename RangeT>
class FirEndOpGenericAdaptor : public detail::FirEndOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::FirEndOpGenericAdaptorBase;
public:
  FirEndOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  FirEndOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : FirEndOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  FirEndOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : FirEndOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  FirEndOpGenericAdaptor(RangeT values, const FirEndOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = FirEndOp, typename = std::enable_if_t<std::is_same_v<LateInst, FirEndOp>>>
  FirEndOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class FirEndOpAdaptor : public FirEndOpGenericAdaptor<::mlir::ValueRange> {
public:
  using FirEndOpGenericAdaptor::FirEndOpGenericAdaptor;
  FirEndOpAdaptor(FirEndOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class FirEndOp : public ::mlir::Op<FirEndOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::ZeroResults, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::ZeroOperands, ::mlir::OpTrait::OpInvariants, ::mlir::OpTrait::IsTerminator, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = FirEndOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = FirEndOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    return {};
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("fir.end");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState);
  static FirEndOp create(::mlir::OpBuilder &builder, ::mlir::Location location);
  static FirEndOp create(::mlir::ImplicitLocOpBuilder &builder);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes);
  static FirEndOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes);
  static FirEndOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static FirEndOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static FirEndOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static FirEndOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static FirEndOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::llvm::LogicalResult setPropertiesFromParsedAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
public:
};

} // namespace fir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::fir::FirEndOp)

namespace fir {


//===----------------------------------------------------------------------===//
// ::fir::FreeMemOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class FreeMemOpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  FreeMemOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("fir.freemem", odsAttrs.getContext());
  }

  FreeMemOpGenericAdaptorBase(FreeMemOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};

} // namespace detail
template <typename RangeT>
class FreeMemOpGenericAdaptor : public detail::FreeMemOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::FreeMemOpGenericAdaptorBase;
  static constexpr int odsIndex_heapref = 0;
public:
  FreeMemOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  FreeMemOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : FreeMemOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  FreeMemOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : FreeMemOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  FreeMemOpGenericAdaptor(RangeT values, const FreeMemOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = FreeMemOp, typename = std::enable_if_t<std::is_same_v<LateInst, FreeMemOp>>>
  FreeMemOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getHeapref() {
    return (*getODSOperands(0).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class FreeMemOpAdaptor : public FreeMemOpGenericAdaptor<::mlir::ValueRange> {
public:
  using FreeMemOpGenericAdaptor::FreeMemOpGenericAdaptor;
  FreeMemOpAdaptor(FreeMemOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class FreeMemOp : public ::mlir::Op<FreeMemOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::ZeroResults, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::OneOperand, ::mlir::OpTrait::OpInvariants, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = FreeMemOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = FreeMemOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_heapref = 0;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    return {};
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("fir.freemem");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::fir::HeapType> getHeapref() {
    return ::llvm::cast<::mlir::TypedValue<::fir::HeapType>>(*getODSOperands(0).begin());
  }

  ::mlir::OpOperand &getHeaprefMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value heapref);
  static FreeMemOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value heapref);
  static FreeMemOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value heapref);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value heapref);
  static FreeMemOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value heapref);
  static FreeMemOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value heapref);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static FreeMemOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static FreeMemOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static FreeMemOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static FreeMemOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
public:
};

} // namespace fir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::fir::FreeMemOp)

namespace fir {


//===----------------------------------------------------------------------===//
// ::fir::GlobalLenOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class GlobalLenOpGenericAdaptorBase {
public:
  struct Properties {
    using intvalTy = ::mlir::IntegerAttr;
    intvalTy intval;

    auto getIntval() const {
      auto &propStorage = this->intval;
      return ::llvm::cast<::mlir::IntegerAttr>(propStorage);
    }
    void setIntval(const ::mlir::IntegerAttr &propValue) {
      this->intval = propValue;
    }
    using lenparamTy = ::mlir::StringAttr;
    lenparamTy lenparam;

    auto getLenparam() const {
      auto &propStorage = this->lenparam;
      return ::llvm::cast<::mlir::StringAttr>(propStorage);
    }
    void setLenparam(const ::mlir::StringAttr &propValue) {
      this->lenparam = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.intval == this->intval &&
        rhs.lenparam == this->lenparam &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  GlobalLenOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("fir.global_len", odsAttrs.getContext());
  }

  GlobalLenOpGenericAdaptorBase(GlobalLenOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::StringAttr getLenparamAttr() {
    auto attr = ::llvm::cast<::mlir::StringAttr>(getProperties().lenparam);
    return attr;
  }

  ::llvm::StringRef getLenparam();
  ::mlir::IntegerAttr getIntvalAttr() {
    auto attr = ::llvm::cast<::mlir::IntegerAttr>(getProperties().intval);
    return attr;
  }

  ::mlir::APInt getIntval();
};

} // namespace detail
template <typename RangeT>
class GlobalLenOpGenericAdaptor : public detail::GlobalLenOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::GlobalLenOpGenericAdaptorBase;
public:
  GlobalLenOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  GlobalLenOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : GlobalLenOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  GlobalLenOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : GlobalLenOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  GlobalLenOpGenericAdaptor(RangeT values, const GlobalLenOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = GlobalLenOp, typename = std::enable_if_t<std::is_same_v<LateInst, GlobalLenOp>>>
  GlobalLenOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class GlobalLenOpAdaptor : public GlobalLenOpGenericAdaptor<::mlir::ValueRange> {
public:
  using GlobalLenOpGenericAdaptor::GlobalLenOpGenericAdaptor;
  GlobalLenOpAdaptor(GlobalLenOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class GlobalLenOp : public ::mlir::Op<GlobalLenOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::ZeroResults, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::ZeroOperands, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = GlobalLenOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = GlobalLenOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("intval"), ::llvm::StringRef("lenparam")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getIntvalAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getIntvalAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getLenparamAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getLenparamAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("fir.global_len");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::StringAttr getLenparamAttr() {
    return ::llvm::cast<::mlir::StringAttr>(getProperties().lenparam);
  }

  ::llvm::StringRef getLenparam();
  ::mlir::IntegerAttr getIntvalAttr() {
    return ::llvm::cast<::mlir::IntegerAttr>(getProperties().intval);
  }

  ::mlir::APInt getIntval();
  void setLenparamAttr(::mlir::StringAttr attr) {
    getProperties().lenparam = attr;
  }

  void setLenparam(::llvm::StringRef attrValue);
  void setIntvalAttr(::mlir::IntegerAttr attr) {
    getProperties().intval = attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::StringAttr lenparam, ::mlir::IntegerAttr intval);
  static GlobalLenOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::StringAttr lenparam, ::mlir::IntegerAttr intval);
  static GlobalLenOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::StringAttr lenparam, ::mlir::IntegerAttr intval);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::StringAttr lenparam, ::mlir::IntegerAttr intval);
  static GlobalLenOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::StringAttr lenparam, ::mlir::IntegerAttr intval);
  static GlobalLenOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::StringAttr lenparam, ::mlir::IntegerAttr intval);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::llvm::StringRef lenparam, ::mlir::IntegerAttr intval);
  static GlobalLenOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::llvm::StringRef lenparam, ::mlir::IntegerAttr intval);
  static GlobalLenOp create(::mlir::ImplicitLocOpBuilder &builder, ::llvm::StringRef lenparam, ::mlir::IntegerAttr intval);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::llvm::StringRef lenparam, ::mlir::IntegerAttr intval);
  static GlobalLenOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::llvm::StringRef lenparam, ::mlir::IntegerAttr intval);
  static GlobalLenOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::llvm::StringRef lenparam, ::mlir::IntegerAttr intval);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static GlobalLenOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static GlobalLenOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static GlobalLenOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static GlobalLenOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &p);
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::llvm::LogicalResult setPropertiesFromParsedAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 2 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
  static constexpr llvm::StringRef getLenParamAttrName() { return "lenparam"; }
  static constexpr llvm::StringRef getIntAttrName() { return "intval"; }
};

} // namespace fir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::fir::GlobalLenOp)

namespace fir {


//===----------------------------------------------------------------------===//
// ::fir::GlobalOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class GlobalOpGenericAdaptorBase {
public:
  struct Properties {
    using alignmentTy = ::mlir::IntegerAttr;
    alignmentTy alignment;

    auto getAlignment() const {
      auto &propStorage = this->alignment;
      return ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(propStorage);
    }
    void setAlignment(const ::mlir::IntegerAttr &propValue) {
      this->alignment = propValue;
    }
    using constantTy = ::mlir::UnitAttr;
    constantTy constant;

    auto getConstant() const {
      auto &propStorage = this->constant;
      return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(propStorage);
    }
    void setConstant(const ::mlir::UnitAttr &propValue) {
      this->constant = propValue;
    }
    using data_attrTy = ::cuf::DataAttributeAttr;
    data_attrTy data_attr;

    auto getDataAttr() const {
      auto &propStorage = this->data_attr;
      return ::llvm::dyn_cast_or_null<::cuf::DataAttributeAttr>(propStorage);
    }
    void setDataAttr(const ::cuf::DataAttributeAttr &propValue) {
      this->data_attr = propValue;
    }
    using initValTy = ::mlir::Attribute;
    initValTy initVal;

    auto getInitVal() const {
      auto &propStorage = this->initVal;
      return ::llvm::dyn_cast_or_null<::mlir::Attribute>(propStorage);
    }
    void setInitVal(const ::mlir::Attribute &propValue) {
      this->initVal = propValue;
    }
    using linkNameTy = ::mlir::StringAttr;
    linkNameTy linkName;

    auto getLinkName() const {
      auto &propStorage = this->linkName;
      return ::llvm::dyn_cast_or_null<::mlir::StringAttr>(propStorage);
    }
    void setLinkName(const ::mlir::StringAttr &propValue) {
      this->linkName = propValue;
    }
    using sym_nameTy = ::mlir::StringAttr;
    sym_nameTy sym_name;

    auto getSymName() const {
      auto &propStorage = this->sym_name;
      return ::llvm::cast<::mlir::StringAttr>(propStorage);
    }
    void setSymName(const ::mlir::StringAttr &propValue) {
      this->sym_name = propValue;
    }
    using symrefTy = ::mlir::SymbolRefAttr;
    symrefTy symref;

    auto getSymref() const {
      auto &propStorage = this->symref;
      return ::llvm::cast<::mlir::SymbolRefAttr>(propStorage);
    }
    void setSymref(const ::mlir::SymbolRefAttr &propValue) {
      this->symref = propValue;
    }
    using targetTy = ::mlir::UnitAttr;
    targetTy target;

    auto getTarget() const {
      auto &propStorage = this->target;
      return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(propStorage);
    }
    void setTarget(const ::mlir::UnitAttr &propValue) {
      this->target = propValue;
    }
    using typeTy = ::mlir::TypeAttr;
    typeTy type;

    auto getType() const {
      auto &propStorage = this->type;
      return ::llvm::cast<::mlir::TypeAttr>(propStorage);
    }
    void setType(const ::mlir::TypeAttr &propValue) {
      this->type = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.alignment == this->alignment &&
        rhs.constant == this->constant &&
        rhs.data_attr == this->data_attr &&
        rhs.initVal == this->initVal &&
        rhs.linkName == this->linkName &&
        rhs.sym_name == this->sym_name &&
        rhs.symref == this->symref &&
        rhs.target == this->target &&
        rhs.type == this->type &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  GlobalOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("fir.global", odsAttrs.getContext());
  }

  GlobalOpGenericAdaptorBase(GlobalOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::StringAttr getSymNameAttr() {
    auto attr = ::llvm::cast<::mlir::StringAttr>(getProperties().sym_name);
    return attr;
  }

  ::llvm::StringRef getSymName();
  ::mlir::SymbolRefAttr getSymrefAttr() {
    auto attr = ::llvm::cast<::mlir::SymbolRefAttr>(getProperties().symref);
    return attr;
  }

  ::mlir::SymbolRefAttr getSymref();
  ::mlir::TypeAttr getTypeAttr() {
    auto attr = ::llvm::cast<::mlir::TypeAttr>(getProperties().type);
    return attr;
  }

  ::mlir::Type getType();
  ::mlir::Attribute getInitValAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::Attribute>(getProperties().initVal);
    return attr;
  }

  ::std::optional<::mlir::Attribute> getInitVal();
  ::mlir::UnitAttr getConstantAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(getProperties().constant);
    return attr;
  }

  ::std::optional<bool> getConstant();
  ::mlir::UnitAttr getTargetAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(getProperties().target);
    return attr;
  }

  ::std::optional<bool> getTarget();
  ::mlir::StringAttr getLinkNameAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::StringAttr>(getProperties().linkName);
    return attr;
  }

  ::std::optional< ::llvm::StringRef > getLinkName();
  ::cuf::DataAttributeAttr getDataAttrAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::cuf::DataAttributeAttr>(getProperties().data_attr);
    return attr;
  }

  ::std::optional<::cuf::DataAttribute> getDataAttr();
  ::mlir::IntegerAttr getAlignmentAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(getProperties().alignment);
    return attr;
  }

  ::std::optional<uint64_t> getAlignment();
  ::mlir::Region &getRegion() {
    return *odsRegions[0];
  }

  ::mlir::RegionRange getRegions() {
    return odsRegions;
  }

};

} // namespace detail
template <typename RangeT>
class GlobalOpGenericAdaptor : public detail::GlobalOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::GlobalOpGenericAdaptorBase;
public:
  GlobalOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  GlobalOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : GlobalOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  GlobalOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : GlobalOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  GlobalOpGenericAdaptor(RangeT values, const GlobalOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = GlobalOp, typename = std::enable_if_t<std::is_same_v<LateInst, GlobalOp>>>
  GlobalOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class GlobalOpAdaptor : public GlobalOpGenericAdaptor<::mlir::ValueRange> {
public:
  using GlobalOpGenericAdaptor::GlobalOpGenericAdaptor;
  GlobalOpAdaptor(GlobalOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class GlobalOp : public ::mlir::Op<GlobalOp, ::mlir::OpTrait::OneRegion, ::mlir::OpTrait::ZeroResults, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::ZeroOperands, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::OpTrait::IsIsolatedFromAbove, ::mlir::SymbolOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = GlobalOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = GlobalOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("alignment"), ::llvm::StringRef("constant"), ::llvm::StringRef("data_attr"), ::llvm::StringRef("initVal"), ::llvm::StringRef("linkName"), ::llvm::StringRef("sym_name"), ::llvm::StringRef("symref"), ::llvm::StringRef("target"), ::llvm::StringRef("type")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getAlignmentAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getAlignmentAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getConstantAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getConstantAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  ::mlir::StringAttr getDataAttrAttrName() {
    return getAttributeNameForIndex(2);
  }

  static ::mlir::StringAttr getDataAttrAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 2);
  }

  ::mlir::StringAttr getInitValAttrName() {
    return getAttributeNameForIndex(3);
  }

  static ::mlir::StringAttr getInitValAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 3);
  }

  ::mlir::StringAttr getLinkNameAttrName() {
    return getAttributeNameForIndex(4);
  }

  static ::mlir::StringAttr getLinkNameAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 4);
  }

  ::mlir::StringAttr getSymNameAttrName() {
    return getAttributeNameForIndex(5);
  }

  static ::mlir::StringAttr getSymNameAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 5);
  }

  ::mlir::StringAttr getSymrefAttrName() {
    return getAttributeNameForIndex(6);
  }

  static ::mlir::StringAttr getSymrefAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 6);
  }

  ::mlir::StringAttr getTargetAttrName() {
    return getAttributeNameForIndex(7);
  }

  static ::mlir::StringAttr getTargetAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 7);
  }

  ::mlir::StringAttr getTypeAttrName() {
    return getAttributeNameForIndex(8);
  }

  static ::mlir::StringAttr getTypeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 8);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("fir.global");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::Region &getRegion() {
    return (*this)->getRegion(0);
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::StringAttr getSymNameAttr() {
    return ::llvm::cast<::mlir::StringAttr>(getProperties().sym_name);
  }

  ::llvm::StringRef getSymName();
  ::mlir::SymbolRefAttr getSymrefAttr() {
    return ::llvm::cast<::mlir::SymbolRefAttr>(getProperties().symref);
  }

  ::mlir::SymbolRefAttr getSymref();
  ::mlir::TypeAttr getTypeAttr() {
    return ::llvm::cast<::mlir::TypeAttr>(getProperties().type);
  }

  ::mlir::Type getType();
  ::mlir::Attribute getInitValAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::Attribute>(getProperties().initVal);
  }

  ::std::optional<::mlir::Attribute> getInitVal();
  ::mlir::UnitAttr getConstantAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(getProperties().constant);
  }

  ::std::optional<bool> getConstant();
  ::mlir::UnitAttr getTargetAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(getProperties().target);
  }

  ::std::optional<bool> getTarget();
  ::mlir::StringAttr getLinkNameAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::StringAttr>(getProperties().linkName);
  }

  ::std::optional< ::llvm::StringRef > getLinkName();
  ::cuf::DataAttributeAttr getDataAttrAttr() {
    return ::llvm::dyn_cast_or_null<::cuf::DataAttributeAttr>(getProperties().data_attr);
  }

  ::std::optional<::cuf::DataAttribute> getDataAttr();
  ::mlir::IntegerAttr getAlignmentAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(getProperties().alignment);
  }

  ::std::optional<uint64_t> getAlignment();
  void setSymNameAttr(::mlir::StringAttr attr) {
    getProperties().sym_name = attr;
  }

  void setSymName(::llvm::StringRef attrValue);
  void setSymrefAttr(::mlir::SymbolRefAttr attr) {
    getProperties().symref = attr;
  }

  void setTypeAttr(::mlir::TypeAttr attr) {
    getProperties().type = attr;
  }

  void setType(::mlir::Type attrValue);
  void setInitValAttr(::mlir::Attribute attr) {
    getProperties().initVal = attr;
  }

  void setConstantAttr(::mlir::UnitAttr attr) {
    getProperties().constant = attr;
  }

  void setConstant(bool attrValue);
  void setTargetAttr(::mlir::UnitAttr attr) {
    getProperties().target = attr;
  }

  void setTarget(bool attrValue);
  void setLinkNameAttr(::mlir::StringAttr attr) {
    getProperties().linkName = attr;
  }

  void setLinkName(::std::optional<::llvm::StringRef> attrValue);
  void setDataAttrAttr(::cuf::DataAttributeAttr attr) {
    getProperties().data_attr = attr;
  }

  void setDataAttr(::std::optional<::cuf::DataAttribute> attrValue);
  void setAlignmentAttr(::mlir::IntegerAttr attr) {
    getProperties().alignment = attr;
  }

  void setAlignment(::std::optional<uint64_t> attrValue);
  ::mlir::Attribute removeInitValAttr() {
      auto attr = getProperties().initVal;
      getProperties().initVal = {};
      return attr;
  }

  ::mlir::Attribute removeConstantAttr() {
      auto attr = getProperties().constant;
      getProperties().constant = {};
      return attr;
  }

  ::mlir::Attribute removeTargetAttr() {
      auto attr = getProperties().target;
      getProperties().target = {};
      return attr;
  }

  ::mlir::Attribute removeLinkNameAttr() {
      auto attr = getProperties().linkName;
      getProperties().linkName = {};
      return attr;
  }

  ::mlir::Attribute removeDataAttrAttr() {
      auto attr = getProperties().data_attr;
      getProperties().data_attr = {};
      return attr;
  }

  ::mlir::Attribute removeAlignmentAttr() {
      auto attr = getProperties().alignment;
      getProperties().alignment = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, llvm::StringRef name, mlir::Type type, llvm::ArrayRef<mlir::NamedAttribute> attrs = {});
  static GlobalOp create(::mlir::OpBuilder &builder, ::mlir::Location location, llvm::StringRef name, mlir::Type type, llvm::ArrayRef<mlir::NamedAttribute> attrs = {});
  static GlobalOp create(::mlir::ImplicitLocOpBuilder &builder, llvm::StringRef name, mlir::Type type, llvm::ArrayRef<mlir::NamedAttribute> attrs = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, llvm::StringRef name, bool isConstant, bool isTarget, mlir::Type type, llvm::ArrayRef<mlir::NamedAttribute> attrs = {});
  static GlobalOp create(::mlir::OpBuilder &builder, ::mlir::Location location, llvm::StringRef name, bool isConstant, bool isTarget, mlir::Type type, llvm::ArrayRef<mlir::NamedAttribute> attrs = {});
  static GlobalOp create(::mlir::ImplicitLocOpBuilder &builder, llvm::StringRef name, bool isConstant, bool isTarget, mlir::Type type, llvm::ArrayRef<mlir::NamedAttribute> attrs = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, llvm::StringRef name, mlir::Type type, mlir::StringAttr linkage = {}, llvm::ArrayRef<mlir::NamedAttribute> attrs = {});
  static GlobalOp create(::mlir::OpBuilder &builder, ::mlir::Location location, llvm::StringRef name, mlir::Type type, mlir::StringAttr linkage = {}, llvm::ArrayRef<mlir::NamedAttribute> attrs = {});
  static GlobalOp create(::mlir::ImplicitLocOpBuilder &builder, llvm::StringRef name, mlir::Type type, mlir::StringAttr linkage = {}, llvm::ArrayRef<mlir::NamedAttribute> attrs = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, llvm::StringRef name, bool isConstant, bool isTarget, mlir::Type type, mlir::StringAttr linkage = {}, llvm::ArrayRef<mlir::NamedAttribute> attrs = {});
  static GlobalOp create(::mlir::OpBuilder &builder, ::mlir::Location location, llvm::StringRef name, bool isConstant, bool isTarget, mlir::Type type, mlir::StringAttr linkage = {}, llvm::ArrayRef<mlir::NamedAttribute> attrs = {});
  static GlobalOp create(::mlir::ImplicitLocOpBuilder &builder, llvm::StringRef name, bool isConstant, bool isTarget, mlir::Type type, mlir::StringAttr linkage = {}, llvm::ArrayRef<mlir::NamedAttribute> attrs = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, llvm::StringRef name, mlir::Type type, mlir::Attribute initVal, mlir::StringAttr linkage = {}, llvm::ArrayRef<mlir::NamedAttribute> attrs = {});
  static GlobalOp create(::mlir::OpBuilder &builder, ::mlir::Location location, llvm::StringRef name, mlir::Type type, mlir::Attribute initVal, mlir::StringAttr linkage = {}, llvm::ArrayRef<mlir::NamedAttribute> attrs = {});
  static GlobalOp create(::mlir::ImplicitLocOpBuilder &builder, llvm::StringRef name, mlir::Type type, mlir::Attribute initVal, mlir::StringAttr linkage = {}, llvm::ArrayRef<mlir::NamedAttribute> attrs = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, llvm::StringRef name, bool isConstant, bool isTarget, mlir::Type type, mlir::Attribute initVal, mlir::StringAttr linkage = {}, llvm::ArrayRef<mlir::NamedAttribute> attrs = {});
  static GlobalOp create(::mlir::OpBuilder &builder, ::mlir::Location location, llvm::StringRef name, bool isConstant, bool isTarget, mlir::Type type, mlir::Attribute initVal, mlir::StringAttr linkage = {}, llvm::ArrayRef<mlir::NamedAttribute> attrs = {});
  static GlobalOp create(::mlir::ImplicitLocOpBuilder &builder, llvm::StringRef name, bool isConstant, bool isTarget, mlir::Type type, mlir::Attribute initVal, mlir::StringAttr linkage = {}, llvm::ArrayRef<mlir::NamedAttribute> attrs = {});
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &p);
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::llvm::LogicalResult setPropertiesFromParsedAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 9 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
  /// The semantic type of the global
  mlir::Type resultType();

  /// Return the initializer attribute if it exists, or a null attribute.
  mlir::Attribute getValueOrNull() { return getInitVal().value_or(mlir::Attribute()); }

  /// Append the next initializer value to the `GlobalOp` to construct
  /// the variable's initial value.
  void appendInitialValue(mlir::Operation *op);

  /// A GlobalOp has one block.
  mlir::Block &getBlock() { return getRegion().front(); }

  /// Determine if `linkage` is a supported keyword
  static mlir::ParseResult verifyValidLinkage(llvm::StringRef linkage);

  bool hasInitializationBody() {
    return ((*this)->getNumRegions() == 1) && !getRegion().empty() &&
      !mlir::isa<fir::FirEndOp>(getBlock().front());
  }

  mlir::FlatSymbolRefAttr getSymbol() {
    return mlir::FlatSymbolRefAttr::get(getContext(),
        (*this)->getAttrOfType<mlir::StringAttr>(
            mlir::SymbolTable::getSymbolAttrName()).getValue());
  }

  bool isInitialized() {
    return getInitVal() || hasInitializationBody();
  }
};

} // namespace fir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::fir::GlobalOp)

namespace fir {


//===----------------------------------------------------------------------===//
// ::fir::HasValueOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class HasValueOpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  HasValueOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("fir.has_value", odsAttrs.getContext());
  }

  HasValueOpGenericAdaptorBase(HasValueOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};

} // namespace detail
template <typename RangeT>
class HasValueOpGenericAdaptor : public detail::HasValueOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::HasValueOpGenericAdaptorBase;
  static constexpr int odsIndex_resval = 0;
public:
  HasValueOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  HasValueOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : HasValueOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  HasValueOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : HasValueOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  HasValueOpGenericAdaptor(RangeT values, const HasValueOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = HasValueOp, typename = std::enable_if_t<std::is_same_v<LateInst, HasValueOp>>>
  HasValueOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getResval() {
    return (*getODSOperands(0).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class HasValueOpAdaptor : public HasValueOpGenericAdaptor<::mlir::ValueRange> {
public:
  using HasValueOpGenericAdaptor::HasValueOpGenericAdaptor;
  HasValueOpAdaptor(HasValueOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class HasValueOp : public ::mlir::Op<HasValueOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::ZeroResults, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::OneOperand, ::mlir::OpTrait::HasParent<GlobalOp>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::OpTrait::IsTerminator> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = HasValueOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = HasValueOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_resval = 0;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    return {};
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("fir.has_value");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getResval() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(0).begin());
  }

  ::mlir::OpOperand &getResvalMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value resval);
  static HasValueOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value resval);
  static HasValueOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value resval);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value resval);
  static HasValueOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value resval);
  static HasValueOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value resval);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static HasValueOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static HasValueOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static HasValueOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static HasValueOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
public:
};

} // namespace fir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::fir::HasValueOp)

namespace fir {


//===----------------------------------------------------------------------===//
// ::fir::IfOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class IfOpGenericAdaptorBase {
public:
  struct Properties {
    using region_weightsTy = ::mlir::DenseI32ArrayAttr;
    region_weightsTy region_weights;

    auto getRegionWeights() const {
      auto &propStorage = this->region_weights;
      return ::llvm::dyn_cast_or_null<::mlir::DenseI32ArrayAttr>(propStorage);
    }
    void setRegionWeights(const ::mlir::DenseI32ArrayAttr &propValue) {
      this->region_weights = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.region_weights == this->region_weights &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  IfOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("fir.if", odsAttrs.getContext());
  }

  IfOpGenericAdaptorBase(IfOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::DenseI32ArrayAttr getRegionWeightsAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::DenseI32ArrayAttr>(getProperties().region_weights);
    return attr;
  }

  ::std::optional<::llvm::ArrayRef<int32_t>> getRegionWeights();
  ::mlir::Region &getThenRegion() {
    return *odsRegions[0];
  }

  ::mlir::Region &getElseRegion() {
    return *odsRegions[1];
  }

  ::mlir::RegionRange getRegions() {
    return odsRegions;
  }

};

} // namespace detail
template <typename RangeT>
class IfOpGenericAdaptor : public detail::IfOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::IfOpGenericAdaptorBase;
  static constexpr int odsIndex_condition = 0;
public:
  IfOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  IfOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : IfOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  IfOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : IfOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  IfOpGenericAdaptor(RangeT values, const IfOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = IfOp, typename = std::enable_if_t<std::is_same_v<LateInst, IfOp>>>
  IfOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getCondition() {
    return (*getODSOperands(0).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class IfOpAdaptor : public IfOpGenericAdaptor<::mlir::ValueRange> {
public:
  using IfOpGenericAdaptor::IfOpGenericAdaptor;
  IfOpAdaptor(IfOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class IfOp : public ::mlir::Op<IfOp, ::mlir::OpTrait::NRegions<2>::Impl, ::mlir::OpTrait::VariadicResults, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::OneOperand, ::mlir::OpTrait::NoRegionArguments, ::mlir::OpTrait::SingleBlock, ::mlir::OpTrait::SingleBlockImplicitTerminator<ResultOp>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::RegionBranchOpInterface::Trait, ::mlir::OpTrait::HasRecursiveMemoryEffects, ::mlir::WeightedRegionBranchOpInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::RecursivelySpeculatableImplTrait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = IfOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = IfOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_condition = 0;
  using Properties = FoldAdaptor::Properties;
  using ::mlir::RegionBranchOpInterface::Trait<IfOp>::getEntrySuccessorOperands;
  using ::mlir::RegionBranchOpInterface::Trait<IfOp>::getSuccessorRegions;
  using ::mlir::RegionBranchOpInterface::Trait<IfOp>::getPredecessors;
  using ::mlir::RegionBranchOpInterface::Trait<IfOp>::getPredecessorValues;
  using ::mlir::RegionBranchOpInterface::Trait<IfOp>::areTypesCompatible;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("region_weights")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getRegionWeightsAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getRegionWeightsAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("fir.if");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::IntegerType> getCondition() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*getODSOperands(0).begin());
  }

  ::mlir::OpOperand &getConditionMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index);
  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::Operation::result_range getResults() {
    return getODSResults(0);
  }

  ::mlir::Region &getThenRegion() {
    return (*this)->getRegion(0);
  }

  ::mlir::Region &getElseRegion() {
    return (*this)->getRegion(1);
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::DenseI32ArrayAttr getRegionWeightsAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::DenseI32ArrayAttr>(getProperties().region_weights);
  }

  ::std::optional<::llvm::ArrayRef<int32_t>> getRegionWeights();
  void setRegionWeightsAttr(::mlir::DenseI32ArrayAttr attr) {
    getProperties().region_weights = attr;
  }

  void setRegionWeights(::std::optional<::llvm::ArrayRef<int32_t>> attrValue);
  ::mlir::Attribute removeRegionWeightsAttr() {
      auto attr = getProperties().region_weights;
      getProperties().region_weights = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, mlir::Value cond, bool withElseRegion);
  static IfOp create(::mlir::OpBuilder &builder, ::mlir::Location location, mlir::Value cond, bool withElseRegion);
  static IfOp create(::mlir::ImplicitLocOpBuilder &builder, mlir::Value cond, bool withElseRegion);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, mlir::TypeRange resultTypes, mlir::Value cond, bool withElseRegion);
  static IfOp create(::mlir::OpBuilder &builder, ::mlir::Location location, mlir::TypeRange resultTypes, mlir::Value cond, bool withElseRegion);
  static IfOp create(::mlir::ImplicitLocOpBuilder &builder, mlir::TypeRange resultTypes, mlir::Value cond, bool withElseRegion);
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &p);
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  void getEntrySuccessorRegions(::llvm::ArrayRef<::mlir::Attribute> operands, ::llvm::SmallVectorImpl<::mlir::RegionSuccessor> &regions);
  void getSuccessorRegions(::mlir::RegionBranchPoint point, ::llvm::SmallVectorImpl<::mlir::RegionSuccessor> &regions);
  void getRegionInvocationBounds(::llvm::ArrayRef<::mlir::Attribute> operands, ::llvm::SmallVectorImpl<::mlir::InvocationBounds> &invocationBounds);
  static ::llvm::LogicalResult setPropertiesFromParsedAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
  mlir::OpBuilder getThenBodyBuilder() {
    assert(!getThenRegion().empty() && "Unexpected empty 'where' region.");
    mlir::Block &body = getThenRegion().front();
    return mlir::OpBuilder(&body, std::prev(body.end()));
  }
  mlir::OpBuilder getElseBodyBuilder() {
    assert(!getElseRegion().empty() && "Unexpected empty 'other' region.");
    mlir::Block &body = getElseRegion().front();
    return mlir::OpBuilder(&body, std::prev(body.end()));
  }

  void resultToSourceOps(llvm::SmallVectorImpl<mlir::Value> &results,
                         unsigned resultNum);

  /// Returns the display name string for the region_weights attribute.
  static constexpr llvm::StringRef getWeightsAttrAssemblyName() {
    return "weights";
  }

  /// Sets WeightedRegionBranchOpInterface weights to indicate
  /// that either THEN or ELSE branch is unlikely.
  /// By default, THEN branch is set to be unlikely.
  void setUnlikelyIfWeights(bool unlikelyElse = false) {
    if (unlikelyElse)
      setWeights({1, 0});
    else
      setWeights({0, 1});
  }
};

} // namespace fir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::fir::IfOp)

namespace fir {


//===----------------------------------------------------------------------===//
// ::fir::InsertOnRangeOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class InsertOnRangeOpGenericAdaptorBase {
public:
  struct Properties {
    using coorTy = ::mlir::DenseIntElementsAttr;
    coorTy coor;

    auto getCoor() const {
      auto &propStorage = this->coor;
      return ::llvm::cast<::mlir::DenseIntElementsAttr>(propStorage);
    }
    void setCoor(const ::mlir::DenseIntElementsAttr &propValue) {
      this->coor = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.coor == this->coor &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  InsertOnRangeOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("fir.insert_on_range", odsAttrs.getContext());
  }

  InsertOnRangeOpGenericAdaptorBase(InsertOnRangeOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::DenseIntElementsAttr getCoorAttr() {
    auto attr = ::llvm::cast<::mlir::DenseIntElementsAttr>(getProperties().coor);
    return attr;
  }

  ::mlir::DenseIntElementsAttr getCoor();
};

} // namespace detail
template <typename RangeT>
class InsertOnRangeOpGenericAdaptor : public detail::InsertOnRangeOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::InsertOnRangeOpGenericAdaptorBase;
  static constexpr int odsIndex_seq = 0;
  static constexpr int odsIndex_val = 1;
public:
  InsertOnRangeOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  InsertOnRangeOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : InsertOnRangeOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  InsertOnRangeOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : InsertOnRangeOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  InsertOnRangeOpGenericAdaptor(RangeT values, const InsertOnRangeOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = InsertOnRangeOp, typename = std::enable_if_t<std::is_same_v<LateInst, InsertOnRangeOp>>>
  InsertOnRangeOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getSeq() {
    return (*getODSOperands(0).begin());
  }

  ValueT getVal() {
    return (*getODSOperands(1).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class InsertOnRangeOpAdaptor : public InsertOnRangeOpGenericAdaptor<::mlir::ValueRange> {
public:
  using InsertOnRangeOpGenericAdaptor::InsertOnRangeOpGenericAdaptor;
  InsertOnRangeOpAdaptor(InsertOnRangeOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class InsertOnRangeOp : public ::mlir::Op<InsertOnRangeOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::fir::SequenceType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<2>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = InsertOnRangeOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = InsertOnRangeOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_seq = 0;
  static constexpr int odsIndex_val = 1;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("coor")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getCoorAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getCoorAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("fir.insert_on_range");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::fir::SequenceType> getSeq() {
    return ::llvm::cast<::mlir::TypedValue<::fir::SequenceType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::Type> getVal() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(1).begin());
  }

  ::mlir::OpOperand &getSeqMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getValMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::DenseIntElementsAttr getCoorAttr() {
    return ::llvm::cast<::mlir::DenseIntElementsAttr>(getProperties().coor);
  }

  ::mlir::DenseIntElementsAttr getCoor();
  void setCoorAttr(::mlir::DenseIntElementsAttr attr) {
    getProperties().coor = attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, mlir::Type resultType, mlir::ValueRange operands, llvm::ArrayRef<mlir::NamedAttribute> attributes = {});
  static InsertOnRangeOp create(::mlir::OpBuilder &builder, ::mlir::Location location, mlir::Type resultType, mlir::ValueRange operands, llvm::ArrayRef<mlir::NamedAttribute> attributes = {});
  static InsertOnRangeOp create(::mlir::ImplicitLocOpBuilder &builder, mlir::Type resultType, mlir::ValueRange operands, llvm::ArrayRef<mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type resultType0, ::mlir::Value seq, ::mlir::Value val, ::mlir::DenseIntElementsAttr coor);
  static InsertOnRangeOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type resultType0, ::mlir::Value seq, ::mlir::Value val, ::mlir::DenseIntElementsAttr coor);
  static InsertOnRangeOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type resultType0, ::mlir::Value seq, ::mlir::Value val, ::mlir::DenseIntElementsAttr coor);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value seq, ::mlir::Value val, ::mlir::DenseIntElementsAttr coor);
  static InsertOnRangeOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value seq, ::mlir::Value val, ::mlir::DenseIntElementsAttr coor);
  static InsertOnRangeOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value seq, ::mlir::Value val, ::mlir::DenseIntElementsAttr coor);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static InsertOnRangeOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static InsertOnRangeOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static InsertOnRangeOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static InsertOnRangeOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
  /// Is this insert_on_range inserting on all the values of the result type?
  bool isFullRange();
};

} // namespace fir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::fir::InsertOnRangeOp)

namespace fir {


//===----------------------------------------------------------------------===//
// ::fir::InsertValueOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class InsertValueOpGenericAdaptorBase {
public:
  struct Properties {
    using coorTy = ::mlir::ArrayAttr;
    coorTy coor;

    auto getCoor() const {
      auto &propStorage = this->coor;
      return ::llvm::cast<::mlir::ArrayAttr>(propStorage);
    }
    void setCoor(const ::mlir::ArrayAttr &propValue) {
      this->coor = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.coor == this->coor &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  InsertValueOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("fir.insert_value", odsAttrs.getContext());
  }

  InsertValueOpGenericAdaptorBase(InsertValueOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::ArrayAttr getCoorAttr() {
    auto attr = ::llvm::cast<::mlir::ArrayAttr>(getProperties().coor);
    return attr;
  }

  ::mlir::ArrayAttr getCoor();
};

} // namespace detail
template <typename RangeT>
class InsertValueOpGenericAdaptor : public detail::InsertValueOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::InsertValueOpGenericAdaptorBase;
  static constexpr int odsIndex_adt = 0;
  static constexpr int odsIndex_val = 1;
public:
  InsertValueOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  InsertValueOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : InsertValueOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  InsertValueOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : InsertValueOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  InsertValueOpGenericAdaptor(RangeT values, const InsertValueOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = InsertValueOp, typename = std::enable_if_t<std::is_same_v<LateInst, InsertValueOp>>>
  InsertValueOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getAdt() {
    return (*getODSOperands(0).begin());
  }

  ValueT getVal() {
    return (*getODSOperands(1).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class InsertValueOpAdaptor : public InsertValueOpGenericAdaptor<::mlir::ValueRange> {
public:
  using InsertValueOpGenericAdaptor::InsertValueOpGenericAdaptor;
  InsertValueOpAdaptor(InsertValueOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class InsertValueOp : public ::mlir::Op<InsertValueOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::Type>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<2>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = InsertValueOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = InsertValueOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_adt = 0;
  static constexpr int odsIndex_val = 1;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("coor")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getCoorAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getCoorAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("fir.insert_value");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getAdt() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::Type> getVal() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(1).begin());
  }

  ::mlir::OpOperand &getAdtMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getValMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::ArrayAttr getCoorAttr() {
    return ::llvm::cast<::mlir::ArrayAttr>(getProperties().coor);
  }

  ::mlir::ArrayAttr getCoor();
  void setCoorAttr(::mlir::ArrayAttr attr) {
    getProperties().coor = attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, mlir::Type resultType, mlir::ValueRange operands, llvm::ArrayRef<mlir::NamedAttribute> attributes = {});
  static InsertValueOp create(::mlir::OpBuilder &builder, ::mlir::Location location, mlir::Type resultType, mlir::ValueRange operands, llvm::ArrayRef<mlir::NamedAttribute> attributes = {});
  static InsertValueOp create(::mlir::ImplicitLocOpBuilder &builder, mlir::Type resultType, mlir::ValueRange operands, llvm::ArrayRef<mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type resultType0, ::mlir::Value adt, ::mlir::Value val, ::mlir::ArrayAttr coor);
  static InsertValueOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type resultType0, ::mlir::Value adt, ::mlir::Value val, ::mlir::ArrayAttr coor);
  static InsertValueOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type resultType0, ::mlir::Value adt, ::mlir::Value val, ::mlir::ArrayAttr coor);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value adt, ::mlir::Value val, ::mlir::ArrayAttr coor);
  static InsertValueOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value adt, ::mlir::Value val, ::mlir::ArrayAttr coor);
  static InsertValueOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value adt, ::mlir::Value val, ::mlir::ArrayAttr coor);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static InsertValueOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static InsertValueOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static InsertValueOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static InsertValueOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static void getCanonicalizationPatterns(::mlir::RewritePatternSet &results, ::mlir::MLIRContext *context);
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};

} // namespace fir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::fir::InsertValueOp)

namespace fir {


//===----------------------------------------------------------------------===//
// ::fir::IsAssumedSizeExtentOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class IsAssumedSizeExtentOpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  IsAssumedSizeExtentOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("fir.is_assumed_size_extent", odsAttrs.getContext());
  }

  IsAssumedSizeExtentOpGenericAdaptorBase(IsAssumedSizeExtentOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};

} // namespace detail
template <typename RangeT>
class IsAssumedSizeExtentOpGenericAdaptor : public detail::IsAssumedSizeExtentOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::IsAssumedSizeExtentOpGenericAdaptorBase;
  static constexpr int odsIndex_val = 0;
public:
  IsAssumedSizeExtentOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  IsAssumedSizeExtentOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : IsAssumedSizeExtentOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  IsAssumedSizeExtentOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : IsAssumedSizeExtentOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  IsAssumedSizeExtentOpGenericAdaptor(RangeT values, const IsAssumedSizeExtentOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = IsAssumedSizeExtentOp, typename = std::enable_if_t<std::is_same_v<LateInst, IsAssumedSizeExtentOp>>>
  IsAssumedSizeExtentOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getVal() {
    return (*getODSOperands(0).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class IsAssumedSizeExtentOpAdaptor : public IsAssumedSizeExtentOpGenericAdaptor<::mlir::ValueRange> {
public:
  using IsAssumedSizeExtentOpGenericAdaptor::IsAssumedSizeExtentOpGenericAdaptor;
  IsAssumedSizeExtentOpAdaptor(IsAssumedSizeExtentOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class IsAssumedSizeExtentOp : public ::mlir::Op<IsAssumedSizeExtentOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::Type>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::OneOperand, ::mlir::OpTrait::OpInvariants, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = IsAssumedSizeExtentOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = IsAssumedSizeExtentOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_val = 0;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    return {};
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("fir.is_assumed_size_extent");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getVal() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(0).begin());
  }

  ::mlir::OpOperand &getValMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type resultType0, ::mlir::Value val);
  static IsAssumedSizeExtentOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type resultType0, ::mlir::Value val);
  static IsAssumedSizeExtentOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type resultType0, ::mlir::Value val);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value val);
  static IsAssumedSizeExtentOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value val);
  static IsAssumedSizeExtentOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value val);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static IsAssumedSizeExtentOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static IsAssumedSizeExtentOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static IsAssumedSizeExtentOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static IsAssumedSizeExtentOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static void getCanonicalizationPatterns(::mlir::RewritePatternSet &results, ::mlir::MLIRContext *context);
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
public:
};

} // namespace fir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::fir::IsAssumedSizeExtentOp)

namespace fir {


//===----------------------------------------------------------------------===//
// ::fir::IsAssumedSizeOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class IsAssumedSizeOpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  IsAssumedSizeOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("fir.is_assumed_size", odsAttrs.getContext());
  }

  IsAssumedSizeOpGenericAdaptorBase(IsAssumedSizeOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};

} // namespace detail
template <typename RangeT>
class IsAssumedSizeOpGenericAdaptor : public detail::IsAssumedSizeOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::IsAssumedSizeOpGenericAdaptorBase;
  static constexpr int odsIndex_val = 0;
public:
  IsAssumedSizeOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  IsAssumedSizeOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : IsAssumedSizeOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  IsAssumedSizeOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : IsAssumedSizeOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  IsAssumedSizeOpGenericAdaptor(RangeT values, const IsAssumedSizeOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = IsAssumedSizeOp, typename = std::enable_if_t<std::is_same_v<LateInst, IsAssumedSizeOp>>>
  IsAssumedSizeOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getVal() {
    return (*getODSOperands(0).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class IsAssumedSizeOpAdaptor : public IsAssumedSizeOpGenericAdaptor<::mlir::ValueRange> {
public:
  using IsAssumedSizeOpGenericAdaptor::IsAssumedSizeOpGenericAdaptor;
  IsAssumedSizeOpAdaptor(IsAssumedSizeOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class IsAssumedSizeOp : public ::mlir::Op<IsAssumedSizeOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::Type>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::OneOperand, ::mlir::OpTrait::OpInvariants, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = IsAssumedSizeOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = IsAssumedSizeOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_val = 0;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    return {};
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("fir.is_assumed_size");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getVal() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(0).begin());
  }

  ::mlir::OpOperand &getValMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type resultType0, ::mlir::Value val);
  static IsAssumedSizeOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type resultType0, ::mlir::Value val);
  static IsAssumedSizeOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type resultType0, ::mlir::Value val);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value val);
  static IsAssumedSizeOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value val);
  static IsAssumedSizeOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value val);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static IsAssumedSizeOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static IsAssumedSizeOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static IsAssumedSizeOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static IsAssumedSizeOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
public:
};

} // namespace fir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::fir::IsAssumedSizeOp)

namespace fir {


//===----------------------------------------------------------------------===//
// ::fir::IsContiguousBoxOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class IsContiguousBoxOpGenericAdaptorBase {
public:
  struct Properties {
    using innermostTy = ::mlir::UnitAttr;
    innermostTy innermost;

    auto getInnermost() const {
      auto &propStorage = this->innermost;
      return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(propStorage);
    }
    void setInnermost(const ::mlir::UnitAttr &propValue) {
      this->innermost = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.innermost == this->innermost &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  IsContiguousBoxOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("fir.is_contiguous_box", odsAttrs.getContext());
  }

  IsContiguousBoxOpGenericAdaptorBase(IsContiguousBoxOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::UnitAttr getInnermostAttr();
  bool getInnermost();
};

} // namespace detail
template <typename RangeT>
class IsContiguousBoxOpGenericAdaptor : public detail::IsContiguousBoxOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::IsContiguousBoxOpGenericAdaptorBase;
  static constexpr int odsIndex_box = 0;
public:
  IsContiguousBoxOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  IsContiguousBoxOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : IsContiguousBoxOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  IsContiguousBoxOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : IsContiguousBoxOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  IsContiguousBoxOpGenericAdaptor(RangeT values, const IsContiguousBoxOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = IsContiguousBoxOp, typename = std::enable_if_t<std::is_same_v<LateInst, IsContiguousBoxOp>>>
  IsContiguousBoxOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getBox() {
    return (*getODSOperands(0).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class IsContiguousBoxOpAdaptor : public IsContiguousBoxOpGenericAdaptor<::mlir::ValueRange> {
public:
  using IsContiguousBoxOpGenericAdaptor::IsContiguousBoxOpGenericAdaptor;
  IsContiguousBoxOpAdaptor(IsContiguousBoxOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class IsContiguousBoxOp : public ::mlir::Op<IsContiguousBoxOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::IntegerType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::OneOperand, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::InferTypeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = IsContiguousBoxOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = IsContiguousBoxOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_box = 0;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("innermost")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getInnermostAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getInnermostAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("fir.is_contiguous_box");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getBox() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(0).begin());
  }

  ::mlir::OpOperand &getBoxMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::UnitAttr getInnermostAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(getProperties().innermost);
  }

  bool getInnermost();
  void setInnermostAttr(::mlir::UnitAttr attr) {
    getProperties().innermost = attr;
  }

  void setInnermost(bool attrValue);
  ::mlir::Attribute removeInnermostAttr() {
      auto attr = getProperties().innermost;
      getProperties().innermost = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type resultType0, ::mlir::Value box, /*optional*/::mlir::UnitAttr innermost);
  static IsContiguousBoxOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type resultType0, ::mlir::Value box, /*optional*/::mlir::UnitAttr innermost);
  static IsContiguousBoxOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type resultType0, ::mlir::Value box, /*optional*/::mlir::UnitAttr innermost);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value box, /*optional*/::mlir::UnitAttr innermost);
  static IsContiguousBoxOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value box, /*optional*/::mlir::UnitAttr innermost);
  static IsContiguousBoxOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value box, /*optional*/::mlir::UnitAttr innermost);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value box, /*optional*/::mlir::UnitAttr innermost);
  static IsContiguousBoxOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value box, /*optional*/::mlir::UnitAttr innermost);
  static IsContiguousBoxOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value box, /*optional*/::mlir::UnitAttr innermost);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type resultType0, ::mlir::Value box, /*optional*/bool innermost = false);
  static IsContiguousBoxOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type resultType0, ::mlir::Value box, /*optional*/bool innermost = false);
  static IsContiguousBoxOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type resultType0, ::mlir::Value box, /*optional*/bool innermost = false);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value box, /*optional*/bool innermost = false);
  static IsContiguousBoxOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value box, /*optional*/bool innermost = false);
  static IsContiguousBoxOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value box, /*optional*/bool innermost = false);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value box, /*optional*/bool innermost = false);
  static IsContiguousBoxOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value box, /*optional*/bool innermost = false);
  static IsContiguousBoxOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value box, /*optional*/bool innermost = false);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static IsContiguousBoxOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static IsContiguousBoxOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static IsContiguousBoxOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static IsContiguousBoxOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static IsContiguousBoxOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static IsContiguousBoxOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static IsContiguousBoxOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static IsContiguousBoxOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static void getCanonicalizationPatterns(::mlir::RewritePatternSet &results, ::mlir::MLIRContext *context);
  static ::llvm::LogicalResult inferReturnTypes(::mlir::MLIRContext *context, ::std::optional<::mlir::Location> location, ::mlir::ValueRange operands, ::mlir::DictionaryAttr attributes, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions, ::llvm::SmallVectorImpl<::mlir::Type>&inferredReturnTypes);
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};

} // namespace fir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::fir::IsContiguousBoxOp)

namespace fir {


//===----------------------------------------------------------------------===//
// ::fir::IsPresentOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class IsPresentOpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  IsPresentOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("fir.is_present", odsAttrs.getContext());
  }

  IsPresentOpGenericAdaptorBase(IsPresentOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};

} // namespace detail
template <typename RangeT>
class IsPresentOpGenericAdaptor : public detail::IsPresentOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::IsPresentOpGenericAdaptorBase;
  static constexpr int odsIndex_val = 0;
public:
  IsPresentOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  IsPresentOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : IsPresentOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  IsPresentOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : IsPresentOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  IsPresentOpGenericAdaptor(RangeT values, const IsPresentOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = IsPresentOp, typename = std::enable_if_t<std::is_same_v<LateInst, IsPresentOp>>>
  IsPresentOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getVal() {
    return (*getODSOperands(0).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class IsPresentOpAdaptor : public IsPresentOpGenericAdaptor<::mlir::ValueRange> {
public:
  using IsPresentOpGenericAdaptor::IsPresentOpGenericAdaptor;
  IsPresentOpAdaptor(IsPresentOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class IsPresentOp : public ::mlir::Op<IsPresentOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::Type>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::OneOperand, ::mlir::OpTrait::OpInvariants, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = IsPresentOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = IsPresentOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_val = 0;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    return {};
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("fir.is_present");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getVal() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(0).begin());
  }

  ::mlir::OpOperand &getValMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type resultType0, ::mlir::Value val);
  static IsPresentOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type resultType0, ::mlir::Value val);
  static IsPresentOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type resultType0, ::mlir::Value val);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value val);
  static IsPresentOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value val);
  static IsPresentOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value val);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static IsPresentOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static IsPresentOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static IsPresentOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static IsPresentOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
public:
};

} // namespace fir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::fir::IsPresentOp)

namespace fir {


//===----------------------------------------------------------------------===//
// ::fir::IterWhileOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class IterWhileOpGenericAdaptorBase {
public:
  struct Properties {
    using finalValueTy = ::mlir::UnitAttr;
    finalValueTy finalValue;

    auto getFinalValue() const {
      auto &propStorage = this->finalValue;
      return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(propStorage);
    }
    void setFinalValue(const ::mlir::UnitAttr &propValue) {
      this->finalValue = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.finalValue == this->finalValue &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  IterWhileOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("fir.iterate_while", odsAttrs.getContext());
  }

  IterWhileOpGenericAdaptorBase(IterWhileOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize);
  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::UnitAttr getFinalValueAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(getProperties().finalValue);
    return attr;
  }

  ::std::optional<bool> getFinalValue();
  ::mlir::Region &getRegion() {
    return *odsRegions[0];
  }

  ::mlir::RegionRange getRegions() {
    return odsRegions;
  }

};

} // namespace detail
template <typename RangeT>
class IterWhileOpGenericAdaptor : public detail::IterWhileOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::IterWhileOpGenericAdaptorBase;
  static constexpr int odsIndex_lowerBound = 0;
  static constexpr int odsIndex_upperBound = 1;
  static constexpr int odsIndex_step = 2;
  static constexpr int odsIndex_iterateIn = 3;
  static constexpr int odsIndex_initArgs = 4;
public:
  IterWhileOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  IterWhileOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : IterWhileOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  IterWhileOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : IterWhileOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  IterWhileOpGenericAdaptor(RangeT values, const IterWhileOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = IterWhileOp, typename = std::enable_if_t<std::is_same_v<LateInst, IterWhileOp>>>
  IterWhileOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getLowerBound() {
    return (*getODSOperands(0).begin());
  }

  ValueT getUpperBound() {
    return (*getODSOperands(1).begin());
  }

  ValueT getStep() {
    return (*getODSOperands(2).begin());
  }

  ValueT getIterateIn() {
    return (*getODSOperands(3).begin());
  }

  RangeT getInitArgs() {
    return getODSOperands(4);
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class IterWhileOpAdaptor : public IterWhileOpGenericAdaptor<::mlir::ValueRange> {
public:
  using IterWhileOpGenericAdaptor::IterWhileOpGenericAdaptor;
  IterWhileOpAdaptor(IterWhileOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class IterWhileOp : public ::mlir::Op<IterWhileOp, ::mlir::OpTrait::OneRegion, ::mlir::OpTrait::VariadicResults, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::AtLeastNOperands<4>::Impl, ::mlir::OpTrait::SingleBlock, ::mlir::OpTrait::SingleBlockImplicitTerminator<ResultOp>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::LoopLikeOpInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::RecursivelySpeculatableImplTrait, ::mlir::OpTrait::HasRecursiveMemoryEffects> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = IterWhileOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = IterWhileOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_lowerBound = 0;
  static constexpr int odsIndex_upperBound = 1;
  static constexpr int odsIndex_step = 2;
  static constexpr int odsIndex_iterateIn = 3;
  static constexpr int odsIndex_initArgs = 4;
  using Properties = FoldAdaptor::Properties;
  using ::mlir::LoopLikeOpInterface::Trait<IterWhileOp>::isDefinedOutsideOfLoop;
  using ::mlir::LoopLikeOpInterface::Trait<IterWhileOp>::moveOutOfLoop;
  using ::mlir::LoopLikeOpInterface::Trait<IterWhileOp>::promoteIfSingleIteration;
  using ::mlir::LoopLikeOpInterface::Trait<IterWhileOp>::getLoopInductionVars;
  using ::mlir::LoopLikeOpInterface::Trait<IterWhileOp>::getLoopLowerBounds;
  using ::mlir::LoopLikeOpInterface::Trait<IterWhileOp>::getLoopSteps;
  using ::mlir::LoopLikeOpInterface::Trait<IterWhileOp>::getLoopUpperBounds;
  using ::mlir::LoopLikeOpInterface::Trait<IterWhileOp>::getInitsMutable;
  using ::mlir::LoopLikeOpInterface::Trait<IterWhileOp>::getRegionIterArgs;
  using ::mlir::LoopLikeOpInterface::Trait<IterWhileOp>::getLoopResults;
  using ::mlir::LoopLikeOpInterface::Trait<IterWhileOp>::replaceWithAdditionalYields;
  using ::mlir::LoopLikeOpInterface::Trait<IterWhileOp>::getStaticTripCount;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("finalValue")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getFinalValueAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getFinalValueAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("fir.iterate_while");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index);
  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::IndexType> getLowerBound() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::IndexType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::IndexType> getUpperBound() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::IndexType>>(*getODSOperands(1).begin());
  }

  ::mlir::TypedValue<::mlir::IndexType> getStep() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::IndexType>>(*getODSOperands(2).begin());
  }

  ::mlir::TypedValue<::mlir::IntegerType> getIterateIn() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*getODSOperands(3).begin());
  }

  ::mlir::Operation::operand_range getInitArgs() {
    return getODSOperands(4);
  }

  ::mlir::OpOperand &getLowerBoundMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getUpperBoundMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getStepMutable() {
    auto range = getODSOperandIndexAndLength(2);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getIterateInMutable() {
    auto range = getODSOperandIndexAndLength(3);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::MutableOperandRange getInitArgsMutable();
  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index);
  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::Operation::result_range getResults() {
    return getODSResults(0);
  }

  ::mlir::Region &getRegion() {
    return (*this)->getRegion(0);
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::UnitAttr getFinalValueAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(getProperties().finalValue);
  }

  ::std::optional<bool> getFinalValue();
  void setFinalValueAttr(::mlir::UnitAttr attr) {
    getProperties().finalValue = attr;
  }

  void setFinalValue(bool attrValue);
  ::mlir::Attribute removeFinalValueAttr() {
      auto attr = getProperties().finalValue;
      getProperties().finalValue = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, mlir::Value lowerBound, mlir::Value upperBound, mlir::Value step, mlir::Value iterate, bool finalCountValue = false, mlir::ValueRange iterArgs = {}, llvm::ArrayRef<mlir::NamedAttribute> attributes = {});
  static IterWhileOp create(::mlir::OpBuilder &builder, ::mlir::Location location, mlir::Value lowerBound, mlir::Value upperBound, mlir::Value step, mlir::Value iterate, bool finalCountValue = false, mlir::ValueRange iterArgs = {}, llvm::ArrayRef<mlir::NamedAttribute> attributes = {});
  static IterWhileOp create(::mlir::ImplicitLocOpBuilder &builder, mlir::Value lowerBound, mlir::Value upperBound, mlir::Value step, mlir::Value iterate, bool finalCountValue = false, mlir::ValueRange iterArgs = {}, llvm::ArrayRef<mlir::NamedAttribute> attributes = {});
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &p);
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  ::llvm::SmallVector<::mlir::Region *> getLoopRegions();
  ::std::optional<::llvm::MutableArrayRef<::mlir::OpOperand>> getYieldedValuesMutable();
  static ::llvm::LogicalResult setPropertiesFromParsedAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
  static constexpr llvm::StringRef getFinalValueAttrNameStr() {
    return "finalValue";
  }
  mlir::Block *getBody() { return &getRegion().front(); }
  mlir::Value getIterateVar() { return getBody()->getArgument(1); }
  mlir::Value getInductionVar() { return getBody()->getArgument(0); }
  mlir::OpBuilder getBodyBuilder() {
    return mlir::OpBuilder(getBody(), std::prev(getBody()->end()));
  }
  mlir::Block::BlockArgListType getRegionIterArgs() {
    return getBody()->getArguments().drop_front();
  }
  mlir::Operation::operand_range getIterOperands() {
    return getOperands().drop_front(getNumControlOperands());
  }
  llvm::MutableArrayRef<mlir::OpOperand> getInitsMutable() {
    return
        getOperation()->getOpOperands().drop_front(getNumControlOperands());
  }

  void setLowerBound(mlir::Value bound) { (*this)->setOperand(0, bound); }
  void setUpperBound(mlir::Value bound) { (*this)->setOperand(1, bound); }
  void setStep(mlir::Value step) { (*this)->setOperand(2, step); }

  /// Number of region arguments for loop-carried values
  unsigned getNumRegionIterArgs() {
    return getBody()->getNumArguments() - 1;
  }
  /// Number of operands controlling the loop
  unsigned getNumControlOperands() { return 3; }
  /// Does the operation hold operands for loop-carried values
  bool hasIterOperands() {
    return (*this)->getNumOperands() > getNumControlOperands();
  }
  /// Get Number of loop-carried values
  unsigned getNumIterOperands() {
    return (*this)->getNumOperands() - getNumControlOperands();
  }

  mlir::BlockArgument iterArgToBlockArg(mlir::Value iterArg);
  void resultToSourceOps(llvm::SmallVectorImpl<mlir::Value> &results,
                         unsigned resultNum);
  mlir::Value blockArgToSourceOp(unsigned blockArgNum);
};

} // namespace fir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::fir::IterWhileOp)

namespace fir {


//===----------------------------------------------------------------------===//
// ::fir::LenParamIndexOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class LenParamIndexOpGenericAdaptorBase {
public:
  struct Properties {
    using field_idTy = ::mlir::StringAttr;
    field_idTy field_id;

    auto getFieldId() const {
      auto &propStorage = this->field_id;
      return ::llvm::cast<::mlir::StringAttr>(propStorage);
    }
    void setFieldId(const ::mlir::StringAttr &propValue) {
      this->field_id = propValue;
    }
    using on_typeTy = ::mlir::TypeAttr;
    on_typeTy on_type;

    auto getOnType() const {
      auto &propStorage = this->on_type;
      return ::llvm::cast<::mlir::TypeAttr>(propStorage);
    }
    void setOnType(const ::mlir::TypeAttr &propValue) {
      this->on_type = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.field_id == this->field_id &&
        rhs.on_type == this->on_type &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  LenParamIndexOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("fir.len_param_index", odsAttrs.getContext());
  }

  LenParamIndexOpGenericAdaptorBase(LenParamIndexOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize);
  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::StringAttr getFieldIdAttr() {
    auto attr = ::llvm::cast<::mlir::StringAttr>(getProperties().field_id);
    return attr;
  }

  ::llvm::StringRef getFieldId();
  ::mlir::TypeAttr getOnTypeAttr() {
    auto attr = ::llvm::cast<::mlir::TypeAttr>(getProperties().on_type);
    return attr;
  }

  ::mlir::Type getOnType();
};

} // namespace detail
template <typename RangeT>
class LenParamIndexOpGenericAdaptor : public detail::LenParamIndexOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::LenParamIndexOpGenericAdaptorBase;
  static constexpr int odsIndex_typeparams = 0;
public:
  LenParamIndexOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  LenParamIndexOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : LenParamIndexOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  LenParamIndexOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : LenParamIndexOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  LenParamIndexOpGenericAdaptor(RangeT values, const LenParamIndexOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = LenParamIndexOp, typename = std::enable_if_t<std::is_same_v<LateInst, LenParamIndexOp>>>
  LenParamIndexOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  RangeT getTypeparams() {
    return getODSOperands(0);
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class LenParamIndexOpAdaptor : public LenParamIndexOpGenericAdaptor<::mlir::ValueRange> {
public:
  using LenParamIndexOpGenericAdaptor::LenParamIndexOpGenericAdaptor;
  LenParamIndexOpAdaptor(LenParamIndexOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class LenParamIndexOp : public ::mlir::Op<LenParamIndexOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::Type>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::VariadicOperands, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = LenParamIndexOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = LenParamIndexOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_typeparams = 0;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("field_id"), ::llvm::StringRef("on_type")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getFieldIdAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getFieldIdAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getOnTypeAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getOnTypeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("fir.len_param_index");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index);
  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::Operation::operand_range getTypeparams() {
    return getODSOperands(0);
  }

  ::mlir::MutableOperandRange getTypeparamsMutable();
  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::StringAttr getFieldIdAttr() {
    return ::llvm::cast<::mlir::StringAttr>(getProperties().field_id);
  }

  ::llvm::StringRef getFieldId();
  ::mlir::TypeAttr getOnTypeAttr() {
    return ::llvm::cast<::mlir::TypeAttr>(getProperties().on_type);
  }

  ::mlir::Type getOnType();
  void setFieldIdAttr(::mlir::StringAttr attr) {
    getProperties().field_id = attr;
  }

  void setFieldId(::llvm::StringRef attrValue);
  void setOnTypeAttr(::mlir::TypeAttr attr) {
    getProperties().on_type = attr;
  }

  void setOnType(::mlir::Type attrValue);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, llvm::StringRef fieldName, mlir::Type recTy, mlir::ValueRange operands = {});
  static LenParamIndexOp create(::mlir::OpBuilder &builder, ::mlir::Location location, llvm::StringRef fieldName, mlir::Type recTy, mlir::ValueRange operands = {});
  static LenParamIndexOp create(::mlir::ImplicitLocOpBuilder &builder, llvm::StringRef fieldName, mlir::Type recTy, mlir::ValueRange operands = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::StringAttr field_id, ::mlir::TypeAttr on_type, ::mlir::ValueRange typeparams);
  static LenParamIndexOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::StringAttr field_id, ::mlir::TypeAttr on_type, ::mlir::ValueRange typeparams);
  static LenParamIndexOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::StringAttr field_id, ::mlir::TypeAttr on_type, ::mlir::ValueRange typeparams);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::StringAttr field_id, ::mlir::TypeAttr on_type, ::mlir::ValueRange typeparams);
  static LenParamIndexOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::StringAttr field_id, ::mlir::TypeAttr on_type, ::mlir::ValueRange typeparams);
  static LenParamIndexOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::StringAttr field_id, ::mlir::TypeAttr on_type, ::mlir::ValueRange typeparams);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::llvm::StringRef field_id, ::mlir::Type on_type, ::mlir::ValueRange typeparams);
  static LenParamIndexOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::llvm::StringRef field_id, ::mlir::Type on_type, ::mlir::ValueRange typeparams);
  static LenParamIndexOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::llvm::StringRef field_id, ::mlir::Type on_type, ::mlir::ValueRange typeparams);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::llvm::StringRef field_id, ::mlir::Type on_type, ::mlir::ValueRange typeparams);
  static LenParamIndexOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::llvm::StringRef field_id, ::mlir::Type on_type, ::mlir::ValueRange typeparams);
  static LenParamIndexOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::llvm::StringRef field_id, ::mlir::Type on_type, ::mlir::ValueRange typeparams);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static LenParamIndexOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static LenParamIndexOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static LenParamIndexOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static LenParamIndexOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &p);
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::llvm::LogicalResult setPropertiesFromParsedAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 2 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
  static constexpr llvm::StringRef getFieldAttrName() { return "field_id"; }
  static constexpr llvm::StringRef getTypeAttrName() { return "on_type"; }
  llvm::StringRef getParamName() { return getFieldId(); }
  llvm::SmallVector<mlir::Attribute> getAttributes();
};

} // namespace fir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::fir::LenParamIndexOp)

namespace fir {


//===----------------------------------------------------------------------===//
// ::fir::LoadOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class LoadOpGenericAdaptorBase {
public:
  struct Properties {
    using accessGroupsTy = ::mlir::ArrayAttr;
    accessGroupsTy accessGroups;

    auto getAccessGroups() const {
      auto &propStorage = this->accessGroups;
      return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(propStorage);
    }
    void setAccessGroups(const ::mlir::ArrayAttr &propValue) {
      this->accessGroups = propValue;
    }
    using nontemporalTy = ::mlir::UnitAttr;
    nontemporalTy nontemporal;

    auto getNontemporal() const {
      auto &propStorage = this->nontemporal;
      return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(propStorage);
    }
    void setNontemporal(const ::mlir::UnitAttr &propValue) {
      this->nontemporal = propValue;
    }
    using tbaaTy = ::mlir::ArrayAttr;
    tbaaTy tbaa;

    auto getTbaa() const {
      auto &propStorage = this->tbaa;
      return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(propStorage);
    }
    void setTbaa(const ::mlir::ArrayAttr &propValue) {
      this->tbaa = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.accessGroups == this->accessGroups &&
        rhs.nontemporal == this->nontemporal &&
        rhs.tbaa == this->tbaa &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  LoadOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("fir.load", odsAttrs.getContext());
  }

  LoadOpGenericAdaptorBase(LoadOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::ArrayAttr getTbaaAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().tbaa);
    return attr;
  }

  ::std::optional< ::mlir::ArrayAttr > getTbaa();
  ::mlir::UnitAttr getNontemporalAttr();
  bool getNontemporal();
  ::mlir::ArrayAttr getAccessGroupsAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().accessGroups);
    return attr;
  }

  ::std::optional< ::mlir::ArrayAttr > getAccessGroups();
};

} // namespace detail
template <typename RangeT>
class LoadOpGenericAdaptor : public detail::LoadOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::LoadOpGenericAdaptorBase;
  static constexpr int odsIndex_memref = 0;
public:
  LoadOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  LoadOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : LoadOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  LoadOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : LoadOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  LoadOpGenericAdaptor(RangeT values, const LoadOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = LoadOp, typename = std::enable_if_t<std::is_same_v<LateInst, LoadOp>>>
  LoadOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getMemref() {
    return (*getODSOperands(0).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class LoadOpAdaptor : public LoadOpGenericAdaptor<::mlir::ValueRange> {
public:
  using LoadOpGenericAdaptor::LoadOpGenericAdaptor;
  LoadOpAdaptor(LoadOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class LoadOp : public ::mlir::Op<LoadOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::Type>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::OneOperand, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::fir::FirAliasTagOpInterface::Trait, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::PromotableMemOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = LoadOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = LoadOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_memref = 0;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("accessGroups"), ::llvm::StringRef("nontemporal"), ::llvm::StringRef("tbaa")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getAccessGroupsAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getAccessGroupsAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getNontemporalAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getNontemporalAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  ::mlir::StringAttr getTbaaAttrName() {
    return getAttributeNameForIndex(2);
  }

  static ::mlir::StringAttr getTbaaAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 2);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("fir.load");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getMemref() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(0).begin());
  }

  ::mlir::OpOperand &getMemrefMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::ArrayAttr getTbaaAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().tbaa);
  }

  ::std::optional< ::mlir::ArrayAttr > getTbaa();
  ::mlir::UnitAttr getNontemporalAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(getProperties().nontemporal);
  }

  bool getNontemporal();
  ::mlir::ArrayAttr getAccessGroupsAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().accessGroups);
  }

  ::std::optional< ::mlir::ArrayAttr > getAccessGroups();
  void setTbaaAttr(::mlir::ArrayAttr attr) {
    getProperties().tbaa = attr;
  }

  void setNontemporalAttr(::mlir::UnitAttr attr) {
    getProperties().nontemporal = attr;
  }

  void setNontemporal(bool attrValue);
  void setAccessGroupsAttr(::mlir::ArrayAttr attr) {
    getProperties().accessGroups = attr;
  }

  ::mlir::Attribute removeTbaaAttr() {
      auto attr = getProperties().tbaa;
      getProperties().tbaa = {};
      return attr;
  }

  ::mlir::Attribute removeNontemporalAttr() {
      auto attr = getProperties().nontemporal;
      getProperties().nontemporal = {};
      return attr;
  }

  ::mlir::Attribute removeAccessGroupsAttr() {
      auto attr = getProperties().accessGroups;
      getProperties().accessGroups = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, mlir::Value refVal);
  static LoadOp create(::mlir::OpBuilder &builder, ::mlir::Location location, mlir::Value refVal);
  static LoadOp create(::mlir::ImplicitLocOpBuilder &builder, mlir::Value refVal);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, mlir::Type resTy, mlir::Value refVal);
  static LoadOp create(::mlir::OpBuilder &builder, ::mlir::Location location, mlir::Type resTy, mlir::Value refVal);
  static LoadOp create(::mlir::ImplicitLocOpBuilder &builder, mlir::Type resTy, mlir::Value refVal);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value memref, /*optional*/::mlir::ArrayAttr tbaa, /*optional*/::mlir::UnitAttr nontemporal, /*optional*/::mlir::ArrayAttr accessGroups);
  static LoadOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value memref, /*optional*/::mlir::ArrayAttr tbaa, /*optional*/::mlir::UnitAttr nontemporal, /*optional*/::mlir::ArrayAttr accessGroups);
  static LoadOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value memref, /*optional*/::mlir::ArrayAttr tbaa, /*optional*/::mlir::UnitAttr nontemporal, /*optional*/::mlir::ArrayAttr accessGroups);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value memref, /*optional*/::mlir::ArrayAttr tbaa, /*optional*/::mlir::UnitAttr nontemporal, /*optional*/::mlir::ArrayAttr accessGroups);
  static LoadOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value memref, /*optional*/::mlir::ArrayAttr tbaa, /*optional*/::mlir::UnitAttr nontemporal, /*optional*/::mlir::ArrayAttr accessGroups);
  static LoadOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value memref, /*optional*/::mlir::ArrayAttr tbaa, /*optional*/::mlir::UnitAttr nontemporal, /*optional*/::mlir::ArrayAttr accessGroups);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value memref, /*optional*/::mlir::ArrayAttr tbaa, /*optional*/bool nontemporal, /*optional*/::mlir::ArrayAttr accessGroups);
  static LoadOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value memref, /*optional*/::mlir::ArrayAttr tbaa, /*optional*/bool nontemporal, /*optional*/::mlir::ArrayAttr accessGroups);
  static LoadOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value memref, /*optional*/::mlir::ArrayAttr tbaa, /*optional*/bool nontemporal, /*optional*/::mlir::ArrayAttr accessGroups);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value memref, /*optional*/::mlir::ArrayAttr tbaa, /*optional*/bool nontemporal, /*optional*/::mlir::ArrayAttr accessGroups);
  static LoadOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value memref, /*optional*/::mlir::ArrayAttr tbaa, /*optional*/bool nontemporal, /*optional*/::mlir::ArrayAttr accessGroups);
  static LoadOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value memref, /*optional*/::mlir::ArrayAttr tbaa, /*optional*/bool nontemporal, /*optional*/::mlir::ArrayAttr accessGroups);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static LoadOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static LoadOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static LoadOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static LoadOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &p);
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
  bool loadsFrom(const ::mlir::MemorySlot &slot);
  bool storesTo(const ::mlir::MemorySlot &slot);
  ::mlir::Value getStored(const ::mlir::MemorySlot &slot, ::mlir::OpBuilder &builder, ::mlir::Value reachingDef, const ::mlir::DataLayout &dataLayout);
  bool canUsesBeRemoved(const ::mlir::MemorySlot &slot, const ::llvm::SmallPtrSetImpl<::mlir::OpOperand *> &blockingUses, ::llvm::SmallVectorImpl<::mlir::OpOperand *> &newBlockingUses, const ::mlir::DataLayout &datalayout);
  ::mlir::DeletionKind removeBlockingUses(const ::mlir::MemorySlot &slot, const ::llvm::SmallPtrSetImpl<mlir::OpOperand *> &blockingUses, ::mlir::OpBuilder &builder, ::mlir::Value reachingDefinition, const ::mlir::DataLayout &dataLayout);
  static ::llvm::LogicalResult setPropertiesFromParsedAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 3 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
  static mlir::ParseResult getElementOf(mlir::Type &ele, mlir::Type ref);
};

} // namespace fir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::fir::LoadOp)

namespace fir {


//===----------------------------------------------------------------------===//
// ::fir::LocalitySpecifierOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class LocalitySpecifierOpGenericAdaptorBase {
public:
  struct Properties {
    using locality_specifier_typeTy = ::fir::LocalitySpecifierTypeAttr;
    locality_specifier_typeTy locality_specifier_type;

    auto getLocalitySpecifierType() const {
      auto &propStorage = this->locality_specifier_type;
      return ::llvm::cast<::fir::LocalitySpecifierTypeAttr>(propStorage);
    }
    void setLocalitySpecifierType(const ::fir::LocalitySpecifierTypeAttr &propValue) {
      this->locality_specifier_type = propValue;
    }
    using sym_nameTy = ::mlir::StringAttr;
    sym_nameTy sym_name;

    auto getSymName() const {
      auto &propStorage = this->sym_name;
      return ::llvm::cast<::mlir::StringAttr>(propStorage);
    }
    void setSymName(const ::mlir::StringAttr &propValue) {
      this->sym_name = propValue;
    }
    using typeTy = ::mlir::TypeAttr;
    typeTy type;

    auto getType() const {
      auto &propStorage = this->type;
      return ::llvm::cast<::mlir::TypeAttr>(propStorage);
    }
    void setType(const ::mlir::TypeAttr &propValue) {
      this->type = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.locality_specifier_type == this->locality_specifier_type &&
        rhs.sym_name == this->sym_name &&
        rhs.type == this->type &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  LocalitySpecifierOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("fir.local", odsAttrs.getContext());
  }

  LocalitySpecifierOpGenericAdaptorBase(LocalitySpecifierOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::StringAttr getSymNameAttr() {
    auto attr = ::llvm::cast<::mlir::StringAttr>(getProperties().sym_name);
    return attr;
  }

  ::llvm::StringRef getSymName();
  ::mlir::TypeAttr getTypeAttr() {
    auto attr = ::llvm::cast<::mlir::TypeAttr>(getProperties().type);
    return attr;
  }

  ::mlir::Type getType();
  ::fir::LocalitySpecifierTypeAttr getLocalitySpecifierTypeAttr() {
    auto attr = ::llvm::cast<::fir::LocalitySpecifierTypeAttr>(getProperties().locality_specifier_type);
    return attr;
  }

  ::fir::LocalitySpecifierType getLocalitySpecifierType();
  ::mlir::Region &getInitRegion() {
    return *odsRegions[0];
  }

  ::mlir::Region &getCopyRegion() {
    return *odsRegions[1];
  }

  ::mlir::Region &getDeallocRegion() {
    return *odsRegions[2];
  }

  ::mlir::RegionRange getRegions() {
    return odsRegions;
  }

};

} // namespace detail
template <typename RangeT>
class LocalitySpecifierOpGenericAdaptor : public detail::LocalitySpecifierOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::LocalitySpecifierOpGenericAdaptorBase;
public:
  LocalitySpecifierOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  LocalitySpecifierOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : LocalitySpecifierOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  LocalitySpecifierOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : LocalitySpecifierOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  LocalitySpecifierOpGenericAdaptor(RangeT values, const LocalitySpecifierOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = LocalitySpecifierOp, typename = std::enable_if_t<std::is_same_v<LateInst, LocalitySpecifierOp>>>
  LocalitySpecifierOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class LocalitySpecifierOpAdaptor : public LocalitySpecifierOpGenericAdaptor<::mlir::ValueRange> {
public:
  using LocalitySpecifierOpGenericAdaptor::LocalitySpecifierOpGenericAdaptor;
  LocalitySpecifierOpAdaptor(LocalitySpecifierOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class LocalitySpecifierOp : public ::mlir::Op<LocalitySpecifierOp, ::mlir::OpTrait::NRegions<3>::Impl, ::mlir::OpTrait::ZeroResults, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::ZeroOperands, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::OpTrait::IsIsolatedFromAbove> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = LocalitySpecifierOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = LocalitySpecifierOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("locality_specifier_type"), ::llvm::StringRef("sym_name"), ::llvm::StringRef("type")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getLocalitySpecifierTypeAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getLocalitySpecifierTypeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getSymNameAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getSymNameAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  ::mlir::StringAttr getTypeAttrName() {
    return getAttributeNameForIndex(2);
  }

  static ::mlir::StringAttr getTypeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 2);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("fir.local");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::Region &getInitRegion() {
    return (*this)->getRegion(0);
  }

  ::mlir::Region &getCopyRegion() {
    return (*this)->getRegion(1);
  }

  ::mlir::Region &getDeallocRegion() {
    return (*this)->getRegion(2);
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::StringAttr getSymNameAttr() {
    return ::llvm::cast<::mlir::StringAttr>(getProperties().sym_name);
  }

  ::llvm::StringRef getSymName();
  ::mlir::TypeAttr getTypeAttr() {
    return ::llvm::cast<::mlir::TypeAttr>(getProperties().type);
  }

  ::mlir::Type getType();
  ::fir::LocalitySpecifierTypeAttr getLocalitySpecifierTypeAttr() {
    return ::llvm::cast<::fir::LocalitySpecifierTypeAttr>(getProperties().locality_specifier_type);
  }

  ::fir::LocalitySpecifierType getLocalitySpecifierType();
  void setSymNameAttr(::mlir::StringAttr attr) {
    getProperties().sym_name = attr;
  }

  void setSymName(::llvm::StringRef attrValue);
  void setTypeAttr(::mlir::TypeAttr attr) {
    getProperties().type = attr;
  }

  void setType(::mlir::Type attrValue);
  void setLocalitySpecifierTypeAttr(::fir::LocalitySpecifierTypeAttr attr) {
    getProperties().locality_specifier_type = attr;
  }

  void setLocalitySpecifierType(::fir::LocalitySpecifierType attrValue);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::StringAttr sym_name, ::mlir::TypeAttr type, ::fir::LocalitySpecifierTypeAttr locality_specifier_type);
  static LocalitySpecifierOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::StringAttr sym_name, ::mlir::TypeAttr type, ::fir::LocalitySpecifierTypeAttr locality_specifier_type);
  static LocalitySpecifierOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::StringAttr sym_name, ::mlir::TypeAttr type, ::fir::LocalitySpecifierTypeAttr locality_specifier_type);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::StringAttr sym_name, ::mlir::TypeAttr type, ::fir::LocalitySpecifierTypeAttr locality_specifier_type);
  static LocalitySpecifierOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::StringAttr sym_name, ::mlir::TypeAttr type, ::fir::LocalitySpecifierTypeAttr locality_specifier_type);
  static LocalitySpecifierOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::StringAttr sym_name, ::mlir::TypeAttr type, ::fir::LocalitySpecifierTypeAttr locality_specifier_type);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::llvm::StringRef sym_name, ::mlir::Type type, ::fir::LocalitySpecifierType locality_specifier_type);
  static LocalitySpecifierOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::llvm::StringRef sym_name, ::mlir::Type type, ::fir::LocalitySpecifierType locality_specifier_type);
  static LocalitySpecifierOp create(::mlir::ImplicitLocOpBuilder &builder, ::llvm::StringRef sym_name, ::mlir::Type type, ::fir::LocalitySpecifierType locality_specifier_type);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::llvm::StringRef sym_name, ::mlir::Type type, ::fir::LocalitySpecifierType locality_specifier_type);
  static LocalitySpecifierOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::llvm::StringRef sym_name, ::mlir::Type type, ::fir::LocalitySpecifierType locality_specifier_type);
  static LocalitySpecifierOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::llvm::StringRef sym_name, ::mlir::Type type, ::fir::LocalitySpecifierType locality_specifier_type);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static LocalitySpecifierOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static LocalitySpecifierOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static LocalitySpecifierOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static LocalitySpecifierOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verifyRegions();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 3 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
  mlir::BlockArgument getInitMoldArg() {
    auto &region = getInitRegion();
    return region.empty() ? nullptr : region.getArgument(0);
  }
  mlir::BlockArgument getInitPrivateArg() {
    auto &region = getInitRegion();
    return region.empty() ? nullptr : region.getArgument(1);
  }

  /// Returns true if the init region might read from the mold argument
  bool initReadsFromMold() {
    mlir::BlockArgument moldArg = getInitMoldArg();
    return moldArg && !moldArg.use_empty();
  }

  /// Get the type for arguments to nested regions. This should
  /// generally be either the same as getType() or some pointer
  /// type (pointing to the type allocated by this op).
  /// This method will return Type{nullptr} if there are no nested
  /// regions.
  mlir::Type getArgType() {
    for (mlir::Region *region : getRegions())
      for (mlir::Type ty : region->getArgumentTypes())
        return ty;
    return nullptr;
  }
};

} // namespace fir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::fir::LocalitySpecifierOp)

namespace fir {


//===----------------------------------------------------------------------===//
// ::fir::MulcOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class MulcOpGenericAdaptorBase {
public:
  struct Properties {
    using fastmathTy = ::mlir::arith::FastMathFlagsAttr;
    fastmathTy fastmath;

    auto getFastmath() const {
      auto &propStorage = this->fastmath;
      return ::llvm::dyn_cast_or_null<::mlir::arith::FastMathFlagsAttr>(propStorage);
    }
    void setFastmath(const ::mlir::arith::FastMathFlagsAttr &propValue) {
      this->fastmath = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.fastmath == this->fastmath &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  MulcOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("fir.mulc", odsAttrs.getContext());
  }

  MulcOpGenericAdaptorBase(MulcOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::arith::FastMathFlagsAttr getFastmathAttr();
  ::mlir::arith::FastMathFlags getFastmath();
};

} // namespace detail
template <typename RangeT>
class MulcOpGenericAdaptor : public detail::MulcOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::MulcOpGenericAdaptorBase;
  static constexpr int odsIndex_lhs = 0;
  static constexpr int odsIndex_rhs = 1;
public:
  MulcOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  MulcOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : MulcOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  MulcOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : MulcOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  MulcOpGenericAdaptor(RangeT values, const MulcOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = MulcOp, typename = std::enable_if_t<std::is_same_v<LateInst, MulcOp>>>
  MulcOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getLhs() {
    return (*getODSOperands(0).begin());
  }

  ValueT getRhs() {
    return (*getODSOperands(1).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class MulcOpAdaptor : public MulcOpGenericAdaptor<::mlir::ValueRange> {
public:
  using MulcOpGenericAdaptor::MulcOpGenericAdaptor;
  MulcOpAdaptor(MulcOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class MulcOp : public ::mlir::Op<MulcOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::Type>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<2>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::OpTrait::IsCommutative, ::mlir::arith::ArithFastMathInterface::Trait, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::OpTrait::SameOperandsAndResultType, ::mlir::InferTypeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = MulcOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = MulcOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_lhs = 0;
  static constexpr int odsIndex_rhs = 1;
  using Properties = FoldAdaptor::Properties;
  using ::mlir::arith::ArithFastMathInterface::Trait<MulcOp>::getFastMathFlagsAttr;
  using ::mlir::arith::ArithFastMathInterface::Trait<MulcOp>::getFastMathAttrName;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("fastmath")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getFastmathAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getFastmathAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("fir.mulc");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getLhs() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::Type> getRhs() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(1).begin());
  }

  ::mlir::OpOperand &getLhsMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getRhsMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getResult() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::arith::FastMathFlagsAttr getFastmathAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::arith::FastMathFlagsAttr>(getProperties().fastmath);
  }

  ::mlir::arith::FastMathFlags getFastmath();
  void setFastmathAttr(::mlir::arith::FastMathFlagsAttr attr) {
    getProperties().fastmath = attr;
  }

  void setFastmath(::mlir::arith::FastMathFlags attrValue);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type result, ::mlir::Value lhs, ::mlir::Value rhs, ::mlir::arith::FastMathFlagsAttr fastmath);
  static MulcOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type result, ::mlir::Value lhs, ::mlir::Value rhs, ::mlir::arith::FastMathFlagsAttr fastmath);
  static MulcOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type result, ::mlir::Value lhs, ::mlir::Value rhs, ::mlir::arith::FastMathFlagsAttr fastmath);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value lhs, ::mlir::Value rhs, ::mlir::arith::FastMathFlagsAttr fastmath);
  static MulcOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value lhs, ::mlir::Value rhs, ::mlir::arith::FastMathFlagsAttr fastmath);
  static MulcOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value lhs, ::mlir::Value rhs, ::mlir::arith::FastMathFlagsAttr fastmath);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value lhs, ::mlir::Value rhs, ::mlir::arith::FastMathFlagsAttr fastmath);
  static MulcOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value lhs, ::mlir::Value rhs, ::mlir::arith::FastMathFlagsAttr fastmath);
  static MulcOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value lhs, ::mlir::Value rhs, ::mlir::arith::FastMathFlagsAttr fastmath);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type result, ::mlir::Value lhs, ::mlir::Value rhs, ::mlir::arith::FastMathFlags fastmath = ::mlir::arith::FastMathFlags::none);
  static MulcOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type result, ::mlir::Value lhs, ::mlir::Value rhs, ::mlir::arith::FastMathFlags fastmath = ::mlir::arith::FastMathFlags::none);
  static MulcOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type result, ::mlir::Value lhs, ::mlir::Value rhs, ::mlir::arith::FastMathFlags fastmath = ::mlir::arith::FastMathFlags::none);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value lhs, ::mlir::Value rhs, ::mlir::arith::FastMathFlags fastmath = ::mlir::arith::FastMathFlags::none);
  static MulcOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value lhs, ::mlir::Value rhs, ::mlir::arith::FastMathFlags fastmath = ::mlir::arith::FastMathFlags::none);
  static MulcOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value lhs, ::mlir::Value rhs, ::mlir::arith::FastMathFlags fastmath = ::mlir::arith::FastMathFlags::none);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value lhs, ::mlir::Value rhs, ::mlir::arith::FastMathFlags fastmath = ::mlir::arith::FastMathFlags::none);
  static MulcOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value lhs, ::mlir::Value rhs, ::mlir::arith::FastMathFlags fastmath = ::mlir::arith::FastMathFlags::none);
  static MulcOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value lhs, ::mlir::Value rhs, ::mlir::arith::FastMathFlags fastmath = ::mlir::arith::FastMathFlags::none);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static MulcOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static MulcOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static MulcOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static MulcOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static MulcOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static MulcOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static MulcOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static MulcOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static void populateDefaultProperties(::mlir::OperationName opName, Properties &properties);
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::llvm::LogicalResult inferReturnTypes(::mlir::MLIRContext *context, ::std::optional<::mlir::Location> location, ::mlir::ValueRange operands, ::mlir::DictionaryAttr attributes, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions, ::llvm::SmallVectorImpl<::mlir::Type>&inferredReturnTypes);
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};

} // namespace fir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::fir::MulcOp)

namespace fir {


//===----------------------------------------------------------------------===//
// ::fir::NegcOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class NegcOpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  NegcOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("fir.negc", odsAttrs.getContext());
  }

  NegcOpGenericAdaptorBase(NegcOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};

} // namespace detail
template <typename RangeT>
class NegcOpGenericAdaptor : public detail::NegcOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::NegcOpGenericAdaptorBase;
  static constexpr int odsIndex_operand = 0;
public:
  NegcOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  NegcOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : NegcOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  NegcOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : NegcOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  NegcOpGenericAdaptor(RangeT values, const NegcOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = NegcOp, typename = std::enable_if_t<std::is_same_v<LateInst, NegcOp>>>
  NegcOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getOperand() {
    return (*getODSOperands(0).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class NegcOpAdaptor : public NegcOpGenericAdaptor<::mlir::ValueRange> {
public:
  using NegcOpGenericAdaptor::NegcOpGenericAdaptor;
  NegcOpAdaptor(NegcOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class NegcOp : public ::mlir::Op<NegcOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::Type>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::OneOperand, ::mlir::OpTrait::OpInvariants, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::OpTrait::SameOperandsAndResultType, ::mlir::InferTypeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = NegcOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = NegcOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_operand = 0;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    return {};
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("fir.negc");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getOperand() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(0).begin());
  }

  ::mlir::OpOperand &getOperandMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getResult() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type result, ::mlir::Value operand);
  static NegcOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type result, ::mlir::Value operand);
  static NegcOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type result, ::mlir::Value operand);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value operand);
  static NegcOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value operand);
  static NegcOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value operand);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value operand);
  static NegcOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value operand);
  static NegcOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value operand);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static NegcOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static NegcOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static NegcOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static NegcOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static NegcOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static NegcOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static NegcOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static NegcOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::llvm::LogicalResult inferReturnTypes(::mlir::MLIRContext *context, ::std::optional<::mlir::Location> location, ::mlir::ValueRange operands, ::mlir::DictionaryAttr attributes, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions, ::llvm::SmallVectorImpl<::mlir::Type>&inferredReturnTypes);
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
public:
};

} // namespace fir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::fir::NegcOp)

namespace fir {


//===----------------------------------------------------------------------===//
// ::fir::NoReassocOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class NoReassocOpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  NoReassocOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("fir.no_reassoc", odsAttrs.getContext());
  }

  NoReassocOpGenericAdaptorBase(NoReassocOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};

} // namespace detail
template <typename RangeT>
class NoReassocOpGenericAdaptor : public detail::NoReassocOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::NoReassocOpGenericAdaptorBase;
  static constexpr int odsIndex_val = 0;
public:
  NoReassocOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  NoReassocOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : NoReassocOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  NoReassocOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : NoReassocOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  NoReassocOpGenericAdaptor(RangeT values, const NoReassocOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = NoReassocOp, typename = std::enable_if_t<std::is_same_v<LateInst, NoReassocOp>>>
  NoReassocOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getVal() {
    return (*getODSOperands(0).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class NoReassocOpAdaptor : public NoReassocOpGenericAdaptor<::mlir::ValueRange> {
public:
  using NoReassocOpGenericAdaptor::NoReassocOpGenericAdaptor;
  NoReassocOpAdaptor(NoReassocOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class NoReassocOp : public ::mlir::Op<NoReassocOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::Type>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::OneOperand, ::mlir::OpTrait::OpInvariants, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::OpTrait::SameOperandsAndResultType, ::mlir::InferTypeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = NoReassocOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = NoReassocOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_val = 0;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    return {};
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("fir.no_reassoc");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getVal() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(0).begin());
  }

  ::mlir::OpOperand &getValMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getRes() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, mlir::Type resultType, mlir::ValueRange operands, llvm::ArrayRef<mlir::NamedAttribute> attributes = {});
  static NoReassocOp create(::mlir::OpBuilder &builder, ::mlir::Location location, mlir::Type resultType, mlir::ValueRange operands, llvm::ArrayRef<mlir::NamedAttribute> attributes = {});
  static NoReassocOp create(::mlir::ImplicitLocOpBuilder &builder, mlir::Type resultType, mlir::ValueRange operands, llvm::ArrayRef<mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type res, ::mlir::Value val);
  static NoReassocOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type res, ::mlir::Value val);
  static NoReassocOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type res, ::mlir::Value val);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value val);
  static NoReassocOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value val);
  static NoReassocOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value val);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value val);
  static NoReassocOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value val);
  static NoReassocOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value val);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static NoReassocOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static NoReassocOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static NoReassocOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static NoReassocOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static NoReassocOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static NoReassocOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static NoReassocOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static NoReassocOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::llvm::LogicalResult inferReturnTypes(::mlir::MLIRContext *context, ::std::optional<::mlir::Location> location, ::mlir::ValueRange operands, ::mlir::DictionaryAttr attributes, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions, ::llvm::SmallVectorImpl<::mlir::Type>&inferredReturnTypes);
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
public:
};

} // namespace fir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::fir::NoReassocOp)

namespace fir {


//===----------------------------------------------------------------------===//
// ::fir::PackArrayOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class PackArrayOpGenericAdaptorBase {
public:
  struct Properties {
    using heuristicsTy = ::fir::PackArrayHeuristicsAttr;
    heuristicsTy heuristics;

    auto getHeuristics() const {
      auto &propStorage = this->heuristics;
      return ::llvm::dyn_cast_or_null<::fir::PackArrayHeuristicsAttr>(propStorage);
    }
    void setHeuristics(const ::fir::PackArrayHeuristicsAttr &propValue) {
      this->heuristics = propValue;
    }
    using innermostTy = ::mlir::UnitAttr;
    innermostTy innermost;

    auto getInnermost() const {
      auto &propStorage = this->innermost;
      return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(propStorage);
    }
    void setInnermost(const ::mlir::UnitAttr &propValue) {
      this->innermost = propValue;
    }
    using is_safeTy = ::mlir::ArrayAttr;
    is_safeTy is_safe;

    auto getIsSafe() const {
      auto &propStorage = this->is_safe;
      return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(propStorage);
    }
    void setIsSafe(const ::mlir::ArrayAttr &propValue) {
      this->is_safe = propValue;
    }
    using max_element_sizeTy = ::mlir::IntegerAttr;
    max_element_sizeTy max_element_size;

    auto getMaxElementSize() const {
      auto &propStorage = this->max_element_size;
      return ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(propStorage);
    }
    void setMaxElementSize(const ::mlir::IntegerAttr &propValue) {
      this->max_element_size = propValue;
    }
    using max_sizeTy = ::mlir::IntegerAttr;
    max_sizeTy max_size;

    auto getMaxSize() const {
      auto &propStorage = this->max_size;
      return ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(propStorage);
    }
    void setMaxSize(const ::mlir::IntegerAttr &propValue) {
      this->max_size = propValue;
    }
    using min_strideTy = ::mlir::IntegerAttr;
    min_strideTy min_stride;

    auto getMinStride() const {
      auto &propStorage = this->min_stride;
      return ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(propStorage);
    }
    void setMinStride(const ::mlir::IntegerAttr &propValue) {
      this->min_stride = propValue;
    }
    using no_copyTy = ::mlir::UnitAttr;
    no_copyTy no_copy;

    auto getNoCopy() const {
      auto &propStorage = this->no_copy;
      return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(propStorage);
    }
    void setNoCopy(const ::mlir::UnitAttr &propValue) {
      this->no_copy = propValue;
    }
    using stackTy = ::mlir::UnitAttr;
    stackTy stack;

    auto getStack() const {
      auto &propStorage = this->stack;
      return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(propStorage);
    }
    void setStack(const ::mlir::UnitAttr &propValue) {
      this->stack = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.heuristics == this->heuristics &&
        rhs.innermost == this->innermost &&
        rhs.is_safe == this->is_safe &&
        rhs.max_element_size == this->max_element_size &&
        rhs.max_size == this->max_size &&
        rhs.min_stride == this->min_stride &&
        rhs.no_copy == this->no_copy &&
        rhs.stack == this->stack &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  PackArrayOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("fir.pack_array", odsAttrs.getContext());
  }

  PackArrayOpGenericAdaptorBase(PackArrayOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize);
  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::UnitAttr getStackAttr();
  bool getStack();
  ::mlir::UnitAttr getInnermostAttr();
  bool getInnermost();
  ::mlir::UnitAttr getNoCopyAttr();
  bool getNoCopy();
  ::mlir::IntegerAttr getMaxSizeAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(getProperties().max_size);
    return attr;
  }

  ::std::optional<uint64_t> getMaxSize();
  ::mlir::IntegerAttr getMaxElementSizeAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(getProperties().max_element_size);
    return attr;
  }

  ::std::optional<uint64_t> getMaxElementSize();
  ::mlir::IntegerAttr getMinStrideAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(getProperties().min_stride);
    return attr;
  }

  ::std::optional<uint64_t> getMinStride();
  ::fir::PackArrayHeuristicsAttr getHeuristicsAttr();
  ::fir::PackArrayHeuristics getHeuristics();
  ::mlir::ArrayAttr getIsSafeAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().is_safe);
    return attr;
  }

  ::std::optional< ::mlir::ArrayAttr > getIsSafe();
};

} // namespace detail
template <typename RangeT>
class PackArrayOpGenericAdaptor : public detail::PackArrayOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::PackArrayOpGenericAdaptorBase;
  static constexpr int odsIndex_array = 0;
  static constexpr int odsIndex_typeparams = 1;
public:
  PackArrayOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  PackArrayOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : PackArrayOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  PackArrayOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : PackArrayOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  PackArrayOpGenericAdaptor(RangeT values, const PackArrayOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = PackArrayOp, typename = std::enable_if_t<std::is_same_v<LateInst, PackArrayOp>>>
  PackArrayOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getArray() {
    return (*getODSOperands(0).begin());
  }

  RangeT getTypeparams() {
    return getODSOperands(1);
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class PackArrayOpAdaptor : public PackArrayOpGenericAdaptor<::mlir::ValueRange> {
public:
  using PackArrayOpGenericAdaptor::PackArrayOpGenericAdaptor;
  PackArrayOpAdaptor(PackArrayOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class PackArrayOp : public ::mlir::Op<PackArrayOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::Type>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::AtLeastNOperands<1>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::InferTypeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = PackArrayOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = PackArrayOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_array = 0;
  static constexpr int odsIndex_typeparams = 1;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("heuristics"), ::llvm::StringRef("innermost"), ::llvm::StringRef("is_safe"), ::llvm::StringRef("max_element_size"), ::llvm::StringRef("max_size"), ::llvm::StringRef("min_stride"), ::llvm::StringRef("no_copy"), ::llvm::StringRef("stack")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getHeuristicsAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getHeuristicsAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getInnermostAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getInnermostAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  ::mlir::StringAttr getIsSafeAttrName() {
    return getAttributeNameForIndex(2);
  }

  static ::mlir::StringAttr getIsSafeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 2);
  }

  ::mlir::StringAttr getMaxElementSizeAttrName() {
    return getAttributeNameForIndex(3);
  }

  static ::mlir::StringAttr getMaxElementSizeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 3);
  }

  ::mlir::StringAttr getMaxSizeAttrName() {
    return getAttributeNameForIndex(4);
  }

  static ::mlir::StringAttr getMaxSizeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 4);
  }

  ::mlir::StringAttr getMinStrideAttrName() {
    return getAttributeNameForIndex(5);
  }

  static ::mlir::StringAttr getMinStrideAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 5);
  }

  ::mlir::StringAttr getNoCopyAttrName() {
    return getAttributeNameForIndex(6);
  }

  static ::mlir::StringAttr getNoCopyAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 6);
  }

  ::mlir::StringAttr getStackAttrName() {
    return getAttributeNameForIndex(7);
  }

  static ::mlir::StringAttr getStackAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 7);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("fir.pack_array");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index);
  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getArray() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(0).begin());
  }

  ::mlir::Operation::operand_range getTypeparams() {
    return getODSOperands(1);
  }

  ::mlir::OpOperand &getArrayMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::MutableOperandRange getTypeparamsMutable();
  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getResult() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::UnitAttr getStackAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(getProperties().stack);
  }

  bool getStack();
  ::mlir::UnitAttr getInnermostAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(getProperties().innermost);
  }

  bool getInnermost();
  ::mlir::UnitAttr getNoCopyAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(getProperties().no_copy);
  }

  bool getNoCopy();
  ::mlir::IntegerAttr getMaxSizeAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(getProperties().max_size);
  }

  ::std::optional<uint64_t> getMaxSize();
  ::mlir::IntegerAttr getMaxElementSizeAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(getProperties().max_element_size);
  }

  ::std::optional<uint64_t> getMaxElementSize();
  ::mlir::IntegerAttr getMinStrideAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(getProperties().min_stride);
  }

  ::std::optional<uint64_t> getMinStride();
  ::fir::PackArrayHeuristicsAttr getHeuristicsAttr() {
    return ::llvm::dyn_cast_or_null<::fir::PackArrayHeuristicsAttr>(getProperties().heuristics);
  }

  ::fir::PackArrayHeuristics getHeuristics();
  ::mlir::ArrayAttr getIsSafeAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().is_safe);
  }

  ::std::optional< ::mlir::ArrayAttr > getIsSafe();
  void setStackAttr(::mlir::UnitAttr attr) {
    getProperties().stack = attr;
  }

  void setStack(bool attrValue);
  void setInnermostAttr(::mlir::UnitAttr attr) {
    getProperties().innermost = attr;
  }

  void setInnermost(bool attrValue);
  void setNoCopyAttr(::mlir::UnitAttr attr) {
    getProperties().no_copy = attr;
  }

  void setNoCopy(bool attrValue);
  void setMaxSizeAttr(::mlir::IntegerAttr attr) {
    getProperties().max_size = attr;
  }

  void setMaxSize(::std::optional<uint64_t> attrValue);
  void setMaxElementSizeAttr(::mlir::IntegerAttr attr) {
    getProperties().max_element_size = attr;
  }

  void setMaxElementSize(::std::optional<uint64_t> attrValue);
  void setMinStrideAttr(::mlir::IntegerAttr attr) {
    getProperties().min_stride = attr;
  }

  void setMinStride(::std::optional<uint64_t> attrValue);
  void setHeuristicsAttr(::fir::PackArrayHeuristicsAttr attr) {
    getProperties().heuristics = attr;
  }

  void setHeuristics(::fir::PackArrayHeuristics attrValue);
  void setIsSafeAttr(::mlir::ArrayAttr attr) {
    getProperties().is_safe = attr;
  }

  ::mlir::Attribute removeStackAttr() {
      auto attr = getProperties().stack;
      getProperties().stack = {};
      return attr;
  }

  ::mlir::Attribute removeInnermostAttr() {
      auto attr = getProperties().innermost;
      getProperties().innermost = {};
      return attr;
  }

  ::mlir::Attribute removeNoCopyAttr() {
      auto attr = getProperties().no_copy;
      getProperties().no_copy = {};
      return attr;
  }

  ::mlir::Attribute removeMaxSizeAttr() {
      auto attr = getProperties().max_size;
      getProperties().max_size = {};
      return attr;
  }

  ::mlir::Attribute removeMaxElementSizeAttr() {
      auto attr = getProperties().max_element_size;
      getProperties().max_element_size = {};
      return attr;
  }

  ::mlir::Attribute removeMinStrideAttr() {
      auto attr = getProperties().min_stride;
      getProperties().min_stride = {};
      return attr;
  }

  ::mlir::Attribute removeIsSafeAttr() {
      auto attr = getProperties().is_safe;
      getProperties().is_safe = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type result, ::mlir::Value array, /*optional*/::mlir::UnitAttr stack, /*optional*/::mlir::UnitAttr innermost, /*optional*/::mlir::UnitAttr no_copy, /*optional*/::mlir::IntegerAttr max_size, /*optional*/::mlir::IntegerAttr max_element_size, /*optional*/::mlir::IntegerAttr min_stride, ::fir::PackArrayHeuristicsAttr heuristics, ::mlir::ValueRange typeparams, /*optional*/::mlir::ArrayAttr is_safe);
  static PackArrayOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type result, ::mlir::Value array, /*optional*/::mlir::UnitAttr stack, /*optional*/::mlir::UnitAttr innermost, /*optional*/::mlir::UnitAttr no_copy, /*optional*/::mlir::IntegerAttr max_size, /*optional*/::mlir::IntegerAttr max_element_size, /*optional*/::mlir::IntegerAttr min_stride, ::fir::PackArrayHeuristicsAttr heuristics, ::mlir::ValueRange typeparams, /*optional*/::mlir::ArrayAttr is_safe);
  static PackArrayOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type result, ::mlir::Value array, /*optional*/::mlir::UnitAttr stack, /*optional*/::mlir::UnitAttr innermost, /*optional*/::mlir::UnitAttr no_copy, /*optional*/::mlir::IntegerAttr max_size, /*optional*/::mlir::IntegerAttr max_element_size, /*optional*/::mlir::IntegerAttr min_stride, ::fir::PackArrayHeuristicsAttr heuristics, ::mlir::ValueRange typeparams, /*optional*/::mlir::ArrayAttr is_safe);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value array, /*optional*/::mlir::UnitAttr stack, /*optional*/::mlir::UnitAttr innermost, /*optional*/::mlir::UnitAttr no_copy, /*optional*/::mlir::IntegerAttr max_size, /*optional*/::mlir::IntegerAttr max_element_size, /*optional*/::mlir::IntegerAttr min_stride, ::fir::PackArrayHeuristicsAttr heuristics, ::mlir::ValueRange typeparams, /*optional*/::mlir::ArrayAttr is_safe);
  static PackArrayOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value array, /*optional*/::mlir::UnitAttr stack, /*optional*/::mlir::UnitAttr innermost, /*optional*/::mlir::UnitAttr no_copy, /*optional*/::mlir::IntegerAttr max_size, /*optional*/::mlir::IntegerAttr max_element_size, /*optional*/::mlir::IntegerAttr min_stride, ::fir::PackArrayHeuristicsAttr heuristics, ::mlir::ValueRange typeparams, /*optional*/::mlir::ArrayAttr is_safe);
  static PackArrayOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value array, /*optional*/::mlir::UnitAttr stack, /*optional*/::mlir::UnitAttr innermost, /*optional*/::mlir::UnitAttr no_copy, /*optional*/::mlir::IntegerAttr max_size, /*optional*/::mlir::IntegerAttr max_element_size, /*optional*/::mlir::IntegerAttr min_stride, ::fir::PackArrayHeuristicsAttr heuristics, ::mlir::ValueRange typeparams, /*optional*/::mlir::ArrayAttr is_safe);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value array, /*optional*/::mlir::UnitAttr stack, /*optional*/::mlir::UnitAttr innermost, /*optional*/::mlir::UnitAttr no_copy, /*optional*/::mlir::IntegerAttr max_size, /*optional*/::mlir::IntegerAttr max_element_size, /*optional*/::mlir::IntegerAttr min_stride, ::fir::PackArrayHeuristicsAttr heuristics, ::mlir::ValueRange typeparams, /*optional*/::mlir::ArrayAttr is_safe);
  static PackArrayOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value array, /*optional*/::mlir::UnitAttr stack, /*optional*/::mlir::UnitAttr innermost, /*optional*/::mlir::UnitAttr no_copy, /*optional*/::mlir::IntegerAttr max_size, /*optional*/::mlir::IntegerAttr max_element_size, /*optional*/::mlir::IntegerAttr min_stride, ::fir::PackArrayHeuristicsAttr heuristics, ::mlir::ValueRange typeparams, /*optional*/::mlir::ArrayAttr is_safe);
  static PackArrayOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value array, /*optional*/::mlir::UnitAttr stack, /*optional*/::mlir::UnitAttr innermost, /*optional*/::mlir::UnitAttr no_copy, /*optional*/::mlir::IntegerAttr max_size, /*optional*/::mlir::IntegerAttr max_element_size, /*optional*/::mlir::IntegerAttr min_stride, ::fir::PackArrayHeuristicsAttr heuristics, ::mlir::ValueRange typeparams, /*optional*/::mlir::ArrayAttr is_safe);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type result, ::mlir::Value array, /*optional*/bool stack, /*optional*/bool innermost, /*optional*/bool no_copy, /*optional*/::mlir::IntegerAttr max_size, /*optional*/::mlir::IntegerAttr max_element_size, /*optional*/::mlir::IntegerAttr min_stride, ::fir::PackArrayHeuristics heuristics, ::mlir::ValueRange typeparams, /*optional*/::mlir::ArrayAttr is_safe);
  static PackArrayOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type result, ::mlir::Value array, /*optional*/bool stack, /*optional*/bool innermost, /*optional*/bool no_copy, /*optional*/::mlir::IntegerAttr max_size, /*optional*/::mlir::IntegerAttr max_element_size, /*optional*/::mlir::IntegerAttr min_stride, ::fir::PackArrayHeuristics heuristics, ::mlir::ValueRange typeparams, /*optional*/::mlir::ArrayAttr is_safe);
  static PackArrayOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type result, ::mlir::Value array, /*optional*/bool stack, /*optional*/bool innermost, /*optional*/bool no_copy, /*optional*/::mlir::IntegerAttr max_size, /*optional*/::mlir::IntegerAttr max_element_size, /*optional*/::mlir::IntegerAttr min_stride, ::fir::PackArrayHeuristics heuristics, ::mlir::ValueRange typeparams, /*optional*/::mlir::ArrayAttr is_safe);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value array, /*optional*/bool stack, /*optional*/bool innermost, /*optional*/bool no_copy, /*optional*/::mlir::IntegerAttr max_size, /*optional*/::mlir::IntegerAttr max_element_size, /*optional*/::mlir::IntegerAttr min_stride, ::fir::PackArrayHeuristics heuristics, ::mlir::ValueRange typeparams, /*optional*/::mlir::ArrayAttr is_safe);
  static PackArrayOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value array, /*optional*/bool stack, /*optional*/bool innermost, /*optional*/bool no_copy, /*optional*/::mlir::IntegerAttr max_size, /*optional*/::mlir::IntegerAttr max_element_size, /*optional*/::mlir::IntegerAttr min_stride, ::fir::PackArrayHeuristics heuristics, ::mlir::ValueRange typeparams, /*optional*/::mlir::ArrayAttr is_safe);
  static PackArrayOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value array, /*optional*/bool stack, /*optional*/bool innermost, /*optional*/bool no_copy, /*optional*/::mlir::IntegerAttr max_size, /*optional*/::mlir::IntegerAttr max_element_size, /*optional*/::mlir::IntegerAttr min_stride, ::fir::PackArrayHeuristics heuristics, ::mlir::ValueRange typeparams, /*optional*/::mlir::ArrayAttr is_safe);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value array, /*optional*/bool stack, /*optional*/bool innermost, /*optional*/bool no_copy, /*optional*/::mlir::IntegerAttr max_size, /*optional*/::mlir::IntegerAttr max_element_size, /*optional*/::mlir::IntegerAttr min_stride, ::fir::PackArrayHeuristics heuristics, ::mlir::ValueRange typeparams, /*optional*/::mlir::ArrayAttr is_safe);
  static PackArrayOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value array, /*optional*/bool stack, /*optional*/bool innermost, /*optional*/bool no_copy, /*optional*/::mlir::IntegerAttr max_size, /*optional*/::mlir::IntegerAttr max_element_size, /*optional*/::mlir::IntegerAttr min_stride, ::fir::PackArrayHeuristics heuristics, ::mlir::ValueRange typeparams, /*optional*/::mlir::ArrayAttr is_safe);
  static PackArrayOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value array, /*optional*/bool stack, /*optional*/bool innermost, /*optional*/bool no_copy, /*optional*/::mlir::IntegerAttr max_size, /*optional*/::mlir::IntegerAttr max_element_size, /*optional*/::mlir::IntegerAttr min_stride, ::fir::PackArrayHeuristics heuristics, ::mlir::ValueRange typeparams, /*optional*/::mlir::ArrayAttr is_safe);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static PackArrayOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static PackArrayOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static PackArrayOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static PackArrayOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static PackArrayOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static PackArrayOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static PackArrayOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static PackArrayOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static void populateDefaultProperties(::mlir::OperationName opName, Properties &properties);
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  static ::llvm::LogicalResult inferReturnTypes(::mlir::MLIRContext *context, ::std::optional<::mlir::Location> location, ::mlir::ValueRange operands, ::mlir::DictionaryAttr attributes, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions, ::llvm::SmallVectorImpl<::mlir::Type>&inferredReturnTypes);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 8 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};

} // namespace fir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::fir::PackArrayOp)

namespace fir {


//===----------------------------------------------------------------------===//
// ::fir::PrefetchOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class PrefetchOpGenericAdaptorBase {
public:
  struct Properties {
    using cacheTypeTy = ::mlir::UnitAttr;
    cacheTypeTy cacheType;

    auto getCacheType() const {
      auto &propStorage = this->cacheType;
      return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(propStorage);
    }
    void setCacheType(const ::mlir::UnitAttr &propValue) {
      this->cacheType = propValue;
    }
    using localityHintTy = ::mlir::IntegerAttr;
    localityHintTy localityHint;

    auto getLocalityHint() const {
      auto &propStorage = this->localityHint;
      return ::llvm::cast<::mlir::IntegerAttr>(propStorage);
    }
    void setLocalityHint(const ::mlir::IntegerAttr &propValue) {
      this->localityHint = propValue;
    }
    using rwTy = ::mlir::UnitAttr;
    rwTy rw;

    auto getRw() const {
      auto &propStorage = this->rw;
      return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(propStorage);
    }
    void setRw(const ::mlir::UnitAttr &propValue) {
      this->rw = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.cacheType == this->cacheType &&
        rhs.localityHint == this->localityHint &&
        rhs.rw == this->rw &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  PrefetchOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("fir.prefetch", odsAttrs.getContext());
  }

  PrefetchOpGenericAdaptorBase(PrefetchOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::UnitAttr getRwAttr();
  bool getRw();
  ::mlir::IntegerAttr getLocalityHintAttr() {
    auto attr = ::llvm::cast<::mlir::IntegerAttr>(getProperties().localityHint);
    return attr;
  }

  uint32_t getLocalityHint();
  ::mlir::UnitAttr getCacheTypeAttr();
  bool getCacheType();
};

} // namespace detail
template <typename RangeT>
class PrefetchOpGenericAdaptor : public detail::PrefetchOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::PrefetchOpGenericAdaptorBase;
  static constexpr int odsIndex_memref = 0;
public:
  PrefetchOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  PrefetchOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : PrefetchOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  PrefetchOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : PrefetchOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  PrefetchOpGenericAdaptor(RangeT values, const PrefetchOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = PrefetchOp, typename = std::enable_if_t<std::is_same_v<LateInst, PrefetchOp>>>
  PrefetchOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getMemref() {
    return (*getODSOperands(0).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class PrefetchOpAdaptor : public PrefetchOpGenericAdaptor<::mlir::ValueRange> {
public:
  using PrefetchOpGenericAdaptor::PrefetchOpGenericAdaptor;
  PrefetchOpAdaptor(PrefetchOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class PrefetchOp : public ::mlir::Op<PrefetchOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::ZeroResults, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::OneOperand, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = PrefetchOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = PrefetchOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_memref = 0;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("cacheType"), ::llvm::StringRef("localityHint"), ::llvm::StringRef("rw")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getCacheTypeAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getCacheTypeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getLocalityHintAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getLocalityHintAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  ::mlir::StringAttr getRwAttrName() {
    return getAttributeNameForIndex(2);
  }

  static ::mlir::StringAttr getRwAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 2);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("fir.prefetch");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getMemref() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(0).begin());
  }

  ::mlir::OpOperand &getMemrefMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::UnitAttr getRwAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(getProperties().rw);
  }

  bool getRw();
  ::mlir::IntegerAttr getLocalityHintAttr() {
    return ::llvm::cast<::mlir::IntegerAttr>(getProperties().localityHint);
  }

  uint32_t getLocalityHint();
  ::mlir::UnitAttr getCacheTypeAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(getProperties().cacheType);
  }

  bool getCacheType();
  void setRwAttr(::mlir::UnitAttr attr) {
    getProperties().rw = attr;
  }

  void setRw(bool attrValue);
  void setLocalityHintAttr(::mlir::IntegerAttr attr) {
    getProperties().localityHint = attr;
  }

  void setLocalityHint(uint32_t attrValue);
  void setCacheTypeAttr(::mlir::UnitAttr attr) {
    getProperties().cacheType = attr;
  }

  void setCacheType(bool attrValue);
  ::mlir::Attribute removeRwAttr() {
      auto attr = getProperties().rw;
      getProperties().rw = {};
      return attr;
  }

  ::mlir::Attribute removeCacheTypeAttr() {
      auto attr = getProperties().cacheType;
      getProperties().cacheType = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value memref, /*optional*/::mlir::UnitAttr rw, ::mlir::IntegerAttr localityHint, /*optional*/::mlir::UnitAttr cacheType = nullptr);
  static PrefetchOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value memref, /*optional*/::mlir::UnitAttr rw, ::mlir::IntegerAttr localityHint, /*optional*/::mlir::UnitAttr cacheType = nullptr);
  static PrefetchOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value memref, /*optional*/::mlir::UnitAttr rw, ::mlir::IntegerAttr localityHint, /*optional*/::mlir::UnitAttr cacheType = nullptr);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value memref, /*optional*/::mlir::UnitAttr rw, ::mlir::IntegerAttr localityHint, /*optional*/::mlir::UnitAttr cacheType = nullptr);
  static PrefetchOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value memref, /*optional*/::mlir::UnitAttr rw, ::mlir::IntegerAttr localityHint, /*optional*/::mlir::UnitAttr cacheType = nullptr);
  static PrefetchOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value memref, /*optional*/::mlir::UnitAttr rw, ::mlir::IntegerAttr localityHint, /*optional*/::mlir::UnitAttr cacheType = nullptr);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value memref, /*optional*/bool rw, uint32_t localityHint, /*optional*/bool cacheType = false);
  static PrefetchOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value memref, /*optional*/bool rw, uint32_t localityHint, /*optional*/bool cacheType = false);
  static PrefetchOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value memref, /*optional*/bool rw, uint32_t localityHint, /*optional*/bool cacheType = false);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value memref, /*optional*/bool rw, uint32_t localityHint, /*optional*/bool cacheType = false);
  static PrefetchOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value memref, /*optional*/bool rw, uint32_t localityHint, /*optional*/bool cacheType = false);
  static PrefetchOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value memref, /*optional*/bool rw, uint32_t localityHint, /*optional*/bool cacheType = false);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static PrefetchOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static PrefetchOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static PrefetchOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static PrefetchOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &p);
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::llvm::LogicalResult setPropertiesFromParsedAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 3 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};

} // namespace fir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::fir::PrefetchOp)

namespace fir {


//===----------------------------------------------------------------------===//
// ::fir::ReboxAssumedRankOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class ReboxAssumedRankOpGenericAdaptorBase {
public:
  struct Properties {
    using lbs_modifierTy = ::fir::LowerBoundModifierAttributeAttr;
    lbs_modifierTy lbs_modifier;

    auto getLbsModifier() const {
      auto &propStorage = this->lbs_modifier;
      return ::llvm::cast<::fir::LowerBoundModifierAttributeAttr>(propStorage);
    }
    void setLbsModifier(const ::fir::LowerBoundModifierAttributeAttr &propValue) {
      this->lbs_modifier = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.lbs_modifier == this->lbs_modifier &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  ReboxAssumedRankOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("fir.rebox_assumed_rank", odsAttrs.getContext());
  }

  ReboxAssumedRankOpGenericAdaptorBase(ReboxAssumedRankOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::fir::LowerBoundModifierAttributeAttr getLbsModifierAttr() {
    auto attr = ::llvm::cast<::fir::LowerBoundModifierAttributeAttr>(getProperties().lbs_modifier);
    return attr;
  }

  ::fir::LowerBoundModifierAttribute getLbsModifier();
};

} // namespace detail
template <typename RangeT>
class ReboxAssumedRankOpGenericAdaptor : public detail::ReboxAssumedRankOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::ReboxAssumedRankOpGenericAdaptorBase;
  static constexpr int odsIndex_box = 0;
public:
  ReboxAssumedRankOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  ReboxAssumedRankOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : ReboxAssumedRankOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  ReboxAssumedRankOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : ReboxAssumedRankOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  ReboxAssumedRankOpGenericAdaptor(RangeT values, const ReboxAssumedRankOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = ReboxAssumedRankOp, typename = std::enable_if_t<std::is_same_v<LateInst, ReboxAssumedRankOp>>>
  ReboxAssumedRankOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getBox() {
    return (*getODSOperands(0).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class ReboxAssumedRankOpAdaptor : public ReboxAssumedRankOpGenericAdaptor<::mlir::ValueRange> {
public:
  using ReboxAssumedRankOpGenericAdaptor::ReboxAssumedRankOpGenericAdaptor;
  ReboxAssumedRankOpAdaptor(ReboxAssumedRankOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class ReboxAssumedRankOp : public ::mlir::Op<ReboxAssumedRankOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::Type>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::OneOperand, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = ReboxAssumedRankOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = ReboxAssumedRankOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_box = 0;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("lbs_modifier")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getLbsModifierAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getLbsModifierAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("fir.rebox_assumed_rank");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getBox() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(0).begin());
  }

  ::mlir::OpOperand &getBoxMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::fir::LowerBoundModifierAttributeAttr getLbsModifierAttr() {
    return ::llvm::cast<::fir::LowerBoundModifierAttributeAttr>(getProperties().lbs_modifier);
  }

  ::fir::LowerBoundModifierAttribute getLbsModifier();
  void setLbsModifierAttr(::fir::LowerBoundModifierAttributeAttr attr) {
    getProperties().lbs_modifier = attr;
  }

  void setLbsModifier(::fir::LowerBoundModifierAttribute attrValue);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type resultType0, ::mlir::Value box, ::fir::LowerBoundModifierAttributeAttr lbs_modifier);
  static ReboxAssumedRankOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type resultType0, ::mlir::Value box, ::fir::LowerBoundModifierAttributeAttr lbs_modifier);
  static ReboxAssumedRankOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type resultType0, ::mlir::Value box, ::fir::LowerBoundModifierAttributeAttr lbs_modifier);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value box, ::fir::LowerBoundModifierAttributeAttr lbs_modifier);
  static ReboxAssumedRankOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value box, ::fir::LowerBoundModifierAttributeAttr lbs_modifier);
  static ReboxAssumedRankOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value box, ::fir::LowerBoundModifierAttributeAttr lbs_modifier);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type resultType0, ::mlir::Value box, ::fir::LowerBoundModifierAttribute lbs_modifier);
  static ReboxAssumedRankOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type resultType0, ::mlir::Value box, ::fir::LowerBoundModifierAttribute lbs_modifier);
  static ReboxAssumedRankOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type resultType0, ::mlir::Value box, ::fir::LowerBoundModifierAttribute lbs_modifier);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value box, ::fir::LowerBoundModifierAttribute lbs_modifier);
  static ReboxAssumedRankOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value box, ::fir::LowerBoundModifierAttribute lbs_modifier);
  static ReboxAssumedRankOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value box, ::fir::LowerBoundModifierAttribute lbs_modifier);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static ReboxAssumedRankOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static ReboxAssumedRankOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ReboxAssumedRankOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ReboxAssumedRankOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};

} // namespace fir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::fir::ReboxAssumedRankOp)

namespace fir {


//===----------------------------------------------------------------------===//
// ::fir::ReboxOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class ReboxOpGenericAdaptorBase {
public:
  struct Properties {
    using operandSegmentSizesTy = std::array<int32_t, 3>;
    operandSegmentSizesTy operandSegmentSizes;
    ::llvm::ArrayRef<int32_t> getOperandSegmentSizes() const {
      auto &propStorage = this->operandSegmentSizes;
      return propStorage;
    }
    void setOperandSegmentSizes(::llvm::ArrayRef<int32_t> propValue) {
      auto &propStorage = this->operandSegmentSizes;
      ::llvm::copy(propValue, propStorage.begin());
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.operandSegmentSizes == this->operandSegmentSizes &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  ReboxOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("fir.rebox", odsAttrs.getContext());
  }

  ReboxOpGenericAdaptorBase(ReboxOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize);
  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};

} // namespace detail
template <typename RangeT>
class ReboxOpGenericAdaptor : public detail::ReboxOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::ReboxOpGenericAdaptorBase;
  static constexpr int odsIndex_box = 0;
  static constexpr int odsIndex_shape = 1;
  static constexpr int odsIndex_slice = 2;
public:
  ReboxOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  ReboxOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : ReboxOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  ReboxOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs) : ReboxOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  ReboxOpGenericAdaptor(RangeT values, const ReboxOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = ReboxOp, typename = std::enable_if_t<std::is_same_v<LateInst, ReboxOp>>>
  ReboxOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getBox() {
    return (*getODSOperands(0).begin());
  }

  ValueT getShape() {
    auto operands = getODSOperands(1);
    return operands.empty() ? ValueT{} : (*operands.begin());
  }

  ValueT getSlice() {
    auto operands = getODSOperands(2);
    return operands.empty() ? ValueT{} : (*operands.begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class ReboxOpAdaptor : public ReboxOpGenericAdaptor<::mlir::ValueRange> {
public:
  using ReboxOpGenericAdaptor::ReboxOpGenericAdaptor;
  ReboxOpAdaptor(ReboxOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class ReboxOp : public ::mlir::Op<ReboxOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::Type>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::AtLeastNOperands<1>::Impl, ::mlir::OpTrait::AttrSizedOperandSegments, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::MemoryEffectOpInterface::Trait, ::fir::FortranObjectViewOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = ReboxOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = ReboxOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_box = 0;
  static constexpr int odsIndex_shape = 1;
  static constexpr int odsIndex_slice = 2;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("operandSegmentSizes")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getOperandSegmentSizesAttrName() {
   return (*this)->getName().getAttributeNames().back();
  }

  static ::mlir::StringAttr getOperandSegmentSizesAttrName(::mlir::OperationName name) {
   return name.getAttributeNames().back();
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("fir.rebox");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index);
  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getBox() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::Type> getShape() {
    auto operands = getODSOperands(1);
    return operands.empty() ? ::mlir::TypedValue<::mlir::Type>{} : ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*operands.begin());
  }

  ::mlir::TypedValue<::fir::SliceType> getSlice() {
    auto operands = getODSOperands(2);
    return operands.empty() ? ::mlir::TypedValue<::fir::SliceType>{} : ::llvm::cast<::mlir::TypedValue<::fir::SliceType>>(*operands.begin());
  }

  ::mlir::OpOperand &getBoxMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::MutableOperandRange getShapeMutable();
  ::mlir::MutableOperandRange getSliceMutable();
  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type resultType0, ::mlir::Value box, /*optional*/::mlir::Value shape, /*optional*/::mlir::Value slice);
  static ReboxOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type resultType0, ::mlir::Value box, /*optional*/::mlir::Value shape, /*optional*/::mlir::Value slice);
  static ReboxOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type resultType0, ::mlir::Value box, /*optional*/::mlir::Value shape, /*optional*/::mlir::Value slice);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value box, /*optional*/::mlir::Value shape, /*optional*/::mlir::Value slice);
  static ReboxOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value box, /*optional*/::mlir::Value shape, /*optional*/::mlir::Value slice);
  static ReboxOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value box, /*optional*/::mlir::Value shape, /*optional*/::mlir::Value slice);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static ReboxOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static ReboxOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ReboxOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ReboxOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    return {};
  }

public:
  // FortranObjectViewOpInterface methods:
  mlir::Value getViewSource(mlir::OpResult) { return getBox(); }
  std::optional<std::int64_t> getViewOffset(mlir::OpResult);
};

} // namespace fir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::fir::ReboxOp)

namespace fir {


//===----------------------------------------------------------------------===//
// ::fir::ResultOp declarations
//===----------------------------------------------------------------------===//

namespace detail {

class ResultOpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  ResultOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("fir.result", odsAttrs.getContext());
  }

  ResultOpGenericAdaptorBase(ResultOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize);
  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};

} // namespace detail
template <typename RangeT>
class ResultOpGenericAdaptor : public detail::ResultOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::ResultOpGenericAdaptorBase;
  static constexpr int odsIndex_results = 0;
public:
  ResultOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  ResultOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : ResultOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  ResultOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : ResultOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  ResultOpGenericAdaptor(RangeT values, const ResultOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = ResultOp, typename = std::enable_if_t<std::is_same_v<LateInst, ResultOp>>>
  ResultOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  RangeT getResults() {
    return getODSOperands(0);
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class ResultOpAdaptor : public ResultOpGenericAdaptor<::mlir::ValueRange> {
public:
  using ResultOpGenericAdaptor::ResultOpGenericAdaptor;
  ResultOpAdaptor(ResultOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class ResultOp : public ::mlir::Op<ResultOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::ZeroResults, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::VariadicOperands, ::mlir::OpTrait::HasParent<IfOp, DoLoopOp, IterWhileOp>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::RegionBranchTerminatorOpInterface::Trait, ::mlir::OpTrait::ReturnLike, ::mlir::OpTrait::IsTerminator> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = ResultOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = ResultOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_results = 0;
  using Properties = FoldAdaptor::Properties;
  using ::mlir::RegionBranchTerminatorOpInterface::Trait<ResultOp>::getSuccessorRegions;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    return {};
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("fir.result");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index);
  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::Operation::operand_range getResults() {
    return getODSOperands(0);
  }

  ::mlir::MutableOperandRange getResultsMutable();
  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getO