/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.nc.utils;

import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.api.resource.LoadableResource;
import org.flywaydb.core.internal.util.StringUtils;
import org.flywaydb.nc.executors.Executor;

public class ErrorUtils {
    private static final Log LOG = LogFactory.getLog(ErrorUtils.class);

    public static <T> String calculateErrorMessage(String title, LoadableResource loadableResource, String physicalLocation, Executor<T> executor, T executionUnit, String message) {
        String underline = StringUtils.trimOrPad((String)"", (int)title.length(), (char)'-');
        StringBuilder messageBuilder = new StringBuilder().append(title).append("\n").append(underline).append("\n");
        if (message != null) {
            messageBuilder.append(message);
        }
        if (loadableResource != null) {
            messageBuilder.append("Location   : ").append(loadableResource.getAbsolutePath()).append(" (").append(loadableResource.getAbsolutePathOnDisk()).append(")\n");
        } else {
            messageBuilder.append("Location   : ").append(physicalLocation);
        }
        if (executionUnit != null && executor != null) {
            executor.appendErrorMessage(executionUnit, messageBuilder, LOG.isDebugEnabled());
        }
        return messageBuilder.toString();
    }
}

