/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.client.sqlengine.dsiext.dataengine.metadata;

import com.databricks.client.dsi.core.impl.DSIDriver;
import com.databricks.client.dsi.dataengine.filters.IFilter;
import com.databricks.client.dsi.dataengine.filters.StringFilter;
import com.databricks.client.dsi.dataengine.interfaces.IMetadataSource;
import com.databricks.client.dsi.dataengine.utilities.DSITypeUtilities;
import com.databricks.client.dsi.dataengine.utilities.DataWrapper;
import com.databricks.client.dsi.dataengine.utilities.MetadataSourceColumnTag;
import com.databricks.client.dsi.utilities.DSIMessageKey;
import com.databricks.client.dsi.utilities.NullSafeStringComparator;
import com.databricks.client.sqlengine.dsiext.dataengine.IMetadataHelper;
import com.databricks.client.sqlengine.dsiext.dataengine.Identifier;
import com.databricks.client.support.ILogger;
import com.databricks.client.support.LogUtilities;
import com.databricks.client.support.exceptions.ErrorException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;

public class DSIExtSchemasOnlyMetadataSource
implements IMetadataSource {
    private ILogger m_logger;
    private IMetadataHelper m_metadataHelper;
    private List<String> m_schemaNames;
    private int m_currRow = -1;
    private IFilter m_catalogFilter;

    @Deprecated
    public DSIExtSchemasOnlyMetadataSource(ILogger iLogger, Map<MetadataSourceColumnTag, String> map, IMetadataHelper iMetadataHelper) {
        this(iLogger, iMetadataHelper, DSIExtSchemasOnlyMetadataSource.createFilter(map));
    }

    public DSIExtSchemasOnlyMetadataSource(ILogger iLogger, IMetadataHelper iMetadataHelper, List<IFilter> list) {
        LogUtilities.logFunctionEntrance(iLogger, new Object[0]);
        this.m_logger = iLogger;
        this.m_metadataHelper = iMetadataHelper;
        for (IFilter iFilter : list) {
            if (MetadataSourceColumnTag.CATALOG_NAME != iFilter.getColumnTag()) continue;
            this.m_catalogFilter = iFilter;
        }
        this.findCatalogSchemas();
    }

    @Override
    public void close() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
    }

    @Override
    public void closeCursor() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
    }

    @Override
    public boolean getMetadata(MetadataSourceColumnTag metadataSourceColumnTag, long l, long l2, DataWrapper dataWrapper) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[]{metadataSourceColumnTag, l, l2});
        switch (metadataSourceColumnTag) {
            case SCHEMA_NAME: {
                return DSITypeUtilities.outputVarCharStringData(this.m_schemaNames.get(this.m_currRow), dataWrapper, l, l2);
            }
        }
        throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.INVALID_METADATA_COLUMN_TAG.name(), metadataSourceColumnTag.name());
    }

    @Override
    public boolean hasMoreRows() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        return this.m_currRow < this.m_schemaNames.size() - 1;
    }

    @Override
    public boolean moveToNextRow() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        if (this.m_currRow < this.m_schemaNames.size()) {
            ++this.m_currRow;
        }
        return this.m_currRow < this.m_schemaNames.size();
    }

    private void findCatalogSchemas() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        Identifier identifier = new Identifier();
        TreeSet<String> treeSet = new TreeSet<String>(NullSafeStringComparator.INSTANCE);
        while (this.m_metadataHelper.getNextTable(identifier)) {
            if (!this.filter(this.m_catalogFilter, identifier.getCatalog())) continue;
            treeSet.add(new String(identifier.getSchema()));
        }
        this.m_schemaNames = Collections.unmodifiableList(new ArrayList<String>(treeSet));
    }

    private boolean filter(IFilter iFilter, String string) {
        if (null == iFilter) {
            return true;
        }
        DataWrapper dataWrapper = new DataWrapper();
        dataWrapper.setChar(string);
        return iFilter.filter(dataWrapper);
    }

    private static List<IFilter> createFilter(Map<MetadataSourceColumnTag, String> map) {
        ArrayList<IFilter> arrayList = new ArrayList<IFilter>();
        if (map.containsKey((Object)MetadataSourceColumnTag.CATALOG_NAME)) {
            arrayList.add(new StringFilter(MetadataSourceColumnTag.CATALOG_NAME, map.get((Object)MetadataSourceColumnTag.CATALOG_NAME), true));
        }
        return arrayList;
    }
}

