/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.community.database.duckdb;

import java.sql.SQLException;
import java.util.List;
import org.flywaydb.community.database.duckdb.DuckDBDatabase;
import org.flywaydb.community.database.duckdb.DuckDBTable;
import org.flywaydb.core.internal.database.base.Database;
import org.flywaydb.core.internal.database.base.Schema;
import org.flywaydb.core.internal.jdbc.JdbcTemplate;

public class DuckDBSchema
extends Schema<DuckDBDatabase, DuckDBTable> {
    public DuckDBSchema(JdbcTemplate jdbcTemplate, DuckDBDatabase database, String name) {
        super(jdbcTemplate, (Database)database, name);
    }

    protected boolean doExists() throws SQLException {
        String countSchemasWithName = "SELECT COUNT(*) FROM information_schema.schemata WHERE schema_name = ?";
        return this.jdbcTemplate.queryForInt("SELECT COUNT(*) FROM information_schema.schemata WHERE schema_name = ?", new String[]{this.name}) > 0;
    }

    protected boolean doEmpty() throws SQLException {
        String countTablesInSchema = "SELECT count(*) from information_schema.tables WHERE table_schema = ?";
        return this.jdbcTemplate.queryForInt("SELECT count(*) from information_schema.tables WHERE table_schema = ?", new String[]{this.name}) == 0;
    }

    protected void doCreate() throws SQLException {
        this.jdbcTemplate.execute("CREATE SCHEMA " + ((DuckDBDatabase)this.database).quote(new String[]{this.name}), new Object[0]);
    }

    protected void doDrop() throws SQLException {
        this.jdbcTemplate.execute("DROP SCHEMA " + ((DuckDBDatabase)this.database).quote(new String[]{this.name}), new Object[0]);
    }

    protected void doClean() throws SQLException {
        this.dropAll("MACRO", this.getAllMacros());
        this.dropAll("SEQUENCE", this.getAllObjectsNames("sequence_name", "duckdb_sequences()"));
        this.dropAll("VIEW", this.getAllViews());
        this.dropAll("TABLE", this.getAllTablesNames());
    }

    protected DuckDBTable[] doAllTables() throws SQLException {
        return this.getAllTablesNames().stream().map(this::getTable).toList().toArray(new DuckDBTable[0]);
    }

    public DuckDBTable getTable(String tableName) {
        return new DuckDBTable(this.jdbcTemplate, (DuckDBDatabase)this.database, this, tableName);
    }

    private void dropAll(String objectType, List<String> objectsNames) throws SQLException {
        for (String objectName : objectsNames) {
            this.jdbcTemplate.execute("DROP %s %s.%s CASCADE".formatted(objectType, ((DuckDBDatabase)this.database).quote(new String[]{this.name}), ((DuckDBDatabase)this.database).quote(new String[]{objectName})), new Object[0]);
        }
    }

    private List<String> getAllMacros() throws SQLException {
        String sql = "SELECT function_name FROM duckdb_functions() WHERE NOT internal AND schema_name = ?";
        return this.jdbcTemplate.queryForStringList("SELECT function_name FROM duckdb_functions() WHERE NOT internal AND schema_name = ?", new String[]{this.name});
    }

    private List<String> getAllViews() throws SQLException {
        String sql = "SELECT view_name FROM duckdb_views() WHERE NOT internal AND schema_name = ?";
        return this.jdbcTemplate.queryForStringList("SELECT view_name FROM duckdb_views() WHERE NOT internal AND schema_name = ?", new String[]{this.name});
    }

    private List<String> getAllTablesNames() throws SQLException {
        return this.getAllObjectsNames("table_name", "duckdb_tables()");
    }

    private List<String> getAllObjectsNames(String catalogNameField, String catalogTable) throws SQLException {
        String sql = "SELECT %s FROM %s WHERE schema_name = ?".formatted(catalogNameField, catalogTable);
        return this.jdbcTemplate.queryForStringList(sql, new String[]{this.name});
    }
}

