import { jsx as _jsx } from "react/jsx-runtime";
/**
 * @license
 * Copyright 2025 Google LLC
 * SPDX-License-Identifier: Apache-2.0
 */
import { render } from '../../../test-utils/render.js';
import { describe, it, expect } from 'vitest';
import { ChatList } from './ChatList.js';
const mockChats = [
    {
        name: 'chat-1',
        mtime: '2025-10-02T10:00:00.000Z',
    },
    {
        name: 'another-chat',
        mtime: '2025-10-01T12:30:00.000Z',
    },
];
describe('<ChatList />', () => {
    it('renders correctly with a list of chats', async () => {
        const { lastFrame, unmount, waitUntilReady } = render(_jsx(ChatList, { chats: mockChats }));
        await waitUntilReady();
        expect(lastFrame()).toMatchSnapshot();
        unmount();
    });
    it('renders correctly with no chats', async () => {
        const { lastFrame, unmount, waitUntilReady } = render(_jsx(ChatList, { chats: [] }));
        await waitUntilReady();
        expect(lastFrame()).toContain('No saved conversation checkpoints found.');
        expect(lastFrame()).toMatchSnapshot();
        unmount();
    });
    it('handles invalid date formats gracefully', async () => {
        const mockChatsWithInvalidDate = [
            {
                name: 'bad-date-chat',
                mtime: 'an-invalid-date-string',
            },
        ];
        const { lastFrame, unmount, waitUntilReady } = render(_jsx(ChatList, { chats: mockChatsWithInvalidDate }));
        await waitUntilReady();
        expect(lastFrame()).toContain('(Invalid Date)');
        expect(lastFrame()).toMatchSnapshot();
        unmount();
    });
});
//# sourceMappingURL=ChatList.test.js.map