import { jsx as _jsx } from "react/jsx-runtime";
/**
 * @license
 * Copyright 2025 Google LLC
 * SPDX-License-Identifier: Apache-2.0
 */
import { Box, Text } from 'ink';
import { useOverflowState } from '../contexts/OverflowContext.js';
import { useStreamingContext } from '../contexts/StreamingContext.js';
import { StreamingState } from '../types.js';
import { theme } from '../semantic-colors.js';
import { useAlternateBuffer } from '../hooks/useAlternateBuffer.js';
export const ShowMoreLines = ({ constrainHeight, isOverflowing: isOverflowingProp, }) => {
    const isAlternateBuffer = useAlternateBuffer();
    const overflowState = useOverflowState();
    const streamingState = useStreamingContext();
    const isOverflowing = isOverflowingProp ??
        (overflowState !== undefined && overflowState.overflowingIds.size > 0);
    if (!isAlternateBuffer ||
        !isOverflowing ||
        !constrainHeight ||
        !(streamingState === StreamingState.Idle ||
            streamingState === StreamingState.WaitingForConfirmation ||
            streamingState === StreamingState.Responding)) {
        return null;
    }
    return (_jsx(Box, { paddingX: 1, marginBottom: 1, children: _jsx(Text, { color: theme.text.accent, wrap: "truncate", children: "Press Ctrl+O to show more lines" }) }));
};
//# sourceMappingURL=ShowMoreLines.js.map