/**
 * @license
 * Copyright 2025 Google LLC
 * SPDX-License-Identifier: Apache-2.0
 */
import { type AuthType, type Config } from '@google/gemini-cli-core';
import type { AccountSuspensionInfo } from '../ui/contexts/UIStateContext.js';
export interface InitialAuthResult {
    authError: string | null;
    accountSuspensionInfo: AccountSuspensionInfo | null;
}
/**
 * Handles the initial authentication flow.
 * @param config The application config.
 * @param authType The selected auth type.
 * @returns The auth result with error message and account suspension status.
 */
export declare function performInitialAuth(config: Config, authType: AuthType | undefined): Promise<InitialAuthResult>;
