import { type ReactNode } from 'react';
import { type StyledChar } from '@alcalzone/ansi-tokenize';
import * as dom from './dom.js';
import ResizeObserver, { ResizeObserverEntry } from './resize-observer.js';
import { Selection } from './selection.js';
/**
Performance metrics for a render operation.
*/
export type RenderMetrics = {
    /**
    Time spent rendering in milliseconds.
    */
    renderTime: number;
    /**
    Output string for the frame.
    */
    output: string;
    /**
    Static output string for the frame.
    */
    staticOutput?: string;
};
export type Options = {
    stdout: NodeJS.WriteStream;
    stdin: NodeJS.ReadStream;
    stderr: NodeJS.WriteStream;
    debug: boolean;
    exitOnCtrlC: boolean;
    patchConsole: boolean;
    onRender?: (metrics: RenderMetrics) => void;
    isScreenReaderEnabled?: boolean;
    waitUntilExit?: () => Promise<void>;
    maxFps?: number;
    alternateBuffer?: boolean;
    alternateBufferAlreadyActive?: boolean;
    incrementalRendering?: boolean;
    debugRainbow?: boolean;
    selectionStyle?: (char: StyledChar) => StyledChar;
    standardReactLayoutTiming?: boolean;
};
export default class Ink {
    private readonly options;
    private readonly log;
    private readonly throttledLog;
    private readonly isScreenReaderEnabled;
    private readonly selection;
    private isUnmounted;
    private lastOutput;
    private lastOutputHeight;
    private lastCursorPosition?;
    private readonly container;
    private readonly rootNode;
    private fullStaticOutput;
    private exitPromise?;
    private restoreConsole?;
    private readonly unsubscribeResize?;
    private readonly unsubscribeSelection?;
    private frameIndex;
    constructor(options: Options);
    resized: () => void;
    getSelection(): Selection;
    resolveExitPromise: () => void;
    rejectExitPromise: (reason?: Error) => void;
    unsubscribeExit: () => void;
    calculateLayout: () => void;
    calculateLayoutAndTriggerObservers(node: dom.DOMElement, observerEntries: Map<ResizeObserver, ResizeObserverEntry[]>): void;
    onRender: () => void;
    recalculateLayout(): void;
    onRerender: () => void;
    render(node: ReactNode): void;
    writeToStdout(data: string): void;
    writeToStderr(data: string): void;
    unmount(error?: Error | number | null): void;
    waitUntilExit(): Promise<void>;
    clear(): void;
    patchConsole(): void;
    private markAllTextNodesDirty;
    private callOnRender;
}
