import { BinaryWriter, BinaryReader } from '@bufbuild/protobuf/wire';
import * as grpc from '@grpc/grpc-js';
import { UntypedServiceImplementation, handleUnaryCall, handleServerStreamingCall } from '@grpc/grpc-js';
import { U as User, a as UnauthenticatedUser, A as A2ARequestHandler } from '../../a2a_request_handler-B3LxMq3P.cjs';
import '../../extensions-DvruCIzw.cjs';

/**
 * A generic empty message that you can re-use to avoid defining duplicated
 * empty messages in your APIs. A typical example is to use it as the request
 * or the response type of an API method. For instance:
 *
 *     service Foo {
 *       rpc Bar(google.protobuf.Empty) returns (google.protobuf.Empty);
 *     }
 */
interface Empty {
}
declare const Empty: MessageFns$2<Empty>;
interface MessageFns$2<T> {
    encode(message: T, writer?: BinaryWriter): BinaryWriter;
    decode(input: BinaryReader | Uint8Array, length?: number): T;
}

/** Older protoc compilers don't understand edition yet. */
/** The set of states a Task can be in. */
declare enum TaskState {
    TASK_STATE_UNSPECIFIED = 0,
    /** TASK_STATE_SUBMITTED - Represents the status that acknowledges a task is created */
    TASK_STATE_SUBMITTED = 1,
    /** TASK_STATE_WORKING - Represents the status that a task is actively being processed */
    TASK_STATE_WORKING = 2,
    /** TASK_STATE_COMPLETED - Represents the status a task is finished. This is a terminal state */
    TASK_STATE_COMPLETED = 3,
    /** TASK_STATE_FAILED - Represents the status a task is done but failed. This is a terminal state */
    TASK_STATE_FAILED = 4,
    /**
     * TASK_STATE_CANCELLED - Represents the status a task was cancelled before it finished.
     * This is a terminal state.
     */
    TASK_STATE_CANCELLED = 5,
    /**
     * TASK_STATE_INPUT_REQUIRED - Represents the status that the task requires information to complete.
     * This is an interrupted state.
     */
    TASK_STATE_INPUT_REQUIRED = 6,
    /**
     * TASK_STATE_REJECTED - Represents the status that the agent has decided to not perform the task.
     * This may be done during initial task creation or later once an agent
     * has determined it can't or won't proceed. This is a terminal state.
     */
    TASK_STATE_REJECTED = 7,
    /**
     * TASK_STATE_AUTH_REQUIRED - Represents the state that some authentication is needed from the upstream
     * client. Authentication is expected to come out-of-band thus this is not
     * an interrupted or terminal state.
     */
    TASK_STATE_AUTH_REQUIRED = 8,
    UNRECOGNIZED = -1
}
declare enum Role {
    ROLE_UNSPECIFIED = 0,
    /** ROLE_USER - USER role refers to communication from the client to the server. */
    ROLE_USER = 1,
    /** ROLE_AGENT - AGENT role refers to communication from the server to the client. */
    ROLE_AGENT = 2,
    UNRECOGNIZED = -1
}
/** Configuration of a send message request. */
interface SendMessageConfiguration {
    /** The output modes that the agent is expected to respond with. */
    acceptedOutputModes: string[];
    /** A configuration of a webhook that can be used to receive updates */
    pushNotification: PushNotificationConfig | undefined;
    /**
     * The maximum number of messages to include in the history. if 0, the
     * history will be unlimited.
     */
    historyLength: number;
    /**
     * If true, the message will be blocking until the task is completed. If
     * false, the message will be non-blocking and the task will be returned
     * immediately. It is the caller's responsibility to check for any task
     * updates.
     */
    blocking: boolean;
}
declare const SendMessageConfiguration: MessageFns$1<SendMessageConfiguration>;
/**
 * Task is the core unit of action for A2A. It has a current status
 * and when results are created for the task they are stored in the
 * artifact. If there are multiple turns for a task, these are stored in
 * history.
 */
interface Task$1 {
    /** Unique identifier for a task, created by the A2A server. */
    id: string;
    /**
     * Unique identifier for the contextual collection of interactions (tasks
     * and messages). Created by the A2A server.
     */
    contextId: string;
    /** The current status of a Task, including state and a message. */
    status: TaskStatus | undefined;
    /** A set of output artifacts for a Task. */
    artifacts: Artifact[];
    /**
     * protolint:disable REPEATED_FIELD_NAMES_PLURALIZED
     * The history of interactions from a task.
     */
    history: Message[];
    /**
     * protolint:enable REPEATED_FIELD_NAMES_PLURALIZED
     * A key/value object to store custom metadata about a task.
     */
    metadata: {
        [key: string]: any;
    } | undefined;
}
declare const Task$1: MessageFns$1<Task$1>;
/** A container for the status of a task */
interface TaskStatus {
    /** The current state of this task */
    state: TaskState;
    /** A message associated with the status. */
    update: Message | undefined;
    /**
     * Timestamp when the status was recorded.
     * Example: "2023-10-27T10:00:00Z"
     */
    timestamp: string | undefined;
}
declare const TaskStatus: MessageFns$1<TaskStatus>;
/**
 * Part represents a container for a section of communication content.
 * Parts can be purely textual, some sort of file (image, video, etc) or
 * a structured data blob (i.e. JSON).
 */
interface Part {
    part?: {
        $case: "text";
        value: string;
    } | {
        $case: "file";
        value: FilePart;
    } | {
        $case: "data";
        value: DataPart;
    } | undefined;
}
declare const Part: MessageFns$1<Part>;
/**
 * FilePart represents the different ways files can be provided. If files are
 * small, directly feeding the bytes is supported via file_with_bytes. If the
 * file is large, the agent should read the content as appropriate directly
 * from the file_with_uri source.
 */
interface FilePart {
    file?: {
        $case: "fileWithUri";
        value: string;
    } | {
        $case: "fileWithBytes";
        value: Buffer;
    } | undefined;
    mimeType: string;
}
declare const FilePart: MessageFns$1<FilePart>;
/** DataPart represents a structured blob. This is most commonly a JSON payload. */
interface DataPart {
    data: {
        [key: string]: any;
    } | undefined;
}
declare const DataPart: MessageFns$1<DataPart>;
/**
 * Message is one unit of communication between client and server. It is
 * associated with a context and optionally a task. Since the server is
 * responsible for the context definition, it must always provide a context_id
 * in its messages. The client can optionally provide the context_id if it
 * knows the context to associate the message to. Similarly for task_id,
 * except the server decides if a task is created and whether to include the
 * task_id.
 */
interface Message {
    /**
     * The message id of the message. This is required and created by the
     * message creator.
     */
    messageId: string;
    /**
     * The context id of the message. This is optional and if set, the message
     * will be associated with the given context.
     */
    contextId: string;
    /**
     * The task id of the message. This is optional and if set, the message
     * will be associated with the given task.
     */
    taskId: string;
    /** A role for the message. */
    role: Role;
    /**
     * protolint:disable REPEATED_FIELD_NAMES_PLURALIZED
     * Content is the container of the message content.
     */
    content: Part[];
    /**
     * protolint:enable REPEATED_FIELD_NAMES_PLURALIZED
     * Any optional metadata to provide along with the message.
     */
    metadata: {
        [key: string]: any;
    } | undefined;
    /** The URIs of extensions that are present or contributed to this Message. */
    extensions: string[];
}
declare const Message: MessageFns$1<Message>;
/**
 * Artifacts are the container for task completed results. These are similar
 * to Messages but are intended to be the product of a task, as opposed to
 * point-to-point communication.
 */
interface Artifact {
    /** Unique id for the artifact. It must be at least unique within a task. */
    artifactId: string;
    /** A human readable name for the artifact. */
    name: string;
    /** A human readable description of the artifact, optional. */
    description: string;
    /** The content of the artifact. */
    parts: Part[];
    /** Optional metadata included with the artifact. */
    metadata: {
        [key: string]: any;
    } | undefined;
    /** The URIs of extensions that are present or contributed to this Artifact. */
    extensions: string[];
}
declare const Artifact: MessageFns$1<Artifact>;
/**
 * TaskStatusUpdateEvent is a delta even on a task indicating that a task
 * has changed.
 */
interface TaskStatusUpdateEvent {
    /** The id of the task that is changed */
    taskId: string;
    /** The id of the context that the task belongs to */
    contextId: string;
    /** The new status of the task. */
    status: TaskStatus | undefined;
    /** Whether this is the last status update expected for this task. */
    final: boolean;
    /** Optional metadata to associate with the task update. */
    metadata: {
        [key: string]: any;
    } | undefined;
}
declare const TaskStatusUpdateEvent: MessageFns$1<TaskStatusUpdateEvent>;
/**
 * TaskArtifactUpdateEvent represents a task delta where an artifact has
 * been generated.
 */
interface TaskArtifactUpdateEvent {
    /** The id of the task for this artifact */
    taskId: string;
    /** The id of the context that this task belongs too */
    contextId: string;
    /** The artifact itself */
    artifact: Artifact | undefined;
    /** Whether this should be appended to a prior one produced */
    append: boolean;
    /** Whether this represents the last part of an artifact */
    lastChunk: boolean;
    /** Optional metadata associated with the artifact update. */
    metadata: {
        [key: string]: any;
    } | undefined;
}
declare const TaskArtifactUpdateEvent: MessageFns$1<TaskArtifactUpdateEvent>;
/** Configuration for setting up push notifications for task updates. */
interface PushNotificationConfig {
    /** A unique id for this push notification. */
    id: string;
    /** Url to send the notification too */
    url: string;
    /** Token unique for this task/session */
    token: string;
    /** Information about the authentication to sent with the notification */
    authentication: AuthenticationInfo | undefined;
}
declare const PushNotificationConfig: MessageFns$1<PushNotificationConfig>;
/** Defines authentication details, used for push notifications. */
interface AuthenticationInfo {
    /** Supported authentication schemes - e.g. Basic, Bearer, etc */
    schemes: string[];
    /** Optional credentials */
    credentials: string;
}
declare const AuthenticationInfo: MessageFns$1<AuthenticationInfo>;
/** Defines additional transport information for the agent. */
interface AgentInterface {
    /** The url this interface is found at. */
    url: string;
    /**
     * The transport supported this url. This is an open form string, to be
     * easily extended for many transport protocols. The core ones officially
     * supported are JSONRPC, GRPC and HTTP+JSON.
     */
    transport: string;
}
declare const AgentInterface: MessageFns$1<AgentInterface>;
/**
 * AgentCard conveys key information:
 * - Overall details (version, name, description, uses)
 * - Skills; a set of actions/solutions the agent can perform
 * - Default modalities/content types supported by the agent.
 * - Authentication requirements
 * Next ID: 18
 */
interface AgentCard$1 {
    /** The version of the A2A protocol this agent supports. */
    protocolVersion: string;
    /**
     * A human readable name for the agent.
     * Example: "Recipe Agent"
     */
    name: string;
    /**
     * A description of the agent's domain of action/solution space.
     * Example: "Agent that helps users with recipes and cooking."
     */
    description: string;
    /**
     * A URL to the address the agent is hosted at. This represents the
     * preferred endpoint as declared by the agent.
     */
    url: string;
    /** The transport of the preferred endpoint. If empty, defaults to JSONRPC. */
    preferredTransport: string;
    /**
     * Announcement of additional supported transports. Client can use any of
     * the supported transports.
     */
    additionalInterfaces: AgentInterface[];
    /** The service provider of the agent. */
    provider: AgentProvider | undefined;
    /**
     * The version of the agent.
     * Example: "1.0.0"
     */
    version: string;
    /** A url to provide additional documentation about the agent. */
    documentationUrl: string;
    /** A2A Capability set supported by the agent. */
    capabilities: AgentCapabilities | undefined;
    /** The security scheme details used for authenticating with this agent. */
    securitySchemes: {
        [key: string]: SecurityScheme;
    };
    /**
     * protolint:disable REPEATED_FIELD_NAMES_PLURALIZED
     * Security requirements for contacting the agent.
     * This list can be seen as an OR of ANDs. Each object in the list describes
     * one possible set of security requirements that must be present on a
     * request. This allows specifying, for example, "callers must either use
     * OAuth OR an API Key AND mTLS."
     * Example:
     * security {
     *   schemes { key: "oauth" value { list: ["read"] } }
     * }
     * security {
     *   schemes { key: "api-key" }
     *   schemes { key: "mtls" }
     * }
     */
    security: Security[];
    /**
     * protolint:enable REPEATED_FIELD_NAMES_PLURALIZED
     * The set of interaction modes that the agent supports across all skills.
     * This can be overridden per skill. Defined as mime types.
     */
    defaultInputModes: string[];
    /** The mime types supported as outputs from this agent. */
    defaultOutputModes: string[];
    /**
     * Skills represent a unit of ability an agent can perform. This may
     * somewhat abstract but represents a more focused set of actions that the
     * agent is highly likely to succeed at.
     */
    skills: AgentSkill[];
    /**
     * Whether the agent supports providing an extended agent card when
     * the user is authenticated, i.e. is the card from .well-known
     * different than the card from GetAgentCard.
     */
    supportsAuthenticatedExtendedCard: boolean;
    /** JSON Web Signatures computed for this AgentCard. */
    signatures: AgentCardSignature[];
}
declare const AgentCard$1: MessageFns$1<AgentCard$1>;
/** Represents information about the service provider of an agent. */
interface AgentProvider {
    /**
     * The providers reference url
     * Example: "https://ai.google.dev"
     */
    url: string;
    /**
     * The providers organization name
     * Example: "Google"
     */
    organization: string;
}
declare const AgentProvider: MessageFns$1<AgentProvider>;
/** Defines the A2A feature set supported by the agent */
interface AgentCapabilities {
    /** If the agent will support streaming responses */
    streaming: boolean;
    /** If the agent can send push notifications to the clients webhook */
    pushNotifications: boolean;
    /** Extensions supported by this agent. */
    extensions: AgentExtension[];
}
declare const AgentCapabilities: MessageFns$1<AgentCapabilities>;
/** A declaration of an extension supported by an Agent. */
interface AgentExtension {
    /**
     * The URI of the extension.
     * Example: "https://developers.google.com/identity/protocols/oauth2"
     */
    uri: string;
    /**
     * A description of how this agent uses this extension.
     * Example: "Google OAuth 2.0 authentication"
     */
    description: string;
    /**
     * Whether the client must follow specific requirements of the extension.
     * Example: false
     */
    required: boolean;
    /** Optional configuration for the extension. */
    params: {
        [key: string]: any;
    } | undefined;
}
declare const AgentExtension: MessageFns$1<AgentExtension>;
/**
 * AgentSkill represents a unit of action/solution that the agent can perform.
 * One can think of this as a type of highly reliable solution that an agent
 * can be tasked to provide. Agents have the autonomy to choose how and when
 * to use specific skills, but clients should have confidence that if the
 * skill is defined that unit of action can be reliably performed.
 */
interface AgentSkill {
    /** Unique id of the skill within this agent. */
    id: string;
    /** A human readable name for the skill. */
    name: string;
    /**
     * A human (or llm) readable description of the skill
     * details and behaviors.
     */
    description: string;
    /**
     * A set of tags for the skill to enhance categorization/utilization.
     * Example: ["cooking", "customer support", "billing"]
     */
    tags: string[];
    /**
     * A set of example queries that this skill is designed to address.
     * These examples should help the caller to understand how to craft requests
     * to the agent to achieve specific goals.
     * Example: ["I need a recipe for bread"]
     */
    examples: string[];
    /** Possible input modalities supported. */
    inputModes: string[];
    /** Possible output modalities produced */
    outputModes: string[];
    /**
     * protolint:disable REPEATED_FIELD_NAMES_PLURALIZED
     * Security schemes necessary for the agent to leverage this skill.
     * As in the overall AgentCard.security, this list represents a logical OR of
     * security requirement objects. Each object is a set of security schemes
     * that must be used together (a logical AND).
     */
    security: Security[];
}
declare const AgentSkill: MessageFns$1<AgentSkill>;
/**
 * AgentCardSignature represents a JWS signature of an AgentCard.
 * This follows the JSON format of an RFC 7515 JSON Web Signature (JWS).
 */
interface AgentCardSignature {
    /**
     * The protected JWS header for the signature. This is always a
     * base64url-encoded JSON object. Required.
     */
    protected: string;
    /** The computed signature, base64url-encoded. Required. */
    signature: string;
    /** The unprotected JWS header values. */
    header: {
        [key: string]: any;
    } | undefined;
}
declare const AgentCardSignature: MessageFns$1<AgentCardSignature>;
interface TaskPushNotificationConfig$1 {
    /** name=tasks/{id}/pushNotificationConfigs/{id} */
    name: string;
    pushNotificationConfig: PushNotificationConfig | undefined;
}
declare const TaskPushNotificationConfig$1: MessageFns$1<TaskPushNotificationConfig$1>;
/** protolint:disable REPEATED_FIELD_NAMES_PLURALIZED */
interface StringList {
    list: string[];
}
declare const StringList: MessageFns$1<StringList>;
interface Security {
    schemes: {
        [key: string]: StringList;
    };
}
declare const Security: MessageFns$1<Security>;
interface SecurityScheme {
    scheme?: {
        $case: "apiKeySecurityScheme";
        value: APIKeySecurityScheme;
    } | {
        $case: "httpAuthSecurityScheme";
        value: HTTPAuthSecurityScheme;
    } | {
        $case: "oauth2SecurityScheme";
        value: OAuth2SecurityScheme;
    } | {
        $case: "openIdConnectSecurityScheme";
        value: OpenIdConnectSecurityScheme;
    } | {
        $case: "mtlsSecurityScheme";
        value: MutualTlsSecurityScheme;
    } | undefined;
}
declare const SecurityScheme: MessageFns$1<SecurityScheme>;
interface APIKeySecurityScheme {
    /** Description of this security scheme. */
    description: string;
    /** Location of the API key, valid values are "query", "header", or "cookie" */
    location: string;
    /** Name of the header, query or cookie parameter to be used. */
    name: string;
}
declare const APIKeySecurityScheme: MessageFns$1<APIKeySecurityScheme>;
interface HTTPAuthSecurityScheme {
    /** Description of this security scheme. */
    description: string;
    /**
     * The name of the HTTP Authentication scheme to be used in the
     * Authorization header as defined in RFC7235. The values used SHOULD be
     * registered in the IANA Authentication Scheme registry.
     * The value is case-insensitive, as defined in RFC7235.
     */
    scheme: string;
    /**
     * A hint to the client to identify how the bearer token is formatted.
     * Bearer tokens are usually generated by an authorization server, so
     * this information is primarily for documentation purposes.
     */
    bearerFormat: string;
}
declare const HTTPAuthSecurityScheme: MessageFns$1<HTTPAuthSecurityScheme>;
interface OAuth2SecurityScheme {
    /** Description of this security scheme. */
    description: string;
    /** An object containing configuration information for the flow types supported */
    flows: OAuthFlows | undefined;
    /**
     * URL to the oauth2 authorization server metadata
     * [RFC8414](https://datatracker.ietf.org/doc/html/rfc8414). TLS is required.
     */
    oauth2MetadataUrl: string;
}
declare const OAuth2SecurityScheme: MessageFns$1<OAuth2SecurityScheme>;
interface OpenIdConnectSecurityScheme {
    /** Description of this security scheme. */
    description: string;
    /**
     * Well-known URL to discover the [[OpenID-Connect-Discovery]] provider
     * metadata.
     */
    openIdConnectUrl: string;
}
declare const OpenIdConnectSecurityScheme: MessageFns$1<OpenIdConnectSecurityScheme>;
interface MutualTlsSecurityScheme {
    /** Description of this security scheme. */
    description: string;
}
declare const MutualTlsSecurityScheme: MessageFns$1<MutualTlsSecurityScheme>;
interface OAuthFlows {
    flow?: {
        $case: "authorizationCode";
        value: AuthorizationCodeOAuthFlow;
    } | {
        $case: "clientCredentials";
        value: ClientCredentialsOAuthFlow;
    } | {
        $case: "implicit";
        value: ImplicitOAuthFlow;
    } | {
        $case: "password";
        value: PasswordOAuthFlow;
    } | undefined;
}
declare const OAuthFlows: MessageFns$1<OAuthFlows>;
interface AuthorizationCodeOAuthFlow {
    /**
     * The authorization URL to be used for this flow. This MUST be in the
     * form of a URL. The OAuth2 standard requires the use of TLS
     */
    authorizationUrl: string;
    /**
     * The token URL to be used for this flow. This MUST be in the form of a URL.
     * The OAuth2 standard requires the use of TLS.
     */
    tokenUrl: string;
    /**
     * The URL to be used for obtaining refresh tokens. This MUST be in the
     * form of a URL. The OAuth2 standard requires the use of TLS.
     */
    refreshUrl: string;
    /**
     * The available scopes for the OAuth2 security scheme. A map between the
     * scope name and a short description for it. The map MAY be empty.
     */
    scopes: {
        [key: string]: string;
    };
}
declare const AuthorizationCodeOAuthFlow: MessageFns$1<AuthorizationCodeOAuthFlow>;
interface ClientCredentialsOAuthFlow {
    /**
     * The token URL to be used for this flow. This MUST be in the form of a URL.
     * The OAuth2 standard requires the use of TLS.
     */
    tokenUrl: string;
    /**
     * The URL to be used for obtaining refresh tokens. This MUST be in the
     * form of a URL. The OAuth2 standard requires the use of TLS.
     */
    refreshUrl: string;
    /**
     * The available scopes for the OAuth2 security scheme. A map between the
     * scope name and a short description for it. The map MAY be empty.
     */
    scopes: {
        [key: string]: string;
    };
}
declare const ClientCredentialsOAuthFlow: MessageFns$1<ClientCredentialsOAuthFlow>;
interface ImplicitOAuthFlow {
    /**
     * The authorization URL to be used for this flow. This MUST be in the
     * form of a URL. The OAuth2 standard requires the use of TLS
     */
    authorizationUrl: string;
    /**
     * The URL to be used for obtaining refresh tokens. This MUST be in the
     * form of a URL. The OAuth2 standard requires the use of TLS.
     */
    refreshUrl: string;
    /**
     * The available scopes for the OAuth2 security scheme. A map between the
     * scope name and a short description for it. The map MAY be empty.
     */
    scopes: {
        [key: string]: string;
    };
}
declare const ImplicitOAuthFlow: MessageFns$1<ImplicitOAuthFlow>;
interface PasswordOAuthFlow {
    /**
     * The token URL to be used for this flow. This MUST be in the form of a URL.
     * The OAuth2 standard requires the use of TLS.
     */
    tokenUrl: string;
    /**
     * The URL to be used for obtaining refresh tokens. This MUST be in the
     * form of a URL. The OAuth2 standard requires the use of TLS.
     */
    refreshUrl: string;
    /**
     * The available scopes for the OAuth2 security scheme. A map between the
     * scope name and a short description for it. The map MAY be empty.
     */
    scopes: {
        [key: string]: string;
    };
}
declare const PasswordOAuthFlow: MessageFns$1<PasswordOAuthFlow>;
/** /////////// Request Messages /////////// */
interface SendMessageRequest$1 {
    request: Message | undefined;
    configuration: SendMessageConfiguration | undefined;
    metadata: {
        [key: string]: any;
    } | undefined;
}
declare const SendMessageRequest$1: MessageFns$1<SendMessageRequest$1>;
interface GetTaskRequest$1 {
    /** name=tasks/{id} */
    name: string;
    historyLength: number;
}
declare const GetTaskRequest$1: MessageFns$1<GetTaskRequest$1>;
interface CancelTaskRequest$1 {
    /** name=tasks/{id} */
    name: string;
}
declare const CancelTaskRequest$1: MessageFns$1<CancelTaskRequest$1>;
interface GetTaskPushNotificationConfigRequest$1 {
    /** name=tasks/{id}/pushNotificationConfigs/{push_id} */
    name: string;
}
declare const GetTaskPushNotificationConfigRequest$1: MessageFns$1<GetTaskPushNotificationConfigRequest$1>;
interface DeleteTaskPushNotificationConfigRequest$1 {
    /** name=tasks/{id}/pushNotificationConfigs/{push_id} */
    name: string;
}
declare const DeleteTaskPushNotificationConfigRequest$1: MessageFns$1<DeleteTaskPushNotificationConfigRequest$1>;
interface CreateTaskPushNotificationConfigRequest$1 {
    /**
     * The task resource for this config.
     * Format: tasks/{id}
     */
    parent: string;
    configId: string;
    config: TaskPushNotificationConfig$1 | undefined;
}
declare const CreateTaskPushNotificationConfigRequest$1: MessageFns$1<CreateTaskPushNotificationConfigRequest$1>;
interface TaskSubscriptionRequest$1 {
    /** name=tasks/{id} */
    name: string;
}
declare const TaskSubscriptionRequest$1: MessageFns$1<TaskSubscriptionRequest$1>;
interface ListTaskPushNotificationConfigRequest$1 {
    /** parent=tasks/{id} */
    parent: string;
    /**
     * For AIP-158 these fields are present. Usually not used/needed.
     * The maximum number of configurations to return.
     * If unspecified, all configs will be returned.
     */
    pageSize: number;
    /**
     * A page token received from a previous
     * ListTaskPushNotificationConfigRequest call.
     * Provide this to retrieve the subsequent page.
     * When paginating, all other parameters provided to
     * `ListTaskPushNotificationConfigRequest` must match the call that provided
     * the page token.
     */
    pageToken: string;
}
declare const ListTaskPushNotificationConfigRequest$1: MessageFns$1<ListTaskPushNotificationConfigRequest$1>;
/** Empty. Added to fix linter violation. */
interface GetAgentCardRequest$1 {
}
declare const GetAgentCardRequest$1: MessageFns$1<GetAgentCardRequest$1>;
/** ////// Response Messages /////////// */
interface SendMessageResponse$1 {
    payload?: {
        $case: "task";
        value: Task$1;
    } | {
        $case: "msg";
        value: Message;
    } | undefined;
}
declare const SendMessageResponse$1: MessageFns$1<SendMessageResponse$1>;
/**
 * The stream response for a message. The stream should be one of the following
 * sequences:
 * If the response is a message, the stream should contain one, and only one,
 * message and then close
 * If the response is a task lifecycle, the first response should be a Task
 * object followed by zero or more TaskStatusUpdateEvents and
 * TaskArtifactUpdateEvents. The stream should complete when the Task
 * if in an interrupted or terminal state. A stream that ends before these
 * conditions are met are
 */
interface StreamResponse$1 {
    payload?: {
        $case: "task";
        value: Task$1;
    } | {
        $case: "msg";
        value: Message;
    } | {
        $case: "statusUpdate";
        value: TaskStatusUpdateEvent;
    } | {
        $case: "artifactUpdate";
        value: TaskArtifactUpdateEvent;
    } | undefined;
}
declare const StreamResponse$1: MessageFns$1<StreamResponse$1>;
interface ListTaskPushNotificationConfigResponse$1 {
    configs: TaskPushNotificationConfig$1[];
    /**
     * A token, which can be sent as `page_token` to retrieve the next page.
     * If this field is omitted, there are no subsequent pages.
     */
    nextPageToken: string;
}
declare const ListTaskPushNotificationConfigResponse$1: MessageFns$1<ListTaskPushNotificationConfigResponse$1>;
interface MessageFns$1<T> {
    fromJSON(object: any): T;
    toJSON(message: T): unknown;
}

type Task = Task$1;
declare const Task: MessageFns<Task>;
type AgentCard = AgentCard$1;
declare const AgentCard: MessageFns<AgentCard>;
type TaskPushNotificationConfig = TaskPushNotificationConfig$1;
declare const TaskPushNotificationConfig: MessageFns<TaskPushNotificationConfig>;
type SendMessageRequest = SendMessageRequest$1;
declare const SendMessageRequest: MessageFns<SendMessageRequest>;
type GetTaskRequest = GetTaskRequest$1;
declare const GetTaskRequest: MessageFns<GetTaskRequest>;
type CancelTaskRequest = CancelTaskRequest$1;
declare const CancelTaskRequest: MessageFns<CancelTaskRequest>;
type GetTaskPushNotificationConfigRequest = GetTaskPushNotificationConfigRequest$1;
declare const GetTaskPushNotificationConfigRequest: MessageFns<GetTaskPushNotificationConfigRequest>;
type DeleteTaskPushNotificationConfigRequest = DeleteTaskPushNotificationConfigRequest$1;
declare const DeleteTaskPushNotificationConfigRequest: MessageFns<DeleteTaskPushNotificationConfigRequest>;
type CreateTaskPushNotificationConfigRequest = CreateTaskPushNotificationConfigRequest$1;
declare const CreateTaskPushNotificationConfigRequest: MessageFns<CreateTaskPushNotificationConfigRequest>;
type TaskSubscriptionRequest = TaskSubscriptionRequest$1;
declare const TaskSubscriptionRequest: MessageFns<TaskSubscriptionRequest>;
type ListTaskPushNotificationConfigRequest = ListTaskPushNotificationConfigRequest$1;
declare const ListTaskPushNotificationConfigRequest: MessageFns<ListTaskPushNotificationConfigRequest>;
type GetAgentCardRequest = GetAgentCardRequest$1;
declare const GetAgentCardRequest: MessageFns<GetAgentCardRequest>;
type SendMessageResponse = SendMessageResponse$1;
declare const SendMessageResponse: MessageFns<SendMessageResponse>;
type StreamResponse = StreamResponse$1;
declare const StreamResponse: MessageFns<StreamResponse>;
type ListTaskPushNotificationConfigResponse = ListTaskPushNotificationConfigResponse$1;
declare const ListTaskPushNotificationConfigResponse: MessageFns<ListTaskPushNotificationConfigResponse>;
/**
 * A2AService defines the gRPC version of the A2A protocol. This has a slightly
 * different shape than the JSONRPC version to better conform to AIP-127,
 * where appropriate. The nouns are AgentCard, Message, Task and
 * TaskPushNotificationConfig.
 * - Messages are not a standard resource so there is no get/delete/update/list
 *   interface, only a send and stream custom methods.
 * - Tasks have a get interface and custom cancel and subscribe methods.
 * - TaskPushNotificationConfig are a resource whose parent is a task.
 *   They have get, list and create methods.
 * - AgentCard is a static resource with only a get method.
 * fields are not present as they don't comply with AIP rules, and the
 * optional history_length on the get task method is not present as it also
 * violates AIP-127 and AIP-131.
 */
type A2AServiceService = typeof A2AServiceService;
declare const A2AServiceService: {
    /**
     * Send a message to the agent. This is a blocking call that will return the
     * task once it is completed, or a LRO if requested.
     */
    readonly sendMessage: {
        readonly path: "/a2a.v1.A2AService/SendMessage";
        readonly requestStream: false;
        readonly responseStream: false;
        readonly requestSerialize: (value: SendMessageRequest) => Buffer<ArrayBuffer>;
        readonly requestDeserialize: (value: Buffer) => SendMessageRequest$1;
        readonly responseSerialize: (value: SendMessageResponse) => Buffer<ArrayBuffer>;
        readonly responseDeserialize: (value: Buffer) => SendMessageResponse$1;
    };
    /**
     * SendStreamingMessage is a streaming call that will return a stream of
     * task update events until the Task is in an interrupted or terminal state.
     */
    readonly sendStreamingMessage: {
        readonly path: "/a2a.v1.A2AService/SendStreamingMessage";
        readonly requestStream: false;
        readonly responseStream: true;
        readonly requestSerialize: (value: SendMessageRequest) => Buffer<ArrayBuffer>;
        readonly requestDeserialize: (value: Buffer) => SendMessageRequest$1;
        readonly responseSerialize: (value: StreamResponse) => Buffer<ArrayBuffer>;
        readonly responseDeserialize: (value: Buffer) => StreamResponse$1;
    };
    /** Get the current state of a task from the agent. */
    readonly getTask: {
        readonly path: "/a2a.v1.A2AService/GetTask";
        readonly requestStream: false;
        readonly responseStream: false;
        readonly requestSerialize: (value: GetTaskRequest) => Buffer<ArrayBuffer>;
        readonly requestDeserialize: (value: Buffer) => GetTaskRequest$1;
        readonly responseSerialize: (value: Task) => Buffer<ArrayBuffer>;
        readonly responseDeserialize: (value: Buffer) => Task$1;
    };
    /**
     * Cancel a task from the agent. If supported one should expect no
     * more task updates for the task.
     */
    readonly cancelTask: {
        readonly path: "/a2a.v1.A2AService/CancelTask";
        readonly requestStream: false;
        readonly responseStream: false;
        readonly requestSerialize: (value: CancelTaskRequest) => Buffer<ArrayBuffer>;
        readonly requestDeserialize: (value: Buffer) => CancelTaskRequest$1;
        readonly responseSerialize: (value: Task) => Buffer<ArrayBuffer>;
        readonly responseDeserialize: (value: Buffer) => Task$1;
    };
    /**
     * TaskSubscription is a streaming call that will return a stream of task
     * update events. This attaches the stream to an existing in process task.
     * If the task is complete the stream will return the completed task (like
     * GetTask) and close the stream.
     */
    readonly taskSubscription: {
        readonly path: "/a2a.v1.A2AService/TaskSubscription";
        readonly requestStream: false;
        readonly responseStream: true;
        readonly requestSerialize: (value: TaskSubscriptionRequest) => Buffer<ArrayBuffer>;
        readonly requestDeserialize: (value: Buffer) => TaskSubscriptionRequest$1;
        readonly responseSerialize: (value: StreamResponse) => Buffer<ArrayBuffer>;
        readonly responseDeserialize: (value: Buffer) => StreamResponse$1;
    };
    /** Set a push notification config for a task. */
    readonly createTaskPushNotificationConfig: {
        readonly path: "/a2a.v1.A2AService/CreateTaskPushNotificationConfig";
        readonly requestStream: false;
        readonly responseStream: false;
        readonly requestSerialize: (value: CreateTaskPushNotificationConfigRequest) => Buffer<ArrayBuffer>;
        readonly requestDeserialize: (value: Buffer) => CreateTaskPushNotificationConfigRequest$1;
        readonly responseSerialize: (value: TaskPushNotificationConfig) => Buffer<ArrayBuffer>;
        readonly responseDeserialize: (value: Buffer) => TaskPushNotificationConfig$1;
    };
    /** Get a push notification config for a task. */
    readonly getTaskPushNotificationConfig: {
        readonly path: "/a2a.v1.A2AService/GetTaskPushNotificationConfig";
        readonly requestStream: false;
        readonly responseStream: false;
        readonly requestSerialize: (value: GetTaskPushNotificationConfigRequest) => Buffer<ArrayBuffer>;
        readonly requestDeserialize: (value: Buffer) => GetTaskPushNotificationConfigRequest$1;
        readonly responseSerialize: (value: TaskPushNotificationConfig) => Buffer<ArrayBuffer>;
        readonly responseDeserialize: (value: Buffer) => TaskPushNotificationConfig$1;
    };
    /** Get a list of push notifications configured for a task. */
    readonly listTaskPushNotificationConfig: {
        readonly path: "/a2a.v1.A2AService/ListTaskPushNotificationConfig";
        readonly requestStream: false;
        readonly responseStream: false;
        readonly requestSerialize: (value: ListTaskPushNotificationConfigRequest) => Buffer<ArrayBuffer>;
        readonly requestDeserialize: (value: Buffer) => ListTaskPushNotificationConfigRequest$1;
        readonly responseSerialize: (value: ListTaskPushNotificationConfigResponse) => Buffer<ArrayBuffer>;
        readonly responseDeserialize: (value: Buffer) => ListTaskPushNotificationConfigResponse$1;
    };
    /** GetAgentCard returns the agent card for the agent. */
    readonly getAgentCard: {
        readonly path: "/a2a.v1.A2AService/GetAgentCard";
        readonly requestStream: false;
        readonly responseStream: false;
        readonly requestSerialize: (value: GetAgentCardRequest) => Buffer<ArrayBuffer>;
        readonly requestDeserialize: (value: Buffer) => GetAgentCardRequest$1;
        readonly responseSerialize: (value: AgentCard) => Buffer<ArrayBuffer>;
        readonly responseDeserialize: (value: Buffer) => AgentCard$1;
    };
    /** Delete a push notification config for a task. */
    readonly deleteTaskPushNotificationConfig: {
        readonly path: "/a2a.v1.A2AService/DeleteTaskPushNotificationConfig";
        readonly requestStream: false;
        readonly responseStream: false;
        readonly requestSerialize: (value: DeleteTaskPushNotificationConfigRequest) => Buffer<ArrayBuffer>;
        readonly requestDeserialize: (value: Buffer) => DeleteTaskPushNotificationConfigRequest$1;
        readonly responseSerialize: (value: Empty) => Buffer<ArrayBuffer>;
        readonly responseDeserialize: (value: Buffer) => Empty;
    };
};
interface A2AServiceServer extends UntypedServiceImplementation {
    /**
     * Send a message to the agent. This is a blocking call that will return the
     * task once it is completed, or a LRO if requested.
     */
    sendMessage: handleUnaryCall<SendMessageRequest, SendMessageResponse>;
    /**
     * SendStreamingMessage is a streaming call that will return a stream of
     * task update events until the Task is in an interrupted or terminal state.
     */
    sendStreamingMessage: handleServerStreamingCall<SendMessageRequest, StreamResponse>;
    /** Get the current state of a task from the agent. */
    getTask: handleUnaryCall<GetTaskRequest, Task>;
    /**
     * Cancel a task from the agent. If supported one should expect no
     * more task updates for the task.
     */
    cancelTask: handleUnaryCall<CancelTaskRequest, Task>;
    /**
     * TaskSubscription is a streaming call that will return a stream of task
     * update events. This attaches the stream to an existing in process task.
     * If the task is complete the stream will return the completed task (like
     * GetTask) and close the stream.
     */
    taskSubscription: handleServerStreamingCall<TaskSubscriptionRequest, StreamResponse>;
    /** Set a push notification config for a task. */
    createTaskPushNotificationConfig: handleUnaryCall<CreateTaskPushNotificationConfigRequest, TaskPushNotificationConfig>;
    /** Get a push notification config for a task. */
    getTaskPushNotificationConfig: handleUnaryCall<GetTaskPushNotificationConfigRequest, TaskPushNotificationConfig>;
    /** Get a list of push notifications configured for a task. */
    listTaskPushNotificationConfig: handleUnaryCall<ListTaskPushNotificationConfigRequest, ListTaskPushNotificationConfigResponse>;
    /** GetAgentCard returns the agent card for the agent. */
    getAgentCard: handleUnaryCall<GetAgentCardRequest, AgentCard>;
    /** Delete a push notification config for a task. */
    deleteTaskPushNotificationConfig: handleUnaryCall<DeleteTaskPushNotificationConfigRequest, Empty>;
}
interface MessageFns<T> {
    encode(message: T, writer?: BinaryWriter): BinaryWriter;
    decode(input: BinaryReader | Uint8Array, length?: number): T;
}

type UserBuilder = (call: grpc.ServerUnaryCall<unknown, unknown> | grpc.ServerWritableStream<unknown, unknown>) => Promise<User>;
declare const UserBuilder: {
    noAuthentication: () => Promise<UnauthenticatedUser>;
};

/**
 * Options for configuring the gRPC handler.
 */
interface GrpcServiceOptions {
    requestHandler: A2ARequestHandler;
    userBuilder: UserBuilder;
}
/**
 * Creates a gRPC transport handler.
 * This handler implements the A2A gRPC service definition and acts as an
 * adapter between the gRPC transport layer and the core A2A request handler.
 *
 * @param requestHandler - The core A2A request handler for business logic.
 * @returns An object that implements the A2AServiceServer interface.
 *
 * @example
 * ```ts
 * const server = new grpc.Server();
 * const requestHandler = new DefaultRequestHandler(...);
 * server.addService(A2AService, grpcService({ requestHandler, userBuilder: UserBuilder.noAuthentication }));
 * ```
 */
declare function grpcService(options: GrpcServiceOptions): A2AServiceServer;

export { A2AServiceService as A2AService, type GrpcServiceOptions, UserBuilder, grpcService };
