/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.emu.jit.gen;

import ghidra.pcode.emu.jit.gen.GenConsts;
import ghidra.pcode.emu.jit.gen.JitCodeGenerator;
import ghidra.pcode.emu.jit.gen.StaticFieldReq;
import ghidra.program.model.address.Address;
import ghidra.program.model.pcode.Varnode;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;

public record FieldForVarnode(Varnode vn) implements StaticFieldReq
{
    @Override
    public String name() {
        Address addr = this.vn.getAddress();
        return "VARNODE_%s_%s_%s".formatted(addr.getAddressSpace().getName().toUpperCase(), Long.toUnsignedString(addr.getOffset(), 16), this.vn.getSize());
    }

    @Override
    public void generateClinitCode(JitCodeGenerator gen, ClassVisitor cv, MethodVisitor sv) {
        cv.visitField(26, this.name(), GenConsts.TDESC_VARNODE, null, null);
        sv.visitFieldInsn(178, gen.nameThis, "ADDRESS_FACTORY", GenConsts.TDESC_ADDRESS_FACTORY);
        sv.visitLdcInsn((Object)this.vn.getAddress().getAddressSpace().getName());
        sv.visitLdcInsn((Object)this.vn.getAddress().getOffset());
        sv.visitLdcInsn((Object)this.vn.getSize());
        sv.visitMethodInsn(184, GenConsts.NAME_JIT_COMPILED_PASSAGE, "createVarnode", GenConsts.MDESC_JIT_COMPILED_PASSAGE__CREATE_VARNODE, true);
        sv.visitFieldInsn(179, gen.nameThis, this.name(), GenConsts.TDESC_VARNODE);
    }

    @Override
    public void generateLoadCode(JitCodeGenerator gen, MethodVisitor rv) {
        rv.visitFieldInsn(178, gen.nameThis, this.name(), GenConsts.TDESC_VARNODE);
    }
}

