/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.decompiler.util;

import ghidra.app.decompiler.ClangToken;
import ghidra.app.decompiler.DecompInterface;
import ghidra.app.decompiler.DecompileOptions;
import ghidra.app.decompiler.DecompilerLocation;
import ghidra.app.decompiler.component.DecompilerUtils;
import ghidra.app.decompiler.util.FillOutStructureHelper;
import ghidra.framework.cmd.BackgroundCommand;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeConflictHandler;
import ghidra.program.model.data.PointerDataType;
import ghidra.program.model.data.Structure;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Program;
import ghidra.program.model.pcode.HighFunction;
import ghidra.program.model.pcode.HighFunctionDBUtil;
import ghidra.program.model.pcode.HighSymbol;
import ghidra.program.model.pcode.HighVariable;
import ghidra.program.model.pcode.PcodeException;
import ghidra.program.model.pcode.Varnode;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.util.FunctionParameterFieldLocation;
import ghidra.program.util.ProgramLocation;
import ghidra.program.util.VariableLocation;
import ghidra.util.Msg;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.task.TaskMonitor;
import java.util.Objects;

public class FillOutStructureCmd
extends BackgroundCommand<Program> {
    private DecompileOptions decompileOptions;
    private ProgramLocation location;

    public FillOutStructureCmd(ProgramLocation location, DecompileOptions decompileOptions) {
        super("Fill Out Structure", true, false, true);
        this.decompileOptions = Objects.requireNonNull(decompileOptions);
        this.location = Objects.requireNonNull(location);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean applyTo(Program program, TaskMonitor monitor) {
        if (program != this.location.getProgram()) {
            throw new AssertionError((Object)"program does not match location");
        }
        Function function = program.getFunctionManager().getFunctionContaining(this.location.getAddress());
        if (function == null) {
            this.setStatusMsg("Function not found at " + String.valueOf(this.location.getAddress()));
            return false;
        }
        FillOutStructureHelper fillStructureHelper = new FillOutStructureHelper(program, monitor);
        DecompInterface decompInterface = fillStructureHelper.setUpDecompiler(this.decompileOptions);
        try {
            HighVariable var = null;
            ProgramLocation programLocation = this.location;
            if (!(programLocation instanceof DecompilerLocation)) {
                Address storageAddr = this.computeStorageAddress(function);
                var = fillStructureHelper.computeHighVariable(storageAddr, function, decompInterface);
            } else {
                DecompilerLocation dloc = (DecompilerLocation)programLocation;
                ClangToken token = dloc.getToken();
                if (token == null) {
                    this.setStatusMsg("Unable to identify variable from decompiler token");
                    boolean bl = false;
                    return bl;
                }
                var = token.getHighVariable();
                Varnode exactSpot = token.getVarnode();
                if (var != null && exactSpot != null) {
                    HighFunction hfunc = var.getHighFunction();
                    try {
                        var = hfunc.splitOutMergeGroup(var, exactSpot);
                    }
                    catch (PcodeException ex) {
                        this.setStatusMsg("Unable to isolate variable from merged group");
                        boolean bl = false;
                        decompInterface.dispose();
                        return bl;
                    }
                }
            }
            Structure structDT = fillStructureHelper.processStructure(var, function, false, true, decompInterface);
            if (structDT == null) {
                this.setStatusMsg("Failed to fill-out structure");
                boolean token = false;
                return token;
            }
            PointerDataType pointerDT = new PointerDataType((DataType)structDT);
            pointerDT = program.getDataTypeManager().addDataType((DataType)pointerDT, DataTypeConflictHandler.DEFAULT_HANDLER);
            boolean isThisParam = DecompilerUtils.isThisParameter(var, function);
            if (!isThisParam) {
                this.commitVariable(var, (DataType)pointerDT, isThisParam);
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            Msg.showError((Object)((Object)this), null, (String)"Auto Create Structure Failed", (Object)"Failed to create Structure variable", (Throwable)e);
        }
        finally {
            decompInterface.dispose();
        }
        return false;
    }

    private void commitVariable(HighVariable var, DataType newDt, boolean isThisParam) {
        if (!isThisParam) {
            try {
                HighFunctionDBUtil.updateDBVariable((HighSymbol)var.getSymbol(), null, (DataType)newDt, (SourceType)SourceType.USER_DEFINED);
            }
            catch (DuplicateNameException e) {
                throw new AssertException("Unexpected exception", (Throwable)e);
            }
            catch (InvalidInputException e) {
                Msg.error((Object)((Object)this), (Object)("Failed to re-type variable " + var.getName() + ": " + e.getMessage()));
            }
        }
    }

    private Address computeStorageAddress(Function function) {
        Address storageAddress = null;
        if (this.location instanceof VariableLocation) {
            VariableLocation varLoc = (VariableLocation)this.location;
            storageAddress = varLoc.getVariable().getVariableStorage().getMinAddress();
        } else if (this.location instanceof FunctionParameterFieldLocation) {
            FunctionParameterFieldLocation funcPFL = (FunctionParameterFieldLocation)this.location;
            storageAddress = funcPFL.getParameter().getVariableStorage().getMinAddress();
        }
        return storageAddress;
    }
}

