/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.decompile.actions;

import docking.widgets.OptionDialog;
import ghidra.app.decompiler.ClangFieldToken;
import ghidra.app.decompiler.ClangToken;
import ghidra.app.plugin.core.decompile.DecompilerProvider;
import ghidra.app.plugin.core.decompile.actions.RetypeFieldTask;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.data.BitFieldDataType;
import ghidra.program.model.data.Composite;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.program.model.data.FactoryDataType;
import ghidra.program.model.data.Union;
import ghidra.program.model.listing.Program;

public class RetypeUnionFieldTask
extends RetypeFieldTask {
    private DataTypeComponent component;
    private int ordinal;

    public RetypeUnionFieldTask(PluginTool tool, Program program, DecompilerProvider provider, ClangToken token, Composite composite) {
        super(tool, program, provider, token, composite);
    }

    @Override
    public String getTransactionName() {
        return "Retype Union Field";
    }

    @Override
    public boolean isValidBefore() {
        if (!(this.composite instanceof Union)) {
            this.errorMsg = "Could not identify union at cursor";
            return false;
        }
        this.ordinal = ((ClangFieldToken)this.tokenAtCursor).getOffset();
        this.component = this.composite.getComponent(this.ordinal);
        if (this.component == null) {
            this.errorMsg = "Could not identify component of " + this.composite.getName();
            return false;
        }
        this.oldType = this.component.getDataType();
        if (this.oldType instanceof BitFieldDataType) {
            this.errorMsg = "Retype of defined bit-field is not supported.";
            return false;
        }
        return true;
    }

    private boolean hasSizeChange() {
        int newTypeLength = this.newType.getLength();
        if (newTypeLength == this.composite.getLength()) {
            return false;
        }
        if (this.newType.getLength() < this.composite.getLength()) {
            DataTypeComponent[] components;
            for (DataTypeComponent dtc : components = this.composite.getDefinedComponents()) {
                if (dtc.getOffset() + dtc.getLength() <= newTypeLength) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean isValidAfter() {
        int choice;
        if (this.newType instanceof FactoryDataType || this.newType.getLength() <= 0) {
            this.errorMsg = "Field of type '" + this.newType.getName() + "' - is not allowed.";
            return false;
        }
        return !this.hasSizeChange() || (choice = OptionDialog.showOptionDialogWithCancelAsDefaultButton(null, (String)"Increase the size of the union", (String)"The size of the containing union will be changed if you continue.", (String)"Continue", (int)2)) == 1;
    }

    @Override
    public void commit() throws IllegalArgumentException {
        String fieldName = null;
        String comment = null;
        if (this.component != null) {
            fieldName = this.component.getFieldName();
            comment = this.component.getComment();
        }
        this.composite.delete(this.ordinal);
        this.composite.insert(this.ordinal, this.newType, -1, fieldName, comment);
    }
}

