/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.data;

import ghidra.program.model.data.AbstractUnsignedIntegerDataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.SignedQWordDataType;

public class QWordDataType
extends AbstractUnsignedIntegerDataType {
    public static final QWordDataType dataType = new QWordDataType();

    public QWordDataType() {
        this(null);
    }

    public QWordDataType(DataTypeManager dtm) {
        super("qword", dtm);
    }

    @Override
    public String getDescription() {
        return "Unsigned Quad-Word (dq, 8-bytes)";
    }

    @Override
    public int getLength() {
        return 8;
    }

    @Override
    public String getAssemblyMnemonic() {
        return "dq";
    }

    @Override
    public SignedQWordDataType getOppositeSignednessDataType() {
        return SignedQWordDataType.dataType.clone(this.getDataTypeManager());
    }

    @Override
    public QWordDataType clone(DataTypeManager dtm) {
        if (dtm == this.getDataTypeManager()) {
            return this;
        }
        return new QWordDataType(dtm);
    }
}

