/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.main.datatree;

import docking.ActionContext;
import docking.DialogComponentProvider;
import docking.widgets.table.GTable;
import docking.widgets.table.GTableCellRenderer;
import docking.widgets.table.GTableCellRenderingData;
import docking.widgets.table.threaded.GThreadedTablePanel;
import docking.widgets.table.threaded.ThreadedTableModel;
import docking.widgets.table.threaded.ThreadedTableModelListener;
import ghidra.framework.main.datatable.ProjectDataContext;
import ghidra.framework.main.datatree.CheckoutInfo;
import ghidra.framework.main.datatree.FindCheckoutsTableModel;
import ghidra.framework.model.DomainFile;
import ghidra.framework.model.DomainFolder;
import ghidra.framework.plugintool.Plugin;
import ghidra.util.DateUtils;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class FindCheckoutsDialog
extends DialogComponentProvider {
    private FindCheckoutsTableModel model;
    private Plugin plugin;
    private DomainFolder folder;
    private GTable table;
    private boolean showMessage = true;
    private GThreadedTablePanel<CheckoutInfo> threadedTablePanel;

    public FindCheckoutsDialog(Plugin plugin, DomainFolder folder) {
        super("Find Checkouts");
        this.plugin = plugin;
        this.folder = folder;
        this.create();
        this.setHelpLocation(new HelpLocation("VersionControl", "Find_Checkouts"));
    }

    private void create() {
        this.model = new FindCheckoutsTableModel(this.folder, this.plugin.getTool());
        this.model.addInitialLoadListener(new ThreadedTableModelListener(){

            public void loadPending() {
            }

            public void loadingStarted() {
            }

            public void loadingFinished(boolean wasCancelled) {
                boolean hasData;
                if (wasCancelled) {
                    FindCheckoutsDialog.this.setStatusText("Find Checkouts Cancelled");
                    return;
                }
                boolean bl = hasData = FindCheckoutsDialog.this.model.getRowCount() > 0;
                if (!hasData && FindCheckoutsDialog.this.showMessage) {
                    Msg.showInfo(this.getClass(), FindCheckoutsDialog.this.threadedTablePanel, (String)"Find Checkouts", (Object)"No checkouts were found.");
                    FindCheckoutsDialog.this.close();
                }
            }
        });
        this.threadedTablePanel = new GThreadedTablePanel((ThreadedTableModel)this.model);
        this.table = this.threadedTablePanel.getTable();
        TableColumnModel columnModel = this.table.getColumnModel();
        MyCellRenderer cellRenderer = new MyCellRenderer();
        for (int i = 0; i < columnModel.getColumnCount(); ++i) {
            TableColumn column = columnModel.getColumn(i);
            column.setCellRenderer((TableCellRenderer)((Object)cellRenderer));
            String name = (String)column.getIdentifier();
            if (!name.equals("Checkout Date")) continue;
            column.setPreferredWidth(180);
        }
        this.table.setPreferredScrollableViewportSize(new Dimension(this.threadedTablePanel.getPreferredSize().width, 150));
        this.threadedTablePanel.getAccessibleContext().setAccessibleName("Find Checkouts");
        this.addWorkPanel((JComponent)this.threadedTablePanel);
        this.addDismissButton();
    }

    private List<DomainFile> getFileList() {
        int[] selectedRows;
        ArrayList<DomainFile> list = new ArrayList<DomainFile>();
        for (int selectedRow : selectedRows = this.table.getSelectedRows()) {
            list.add(this.model.getDomainFile(selectedRow));
        }
        return list;
    }

    public void close() {
        super.close();
        this.threadedTablePanel.dispose();
    }

    public ActionContext getActionContext(MouseEvent event) {
        return new ProjectDataContext(null, this.folder.getProjectData(), null, null, this.getFileList(), null, true);
    }

    private class MyCellRenderer
    extends GTableCellRenderer {
        private MyCellRenderer() {
        }

        public Component getTableCellRendererComponent(GTableCellRenderingData data) {
            super.getTableCellRendererComponent(data);
            Object value = data.getValue();
            if (value instanceof Date) {
                this.setText(DateUtils.formatDateTimestamp((Date)((Date)value)));
            }
            this.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
            String toolTipText = null;
            int col = data.getColumnModelIndex();
            if (col == 0) {
                toolTipText = "Date when file was checked out";
            }
            this.setToolTipText(toolTipText);
            return this;
        }
    }
}

