/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.impl.swing;

import ca.odell.glazedlists.impl.swing.ScreenGeometry;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public final class ComboBoxPopupLocationFix {
    private final JComboBox comboBox;
    private final JPopupMenu popupMenu;
    private final Listener listener = new Listener();

    private ComboBoxPopupLocationFix(JComboBox comboBox) {
        this.comboBox = comboBox;
        this.popupMenu = (JPopupMenu)comboBox.getUI().getAccessibleChild(comboBox, 0);
        this.popupMenu.addPopupMenuListener(this.listener);
    }

    public static ComboBoxPopupLocationFix install(JComboBox comboBox) {
        if (comboBox == null) {
            throw new IllegalArgumentException();
        }
        return new ComboBoxPopupLocationFix(comboBox);
    }

    public void uninstall() {
        this.popupMenu.removePopupMenuListener(this.listener);
    }

    private void fixPopupLocation(JComponent popupComponent) {
        if (popupComponent.getClass().getName().indexOf("apple.laf") != 0) {
            return;
        }
        Point comboLocationOnScreen = this.comboBox.getLocationOnScreen();
        int comboHeight = this.comboBox.getHeight();
        int popupY = comboLocationOnScreen.y + comboHeight;
        Rectangle screenBounds = new ScreenGeometry(this.comboBox).getScreenBounds();
        int popupHeight = popupComponent.getPreferredSize().height;
        if (comboLocationOnScreen.y + comboHeight + popupHeight > screenBounds.x + screenBounds.height) {
            popupY = comboLocationOnScreen.y - popupHeight;
        }
        popupComponent.setLocation(comboLocationOnScreen.x, popupY);
    }

    private class Listener
    implements PopupMenuListener {
        private Listener() {
        }

        @Override
        public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            JComponent popupComponent = (JComponent)e.getSource();
            ComboBoxPopupLocationFix.this.fixPopupLocation(popupComponent);
        }

        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
        }

        @Override
        public void popupMenuCanceled(PopupMenuEvent e) {
        }
    }
}

