/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader.symbol;

import ghidra.app.util.bin.format.pdb2.pdbreader.AbstractPdb;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbByteReader;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.AbstractDefinedSingleAddressRangeMsSymbol;

public class FramePointerRelativeDARMsSymbol
extends AbstractDefinedSingleAddressRangeMsSymbol {
    public static final int PDB_ID = 4418;
    private long offsetToFramePointer;

    public FramePointerRelativeDARMsSymbol(AbstractPdb pdb, PdbByteReader reader) throws PdbException {
        super(pdb, reader);
        this.offsetToFramePointer = reader.parseVarSizedOffset(32);
        this.parseRangeAndGaps(reader);
    }

    @Override
    public int getPdbId() {
        return 4418;
    }

    @Override
    protected String getSymbolTypeName() {
        return "DEFRANGE_FRAMEPOINTER_REL";
    }

    @Override
    public void emit(StringBuilder builder) {
        builder.append(String.format("%s: FrameOffset: %04X ", this.getSymbolTypeName(), this.offsetToFramePointer));
        this.emitRangeAndGaps(builder);
    }
}

