/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader.symbol;

import ghidra.app.util.bin.format.pdb2.pdbreader.AbstractPdb;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbByteReader;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.AbstractMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.AddressMsSymbol;
import java.util.HashMap;
import java.util.Map;

public class TrampolineMsSymbol
extends AbstractMsSymbol
implements AddressMsSymbol {
    public static final int PDB_ID = 4396;
    private Type trampolineType;
    private int sizeOfThunk;
    private long offsetThunk;
    private long offsetTarget;
    private int sectionThunk;
    private int sectionTarget;

    public TrampolineMsSymbol(AbstractPdb pdb, PdbByteReader reader) throws PdbException {
        super(pdb, reader);
        this.trampolineType = Type.fromValue(reader.parseUnsignedShortVal());
        this.sizeOfThunk = reader.parseUnsignedShortVal();
        this.offsetThunk = reader.parseUnsignedIntVal();
        this.offsetTarget = reader.parseUnsignedIntVal();
        this.sectionThunk = pdb.parseSegment(reader);
        this.sectionTarget = pdb.parseSegment(reader);
    }

    @Override
    public int getPdbId() {
        return 4396;
    }

    public Type getType() {
        return this.trampolineType;
    }

    public int getSizeOfThunk() {
        return this.sizeOfThunk;
    }

    @Override
    public long getOffset() {
        return this.getOffsetThunk();
    }

    @Override
    public int getSegment() {
        return this.getSegmentThunk();
    }

    public long getOffsetThunk() {
        return this.offsetThunk;
    }

    public long getOffsetTarget() {
        return this.offsetTarget;
    }

    public int getSegmentThunk() {
        return this.sectionThunk;
    }

    public int getSegmentTarget() {
        return this.sectionTarget;
    }

    @Override
    public void emit(StringBuilder builder) {
        builder.append(this.getSymbolTypeName());
        builder.append(": subtype ");
        builder.append((Object)this.trampolineType);
        builder.append(String.format(", code size = %d bytes\n", this.sizeOfThunk));
        builder.append(String.format("   Thunk address: [%04X:%08X]\n", this.sectionThunk, this.offsetThunk));
        builder.append(String.format("   Thunk target:  [%04X:%08X]\n", this.sectionTarget, this.offsetTarget));
    }

    @Override
    protected String getSymbolTypeName() {
        return "TRAMPOLINE";
    }

    public static enum Type {
        UNKNOWN("<unknown subtype>", -1),
        INCREMENTAL("Incremental", 0),
        BRANCH_ISLAND("BranchIsland", 1);

        private static final Map<Integer, Type> BY_VALUE;
        public final String label;
        public final int value;

        public String toString() {
            return this.label;
        }

        public static Type fromValue(int val) {
            return BY_VALUE.getOrDefault(val, UNKNOWN);
        }

        private Type(String label, int value) {
            this.label = label;
            this.value = value;
        }

        static {
            BY_VALUE = new HashMap<Integer, Type>();
            for (Type val : Type.values()) {
                BY_VALUE.put(val.value, val);
            }
        }
    }
}

