/*
 * Decompiled with CFR 0.152.
 */
package generic.json;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apache.commons.lang3.builder.ToStringSummary;

public class Json
extends ToStringStyle {
    public static final JsonWithNewlinesToStringStyle WITH_NEWLINES = new JsonWithNewlinesToStringStyle();

    public static String toString(Object o) {
        return ToStringBuilder.reflectionToString((Object)o, (ToStringStyle)WITH_NEWLINES);
    }

    public static String toStringFlat(Object o) {
        return ToStringBuilder.reflectionToString((Object)o, (ToStringStyle)new JsonWithFlatToStringStyle());
    }

    public static String toString(Object o, String ... includFields) {
        InclusiveReflectionToStringBuilder builder = new InclusiveReflectionToStringBuilder(o);
        builder.setIncludeFieldNames(includFields);
        return builder.toString();
    }

    public static String toStringExclude(Object o, String ... excludedFields) {
        ReflectionToStringBuilder builder = new ReflectionToStringBuilder(o, (ToStringStyle)WITH_NEWLINES);
        builder.setExcludeFieldNames(excludedFields);
        return builder.toString();
    }

    public static class JsonWithNewlinesToStringStyle
    extends ToStringStyle {
        private JsonWithNewlinesToStringStyle() {
            this.setUseClassName(false);
            this.setUseIdentityHashCode(false);
            this.setContentStart("{\n\t");
            this.setContentEnd("\n}");
            this.setArrayStart("[");
            this.setArrayEnd("]");
            this.setFieldSeparator(",\n\t");
            this.setFieldNameValueSeparator(": ");
            this.setNullText("null");
            this.setSummaryObjectStartText("\"<");
            this.setSummaryObjectEndText(">\"");
            this.setSizeStartText("\"<size=");
            this.setSizeEndText(">\"");
        }
    }

    public static class JsonWithFlatToStringStyle
    extends ToStringStyle {
        private JsonWithFlatToStringStyle() {
            this.setUseClassName(false);
            this.setUseIdentityHashCode(false);
            this.setContentStart("{ ");
            this.setContentEnd(" }");
            this.setArrayStart("[");
            this.setArrayEnd("]");
            this.setFieldSeparator(", ");
            this.setFieldNameValueSeparator(": ");
            this.setNullText("null");
            this.setSummaryObjectStartText("\"<");
            this.setSummaryObjectEndText(">\"");
            this.setSizeStartText("\"<size=");
            this.setSizeEndText(">\"");
        }
    }

    private static class InclusiveReflectionToStringBuilder
    extends ReflectionToStringBuilder {
        private String[] includedNames = new String[0];

        public InclusiveReflectionToStringBuilder(Object object) {
            super(object, (ToStringStyle)WITH_NEWLINES);
        }

        protected boolean accept(Field field) {
            if (!super.accept(field)) {
                return false;
            }
            if (this.includedNames.length == 0) {
                return true;
            }
            String fieldName = field.getName();
            for (String name : this.includedNames) {
                if (!fieldName.equals(name)) continue;
                return true;
            }
            return false;
        }

        protected void appendFieldsIn(Class<?> clazz) {
            if (clazz.isArray()) {
                super.appendFieldsIn(clazz);
                return;
            }
            if (this.includedNames.length == 0) {
                super.appendFieldsIn(clazz);
                return;
            }
            AccessibleObject[] fields = clazz.getDeclaredFields();
            AccessibleObject.setAccessible(fields, true);
            Map<String, Field> fieldsByName = Arrays.stream(fields).collect(Collectors.toMap(f -> f.getName(), f -> f));
            for (String name : this.includedNames) {
                Field field = fieldsByName.get(name);
                if (field == null || !this.accept(field)) continue;
                try {
                    Object fieldValue = this.getValue(field);
                    if (this.isExcludeNullValues() && fieldValue == null) continue;
                    this.append(name, fieldValue, !field.isAnnotationPresent(ToStringSummary.class));
                }
                catch (IllegalAccessException ex) {
                    throw new InternalError("Unexpected IllegalAccessException: " + ex.getMessage());
                }
            }
        }

        public ReflectionToStringBuilder setIncludeFieldNames(String ... includeFieldNamesParam) {
            this.includedNames = includeFieldNamesParam == null ? new String[0] : includeFieldNamesParam;
            return this;
        }
    }
}

