/*
 * Decompiled with CFR 0.152.
 */
package generic.test;

import org.junit.runners.model.Statement;
import utilities.util.reflection.ReflectionUtilities;

public class TestThread
extends Thread {
    private static final String SUN_PACKAGE = "sun.";
    private static final String JAVA_LANG_PACKAGE = "java.lang";
    private static final String JAVA_AWT_EVENT_PACKAGE = "java.awt.EventQueue";
    private static final String JUNIT_FRAMEWORK_PACKAGE = "junit.framework";
    private static final String JUNIT_ORG_PACKAGE = "org.junit";
    private static final String MOCKIT_JUNIT_PACKAGE = "mockit.integration.junit";
    private static final String GHIDRA_SWING_RUNNER = "ExceptionHandlingRunner";
    public static final String NAME_PREFIX = "Test-";
    final Statement statement;
    volatile boolean finished = false;
    volatile Throwable exceptionFromTest = null;

    public static boolean isTestThread() {
        return TestThread.isTestThread(Thread.currentThread());
    }

    public static boolean isTestThread(Thread t) {
        return t.getName().startsWith(NAME_PREFIX);
    }

    public static boolean isTestThreadName(String name) {
        return name.startsWith(NAME_PREFIX);
    }

    public static StackTraceElement[] filterTrace(StackTraceElement[] trace) {
        StackTraceElement[] filtered = ReflectionUtilities.filterStackTrace((StackTraceElement[])trace, (String[])new String[]{JUNIT_ORG_PACKAGE, JUNIT_FRAMEWORK_PACKAGE, MOCKIT_JUNIT_PACKAGE, JAVA_AWT_EVENT_PACKAGE, JAVA_LANG_PACKAGE, SUN_PACKAGE, GHIDRA_SWING_RUNNER});
        return filtered;
    }

    TestThread(Statement statement) {
        this.statement = statement;
        String defaultName = this.getName();
        this.setName(NAME_PREFIX + defaultName);
    }

    @Override
    public void run() {
        try {
            this.statement.evaluate();
        }
        catch (InterruptedException interruptedException) {
        }
        catch (Throwable e) {
            this.exceptionFromTest = e;
        }
        finally {
            this.finished = true;
        }
    }
}

