/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.graph.attributes;

import ghidra.util.graph.KeyIndexableSet;
import ghidra.util.graph.KeyedObject;

public abstract class Attribute<T extends KeyedObject> {
    private final KeyIndexableSet<T> owningSet;
    private final String attributeName;
    private long modificationNumber;
    private long backingSetModificationNumber;

    public Attribute(String name, KeyIndexableSet<T> set) {
        this.owningSet = set;
        this.attributeName = name;
        this.modificationNumber = 0L;
        this.backingSetModificationNumber = set.getModificationNumber();
    }

    void update() {
        ++this.modificationNumber;
    }

    boolean owningSetIsUnmodified() {
        return this.backingSetModificationNumber == this.owningSet.getModificationNumber();
    }

    public long getModificationNumber() {
        return this.modificationNumber;
    }

    public String name() {
        return this.attributeName;
    }

    public KeyIndexableSet<T> owningSet() {
        return this.owningSet;
    }

    public abstract String attributeType();

    public abstract String getValueAsString(KeyedObject var1);

    public abstract void clear();
}

