/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.emulation;

import ghidra.pcode.emulate.Emulate;
import ghidra.pcode.emulate.EmulateInstructionStateModifier;
import ghidra.pcode.emulate.callother.OpBehaviorOther;
import ghidra.pcode.error.LowlevelError;
import ghidra.pcode.memstate.MemoryState;
import ghidra.program.model.pcode.Varnode;
import java.math.BigInteger;

public class AARCH64EmulateInstructionStateModifier
extends EmulateInstructionStateModifier {
    public AARCH64EmulateInstructionStateModifier(Emulate emu) {
        super(emu);
        this.registerPcodeOpBehavior("MP_INT_ABS", new MP_INT_ABS(this));
        this.registerPcodeOpBehavior("MP_INT_RIGHT", new MP_INT_RIGHT(this));
        this.registerPcodeOpBehavior("MP_INT_MULT", new MP_INT_MULT(this));
        this.registerPcodeOpBehavior("MP_INT_UMULT", new MP_INT_UMULT(this));
        this.registerPcodeOpBehavior("SIMD_PIECE", new SIMD_PIECE(this));
        this.registerPcodeOpBehavior("a64_TBL", new a64_TBL(this));
    }

    private long getmask(long esize) {
        long mask = -1L;
        if (esize < 8L) {
            mask >>>= (int)((8L - esize) * 8L);
        }
        return mask;
    }

    private float shortBitsToFloat(long x) {
        long sign = x >>> 15 & 1L;
        long exp = x >>> 10 & 0x8FL;
        long mant = (x & 0x3FFL) << 13;
        return Float.intBitsToFloat((int)(sign << 31 | exp << 23 | mant));
    }

    private long floatToShortBits(float x) {
        long fbits = Float.floatToIntBits(x);
        long sign = fbits >>> 31 & 1L;
        long exp = fbits >>> 23 & 0x8FL;
        long mant = (fbits & 0x7FFFFFL) >>> 13;
        return sign << 15 | exp << 10 | mant;
    }

    protected long bytes_to_long(byte[] bytes, int lsb, int esize) {
        if (lsb <= 0) {
            return 0L;
        }
        int i = lsb - esize;
        if (i < 0) {
            i = 0;
        }
        long result = bytes[i];
        ++i;
        while (i < lsb) {
            result <<= 8;
            result |= (long)(bytes[i] & 0xFF);
            ++i;
        }
        return result;
    }

    protected void insert_long(long value, byte[] outBytes, int lsb, int esize) {
        if (lsb - esize < 0) {
            throw new LowlevelError("insert_long: byte array too small");
        }
        for (int j = 0; j < esize; ++j) {
            outBytes[lsb - j - 1] = (byte)(value & 0xFFL);
            value >>= 8;
        }
    }

    protected byte[] varnode_to_bytes(Varnode outputVarnode, byte[] initBytes, int esize) {
        byte[] outBytes = new byte[outputVarnode.getSize()];
        if (initBytes == null) {
            return outBytes;
        }
        byte ext = 0;
        int i = outBytes.length;
        int j = initBytes.length;
        while (i > 0) {
            if (j > 0) {
                outBytes[i - 1] = initBytes[j - 1];
                ext = (byte)(initBytes[j - 1] >= 0 ? 0 : 255);
            } else {
                outBytes[i - 1] = ext;
                if ((i - 1) % esize == 0) break;
            }
            --i;
            --j;
        }
        return outBytes;
    }

    private class MP_INT_ABS
    implements OpBehaviorOther {
        private MP_INT_ABS(AARCH64EmulateInstructionStateModifier aARCH64EmulateInstructionStateModifier) {
        }

        public void evaluate(Emulate emu, Varnode outputVarnode, Varnode[] inputs) {
            int numArgs = inputs.length - 1;
            if (numArgs != 1) {
                throw new LowlevelError("MP_INT_ABS: requires 1 (Vn), got " + numArgs);
            }
            if (outputVarnode == null) {
                throw new LowlevelError("MP_INT_ABS: missing required output");
            }
            MemoryState memoryState = emu.getMemoryState();
            BigInteger op = memoryState.getBigInteger(inputs[1], true);
            BigInteger result = op.abs();
            memoryState.setValue(outputVarnode, result);
        }
    }

    private class MP_INT_RIGHT
    implements OpBehaviorOther {
        private MP_INT_RIGHT(AARCH64EmulateInstructionStateModifier aARCH64EmulateInstructionStateModifier) {
        }

        public void evaluate(Emulate emu, Varnode outputVarnode, Varnode[] inputs) {
            int numArgs = inputs.length - 1;
            if (numArgs != 2) {
                throw new LowlevelError("MP_INT_RIGHT: requires 2 (Vn, shift), got " + numArgs);
            }
            if (outputVarnode == null) {
                throw new LowlevelError("MP_INT_RIGHT: missing required output");
            }
            MemoryState memoryState = emu.getMemoryState();
            BigInteger value = memoryState.getBigInteger(inputs[1], false);
            int shift = (int)memoryState.getValue(inputs[2]);
            BigInteger result = value.shiftRight(shift);
            memoryState.setValue(outputVarnode, result);
        }
    }

    private class MP_INT_MULT
    implements OpBehaviorOther {
        private MP_INT_MULT(AARCH64EmulateInstructionStateModifier aARCH64EmulateInstructionStateModifier) {
        }

        public void evaluate(Emulate emu, Varnode outputVarnode, Varnode[] inputs) {
            int numArgs = inputs.length - 1;
            if (numArgs != 2) {
                throw new LowlevelError("MP_INT_MULT: requires 2 (Vm, Vn), got " + numArgs);
            }
            if (outputVarnode == null) {
                throw new LowlevelError("MP_INT_MULT: missing required output");
            }
            MemoryState memoryState = emu.getMemoryState();
            BigInteger value = memoryState.getBigInteger(inputs[1], true);
            BigInteger mult = memoryState.getBigInteger(inputs[2], true);
            BigInteger result = value.multiply(mult);
            memoryState.setValue(outputVarnode, result);
        }
    }

    private class MP_INT_UMULT
    implements OpBehaviorOther {
        private MP_INT_UMULT(AARCH64EmulateInstructionStateModifier aARCH64EmulateInstructionStateModifier) {
        }

        public void evaluate(Emulate emu, Varnode outputVarnode, Varnode[] inputs) {
            int numArgs = inputs.length - 1;
            if (numArgs != 2) {
                throw new LowlevelError("MP_INT_UMULT: requires 2 (Vm, Vn), got " + numArgs);
            }
            if (outputVarnode == null) {
                throw new LowlevelError("MP_INT_UMULT: missing required output");
            }
            MemoryState memoryState = emu.getMemoryState();
            BigInteger value = memoryState.getBigInteger(inputs[1], false);
            BigInteger mult = memoryState.getBigInteger(inputs[2], false);
            BigInteger result = value.multiply(mult);
            memoryState.setValue(outputVarnode, result);
        }
    }

    private class SIMD_PIECE
    implements OpBehaviorOther {
        private SIMD_PIECE(AARCH64EmulateInstructionStateModifier aARCH64EmulateInstructionStateModifier) {
        }

        public void evaluate(Emulate emu, Varnode outputVarnode, Varnode[] inputs) {
            int numArgs = inputs.length - 1;
            if (numArgs != 2) {
                throw new LowlevelError("SIMD_PIECE: requires 2 inputs, got " + numArgs);
            }
            if (outputVarnode == null) {
                throw new LowlevelError("SIMD_PIECE: missing required output");
            }
            MemoryState memoryState = emu.getMemoryState();
            Varnode simdVarnode = inputs[1];
            int offset = (int)memoryState.getValue(inputs[2]);
            if (simdVarnode.getSize() < (offset + 1) * outputVarnode.getSize()) {
                throw new LowlevelError("SIMD_PIECE: input size (" + simdVarnode.getSize() + ") too small to extract output size (" + outputVarnode.getSize() + ") from offset (" + offset + ")");
            }
            int outSize = outputVarnode.getSize();
            byte[] outBytes = new byte[outSize];
            byte[] simdBytes = memoryState.getBigInteger(simdVarnode, false).toByteArray();
            byte ext = 0;
            int i = outSize - 1;
            int j = simdBytes.length - 1 - outSize * offset;
            while (i >= 0) {
                if (j >= 0) {
                    outBytes[i] = simdBytes[j];
                    ext = (byte)(simdBytes[j] < 0 ? -1 : 0);
                } else {
                    outBytes[i] = ext;
                }
                --i;
                --j;
            }
            memoryState.setValue(outputVarnode, new BigInteger(outBytes));
        }
    }

    private class a64_TBL
    implements OpBehaviorOther {
        private a64_TBL(AARCH64EmulateInstructionStateModifier aARCH64EmulateInstructionStateModifier) {
        }

        public void evaluate(Emulate emu, Varnode outputVarnode, Varnode[] inputs) {
            int i;
            int j;
            int numArgs = inputs.length - 1;
            if (numArgs < 3 || numArgs > 6) {
                throw new LowlevelError("a64_TBL: requires 3 to 6 inputs (Vinit, Vn-Vn4, Vm), got " + numArgs);
            }
            if (outputVarnode == null) {
                throw new LowlevelError("a64_TBL: missing required output");
            }
            MemoryState memoryState = emu.getMemoryState();
            Varnode updateVarnode = inputs[1];
            Varnode indexVarnode = inputs[numArgs];
            if (outputVarnode.getSize() != indexVarnode.getSize()) {
                throw new LowlevelError("a64_TBL: the output size (" + outputVarnode.getSize() + ") must match the index size (" + indexVarnode.getSize() + ")");
            }
            int regs = numArgs - 2;
            int elements = outputVarnode.getSize();
            byte[] indices = new byte[elements];
            byte[] vx = memoryState.getBigInteger(indexVarnode, false).toByteArray();
            for (int j2 = 0; j2 < vx.length && j2 < elements; ++j2) {
                indices[j2] = vx[vx.length - j2 - 1];
            }
            byte[] table = new byte[64];
            for (int i2 = 0; i2 < regs; ++i2) {
                byte[] vn = memoryState.getBigInteger(inputs[2 + i2], false).toByteArray();
                for (j = 0; j < vn.length && i2 * 16 + j < 64; ++j) {
                    table[i2 * 16 + j] = vn[vn.length - j - 1];
                }
            }
            byte[] result = new byte[elements];
            byte[] vi = memoryState.getBigInteger(updateVarnode, false).toByteArray();
            for (j = 0; j < vi.length && j < elements; ++j) {
                result[j] = vi[vi.length - j - 1];
            }
            for (i = 0; i < elements; ++i) {
                int index = indices[i] & 0xFF;
                if (index >= 16 * regs) continue;
                result[i] = table[index];
            }
            for (i = 0; i < elements / 2; ++i) {
                byte tmp = result[i];
                result[i] = result[elements - i - 1];
                result[elements - i - 1] = tmp;
            }
            memoryState.setValue(outputVarnode, new BigInteger(result));
        }
    }

    private class a64_CONCAT
    implements OpBehaviorOther {
        private a64_CONCAT(AARCH64EmulateInstructionStateModifier aARCH64EmulateInstructionStateModifier) {
        }

        public void evaluate(Emulate emu, Varnode outputVarnode, Varnode[] inputs) {
            int j;
            int numArgs = inputs.length - 1;
            if (numArgs != 2) {
                throw new LowlevelError(this.getClass().getName() + ": requires 2 inputs (Vn, Vm), got " + numArgs);
            }
            if (outputVarnode == null) {
                throw new LowlevelError(this.getClass().getName() + ": missing required output");
            }
            MemoryState memoryState = emu.getMemoryState();
            int outSize = outputVarnode.getSize();
            Varnode VnVarnode = inputs[1];
            Varnode VmVarnode = inputs[2];
            if (outSize != VnVarnode.getSize() + VmVarnode.getSize()) {
                throw new LowlevelError(this.getClass().getName() + ": output size (" + outSize + ") must equal the sum of input sizes (" + VnVarnode.getSize() + "," + VmVarnode.getSize() + ")");
            }
            byte[] outBytes = new byte[outSize];
            byte[] VnBytes = memoryState.getBigInteger(VnVarnode, false).toByteArray();
            byte[] VmBytes = memoryState.getBigInteger(VmVarnode, false).toByteArray();
            int i = outSize - 1;
            for (j = VnBytes.length - 1; i >= 0 && j >= 0; --i, --j) {
                outBytes[i] = VnBytes[j];
            }
            i = outSize - VnVarnode.getSize() - 1;
            for (j = VmBytes.length - 1; i >= 0 && j >= 0; --i, --j) {
                outBytes[i] = VmBytes[j];
            }
        }
    }

    private class SIMD_FLOAT_ROUND
    extends SIMD_UOP1E {
        private SIMD_FLOAT_ROUND() {
        }

        @Override
        protected long op1e(long x, int s_size, int d_size) {
            if (s_size == 2) {
                float fx = AARCH64EmulateInstructionStateModifier.this.shortBitsToFloat(x);
                return (long)fx;
            }
            if (s_size == 4) {
                float fx = Float.intBitsToFloat((int)x);
                return (long)fx;
            }
            if (s_size == 8) {
                double fx = Double.longBitsToDouble(x);
                return (long)fx;
            }
            return 0L;
        }
    }

    private class SIMD_TRUNC
    extends SIMD_UOP1E {
        private SIMD_TRUNC() {
        }

        @Override
        protected long op1e(long x, int s_size, int d_size) {
            if (s_size == d_size) {
                return x;
            }
            if (s_size == 2) {
                float fx = AARCH64EmulateInstructionStateModifier.this.shortBitsToFloat(x);
                if (d_size == 4) {
                    return (int)fx;
                }
                if (d_size == 8) {
                    return (long)fx;
                }
            } else if (s_size == 4) {
                float fx = Float.intBitsToFloat((int)x);
                if (d_size == 2) {
                    return (short)fx;
                }
                if (d_size == 8) {
                    return (long)fx;
                }
            } else if (s_size == 8) {
                double fx = Double.longBitsToDouble(x);
                if (d_size == 2) {
                    return (short)fx;
                }
                if (d_size == 4) {
                    return (int)fx;
                }
            }
            return x;
        }
    }

    private class SIMD_FLOAT2FLOAT
    extends SIMD_UOP1E {
        private SIMD_FLOAT2FLOAT() {
        }

        @Override
        protected long op1e(long x, int s_size, int d_size) {
            if (s_size == d_size) {
                return x;
            }
            if (s_size == 2) {
                float fx = AARCH64EmulateInstructionStateModifier.this.shortBitsToFloat(x);
                if (d_size == 4) {
                    return Float.floatToIntBits(fx);
                }
                if (d_size == 8) {
                    return Double.doubleToLongBits(fx);
                }
            } else if (s_size == 4) {
                float fx = Float.intBitsToFloat((int)x);
                if (d_size == 2) {
                    return AARCH64EmulateInstructionStateModifier.this.floatToShortBits(fx);
                }
                if (d_size == 8) {
                    return Double.doubleToLongBits(fx);
                }
            } else if (s_size == 8) {
                double fx = Double.longBitsToDouble(x);
                if (d_size == 2) {
                    return AARCH64EmulateInstructionStateModifier.this.floatToShortBits((float)fx);
                }
                if (d_size == 4) {
                    return Float.floatToIntBits((float)fx);
                }
            }
            return x;
        }
    }

    private class SIMD_FLOAT_ABS
    extends SIMD_UOP1 {
        private SIMD_FLOAT_ABS() {
        }

        @Override
        protected long op1(long x, int esize) {
            if (esize == 2) {
                float fx = AARCH64EmulateInstructionStateModifier.this.shortBitsToFloat(x);
                float fz = fx < 0.0f ? 0.0f - fx : fx;
                return AARCH64EmulateInstructionStateModifier.this.floatToShortBits(fz);
            }
            if (esize == 4) {
                float fx = Float.intBitsToFloat((int)x);
                float fz = fx < 0.0f ? 0.0f - fx : fx;
                return Float.floatToIntBits(fz);
            }
            if (esize == 8) {
                double fx = Double.longBitsToDouble(x);
                double fz = fx < 0.0 ? 0.0 - fx : fx;
                return Double.doubleToLongBits(fz);
            }
            return 0L;
        }
    }

    private class SIMD_FLOAT_NEG
    extends SIMD_UOP1 {
        private SIMD_FLOAT_NEG() {
        }

        @Override
        protected long op1(long x, int esize) {
            if (esize == 2) {
                float fx = AARCH64EmulateInstructionStateModifier.this.shortBitsToFloat(x);
                float fz = -fx;
                return AARCH64EmulateInstructionStateModifier.this.floatToShortBits(fz);
            }
            if (esize == 4) {
                float fx = Float.intBitsToFloat((int)x);
                float fz = -fx;
                return Float.floatToIntBits(fz);
            }
            if (esize == 8) {
                double fx = Double.longBitsToDouble(x);
                double fz = -fx;
                return Double.doubleToLongBits(fz);
            }
            return 0L;
        }
    }

    private class SIMD_FLOAT_SUB
    extends SIMD_UOP2 {
        private SIMD_FLOAT_SUB() {
        }

        @Override
        protected long op2(long x, long y, int esize) {
            if (esize == 2) {
                float fx = AARCH64EmulateInstructionStateModifier.this.shortBitsToFloat(x);
                float fy = AARCH64EmulateInstructionStateModifier.this.shortBitsToFloat(y);
                float fz = fx - fy;
                return AARCH64EmulateInstructionStateModifier.this.floatToShortBits(fz);
            }
            if (esize == 4) {
                float fx = Float.intBitsToFloat((int)x);
                float fy = Float.intBitsToFloat((int)y);
                float fz = fx - fy;
                return Float.floatToIntBits(fz);
            }
            if (esize == 8) {
                double fx = Double.longBitsToDouble(x);
                double fy = Double.longBitsToDouble(y);
                double fz = fx - fy;
                return Double.doubleToLongBits(fz);
            }
            return 0L;
        }
    }

    private class SIMD_FLOAT_MULT
    extends SIMD_UOP2 {
        private SIMD_FLOAT_MULT() {
        }

        @Override
        protected long op2(long x, long y, int esize) {
            if (esize == 2) {
                float fx = AARCH64EmulateInstructionStateModifier.this.shortBitsToFloat(x);
                float fy = AARCH64EmulateInstructionStateModifier.this.shortBitsToFloat(y);
                float fz = fx * fy;
                return AARCH64EmulateInstructionStateModifier.this.floatToShortBits(fz);
            }
            if (esize == 4) {
                float fx = Float.intBitsToFloat((int)x);
                float fy = Float.intBitsToFloat((int)y);
                float fz = fx * fy;
                return Float.floatToIntBits(fz);
            }
            if (esize == 8) {
                double fx = Double.longBitsToDouble(x);
                double fy = Double.longBitsToDouble(y);
                double fz = fx * fy;
                return Double.doubleToLongBits(fz);
            }
            return 0L;
        }
    }

    private class SIMD_FLOAT_DIV
    extends SIMD_UOP2 {
        private SIMD_FLOAT_DIV() {
        }

        @Override
        protected long op2(long x, long y, int esize) {
            if (esize == 2) {
                float fx = AARCH64EmulateInstructionStateModifier.this.shortBitsToFloat(x);
                float fy = AARCH64EmulateInstructionStateModifier.this.shortBitsToFloat(y);
                float fz = fx / fy;
                return AARCH64EmulateInstructionStateModifier.this.floatToShortBits(fz);
            }
            if (esize == 4) {
                float fx = Float.intBitsToFloat((int)x);
                float fy = Float.intBitsToFloat((int)y);
                float fz = fx / fy;
                return Float.floatToIntBits(fz);
            }
            if (esize == 8) {
                double fx = Double.longBitsToDouble(x);
                double fy = Double.longBitsToDouble(y);
                double fz = fx / fy;
                return Double.doubleToLongBits(fz);
            }
            return 0L;
        }
    }

    private class SIPD_FLOAT_ADD
    extends SIPD_UOP2 {
        private SIPD_FLOAT_ADD() {
        }

        @Override
        protected long op2(long x, long y, int iesize, int oesize) {
            if (iesize == 2) {
                float fx = AARCH64EmulateInstructionStateModifier.this.shortBitsToFloat(x);
                float fy = AARCH64EmulateInstructionStateModifier.this.shortBitsToFloat(y);
                float fz = fx + fy;
                if (oesize == 2) {
                    return AARCH64EmulateInstructionStateModifier.this.floatToShortBits(fz);
                }
                if (oesize == 4) {
                    return Float.floatToIntBits(fz);
                }
                if (oesize == 8) {
                    return Double.doubleToLongBits(fz);
                }
            } else if (iesize == 4) {
                float fx = Float.intBitsToFloat((int)x);
                float fy = Float.intBitsToFloat((int)y);
                float fz = fx + fy;
                if (oesize == 2) {
                    return AARCH64EmulateInstructionStateModifier.this.floatToShortBits(fz);
                }
                if (oesize == 4) {
                    return Float.floatToIntBits(fz);
                }
                if (oesize == 8) {
                    return Double.doubleToLongBits(fz);
                }
            } else if (iesize == 8) {
                double fx = Double.longBitsToDouble(x);
                double fy = Double.longBitsToDouble(y);
                double fz = fx + fy;
                if (oesize == 2) {
                    return AARCH64EmulateInstructionStateModifier.this.floatToShortBits((float)fz);
                }
                if (oesize == 4) {
                    return Float.floatToIntBits((float)fz);
                }
                if (oesize == 8) {
                    return Double.doubleToLongBits(fz);
                }
            }
            return 0L;
        }
    }

    private class SIMD_FLOAT_ADD
    extends SIMD_UOP2 {
        private SIMD_FLOAT_ADD() {
        }

        @Override
        protected long op2(long x, long y, int esize) {
            if (esize == 2) {
                float fx = AARCH64EmulateInstructionStateModifier.this.shortBitsToFloat(x);
                float fy = AARCH64EmulateInstructionStateModifier.this.shortBitsToFloat(y);
                float fz = fx + fy;
                return AARCH64EmulateInstructionStateModifier.this.floatToShortBits(fz);
            }
            if (esize == 4) {
                float fx = Float.intBitsToFloat((int)x);
                float fy = Float.intBitsToFloat((int)y);
                float fz = fx + fy;
                return Float.floatToIntBits(fz);
            }
            if (esize == 8) {
                double fx = Double.longBitsToDouble(x);
                double fy = Double.longBitsToDouble(y);
                double fz = fx + fy;
                return Double.doubleToLongBits(fz);
            }
            return 0L;
        }
    }

    private class SIMD_INT_MULT
    extends SIMD_SOP2 {
        private SIMD_INT_MULT(AARCH64EmulateInstructionStateModifier aARCH64EmulateInstructionStateModifier) {
        }

        @Override
        protected long op2(long x, long y, int esize) {
            return x * y;
        }
    }

    private class SIMD_INT_SRIGHT
    extends SIMD_UOP2 {
        private SIMD_INT_SRIGHT(AARCH64EmulateInstructionStateModifier aARCH64EmulateInstructionStateModifier) {
        }

        @Override
        protected long op2(long x, long y, int esize) {
            return x >> (int)y;
        }
    }

    private class SIMD_INT_RIGHT
    extends SIMD_SOP2 {
        private SIMD_INT_RIGHT(AARCH64EmulateInstructionStateModifier aARCH64EmulateInstructionStateModifier) {
        }

        @Override
        protected long op2(long x, long y, int esize) {
            return x >>> (int)y;
        }
    }

    private class SIMD_INT_LEFT
    extends SIMD_UOP2 {
        private SIMD_INT_LEFT(AARCH64EmulateInstructionStateModifier aARCH64EmulateInstructionStateModifier) {
        }

        @Override
        protected long op2(long x, long y, int esize) {
            return x << (int)y;
        }
    }

    private class SIMD_INT_OR
    extends SIMD_UOP2 {
        private SIMD_INT_OR(AARCH64EmulateInstructionStateModifier aARCH64EmulateInstructionStateModifier) {
        }

        @Override
        protected long op2(long x, long y, int esize) {
            return x | y;
        }
    }

    private class SIMD_INT_AND
    extends SIMD_UOP2 {
        private SIMD_INT_AND(AARCH64EmulateInstructionStateModifier aARCH64EmulateInstructionStateModifier) {
        }

        @Override
        protected long op2(long x, long y, int esize) {
            return x & y;
        }
    }

    private class SIMD_INT_XOR
    extends SIMD_UOP2 {
        private SIMD_INT_XOR(AARCH64EmulateInstructionStateModifier aARCH64EmulateInstructionStateModifier) {
        }

        @Override
        protected long op2(long x, long y, int esize) {
            return x ^ y;
        }
    }

    private class MP_INT_AND
    implements OpBehaviorOther {
        private MP_INT_AND(AARCH64EmulateInstructionStateModifier aARCH64EmulateInstructionStateModifier) {
        }

        public void evaluate(Emulate emu, Varnode outputVarnode, Varnode[] inputs) {
            int numArgs = inputs.length - 1;
            if (numArgs != 2) {
                throw new LowlevelError("MP_INT_AND: requires 2 (Vm, Vn), got " + numArgs);
            }
            if (outputVarnode == null) {
                throw new LowlevelError("MP_INT_AND: missing required output");
            }
            MemoryState memoryState = emu.getMemoryState();
            BigInteger value = memoryState.getBigInteger(inputs[1], false);
            BigInteger mask = memoryState.getBigInteger(inputs[2], false);
            BigInteger result = value.and(mask);
            memoryState.setValue(outputVarnode, result);
        }
    }

    private class SIMD_INT_NEGATE
    extends SIMD_UOP1 {
        private SIMD_INT_NEGATE(AARCH64EmulateInstructionStateModifier aARCH64EmulateInstructionStateModifier) {
        }

        @Override
        protected long op1(long x, int esize) {
            return x ^ 0xFFFFFFFFFFFFFFFFL;
        }
    }

    private class MP_INT_NEGATE
    implements OpBehaviorOther {
        private MP_INT_NEGATE(AARCH64EmulateInstructionStateModifier aARCH64EmulateInstructionStateModifier) {
        }

        public void evaluate(Emulate emu, Varnode outputVarnode, Varnode[] inputs) {
            int numArgs = inputs.length - 1;
            if (numArgs != 1) {
                throw new LowlevelError("MP_INT_NEGATE: requires 1 (Vn), got " + numArgs);
            }
            if (outputVarnode == null) {
                throw new LowlevelError("MP_INT_NEGATE: missing required output");
            }
            MemoryState memoryState = emu.getMemoryState();
            byte[] value = memoryState.getBigInteger(inputs[1], true).toByteArray();
            int outSize = outputVarnode.getSize();
            byte[] result = new byte[outSize];
            int i = outSize - 1;
            int j = value.length - 1;
            while (i >= 0) {
                result[i] = j >= 0 ? (int)(~value[j] & 0xFF) : -1;
                --i;
                --j;
            }
            memoryState.setValue(outputVarnode, new BigInteger(result));
        }
    }

    private class SIMD_INT_2COMP
    extends SIMD_SOP1 {
        private SIMD_INT_2COMP(AARCH64EmulateInstructionStateModifier aARCH64EmulateInstructionStateModifier) {
        }

        @Override
        protected long op1(long x, int esize) {
            return -x;
        }
    }

    private class SIMD_INT_SUB
    extends SIMD_SOP2 {
        private SIMD_INT_SUB(AARCH64EmulateInstructionStateModifier aARCH64EmulateInstructionStateModifier) {
        }

        @Override
        protected long op2(long x, long y, int esize) {
            return x - y;
        }
    }

    private class SIPD_INT_ADD
    extends SIPD_SOP2 {
        private SIPD_INT_ADD(AARCH64EmulateInstructionStateModifier aARCH64EmulateInstructionStateModifier) {
        }

        @Override
        protected long op2(long x, long y, int iesize, int oesize) {
            return x + y;
        }
    }

    private class SIMD_INT_ADD
    extends SIMD_SOP2 {
        private SIMD_INT_ADD(AARCH64EmulateInstructionStateModifier aARCH64EmulateInstructionStateModifier) {
        }

        @Override
        protected long op2(long x, long y, int esize) {
            return x + y;
        }
    }

    private class SIMD_INT_ABS
    extends SIMD_SOP1 {
        private SIMD_INT_ABS(AARCH64EmulateInstructionStateModifier aARCH64EmulateInstructionStateModifier) {
        }

        @Override
        protected long op1(long x, int esize) {
            return x < 0L ? -x : x;
        }
    }

    private class SIMD_INT_SEXT
    extends SIMD_SOP1E {
        private SIMD_INT_SEXT() {
        }

        @Override
        protected long op1e(long x, int s_size, int d_size) {
            return x & AARCH64EmulateInstructionStateModifier.this.getmask(d_size);
        }
    }

    private class SIMD_INT_ZEXT
    extends SIMD_UOP1E {
        private SIMD_INT_ZEXT() {
        }

        @Override
        protected long op1e(long x, int s_size, int d_size) {
            return x & AARCH64EmulateInstructionStateModifier.this.getmask(s_size) & AARCH64EmulateInstructionStateModifier.this.getmask(d_size);
        }
    }

    private class MP_INT_EQUAL
    implements OpBehaviorOther {
        private MP_INT_EQUAL(AARCH64EmulateInstructionStateModifier aARCH64EmulateInstructionStateModifier) {
        }

        public void evaluate(Emulate emu, Varnode outputVarnode, Varnode[] inputs) {
            BigInteger cmp2;
            int numArgs = inputs.length - 1;
            if (numArgs != 2) {
                throw new LowlevelError("MP_INT_EQUAL: requires 2 (Vm, Vn), got " + numArgs);
            }
            if (outputVarnode == null) {
                throw new LowlevelError("MP_INT_EQUAL: missing required output");
            }
            MemoryState memoryState = emu.getMemoryState();
            BigInteger cmp1 = memoryState.getBigInteger(inputs[1], false);
            BigInteger result = cmp1.compareTo(cmp2 = memoryState.getBigInteger(inputs[2], false)) == 0 ? BigInteger.ONE : BigInteger.ZERO;
            memoryState.setValue(outputVarnode, result);
        }
    }

    private class SIMD_COPY
    implements OpBehaviorOther {
        private SIMD_COPY(AARCH64EmulateInstructionStateModifier aARCH64EmulateInstructionStateModifier) {
        }

        public void evaluate(Emulate emu, Varnode outputVarnode, Varnode[] inputs) {
            int numArgs = inputs.length - 1;
            if (numArgs != 2 && numArgs != 3) {
                throw new LowlevelError("SIMD_COPY: requires 2 or 3 inputs, got " + numArgs);
            }
            if (outputVarnode == null) {
                throw new LowlevelError("SIMD_COPY: missing required output");
            }
            MemoryState memoryState = emu.getMemoryState();
            Varnode initVarnode = inputs[1];
            Varnode valueVarnode = inputs[2];
            int offset = -1;
            if (numArgs == 3) {
                offset = (int)memoryState.getValue(inputs[3]);
            }
            if (outputVarnode.getSize() < initVarnode.getSize()) {
                throw new LowlevelError("SIMD_COPY: output size (" + outputVarnode.getSize() + ") is smaller than the init size (" + initVarnode.getSize() + ")");
            }
            if (offset >= 0) {
                if (outputVarnode.getSize() < offset + valueVarnode.getSize()) {
                    throw new LowlevelError("SIMD_COPY: output size (" + outputVarnode.getSize() + ") too small to copy input size (" + valueVarnode.getSize() + ") to offset (" + offset + ")");
                }
            } else if (outputVarnode.getSize() < valueVarnode.getSize() || outputVarnode.getSize() % valueVarnode.getSize() != 0) {
                throw new LowlevelError("SIMD_COPY: output size (" + outputVarnode.getSize() + ") must be multiple of input size (" + valueVarnode.getSize() + ")");
            }
            int outSize = outputVarnode.getSize();
            byte[] outBytes = new byte[outSize];
            byte[] initBytes = memoryState.getBigInteger(initVarnode, false).toByteArray();
            for (int i = 0; i < initBytes.length && i < outSize; ++i) {
                outBytes[outSize - 1 - i] = initBytes[initBytes.length - 1 - i];
            }
            int valueSize = valueVarnode.getSize();
            byte[] copyBytes = new byte[valueSize];
            byte[] valueBytes = memoryState.getBigInteger(valueVarnode, false).toByteArray();
            byte ext = 0;
            int i = valueSize - 1;
            int j = valueBytes.length - 1;
            while (i >= 0) {
                if (j >= 0) {
                    copyBytes[i] = valueBytes[j];
                    ext = (byte)(valueBytes[j] < 0 ? -1 : 0);
                } else {
                    copyBytes[i] = ext;
                }
                --i;
                --j;
            }
            for (int i2 = 0; i2 < valueSize; ++i2) {
                if (offset >= 0) {
                    outBytes[outSize - offset * valueSize - valueSize + i2] = copyBytes[i2];
                    continue;
                }
                int offs = 0;
                while (offs * valueSize < outSize) {
                    outBytes[outSize - offs * valueSize - valueSize + i2] = copyBytes[i2];
                    ++offs;
                }
            }
            memoryState.setValue(outputVarnode, new BigInteger(outBytes));
        }
    }

    private abstract class SIPD_UOP2
    extends SIPD_OP2 {
        private SIPD_UOP2() {
            super(AARCH64EmulateInstructionStateModifier.this);
        }

        public void evaluate(Emulate emu, Varnode outputVarnode, Varnode[] inputs) {
            int pi;
            int i;
            this.check_args(emu, outputVarnode, inputs);
            MemoryState memoryState = emu.getMemoryState();
            int numArgs = inputs.length - 1;
            Varnode p1Varnode = inputs[1];
            int isize = p1Varnode.getSize();
            Varnode p2Varnode = null;
            if (numArgs == 3) {
                p2Varnode = inputs[2];
                isize += p2Varnode.getSize();
            }
            int iesize = (int)memoryState.getValue(inputs[numArgs]);
            int osize = outputVarnode.getSize();
            int oesize = iesize * osize / isize;
            byte[] pairBytes = new byte[isize];
            if (p2Varnode != null) {
                byte[] p2Bytes = memoryState.getBigInteger(p2Varnode, false).toByteArray();
                i = p2Bytes.length;
                for (pi = pairBytes.length; i > 0 && pi > 0; --i, --pi) {
                    pairBytes[pi - 1] = p2Bytes[i - 1];
                }
            }
            byte[] p1Bytes = memoryState.getBigInteger(p1Varnode, false).toByteArray();
            i = p1Bytes.length;
            for (pi = p1Varnode.getSize(); i > 0 && pi > 0; --i, --pi) {
                pairBytes[pi - 1] = p1Bytes[i - 1];
            }
            byte[] outBytes = AARCH64EmulateInstructionStateModifier.this.varnode_to_bytes(outputVarnode, null, osize);
            int outLSB = outBytes.length;
            for (int opLSB = pairBytes.length; outLSB > 0 && opLSB > 0; outLSB -= oesize, opLSB -= iesize) {
                long arg1Lane = AARCH64EmulateInstructionStateModifier.this.bytes_to_long(pairBytes, opLSB, iesize);
                long arg2Lane = AARCH64EmulateInstructionStateModifier.this.bytes_to_long(pairBytes, opLSB - iesize, iesize);
                arg1Lane = this.op2(arg1Lane, arg2Lane, iesize, oesize);
                AARCH64EmulateInstructionStateModifier.this.insert_long(arg1Lane, outBytes, outLSB, oesize);
            }
            memoryState.setValue(outputVarnode, new BigInteger(outBytes));
        }
    }

    private abstract class SIPD_SOP2
    extends SIPD_OP2 {
        private SIPD_SOP2() {
            super(AARCH64EmulateInstructionStateModifier.this);
        }

        public void evaluate(Emulate emu, Varnode outputVarnode, Varnode[] inputs) {
            int pi;
            int i;
            this.check_args(emu, outputVarnode, inputs);
            MemoryState memoryState = emu.getMemoryState();
            int numArgs = inputs.length - 1;
            Varnode p1Varnode = inputs[1];
            int isize = p1Varnode.getSize();
            Varnode p2Varnode = null;
            if (numArgs == 3) {
                p2Varnode = inputs[2];
                isize += p2Varnode.getSize();
            }
            int iesize = (int)memoryState.getValue(inputs[numArgs]);
            int osize = outputVarnode.getSize();
            int oesize = iesize * osize / isize;
            byte[] pairBytes = new byte[isize];
            if (p2Varnode != null) {
                byte[] p2Bytes = memoryState.getBigInteger(p2Varnode, true).toByteArray();
                i = p2Bytes.length;
                for (pi = pairBytes.length; i > 0 && pi > 0; --i, --pi) {
                    pairBytes[pi - 1] = p2Bytes[i - 1];
                }
            }
            byte[] p1Bytes = memoryState.getBigInteger(p1Varnode, true).toByteArray();
            i = p1Bytes.length;
            for (pi = p1Varnode.getSize(); i > 0 && pi > 0; --i, --pi) {
                pairBytes[pi - 1] = p1Bytes[i - 1];
            }
            byte[] outBytes = AARCH64EmulateInstructionStateModifier.this.varnode_to_bytes(outputVarnode, null, osize);
            int outLSB = outBytes.length;
            for (int opLSB = pairBytes.length; outLSB > 0 && opLSB > 0; outLSB -= oesize, opLSB -= iesize) {
                long arg1Lane = AARCH64EmulateInstructionStateModifier.this.bytes_to_long(pairBytes, opLSB, iesize);
                long arg2Lane = AARCH64EmulateInstructionStateModifier.this.bytes_to_long(pairBytes, opLSB - iesize, iesize);
                arg1Lane = this.op2(arg1Lane, arg2Lane, iesize, oesize);
                AARCH64EmulateInstructionStateModifier.this.insert_long(arg1Lane, outBytes, outLSB, oesize);
            }
            memoryState.setValue(outputVarnode, new BigInteger(outBytes));
        }
    }

    private abstract class SIPD_OP2
    implements OpBehaviorOther {
        private SIPD_OP2(AARCH64EmulateInstructionStateModifier aARCH64EmulateInstructionStateModifier) {
        }

        protected abstract long op2(long var1, long var3, int var5, int var6);

        void check_args(Emulate emu, Varnode outputVarnode, Varnode[] inputs) {
            int numArgs = inputs.length - 1;
            if (numArgs != 2 && numArgs != 3) {
                throw new LowlevelError(this.getClass().getName() + ": requires 2 or 3 inputs (pairData*, esize), got " + numArgs);
            }
            if (outputVarnode == null) {
                throw new LowlevelError(this.getClass().getName() + ": missing required output");
            }
            MemoryState memoryState = emu.getMemoryState();
            Varnode p1Varnode = inputs[1];
            int isize = p1Varnode.getSize();
            Varnode p2Varnode = null;
            if (numArgs == 3) {
                p2Varnode = inputs[2];
                isize += p2Varnode.getSize();
            }
            int iesize = (int)memoryState.getValue(inputs[numArgs]);
            int osize = outputVarnode.getSize();
            int oesize = iesize * osize / isize;
            if (iesize != 1 && iesize != 2 && iesize != 4 && iesize != 8) {
                throw new LowlevelError(this.getClass().getName() + ": operand lanes must be 1, 2, 4, or 8 bytes: got " + iesize);
            }
            if (oesize != 1 && oesize != 2 && oesize != 4 && oesize != 8) {
                throw new LowlevelError(this.getClass().getName() + ": output lanes must be 1, 2, 4, or 8 bytes: got " + oesize);
            }
        }
    }

    private abstract class SIMD_UOP2
    extends SIMD_OP2 {
        private SIMD_UOP2() {
            super(AARCH64EmulateInstructionStateModifier.this);
        }

        public void evaluate(Emulate emu, Varnode outputVarnode, Varnode[] inputs) {
            this.check_args(emu, outputVarnode, inputs);
            MemoryState memoryState = emu.getMemoryState();
            Varnode simdVarnode = inputs[1];
            Varnode opVarnode = inputs[2];
            boolean opConstant = inputs.length == 3;
            int esize = opVarnode.getSize();
            if (!opConstant) {
                esize = (int)memoryState.getValue(inputs[3]);
            }
            int opstep = opConstant ? 0 : esize;
            byte[] simdBytes = memoryState.getBigInteger(simdVarnode, false).toByteArray();
            byte[] opBytes = memoryState.getBigInteger(opVarnode, false).toByteArray();
            byte[] outBytes = AARCH64EmulateInstructionStateModifier.this.varnode_to_bytes(outputVarnode, null, esize);
            int outLSB = outBytes.length;
            int simdLSB = simdBytes.length;
            int opLSB = opBytes.length;
            while (outLSB > 0) {
                long simdLane = AARCH64EmulateInstructionStateModifier.this.bytes_to_long(simdBytes, simdLSB, esize);
                long opLane = AARCH64EmulateInstructionStateModifier.this.bytes_to_long(opBytes, opLSB, esize);
                simdLane = this.op2(simdLane, opLane, esize);
                AARCH64EmulateInstructionStateModifier.this.insert_long(simdLane, outBytes, outLSB, esize);
                outLSB -= esize;
                simdLSB -= esize;
                opLSB -= opstep;
            }
            memoryState.setValue(outputVarnode, new BigInteger(outBytes));
        }
    }

    private abstract class SIMD_SOP2
    extends SIMD_OP2 {
        private SIMD_SOP2() {
            super(AARCH64EmulateInstructionStateModifier.this);
        }

        public void evaluate(Emulate emu, Varnode outputVarnode, Varnode[] inputs) {
            this.check_args(emu, outputVarnode, inputs);
            MemoryState memoryState = emu.getMemoryState();
            Varnode simdVarnode = inputs[1];
            Varnode opVarnode = inputs[2];
            boolean opConstant = inputs.length == 3;
            int esize = opVarnode.getSize();
            if (!opConstant) {
                esize = (int)memoryState.getValue(inputs[3]);
            }
            int opstep = opConstant ? 0 : esize;
            byte[] simdBytes = memoryState.getBigInteger(simdVarnode, true).toByteArray();
            byte[] opBytes = memoryState.getBigInteger(opVarnode, true).toByteArray();
            byte[] outBytes = AARCH64EmulateInstructionStateModifier.this.varnode_to_bytes(outputVarnode, null, esize);
            int outLSB = outBytes.length;
            int simdLSB = simdBytes.length;
            int opLSB = opBytes.length;
            while (outLSB > 0) {
                long simdLane = AARCH64EmulateInstructionStateModifier.this.bytes_to_long(simdBytes, simdLSB, esize);
                long opLane = AARCH64EmulateInstructionStateModifier.this.bytes_to_long(opBytes, opLSB, esize);
                simdLane = this.op2(simdLane, opLane, esize);
                AARCH64EmulateInstructionStateModifier.this.insert_long(simdLane, outBytes, outLSB, esize);
                outLSB -= esize;
                simdLSB -= esize;
                opLSB -= opstep;
            }
            memoryState.setValue(outputVarnode, new BigInteger(outBytes));
        }
    }

    private abstract class SIMD_OP2
    implements OpBehaviorOther {
        private SIMD_OP2(AARCH64EmulateInstructionStateModifier aARCH64EmulateInstructionStateModifier) {
        }

        protected abstract long op2(long var1, long var3, int var5);

        void check_args(Emulate emu, Varnode outputVarnode, Varnode[] inputs) {
            boolean opConstant;
            int numArgs = inputs.length - 1;
            if (numArgs != 2 && numArgs != 3) {
                throw new LowlevelError(this.getClass().getName() + ": requires 3 inputs (simd, op, esize), got " + numArgs);
            }
            if (outputVarnode == null) {
                throw new LowlevelError(this.getClass().getName() + ": missing required output");
            }
            MemoryState memoryState = emu.getMemoryState();
            Varnode simdVarnode = inputs[1];
            Varnode opVarnode = inputs[2];
            int esize = opVarnode.getSize();
            boolean bl = opConstant = numArgs == 2;
            if (!opConstant) {
                esize = (int)memoryState.getValue(inputs[3]);
            }
            if (outputVarnode.getSize() < simdVarnode.getSize()) {
                throw new LowlevelError(this.getClass().getName() + ": input size (" + simdVarnode.getSize() + ") exceeds output size (" + outputVarnode.getSize() + ")");
            }
            if (esize != 1 && esize != 2 && esize != 4 && esize != 8) {
                throw new LowlevelError(this.getClass().getName() + ": operand must be 1, 2, 4, or 8 bytes: got " + esize);
            }
            if (outputVarnode.getSize() % esize != 0) {
                throw new LowlevelError(this.getClass().getName() + ": output size (" + outputVarnode.getSize() + ") must be a multiple of operand size (" + esize + ")");
            }
            if (!opConstant && simdVarnode.getSize() != opVarnode.getSize()) {
                throw new LowlevelError(this.getClass().getName() + ": simd size (" + outputVarnode.getSize() + ") and operand size (" + esize + ") must be the same for simd operation");
            }
        }
    }

    private abstract class SIMD_UOP1E
    extends SIMD_OP1E {
        private SIMD_UOP1E() {
            super(AARCH64EmulateInstructionStateModifier.this);
        }

        public void evaluate(Emulate emu, Varnode outputVarnode, Varnode[] inputs) {
            this.check_args(emu, outputVarnode, inputs);
            MemoryState memoryState = emu.getMemoryState();
            Varnode simdVarnode = inputs[1];
            int s_size = (int)memoryState.getValue(inputs[2]);
            int d_size = s_size * outputVarnode.getSize() / simdVarnode.getSize();
            byte[] simdBytes = memoryState.getBigInteger(simdVarnode, false).toByteArray();
            byte[] outBytes = AARCH64EmulateInstructionStateModifier.this.varnode_to_bytes(outputVarnode, null, d_size);
            int outLSB = outBytes.length;
            int simdLSB = simdBytes.length;
            while (outLSB > 0) {
                long simdLane = AARCH64EmulateInstructionStateModifier.this.bytes_to_long(simdBytes, simdLSB, s_size);
                simdLane = this.op1e(simdLane, s_size, d_size);
                AARCH64EmulateInstructionStateModifier.this.insert_long(simdLane, outBytes, outLSB, d_size);
                outLSB -= d_size;
                simdLSB -= s_size;
            }
            memoryState.setValue(outputVarnode, new BigInteger(outBytes));
        }
    }

    private abstract class SIMD_SOP1E
    extends SIMD_OP1E {
        private SIMD_SOP1E() {
            super(AARCH64EmulateInstructionStateModifier.this);
        }

        public void evaluate(Emulate emu, Varnode outputVarnode, Varnode[] inputs) {
            this.check_args(emu, outputVarnode, inputs);
            MemoryState memoryState = emu.getMemoryState();
            Varnode simdVarnode = inputs[1];
            int s_size = (int)memoryState.getValue(inputs[2]);
            int d_size = s_size * outputVarnode.getSize() / simdVarnode.getSize();
            byte[] simdBytes = memoryState.getBigInteger(simdVarnode, true).toByteArray();
            byte[] outBytes = AARCH64EmulateInstructionStateModifier.this.varnode_to_bytes(outputVarnode, null, d_size);
            int outLSB = outBytes.length;
            int simdLSB = simdBytes.length;
            while (outLSB > 0) {
                long simdLane = AARCH64EmulateInstructionStateModifier.this.bytes_to_long(simdBytes, simdLSB, s_size);
                simdLane = this.op1e(simdLane, s_size, d_size);
                AARCH64EmulateInstructionStateModifier.this.insert_long(simdLane, outBytes, outLSB, d_size);
                outLSB -= d_size;
                simdLSB -= s_size;
            }
            memoryState.setValue(outputVarnode, new BigInteger(outBytes));
        }
    }

    private abstract class SIMD_OP1E
    implements OpBehaviorOther {
        private SIMD_OP1E(AARCH64EmulateInstructionStateModifier aARCH64EmulateInstructionStateModifier) {
        }

        protected abstract long op1e(long var1, int var3, int var4);

        void check_args(Emulate emu, Varnode outputVarnode, Varnode[] inputs) {
            int numArgs = inputs.length - 1;
            if (numArgs != 2) {
                throw new LowlevelError(this.getClass().getName() + ": requires 2 inputs (op, size), got " + numArgs);
            }
            if (outputVarnode == null) {
                throw new LowlevelError(this.getClass().getName() + ": missing required output");
            }
            MemoryState memoryState = emu.getMemoryState();
            Varnode simdVarnode = inputs[1];
            int s_size = (int)memoryState.getValue(inputs[2]);
            if (outputVarnode.getSize() != 2 * simdVarnode.getSize()) {
                throw new LowlevelError(this.getClass().getName() + ": input size (" + simdVarnode.getSize() + ") must be exactly half of the output size (" + outputVarnode.getSize() + ")");
            }
            if (s_size != 1 && s_size != 2 && s_size != 4 && s_size != 8) {
                throw new LowlevelError(this.getClass().getName() + ": input elements must be 1, 2, 4, or 8 bytes: got " + s_size);
            }
            int d_size = s_size * outputVarnode.getSize() / simdVarnode.getSize();
            if (d_size != 1 && d_size != 2 && d_size != 4 && d_size != 8) {
                throw new LowlevelError(this.getClass().getName() + ": the output elements must be 1, 2, 4, or 8 bytes: got " + d_size);
            }
            if (simdVarnode.getSize() % s_size != 0) {
                throw new LowlevelError(this.getClass().getName() + ": input size (" + simdVarnode.getSize() + ") must be a multiple of input element size (" + s_size + ")");
            }
            if (outputVarnode.getSize() % d_size != 0) {
                throw new LowlevelError(this.getClass().getName() + ": output size (" + simdVarnode.getSize() + ") must be a multiple of output element size (" + d_size + ")");
            }
        }
    }

    private abstract class SIMD_UOP1
    extends SIMD_OP1 {
        private SIMD_UOP1() {
            super(AARCH64EmulateInstructionStateModifier.this);
        }

        public void evaluate(Emulate emu, Varnode outputVarnode, Varnode[] inputs) {
            this.check_args(emu, outputVarnode, inputs);
            MemoryState memoryState = emu.getMemoryState();
            Varnode simdVarnode = inputs[1];
            int esize = (int)memoryState.getValue(inputs[2]);
            byte[] simdBytes = memoryState.getBigInteger(simdVarnode, false).toByteArray();
            byte[] outBytes = AARCH64EmulateInstructionStateModifier.this.varnode_to_bytes(outputVarnode, null, esize);
            int outLSB = outBytes.length;
            int simdLSB = simdBytes.length;
            while (outLSB > 0) {
                long simdLane = AARCH64EmulateInstructionStateModifier.this.bytes_to_long(simdBytes, simdLSB, esize);
                simdLane = this.op1(simdLane, esize);
                AARCH64EmulateInstructionStateModifier.this.insert_long(simdLane, outBytes, outLSB, esize);
                outLSB -= esize;
                simdLSB -= esize;
            }
            memoryState.setValue(outputVarnode, new BigInteger(outBytes));
        }
    }

    private abstract class SIMD_SOP1
    extends SIMD_OP1 {
        private SIMD_SOP1() {
            super(AARCH64EmulateInstructionStateModifier.this);
        }

        public void evaluate(Emulate emu, Varnode outputVarnode, Varnode[] inputs) {
            this.check_args(emu, outputVarnode, inputs);
            MemoryState memoryState = emu.getMemoryState();
            Varnode simdVarnode = inputs[1];
            int esize = (int)memoryState.getValue(inputs[2]);
            byte[] simdBytes = memoryState.getBigInteger(simdVarnode, true).toByteArray();
            byte[] outBytes = AARCH64EmulateInstructionStateModifier.this.varnode_to_bytes(outputVarnode, null, esize);
            int outLSB = outBytes.length;
            int simdLSB = simdBytes.length;
            while (outLSB > 0) {
                long simdLane = AARCH64EmulateInstructionStateModifier.this.bytes_to_long(simdBytes, simdLSB, esize);
                simdLane = this.op1(simdLane, esize);
                AARCH64EmulateInstructionStateModifier.this.insert_long(simdLane, outBytes, outLSB, esize);
                outLSB -= esize;
                simdLSB -= esize;
            }
            memoryState.setValue(outputVarnode, new BigInteger(outBytes));
        }
    }

    private abstract class SIMD_OP1
    implements OpBehaviorOther {
        private SIMD_OP1(AARCH64EmulateInstructionStateModifier aARCH64EmulateInstructionStateModifier) {
        }

        protected abstract long op1(long var1, int var3);

        void check_args(Emulate emu, Varnode outputVarnode, Varnode[] inputs) {
            int numArgs = inputs.length - 1;
            if (numArgs != 2) {
                throw new LowlevelError(this.getClass().getName() + ": requires 2 inputs (op, size), got " + numArgs);
            }
            if (outputVarnode == null) {
                throw new LowlevelError(this.getClass().getName() + ": missing required output");
            }
            MemoryState memoryState = emu.getMemoryState();
            Varnode simdVarnode = inputs[1];
            int esize = (int)memoryState.getValue(inputs[2]);
            if (outputVarnode.getSize() < simdVarnode.getSize()) {
                throw new LowlevelError(this.getClass().getName() + ": input size (" + simdVarnode.getSize() + ") exceeds output size (" + outputVarnode.getSize() + ")");
            }
            if (esize != 1 && esize != 2 && esize != 4 && esize != 8) {
                throw new LowlevelError(this.getClass().getName() + ": operand must be 1, 2, 4, or 8 bytes: got " + esize);
            }
            if (outputVarnode.getSize() % esize != 0) {
                throw new LowlevelError(this.getClass().getName() + ": output size (" + outputVarnode.getSize() + ") must be a multiple of operand size (" + esize + ")");
            }
        }
    }
}

