/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.bsim.query;

import ghidra.GhidraApplicationLayout;
import ghidra.GhidraLaunchable;
import ghidra.features.bsim.query.ServerConfig;
import ghidra.features.bsim.query.ingest.BSimLaunchable;
import ghidra.framework.Application;
import ghidra.framework.OSFileNotFoundException;
import ghidra.framework.OperatingSystem;
import ghidra.framework.Platform;
import ghidra.framework.client.ClientUtil;
import ghidra.net.ApplicationKeyManagerUtils;
import ghidra.util.Msg;
import ghidra.util.exception.AssertException;
import ghidra.util.xml.SpecXmlUtils;
import ghidra.xml.NonThreadedXmlPullParserImpl;
import ghidra.xml.XmlPullParser;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.Authenticator;
import java.net.InetAddress;
import java.nio.file.Files;
import java.nio.file.attribute.PosixFilePermissions;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableEntryException;
import java.security.cert.Certificate;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import javax.security.auth.DestroyFailedException;
import org.apache.commons.lang3.StringUtils;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import utilities.util.FileUtilities;
import utility.application.ApplicationLayout;

public class BSimControlLaunchable
implements GhidraLaunchable {
    public static final String COMMAND_START = "start";
    public static final String COMMAND_STOP = "stop";
    public static final String COMMAND_STATUS = "status";
    public static final String COMMAND_RESET_PASSWORD = "resetpassword";
    public static final String COMMAND_CHANGE_PRIVILEGE = "changeprivilege";
    public static final String COMMAND_ADDUSER = "adduser";
    public static final String COMMAND_DROPUSER = "dropuser";
    public static final String COMMAND_CHANGEAUTH = "changeauth";
    public static final String CAFILE_OPTION = "--cafile";
    public static final String AUTH_OPTION = "--auth";
    public static final String DN_OPTION = "--dn";
    public static final String PORT_OPTION = "--port";
    public static final String USER_OPTION = "--user";
    public static final String CERT_OPTION = "--cert";
    private static final Set<String> VALUE_OPTIONS = Set.of("--port", "--user", "--cert", "--cafile", "--auth", "--dn");
    private static final Set<String> GLOBAL_OPTIONS = Set.of("--port", "--user", "--cert");
    public static final String NO_LOCAL_AUTH_OPTION = "--noLocalAuth";
    public static final String FORCE_OPTION = "--force";
    private static final Map<String, String> SHORTCUT_OPTION_MAP = new HashMap<String, String>();
    private static final Set<String> START_OPTIONS;
    private static final Set<String> STOP_OPTIONS;
    private static final Set<String> STATUS_OPTIONS;
    private static final Set<String> RESET_PASSWORD_OPTIONS;
    private static final Set<String> CHANGE_PRIVILEGE_OPTIONS;
    private static final Set<String> ADDUSER_OPTIONS;
    private static final Set<String> DROPUSER_OPTIONS;
    private static final Set<String> CHANGEAUTH_OPTIONS;
    private static final Map<String, Set<String>> ALLOWED_OPTION_MAP;
    private static final String POSTGRES = "postgresql";
    private static final String POSTGRES_BUILD_SCRIPT = "Ghidra/Features/BSim/support/make-postgres.sh";
    private static final String POSTGRES_CONFIGFILE = "postgresql.conf";
    private static final String POSTGRES_CONNECTFILE = "pg_hba.conf";
    private static final String POSTGRES_IDENTFILE = "pg_ident.conf";
    private static final String POSTGRES_ROOTCA = "root.crt";
    private static final String PASSWORD_METHOD = "scram-sha-256";
    private static final String TRUST_METHOD = "trust";
    private static final String CERTIFICATE_METHOD = "cert";
    private static final String CERTIFICATE_OPTIONS = "map=mymap clientcert=verify-full";
    private static final String POSTGRES_MAP_IDENTIFIER = "mymap";
    private static final String DEFAULT_PASSWORD = "changeme";
    private static final int AUTHENTICATION_NONE = 0;
    private static final int AUTHENTICATION_PASSWORD = 1;
    private static final int AUTHENTICATION_PKI = 2;
    private GhidraApplicationLayout layout;
    private File dataDirectory;
    private File postgresRoot;
    private File postgresControl;
    private File certAuthorityFile;
    private String certParameter;
    private String distinguishedName;
    private String commonName;
    private String connectingUserName;
    private String specifiedUserName;
    private boolean adminPrivilegeRequested;
    private boolean forceShutdown;
    private String loadLibraryVar;
    private String loadLibraryValue;
    private int port;
    private int localAuthentication;
    private int hostAuthentication;
    private boolean authConfigPresent;
    private File passwordFile;
    private char[] adminPasswordData;
    private Connection localConnection;

    private void clearParams() {
        this.dataDirectory = null;
        this.postgresRoot = null;
        this.postgresControl = null;
        this.certAuthorityFile = null;
        this.certParameter = null;
        this.distinguishedName = null;
        this.commonName = null;
        this.connectingUserName = null;
        this.specifiedUserName = null;
        this.adminPrivilegeRequested = false;
        this.forceShutdown = false;
        this.loadLibraryVar = null;
        this.loadLibraryValue = null;
        this.port = -1;
        this.localAuthentication = 0;
        this.hostAuthentication = 0;
        this.authConfigPresent = false;
        this.passwordFile = null;
        this.adminPasswordData = null;
    }

    private String readCommandLine(String[] params) throws IllegalArgumentException, IOException {
        String command;
        int slot = 0;
        this.checkRequiredParam(params, slot, "command");
        switch (command = params[slot++]) {
            case "start": {
                this.scanDataDirectory(params, slot++);
                break;
            }
            case "stop": {
                this.scanDataDirectory(params, slot++);
                break;
            }
            case "status": {
                this.scanDataDirectory(params, slot++);
                break;
            }
            case "adduser": {
                this.scanDataDirectory(params, slot++);
                this.scanUsername(params, slot++);
                break;
            }
            case "dropuser": {
                this.scanDataDirectory(params, slot++);
                this.scanUsername(params, slot++);
                break;
            }
            case "resetpassword": {
                this.scanUsername(params, slot++);
                break;
            }
            case "changeauth": {
                this.scanDataDirectory(params, slot++);
                break;
            }
            case "changeprivilege": {
                this.scanUsername(params, slot++);
                this.scanPrivilege(params, slot++);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown command: " + command);
            }
        }
        this.readOptions(command, params, slot);
        return command;
    }

    private void readOptions(String command, String[] params, int discard) {
        boolean sawNoLocalAuth = false;
        Set<String> allowedParams = ALLOWED_OPTION_MAP.get(command);
        if (allowedParams == null) {
            throw new IllegalArgumentException("Unsupported command: " + command);
        }
        block20: for (int i = discard; i < params.length; ++i) {
            int ix;
            String optionName = params[i];
            String value = null;
            if (optionName.startsWith("-") && (ix = optionName.indexOf("=")) > 1) {
                value = optionName.substring(ix + 1);
                optionName = optionName.substring(0, ix);
            }
            String option = optionName;
            if (optionName.startsWith("-") && !optionName.startsWith("--") && (option = SHORTCUT_OPTION_MAP.get(optionName)) == null) {
                throw new IllegalArgumentException("Unsupported option use: " + optionName);
            }
            if (!option.startsWith("--")) {
                throw new IllegalArgumentException("Unexpected argument: " + option);
            }
            if (!GLOBAL_OPTIONS.contains(option) && !allowedParams.contains(option)) {
                throw new IllegalArgumentException("Unsupported option use: " + optionName);
            }
            if (!VALUE_OPTIONS.contains(option)) {
                if (value != null) {
                    throw new IllegalArgumentException("Unsupported option specification: " + optionName + "=");
                }
            } else if (StringUtils.isBlank((CharSequence)value)) {
                if (++i == params.length) {
                    throw new IllegalArgumentException("Missing option value: " + optionName);
                }
                value = params[i];
            }
            switch (option) {
                case "--port": {
                    this.port = this.parsePositiveIntegerOption(optionName, value);
                    continue block20;
                }
                case "--user": {
                    this.connectingUserName = value;
                    continue block20;
                }
                case "--cert": {
                    this.certParameter = value;
                    continue block20;
                }
                case "--cafile": {
                    this.certAuthorityFile = new File(value);
                    continue block20;
                }
                case "--auth": {
                    this.authConfigPresent = true;
                    String type = value;
                    if (type.equals("pki")) {
                        this.hostAuthentication = 2;
                        this.localAuthentication = 2;
                        continue block20;
                    }
                    if (type.equals("password")) {
                        this.hostAuthentication = 1;
                        this.localAuthentication = 1;
                        continue block20;
                    }
                    if (type.equals(TRUST_METHOD) || type.equals("none")) {
                        this.hostAuthentication = 0;
                        this.localAuthentication = 0;
                        continue block20;
                    }
                    throw new IllegalArgumentException("Unknown authentication method: " + type + " : options are trust, password or pki");
                }
                case "--dn": {
                    this.distinguishedName = value;
                    this.validateDistinguishedName();
                    continue block20;
                }
                case "--noLocalAuth": {
                    sawNoLocalAuth = true;
                    continue block20;
                }
                case "--force": {
                    this.forceShutdown = true;
                    continue block20;
                }
                default: {
                    throw new AssertionError((Object)("Missing option handling: " + option));
                }
            }
        }
        if (sawNoLocalAuth) {
            this.authConfigPresent = true;
            this.localAuthentication = 0;
        }
        if (this.connectingUserName == null) {
            this.connectingUserName = ClientUtil.getUserName();
        }
    }

    private void checkRequiredParam(String[] params, int index, String name) {
        if (params.length <= index) {
            throw new IllegalArgumentException("Missing required parameter: " + name);
        }
        String p = params[index];
        if (p.startsWith("--")) {
            throw new IllegalArgumentException("Missing required parameter (" + name + ") before specified option: " + p);
        }
    }

    private int parsePositiveIntegerOption(String option, String optionValue) {
        try {
            int value = Integer.valueOf(optionValue);
            if (value < 0) {
                throw new IllegalArgumentException("Negative value not permitted for " + option);
            }
            return value;
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid integer value specified for " + option);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean verifyPEMFormat(File testFile) throws IOException {
        try (BufferedReader reader = new BufferedReader(new FileReader(testFile));){
            for (int i = 0; i < 200; ++i) {
                String line = reader.readLine();
                if (line == null) {
                    break;
                }
                if (!line.startsWith("-----BEGIN CERTIFICATE-----")) continue;
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    private void validateDistinguishedName() throws IllegalArgumentException {
        if (this.distinguishedName == null) {
            return;
        }
        this.commonName = null;
        try {
            LdapName ldapName = new LdapName(this.distinguishedName);
            for (Rdn rdn : ldapName.getRdns()) {
                if (!rdn.getType().equalsIgnoreCase("CN")) continue;
                this.commonName = rdn.getValue().toString();
                break;
            }
            if (this.commonName == null) {
                throw new IllegalArgumentException("Missing common name attribute");
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Improperly formatted distinguished name");
        }
    }

    private boolean isServerRunning() throws IOException, InterruptedException {
        int ret;
        File createCommand = new File(this.postgresRoot, "bin/pg_isready");
        ArrayList<String> command = new ArrayList<String>();
        command.add(createCommand.getAbsolutePath());
        if (this.port != -1 && this.port != 5432) {
            command.add("-p");
            command.add(Integer.toString(this.port));
        }
        return (ret = this.runCommand(null, command, this.loadLibraryVar, this.loadLibraryValue)) == 0;
    }

    private char[] requestPassword(String prompt) {
        String host = "localhost";
        InetAddress addr = InetAddress.getLoopbackAddress();
        String protocol = POSTGRES;
        String scheme = "NO_NAME";
        return Authenticator.requestPasswordAuthentication(host, addr, this.port, protocol, prompt, scheme).getPassword();
    }

    private void establishAdminPassword() throws IOException {
        while (true) {
            this.adminPasswordData = this.requestPassword("Set admin(" + this.connectingUserName + ") password:");
            if (this.adminPasswordData == null) {
                throw new IOException("Unable to obtain password");
            }
            char[] repeatPass = this.requestPassword("Please re-enter password:");
            boolean match = BSimControlLaunchable.comparePasswordData(this.adminPasswordData, repeatPass);
            BSimControlLaunchable.clearPasswordData(repeatPass);
            if (match) break;
            this.cleanupPasswordData();
            System.out.println("Passwords do not match");
        }
        this.passwordFile = Files.createTempFile("bsim", ".dat", PosixFilePermissions.asFileAttribute(PosixFilePermissions.fromString("rw-------"))).toFile();
        FileWriter writer = new FileWriter(this.passwordFile);
        writer.write(this.adminPasswordData);
        writer.close();
    }

    private static void clearPasswordData(char[] password) {
        if (password != null) {
            for (int i = 0; i < password.length; ++i) {
                password[i] = 32;
            }
        }
    }

    private static boolean comparePasswordData(char[] password, char[] repeatPass) {
        if (password == null || repeatPass == null) {
            return false;
        }
        if (password.length != repeatPass.length) {
            return false;
        }
        for (int i = 0; i < repeatPass.length; ++i) {
            if (repeatPass[i] == password[i]) continue;
            return false;
        }
        return true;
    }

    private void cleanupPasswordData() throws IOException {
        BSimControlLaunchable.clearPasswordData(this.adminPasswordData);
        this.adminPasswordData = null;
        if (this.passwordFile != null) {
            if (!this.passwordFile.delete()) {
                throw new IOException("Unable to delete password file: " + this.passwordFile.getAbsolutePath());
            }
            this.passwordFile = null;
        }
    }

    private void generateSelfSignedCertificate(File certFile, File passFile) throws IOException, GeneralSecurityException {
        String alias = "bsimroot";
        char[] password = "unusedpassword".toCharArray();
        KeyStore.PasswordProtection pp = new KeyStore.PasswordProtection(password);
        try {
            KeyStore keyStore = ApplicationKeyManagerUtils.createKeyStore((String)alias, (String)"CN=BSimServer", (int)730, null, null, (String)"JKS", null, (char[])password);
            ApplicationKeyManagerUtils.exportX509Certificates((Certificate[])keyStore.getCertificateChain(alias), (File)certFile);
            Key key = keyStore.getKey(alias, password);
            try (FileOutputStream fout = new FileOutputStream(passFile);
                 PrintWriter writer = new PrintWriter(fout);){
                writer.print("-----BEGIN PRIVATE KEY-----");
                writer.println();
                String base64 = Base64.getEncoder().encodeToString(key.getEncoded());
                while (base64.length() != 0) {
                    int endIndex = Math.min(44, base64.length());
                    String line = base64.substring(0, endIndex);
                    writer.println(line);
                    base64 = base64.substring(endIndex);
                }
                writer.println("-----END PRIVATE KEY-----");
                writer.println();
            }
            passFile.setExecutable(false, false);
            passFile.setReadable(false, false);
            passFile.setWritable(false, false);
            passFile.setReadable(true, true);
        }
        catch (NoSuchAlgorithmException | UnrecoverableEntryException e) {
            throw new KeyStoreException("Failed to generate BSim server certificate", e);
        }
        finally {
            Arrays.fill(password, ' ');
            try {
                pp.destroy();
            }
            catch (DestroyFailedException e) {
                throw new AssertException((Throwable)e);
            }
        }
    }

    private Connection createLocalConnection() throws SQLException, IOException {
        String connstring;
        Properties properties;
        block5: {
            properties = new Properties();
            properties.setProperty("sslmode", "require");
            properties.setProperty("sslfactory", "ghidra.net.ApplicationSSLSocketFactory");
            properties.setProperty("user", this.connectingUserName);
            StringBuilder buffer = new StringBuilder();
            buffer.append("jdbc:postgresql://localhost");
            if (this.port != -1 && this.port != 5432) {
                buffer.append(':');
                buffer.append(this.port);
            }
            buffer.append("/template1");
            connstring = buffer.toString();
            if (this.adminPasswordData == null) {
                try {
                    Connection pdb = DriverManager.getConnection(connstring, properties);
                    return pdb;
                }
                catch (SQLException e) {
                    if (!e.getMessage().contains("password-based authentication") && !e.getMessage().contains("SCRAM-based authentication")) {
                        throw e;
                    }
                    this.adminPasswordData = this.requestPassword("User " + this.connectingUserName + " password:");
                    if (this.adminPasswordData != null) break block5;
                    throw new IOException("Unable to obtain password");
                }
            }
        }
        String passString = new String(this.adminPasswordData);
        properties.setProperty("password", passString);
        return DriverManager.getConnection(connstring, properties);
    }

    private static void executeSQLStatement(Connection pdb, String statementString) throws SQLException {
        try (Statement st = pdb.createStatement();){
            st.executeUpdate(statementString);
        }
        catch (SQLException err) {
            pdb.close();
            throw err;
        }
    }

    private void enableLSHExtension() throws SQLException, IOException {
        try (Connection pdb = this.createLocalConnection();){
            BSimControlLaunchable.executeSQLStatement(pdb, "CREATE EXTENSION IF NOT EXISTS lshvector");
        }
    }

    private int runCommand(File directory, List<String> command, String envvar, String value) throws IOException, InterruptedException {
        ProcessBuilder processBuilder = new ProcessBuilder(command);
        processBuilder.directory(directory);
        if (envvar != null) {
            Map<String, String> environment = processBuilder.environment();
            environment.put(envvar, value);
        }
        Process process = processBuilder.start();
        new IOThread(this, process.getInputStream(), true).start();
        IOThread errThread = new IOThread(this, process.getErrorStream(), false);
        errThread.start();
        errThread.join();
        int retval = process.waitFor();
        return retval;
    }

    private void tuneConfig(File inputFile, File outputFile, File inHbaFile, File outHbaFile, File serverConfigFile) throws SAXException, IOException {
        ErrorHandler handler = SpecXmlUtils.getXmlHandler();
        NonThreadedXmlPullParserImpl parser = new NonThreadedXmlPullParserImpl(serverConfigFile, handler, false);
        ServerConfig serverConfig = new ServerConfig();
        serverConfig.restoreXml((XmlPullParser)parser);
        if (this.port != -1 && this.port != 5432) {
            serverConfig.addKey("port", Integer.toString(this.port));
        }
        if (this.localAuthentication == 0) {
            serverConfig.setLocalAuthentication(TRUST_METHOD, null);
        } else if (this.localAuthentication == 1) {
            serverConfig.setLocalAuthentication(PASSWORD_METHOD, null);
        } else if (this.localAuthentication == 2) {
            serverConfig.setLocalAuthentication(CERTIFICATE_METHOD, CERTIFICATE_OPTIONS);
        } else {
            throw new IOException("Unsupported local authentication type");
        }
        if (this.hostAuthentication == 0) {
            serverConfig.setHostAuthentication(TRUST_METHOD, null);
        } else if (this.hostAuthentication == 1) {
            serverConfig.setHostAuthentication(PASSWORD_METHOD, null);
        } else if (this.hostAuthentication == 2) {
            serverConfig.setHostAuthentication(CERTIFICATE_METHOD, CERTIFICATE_OPTIONS);
        } else {
            throw new IOException("Unsupported host authentication type");
        }
        if (this.hostAuthentication == 2 || this.localAuthentication == 2) {
            serverConfig.addKey("ssl_ca_file", "'root.crt'");
        }
        serverConfig.patchConfig(inputFile, outputFile);
        serverConfig.patchConnect(inHbaFile, outHbaFile);
    }

    private void setupPostgresSharedLibrary() {
        this.loadLibraryVar = Platform.CURRENT_PLATFORM.getOperatingSystem() == OperatingSystem.MAC_OS_X ? "DYLD_LIBRARY_PATH" : "LD_LIBRARY_PATH";
        File postgresLibrary = new File(this.postgresRoot, "lib");
        this.loadLibraryValue = postgresLibrary.getAbsolutePath();
    }

    private void discoverPostgresInstall() throws IOException {
        try {
            this.postgresRoot = Application.getOSFile((String)POSTGRES);
            this.postgresControl = new File(this.postgresRoot, "bin/pg_ctl");
            if (!this.postgresControl.isFile()) {
                throw new IOException("PostgreSQL pg_ctl command not found: " + String.valueOf(this.postgresControl));
            }
            this.setupPostgresSharedLibrary();
        }
        catch (OSFileNotFoundException e) {
            throw new IOException("PostgreSQL not found and must be built (see Ghidra/Features/BSim/support/make-postgres.sh, view script for details)");
        }
    }

    private void recoverConfigurationParameters(File configFile, File hbaFile) throws IOException {
        ServerConfig serverConfig = new ServerConfig();
        serverConfig.addKey("port", "");
        serverConfig.scanConfig(configFile);
        String value = serverConfig.getValue("port");
        int scannedPort = 5432;
        if (value.length() != 0) {
            scannedPort = Integer.parseInt(value);
        }
        if (this.port != -1 && scannedPort != this.port) {
            throw new IOException("Server is configured to run on port " + Integer.toString(scannedPort) + ": Change in postgresql.conf");
        }
        this.port = scannedPort;
        serverConfig.scanConnect(hbaFile);
        String localMethod = serverConfig.getLocalAuthentication();
        if (localMethod == null || localMethod.equals(TRUST_METHOD)) {
            this.localAuthentication = 0;
        } else if (localMethod.equals(PASSWORD_METHOD)) {
            this.localAuthentication = 1;
        } else if (localMethod.equals(CERTIFICATE_METHOD)) {
            this.localAuthentication = 2;
        }
        String hostMethod = serverConfig.getHostAuthentication();
        if (hostMethod == null || hostMethod.equals(TRUST_METHOD)) {
            this.hostAuthentication = 0;
        } else if (hostMethod.equals(PASSWORD_METHOD)) {
            this.hostAuthentication = 1;
        } else if (hostMethod.equals(CERTIFICATE_METHOD)) {
            this.hostAuthentication = 2;
        }
    }

    private void checkCertAuthorityFile() throws IOException, GeneralSecurityException {
        if (this.certAuthorityFile == null) {
            throw new IOException("PKI authentication requested, but certificate authority file not provided");
        }
        if (!this.certAuthorityFile.isFile()) {
            throw new IOException(this.certAuthorityFile.getAbsolutePath() + " is not a valid certification authority");
        }
        if (!BSimControlLaunchable.verifyPEMFormat(this.certAuthorityFile)) {
            throw new GeneralSecurityException("File " + this.certAuthorityFile.getName() + " does not appear to be a certificate");
        }
    }

    private void initializeDataDirectory() throws IOException, InterruptedException, SAXException, GeneralSecurityException {
        File configFile = new File(this.dataDirectory, POSTGRES_CONFIGFILE);
        File hbaFile = new File(this.dataDirectory, POSTGRES_CONNECTFILE);
        if (configFile.exists()) {
            this.recoverConfigurationParameters(configFile, hbaFile);
            return;
        }
        File serverConfigFile = Application.getModuleDataFile((String)"serverconfig.xml").getFile(false);
        if (this.hostAuthentication == 2) {
            this.checkCertAuthorityFile();
            System.out.println("Remote client authentication with PKI certificates");
        } else if (this.hostAuthentication == 1) {
            System.out.println("Remote client authentication via password");
        } else {
            System.out.println("No client authentication");
        }
        System.out.println("Initializing data directory");
        ArrayList<String> command = new ArrayList<String>();
        command.add(this.postgresControl.getAbsolutePath());
        command.add("init");
        command.add("-o");
        command.add("'--username=" + this.connectingUserName + "'");
        if (this.hostAuthentication == 1) {
            this.establishAdminPassword();
            command.add("-o");
            command.add("'--pwfile=" + this.passwordFile.getAbsolutePath() + "'");
        } else if (this.hostAuthentication == 2) {
            if (this.commonName == null) {
                throw new GeneralSecurityException("Distinguished name option (--dn) required for " + this.connectingUserName);
            }
            this.checkCertAuthorityFile();
        }
        command.add("-D");
        command.add(this.dataDirectory.getAbsolutePath());
        int res = this.runCommand(null, command, this.loadLibraryVar, this.loadLibraryValue);
        if (res != 0) {
            throw new IOException("Error initializing postgres database");
        }
        File configCopy = new File(this.dataDirectory, "postgresql.conf.orig");
        if (this.hostAuthentication == 2 || this.localAuthentication == 2) {
            File rootCA = new File(this.dataDirectory, POSTGRES_ROOTCA);
            FileUtilities.copyFile((File)this.certAuthorityFile, (File)rootCA, (boolean)false, null);
            this.addCertificateName(this.connectingUserName);
        }
        if (!configFile.renameTo(configCopy)) {
            throw new IOException("Error copying original configuration file");
        }
        File hbaCopy = new File(this.dataDirectory, "pg_hba.conf.orig");
        if (!hbaFile.renameTo(hbaCopy)) {
            throw new IOException("Error copying original connection file");
        }
        this.tuneConfig(configCopy, configFile, hbaCopy, hbaFile, serverConfigFile);
        System.out.println("Generating servers SSL certificate");
        this.generateSelfSignedCertificate(new File(this.dataDirectory, "server.crt"), new File(this.dataDirectory, "server.key"));
    }

    private void scanDataDirectory(String[] params, int slot) throws IllegalArgumentException, IOException {
        if (params.length <= slot) {
            throw new IllegalArgumentException("Missing data directory");
        }
        this.dataDirectory = new File(params[slot]);
        if (!this.dataDirectory.isDirectory()) {
            throw new IllegalArgumentException("Data directory " + this.dataDirectory.getAbsolutePath() + " does not exist");
        }
        this.dataDirectory = this.dataDirectory.getCanonicalFile();
    }

    private void scanUsername(String[] params, int slot) throws IllegalArgumentException {
        if (params.length <= slot) {
            throw new IllegalArgumentException("Missing username");
        }
        this.specifiedUserName = params[slot];
    }

    private void scanPrivilege(String[] params, int slot) throws IllegalArgumentException {
        if (params.length <= slot) {
            throw new IllegalArgumentException("Missing desired privilege (admin or user)");
        }
        if (params[slot].equals("admin")) {
            this.adminPrivilegeRequested = true;
        } else if (params[slot].equals("user")) {
            this.adminPrivilegeRequested = false;
        } else {
            throw new IllegalArgumentException("Expecting privilege option (admin or user)");
        }
    }

    private void startCommand() throws IOException, InterruptedException, SAXException, GeneralSecurityException {
        this.discoverPostgresInstall();
        this.initializeDataDirectory();
        if (this.localAuthentication == 2 && this.certParameter == null) {
            throw new GeneralSecurityException("Path to certificate necessary to start server (--cert /path/to/cert)");
        }
        File logFile = new File(this.dataDirectory, "logfile");
        ArrayList<String> command = new ArrayList<String>();
        command.add(this.postgresControl.getAbsolutePath());
        command.add(COMMAND_START);
        command.add("-w");
        command.add("-D");
        command.add(this.dataDirectory.getAbsolutePath());
        command.add("-l");
        command.add(logFile.getAbsolutePath());
        int res = this.runCommand(null, command, this.loadLibraryVar, this.loadLibraryValue);
        if (res != 0) {
            throw new IOException("Could not start postgres server process");
        }
        System.out.println("Server started");
        boolean extensionEnabled = true;
        try {
            this.enableLSHExtension();
        }
        catch (SQLException e) {
            System.out.println(e.getMessage());
            extensionEnabled = false;
        }
        if (extensionEnabled) {
            System.out.println("BSim extension enabled");
        } else {
            this.forceShutdown = true;
            this.stopCommand();
        }
    }

    private void stopCommand() throws IOException, InterruptedException {
        int res;
        this.discoverPostgresInstall();
        ArrayList<String> command = new ArrayList<String>();
        command.add(this.postgresControl.getAbsolutePath());
        command.add(COMMAND_STOP);
        command.add("-D");
        command.add(this.dataDirectory.getAbsolutePath());
        if (this.forceShutdown) {
            command.add("-m");
            command.add("fast");
        }
        if ((res = this.runCommand(null, command, this.loadLibraryVar, this.loadLibraryValue)) != 0) {
            throw new IOException("Error shutting down postgres server process");
        }
        System.out.println("Server shutdown complete");
    }

    private void statusCommand() throws IOException, InterruptedException {
        this.discoverPostgresInstall();
        ArrayList<String> command = new ArrayList<String>();
        command.add(this.postgresControl.getAbsolutePath());
        command.add(COMMAND_STATUS);
        command.add("-D");
        command.add(this.dataDirectory.getAbsolutePath());
        int res = this.runCommand(null, command, this.loadLibraryVar, this.loadLibraryValue);
        if (res == 0) {
            System.out.println("Server running");
        } else if (res == 3) {
            System.out.println("Server down");
        } else {
            throw new IOException("Error getting postgres server status");
        }
    }

    private void reloadIdent() throws IOException, InterruptedException {
        ArrayList<String> command = new ArrayList<String>();
        command.add(this.postgresControl.getAbsolutePath());
        command.add("reload");
        command.add("-D");
        command.add(this.dataDirectory.getAbsolutePath());
        command.add("-s");
        int res = this.runCommand(null, command, this.loadLibraryVar, this.loadLibraryValue);
        if (res != 0) {
            throw new IOException("Error creating new user");
        }
    }

    private void addCertificateName(String username) throws IOException {
        File identFile = new File(this.dataDirectory, POSTGRES_IDENTFILE);
        File copyFile = new File(this.dataDirectory, "pg_ident.conf.copy");
        if (!identFile.isFile()) {
            throw new IOException("Missing ident file: " + identFile.getAbsolutePath());
        }
        ServerConfig.patchIdent(identFile, copyFile, POSTGRES_MAP_IDENTIFIER, this.commonName, username, true);
        FileUtilities.copyFile((File)copyFile, (File)identFile, (boolean)false, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addUserCommand() throws GeneralSecurityException, Exception {
        this.discoverPostgresInstall();
        this.initializeDataDirectory();
        if (this.hostAuthentication == 2 && (this.distinguishedName == null || this.commonName == null)) {
            throw new GeneralSecurityException("Distinguished name required (dn=\"..\")");
        }
        StringBuilder resultMessage = new StringBuilder();
        resultMessage.append("Added user: ");
        resultMessage.append(this.specifiedUserName);
        boolean resetPassword = this.hostAuthentication == 1;
        this.adminPasswordData = null;
        this.localConnection = this.getOrCreateLocalConnection();
        StringBuilder buffer = new StringBuilder();
        buffer.append("CREATE ROLE \"");
        buffer.append(this.specifiedUserName);
        buffer.append("\" WITH LOGIN");
        try (Statement st = this.localConnection.createStatement();){
            st.executeUpdate(buffer.toString());
        }
        catch (SQLException err) {
            if (!err.getMessage().contains("already exists")) {
                throw err;
            }
            resultMessage.append(" (already present)");
            resetPassword = false;
        }
        finally {
            if (resetPassword) {
                this.resetPassword(this.localConnection, this.specifiedUserName);
            }
            this.localConnection.close();
        }
        if (this.hostAuthentication == 2) {
            this.addCertificateName(this.specifiedUserName);
            this.reloadIdent();
            System.out.println("Linking distinguished name to user: " + this.specifiedUserName);
            return;
        }
        System.out.println(resultMessage.toString());
    }

    private Connection getOrCreateLocalConnection() throws Exception {
        try {
            if (this.localConnection == null || this.localConnection.isClosed()) {
                this.localConnection = this.createLocalConnection();
            }
        }
        catch (IOException | SQLException e) {
            Msg.error((Object)this, (Object)"Error creating connection to Postgres database", (Throwable)e);
            throw e;
        }
        return this.localConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dropUserCommand() throws Exception {
        this.discoverPostgresInstall();
        this.initializeDataDirectory();
        boolean userDoesNotExist = false;
        this.localConnection = this.getOrCreateLocalConnection();
        StringBuilder buffer = new StringBuilder();
        buffer.append("DROP ROLE \"");
        buffer.append(this.specifiedUserName);
        buffer.append('\"');
        try (Statement st = this.localConnection.createStatement();){
            st.executeUpdate(buffer.toString());
        }
        catch (SQLException err) {
            if (!err.getMessage().contains("does not exist")) {
                throw err;
            }
            userDoesNotExist = true;
        }
        finally {
            this.localConnection.close();
        }
        if (this.hostAuthentication == 2 || this.localAuthentication == 2) {
            File identFile = new File(this.dataDirectory, POSTGRES_IDENTFILE);
            File copyFile = new File(this.dataDirectory, "pg_ident.conf.copy");
            if (!identFile.isFile()) {
                throw new IOException("Missing ident file: " + identFile.getAbsolutePath());
            }
            ServerConfig.patchIdent(identFile, copyFile, POSTGRES_MAP_IDENTIFIER, this.commonName, this.specifiedUserName, false);
            FileUtilities.copyFile((File)copyFile, (File)identFile, (boolean)false, null);
            this.reloadIdent();
        }
        if (userDoesNotExist) {
            System.out.println("User " + this.specifiedUserName + " does not exist");
        } else {
            System.out.println("Removed user: " + this.specifiedUserName);
        }
    }

    private void changeAuthCommand() throws IOException, InterruptedException, SAXException, GeneralSecurityException {
        this.discoverPostgresInstall();
        File configFile = new File(this.dataDirectory, POSTGRES_CONFIGFILE);
        File hbaFile = new File(this.dataDirectory, POSTGRES_CONNECTFILE);
        if (!configFile.exists()) {
            throw new IOException("Data directory not initialized: run \"bsim_ctl start\" first");
        }
        int requestedLocalAuth = this.localAuthentication;
        int requestedHostAuth = this.hostAuthentication;
        int requestedPort = this.port;
        this.port = -1;
        this.recoverConfigurationParameters(configFile, hbaFile);
        if (this.isServerRunning()) {
            throw new IOException("Cannot modify settings on running server");
        }
        if (!(this.authConfigPresent && (requestedHostAuth != this.hostAuthentication || requestedLocalAuth != this.localAuthentication) || requestedPort != -1 && requestedPort != this.port)) {
            System.out.println("No changes to make");
            return;
        }
        File serverConfigFile = Application.getModuleDataFile((String)"serverconfig.xml").getFile(false);
        File configCopy = new File(this.dataDirectory, "postgresql.conf.orig");
        if (!configCopy.exists()) {
            throw new IOException("Original configuration file not present: " + configCopy.getAbsolutePath());
        }
        File hbaCopy = new File(this.dataDirectory, "pg_hba.conf.orig");
        if (!hbaCopy.exists()) {
            throw new IOException("Original connection file not present: " + hbaCopy.getAbsolutePath());
        }
        if (requestedPort != -1 && requestedPort != this.port) {
            this.port = requestedPort;
            System.out.println("Server will now listen on port " + Integer.toString(this.port));
        }
        boolean newRemotePki = false;
        boolean newLocalPki = false;
        if (this.authConfigPresent && requestedLocalAuth != this.localAuthentication) {
            this.localAuthentication = requestedLocalAuth;
            System.out.print("New local authentication: ");
            if (this.localAuthentication == 1) {
                System.out.println("password");
            } else if (this.localAuthentication == 2) {
                System.out.println("pki");
                newLocalPki = true;
                if (this.commonName == null) {
                    throw new GeneralSecurityException("Distinguished name required (dn=\"..\")");
                }
            } else if (this.localAuthentication == 0) {
                System.out.println("none");
            }
        }
        if (this.authConfigPresent && requestedHostAuth != this.hostAuthentication) {
            this.hostAuthentication = requestedHostAuth;
            System.out.print("New host authentication: ");
            if (this.hostAuthentication == 0) {
                System.out.println("none");
            } else if (this.hostAuthentication == 1) {
                System.out.println("password");
            } else if (this.hostAuthentication == 2) {
                System.out.println("pki");
                newRemotePki = true;
            } else {
                System.out.println("unknown");
            }
        }
        if (newLocalPki || newRemotePki) {
            this.checkCertAuthorityFile();
            File rootCA = new File(this.dataDirectory, POSTGRES_ROOTCA);
            FileUtilities.copyFile((File)this.certAuthorityFile, (File)rootCA, (boolean)false, null);
        }
        if (newLocalPki) {
            this.addCertificateName(this.connectingUserName);
        }
        this.tuneConfig(configCopy, configFile, hbaCopy, hbaFile, serverConfigFile);
    }

    private void resetPassword(Connection pdb, String username) throws SQLException {
        StringBuilder buffer = new StringBuilder();
        buffer.append("ALTER ROLE \"");
        buffer.append(username);
        buffer.append("\" WITH PASSWORD '");
        buffer.append(DEFAULT_PASSWORD);
        buffer.append('\'');
        BSimControlLaunchable.executeSQLStatement(pdb, buffer.toString());
    }

    private void passwordCommand() throws Exception {
        this.localConnection = this.getOrCreateLocalConnection();
        System.out.println("Resetting password for user: " + this.specifiedUserName);
        try {
            this.resetPassword(this.localConnection, this.specifiedUserName);
            System.out.println("Password reset complete");
        }
        finally {
            this.localConnection.close();
        }
    }

    private void changePrivilegeCommand() throws Exception {
        this.localConnection = this.getOrCreateLocalConnection();
        try {
            if (this.adminPrivilegeRequested) {
                System.out.println("Granting admin privileges to " + this.specifiedUserName);
                BSimControlLaunchable.executeSQLStatement(this.localConnection, "ALTER ROLE " + this.specifiedUserName + " SUPERUSER CREATEROLE CREATEDB");
            } else {
                System.out.println("Revoking admin privileges from " + this.specifiedUserName);
                BSimControlLaunchable.executeSQLStatement(this.localConnection, "ALTER ROLE " + this.specifiedUserName + " NOSUPERUSER NOCREATEROLE NOCREATEDB");
            }
        }
        finally {
            this.localConnection.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void run(String[] params) throws Exception {
        try {
            this.clearParams();
            String command = this.readCommandLine(params);
            this.initializeApplication();
            switch (command) {
                case "start": {
                    this.startCommand();
                    return;
                }
                case "stop": {
                    this.stopCommand();
                    return;
                }
                case "status": {
                    this.statusCommand();
                    return;
                }
                case "adduser": {
                    this.addUserCommand();
                    return;
                }
                case "dropuser": {
                    this.dropUserCommand();
                    return;
                }
                case "changeauth": {
                    this.changeAuthCommand();
                    return;
                }
                case "resetpassword": {
                    this.passwordCommand();
                    return;
                }
                case "changeprivilege": {
                    this.changePrivilegeCommand();
                    return;
                }
                default: {
                    throw new IllegalArgumentException("Unknown command: " + command);
                }
            }
        }
        finally {
            try {
                this.cleanupPasswordData();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static void printUsage() {
        System.err.println("\nUSAGE: bsim_ctl [command]  required-args... [OPTIONS...}\n\n                start      </datadir-path> [--auth|-a pki|password|trust] [--noLocalAuth] [--cafile \"</cacert-path>\"] [--dn \"<distinguished-name>\"]\n                stop       </datadir-path> [--force]\n                status     </datadir-path>\n                adduser    </datadir-path> <username> [--dn \"<distinguished-name>\"]\n                dropuser   </datadir-path> <username>\n                changeauth </datadir-path> [--auth|-a pki|password|trust] [--noLocalAuth] [--cafile \"</cacert-path>\"] [--dn \"<distinguished-name>\"]\n                resetpassword   <username>\n                changeprivilege <username> admin|user\n\nGlobal options:\n   --port|-p <portnum>\n   --user|-u <username>\n   --cert </certfile-path>\n\nNOTE: Options with values may also be specified using the form: --option=value\n");
    }

    public void launch(GhidraApplicationLayout ghidraLayout, String[] params) {
        if (params.length <= 1) {
            BSimControlLaunchable.printUsage();
            return;
        }
        this.layout = ghidraLayout;
        boolean success = false;
        try {
            this.run(params);
            success = true;
        }
        catch (SAXException e1) {
            System.err.println("Error in server configuation data");
            System.err.println(e1.getMessage());
        }
        catch (InterruptedException e) {
            System.err.println("Command was interrupted");
            System.err.println(e.getMessage());
        }
        catch (SQLException e) {
            System.err.println("Error connecting to the database");
            System.err.println(e.getMessage());
        }
        catch (GeneralSecurityException e) {
            System.err.println("Error establishing server certificate");
            System.err.println(e.getMessage());
        }
        catch (IllegalArgumentException e) {
            System.err.println("Error in command line arguments");
            System.err.println(e.getMessage());
        }
        catch (Exception e) {
            System.err.println("Unexpected error");
            e.printStackTrace();
        }
        if (!success) {
            System.exit(1);
        }
    }

    private void initializeApplication() throws IOException, ClassNotFoundException {
        if (this.layout != null) {
            BSimLaunchable.initializeApplication((ApplicationLayout)this.layout, 0, this.connectingUserName, this.certParameter);
        }
    }

    static {
        SHORTCUT_OPTION_MAP.put("-a", AUTH_OPTION);
        SHORTCUT_OPTION_MAP.put("-p", PORT_OPTION);
        SHORTCUT_OPTION_MAP.put("-u", USER_OPTION);
        START_OPTIONS = Set.of(AUTH_OPTION, DN_OPTION, NO_LOCAL_AUTH_OPTION, CAFILE_OPTION);
        STOP_OPTIONS = Set.of(FORCE_OPTION);
        STATUS_OPTIONS = Set.of();
        RESET_PASSWORD_OPTIONS = Set.of();
        CHANGE_PRIVILEGE_OPTIONS = Set.of();
        ADDUSER_OPTIONS = Set.of(DN_OPTION);
        DROPUSER_OPTIONS = Set.of();
        CHANGEAUTH_OPTIONS = Set.of(AUTH_OPTION, DN_OPTION, NO_LOCAL_AUTH_OPTION, CAFILE_OPTION);
        ALLOWED_OPTION_MAP = new HashMap<String, Set<String>>();
        ALLOWED_OPTION_MAP.put(COMMAND_START, START_OPTIONS);
        ALLOWED_OPTION_MAP.put(COMMAND_STOP, STOP_OPTIONS);
        ALLOWED_OPTION_MAP.put(COMMAND_STATUS, STATUS_OPTIONS);
        ALLOWED_OPTION_MAP.put(COMMAND_RESET_PASSWORD, RESET_PASSWORD_OPTIONS);
        ALLOWED_OPTION_MAP.put(COMMAND_CHANGE_PRIVILEGE, CHANGE_PRIVILEGE_OPTIONS);
        ALLOWED_OPTION_MAP.put(COMMAND_ADDUSER, ADDUSER_OPTIONS);
        ALLOWED_OPTION_MAP.put(COMMAND_DROPUSER, DROPUSER_OPTIONS);
        ALLOWED_OPTION_MAP.put(COMMAND_CHANGEAUTH, CHANGEAUTH_OPTIONS);
    }

    private class IOThread
    extends Thread {
        private BufferedReader shellOutput;
        private boolean suppressOutput;

        public IOThread(BSimControlLaunchable bSimControlLaunchable, InputStream input, boolean suppressOut) {
            this.shellOutput = new BufferedReader(new InputStreamReader(input));
            this.suppressOutput = suppressOut;
        }

        @Override
        public void run() {
            String line = null;
            try {
                while ((line = this.shellOutput.readLine()) != null) {
                    if (this.suppressOutput) continue;
                    System.out.println(" " + line);
                }
            }
            catch (Exception e) {
                System.err.println("Unexpected Exception: " + e.getMessage());
                e.printStackTrace(System.err);
            }
        }
    }
}

