/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.bsim.query.protocol;

import generic.lsh.vector.LSHVectorFactory;
import ghidra.features.bsim.query.LSHException;
import ghidra.features.bsim.query.protocol.QueryResponseRecord;
import ghidra.util.xml.SpecXmlUtils;
import ghidra.xml.XmlPullParser;
import java.io.IOException;
import java.io.Writer;

public class ResponseOptionalExist
extends QueryResponseRecord {
    public boolean tableExists = false;
    public boolean wasCreated = false;

    public ResponseOptionalExist() {
        super("responseoptionalexist");
    }

    @Override
    public void saveXml(Writer fwrite) throws IOException {
        fwrite.append('<').append(this.name).append(">\n");
        if (this.tableExists) {
            fwrite.append("<exists>true</exist>\n");
        } else {
            fwrite.append("<exists>false</exists>\n");
        }
        if (this.wasCreated) {
            fwrite.append("<created>true</created>\n");
        } else {
            fwrite.append("<created>false</created>\n");
        }
        fwrite.append("</").append(this.name).append(">\n");
    }

    @Override
    public void restoreXml(XmlPullParser parser, LSHVectorFactory vectorFactory) throws LSHException {
        this.tableExists = false;
        this.wasCreated = false;
        parser.start(new String[]{this.name});
        if (parser.peek().getName().equals("exists")) {
            parser.start(new String[0]);
            this.tableExists = SpecXmlUtils.decodeBoolean((String)parser.end().getText());
        }
        if (parser.peek().getName().equals("created")) {
            parser.start(new String[0]);
            this.tableExists = SpecXmlUtils.decodeBoolean((String)parser.end().getText());
        }
        parser.end();
    }
}

