/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.symboltree.actions;

import docking.action.MenuData;
import ghidra.app.context.ProgramSymbolActionContext;
import ghidra.app.context.ProgramSymbolContextAction;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.Symbol;
import ghidra.util.HelpLocation;

public class ClearPinSymbolAction
extends ProgramSymbolContextAction {
    public ClearPinSymbolAction(String owner, String popupGroup) {
        super("Clear Pinned Symbol", owner);
        this.setPopupMenuData(new MenuData(new String[]{"Clear Pinned Symbol(s)"}, popupGroup));
        this.setDescription("Unpins symbol(s) so that the symbol moves with memory block moves or image base changes.");
        this.setHelpLocation(new HelpLocation("SymbolTablePlugin", "Pinning a Symbol"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void actionPerformed(ProgramSymbolActionContext context) {
        Program program = context.getProgram();
        int transactionID = program.startTransaction("Clear Pinned");
        try {
            for (Symbol symbol : context.getSymbols()) {
                if (!symbol.isPinned()) continue;
                symbol.setPinned(false);
            }
        }
        finally {
            program.endTransaction(transactionID, true);
        }
    }

    @Override
    protected boolean isEnabledForContext(ProgramSymbolActionContext context) {
        for (Symbol symbol : context.getSymbols()) {
            if (!symbol.isPinned()) continue;
            return true;
        }
        return false;
    }
}

