/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.elf.relocation;

import ghidra.app.util.bin.format.elf.ElfHeader;
import ghidra.app.util.bin.format.elf.ElfLoadHelper;
import ghidra.app.util.bin.format.elf.ElfRelocation;
import ghidra.app.util.bin.format.elf.ElfSymbol;
import ghidra.app.util.bin.format.elf.relocation.ElfRelocationContext;
import ghidra.app.util.importer.MessageLog;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.DataUtilities;
import ghidra.program.model.data.PointerTypedef;
import ghidra.program.model.listing.BookmarkManager;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.model.reloc.RelocationResult;
import ghidra.program.model.util.CodeUnitInsertionException;
import ghidra.util.Msg;
import ghidra.util.classfinder.ExtensionPoint;
import ghidra.util.exception.NotFoundException;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public abstract class ElfRelocationHandler
implements ExtensionPoint {
    public static final String GOT_BLOCK_NAME = "%got";

    @Deprecated(since="11.1", forRemoval=true)
    protected ElfRelocationHandler() {
    }

    public abstract boolean canRelocate(ElfHeader var1);

    public int getRelrRelocationType() {
        return 0;
    }

    protected ElfRelocationContext createRelocationContext(ElfLoadHelper loadHelper, Map<ElfSymbol, Address> symbolMap) {
        return null;
    }

    protected abstract RelocationResult relocate(ElfRelocationContext var1, ElfRelocation var2, Address var3) throws MemoryAccessException, NotFoundException;

    protected void markAsUnhandled(Program program, Address relocationAddress, int typeId, String symbolName, int symbolIndex, MessageLog log) {
        ElfRelocationHandler.markupErrorOrWarning(program, "Unhandled ELF Relocation", null, relocationAddress, ElfRelocationHandler.getDefaultRelocationTypeDetail(typeId), symbolIndex, symbolName, "Error", log);
    }

    protected void markAsError(Program program, Address relocationAddress, int typeId, String symbolName, int symbolIndex, String msg, MessageLog log) {
        ElfRelocationHandler.markupErrorOrWarning(program, "ELF Relocation Error", msg, relocationAddress, ElfRelocationHandler.getDefaultRelocationTypeDetail(typeId), symbolIndex, symbolName, "Error", log);
    }

    protected void markAsWarning(Program program, Address relocationAddress, int typeId, String symbolName, int symbolIndex, String msg, MessageLog log) {
        ElfRelocationHandler.markupErrorOrWarning(program, "ELF Relocation Warning", msg, relocationAddress, ElfRelocationHandler.getDefaultRelocationTypeDetail(typeId), symbolIndex, symbolName, "Warning", log);
    }

    public static void applyComponentOffsetPointer(Program program, Address addr, long componentOffset) {
        MemoryBlock block = program.getMemory().getBlock(addr);
        if (block == null || block.isExecute()) {
            return;
        }
        PointerTypedef dt = new PointerTypedef(null, null, -1, (DataTypeManager)program.getDataTypeManager(), componentOffset);
        try {
            DataUtilities.createData((Program)program, (Address)addr, (DataType)dt, (int)-1, (DataUtilities.ClearDataMode)DataUtilities.ClearDataMode.CLEAR_ALL_UNDEFINED_CONFLICT_DATA);
        }
        catch (CodeUnitInsertionException e) {
            Msg.error(ElfRelocationHandler.class, (Object)("Failed to apply component-offset pointer at " + String.valueOf(addr)));
        }
    }

    public static void warnExternalOffsetRelocation(Program program, Address relocationAddress, Address symbolAddr, String symbolName, long adjustment, MessageLog log) {
        if (symbolAddr == null || adjustment == 0L || !program.getMemory().isExternalBlockAddress(symbolAddr)) {
            return;
        }
        MemoryBlock block = program.getMemory().getBlock(relocationAddress);
        boolean showAsError = block == null || block.isExecute();
        String sign = "+";
        if (adjustment < 0L) {
            adjustment = -adjustment;
            sign = "-";
        }
        String adjStr = sign + "0x" + Long.toHexString(adjustment);
        symbolName = StringUtils.isEmpty((CharSequence)symbolName) ? "<no name>" : symbolName;
        String msg1 = "EXTERNAL Data ELF Relocation with offset: at " + String.valueOf(relocationAddress) + " (External Location = " + symbolName + adjStr + ")";
        if (showAsError) {
            Msg.error(ElfRelocationHandler.class, (Object)msg1);
        } else {
            Msg.warn(ElfRelocationHandler.class, (Object)msg1);
        }
        if (block != null) {
            BookmarkManager bookmarkManager = program.getBookmarkManager();
            bookmarkManager.setBookmark(relocationAddress, "Warning", "EXTERNAL Relocation", "EXTERNAL Data ELF Relocation with offset: External Location = " + symbolName + adjStr);
        }
    }

    static String getDefaultRelocationTypeDetail(int typeId) {
        return "Type = " + Integer.toUnsignedLong(typeId) + " (0x" + Integer.toHexString(typeId) + ")";
    }

    public static void bookmarkNoHandlerError(Program program, Address relocationAddress, int typeId, int symbolIndex, String symbolName) {
        ElfRelocationHandler.markupErrorOrWarning(program, "No relocation handler", null, relocationAddress, ElfRelocationHandler.getDefaultRelocationTypeDetail(typeId), symbolIndex, symbolName, "Error", null);
    }

    public static void bookmarkUnsupportedRelr(Program program, Address relocationAddress, int symbolIndex, String symbolName) {
        symbolName = StringUtils.isEmpty((CharSequence)symbolName) ? "<no name>" : symbolName;
        String symbolIndexStr = symbolIndex < 0 ? "" : " (0x" + Integer.toHexString(symbolIndex) + ")";
        BookmarkManager bookmarkManager = program.getBookmarkManager();
        bookmarkManager.setBookmark(relocationAddress, "Error", "Relocation", "Unsupported RELR Relocation: Symbol = " + symbolName + symbolIndexStr + " - ELF Extension does not specify type");
    }

    public static void markAsError(Program program, Address relocationAddress, int typeId, int symbolIndex, String symbolName, String msg, MessageLog log) {
        ElfRelocationHandler.markupErrorOrWarning(program, "Elf Relocation Error", msg, relocationAddress, ElfRelocationHandler.getDefaultRelocationTypeDetail(typeId), symbolIndex, symbolName, "Error", log);
    }

    static void markupErrorOrWarning(Program program, String mainMsg, String tailMsg, Address relocationAddress, String relocTypeDetail, int symbolIndex, String symbolName, String bookmarkType, MessageLog log) {
        String symbolIndexStr;
        tailMsg = StringUtils.isEmpty((CharSequence)tailMsg) ? "" : " - " + (String)tailMsg;
        symbolName = StringUtils.isEmpty((CharSequence)symbolName) ? "<no name>" : symbolName;
        String string = symbolIndexStr = symbolIndex < 0 ? "" : " (0x" + Integer.toHexString(symbolIndex) + ")";
        if (log != null) {
            log.appendMsg(mainMsg + ": " + relocTypeDetail + " at " + String.valueOf(relocationAddress) + " (Symbol = " + symbolName + ")" + (String)tailMsg);
        }
        BookmarkManager bookmarkManager = program.getBookmarkManager();
        bookmarkManager.setBookmark(relocationAddress, bookmarkType, "Relocation", mainMsg + ": " + relocTypeDetail + " Symbol = " + symbolName + symbolIndexStr + (String)tailMsg);
    }

    @Deprecated
    public static void markAsUnhandled(Program program, Address relocationAddress, long typeId, long symbolIndex, String symbolName, MessageLog log) {
        ElfRelocationHandler.markupErrorOrWarning(program, "Unhandled ELF Relocation", null, relocationAddress, ElfRelocationHandler.getDefaultRelocationTypeDetail((int)typeId), (int)symbolIndex, symbolName, "Error", log);
    }

    @Deprecated
    public static void markAsWarning(Program program, Address relocationAddress, String type, String msg, MessageLog log) {
        ElfRelocationHandler.markAsWarning(program, relocationAddress, type, null, -1, msg, log);
    }

    @Deprecated
    public static void markAsWarning(Program program, Address relocationAddress, String type, String symbolName, int symbolIndex, String msg, MessageLog log) {
        ElfRelocationHandler.markupErrorOrWarning(program, "Elf Relocation Warning", msg, relocationAddress, "Type = " + type, symbolIndex, symbolName, "Warning", log);
    }

    @Deprecated
    public static void markAsError(Program program, Address relocationAddress, long typeId, String symbolName, String msg, MessageLog log) {
        ElfRelocationHandler.markAsError(program, relocationAddress, typeId + " (0x" + Long.toHexString(typeId) + ")", symbolName, msg, log);
    }

    @Deprecated
    public static void markAsError(Program program, Address relocationAddress, String type, String symbolName, String msg, MessageLog log) {
        ElfRelocationHandler.markupErrorOrWarning(program, "Elf Relocation Error", msg, relocationAddress, "Type = " + type, -1, symbolName, "Error", log);
    }
}

