/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef _GNOTIFY_H
#define _GNOTIFY_H

#include "config.h"

#include <gtk/gtk.h>
#include <pthread.h>
#include <ctype.h>
#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <unistd.h>
#include <string.h>
#include <fcntl.h>
#include <errno.h>
#include <syslog.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/utsname.h>
#include <netinet/in.h>
#include <netdb.h>
#include <arpa/inet.h>
#include <signal.h>
#include <libxml/xmlmemory.h>
#include <libxml/parser.h>

#define GNOTIFY_ICON "/usr/share/pixmaps/gnome-main-menu.png"
#define GNOTIFY_ETC	"/etc/gnotify.xml"

#define MAX_CLIENTS		128

#define BTNEVENT_HTTP		1
#define BTNEVENT_FTP		2
#define BTNEVENT_FILE		3

/* The config-struct. Here all information gnotify got from the 
 * ~/.gnotify.xml will be stored */
struct CONF
{
  int notify_x;
  int notify_y;
  int notify_delay;
  int notify_play;
  int notify_ipdisallows;
	int notify_allowmove;
	int notify_allowhtml;
	int notify_allowreload;
	int notify_allowconfchange;
	int notify_saveconfonexit;
	int notify_btnevents;
  char notify_ssink[12];
	char notify_logout[256];
  char notify_allowip[128][32];
	
	int notify_verbose;
}cfg;

 /* The Client-Database. Every client gehts one array of this struct
	* and will use it for storing things like his IP, his Socket-
	* Filedescriptor and other stuff. */
struct CLIENTSDB
{
	pthread_t th;
	int sockfd;
	int move_x;
	int move_y;
	int ckboxpress;
	int btnpress;
	int occupied;
	int btnevent_type;
	char ip[16];
  char app[128];
  char icon[512];
  char snd[512];
  char msg[512];
  char button[128];
	char ckbox[128];
	char btnevent[512];
}cdb[MAX_CLIENTS];

struct SYSINFODB
{
  char k_release[32];
  char k_version[64];
  char machine[16];
  char opsys[32];
  char nodename[64];
}sysinfo;

pthread_mutex_t mutex; /* This is the mutex which is used for a thread-
												* synchronization. */
pthread_t gtkf;
pthread_t NULLTHREAD; /* The NULL-Thread for comparing if a pthread_t is occupied or not */
pid_t GNOTIFYPID;

/* This is the GNotify constructor, it's needed for initializing and loading important things */
int gnotify_constructor(void);

/* You shouldn't remove this function.. it's.. usefull... */
void gnotify_main(void);

/* The GNotify about dialog */
void gnotify_about(void);

/* Configuration-GUI stuff */
void gnotify_cfggui(void);

/* Configuration-GUI callbacks */
void ckPlaysound_callback(GtkObject *widget, gpointer user_data);
void ckAllowhtml_callback(GtkObject *widget, gpointer user_data);
void ckAllowcfgchange_callback(GtkObject *widget, gpointer user_data);
void ckSaveconf_callback(GtkObject *widget, gpointer user_data);
void ckAllowmove_callback(GtkObject *widget, gpointer user_data);
void ckAllowreload_callback(GtkObject *widget, gpointer user_data);
void ckBtnevent_callback(GtkObject *widget, gpointer user_data);
void cboSsink_callback(GtkObject *widget, gpointer user_data);
void cboLogout_callback(GtkObject *widget, gpointer user_data);
void cmdAddip_callback(GtkObject *widget, gpointer user_data);
void cmdSave_callback(GtkObject *widget, gpointer user_data);

/* GNOtify IP-Config-Tool */
void gnotify_cfggui_iplist(void);

/* Converts a list into a plain-text */
char *list_to_plain(void);

/* Some callbacks */
void cmdAddip_callback(GtkObject *widget, gpointer user_data);
void cmdRemoveip_callback(GtkObject *widget, gpointer user_data);
void cmdSaveip_callback(GtkObject *widget, gpointer user_data);

/* Searches an IP in the list */
int searchip(char *ip);

/* Adds a new IP to the list */
int add_ip_to_list(char *ip);

/* Removes an existing IP from the list */

int remove_ip_from_list(char *ip);
/* End of the cfggui stuff */

/* Something like a destructor */
void gnotify_atexit(void);

/* This is the gnotify-signal-handler.
 * sign - The signal which arrives
 */
void gnotify_signal(int sign);

/* The gnotify-clienthandling function */
int gnotify_client(int cid);

/* This function runs an event when it's enabled an the button is clicked */
void run_button_event(int cid);

int gnotify_notify(int cid);
void gnotify_notify_quit(GtkWidget *widget,gpointer data);
void buttonclick(GtkWidget *widget,gpointer data);
void ckboxonclick(GtkWidget *widget,gpointer data);
int playsound(const char *file);

void showmessage(int type, int buttons, char *text);

/* This function gets a free Client-ID from the cdb-struct and returns it */
int cid_getfree(void);

void cid_zombiekill(void);

void getsysinfo(void);

int is_ip(char ip[16]);
int count_connections(void);

char *reverse_strnget(const char* string1, int n);
int printflog(int syslogpriority, const char *text, ...);

int saveconfig(char *config);
int readconfig(char *config);
int createconfig(char *config);

int g_argc; 
char **g_argv;

#endif
