# This file was automatically generated by SWIG (https://www.swig.org).
# Version 4.4.1
#
# Do not make changes to this file unless you know what you are doing - modify
# the SWIG interface file instead.

from sys import version_info as _swig_python_version_info
# Import the low-level C/C++ module
if getattr(globals().get("__spec__"), "parent", None) or __package__ or "." in __name__:
    from . import _digital_swig0
else:
    import _digital_swig0

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)


def _swig_setattr_nondynamic_instance_variable(set):
    def set_instance_attr(self, name, value):
        if name == "this":
            set(self, name, value)
        elif name == "thisown":
            self.this.own(value)
        elif hasattr(self, name) and isinstance(getattr(type(self), name), property):
            set(self, name, value)
        else:
            raise AttributeError("You cannot add instance attributes to %s" % self)
    return set_instance_attr


def _swig_setattr_nondynamic_class_variable(set):
    def set_class_attr(cls, name, value):
        if hasattr(cls, name) and not isinstance(getattr(cls, name), property):
            set(cls, name, value)
        else:
            raise AttributeError("You cannot add class attributes to %s" % cls)
    return set_class_attr


def _swig_add_metaclass(metaclass):
    """Class decorator for adding a metaclass to a SWIG wrapped class - a slimmed down version of six.add_metaclass"""
    def wrapper(cls):
        return metaclass(cls.__name__, cls.__bases__, cls.__dict__.copy())
    return wrapper


class _SwigNonDynamicMeta(type):
    """Meta class to enforce nondynamic attributes (no new attributes) for a class"""
    __setattr__ = _swig_setattr_nondynamic_class_variable(type.__setattr__)



def high_res_timer_now() -> "gr::high_res_timer_type":
    r"""high_res_timer_now() -> gr::high_res_timer_type"""
    return _digital_swig0.high_res_timer_now()

def high_res_timer_now_perfmon() -> "gr::high_res_timer_type":
    r"""high_res_timer_now_perfmon() -> gr::high_res_timer_type"""
    return _digital_swig0.high_res_timer_now_perfmon()

def high_res_timer_tps() -> "gr::high_res_timer_type":
    r"""high_res_timer_tps() -> gr::high_res_timer_type"""
    return _digital_swig0.high_res_timer_tps()

def high_res_timer_epoch() -> "gr::high_res_timer_type":
    r"""high_res_timer_epoch() -> gr::high_res_timer_type"""
    return _digital_swig0.high_res_timer_epoch()
class cpm(object):
    r"""Proxy of C++ gr::analog::cpm class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    LRC = _digital_swig0.cpm_LRC
    
    LSRC = _digital_swig0.cpm_LSRC
    
    LREC = _digital_swig0.cpm_LREC
    
    TFM = _digital_swig0.cpm_TFM
    
    GAUSSIAN = _digital_swig0.cpm_GAUSSIAN
    
    GENERIC = _digital_swig0.cpm_GENERIC
    

    @staticmethod
    def phase_response(type: "gr::analog::cpm::cpm_type", samples_per_sym: "unsigned int", L: "unsigned int", beta: "double"=0.3) -> "std::vector< float,std::allocator< float > >":
        r"""phase_response(gr::analog::cpm::cpm_type type, unsigned int samples_per_sym, unsigned int L, double beta=0.3) -> pmt_vector_float"""
        return _digital_swig0.cpm_phase_response(type, samples_per_sym, L, beta)

    def __init__(self):
        r"""__init__(cpm self) -> cpm"""
        _digital_swig0.cpm_swiginit(self, _digital_swig0.new_cpm())
    __swig_destroy__ = _digital_swig0.delete_cpm

# Register cpm in _digital_swig0:
_digital_swig0.cpm_swigregister(cpm)
class control_loop(object):
    r"""Proxy of C++ gr::blocks::control_loop class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(control_loop self) -> control_loop
        __init__(control_loop self, float loop_bw, float max_freq, float min_freq) -> control_loop
        """
        _digital_swig0.control_loop_swiginit(self, _digital_swig0.new_control_loop(*args))
    __swig_destroy__ = _digital_swig0.delete_control_loop

    def update_gains(self) -> "void":
        r"""update_gains(control_loop self)"""
        return _digital_swig0.control_loop_update_gains(self)

    def advance_loop(self, error: "float") -> "void":
        r"""advance_loop(control_loop self, float error)"""
        return _digital_swig0.control_loop_advance_loop(self, error)

    def phase_wrap(self) -> "void":
        r"""phase_wrap(control_loop self)"""
        return _digital_swig0.control_loop_phase_wrap(self)

    def frequency_limit(self) -> "void":
        r"""frequency_limit(control_loop self)"""
        return _digital_swig0.control_loop_frequency_limit(self)

    def set_loop_bandwidth(self, bw: "float") -> "void":
        r"""set_loop_bandwidth(control_loop self, float bw)"""
        return _digital_swig0.control_loop_set_loop_bandwidth(self, bw)

    def set_damping_factor(self, df: "float") -> "void":
        r"""set_damping_factor(control_loop self, float df)"""
        return _digital_swig0.control_loop_set_damping_factor(self, df)

    def set_alpha(self, alpha: "float") -> "void":
        r"""set_alpha(control_loop self, float alpha)"""
        return _digital_swig0.control_loop_set_alpha(self, alpha)

    def set_beta(self, beta: "float") -> "void":
        r"""set_beta(control_loop self, float beta)"""
        return _digital_swig0.control_loop_set_beta(self, beta)

    def set_frequency(self, freq: "float") -> "void":
        r"""set_frequency(control_loop self, float freq)"""
        return _digital_swig0.control_loop_set_frequency(self, freq)

    def set_phase(self, phase: "float") -> "void":
        r"""set_phase(control_loop self, float phase)"""
        return _digital_swig0.control_loop_set_phase(self, phase)

    def set_max_freq(self, freq: "float") -> "void":
        r"""set_max_freq(control_loop self, float freq)"""
        return _digital_swig0.control_loop_set_max_freq(self, freq)

    def set_min_freq(self, freq: "float") -> "void":
        r"""set_min_freq(control_loop self, float freq)"""
        return _digital_swig0.control_loop_set_min_freq(self, freq)

    def get_loop_bandwidth(self) -> "float":
        r"""get_loop_bandwidth(control_loop self) -> float"""
        return _digital_swig0.control_loop_get_loop_bandwidth(self)

    def get_damping_factor(self) -> "float":
        r"""get_damping_factor(control_loop self) -> float"""
        return _digital_swig0.control_loop_get_damping_factor(self)

    def get_alpha(self) -> "float":
        r"""get_alpha(control_loop self) -> float"""
        return _digital_swig0.control_loop_get_alpha(self)

    def get_beta(self) -> "float":
        r"""get_beta(control_loop self) -> float"""
        return _digital_swig0.control_loop_get_beta(self)

    def get_frequency(self) -> "float":
        r"""get_frequency(control_loop self) -> float"""
        return _digital_swig0.control_loop_get_frequency(self)

    def get_phase(self) -> "float":
        r"""get_phase(control_loop self) -> float"""
        return _digital_swig0.control_loop_get_phase(self)

    def get_max_freq(self) -> "float":
        r"""get_max_freq(control_loop self) -> float"""
        return _digital_swig0.control_loop_get_max_freq(self)

    def get_min_freq(self) -> "float":
        r"""get_min_freq(control_loop self) -> float"""
        return _digital_swig0.control_loop_get_min_freq(self)

# Register control_loop in _digital_swig0:
_digital_swig0.control_loop_swigregister(control_loop)

def tanhf_lut(x: "float") -> "float":
    r"""tanhf_lut(float x) -> float"""
    return _digital_swig0.tanhf_lut(x)
class binary_slicer_fb(object):
    r"""
    Slice float binary symbol producing 1 bit output.

    Constructor Specific Documentation:

    Make binary symbol slicer block.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    @staticmethod
    def make() -> "gr::digital::binary_slicer_fb::sptr":
        r"""
        make() -> binary_slicer_fb_sptr
        Slice float binary symbol producing 1 bit output.

        Constructor Specific Documentation:

        Make binary symbol slicer block.
        """
        return _digital_swig0.binary_slicer_fb_make()
    __swig_destroy__ = _digital_swig0.delete_binary_slicer_fb

# Register binary_slicer_fb in _digital_swig0:
_digital_swig0.binary_slicer_fb_swigregister(binary_slicer_fb)
cvar = _digital_swig0.cvar

class cma_equalizer_cc(object):
    r"""
    Implements constant modulus adaptive filter on complex stream.

    The error value and tap update equations (for p=2) can be found in:


    D. Godard, "Self-Recovering Equalization and Carrier Tracking
    in Two-Dimensional Data Communication Systems," IEEE Transactions on Communications, Vol. 28, No. 11, pp. 1867 - 1875, 1980.

    Constructor Specific Documentation:

    Make a CMA Equalizer block

    Args:
        num_taps : Number of taps in the equalizer (channel size)
        modulus : Modulus of the modulated signals
        mu : Gain of the update loop
        sps : Number of samples per symbol of the input signal
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr

    @staticmethod
    def make(num_taps: "int", modulus: "float", mu: "float", sps: "int") -> "gr::digital::cma_equalizer_cc::sptr":
        r"""
        make(int num_taps, float modulus, float mu, int sps) -> cma_equalizer_cc_sptr
        Implements constant modulus adaptive filter on complex stream.

        The error value and tap update equations (for p=2) can be found in:


        D. Godard, "Self-Recovering Equalization and Carrier Tracking
        in Two-Dimensional Data Communication Systems," IEEE Transactions on Communications, Vol. 28, No. 11, pp. 1867 - 1875, 1980.

        Constructor Specific Documentation:

        Make a CMA Equalizer block

        Args:
            num_taps : Number of taps in the equalizer (channel size)
            modulus : Modulus of the modulated signals
            mu : Gain of the update loop
            sps : Number of samples per symbol of the input signal
        """
        return _digital_swig0.cma_equalizer_cc_make(num_taps, modulus, mu, sps)

    def set_taps(self, taps: "pmt_vector_cfloat") -> "void":
        r"""set_taps(cma_equalizer_cc self, pmt_vector_cfloat taps)"""
        return _digital_swig0.cma_equalizer_cc_set_taps(self, taps)

    def taps(self) -> "std::vector< gr_complex,std::allocator< gr_complex > >":
        r"""taps(cma_equalizer_cc self) -> pmt_vector_cfloat"""
        return _digital_swig0.cma_equalizer_cc_taps(self)

    def gain(self) -> "float":
        r"""gain(cma_equalizer_cc self) -> float"""
        return _digital_swig0.cma_equalizer_cc_gain(self)

    def set_gain(self, mu: "float") -> "void":
        r"""set_gain(cma_equalizer_cc self, float mu)"""
        return _digital_swig0.cma_equalizer_cc_set_gain(self, mu)

    def modulus(self) -> "float":
        r"""modulus(cma_equalizer_cc self) -> float"""
        return _digital_swig0.cma_equalizer_cc_modulus(self)

    def set_modulus(self, mod: "float") -> "void":
        r"""set_modulus(cma_equalizer_cc self, float mod)"""
        return _digital_swig0.cma_equalizer_cc_set_modulus(self, mod)
    __swig_destroy__ = _digital_swig0.delete_cma_equalizer_cc

# Register cma_equalizer_cc in _digital_swig0:
_digital_swig0.cma_equalizer_cc_swigregister(cma_equalizer_cc)
class constellation(object):
    r"""
    An abstracted constellation object.

    The constellation objects hold the necessary information to pass around constellation information for modulators and demodulators. These objects contain the mapping between the bits and the constellation points used to represent them as well as methods for slicing the symbol space. Various implementations are possible for efficiency and ease of use.


    Standard constellations (BPSK, QPSK, QAM, etc) can be inherited from this class and overloaded to perform optimized slicing and constellation mappings.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _digital_swig0.delete_constellation

    def map_to_points(self, value: "unsigned int", points: "gr_complex *") -> "void":
        r"""
        map_to_points(constellation self, unsigned int value, gr_complex * points)
        Returns the constellation points for a symbol value.
        """
        return _digital_swig0.constellation_map_to_points(self, value, points)

    def map_to_points_v(self, value: "unsigned int") -> "std::vector< gr_complex,std::allocator< gr_complex > >":
        r"""map_to_points_v(constellation self, unsigned int value) -> pmt_vector_cfloat"""
        return _digital_swig0.constellation_map_to_points_v(self, value)

    def decision_maker(self, sample: "gr_complex const *") -> "unsigned int":
        r"""
        decision_maker(constellation self, gr_complex const * sample) -> unsigned int
        Returns the constellation point that matches best.
        """
        return _digital_swig0.constellation_decision_maker(self, sample)

    def decision_maker_v(self, sample: "pmt_vector_cfloat") -> "unsigned int":
        r"""
        decision_maker_v(constellation self, pmt_vector_cfloat sample) -> unsigned int
        Takes a vector rather than a pointer. Better for SWIG wrapping.
        """
        return _digital_swig0.constellation_decision_maker_v(self, sample)

    def decision_maker_pe(self, sample: "gr_complex const *", phase_error: "float *") -> "unsigned int":
        r"""
        decision_maker_pe(constellation self, gr_complex const * sample, float * phase_error) -> unsigned int
        Also calculates the phase error.
        """
        return _digital_swig0.constellation_decision_maker_pe(self, sample, phase_error)

    def calc_metric(self, sample: "gr_complex const *", metric: "float *", type: "gr::digital::trellis_metric_type_t") -> "void":
        r"""
        calc_metric(constellation self, gr_complex const * sample, float * metric, gr::digital::trellis_metric_type_t type)
        Calculates distance.

        Calculates metrics for all points in the constellation. For use with the viterbi algorithm.
        """
        return _digital_swig0.constellation_calc_metric(self, sample, metric, type)

    def calc_euclidean_metric(self, sample: "gr_complex const *", metric: "float *") -> "void":
        r"""calc_euclidean_metric(constellation self, gr_complex const * sample, float * metric)"""
        return _digital_swig0.constellation_calc_euclidean_metric(self, sample, metric)

    def calc_hard_symbol_metric(self, sample: "gr_complex const *", metric: "float *") -> "void":
        r"""calc_hard_symbol_metric(constellation self, gr_complex const * sample, float * metric)"""
        return _digital_swig0.constellation_calc_hard_symbol_metric(self, sample, metric)

    def points(self) -> "std::vector< gr_complex,std::allocator< gr_complex > >":
        r"""
        points(constellation self) -> pmt_vector_cfloat
        Returns the set of points in this constellation.
        """
        return _digital_swig0.constellation_points(self)

    def s_points(self) -> "std::vector< gr_complex,std::allocator< gr_complex > >":
        r"""
        s_points(constellation self) -> pmt_vector_cfloat
        Returns the vector of points in this constellation. Raise error if dimensionality is not one.
        """
        return _digital_swig0.constellation_s_points(self)

    def v_points(self) -> "std::vector< std::vector< gr_complex,std::allocator< gr_complex > >,std::allocator< std::vector< gr_complex,std::allocator< gr_complex > > > >":
        r"""
        v_points(constellation self) -> gr_vector_vector_complexf
        Returns a vector of vectors of points.
        """
        return _digital_swig0.constellation_v_points(self)

    def apply_pre_diff_code(self) -> "bool":
        r"""
        apply_pre_diff_code(constellation self) -> bool
        Whether to apply an encoding before doing differential encoding. (e.g. gray coding)
        """
        return _digital_swig0.constellation_apply_pre_diff_code(self)

    def set_pre_diff_code(self, a: "bool") -> "void":
        r"""
        set_pre_diff_code(constellation self, bool a)
        Whether to apply an encoding before doing differential encoding. (e.g. gray coding)
        """
        return _digital_swig0.constellation_set_pre_diff_code(self, a)

    def pre_diff_code(self) -> "std::vector< int,std::allocator< int > >":
        r"""
        pre_diff_code(constellation self) -> std::vector< int,std::allocator< int > >
        Returns the encoding to apply before differential encoding.
        """
        return _digital_swig0.constellation_pre_diff_code(self)

    def rotational_symmetry(self) -> "unsigned int":
        r"""
        rotational_symmetry(constellation self) -> unsigned int
        Returns the order of rotational symmetry.
        """
        return _digital_swig0.constellation_rotational_symmetry(self)

    def dimensionality(self) -> "unsigned int":
        r"""
        dimensionality(constellation self) -> unsigned int
        Returns the number of complex numbers in a single symbol.
        """
        return _digital_swig0.constellation_dimensionality(self)

    def bits_per_symbol(self) -> "unsigned int":
        r"""bits_per_symbol(constellation self) -> unsigned int"""
        return _digital_swig0.constellation_bits_per_symbol(self)

    def arity(self) -> "unsigned int":
        r"""arity(constellation self) -> unsigned int"""
        return _digital_swig0.constellation_arity(self)

    def base(self) -> "gr::digital::constellation_sptr":
        r"""base(constellation self) -> constellation_sptr"""
        return _digital_swig0.constellation_base(self)

    def as_pmt(self) -> "pmt::pmt_t":
        r"""as_pmt(constellation self) -> swig_pmt_ptr"""
        return _digital_swig0.constellation_as_pmt(self)

    def gen_soft_dec_lut(self, precision: "int", npwr: "float"=1.0) -> "void":
        r"""
        gen_soft_dec_lut(constellation self, int precision, float npwr=1.0)
        Generates the soft decision LUT based on constellation and symbol map.

        Generates the soft decision LUT based on constellation and symbol map. It can be given a estimate of the noise power in the channel as .



        This is expensive to compute.
        """
        return _digital_swig0.constellation_gen_soft_dec_lut(self, precision, npwr)

    def calc_soft_dec(self, sample: "gr_complex", npwr: "float"=1.0) -> "std::vector< float,std::allocator< float > >":
        r"""
        calc_soft_dec(constellation self, gr_complex sample, float npwr=1.0) -> pmt_vector_float
        Calculate soft decisions for the given .

        Calculate the soft decisions from the given  at the given noise power .


        This is a very costly algorithm (especially for higher order modulations) and should be used sparingly. It uses the gen_soft_dec_lut function to generate the LUT, which should be done once or if a large change in the noise floor is detected.


        Instead of using this function, generate the LUT using the gen_soft_dec_lut after creating the constellation object and then use the soft_decision_maker function to return the answer from the LUT.
        """
        return _digital_swig0.constellation_calc_soft_dec(self, sample, npwr)

    def set_soft_dec_lut(self, soft_dec_lut: "std::vector< std::vector< float,std::allocator< float > >,std::allocator< std::vector< float,std::allocator< float > > > > const &", precision: "int") -> "void":
        r"""
        set_soft_dec_lut(constellation self, std::vector< std::vector< float,std::allocator< float > >,std::allocator< std::vector< float,std::allocator< float > > > > const & soft_dec_lut, int precision)
        Define a soft decision look-up table.

        Define a soft decision look-up table (LUT). Because soft decisions can be calculated in various ways with various levels of accuracy and complexity, this function allows users to create a LUT in their own way.


        Setting the LUT here means that has_soft_dec_lut will return true. Decision vectors returned by soft_decision_maker will be calculated using this LUT.
        """
        return _digital_swig0.constellation_set_soft_dec_lut(self, soft_dec_lut, precision)

    def has_soft_dec_lut(self) -> "bool":
        r"""
        has_soft_dec_lut(constellation self) -> bool
        Returns True if the soft decision LUT has been defined, False otherwise.
        """
        return _digital_swig0.constellation_has_soft_dec_lut(self)

    def soft_dec_lut(self) -> "std::vector< std::vector< float,std::allocator< float > >,std::allocator< std::vector< float,std::allocator< float > > > >":
        r"""soft_dec_lut(constellation self) -> std::vector< std::vector< float,std::allocator< float > >,std::allocator< std::vector< float,std::allocator< float > > > >"""
        return _digital_swig0.constellation_soft_dec_lut(self)

    def soft_decision_maker(self, sample: "gr_complex") -> "std::vector< float,std::allocator< float > >":
        r"""
        soft_decision_maker(constellation self, gr_complex sample) -> pmt_vector_float
        Returns the soft decisions for the given .

        Returns the soft decisions for the given . If a LUT is defined for the object, the decisions will be calculated from there. Otherwise, this function will call calc_soft_dec directly to calculate the soft decisions.
        """
        return _digital_swig0.constellation_soft_decision_maker(self, sample)

# Register constellation in _digital_swig0:
_digital_swig0.constellation_swigregister(constellation)
class constellation_calcdist(constellation):
    r"""
    Calculate Euclidean distance for any constellation.

    Constellation which calculates the distance to each point in the constellation for decision making. Inefficient for large constellations.

    Constructor Specific Documentation:

    Make a general constellation object that calculates the Euclidean distance for hard decisions.

    Args:
        constell : List of constellation points (order of list matches pre_diff_code)
        pre_diff_code : List of alphabet symbols (before applying any differential coding) (order of list matches constell)
        rotational_symmetry : Number of rotations around unit circle that have the same representation.
        dimensionality : Number of dimensions to the constellation.
        normalize_points : Normalize constellation points to mean(abs(points))=1 (default is true)
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    @staticmethod
    def make(constell: "pmt_vector_cfloat", pre_diff_code: "std::vector< int,std::allocator< int > >", rotational_symmetry: "unsigned int", dimensionality: "unsigned int", normalize_points: "bool"=True) -> "gr::digital::constellation_calcdist::sptr":
        r"""
        make(pmt_vector_cfloat constell, std::vector< int,std::allocator< int > > pre_diff_code, unsigned int rotational_symmetry, unsigned int dimensionality, bool normalize_points=True) -> constellation_calcdist_sptr
        Calculate Euclidean distance for any constellation.

        Constellation which calculates the distance to each point in the constellation for decision making. Inefficient for large constellations.

        Constructor Specific Documentation:

        Make a general constellation object that calculates the Euclidean distance for hard decisions.

        Args:
            constell : List of constellation points (order of list matches pre_diff_code)
            pre_diff_code : List of alphabet symbols (before applying any differential coding) (order of list matches constell)
            rotational_symmetry : Number of rotations around unit circle that have the same representation.
            dimensionality : Number of dimensions to the constellation.
            normalize_points : Normalize constellation points to mean(abs(points))=1 (default is true)
        """
        return _digital_swig0.constellation_calcdist_make(constell, pre_diff_code, rotational_symmetry, dimensionality, normalize_points)
    __swig_destroy__ = _digital_swig0.delete_constellation_calcdist

# Register constellation_calcdist in _digital_swig0:
_digital_swig0.constellation_calcdist_swigregister(constellation_calcdist)
class constellation_sector(constellation):
    r"""
    Sectorized digital constellation.

    constellation_sector


    Constellation space is divided into sectors. Each sector is associated with the nearest constellation point.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _digital_swig0.delete_constellation_sector

# Register constellation_sector in _digital_swig0:
_digital_swig0.constellation_sector_swigregister(constellation_sector)
class constellation_rect(constellation_sector):
    r"""
    Rectangular digital constellation.

    Only implemented for 1-(complex)dimensional constellation.


    Constellation space is divided into rectangular sectors. Each sector is associated with the nearest constellation point.


    Works well for square QAM.


    Works for any generic constellation provided sectors are not too large.

    Constructor Specific Documentation:

    Make a rectangular constellation object.

    Args:
        constell : List of constellation points (order of list matches pre_diff_code)
        pre_diff_code : List of alphabet symbols (before applying any differential coding) (order of list matches constell)
        rotational_symmetry : Number of rotations around unit circle that have the same representation.
        real_sectors : Number of sectors the real axis is split in to.
        imag_sectors : Number of sectors the imag axis is split in to.
        width_real_sectors : width of each real sector to calculate decision boundaries.
        width_imag_sectors : width of each imag sector to calculate decision boundaries.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    @staticmethod
    def make(constell: "pmt_vector_cfloat", pre_diff_code: "std::vector< int,std::allocator< int > >", rotational_symmetry: "unsigned int", real_sectors: "unsigned int", imag_sectors: "unsigned int", width_real_sectors: "float", width_imag_sectors: "float") -> "gr::digital::constellation_rect::sptr":
        r"""
        make(pmt_vector_cfloat constell, std::vector< int,std::allocator< int > > pre_diff_code, unsigned int rotational_symmetry, unsigned int real_sectors, unsigned int imag_sectors, float width_real_sectors, float width_imag_sectors) -> constellation_rect_sptr
        Rectangular digital constellation.

        Only implemented for 1-(complex)dimensional constellation.


        Constellation space is divided into rectangular sectors. Each sector is associated with the nearest constellation point.


        Works well for square QAM.


        Works for any generic constellation provided sectors are not too large.

        Constructor Specific Documentation:

        Make a rectangular constellation object.

        Args:
            constell : List of constellation points (order of list matches pre_diff_code)
            pre_diff_code : List of alphabet symbols (before applying any differential coding) (order of list matches constell)
            rotational_symmetry : Number of rotations around unit circle that have the same representation.
            real_sectors : Number of sectors the real axis is split in to.
            imag_sectors : Number of sectors the imag axis is split in to.
            width_real_sectors : width of each real sector to calculate decision boundaries.
            width_imag_sectors : width of each imag sector to calculate decision boundaries.
        """
        return _digital_swig0.constellation_rect_make(constell, pre_diff_code, rotational_symmetry, real_sectors, imag_sectors, width_real_sectors, width_imag_sectors)
    __swig_destroy__ = _digital_swig0.delete_constellation_rect

# Register constellation_rect in _digital_swig0:
_digital_swig0.constellation_rect_swigregister(constellation_rect)
class constellation_expl_rect(constellation_rect):
    r"""
    Rectangular digital constellation.

    Only implemented for 1-(complex)dimensional constellation.


    Constellation space is divided into rectangular sectors. Each sector is associated with the nearest constellation point.


    This class is different from constellation_rect in that the mapping from sector to constellation point is explicitly passed into the constructor as sector_values. Usually we do not need this, since we want each sector to be automatically mapped to the closest constellation point, however sometimes it's nice to have the flexibility.

    Constructor Specific Documentation:



    Args:
        constellation : 
        pre_diff_code : 
        rotational_symmetry : 
        real_sectors : 
        imag_sectors : 
        width_real_sectors : 
        width_imag_sectors : 
        sector_values : 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    @staticmethod
    def make(constellation: "pmt_vector_cfloat", pre_diff_code: "std::vector< int,std::allocator< int > >", rotational_symmetry: "unsigned int", real_sectors: "unsigned int", imag_sectors: "unsigned int", width_real_sectors: "float", width_imag_sectors: "float", sector_values: "std::vector< unsigned int,std::allocator< unsigned int > >") -> "gr::digital::constellation_expl_rect::sptr":
        r"""
        make(pmt_vector_cfloat constellation, std::vector< int,std::allocator< int > > pre_diff_code, unsigned int rotational_symmetry, unsigned int real_sectors, unsigned int imag_sectors, float width_real_sectors, float width_imag_sectors, std::vector< unsigned int,std::allocator< unsigned int > > sector_values) -> constellation_expl_rect_sptr
        Rectangular digital constellation.

        Only implemented for 1-(complex)dimensional constellation.


        Constellation space is divided into rectangular sectors. Each sector is associated with the nearest constellation point.


        This class is different from constellation_rect in that the mapping from sector to constellation point is explicitly passed into the constructor as sector_values. Usually we do not need this, since we want each sector to be automatically mapped to the closest constellation point, however sometimes it's nice to have the flexibility.

        Constructor Specific Documentation:



        Args:
            constellation : 
            pre_diff_code : 
            rotational_symmetry : 
            real_sectors : 
            imag_sectors : 
            width_real_sectors : 
            width_imag_sectors : 
            sector_values : 
        """
        return _digital_swig0.constellation_expl_rect_make(constellation, pre_diff_code, rotational_symmetry, real_sectors, imag_sectors, width_real_sectors, width_imag_sectors, sector_values)
    __swig_destroy__ = _digital_swig0.delete_constellation_expl_rect

# Register constellation_expl_rect in _digital_swig0:
_digital_swig0.constellation_expl_rect_swigregister(constellation_expl_rect)
class constellation_psk(constellation_sector):
    r"""
    constellation_psk

    Constellation space is divided into pie slices sectors.


    Each slice is associated with the nearest constellation point.


    Works well for PSK but nothing else.


    Assumes that there is a constellation point at 1.x

    Constructor Specific Documentation:



    Args:
        constell : 
        pre_diff_code : 
        n_sectors : 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    @staticmethod
    def make(constell: "pmt_vector_cfloat", pre_diff_code: "std::vector< int,std::allocator< int > >", n_sectors: "unsigned int") -> "gr::digital::constellation_psk::sptr":
        r"""
        make(pmt_vector_cfloat constell, std::vector< int,std::allocator< int > > pre_diff_code, unsigned int n_sectors) -> constellation_psk_sptr
        constellation_psk

        Constellation space is divided into pie slices sectors.


        Each slice is associated with the nearest constellation point.


        Works well for PSK but nothing else.


        Assumes that there is a constellation point at 1.x

        Constructor Specific Documentation:



        Args:
            constell : 
            pre_diff_code : 
            n_sectors : 
        """
        return _digital_swig0.constellation_psk_make(constell, pre_diff_code, n_sectors)
    __swig_destroy__ = _digital_swig0.delete_constellation_psk

# Register constellation_psk in _digital_swig0:
_digital_swig0.constellation_psk_swigregister(constellation_psk)
class constellation_bpsk(constellation):
    r"""
    Digital constellation for BPSK .

    Constructor Specific Documentation:


    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    @staticmethod
    def make() -> "gr::digital::constellation_bpsk::sptr":
        r"""
        make() -> constellation_bpsk_sptr
        Digital constellation for BPSK .

        Constructor Specific Documentation:


        """
        return _digital_swig0.constellation_bpsk_make()
    __swig_destroy__ = _digital_swig0.delete_constellation_bpsk

# Register constellation_bpsk in _digital_swig0:
_digital_swig0.constellation_bpsk_swigregister(constellation_bpsk)
class constellation_qpsk(constellation):
    r"""
    Digital constellation for QPSK.

    Constellation diagram assumes little endian format e.g. top, left means 2 not 1.

    Constructor Specific Documentation:


    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    @staticmethod
    def make() -> "gr::digital::constellation_qpsk::sptr":
        r"""
        make() -> constellation_qpsk_sptr
        Digital constellation for QPSK.

        Constellation diagram assumes little endian format e.g. top, left means 2 not 1.

        Constructor Specific Documentation:


        """
        return _digital_swig0.constellation_qpsk_make()
    __swig_destroy__ = _digital_swig0.delete_constellation_qpsk

# Register constellation_qpsk in _digital_swig0:
_digital_swig0.constellation_qpsk_swigregister(constellation_qpsk)
class constellation_dqpsk(constellation):
    r"""
    Digital constellation for DQPSK.

    Constructor Specific Documentation:


    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    @staticmethod
    def make() -> "gr::digital::constellation_dqpsk::sptr":
        r"""
        make() -> constellation_dqpsk_sptr
        Digital constellation for DQPSK.

        Constructor Specific Documentation:


        """
        return _digital_swig0.constellation_dqpsk_make()
    __swig_destroy__ = _digital_swig0.delete_constellation_dqpsk

# Register constellation_dqpsk in _digital_swig0:
_digital_swig0.constellation_dqpsk_swigregister(constellation_dqpsk)
class constellation_8psk(constellation):
    r"""
    Digital constellation for 8PSK.

    Constructor Specific Documentation:


    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    @staticmethod
    def make() -> "gr::digital::constellation_8psk::sptr":
        r"""
        make() -> constellation_8psk_sptr
        Digital constellation for 8PSK.

        Constructor Specific Documentation:


        """
        return _digital_swig0.constellation_8psk_make()
    __swig_destroy__ = _digital_swig0.delete_constellation_8psk

# Register constellation_8psk in _digital_swig0:
_digital_swig0.constellation_8psk_swigregister(constellation_8psk)
class constellation_8psk_natural(constellation):
    r"""
    Digital constellation for natually mapped 8PSK.

    Constructor Specific Documentation:


    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    @staticmethod
    def make() -> "gr::digital::constellation_8psk_natural::sptr":
        r"""
        make() -> constellation_8psk_natural_sptr
        Digital constellation for natually mapped 8PSK.

        Constructor Specific Documentation:


        """
        return _digital_swig0.constellation_8psk_natural_make()
    __swig_destroy__ = _digital_swig0.delete_constellation_8psk_natural

# Register constellation_8psk_natural in _digital_swig0:
_digital_swig0.constellation_8psk_natural_swigregister(constellation_8psk_natural)
class constellation_16qam(constellation):
    r"""
    Digital constellation for 16qam.

    Constructor Specific Documentation:


    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    @staticmethod
    def make() -> "gr::digital::constellation_16qam::sptr":
        r"""
        make() -> constellation_16qam_sptr
        Digital constellation for 16qam.

        Constructor Specific Documentation:


        """
        return _digital_swig0.constellation_16qam_make()
    __swig_destroy__ = _digital_swig0.delete_constellation_16qam

# Register constellation_16qam in _digital_swig0:
_digital_swig0.constellation_16qam_swigregister(constellation_16qam)
class constellation_decoder_cb(object):
    r"""
    Constellation Decoder.

    Decode a constellation's points from a complex space to (unpacked) bits based on the map of the  object.

    Constructor Specific Documentation:

    Make constellation decoder block.

    Args:
        constellation : A constellation derived from class 'constellation'. Use base() method to get a shared pointer to this base class type.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    @staticmethod
    def make(constellation: "constellation_sptr") -> "gr::digital::constellation_decoder_cb::sptr":
        r"""
        make(constellation_sptr constellation) -> constellation_decoder_cb_sptr
        Constellation Decoder.

        Decode a constellation's points from a complex space to (unpacked) bits based on the map of the  object.

        Constructor Specific Documentation:

        Make constellation decoder block.

        Args:
            constellation : A constellation derived from class 'constellation'. Use base() method to get a shared pointer to this base class type.
        """
        return _digital_swig0.constellation_decoder_cb_make(constellation)
    __swig_destroy__ = _digital_swig0.delete_constellation_decoder_cb

# Register constellation_decoder_cb in _digital_swig0:
_digital_swig0.constellation_decoder_cb_swigregister(constellation_decoder_cb)
class constellation_receiver_cb(control_loop):
    r"""
    This block makes hard decisions about the received symbols (using a constellation object) and also fine tunes phase synchronization.

    The phase and frequency synchronization are based on a Costas loop that finds the error of the incoming signal point compared to its nearest constellation point. The frequency and phase of the NCO are updated according to this error.


    Message Ports:


    set_constellation (input): Receives a PMT any containing a new gr::digital::constellation object. The PMT is cast back to a gr::digital::constellation_sptr and passes this to set_constellation.


    rotate_phase (input): Receives a PMT double to update the phase. The phase value passed in the message is added to the current phase of the receiver.

    Constructor Specific Documentation:

    Constructs a constellation receiver that (phase/fine freq) synchronizes and decodes constellation points specified by a constellation object.

    Args:
        constellation : constellation of points for generic modulation
        loop_bw : Loop bandwidth of the Costas Loop (~ 2pi/100)
        fmin : minimum normalized frequency value the loop can achieve
        fmax : maximum normalized frequency value the loop can achieve
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr

    @staticmethod
    def make(constellation: "constellation_sptr", loop_bw: "float", fmin: "float", fmax: "float") -> "gr::digital::constellation_receiver_cb::sptr":
        r"""
        make(constellation_sptr constellation, float loop_bw, float fmin, float fmax) -> constellation_receiver_cb_sptr
        This block makes hard decisions about the received symbols (using a constellation object) and also fine tunes phase synchronization.

        The phase and frequency synchronization are based on a Costas loop that finds the error of the incoming signal point compared to its nearest constellation point. The frequency and phase of the NCO are updated according to this error.


        Message Ports:


        set_constellation (input): Receives a PMT any containing a new gr::digital::constellation object. The PMT is cast back to a gr::digital::constellation_sptr and passes this to set_constellation.


        rotate_phase (input): Receives a PMT double to update the phase. The phase value passed in the message is added to the current phase of the receiver.

        Constructor Specific Documentation:

        Constructs a constellation receiver that (phase/fine freq) synchronizes and decodes constellation points specified by a constellation object.

        Args:
            constellation : constellation of points for generic modulation
            loop_bw : Loop bandwidth of the Costas Loop (~ 2pi/100)
            fmin : minimum normalized frequency value the loop can achieve
            fmax : maximum normalized frequency value the loop can achieve
        """
        return _digital_swig0.constellation_receiver_cb_make(constellation, loop_bw, fmin, fmax)

    def phase_error_tracking(self, phase_error: "float") -> "void":
        r"""phase_error_tracking(constellation_receiver_cb self, float phase_error)"""
        return _digital_swig0.constellation_receiver_cb_phase_error_tracking(self, phase_error)
    __swig_destroy__ = _digital_swig0.delete_constellation_receiver_cb

# Register constellation_receiver_cb in _digital_swig0:
_digital_swig0.constellation_receiver_cb_swigregister(constellation_receiver_cb)
class constellation_soft_decoder_cf(object):
    r"""
    Constellation Decoder.

    Decode a constellation's points from a complex space to soft bits based on the map and soft decision LUT of the  object.

    Constructor Specific Documentation:

    Make constellation decoder block.

    Args:
        constellation : A constellation derived from class 'constellation'. Use base() method to get a shared pointer to this base class type.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    @staticmethod
    def make(constellation: "constellation_sptr") -> "gr::digital::constellation_soft_decoder_cf::sptr":
        r"""
        make(constellation_sptr constellation) -> constellation_soft_decoder_cf_sptr
        Constellation Decoder.

        Decode a constellation's points from a complex space to soft bits based on the map and soft decision LUT of the  object.

        Constructor Specific Documentation:

        Make constellation decoder block.

        Args:
            constellation : A constellation derived from class 'constellation'. Use base() method to get a shared pointer to this base class type.
        """
        return _digital_swig0.constellation_soft_decoder_cf_make(constellation)
    __swig_destroy__ = _digital_swig0.delete_constellation_soft_decoder_cf

# Register constellation_soft_decoder_cf in _digital_swig0:
_digital_swig0.constellation_soft_decoder_cf_swigregister(constellation_soft_decoder_cf)
THRESHOLD_DYNAMIC = _digital_swig0.THRESHOLD_DYNAMIC

THRESHOLD_ABSOLUTE = _digital_swig0.THRESHOLD_ABSOLUTE

class corr_est_cc(object):
    r"""


    Constructor Specific Documentation:

    Make a block that correlates against the  vector and outputs a phase and symbol timing estimate.

    Args:
        symbols : Set of symbols to correlate against (e.g., a sync word).
        sps : Samples per symbol
        mark_delay : tag marking delay in samples after the corr_start tag
        threshold : Threshold of correlator, relative to a 100% correlation (1.0). Default is 0.9.
        threshold_method : Method for computing threshold.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr

    @staticmethod
    def make(*args, **kwargs) -> "gr::digital::corr_est_cc::sptr":
        r"""
        make(pmt_vector_cfloat symbols, float sps, unsigned int mark_delay, float threshold=0.9, gr::digital::tm_type threshold_method=THRESHOLD_ABSOLUTE) -> corr_est_cc_sptr


        Constructor Specific Documentation:

        Make a block that correlates against the  vector and outputs a phase and symbol timing estimate.

        Args:
            symbols : Set of symbols to correlate against (e.g., a sync word).
            sps : Samples per symbol
            mark_delay : tag marking delay in samples after the corr_start tag
            threshold : Threshold of correlator, relative to a 100% correlation (1.0). Default is 0.9.
            threshold_method : Method for computing threshold.
        """
        return _digital_swig0.corr_est_cc_make(*args, **kwargs)

    def symbols(self) -> "std::vector< gr_complex,std::allocator< gr_complex > >":
        r"""symbols(corr_est_cc self) -> pmt_vector_cfloat"""
        return _digital_swig0.corr_est_cc_symbols(self)

    def set_symbols(self, symbols: "pmt_vector_cfloat") -> "void":
        r"""set_symbols(corr_est_cc self, pmt_vector_cfloat symbols)"""
        return _digital_swig0.corr_est_cc_set_symbols(self, symbols)

    def mark_delay(self) -> "unsigned int":
        r"""mark_delay(corr_est_cc self) -> unsigned int"""
        return _digital_swig0.corr_est_cc_mark_delay(self)

    def set_mark_delay(self, mark_delay: "unsigned int") -> "void":
        r"""set_mark_delay(corr_est_cc self, unsigned int mark_delay)"""
        return _digital_swig0.corr_est_cc_set_mark_delay(self, mark_delay)

    def threshold(self) -> "float":
        r"""threshold(corr_est_cc self) -> float"""
        return _digital_swig0.corr_est_cc_threshold(self)

    def set_threshold(self, threshold: "float") -> "void":
        r"""set_threshold(corr_est_cc self, float threshold)"""
        return _digital_swig0.corr_est_cc_set_threshold(self, threshold)
    __swig_destroy__ = _digital_swig0.delete_corr_est_cc

# Register corr_est_cc in _digital_swig0:
_digital_swig0.corr_est_cc_swigregister(corr_est_cc)
class correlate_access_code_bb(object):
    r"""
    Examine input for specified access code, one bit at a time.

    input: stream of bits, 1 bit per input byte (data in LSB) output: stream of bits, 2 bits per output byte (data in LSB, flag in next higher bit)


    Each output byte contains two valid bits, the data bit, and the flag bit. The LSB (bit 0) is the data bit, and is the original input data, delayed 64 bits. Bit 1 is the flag bit and is 1 if the corresponding data bit is the first data bit following the access code. Otherwise the flag bit is 0.

    Constructor Specific Documentation:

    Make a correlate_access_code block.

    Args:
        access_code : is represented with 1 byte per bit, e.g., "010101010111000100"
        threshold : maximum number of bits that may be wrong
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr

    @staticmethod
    def make(access_code: "std::string const &", threshold: "int") -> "gr::digital::correlate_access_code_bb::sptr":
        r"""
        make(std::string const & access_code, int threshold) -> correlate_access_code_bb_sptr
        Examine input for specified access code, one bit at a time.

        input: stream of bits, 1 bit per input byte (data in LSB) output: stream of bits, 2 bits per output byte (data in LSB, flag in next higher bit)


        Each output byte contains two valid bits, the data bit, and the flag bit. The LSB (bit 0) is the data bit, and is the original input data, delayed 64 bits. Bit 1 is the flag bit and is 1 if the corresponding data bit is the first data bit following the access code. Otherwise the flag bit is 0.

        Constructor Specific Documentation:

        Make a correlate_access_code block.

        Args:
            access_code : is represented with 1 byte per bit, e.g., "010101010111000100"
            threshold : maximum number of bits that may be wrong
        """
        return _digital_swig0.correlate_access_code_bb_make(access_code, threshold)

    def set_access_code(self, access_code: "std::string const &") -> "bool":
        r"""
        set_access_code(correlate_access_code_bb self, std::string const & access_code) -> bool
        Set a new access code.
        """
        return _digital_swig0.correlate_access_code_bb_set_access_code(self, access_code)
    __swig_destroy__ = _digital_swig0.delete_correlate_access_code_bb

# Register correlate_access_code_bb in _digital_swig0:
_digital_swig0.correlate_access_code_bb_swigregister(correlate_access_code_bb)
class correlate_access_code_tag_bb(object):
    r"""
    Examine input for specified access code, one bit at a time.

    input: stream of bits, 1 bit per input byte (data in LSB) output: unaltered stream of bits (plus tags)


    This block annotates the input stream with tags. The tags have key name [tag_name], specified in the constructor. Used for searching an input data stream for preambles, etc.

    Constructor Specific Documentation:



    Args:
        access_code : is represented with 1 byte per bit, e.g., "010101010111000100"
        threshold : maximum number of bits that may be wrong
        tag_name : key of the tag inserted into the tag stream
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr

    @staticmethod
    def make(access_code: "std::string const &", threshold: "int", tag_name: "std::string const &") -> "gr::digital::correlate_access_code_tag_bb::sptr":
        r"""
        make(std::string const & access_code, int threshold, std::string const & tag_name) -> correlate_access_code_tag_bb_sptr
        Examine input for specified access code, one bit at a time.

        input: stream of bits, 1 bit per input byte (data in LSB) output: unaltered stream of bits (plus tags)


        This block annotates the input stream with tags. The tags have key name [tag_name], specified in the constructor. Used for searching an input data stream for preambles, etc.

        Constructor Specific Documentation:



        Args:
            access_code : is represented with 1 byte per bit, e.g., "010101010111000100"
            threshold : maximum number of bits that may be wrong
            tag_name : key of the tag inserted into the tag stream
        """
        return _digital_swig0.correlate_access_code_tag_bb_make(access_code, threshold, tag_name)

    def set_access_code(self, access_code: "std::string const &") -> "bool":
        r"""set_access_code(correlate_access_code_tag_bb self, std::string const & access_code) -> bool"""
        return _digital_swig0.correlate_access_code_tag_bb_set_access_code(self, access_code)

    def set_threshold(self, threshold: "int") -> "void":
        r"""set_threshold(correlate_access_code_tag_bb self, int threshold)"""
        return _digital_swig0.correlate_access_code_tag_bb_set_threshold(self, threshold)

    def set_tagname(self, tagname: "std::string const &") -> "void":
        r"""set_tagname(correlate_access_code_tag_bb self, std::string const & tagname)"""
        return _digital_swig0.correlate_access_code_tag_bb_set_tagname(self, tagname)
    __swig_destroy__ = _digital_swig0.delete_correlate_access_code_tag_bb

# Register correlate_access_code_tag_bb in _digital_swig0:
_digital_swig0.correlate_access_code_tag_bb_swigregister(correlate_access_code_tag_bb)
class correlate_access_code_tag_ff(object):
    r"""
    Examine input for specified access code, one bit at a time.

    input: stream of floats (generally, soft decisions) output: unaltered stream of bits (plus tags)


    This block annotates the input stream with tags. The tags have key name [tag_name], specified in the constructor. Used for searching an input data stream for preambles, etc., by slicing the soft decision symbol inputs.

    Constructor Specific Documentation:



    Args:
        access_code : is represented with 1 byte per bit, e.g., "010101010111000100"
        threshold : maximum number of bits that may be wrong
        tag_name : key of the tag inserted into the tag stream
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr

    @staticmethod
    def make(access_code: "std::string const &", threshold: "int", tag_name: "std::string const &") -> "gr::digital::correlate_access_code_tag_ff::sptr":
        r"""
        make(std::string const & access_code, int threshold, std::string const & tag_name) -> correlate_access_code_tag_ff_sptr
        Examine input for specified access code, one bit at a time.

        input: stream of floats (generally, soft decisions) output: unaltered stream of bits (plus tags)


        This block annotates the input stream with tags. The tags have key name [tag_name], specified in the constructor. Used for searching an input data stream for preambles, etc., by slicing the soft decision symbol inputs.

        Constructor Specific Documentation:



        Args:
            access_code : is represented with 1 byte per bit, e.g., "010101010111000100"
            threshold : maximum number of bits that may be wrong
            tag_name : key of the tag inserted into the tag stream
        """
        return _digital_swig0.correlate_access_code_tag_ff_make(access_code, threshold, tag_name)

    def set_access_code(self, access_code: "std::string const &") -> "bool":
        r"""set_access_code(correlate_access_code_tag_ff self, std::string const & access_code) -> bool"""
        return _digital_swig0.correlate_access_code_tag_ff_set_access_code(self, access_code)

    def set_threshold(self, threshold: "int") -> "void":
        r"""set_threshold(correlate_access_code_tag_ff self, int threshold)"""
        return _digital_swig0.correlate_access_code_tag_ff_set_threshold(self, threshold)

    def set_tagname(self, tagname: "std::string const &") -> "void":
        r"""set_tagname(correlate_access_code_tag_ff self, std::string const & tagname)"""
        return _digital_swig0.correlate_access_code_tag_ff_set_tagname(self, tagname)
    __swig_destroy__ = _digital_swig0.delete_correlate_access_code_tag_ff

# Register correlate_access_code_tag_ff in _digital_swig0:
_digital_swig0.correlate_access_code_tag_ff_swigregister(correlate_access_code_tag_ff)
class correlate_access_code_bb_ts(object):
    r"""
    Examine input for specified access code, one bit at a time.

    input: stream of bits (unpacked bytes) output: a tagged stream set of bits from the payload following the access code and header.


    This block searches for the given access code by reading in the input bits. Once found, it expects the following 32 samples to contain a header that includes the frame length (16 bits for the length, repeated). It decodes the header to get the frame length in order to set up the the tagged stream key information.


    The output of this block is appropriate for use with tagged stream blocks.

    Constructor Specific Documentation:



    Args:
        access_code : is represented with 1 byte per bit, e.g., "010101010111000100"
        threshold : maximum number of bits that may be wrong
        tag_name : key of the tag inserted into the tag stream
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr

    @staticmethod
    def make(access_code: "std::string const &", threshold: "int", tag_name: "std::string const &") -> "gr::digital::correlate_access_code_bb_ts::sptr":
        r"""
        make(std::string const & access_code, int threshold, std::string const & tag_name) -> correlate_access_code_bb_ts_sptr
        Examine input for specified access code, one bit at a time.

        input: stream of bits (unpacked bytes) output: a tagged stream set of bits from the payload following the access code and header.


        This block searches for the given access code by reading in the input bits. Once found, it expects the following 32 samples to contain a header that includes the frame length (16 bits for the length, repeated). It decodes the header to get the frame length in order to set up the the tagged stream key information.


        The output of this block is appropriate for use with tagged stream blocks.

        Constructor Specific Documentation:



        Args:
            access_code : is represented with 1 byte per bit, e.g., "010101010111000100"
            threshold : maximum number of bits that may be wrong
            tag_name : key of the tag inserted into the tag stream
        """
        return _digital_swig0.correlate_access_code_bb_ts_make(access_code, threshold, tag_name)

    def set_access_code(self, access_code: "std::string const &") -> "bool":
        r"""set_access_code(correlate_access_code_bb_ts self, std::string const & access_code) -> bool"""
        return _digital_swig0.correlate_access_code_bb_ts_set_access_code(self, access_code)

    def access_code(self) -> "unsigned long long":
        r"""access_code(correlate_access_code_bb_ts self) -> unsigned long long"""
        return _digital_swig0.correlate_access_code_bb_ts_access_code(self)
    __swig_destroy__ = _digital_swig0.delete_correlate_access_code_bb_ts

# Register correlate_access_code_bb_ts in _digital_swig0:
_digital_swig0.correlate_access_code_bb_ts_swigregister(correlate_access_code_bb_ts)
class correlate_access_code_ff_ts(object):
    r"""
    Examine input for specified access code, one bit at a time.

    input: stream of floats (generally, soft decisions) output: a tagged stream set of samples from the payload following the access code and header.


    This block searches for the given access code by slicing the soft decision symbol inputs. Once found, it expects the following 32 samples to contain a header that includes the frame length (16 bits for the length, repeated). It decodes the header to get the frame length in order to set up the the tagged stream key information.


    The output of this block is appropriate for use with tagged stream blocks.

    Constructor Specific Documentation:



    Args:
        access_code : is represented with 1 byte per bit, e.g., "010101010111000100"
        threshold : maximum number of bits that may be wrong
        tag_name : key of the tag inserted into the tag stream
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr

    @staticmethod
    def make(access_code: "std::string const &", threshold: "int", tag_name: "std::string const &") -> "gr::digital::correlate_access_code_ff_ts::sptr":
        r"""
        make(std::string const & access_code, int threshold, std::string const & tag_name) -> correlate_access_code_ff_ts_sptr
        Examine input for specified access code, one bit at a time.

        input: stream of floats (generally, soft decisions) output: a tagged stream set of samples from the payload following the access code and header.


        This block searches for the given access code by slicing the soft decision symbol inputs. Once found, it expects the following 32 samples to contain a header that includes the frame length (16 bits for the length, repeated). It decodes the header to get the frame length in order to set up the the tagged stream key information.


        The output of this block is appropriate for use with tagged stream blocks.

        Constructor Specific Documentation:



        Args:
            access_code : is represented with 1 byte per bit, e.g., "010101010111000100"
            threshold : maximum number of bits that may be wrong
            tag_name : key of the tag inserted into the tag stream
        """
        return _digital_swig0.correlate_access_code_ff_ts_make(access_code, threshold, tag_name)

    def set_access_code(self, access_code: "std::string const &") -> "bool":
        r"""set_access_code(correlate_access_code_ff_ts self, std::string const & access_code) -> bool"""
        return _digital_swig0.correlate_access_code_ff_ts_set_access_code(self, access_code)

    def access_code(self) -> "unsigned long long":
        r"""access_code(correlate_access_code_ff_ts self) -> unsigned long long"""
        return _digital_swig0.correlate_access_code_ff_ts_access_code(self)
    __swig_destroy__ = _digital_swig0.delete_correlate_access_code_ff_ts

# Register correlate_access_code_ff_ts in _digital_swig0:
_digital_swig0.correlate_access_code_ff_ts_swigregister(correlate_access_code_ff_ts)
class costas_loop_cc(control_loop):
    r"""
    A Costas loop carrier recovery module.

    The Costas loop locks to the center frequency of a signal and downconverts it to baseband.





    More details can be found online:


    J. Feigin, "Practical Costas loop design: Designing a simple
    and inexpensive BPSK Costas loop carrier recovery circuit," RF signal processing, pp. 20-36, 2002.





    The Costas loop can have two output streams: 
    There is a single optional message input:

    Constructor Specific Documentation:

    Make a Costas loop carrier recovery block.

    Args:
        loop_bw : internal 2nd order loop bandwidth (~ 2pi/100)
        order : the loop order, either 2, 4, or 8
        use_snr : Use or ignore SNR estimates (from noise message port) in measurements; also uses tanh instead of slicing.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr

    @staticmethod
    def make(loop_bw: "float", order: "int", use_snr: "bool"=False) -> "gr::digital::costas_loop_cc::sptr":
        r"""
        make(float loop_bw, int order, bool use_snr=False) -> costas_loop_cc_sptr
        A Costas loop carrier recovery module.

        The Costas loop locks to the center frequency of a signal and downconverts it to baseband.





        More details can be found online:


        J. Feigin, "Practical Costas loop design: Designing a simple
        and inexpensive BPSK Costas loop carrier recovery circuit," RF signal processing, pp. 20-36, 2002.





        The Costas loop can have two output streams: 
        There is a single optional message input:

        Constructor Specific Documentation:

        Make a Costas loop carrier recovery block.

        Args:
            loop_bw : internal 2nd order loop bandwidth (~ 2pi/100)
            order : the loop order, either 2, 4, or 8
            use_snr : Use or ignore SNR estimates (from noise message port) in measurements; also uses tanh instead of slicing.
        """
        return _digital_swig0.costas_loop_cc_make(loop_bw, order, use_snr)

    def error(self) -> "float":
        r"""
        error(costas_loop_cc self) -> float
        Returns the current value of the loop error.
        """
        return _digital_swig0.costas_loop_cc_error(self)
    __swig_destroy__ = _digital_swig0.delete_costas_loop_cc

# Register costas_loop_cc in _digital_swig0:
_digital_swig0.costas_loop_cc_swigregister(costas_loop_cc)
class cpmmod_bc(object):
    r"""
    Generic CPM modulator.

    Examples:



    The input of this block are symbols from an M-ary alphabet +/-1, +/-3, ..., +/-(M-1). Usually, M = 2 and therefore, the valid inputs are +/-1. The modulator will silently accept any other inputs, though. The output is the phase-modulated signal.

    Constructor Specific Documentation:

    Make CPM modulator block.

    Args:
        type : The modulation type. Can be one of LREC, LRC, LSRC, TFM or GAUSSIAN. See gr_cpm::phase_response() for a detailed description.
        h : The modulation index.  is the maximum phase change that can occur between two symbols, i.e., if you only send ones, the phase will increase by   every  samples. Set this to 0.5 for Minimum Shift Keying variants.
        samples_per_sym : Samples per symbol.
        L : The length of the phase duration in symbols. For L=1, this yields full- response CPM symbols, for L > 1, partial-response.
        beta : For LSRC, this is the rolloff factor. For Gaussian pulses, this is the 3 dB time-bandwidth product.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr

    @staticmethod
    def make(type: "gr::analog::cpm::cpm_type", h: "float", samples_per_sym: "int", L: "int", beta: "double"=0.3) -> "gr::digital::cpmmod_bc::sptr":
        r"""
        make(gr::analog::cpm::cpm_type type, float h, int samples_per_sym, int L, double beta=0.3) -> cpmmod_bc_sptr
        Generic CPM modulator.

        Examples:



        The input of this block are symbols from an M-ary alphabet +/-1, +/-3, ..., +/-(M-1). Usually, M = 2 and therefore, the valid inputs are +/-1. The modulator will silently accept any other inputs, though. The output is the phase-modulated signal.

        Constructor Specific Documentation:

        Make CPM modulator block.

        Args:
            type : The modulation type. Can be one of LREC, LRC, LSRC, TFM or GAUSSIAN. See gr_cpm::phase_response() for a detailed description.
            h : The modulation index.  is the maximum phase change that can occur between two symbols, i.e., if you only send ones, the phase will increase by   every  samples. Set this to 0.5 for Minimum Shift Keying variants.
            samples_per_sym : Samples per symbol.
            L : The length of the phase duration in symbols. For L=1, this yields full- response CPM symbols, for L > 1, partial-response.
            beta : For LSRC, this is the rolloff factor. For Gaussian pulses, this is the 3 dB time-bandwidth product.
        """
        return _digital_swig0.cpmmod_bc_make(type, h, samples_per_sym, L, beta)

    @staticmethod
    def make_gmskmod_bc(samples_per_sym: "int"=2, L: "int"=4, beta: "double"=0.3) -> "gr::digital::cpmmod_bc::sptr":
        r"""
        make_gmskmod_bc(int samples_per_sym=2, int L=4, double beta=0.3) -> cpmmod_bc_sptr
        Make GMSK modulator block.


        The type is GAUSSIAN and the modulation index for GMSK is 0.5. This are populated automatically by this factory function.
        """
        return _digital_swig0.cpmmod_bc_make_gmskmod_bc(samples_per_sym, L, beta)

    def taps(self) -> "std::vector< float,std::allocator< float > >":
        r"""
        taps(cpmmod_bc self) -> pmt_vector_float
        Return the phase response FIR taps.
        """
        return _digital_swig0.cpmmod_bc_taps(self)

    def type(self) -> "int":
        r"""
        type(cpmmod_bc self) -> int
        Return the type of CPM modulator.
        """
        return _digital_swig0.cpmmod_bc_type(self)

    def index(self) -> "float":
        r"""
        index(cpmmod_bc self) -> float
        Return the modulation index of the modulator.
        """
        return _digital_swig0.cpmmod_bc_index(self)

    def samples_per_sym(self) -> "int":
        r"""
        samples_per_sym(cpmmod_bc self) -> int
        Return the number of samples per symbol.
        """
        return _digital_swig0.cpmmod_bc_samples_per_sym(self)

    def length(self) -> "int":
        r"""
        length(cpmmod_bc self) -> int
        Return the length of the phase duration (in symbols)
        """
        return _digital_swig0.cpmmod_bc_length(self)

    def beta(self) -> "double":
        r"""
        beta(cpmmod_bc self) -> double
        Return the value of beta for the modulator.
        """
        return _digital_swig0.cpmmod_bc_beta(self)
    __swig_destroy__ = _digital_swig0.delete_cpmmod_bc

# Register cpmmod_bc in _digital_swig0:
_digital_swig0.cpmmod_bc_swigregister(cpmmod_bc)

def update_crc32(*args) -> "unsigned int":
    r"""
    update_crc32(unsigned int crc, unsigned char const * buf, size_t len) -> unsigned int
    update_crc32(unsigned int crc, std::string const buf) -> unsigned int
    update running CRC-32

    Update a running CRC with the bytes buf[0..len-1] The CRC should be initialized to all 1's, and the transmitted value is the 1's complement of the final running CRC. The resulting CRC should be transmitted in big endian order.
    """
    return _digital_swig0.update_crc32(*args)

def crc32(*args) -> "unsigned int":
    r"""
    crc32(unsigned char const * buf, size_t len) -> unsigned int
    crc32(std::string const buf) -> unsigned int
    """
    return _digital_swig0.crc32(*args)
class crc32_bb(object):
    r"""
    Byte-stream CRC block.

    Input: stream of bytes, which form a packet. The first byte of the packet has a tag with key "length" and the value being the number of bytes in the packet.


    Output: The same bytes as incoming, but trailing a CRC32 of the packet. The tag is re-set to the new length.

    Constructor Specific Documentation:



    Args:
        check : Set to true if you want to check CRC, false to create CRC.
        lengthtagname : Length tag key for the tagged stream.
        packed : If the data is packed or unpacked bits (default=true).
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    @staticmethod
    def make(*args, **kwargs) -> "gr::digital::crc32_bb::sptr":
        r"""
        make(bool check=False, std::string const & lengthtagname="packet_len", bool packed=True) -> crc32_bb_sptr
        Byte-stream CRC block.

        Input: stream of bytes, which form a packet. The first byte of the packet has a tag with key "length" and the value being the number of bytes in the packet.


        Output: The same bytes as incoming, but trailing a CRC32 of the packet. The tag is re-set to the new length.

        Constructor Specific Documentation:



        Args:
            check : Set to true if you want to check CRC, false to create CRC.
            lengthtagname : Length tag key for the tagged stream.
            packed : If the data is packed or unpacked bits (default=true).
        """
        return _digital_swig0.crc32_bb_make(*args, **kwargs)
    __swig_destroy__ = _digital_swig0.delete_crc32_bb

# Register crc32_bb in _digital_swig0:
_digital_swig0.crc32_bb_swigregister(crc32_bb)
class crc32_async_bb(object):
    r"""
    Byte-stream CRC block for async messages.

    Processes packets (as async PDU messages) for CRC32. The  parameter determines if the block acts to check and strip the CRC or to calculate and append the CRC32.


    The input PDU is expected to be a message of packet bytes.


    When using check mode, if the CRC passes, the output is a payload of the message with the CRC stripped, so the output will be 4 bytes smaller than the input.


    When using calculate mode (check == false), then the CRC is calculated on the PDU and appended to it. The output is then 4 bytes longer than the input.


    This block implements the CRC32 using the Boost crc_optimal class for 32-bit CRCs with the standard generator 0x04C11DB7.

    Constructor Specific Documentation:



    Args:
        check : Set to true if you want to check CRC, false to create CRC.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    @staticmethod
    def make(check: "bool"=False) -> "gr::digital::crc32_async_bb::sptr":
        r"""
        make(bool check=False) -> crc32_async_bb_sptr
        Byte-stream CRC block for async messages.

        Processes packets (as async PDU messages) for CRC32. The  parameter determines if the block acts to check and strip the CRC or to calculate and append the CRC32.


        The input PDU is expected to be a message of packet bytes.


        When using check mode, if the CRC passes, the output is a payload of the message with the CRC stripped, so the output will be 4 bytes smaller than the input.


        When using calculate mode (check == false), then the CRC is calculated on the PDU and appended to it. The output is then 4 bytes longer than the input.


        This block implements the CRC32 using the Boost crc_optimal class for 32-bit CRCs with the standard generator 0x04C11DB7.

        Constructor Specific Documentation:



        Args:
            check : Set to true if you want to check CRC, false to create CRC.
        """
        return _digital_swig0.crc32_async_bb_make(check)
    __swig_destroy__ = _digital_swig0.delete_crc32_async_bb

# Register crc32_async_bb in _digital_swig0:
_digital_swig0.crc32_async_bb_swigregister(crc32_async_bb)
class descrambler_bb(object):
    r"""
    Descramber an input stream using an LFSR.

    Descramble an input stream using an LFSR. This block works on the LSB only of the input data stream, i.e., on an "unpacked
    binary" stream, and produces the same format on its output.

    Constructor Specific Documentation:

    Make a descrambler block.

    Args:
        mask : Polynomial mask for LFSR
        seed : Initial shift register contents
        len : Shift register length
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    @staticmethod
    def make(mask: "int", seed: "int", len: "int") -> "gr::digital::descrambler_bb::sptr":
        r"""
        make(int mask, int seed, int len) -> descrambler_bb_sptr
        Descramber an input stream using an LFSR.

        Descramble an input stream using an LFSR. This block works on the LSB only of the input data stream, i.e., on an "unpacked
        binary" stream, and produces the same format on its output.

        Constructor Specific Documentation:

        Make a descrambler block.

        Args:
            mask : Polynomial mask for LFSR
            seed : Initial shift register contents
            len : Shift register length
        """
        return _digital_swig0.descrambler_bb_make(mask, seed, len)
    __swig_destroy__ = _digital_swig0.delete_descrambler_bb

# Register descrambler_bb in _digital_swig0:
_digital_swig0.descrambler_bb_swigregister(descrambler_bb)
class lms_dd_equalizer_cc(object):
    r"""
    Least-Mean-Square Decision Directed Equalizer (complex in/out)

    This block implements an LMS-based decision-directed equalizer. It uses a set of weights, w, to correlate against the inputs, u, and a decisions is then made from this output. The error in the decision is used to update the weight vector.


    y[n] = conj(w[n]) u[n] d[n] = decision(y[n]) e[n] = d[n] - y[n] w[n+1] = w[n] + mu u[n] conj(e[n])


    Where mu is a gain value (between 0 and 1 and usually small, around 0.001 - 0.01.


    This block uses the digital_constellation object for making the decision from y[n]. Create the constellation object for whatever constellation is to be used and pass in the object. In Python, you can use something like:


    self.constellation = digital.constellation_qpsk()


    To create a QPSK constellation (see the digital_constellation block for more details as to what constellations are available or how to create your own). You then pass the object to this block as an sptr, or using "self.constellation.base()".


    The theory for this algorithm can be found in Chapter 9 of: S. Haykin, Adaptive Filter Theory, Upper Saddle River, NJ: Prentice Hall, 1996.

    Constructor Specific Documentation:

    Make an LMS decision-directed equalizer

    Args:
        num_taps : Number of taps in the equalizer (channel size)
        mu : Gain of the update loop
        sps : Number of samples per symbol of the input signal
        cnst : A constellation derived from class 'constellation'. Use base() method to get a shared pointer to this base class type.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr

    @staticmethod
    def make(num_taps: "int", mu: "float", sps: "int", cnst: "constellation_sptr") -> "gr::digital::lms_dd_equalizer_cc::sptr":
        r"""
        make(int num_taps, float mu, int sps, constellation_sptr cnst) -> lms_dd_equalizer_cc_sptr
        Least-Mean-Square Decision Directed Equalizer (complex in/out)

        This block implements an LMS-based decision-directed equalizer. It uses a set of weights, w, to correlate against the inputs, u, and a decisions is then made from this output. The error in the decision is used to update the weight vector.


        y[n] = conj(w[n]) u[n] d[n] = decision(y[n]) e[n] = d[n] - y[n] w[n+1] = w[n] + mu u[n] conj(e[n])


        Where mu is a gain value (between 0 and 1 and usually small, around 0.001 - 0.01.


        This block uses the digital_constellation object for making the decision from y[n]. Create the constellation object for whatever constellation is to be used and pass in the object. In Python, you can use something like:


        self.constellation = digital.constellation_qpsk()


        To create a QPSK constellation (see the digital_constellation block for more details as to what constellations are available or how to create your own). You then pass the object to this block as an sptr, or using "self.constellation.base()".


        The theory for this algorithm can be found in Chapter 9 of: S. Haykin, Adaptive Filter Theory, Upper Saddle River, NJ: Prentice Hall, 1996.

        Constructor Specific Documentation:

        Make an LMS decision-directed equalizer

        Args:
            num_taps : Number of taps in the equalizer (channel size)
            mu : Gain of the update loop
            sps : Number of samples per symbol of the input signal
            cnst : A constellation derived from class 'constellation'. Use base() method to get a shared pointer to this base class type.
        """
        return _digital_swig0.lms_dd_equalizer_cc_make(num_taps, mu, sps, cnst)

    def set_taps(self, taps: "pmt_vector_cfloat") -> "void":
        r"""set_taps(lms_dd_equalizer_cc self, pmt_vector_cfloat taps)"""
        return _digital_swig0.lms_dd_equalizer_cc_set_taps(self, taps)

    def taps(self) -> "std::vector< gr_complex,std::allocator< gr_complex > >":
        r"""taps(lms_dd_equalizer_cc self) -> pmt_vector_cfloat"""
        return _digital_swig0.lms_dd_equalizer_cc_taps(self)

    def gain(self) -> "float":
        r"""gain(lms_dd_equalizer_cc self) -> float"""
        return _digital_swig0.lms_dd_equalizer_cc_gain(self)

    def set_gain(self, mu: "float") -> "void":
        r"""set_gain(lms_dd_equalizer_cc self, float mu)"""
        return _digital_swig0.lms_dd_equalizer_cc_set_gain(self, mu)
    __swig_destroy__ = _digital_swig0.delete_lms_dd_equalizer_cc

# Register lms_dd_equalizer_cc in _digital_swig0:
_digital_swig0.lms_dd_equalizer_cc_swigregister(lms_dd_equalizer_cc)
class ofdm_carrier_allocator_cvc(object):
    r"""
    Create frequency domain OFDM symbols from complex values, add pilots.

    This block turns a stream of complex, scalar modulation symbols into vectors which are the input for an IFFT in an OFDM transmitter. It also supports the possibility of placing pilot symbols onto the carriers.


    The carriers can be allocated freely, if a carrier is not allocated, it is set to zero. This allows doing OFDMA-style carrier allocations.


    Input: A tagged stream of complex scalars. The first item must have a tag containing the number of complex symbols in this frame. Output: A tagged stream of complex vectors of length fft_len. This can directly be connected to an FFT block. Make sure to set this block to 'reverse' for the IFFT. If  is true, the FFT block must activate FFT shifting, otherwise, set shifting to false. If given, sync words are prepended to the output. Note that sync words are prepended verbatim, make sure they are shifted (or not).


    Carrier indexes are always such that index 0 is the DC carrier (note: you should not allocate this carrier). The carriers below the DC carrier are either indexed with negative numbers, or with indexes larger than . Index -1 and index  both identify the carrier below the DC carrier.


    There are some basic checks in place during initialization which check that the carrier allocation table is valid. However, it is possible to overwrite data symbols with pilot symbols, or provide a carrier allocation that has mismatching pilot symbol positions and -values.


    Tags are propagated such that a tag on an incoming complex symbol is mapped to the corresponding OFDM symbol. There is one exception: If a tag is on the first OFDM symbol, it is assumed that this tag should stay there, so it is moved to the front even if a sync word is included (any other tags will never be attached to the sync word). This allows tags to control the transmit timing to pass through in the correct position.

    Constructor Specific Documentation:



    Args:
        fft_len : 
        occupied_carriers : 
        pilot_carriers : 
        pilot_symbols : 
        sync_words : 
        len_tag_key : 
        output_is_shifted : 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr

    def len_tag_key(self) -> "std::string":
        r"""len_tag_key(ofdm_carrier_allocator_cvc self) -> std::string"""
        return _digital_swig0.ofdm_carrier_allocator_cvc_len_tag_key(self)

    def fft_len(self) -> "int const":
        r"""fft_len(ofdm_carrier_allocator_cvc self) -> int const"""
        return _digital_swig0.ofdm_carrier_allocator_cvc_fft_len(self)

    def occupied_carriers(self) -> "std::vector< std::vector< int,std::allocator< int > >,std::allocator< std::vector< int,std::allocator< int > > > >":
        r"""occupied_carriers(ofdm_carrier_allocator_cvc self) -> std::vector< std::vector< int,std::allocator< int > >,std::allocator< std::vector< int,std::allocator< int > > > >"""
        return _digital_swig0.ofdm_carrier_allocator_cvc_occupied_carriers(self)

    @staticmethod
    def make(*args, **kwargs) -> "gr::digital::ofdm_carrier_allocator_cvc::sptr":
        r"""
        make(int fft_len, std::vector< std::vector< int,std::allocator< int > >,std::allocator< std::vector< int,std::allocator< int > > > > const & occupied_carriers, std::vector< std::vector< int,std::allocator< int > >,std::allocator< std::vector< int,std::allocator< int > > > > const & pilot_carriers, gr_vector_vector_complexf pilot_symbols, gr_vector_vector_complexf sync_words, std::string const & len_tag_key="packet_len", bool const output_is_shifted=True) -> ofdm_carrier_allocator_cvc_sptr
        Create frequency domain OFDM symbols from complex values, add pilots.

        This block turns a stream of complex, scalar modulation symbols into vectors which are the input for an IFFT in an OFDM transmitter. It also supports the possibility of placing pilot symbols onto the carriers.


        The carriers can be allocated freely, if a carrier is not allocated, it is set to zero. This allows doing OFDMA-style carrier allocations.


        Input: A tagged stream of complex scalars. The first item must have a tag containing the number of complex symbols in this frame. Output: A tagged stream of complex vectors of length fft_len. This can directly be connected to an FFT block. Make sure to set this block to 'reverse' for the IFFT. If  is true, the FFT block must activate FFT shifting, otherwise, set shifting to false. If given, sync words are prepended to the output. Note that sync words are prepended verbatim, make sure they are shifted (or not).


        Carrier indexes are always such that index 0 is the DC carrier (note: you should not allocate this carrier). The carriers below the DC carrier are either indexed with negative numbers, or with indexes larger than . Index -1 and index  both identify the carrier below the DC carrier.


        There are some basic checks in place during initialization which check that the carrier allocation table is valid. However, it is possible to overwrite data symbols with pilot symbols, or provide a carrier allocation that has mismatching pilot symbol positions and -values.


        Tags are propagated such that a tag on an incoming complex symbol is mapped to the corresponding OFDM symbol. There is one exception: If a tag is on the first OFDM symbol, it is assumed that this tag should stay there, so it is moved to the front even if a sync word is included (any other tags will never be attached to the sync word). This allows tags to control the transmit timing to pass through in the correct position.

        Constructor Specific Documentation:



        Args:
            fft_len : 
            occupied_carriers : 
            pilot_carriers : 
            pilot_symbols : 
            sync_words : 
            len_tag_key : 
            output_is_shifted : 
        """
        return _digital_swig0.ofdm_carrier_allocator_cvc_make(*args, **kwargs)
    __swig_destroy__ = _digital_swig0.delete_ofdm_carrier_allocator_cvc

# Register ofdm_carrier_allocator_cvc in _digital_swig0:
_digital_swig0.ofdm_carrier_allocator_cvc_swigregister(ofdm_carrier_allocator_cvc)
class ofdm_chanest_vcvc(object):
    r"""
    Estimate channel and coarse frequency offset for OFDM from preambles.

    Input: OFDM symbols (in frequency domain). The first one (or two) symbols are expected to be synchronisation symbols, which are used to estimate the coarse freq offset and the initial equalizer taps (these symbols are removed from the stream). The following  are passed through unmodified (the actual equalisation must be done elsewhere). Output: The data symbols, without the synchronisation symbols. The first data symbol passed through has two tags: 'ofdm_sync_carr_offset' (integer), the coarse frequency offset as number of carriers, and 'ofdm_sync_eq_taps' (complex vector). Any tags attached to the synchronisation symbols are attached to the first data symbol. All other tags are propagated as expected.


    Note: The vector on ofdm_sync_eq_taps is already frequency-corrected, whereas the rest is not.


    This block assumes the frequency offset is even (i.e. an integer multiple of 2).


    [1] Schmidl, T.M. and Cox, D.C., "Robust frequency and timing synchronization for
    OFDM", Communications, IEEE Transactions on, 1997. [2] K.D. Kammeyer, "Nachrichtenuebertragung," Chapter. 16.3.2.

    Constructor Specific Documentation:



    Args:
        sync_symbol1 : First synchronisation symbol in the frequency domain. Its length must be the FFT length. For Schmidl & Cox synchronisation, every second sub-carrier has to be zero.
        sync_symbol2 : Second synchronisation symbol in the frequency domain. Must be equal to the FFT length, or zero length if only one synchronisation symbol is used. Using this symbol is how synchronisation is described in [1]. Leaving this empty forces us to interpolate the equalizer taps. If you are using an unusual sub-carrier configuration (e.g. because of OFDMA), this sync symbol is used to identify the active sub-carriers. If you only have one synchronisation symbol, set the active sub-carriers to a non-zero value in here, and also set  parameter to true.
        n_data_symbols : The number of data symbols following each set of synchronisation symbols. Must be at least 1.
        eq_noise_red_len : If non-zero, noise reduction for the equalizer taps is done according to [2]. In this case, it is the channel influence time in number of samples. A good value is usually the length of the cyclic prefix.
        max_carr_offset : Limit the number of sub-carriers the frequency offset can maximally be. Leave this zero to try all possibilities.
        force_one_sync_symbol : See .
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    @staticmethod
    def make(sync_symbol1: "pmt_vector_cfloat", sync_symbol2: "pmt_vector_cfloat", n_data_symbols: "int", eq_noise_red_len: "int"=0, max_carr_offset: "int"=-1, force_one_sync_symbol: "bool"=False) -> "gr::digital::ofdm_chanest_vcvc::sptr":
        r"""
        make(pmt_vector_cfloat sync_symbol1, pmt_vector_cfloat sync_symbol2, int n_data_symbols, int eq_noise_red_len=0, int max_carr_offset=-1, bool force_one_sync_symbol=False) -> ofdm_chanest_vcvc_sptr
        Estimate channel and coarse frequency offset for OFDM from preambles.

        Input: OFDM symbols (in frequency domain). The first one (or two) symbols are expected to be synchronisation symbols, which are used to estimate the coarse freq offset and the initial equalizer taps (these symbols are removed from the stream). The following  are passed through unmodified (the actual equalisation must be done elsewhere). Output: The data symbols, without the synchronisation symbols. The first data symbol passed through has two tags: 'ofdm_sync_carr_offset' (integer), the coarse frequency offset as number of carriers, and 'ofdm_sync_eq_taps' (complex vector). Any tags attached to the synchronisation symbols are attached to the first data symbol. All other tags are propagated as expected.


        Note: The vector on ofdm_sync_eq_taps is already frequency-corrected, whereas the rest is not.


        This block assumes the frequency offset is even (i.e. an integer multiple of 2).


        [1] Schmidl, T.M. and Cox, D.C., "Robust frequency and timing synchronization for
        OFDM", Communications, IEEE Transactions on, 1997. [2] K.D. Kammeyer, "Nachrichtenuebertragung," Chapter. 16.3.2.

        Constructor Specific Documentation:



        Args:
            sync_symbol1 : First synchronisation symbol in the frequency domain. Its length must be the FFT length. For Schmidl & Cox synchronisation, every second sub-carrier has to be zero.
            sync_symbol2 : Second synchronisation symbol in the frequency domain. Must be equal to the FFT length, or zero length if only one synchronisation symbol is used. Using this symbol is how synchronisation is described in [1]. Leaving this empty forces us to interpolate the equalizer taps. If you are using an unusual sub-carrier configuration (e.g. because of OFDMA), this sync symbol is used to identify the active sub-carriers. If you only have one synchronisation symbol, set the active sub-carriers to a non-zero value in here, and also set  parameter to true.
            n_data_symbols : The number of data symbols following each set of synchronisation symbols. Must be at least 1.
            eq_noise_red_len : If non-zero, noise reduction for the equalizer taps is done according to [2]. In this case, it is the channel influence time in number of samples. A good value is usually the length of the cyclic prefix.
            max_carr_offset : Limit the number of sub-carriers the frequency offset can maximally be. Leave this zero to try all possibilities.
            force_one_sync_symbol : See .
        """
        return _digital_swig0.ofdm_chanest_vcvc_make(sync_symbol1, sync_symbol2, n_data_symbols, eq_noise_red_len, max_carr_offset, force_one_sync_symbol)
    __swig_destroy__ = _digital_swig0.delete_ofdm_chanest_vcvc

# Register ofdm_chanest_vcvc in _digital_swig0:
_digital_swig0.ofdm_chanest_vcvc_swigregister(ofdm_chanest_vcvc)
class ofdm_cyclic_prefixer(object):
    r"""
    Adds a cyclic prefix and performs pulse shaping on OFDM symbols.

    Input: OFDM symbols (in the time domain, i.e. after the IFFT). Optionally, entire frames can be processed. In this case,  must be specified which holds the key of the tag that denotes how many OFDM symbols are in a frame. Output: A stream of (scalar) complex symbols, which include the cyclic prefix and the pulse shaping. Note: If complete frames are processed, and  is greater than zero, the final OFDM symbol is followed by the delay line of the pulse shaping.


    The pulse shape is a raised cosine in the time domain.

    Constructor Specific Documentation:



    Args:
        input_size : FFT length (i.e. length of the OFDM symbols)
        output_size : FFT length + cyclic prefix length (in samples)
        rolloff_len : Length of the rolloff flank in samples
        len_tag_key : For framed processing the key of the length tag
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    @staticmethod
    def make(*args, **kwargs) -> "gr::digital::ofdm_cyclic_prefixer::sptr":
        r"""
        make(size_t input_size, size_t output_size, int rolloff_len=0, std::string const & len_tag_key="") -> ofdm_cyclic_prefixer_sptr
        Adds a cyclic prefix and performs pulse shaping on OFDM symbols.

        Input: OFDM symbols (in the time domain, i.e. after the IFFT). Optionally, entire frames can be processed. In this case,  must be specified which holds the key of the tag that denotes how many OFDM symbols are in a frame. Output: A stream of (scalar) complex symbols, which include the cyclic prefix and the pulse shaping. Note: If complete frames are processed, and  is greater than zero, the final OFDM symbol is followed by the delay line of the pulse shaping.


        The pulse shape is a raised cosine in the time domain.

        Constructor Specific Documentation:



        Args:
            input_size : FFT length (i.e. length of the OFDM symbols)
            output_size : FFT length + cyclic prefix length (in samples)
            rolloff_len : Length of the rolloff flank in samples
            len_tag_key : For framed processing the key of the length tag
        """
        return _digital_swig0.ofdm_cyclic_prefixer_make(*args, **kwargs)
    __swig_destroy__ = _digital_swig0.delete_ofdm_cyclic_prefixer

# Register ofdm_cyclic_prefixer in _digital_swig0:
_digital_swig0.ofdm_cyclic_prefixer_swigregister(ofdm_cyclic_prefixer)
class ofdm_equalizer_base(object):
    r"""Base class for implementation details of frequency-domain OFDM equalizers."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _digital_swig0.delete_ofdm_equalizer_base

    def reset(self) -> "void":
        r"""
        reset(ofdm_equalizer_base self)
        Reset the channel information state knowledge.
        """
        return _digital_swig0.ofdm_equalizer_base_reset(self)

    def equalize(self, *args, **kwargs) -> "void":
        r"""
        equalize(ofdm_equalizer_base self, gr_complex * frame, int n_sym, pmt_vector_cfloat initial_taps=std::vector< gr_complex >(), tags_vector_t tags=std::vector< gr::tag_t >())
        Run the actual equalization.
        """
        return _digital_swig0.ofdm_equalizer_base_equalize(self, *args, **kwargs)

    def get_channel_state(self, taps: "pmt_vector_cfloat") -> "void":
        r"""
        get_channel_state(ofdm_equalizer_base self, pmt_vector_cfloat taps)
        Return the current channel state.
        """
        return _digital_swig0.ofdm_equalizer_base_get_channel_state(self, taps)

    def fft_len(self) -> "int":
        r"""fft_len(ofdm_equalizer_base self) -> int"""
        return _digital_swig0.ofdm_equalizer_base_fft_len(self)

    def base(self) -> "gr::digital::ofdm_equalizer_base::sptr":
        r"""base(ofdm_equalizer_base self) -> ofdm_equalizer_base_sptr"""
        return _digital_swig0.ofdm_equalizer_base_base(self)

# Register ofdm_equalizer_base in _digital_swig0:
_digital_swig0.ofdm_equalizer_base_swigregister(ofdm_equalizer_base)
class ofdm_equalizer_1d_pilots(ofdm_equalizer_base):
    r"""Proxy of C++ gr::digital::ofdm_equalizer_1d_pilots class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _digital_swig0.delete_ofdm_equalizer_1d_pilots

# Register ofdm_equalizer_1d_pilots in _digital_swig0:
_digital_swig0.ofdm_equalizer_1d_pilots_swigregister(ofdm_equalizer_1d_pilots)
class ofdm_equalizer_simpledfe(ofdm_equalizer_1d_pilots):
    r"""
    Simple decision feedback equalizer for OFDM.

    Equalizes an OFDM signal symbol by symbol using knowledge of the complex modulations symbols. For every symbol, the following steps are performed:



    This equalizer makes a lot of assumptions:



    Note that the equalized symbols are  on the constellation. This means soft information of the modulation symbols is lost after the equalization, which is suboptimal for channel codes that use soft decision.

    Constructor Specific Documentation:



    Args:
        fft_len : 
        constellation : 
        occupied_carriers : 
        pilot_carriers : 
        pilot_symbols : 
        symbols_skipped : 
        alpha : 
        input_is_shifted : 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args, **kwargs):
        r"""__init__(ofdm_equalizer_simpledfe self, int fft_len, constellation_sptr constellation, std::vector< std::vector< int,std::allocator< int > >,std::allocator< std::vector< int,std::allocator< int > > > > const & occupied_carriers=std::vector< std::vector< int > >(), std::vector< std::vector< int,std::allocator< int > >,std::allocator< std::vector< int,std::allocator< int > > > > const & pilot_carriers=std::vector< std::vector< int > >(), gr_vector_vector_complexf pilot_symbols=std::vector< std::vector< gr_complex > >(), int symbols_skipped=0, float alpha=0.1, bool input_is_shifted=True) -> ofdm_equalizer_simpledfe"""
        _digital_swig0.ofdm_equalizer_simpledfe_swiginit(self, _digital_swig0.new_ofdm_equalizer_simpledfe(*args, **kwargs))
    __swig_destroy__ = _digital_swig0.delete_ofdm_equalizer_simpledfe

    @staticmethod
    def make(*args, **kwargs) -> "gr::digital::ofdm_equalizer_simpledfe::sptr":
        r"""
        make(int fft_len, constellation_sptr constellation, std::vector< std::vector< int,std::allocator< int > >,std::allocator< std::vector< int,std::allocator< int > > > > const & occupied_carriers=std::vector< std::vector< int > >(), std::vector< std::vector< int,std::allocator< int > >,std::allocator< std::vector< int,std::allocator< int > > > > const & pilot_carriers=std::vector< std::vector< int > >(), gr_vector_vector_complexf pilot_symbols=std::vector< std::vector< gr_complex > >(), int symbols_skipped=0, float alpha=0.1, bool input_is_shifted=True) -> ofdm_equalizer_simpledfe_sptr
        Simple decision feedback equalizer for OFDM.

        Equalizes an OFDM signal symbol by symbol using knowledge of the complex modulations symbols. For every symbol, the following steps are performed:



        This equalizer makes a lot of assumptions:



        Note that the equalized symbols are  on the constellation. This means soft information of the modulation symbols is lost after the equalization, which is suboptimal for channel codes that use soft decision.

        Constructor Specific Documentation:



        Args:
            fft_len : 
            constellation : 
            occupied_carriers : 
            pilot_carriers : 
            pilot_symbols : 
            symbols_skipped : 
            alpha : 
            input_is_shifted : 
        """
        return _digital_swig0.ofdm_equalizer_simpledfe_make(*args, **kwargs)

# Register ofdm_equalizer_simpledfe in _digital_swig0:
_digital_swig0.ofdm_equalizer_simpledfe_swigregister(ofdm_equalizer_simpledfe)
class ofdm_equalizer_static(ofdm_equalizer_1d_pilots):
    r"""
    Very simple static equalizer for OFDM.

    This is an extremely simple equalizer. It will only work for high-SNR, very, very slowly changing channels.


    It simply divides the signal with the currently known channel state. Whenever a pilot symbol comes around, it updates the channel state on that particular carrier by dividing the received symbol with the known pilot symbol.

    Constructor Specific Documentation:



    Args:
        fft_len : 
        occupied_carriers : 
        pilot_carriers : 
        pilot_symbols : 
        symbols_skipped : 
        input_is_shifted : 
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args, **kwargs):
        r"""__init__(ofdm_equalizer_static self, int fft_len, std::vector< std::vector< int,std::allocator< int > >,std::allocator< std::vector< int,std::allocator< int > > > > const & occupied_carriers=std::vector< std::vector< int > >(), std::vector< std::vector< int,std::allocator< int > >,std::allocator< std::vector< int,std::allocator< int > > > > const & pilot_carriers=std::vector< std::vector< int > >(), gr_vector_vector_complexf pilot_symbols=std::vector< std::vector< gr_complex > >(), int symbols_skipped=0, bool input_is_shifted=True) -> ofdm_equalizer_static"""
        _digital_swig0.ofdm_equalizer_static_swiginit(self, _digital_swig0.new_ofdm_equalizer_static(*args, **kwargs))
    __swig_destroy__ = _digital_swig0.delete_ofdm_equalizer_static

    @staticmethod
    def make(*args, **kwargs) -> "gr::digital::ofdm_equalizer_static::sptr":
        r"""
        make(int fft_len, std::vector< std::vector< int,std::allocator< int > >,std::allocator< std::vector< int,std::allocator< int > > > > const & occupied_carriers=std::vector< std::vector< int > >(), std::vector< std::vector< int,std::allocator< int > >,std::allocator< std::vector< int,std::allocator< int > > > > const & pilot_carriers=std::vector< std::vector< int > >(), gr_vector_vector_complexf pilot_symbols=std::vector< std::vector< gr_complex > >(), int symbols_skipped=0, bool input_is_shifted=True) -> ofdm_equalizer_static_sptr
        Very simple static equalizer for OFDM.

        This is an extremely simple equalizer. It will only work for high-SNR, very, very slowly changing channels.


        It simply divides the signal with the currently known channel state. Whenever a pilot symbol comes around, it updates the channel state on that particular carrier by dividing the received symbol with the known pilot symbol.

        Constructor Specific Documentation:



        Args:
            fft_len : 
            occupied_carriers : 
            pilot_carriers : 
            pilot_symbols : 
            symbols_skipped : 
            input_is_shifted : 
        """
        return _digital_swig0.ofdm_equalizer_static_make(*args, **kwargs)

# Register ofdm_equalizer_static in _digital_swig0:
_digital_swig0.ofdm_equalizer_static_swigregister(ofdm_equalizer_static)
class ofdm_frame_equalizer_vcvc(object):
    r"""
    OFDM frame equalizer.

    Performs equalization in one or two dimensions on a tagged OFDM frame.


    This does two things: First, it removes the coarse carrier offset. If a tag is found on the first item with the key 'ofdm_sync_carr_offset', this is interpreted as the coarse frequency offset in number of carriers. Next, it performs equalization in one or two dimensions on a tagged OFDM frame. The actual equalization is done by a ofdm_frame_equalizer object, outside of the block.


    Note that the tag with the coarse carrier offset is not removed. Blocks downstream from this block must not attempt to also correct this offset.


    Input: a tagged series of OFDM symbols. Output: The same as the input, but equalized and frequency-corrected.

    Constructor Specific Documentation:



    Args:
        equalizer : The equalizer object that will do the actual work
        cp_len : Length of the cyclic prefix in samples (required to correct the frequency offset)
        tsb_key : TSB key
        propagate_channel_state : If true, the channel state after the last symbol will be added to the first symbol as a tag
        fixed_frame_len : Set if the frame length is fixed. When this value is given, the TSB tag key can be left empty, but it is useful even when using tagged streams at the input.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    @staticmethod
    def make(*args, **kwargs) -> "gr::digital::ofdm_frame_equalizer_vcvc::sptr":
        r"""
        make(ofdm_equalizer_base_sptr equalizer, int cp_len, std::string const & tsb_key="frame_len", bool propagate_channel_state=False, int fixed_frame_len=0) -> ofdm_frame_equalizer_vcvc_sptr
        OFDM frame equalizer.

        Performs equalization in one or two dimensions on a tagged OFDM frame.


        This does two things: First, it removes the coarse carrier offset. If a tag is found on the first item with the key 'ofdm_sync_carr_offset', this is interpreted as the coarse frequency offset in number of carriers. Next, it performs equalization in one or two dimensions on a tagged OFDM frame. The actual equalization is done by a ofdm_frame_equalizer object, outside of the block.


        Note that the tag with the coarse carrier offset is not removed. Blocks downstream from this block must not attempt to also correct this offset.


        Input: a tagged series of OFDM symbols. Output: The same as the input, but equalized and frequency-corrected.

        Constructor Specific Documentation:



        Args:
            equalizer : The equalizer object that will do the actual work
            cp_len : Length of the cyclic prefix in samples (required to correct the frequency offset)
            tsb_key : TSB key
            propagate_channel_state : If true, the channel state after the last symbol will be added to the first symbol as a tag
            fixed_frame_len : Set if the frame length is fixed. When this value is given, the TSB tag key can be left empty, but it is useful even when using tagged streams at the input.
        """
        return _digital_swig0.ofdm_frame_equalizer_vcvc_make(*args, **kwargs)
    __swig_destroy__ = _digital_swig0.delete_ofdm_frame_equalizer_vcvc

# Register ofdm_frame_equalizer_vcvc in _digital_swig0:
_digital_swig0.ofdm_frame_equalizer_vcvc_swigregister(ofdm_frame_equalizer_vcvc)
class ofdm_serializer_vcc(object):
    r"""
    Serializes complex modulations symbols from OFDM sub-carriers.

    This is the inverse block to the carrier_allocator_cvc. It outputs the complex data symbols as a tagged stream, discarding the pilot symbols.


    If given, two different tags are parsed: The first key () specifies the number of OFDM symbols in the frame at the input. The second key () specifies the number of complex symbols that are coded into this frame. If given, this second key is then used at the output, otherwise,  is used. If both are given, the packet length specifies the maximum number of output items, and the frame length specifies the exact number of consumed input items.


    It is possible to correct a carrier offset in this function by passing another tag with said offset.


    Input: Complex vectors of length  Output: Complex scalars, in the same order as specified in occupied_carriers.

    Constructor Specific Documentation:



    Args:
        fft_len : FFT length
        occupied_carriers : See ofdm_carrier_allocator_cvc.
        len_tag_key : The key of the tag identifying the length of the input frame in OFDM symbols.
        packet_len_tag_key : The key of the tag identifying the number of complex symbols in this packet.
        symbols_skipped : If the first symbol is not allocated as in [0], set this
        carr_offset_key : When this block should correct a carrier offset, specify the tag key of the offset here (not necessary if following an ofdm_frame_equalizer_vcvc)
        input_is_shifted : If the input has the DC carrier on index 0 (i.e. it is not FFT shifted), set this to false
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    @staticmethod
    def make(*args) -> "gr::digital::ofdm_serializer_vcc::sptr":
        r"""
        make(int fft_len, std::vector< std::vector< int,std::allocator< int > >,std::allocator< std::vector< int,std::allocator< int > > > > const & occupied_carriers, std::string const & len_tag_key="frame_len", std::string const & packet_len_tag_key="", int symbols_skipped=0, std::string const & carr_offset_key="", bool input_is_shifted=True) -> ofdm_serializer_vcc_sptr
        make(ofdm_carrier_allocator_cvc_sptr allocator, std::string const & packet_len_tag_key="", int symbols_skipped=0, std::string const & carr_offset_key="", bool input_is_shifted=True) -> ofdm_serializer_vcc_sptr
        Serializes complex modulations symbols from OFDM sub-carriers.

        This is the inverse block to the carrier_allocator_cvc. It outputs the complex data symbols as a tagged stream, discarding the pilot symbols.


        If given, two different tags are parsed: The first key () specifies the number of OFDM symbols in the frame at the input. The second key () specifies the number of complex symbols that are coded into this frame. If given, this second key is then used at the output, otherwise,  is used. If both are given, the packet length specifies the maximum number of output items, and the frame length specifies the exact number of consumed input items.


        It is possible to correct a carrier offset in this function by passing another tag with said offset.


        Input: Complex vectors of length  Output: Complex scalars, in the same order as specified in occupied_carriers.

        Constructor Specific Documentation:



        Args:
            fft_len : FFT length
            occupied_carriers : See ofdm_carrier_allocator_cvc.
            len_tag_key : The key of the tag identifying the length of the input frame in OFDM symbols.
            packet_len_tag_key : The key of the tag identifying the number of complex symbols in this packet.
            symbols_skipped : If the first symbol is not allocated as in [0], set this
            carr_offset_key : When this block should correct a carrier offset, specify the tag key of the offset here (not necessary if following an ofdm_frame_equalizer_vcvc)
            input_is_shifted : If the input has the DC carrier on index 0 (i.e. it is not FFT shifted), set this to false
        """
        return _digital_swig0.ofdm_serializer_vcc_make(*args)
    __swig_destroy__ = _digital_swig0.delete_ofdm_serializer_vcc

# Register ofdm_serializer_vcc in _digital_swig0:
_digital_swig0.ofdm_serializer_vcc_swigregister(ofdm_serializer_vcc)
class ofdm_sync_sc_cfb(object):
    r"""
    Schmidl & Cox synchronisation for OFDM.

    Input: complex samples. Output 0: Fine frequency offset, scaled by the OFDM symbol duration. This is  in [1]. The normalized frequency offset is then 2.0*output0/fft_len. Output 1: Beginning of the first OFDM symbol after the first (doubled) OFDM symbol. The beginning is marked with a 1 (it's 0 everywhere else).


    The evaluation of the coarse frequency offset is  done in this block. Also, the initial equalizer taps are not calculated here.


    Note that we use a different normalization factor in the timing metric than the authors do in their original work[1]. If the timing metric (8) is    we calculate the normalization as    i.e., we estimate the energy from  half-symbols. This avoids spurious detects at the end of a burst, when the energy level suddenly drops.


    [1] Schmidl, T.M. and Cox, D.C., "Robust frequency and timing synchronization for
    OFDM", Communications, IEEE Transactions on, 1997.

    Constructor Specific Documentation:



    Args:
        fft_len : FFT length
        cp_len : Length of the guard interval (cyclic prefix) in samples
        use_even_carriers : If true, the carriers in the sync preamble are occupied such that the even carriers are used (0, 2, 4, ...). If you use all carriers, that would include the DC carrier, so be careful.
        threshold : detection threshold. Default is 0.9.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr

    @staticmethod
    def make(fft_len: "int", cp_len: "int", use_even_carriers: "bool"=False, threshold: "float"=0.9) -> "gr::digital::ofdm_sync_sc_cfb::sptr":
        r"""
        make(int fft_len, int cp_len, bool use_even_carriers=False, float threshold=0.9) -> ofdm_sync_sc_cfb_sptr
        Schmidl & Cox synchronisation for OFDM.

        Input: complex samples. Output 0: Fine frequency offset, scaled by the OFDM symbol duration. This is  in [1]. The normalized frequency offset is then 2.0*output0/fft_len. Output 1: Beginning of the first OFDM symbol after the first (doubled) OFDM symbol. The beginning is marked with a 1 (it's 0 everywhere else).


        The evaluation of the coarse frequency offset is  done in this block. Also, the initial equalizer taps are not calculated here.


        Note that we use a different normalization factor in the timing metric than the authors do in their original work[1]. If the timing metric (8) is    we calculate the normalization as    i.e., we estimate the energy from  half-symbols. This avoids spurious detects at the end of a burst, when the energy level suddenly drops.


        [1] Schmidl, T.M. and Cox, D.C., "Robust frequency and timing synchronization for
        OFDM", Communications, IEEE Transactions on, 1997.

        Constructor Specific Documentation:



        Args:
            fft_len : FFT length
            cp_len : Length of the guard interval (cyclic prefix) in samples
            use_even_carriers : If true, the carriers in the sync preamble are occupied such that the even carriers are used (0, 2, 4, ...). If you use all carriers, that would include the DC carrier, so be careful.
            threshold : detection threshold. Default is 0.9.
        """
        return _digital_swig0.ofdm_sync_sc_cfb_make(fft_len, cp_len, use_even_carriers, threshold)

    def set_threshold(self, threshold: "float") -> "void":
        r"""set_threshold(ofdm_sync_sc_cfb self, float threshold)"""
        return _digital_swig0.ofdm_sync_sc_cfb_set_threshold(self, threshold)

    def threshold(self) -> "float":
        r"""threshold(ofdm_sync_sc_cfb self) -> float"""
        return _digital_swig0.ofdm_sync_sc_cfb_threshold(self)
    __swig_destroy__ = _digital_swig0.delete_ofdm_sync_sc_cfb

# Register ofdm_sync_sc_cfb in _digital_swig0:
_digital_swig0.ofdm_sync_sc_cfb_swigregister(ofdm_sync_sc_cfb)
class binary_slicer_fb_sptr(object):
    r"""Proxy of C++ boost::shared_ptr< gr::digital::binary_slicer_fb > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(binary_slicer_fb_sptr self) -> binary_slicer_fb_sptr
        __init__(binary_slicer_fb_sptr self, binary_slicer_fb p) -> binary_slicer_fb_sptr
        """
        _digital_swig0.binary_slicer_fb_sptr_swiginit(self, _digital_swig0.new_binary_slicer_fb_sptr(*args))

    def __deref__(self) -> "gr::digital::binary_slicer_fb *":
        r"""__deref__(binary_slicer_fb_sptr self) -> binary_slicer_fb"""
        return _digital_swig0.binary_slicer_fb_sptr___deref__(self)
    __swig_destroy__ = _digital_swig0.delete_binary_slicer_fb_sptr

    def make(self) -> "gr::digital::binary_slicer_fb::sptr":
        r"""
        make(binary_slicer_fb_sptr self) -> binary_slicer_fb_sptr
        Slice float binary symbol producing 1 bit output.

        Constructor Specific Documentation:

        Make binary symbol slicer block.
        """
        return _digital_swig0.binary_slicer_fb_sptr_make(self)

    def history(self) -> "unsigned int":
        r"""history(binary_slicer_fb_sptr self) -> unsigned int"""
        return _digital_swig0.binary_slicer_fb_sptr_history(self)

    def declare_sample_delay(self, *args) -> "void":
        r"""
        declare_sample_delay(binary_slicer_fb_sptr self, int which, int delay)
        declare_sample_delay(binary_slicer_fb_sptr self, unsigned int delay)
        """
        return _digital_swig0.binary_slicer_fb_sptr_declare_sample_delay(self, *args)

    def sample_delay(self, which: "int") -> "unsigned int":
        r"""sample_delay(binary_slicer_fb_sptr self, int which) -> unsigned int"""
        return _digital_swig0.binary_slicer_fb_sptr_sample_delay(self, which)

    def set_output_multiple(self, multiple: "int") -> "void":
        r"""set_output_multiple(binary_slicer_fb_sptr self, int multiple)"""
        return _digital_swig0.binary_slicer_fb_sptr_set_output_multiple(self, multiple)

    def output_multiple(self) -> "int":
        r"""output_multiple(binary_slicer_fb_sptr self) -> int"""
        return _digital_swig0.binary_slicer_fb_sptr_output_multiple(self)

    def relative_rate(self) -> "double":
        r"""relative_rate(binary_slicer_fb_sptr self) -> double"""
        return _digital_swig0.binary_slicer_fb_sptr_relative_rate(self)

    def relative_rate_i(self) -> "uint64_t":
        r"""relative_rate_i(binary_slicer_fb_sptr self) -> uint64_t"""
        return _digital_swig0.binary_slicer_fb_sptr_relative_rate_i(self)

    def relative_rate_d(self) -> "uint64_t":
        r"""relative_rate_d(binary_slicer_fb_sptr self) -> uint64_t"""
        return _digital_swig0.binary_slicer_fb_sptr_relative_rate_d(self)

    def start(self) -> "bool":
        r"""start(binary_slicer_fb_sptr self) -> bool"""
        return _digital_swig0.binary_slicer_fb_sptr_start(self)

    def stop(self) -> "bool":
        r"""stop(binary_slicer_fb_sptr self) -> bool"""
        return _digital_swig0.binary_slicer_fb_sptr_stop(self)

    def nitems_read(self, which_input: "unsigned int") -> "uint64_t":
        r"""nitems_read(binary_slicer_fb_sptr self, unsigned int which_input) -> uint64_t"""
        return _digital_swig0.binary_slicer_fb_sptr_nitems_read(self, which_input)

    def nitems_written(self, which_output: "unsigned int") -> "uint64_t":
        r"""nitems_written(binary_slicer_fb_sptr self, unsigned int which_output) -> uint64_t"""
        return _digital_swig0.binary_slicer_fb_sptr_nitems_written(self, which_output)

    def set_log_level(self, level: "std::string") -> "void":
        r"""set_log_level(binary_slicer_fb_sptr self, std::string level)"""
        return _digital_swig0.binary_slicer_fb_sptr_set_log_level(self, level)

    def log_level(self) -> "std::string":
        r"""log_level(binary_slicer_fb_sptr self) -> std::string"""
        return _digital_swig0.binary_slicer_fb_sptr_log_level(self)

    def max_noutput_items(self) -> "int":
        r"""max_noutput_items(binary_slicer_fb_sptr self) -> int"""
        return _digital_swig0.binary_slicer_fb_sptr_max_noutput_items(self)

    def set_max_noutput_items(self, m: "int") -> "void":
        r"""set_max_noutput_items(binary_slicer_fb_sptr self, int m)"""
        return _digital_swig0.binary_slicer_fb_sptr_set_max_noutput_items(self, m)

    def unset_max_noutput_items(self) -> "void":
        r"""unset_max_noutput_items(binary_slicer_fb_sptr self)"""
        return _digital_swig0.binary_slicer_fb_sptr_unset_max_noutput_items(self)

    def is_set_max_noutput_items(self) -> "bool":
        r"""is_set_max_noutput_items(binary_slicer_fb_sptr self) -> bool"""
        return _digital_swig0.binary_slicer_fb_sptr_is_set_max_noutput_items(self)

    def set_min_noutput_items(self, m: "int") -> "void":
        r"""set_min_noutput_items(binary_slicer_fb_sptr self, int m)"""
        return _digital_swig0.binary_slicer_fb_sptr_set_min_noutput_items(self, m)

    def min_noutput_items(self) -> "int":
        r"""min_noutput_items(binary_slicer_fb_sptr self) -> int"""
        return _digital_swig0.binary_slicer_fb_sptr_min_noutput_items(self)

    def max_output_buffer(self, i: "int") -> "long":
        r"""max_output_buffer(binary_slicer_fb_sptr self, int i) -> long"""
        return _digital_swig0.binary_slicer_fb_sptr_max_output_buffer(self, i)

    def set_max_output_buffer(self, *args) -> "void":
        r"""
        set_max_output_buffer(binary_slicer_fb_sptr self, long max_output_buffer)
        set_max_output_buffer(binary_slicer_fb_sptr self, int port, long max_output_buffer)
        """
        return _digital_swig0.binary_slicer_fb_sptr_set_max_output_buffer(self, *args)

    def min_output_buffer(self, i: "int") -> "long":
        r"""min_output_buffer(binary_slicer_fb_sptr self, int i) -> long"""
        return _digital_swig0.binary_slicer_fb_sptr_min_output_buffer(self, i)

    def set_min_output_buffer(self, *args) -> "void":
        r"""
        set_min_output_buffer(binary_slicer_fb_sptr self, long min_output_buffer)
        set_min_output_buffer(binary_slicer_fb_sptr self, int port, long min_output_buffer)
        """
        return _digital_swig0.binary_slicer_fb_sptr_set_min_output_buffer(self, *args)

    def pc_noutput_items(self) -> "float":
        r"""pc_noutput_items(binary_slicer_fb_sptr self) -> float"""
        return _digital_swig0.binary_slicer_fb_sptr_pc_noutput_items(self)

    def pc_noutput_items_avg(self) -> "float":
        r"""pc_noutput_items_avg(binary_slicer_fb_sptr self) -> float"""
        return _digital_swig0.binary_slicer_fb_sptr_pc_noutput_items_avg(self)

    def pc_noutput_items_var(self) -> "float":
        r"""pc_noutput_items_var(binary_slicer_fb_sptr self) -> float"""
        return _digital_swig0.binary_slicer_fb_sptr_pc_noutput_items_var(self)

    def pc_nproduced(self) -> "float":
        r"""pc_nproduced(binary_slicer_fb_sptr self) -> float"""
        return _digital_swig0.binary_slicer_fb_sptr_pc_nproduced(self)

    def pc_nproduced_avg(self) -> "float":
        r"""pc_nproduced_avg(binary_slicer_fb_sptr self) -> float"""
        return _digital_swig0.binary_slicer_fb_sptr_pc_nproduced_avg(self)

    def pc_nproduced_var(self) -> "float":
        r"""pc_nproduced_var(binary_slicer_fb_sptr self) -> float"""
        return _digital_swig0.binary_slicer_fb_sptr_pc_nproduced_var(self)

    def pc_input_buffers_full(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full(binary_slicer_fb_sptr self, int which) -> float
        pc_input_buffers_full(binary_slicer_fb_sptr self) -> pmt_vector_float
        """
        return _digital_swig0.binary_slicer_fb_sptr_pc_input_buffers_full(self, *args)

    def pc_input_buffers_full_avg(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full_avg(binary_slicer_fb_sptr self, int which) -> float
        pc_input_buffers_full_avg(binary_slicer_fb_sptr self) -> pmt_vector_float
        """
        return _digital_swig0.binary_slicer_fb_sptr_pc_input_buffers_full_avg(self, *args)

    def pc_input_buffers_full_var(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full_var(binary_slicer_fb_sptr self, int which) -> float
        pc_input_buffers_full_var(binary_slicer_fb_sptr self) -> pmt_vector_float
        """
        return _digital_swig0.binary_slicer_fb_sptr_pc_input_buffers_full_var(self, *args)

    def pc_output_buffers_full(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full(binary_slicer_fb_sptr self, int which) -> float
        pc_output_buffers_full(binary_slicer_fb_sptr self) -> pmt_vector_float
        """
        return _digital_swig0.binary_slicer_fb_sptr_pc_output_buffers_full(self, *args)

    def pc_output_buffers_full_avg(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full_avg(binary_slicer_fb_sptr self, int which) -> float
        pc_output_buffers_full_avg(binary_slicer_fb_sptr self) -> pmt_vector_float
        """
        return _digital_swig0.binary_slicer_fb_sptr_pc_output_buffers_full_avg(self, *args)

    def pc_output_buffers_full_var(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full_var(binary_slicer_fb_sptr self, int which) -> float
        pc_output_buffers_full_var(binary_slicer_fb_sptr self) -> pmt_vector_float
        """
        return _digital_swig0.binary_slicer_fb_sptr_pc_output_buffers_full_var(self, *args)

    def pc_work_time(self) -> "float":
        r"""pc_work_time(binary_slicer_fb_sptr self) -> float"""
        return _digital_swig0.binary_slicer_fb_sptr_pc_work_time(self)

    def pc_work_time_avg(self) -> "float":
        r"""pc_work_time_avg(binary_slicer_fb_sptr self) -> float"""
        return _digital_swig0.binary_slicer_fb_sptr_pc_work_time_avg(self)

    def pc_work_time_var(self) -> "float":
        r"""pc_work_time_var(binary_slicer_fb_sptr self) -> float"""
        return _digital_swig0.binary_slicer_fb_sptr_pc_work_time_var(self)

    def pc_work_time_total(self) -> "float":
        r"""pc_work_time_total(binary_slicer_fb_sptr self) -> float"""
        return _digital_swig0.binary_slicer_fb_sptr_pc_work_time_total(self)

    def pc_throughput_avg(self) -> "float":
        r"""pc_throughput_avg(binary_slicer_fb_sptr self) -> float"""
        return _digital_swig0.binary_slicer_fb_sptr_pc_throughput_avg(self)

    def set_processor_affinity(self, mask: "std::vector< int,std::allocator< int > > const &") -> "void":
        r"""set_processor_affinity(binary_slicer_fb_sptr self, std::vector< int,std::allocator< int > > const & mask)"""
        return _digital_swig0.binary_slicer_fb_sptr_set_processor_affinity(self, mask)

    def unset_processor_affinity(self) -> "void":
        r"""unset_processor_affinity(binary_slicer_fb_sptr self)"""
        return _digital_swig0.binary_slicer_fb_sptr_unset_processor_affinity(self)

    def processor_affinity(self) -> "std::vector< int,std::allocator< int > >":
        r"""processor_affinity(binary_slicer_fb_sptr self) -> std::vector< int,std::allocator< int > >"""
        return _digital_swig0.binary_slicer_fb_sptr_processor_affinity(self)

    def active_thread_priority(self) -> "int":
        r"""active_thread_priority(binary_slicer_fb_sptr self) -> int"""
        return _digital_swig0.binary_slicer_fb_sptr_active_thread_priority(self)

    def thread_priority(self) -> "int":
        r"""thread_priority(binary_slicer_fb_sptr self) -> int"""
        return _digital_swig0.binary_slicer_fb_sptr_thread_priority(self)

    def set_thread_priority(self, priority: "int") -> "int":
        r"""set_thread_priority(binary_slicer_fb_sptr self, int priority) -> int"""
        return _digital_swig0.binary_slicer_fb_sptr_set_thread_priority(self, priority)

    def name(self) -> "std::string":
        r"""name(binary_slicer_fb_sptr self) -> std::string"""
        return _digital_swig0.binary_slicer_fb_sptr_name(self)

    def symbol_name(self) -> "std::string":
        r"""symbol_name(binary_slicer_fb_sptr self) -> std::string"""
        return _digital_swig0.binary_slicer_fb_sptr_symbol_name(self)

    def input_signature(self) -> "gr::io_signature::sptr":
        r"""input_signature(binary_slicer_fb_sptr self) -> io_signature_sptr"""
        return _digital_swig0.binary_slicer_fb_sptr_input_signature(self)

    def output_signature(self) -> "gr::io_signature::sptr":
        r"""output_signature(binary_slicer_fb_sptr self) -> io_signature_sptr"""
        return _digital_swig0.binary_slicer_fb_sptr_output_signature(self)

    def unique_id(self) -> "long":
        r"""unique_id(binary_slicer_fb_sptr self) -> long"""
        return _digital_swig0.binary_slicer_fb_sptr_unique_id(self)

    def to_basic_block(self) -> "gr::basic_block_sptr":
        r"""to_basic_block(binary_slicer_fb_sptr self) -> basic_block_sptr"""
        return _digital_swig0.binary_slicer_fb_sptr_to_basic_block(self)

    def check_topology(self, ninputs: "int", noutputs: "int") -> "bool":
        r"""check_topology(binary_slicer_fb_sptr self, int ninputs, int noutputs) -> bool"""
        return _digital_swig0.binary_slicer_fb_sptr_check_topology(self, ninputs, noutputs)

    def alias(self) -> "std::string":
        r"""alias(binary_slicer_fb_sptr self) -> std::string"""
        return _digital_swig0.binary_slicer_fb_sptr_alias(self)

    def set_block_alias(self, name: "std::string") -> "void":
        r"""set_block_alias(binary_slicer_fb_sptr self, std::string name)"""
        return _digital_swig0.binary_slicer_fb_sptr_set_block_alias(self, name)

    def _post(self, which_port: "swig_pmt_ptr", msg: "swig_pmt_ptr") -> "void":
        r"""_post(binary_slicer_fb_sptr self, swig_pmt_ptr which_port, swig_pmt_ptr msg)"""
        return _digital_swig0.binary_slicer_fb_sptr__post(self, which_port, msg)

    def message_ports_in(self) -> "pmt::pmt_t":
        r"""message_ports_in(binary_slicer_fb_sptr self) -> swig_pmt_ptr"""
        return _digital_swig0.binary_slicer_fb_sptr_message_ports_in(self)

    def message_ports_out(self) -> "pmt::pmt_t":
        r"""message_ports_out(binary_slicer_fb_sptr self) -> swig_pmt_ptr"""
        return _digital_swig0.binary_slicer_fb_sptr_message_ports_out(self)

    def message_subscribers(self, which_port: "swig_pmt_ptr") -> "pmt::pmt_t":
        r"""message_subscribers(binary_slicer_fb_sptr self, swig_pmt_ptr which_port) -> swig_pmt_ptr"""
        return _digital_swig0.binary_slicer_fb_sptr_message_subscribers(self, which_port)

# Register binary_slicer_fb_sptr in _digital_swig0:
_digital_swig0.binary_slicer_fb_sptr_swigregister(binary_slicer_fb_sptr)

binary_slicer_fb_sptr.__repr__ = lambda self: "<gr_block %s (%d)>" % (self.name(), self.unique_id())
binary_slicer_fb = binary_slicer_fb.make;

class cma_equalizer_cc_sptr(object):
    r"""Proxy of C++ boost::shared_ptr< gr::digital::cma_equalizer_cc > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(cma_equalizer_cc_sptr self) -> cma_equalizer_cc_sptr
        __init__(cma_equalizer_cc_sptr self, cma_equalizer_cc p) -> cma_equalizer_cc_sptr
        """
        _digital_swig0.cma_equalizer_cc_sptr_swiginit(self, _digital_swig0.new_cma_equalizer_cc_sptr(*args))

    def __deref__(self) -> "gr::digital::cma_equalizer_cc *":
        r"""__deref__(cma_equalizer_cc_sptr self) -> cma_equalizer_cc"""
        return _digital_swig0.cma_equalizer_cc_sptr___deref__(self)
    __swig_destroy__ = _digital_swig0.delete_cma_equalizer_cc_sptr

    def make(self, num_taps: "int", modulus: "float", mu: "float", sps: "int") -> "gr::digital::cma_equalizer_cc::sptr":
        r"""
        make(cma_equalizer_cc_sptr self, int num_taps, float modulus, float mu, int sps) -> cma_equalizer_cc_sptr
        Implements constant modulus adaptive filter on complex stream.

        The error value and tap update equations (for p=2) can be found in:


        D. Godard, "Self-Recovering Equalization and Carrier Tracking
        in Two-Dimensional Data Communication Systems," IEEE Transactions on Communications, Vol. 28, No. 11, pp. 1867 - 1875, 1980.

        Constructor Specific Documentation:

        Make a CMA Equalizer block

        Args:
            num_taps : Number of taps in the equalizer (channel size)
            modulus : Modulus of the modulated signals
            mu : Gain of the update loop
            sps : Number of samples per symbol of the input signal
        """
        return _digital_swig0.cma_equalizer_cc_sptr_make(self, num_taps, modulus, mu, sps)

    def set_taps(self, taps: "pmt_vector_cfloat") -> "void":
        r"""set_taps(cma_equalizer_cc_sptr self, pmt_vector_cfloat taps)"""
        return _digital_swig0.cma_equalizer_cc_sptr_set_taps(self, taps)

    def taps(self) -> "std::vector< gr_complex,std::allocator< gr_complex > >":
        r"""taps(cma_equalizer_cc_sptr self) -> pmt_vector_cfloat"""
        return _digital_swig0.cma_equalizer_cc_sptr_taps(self)

    def gain(self) -> "float":
        r"""gain(cma_equalizer_cc_sptr self) -> float"""
        return _digital_swig0.cma_equalizer_cc_sptr_gain(self)

    def set_gain(self, mu: "float") -> "void":
        r"""set_gain(cma_equalizer_cc_sptr self, float mu)"""
        return _digital_swig0.cma_equalizer_cc_sptr_set_gain(self, mu)

    def modulus(self) -> "float":
        r"""modulus(cma_equalizer_cc_sptr self) -> float"""
        return _digital_swig0.cma_equalizer_cc_sptr_modulus(self)

    def set_modulus(self, mod: "float") -> "void":
        r"""set_modulus(cma_equalizer_cc_sptr self, float mod)"""
        return _digital_swig0.cma_equalizer_cc_sptr_set_modulus(self, mod)

    def history(self) -> "unsigned int":
        r"""history(cma_equalizer_cc_sptr self) -> unsigned int"""
        return _digital_swig0.cma_equalizer_cc_sptr_history(self)

    def declare_sample_delay(self, *args) -> "void":
        r"""
        declare_sample_delay(cma_equalizer_cc_sptr self, int which, int delay)
        declare_sample_delay(cma_equalizer_cc_sptr self, unsigned int delay)
        """
        return _digital_swig0.cma_equalizer_cc_sptr_declare_sample_delay(self, *args)

    def sample_delay(self, which: "int") -> "unsigned int":
        r"""sample_delay(cma_equalizer_cc_sptr self, int which) -> unsigned int"""
        return _digital_swig0.cma_equalizer_cc_sptr_sample_delay(self, which)

    def set_output_multiple(self, multiple: "int") -> "void":
        r"""set_output_multiple(cma_equalizer_cc_sptr self, int multiple)"""
        return _digital_swig0.cma_equalizer_cc_sptr_set_output_multiple(self, multiple)

    def output_multiple(self) -> "int":
        r"""output_multiple(cma_equalizer_cc_sptr self) -> int"""
        return _digital_swig0.cma_equalizer_cc_sptr_output_multiple(self)

    def relative_rate(self) -> "double":
        r"""relative_rate(cma_equalizer_cc_sptr self) -> double"""
        return _digital_swig0.cma_equalizer_cc_sptr_relative_rate(self)

    def relative_rate_i(self) -> "uint64_t":
        r"""relative_rate_i(cma_equalizer_cc_sptr self) -> uint64_t"""
        return _digital_swig0.cma_equalizer_cc_sptr_relative_rate_i(self)

    def relative_rate_d(self) -> "uint64_t":
        r"""relative_rate_d(cma_equalizer_cc_sptr self) -> uint64_t"""
        return _digital_swig0.cma_equalizer_cc_sptr_relative_rate_d(self)

    def start(self) -> "bool":
        r"""start(cma_equalizer_cc_sptr self) -> bool"""
        return _digital_swig0.cma_equalizer_cc_sptr_start(self)

    def stop(self) -> "bool":
        r"""stop(cma_equalizer_cc_sptr self) -> bool"""
        return _digital_swig0.cma_equalizer_cc_sptr_stop(self)

    def nitems_read(self, which_input: "unsigned int") -> "uint64_t":
        r"""nitems_read(cma_equalizer_cc_sptr self, unsigned int which_input) -> uint64_t"""
        return _digital_swig0.cma_equalizer_cc_sptr_nitems_read(self, which_input)

    def nitems_written(self, which_output: "unsigned int") -> "uint64_t":
        r"""nitems_written(cma_equalizer_cc_sptr self, unsigned int which_output) -> uint64_t"""
        return _digital_swig0.cma_equalizer_cc_sptr_nitems_written(self, which_output)

    def set_log_level(self, level: "std::string") -> "void":
        r"""set_log_level(cma_equalizer_cc_sptr self, std::string level)"""
        return _digital_swig0.cma_equalizer_cc_sptr_set_log_level(self, level)

    def log_level(self) -> "std::string":
        r"""log_level(cma_equalizer_cc_sptr self) -> std::string"""
        return _digital_swig0.cma_equalizer_cc_sptr_log_level(self)

    def max_noutput_items(self) -> "int":
        r"""max_noutput_items(cma_equalizer_cc_sptr self) -> int"""
        return _digital_swig0.cma_equalizer_cc_sptr_max_noutput_items(self)

    def set_max_noutput_items(self, m: "int") -> "void":
        r"""set_max_noutput_items(cma_equalizer_cc_sptr self, int m)"""
        return _digital_swig0.cma_equalizer_cc_sptr_set_max_noutput_items(self, m)

    def unset_max_noutput_items(self) -> "void":
        r"""unset_max_noutput_items(cma_equalizer_cc_sptr self)"""
        return _digital_swig0.cma_equalizer_cc_sptr_unset_max_noutput_items(self)

    def is_set_max_noutput_items(self) -> "bool":
        r"""is_set_max_noutput_items(cma_equalizer_cc_sptr self) -> bool"""
        return _digital_swig0.cma_equalizer_cc_sptr_is_set_max_noutput_items(self)

    def set_min_noutput_items(self, m: "int") -> "void":
        r"""set_min_noutput_items(cma_equalizer_cc_sptr self, int m)"""
        return _digital_swig0.cma_equalizer_cc_sptr_set_min_noutput_items(self, m)

    def min_noutput_items(self) -> "int":
        r"""min_noutput_items(cma_equalizer_cc_sptr self) -> int"""
        return _digital_swig0.cma_equalizer_cc_sptr_min_noutput_items(self)

    def max_output_buffer(self, i: "int") -> "long":
        r"""max_output_buffer(cma_equalizer_cc_sptr self, int i) -> long"""
        return _digital_swig0.cma_equalizer_cc_sptr_max_output_buffer(self, i)

    def set_max_output_buffer(self, *args) -> "void":
        r"""
        set_max_output_buffer(cma_equalizer_cc_sptr self, long max_output_buffer)
        set_max_output_buffer(cma_equalizer_cc_sptr self, int port, long max_output_buffer)
        """
        return _digital_swig0.cma_equalizer_cc_sptr_set_max_output_buffer(self, *args)

    def min_output_buffer(self, i: "int") -> "long":
        r"""min_output_buffer(cma_equalizer_cc_sptr self, int i) -> long"""
        return _digital_swig0.cma_equalizer_cc_sptr_min_output_buffer(self, i)

    def set_min_output_buffer(self, *args) -> "void":
        r"""
        set_min_output_buffer(cma_equalizer_cc_sptr self, long min_output_buffer)
        set_min_output_buffer(cma_equalizer_cc_sptr self, int port, long min_output_buffer)
        """
        return _digital_swig0.cma_equalizer_cc_sptr_set_min_output_buffer(self, *args)

    def pc_noutput_items(self) -> "float":
        r"""pc_noutput_items(cma_equalizer_cc_sptr self) -> float"""
        return _digital_swig0.cma_equalizer_cc_sptr_pc_noutput_items(self)

    def pc_noutput_items_avg(self) -> "float":
        r"""pc_noutput_items_avg(cma_equalizer_cc_sptr self) -> float"""
        return _digital_swig0.cma_equalizer_cc_sptr_pc_noutput_items_avg(self)

    def pc_noutput_items_var(self) -> "float":
        r"""pc_noutput_items_var(cma_equalizer_cc_sptr self) -> float"""
        return _digital_swig0.cma_equalizer_cc_sptr_pc_noutput_items_var(self)

    def pc_nproduced(self) -> "float":
        r"""pc_nproduced(cma_equalizer_cc_sptr self) -> float"""
        return _digital_swig0.cma_equalizer_cc_sptr_pc_nproduced(self)

    def pc_nproduced_avg(self) -> "float":
        r"""pc_nproduced_avg(cma_equalizer_cc_sptr self) -> float"""
        return _digital_swig0.cma_equalizer_cc_sptr_pc_nproduced_avg(self)

    def pc_nproduced_var(self) -> "float":
        r"""pc_nproduced_var(cma_equalizer_cc_sptr self) -> float"""
        return _digital_swig0.cma_equalizer_cc_sptr_pc_nproduced_var(self)

    def pc_input_buffers_full(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full(cma_equalizer_cc_sptr self, int which) -> float
        pc_input_buffers_full(cma_equalizer_cc_sptr self) -> pmt_vector_float
        """
        return _digital_swig0.cma_equalizer_cc_sptr_pc_input_buffers_full(self, *args)

    def pc_input_buffers_full_avg(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full_avg(cma_equalizer_cc_sptr self, int which) -> float
        pc_input_buffers_full_avg(cma_equalizer_cc_sptr self) -> pmt_vector_float
        """
        return _digital_swig0.cma_equalizer_cc_sptr_pc_input_buffers_full_avg(self, *args)

    def pc_input_buffers_full_var(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full_var(cma_equalizer_cc_sptr self, int which) -> float
        pc_input_buffers_full_var(cma_equalizer_cc_sptr self) -> pmt_vector_float
        """
        return _digital_swig0.cma_equalizer_cc_sptr_pc_input_buffers_full_var(self, *args)

    def pc_output_buffers_full(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full(cma_equalizer_cc_sptr self, int which) -> float
        pc_output_buffers_full(cma_equalizer_cc_sptr self) -> pmt_vector_float
        """
        return _digital_swig0.cma_equalizer_cc_sptr_pc_output_buffers_full(self, *args)

    def pc_output_buffers_full_avg(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full_avg(cma_equalizer_cc_sptr self, int which) -> float
        pc_output_buffers_full_avg(cma_equalizer_cc_sptr self) -> pmt_vector_float
        """
        return _digital_swig0.cma_equalizer_cc_sptr_pc_output_buffers_full_avg(self, *args)

    def pc_output_buffers_full_var(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full_var(cma_equalizer_cc_sptr self, int which) -> float
        pc_output_buffers_full_var(cma_equalizer_cc_sptr self) -> pmt_vector_float
        """
        return _digital_swig0.cma_equalizer_cc_sptr_pc_output_buffers_full_var(self, *args)

    def pc_work_time(self) -> "float":
        r"""pc_work_time(cma_equalizer_cc_sptr self) -> float"""
        return _digital_swig0.cma_equalizer_cc_sptr_pc_work_time(self)

    def pc_work_time_avg(self) -> "float":
        r"""pc_work_time_avg(cma_equalizer_cc_sptr self) -> float"""
        return _digital_swig0.cma_equalizer_cc_sptr_pc_work_time_avg(self)

    def pc_work_time_var(self) -> "float":
        r"""pc_work_time_var(cma_equalizer_cc_sptr self) -> float"""
        return _digital_swig0.cma_equalizer_cc_sptr_pc_work_time_var(self)

    def pc_work_time_total(self) -> "float":
        r"""pc_work_time_total(cma_equalizer_cc_sptr self) -> float"""
        return _digital_swig0.cma_equalizer_cc_sptr_pc_work_time_total(self)

    def pc_throughput_avg(self) -> "float":
        r"""pc_throughput_avg(cma_equalizer_cc_sptr self) -> float"""
        return _digital_swig0.cma_equalizer_cc_sptr_pc_throughput_avg(self)

    def set_processor_affinity(self, mask: "std::vector< int,std::allocator< int > > const &") -> "void":
        r"""set_processor_affinity(cma_equalizer_cc_sptr self, std::vector< int,std::allocator< int > > const & mask)"""
        return _digital_swig0.cma_equalizer_cc_sptr_set_processor_affinity(self, mask)

    def unset_processor_affinity(self) -> "void":
        r"""unset_processor_affinity(cma_equalizer_cc_sptr self)"""
        return _digital_swig0.cma_equalizer_cc_sptr_unset_processor_affinity(self)

    def processor_affinity(self) -> "std::vector< int,std::allocator< int > >":
        r"""processor_affinity(cma_equalizer_cc_sptr self) -> std::vector< int,std::allocator< int > >"""
        return _digital_swig0.cma_equalizer_cc_sptr_processor_affinity(self)

    def active_thread_priority(self) -> "int":
        r"""active_thread_priority(cma_equalizer_cc_sptr self) -> int"""
        return _digital_swig0.cma_equalizer_cc_sptr_active_thread_priority(self)

    def thread_priority(self) -> "int":
        r"""thread_priority(cma_equalizer_cc_sptr self) -> int"""
        return _digital_swig0.cma_equalizer_cc_sptr_thread_priority(self)

    def set_thread_priority(self, priority: "int") -> "int":
        r"""set_thread_priority(cma_equalizer_cc_sptr self, int priority) -> int"""
        return _digital_swig0.cma_equalizer_cc_sptr_set_thread_priority(self, priority)

    def name(self) -> "std::string":
        r"""name(cma_equalizer_cc_sptr self) -> std::string"""
        return _digital_swig0.cma_equalizer_cc_sptr_name(self)

    def symbol_name(self) -> "std::string":
        r"""symbol_name(cma_equalizer_cc_sptr self) -> std::string"""
        return _digital_swig0.cma_equalizer_cc_sptr_symbol_name(self)

    def input_signature(self) -> "gr::io_signature::sptr":
        r"""input_signature(cma_equalizer_cc_sptr self) -> io_signature_sptr"""
        return _digital_swig0.cma_equalizer_cc_sptr_input_signature(self)

    def output_signature(self) -> "gr::io_signature::sptr":
        r"""output_signature(cma_equalizer_cc_sptr self) -> io_signature_sptr"""
        return _digital_swig0.cma_equalizer_cc_sptr_output_signature(self)

    def unique_id(self) -> "long":
        r"""unique_id(cma_equalizer_cc_sptr self) -> long"""
        return _digital_swig0.cma_equalizer_cc_sptr_unique_id(self)

    def to_basic_block(self) -> "gr::basic_block_sptr":
        r"""to_basic_block(cma_equalizer_cc_sptr self) -> basic_block_sptr"""
        return _digital_swig0.cma_equalizer_cc_sptr_to_basic_block(self)

    def check_topology(self, ninputs: "int", noutputs: "int") -> "bool":
        r"""check_topology(cma_equalizer_cc_sptr self, int ninputs, int noutputs) -> bool"""
        return _digital_swig0.cma_equalizer_cc_sptr_check_topology(self, ninputs, noutputs)

    def alias(self) -> "std::string":
        r"""alias(cma_equalizer_cc_sptr self) -> std::string"""
        return _digital_swig0.cma_equalizer_cc_sptr_alias(self)

    def set_block_alias(self, name: "std::string") -> "void":
        r"""set_block_alias(cma_equalizer_cc_sptr self, std::string name)"""
        return _digital_swig0.cma_equalizer_cc_sptr_set_block_alias(self, name)

    def _post(self, which_port: "swig_pmt_ptr", msg: "swig_pmt_ptr") -> "void":
        r"""_post(cma_equalizer_cc_sptr self, swig_pmt_ptr which_port, swig_pmt_ptr msg)"""
        return _digital_swig0.cma_equalizer_cc_sptr__post(self, which_port, msg)

    def message_ports_in(self) -> "pmt::pmt_t":
        r"""message_ports_in(cma_equalizer_cc_sptr self) -> swig_pmt_ptr"""
        return _digital_swig0.cma_equalizer_cc_sptr_message_ports_in(self)

    def message_ports_out(self) -> "pmt::pmt_t":
        r"""message_ports_out(cma_equalizer_cc_sptr self) -> swig_pmt_ptr"""
        return _digital_swig0.cma_equalizer_cc_sptr_message_ports_out(self)

    def message_subscribers(self, which_port: "swig_pmt_ptr") -> "pmt::pmt_t":
        r"""message_subscribers(cma_equalizer_cc_sptr self, swig_pmt_ptr which_port) -> swig_pmt_ptr"""
        return _digital_swig0.cma_equalizer_cc_sptr_message_subscribers(self, which_port)

# Register cma_equalizer_cc_sptr in _digital_swig0:
_digital_swig0.cma_equalizer_cc_sptr_swigregister(cma_equalizer_cc_sptr)

cma_equalizer_cc_sptr.__repr__ = lambda self: "<gr_block %s (%d)>" % (self.name(), self.unique_id())
cma_equalizer_cc = cma_equalizer_cc.make;

class constellation_decoder_cb_sptr(object):
    r"""Proxy of C++ boost::shared_ptr< gr::digital::constellation_decoder_cb > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(constellation_decoder_cb_sptr self) -> constellation_decoder_cb_sptr
        __init__(constellation_decoder_cb_sptr self, constellation_decoder_cb p) -> constellation_decoder_cb_sptr
        """
        _digital_swig0.constellation_decoder_cb_sptr_swiginit(self, _digital_swig0.new_constellation_decoder_cb_sptr(*args))

    def __deref__(self) -> "gr::digital::constellation_decoder_cb *":
        r"""__deref__(constellation_decoder_cb_sptr self) -> constellation_decoder_cb"""
        return _digital_swig0.constellation_decoder_cb_sptr___deref__(self)
    __swig_destroy__ = _digital_swig0.delete_constellation_decoder_cb_sptr

    def make(self, constellation: "constellation_sptr") -> "gr::digital::constellation_decoder_cb::sptr":
        r"""
        make(constellation_decoder_cb_sptr self, constellation_sptr constellation) -> constellation_decoder_cb_sptr
        Constellation Decoder.

        Decode a constellation's points from a complex space to (unpacked) bits based on the map of the  object.

        Constructor Specific Documentation:

        Make constellation decoder block.

        Args:
            constellation : A constellation derived from class 'constellation'. Use base() method to get a shared pointer to this base class type.
        """
        return _digital_swig0.constellation_decoder_cb_sptr_make(self, constellation)

    def history(self) -> "unsigned int":
        r"""history(constellation_decoder_cb_sptr self) -> unsigned int"""
        return _digital_swig0.constellation_decoder_cb_sptr_history(self)

    def declare_sample_delay(self, *args) -> "void":
        r"""
        declare_sample_delay(constellation_decoder_cb_sptr self, int which, int delay)
        declare_sample_delay(constellation_decoder_cb_sptr self, unsigned int delay)
        """
        return _digital_swig0.constellation_decoder_cb_sptr_declare_sample_delay(self, *args)

    def sample_delay(self, which: "int") -> "unsigned int":
        r"""sample_delay(constellation_decoder_cb_sptr self, int which) -> unsigned int"""
        return _digital_swig0.constellation_decoder_cb_sptr_sample_delay(self, which)

    def set_output_multiple(self, multiple: "int") -> "void":
        r"""set_output_multiple(constellation_decoder_cb_sptr self, int multiple)"""
        return _digital_swig0.constellation_decoder_cb_sptr_set_output_multiple(self, multiple)

    def output_multiple(self) -> "int":
        r"""output_multiple(constellation_decoder_cb_sptr self) -> int"""
        return _digital_swig0.constellation_decoder_cb_sptr_output_multiple(self)

    def relative_rate(self) -> "double":
        r"""relative_rate(constellation_decoder_cb_sptr self) -> double"""
        return _digital_swig0.constellation_decoder_cb_sptr_relative_rate(self)

    def relative_rate_i(self) -> "uint64_t":
        r"""relative_rate_i(constellation_decoder_cb_sptr self) -> uint64_t"""
        return _digital_swig0.constellation_decoder_cb_sptr_relative_rate_i(self)

    def relative_rate_d(self) -> "uint64_t":
        r"""relative_rate_d(constellation_decoder_cb_sptr self) -> uint64_t"""
        return _digital_swig0.constellation_decoder_cb_sptr_relative_rate_d(self)

    def start(self) -> "bool":
        r"""start(constellation_decoder_cb_sptr self) -> bool"""
        return _digital_swig0.constellation_decoder_cb_sptr_start(self)

    def stop(self) -> "bool":
        r"""stop(constellation_decoder_cb_sptr self) -> bool"""
        return _digital_swig0.constellation_decoder_cb_sptr_stop(self)

    def nitems_read(self, which_input: "unsigned int") -> "uint64_t":
        r"""nitems_read(constellation_decoder_cb_sptr self, unsigned int which_input) -> uint64_t"""
        return _digital_swig0.constellation_decoder_cb_sptr_nitems_read(self, which_input)

    def nitems_written(self, which_output: "unsigned int") -> "uint64_t":
        r"""nitems_written(constellation_decoder_cb_sptr self, unsigned int which_output) -> uint64_t"""
        return _digital_swig0.constellation_decoder_cb_sptr_nitems_written(self, which_output)

    def set_log_level(self, level: "std::string") -> "void":
        r"""set_log_level(constellation_decoder_cb_sptr self, std::string level)"""
        return _digital_swig0.constellation_decoder_cb_sptr_set_log_level(self, level)

    def log_level(self) -> "std::string":
        r"""log_level(constellation_decoder_cb_sptr self) -> std::string"""
        return _digital_swig0.constellation_decoder_cb_sptr_log_level(self)

    def max_noutput_items(self) -> "int":
        r"""max_noutput_items(constellation_decoder_cb_sptr self) -> int"""
        return _digital_swig0.constellation_decoder_cb_sptr_max_noutput_items(self)

    def set_max_noutput_items(self, m: "int") -> "void":
        r"""set_max_noutput_items(constellation_decoder_cb_sptr self, int m)"""
        return _digital_swig0.constellation_decoder_cb_sptr_set_max_noutput_items(self, m)

    def unset_max_noutput_items(self) -> "void":
        r"""unset_max_noutput_items(constellation_decoder_cb_sptr self)"""
        return _digital_swig0.constellation_decoder_cb_sptr_unset_max_noutput_items(self)

    def is_set_max_noutput_items(self) -> "bool":
        r"""is_set_max_noutput_items(constellation_decoder_cb_sptr self) -> bool"""
        return _digital_swig0.constellation_decoder_cb_sptr_is_set_max_noutput_items(self)

    def set_min_noutput_items(self, m: "int") -> "void":
        r"""set_min_noutput_items(constellation_decoder_cb_sptr self, int m)"""
        return _digital_swig0.constellation_decoder_cb_sptr_set_min_noutput_items(self, m)

    def min_noutput_items(self) -> "int":
        r"""min_noutput_items(constellation_decoder_cb_sptr self) -> int"""
        return _digital_swig0.constellation_decoder_cb_sptr_min_noutput_items(self)

    def max_output_buffer(self, i: "int") -> "long":
        r"""max_output_buffer(constellation_decoder_cb_sptr self, int i) -> long"""
        return _digital_swig0.constellation_decoder_cb_sptr_max_output_buffer(self, i)

    def set_max_output_buffer(self, *args) -> "void":
        r"""
        set_max_output_buffer(constellation_decoder_cb_sptr self, long max_output_buffer)
        set_max_output_buffer(constellation_decoder_cb_sptr self, int port, long max_output_buffer)
        """
        return _digital_swig0.constellation_decoder_cb_sptr_set_max_output_buffer(self, *args)

    def min_output_buffer(self, i: "int") -> "long":
        r"""min_output_buffer(constellation_decoder_cb_sptr self, int i) -> long"""
        return _digital_swig0.constellation_decoder_cb_sptr_min_output_buffer(self, i)

    def set_min_output_buffer(self, *args) -> "void":
        r"""
        set_min_output_buffer(constellation_decoder_cb_sptr self, long min_output_buffer)
        set_min_output_buffer(constellation_decoder_cb_sptr self, int port, long min_output_buffer)
        """
        return _digital_swig0.constellation_decoder_cb_sptr_set_min_output_buffer(self, *args)

    def pc_noutput_items(self) -> "float":
        r"""pc_noutput_items(constellation_decoder_cb_sptr self) -> float"""
        return _digital_swig0.constellation_decoder_cb_sptr_pc_noutput_items(self)

    def pc_noutput_items_avg(self) -> "float":
        r"""pc_noutput_items_avg(constellation_decoder_cb_sptr self) -> float"""
        return _digital_swig0.constellation_decoder_cb_sptr_pc_noutput_items_avg(self)

    def pc_noutput_items_var(self) -> "float":
        r"""pc_noutput_items_var(constellation_decoder_cb_sptr self) -> float"""
        return _digital_swig0.constellation_decoder_cb_sptr_pc_noutput_items_var(self)

    def pc_nproduced(self) -> "float":
        r"""pc_nproduced(constellation_decoder_cb_sptr self) -> float"""
        return _digital_swig0.constellation_decoder_cb_sptr_pc_nproduced(self)

    def pc_nproduced_avg(self) -> "float":
        r"""pc_nproduced_avg(constellation_decoder_cb_sptr self) -> float"""
        return _digital_swig0.constellation_decoder_cb_sptr_pc_nproduced_avg(self)

    def pc_nproduced_var(self) -> "float":
        r"""pc_nproduced_var(constellation_decoder_cb_sptr self) -> float"""
        return _digital_swig0.constellation_decoder_cb_sptr_pc_nproduced_var(self)

    def pc_input_buffers_full(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full(constellation_decoder_cb_sptr self, int which) -> float
        pc_input_buffers_full(constellation_decoder_cb_sptr self) -> pmt_vector_float
        """
        return _digital_swig0.constellation_decoder_cb_sptr_pc_input_buffers_full(self, *args)

    def pc_input_buffers_full_avg(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full_avg(constellation_decoder_cb_sptr self, int which) -> float
        pc_input_buffers_full_avg(constellation_decoder_cb_sptr self) -> pmt_vector_float
        """
        return _digital_swig0.constellation_decoder_cb_sptr_pc_input_buffers_full_avg(self, *args)

    def pc_input_buffers_full_var(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full_var(constellation_decoder_cb_sptr self, int which) -> float
        pc_input_buffers_full_var(constellation_decoder_cb_sptr self) -> pmt_vector_float
        """
        return _digital_swig0.constellation_decoder_cb_sptr_pc_input_buffers_full_var(self, *args)

    def pc_output_buffers_full(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full(constellation_decoder_cb_sptr self, int which) -> float
        pc_output_buffers_full(constellation_decoder_cb_sptr self) -> pmt_vector_float
        """
        return _digital_swig0.constellation_decoder_cb_sptr_pc_output_buffers_full(self, *args)

    def pc_output_buffers_full_avg(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full_avg(constellation_decoder_cb_sptr self, int which) -> float
        pc_output_buffers_full_avg(constellation_decoder_cb_sptr self) -> pmt_vector_float
        """
        return _digital_swig0.constellation_decoder_cb_sptr_pc_output_buffers_full_avg(self, *args)

    def pc_output_buffers_full_var(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full_var(constellation_decoder_cb_sptr self, int which) -> float
        pc_output_buffers_full_var(constellation_decoder_cb_sptr self) -> pmt_vector_float
        """
        return _digital_swig0.constellation_decoder_cb_sptr_pc_output_buffers_full_var(self, *args)

    def pc_work_time(self) -> "float":
        r"""pc_work_time(constellation_decoder_cb_sptr self) -> float"""
        return _digital_swig0.constellation_decoder_cb_sptr_pc_work_time(self)

    def pc_work_time_avg(self) -> "float":
        r"""pc_work_time_avg(constellation_decoder_cb_sptr self) -> float"""
        return _digital_swig0.constellation_decoder_cb_sptr_pc_work_time_avg(self)

    def pc_work_time_var(self) -> "float":
        r"""pc_work_time_var(constellation_decoder_cb_sptr self) -> float"""
        return _digital_swig0.constellation_decoder_cb_sptr_pc_work_time_var(self)

    def pc_work_time_total(self) -> "float":
        r"""pc_work_time_total(constellation_decoder_cb_sptr self) -> float"""
        return _digital_swig0.constellation_decoder_cb_sptr_pc_work_time_total(self)

    def pc_throughput_avg(self) -> "float":
        r"""pc_throughput_avg(constellation_decoder_cb_sptr self) -> float"""
        return _digital_swig0.constellation_decoder_cb_sptr_pc_throughput_avg(self)

    def set_processor_affinity(self, mask: "std::vector< int,std::allocator< int > > const &") -> "void":
        r"""set_processor_affinity(constellation_decoder_cb_sptr self, std::vector< int,std::allocator< int > > const & mask)"""
        return _digital_swig0.constellation_decoder_cb_sptr_set_processor_affinity(self, mask)

    def unset_processor_affinity(self) -> "void":
        r"""unset_processor_affinity(constellation_decoder_cb_sptr self)"""
        return _digital_swig0.constellation_decoder_cb_sptr_unset_processor_affinity(self)

    def processor_affinity(self) -> "std::vector< int,std::allocator< int > >":
        r"""processor_affinity(constellation_decoder_cb_sptr self) -> std::vector< int,std::allocator< int > >"""
        return _digital_swig0.constellation_decoder_cb_sptr_processor_affinity(self)

    def active_thread_priority(self) -> "int":
        r"""active_thread_priority(constellation_decoder_cb_sptr self) -> int"""
        return _digital_swig0.constellation_decoder_cb_sptr_active_thread_priority(self)

    def thread_priority(self) -> "int":
        r"""thread_priority(constellation_decoder_cb_sptr self) -> int"""
        return _digital_swig0.constellation_decoder_cb_sptr_thread_priority(self)

    def set_thread_priority(self, priority: "int") -> "int":
        r"""set_thread_priority(constellation_decoder_cb_sptr self, int priority) -> int"""
        return _digital_swig0.constellation_decoder_cb_sptr_set_thread_priority(self, priority)

    def name(self) -> "std::string":
        r"""name(constellation_decoder_cb_sptr self) -> std::string"""
        return _digital_swig0.constellation_decoder_cb_sptr_name(self)

    def symbol_name(self) -> "std::string":
        r"""symbol_name(constellation_decoder_cb_sptr self) -> std::string"""
        return _digital_swig0.constellation_decoder_cb_sptr_symbol_name(self)

    def input_signature(self) -> "gr::io_signature::sptr":
        r"""input_signature(constellation_decoder_cb_sptr self) -> io_signature_sptr"""
        return _digital_swig0.constellation_decoder_cb_sptr_input_signature(self)

    def output_signature(self) -> "gr::io_signature::sptr":
        r"""output_signature(constellation_decoder_cb_sptr self) -> io_signature_sptr"""
        return _digital_swig0.constellation_decoder_cb_sptr_output_signature(self)

    def unique_id(self) -> "long":
        r"""unique_id(constellation_decoder_cb_sptr self) -> long"""
        return _digital_swig0.constellation_decoder_cb_sptr_unique_id(self)

    def to_basic_block(self) -> "gr::basic_block_sptr":
        r"""to_basic_block(constellation_decoder_cb_sptr self) -> basic_block_sptr"""
        return _digital_swig0.constellation_decoder_cb_sptr_to_basic_block(self)

    def check_topology(self, ninputs: "int", noutputs: "int") -> "bool":
        r"""check_topology(constellation_decoder_cb_sptr self, int ninputs, int noutputs) -> bool"""
        return _digital_swig0.constellation_decoder_cb_sptr_check_topology(self, ninputs, noutputs)

    def alias(self) -> "std::string":
        r"""alias(constellation_decoder_cb_sptr self) -> std::string"""
        return _digital_swig0.constellation_decoder_cb_sptr_alias(self)

    def set_block_alias(self, name: "std::string") -> "void":
        r"""set_block_alias(constellation_decoder_cb_sptr self, std::string name)"""
        return _digital_swig0.constellation_decoder_cb_sptr_set_block_alias(self, name)

    def _post(self, which_port: "swig_pmt_ptr", msg: "swig_pmt_ptr") -> "void":
        r"""_post(constellation_decoder_cb_sptr self, swig_pmt_ptr which_port, swig_pmt_ptr msg)"""
        return _digital_swig0.constellation_decoder_cb_sptr__post(self, which_port, msg)

    def message_ports_in(self) -> "pmt::pmt_t":
        r"""message_ports_in(constellation_decoder_cb_sptr self) -> swig_pmt_ptr"""
        return _digital_swig0.constellation_decoder_cb_sptr_message_ports_in(self)

    def message_ports_out(self) -> "pmt::pmt_t":
        r"""message_ports_out(constellation_decoder_cb_sptr self) -> swig_pmt_ptr"""
        return _digital_swig0.constellation_decoder_cb_sptr_message_ports_out(self)

    def message_subscribers(self, which_port: "swig_pmt_ptr") -> "pmt::pmt_t":
        r"""message_subscribers(constellation_decoder_cb_sptr self, swig_pmt_ptr which_port) -> swig_pmt_ptr"""
        return _digital_swig0.constellation_decoder_cb_sptr_message_subscribers(self, which_port)

# Register constellation_decoder_cb_sptr in _digital_swig0:
_digital_swig0.constellation_decoder_cb_sptr_swigregister(constellation_decoder_cb_sptr)

constellation_decoder_cb_sptr.__repr__ = lambda self: "<gr_block %s (%d)>" % (self.name(), self.unique_id())
constellation_decoder_cb = constellation_decoder_cb.make;

class constellation_receiver_cb_sptr(object):
    r"""Proxy of C++ boost::shared_ptr< gr::digital::constellation_receiver_cb > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(constellation_receiver_cb_sptr self) -> constellation_receiver_cb_sptr
        __init__(constellation_receiver_cb_sptr self, constellation_receiver_cb p) -> constellation_receiver_cb_sptr
        """
        _digital_swig0.constellation_receiver_cb_sptr_swiginit(self, _digital_swig0.new_constellation_receiver_cb_sptr(*args))

    def __deref__(self) -> "gr::digital::constellation_receiver_cb *":
        r"""__deref__(constellation_receiver_cb_sptr self) -> constellation_receiver_cb"""
        return _digital_swig0.constellation_receiver_cb_sptr___deref__(self)
    __swig_destroy__ = _digital_swig0.delete_constellation_receiver_cb_sptr

    def make(self, constellation: "constellation_sptr", loop_bw: "float", fmin: "float", fmax: "float") -> "gr::digital::constellation_receiver_cb::sptr":
        r"""
        make(constellation_receiver_cb_sptr self, constellation_sptr constellation, float loop_bw, float fmin, float fmax) -> constellation_receiver_cb_sptr
        This block makes hard decisions about the received symbols (using a constellation object) and also fine tunes phase synchronization.

        The phase and frequency synchronization are based on a Costas loop that finds the error of the incoming signal point compared to its nearest constellation point. The frequency and phase of the NCO are updated according to this error.


        Message Ports:


        set_constellation (input): Receives a PMT any containing a new gr::digital::constellation object. The PMT is cast back to a gr::digital::constellation_sptr and passes this to set_constellation.


        rotate_phase (input): Receives a PMT double to update the phase. The phase value passed in the message is added to the current phase of the receiver.

        Constructor Specific Documentation:

        Constructs a constellation receiver that (phase/fine freq) synchronizes and decodes constellation points specified by a constellation object.

        Args:
            constellation : constellation of points for generic modulation
            loop_bw : Loop bandwidth of the Costas Loop (~ 2pi/100)
            fmin : minimum normalized frequency value the loop can achieve
            fmax : maximum normalized frequency value the loop can achieve
        """
        return _digital_swig0.constellation_receiver_cb_sptr_make(self, constellation, loop_bw, fmin, fmax)

    def phase_error_tracking(self, phase_error: "float") -> "void":
        r"""phase_error_tracking(constellation_receiver_cb_sptr self, float phase_error)"""
        return _digital_swig0.constellation_receiver_cb_sptr_phase_error_tracking(self, phase_error)

    def history(self) -> "unsigned int":
        r"""history(constellation_receiver_cb_sptr self) -> unsigned int"""
        return _digital_swig0.constellation_receiver_cb_sptr_history(self)

    def declare_sample_delay(self, *args) -> "void":
        r"""
        declare_sample_delay(constellation_receiver_cb_sptr self, int which, int delay)
        declare_sample_delay(constellation_receiver_cb_sptr self, unsigned int delay)
        """
        return _digital_swig0.constellation_receiver_cb_sptr_declare_sample_delay(self, *args)

    def sample_delay(self, which: "int") -> "unsigned int":
        r"""sample_delay(constellation_receiver_cb_sptr self, int which) -> unsigned int"""
        return _digital_swig0.constellation_receiver_cb_sptr_sample_delay(self, which)

    def set_output_multiple(self, multiple: "int") -> "void":
        r"""set_output_multiple(constellation_receiver_cb_sptr self, int multiple)"""
        return _digital_swig0.constellation_receiver_cb_sptr_set_output_multiple(self, multiple)

    def output_multiple(self) -> "int":
        r"""output_multiple(constellation_receiver_cb_sptr self) -> int"""
        return _digital_swig0.constellation_receiver_cb_sptr_output_multiple(self)

    def relative_rate(self) -> "double":
        r"""relative_rate(constellation_receiver_cb_sptr self) -> double"""
        return _digital_swig0.constellation_receiver_cb_sptr_relative_rate(self)

    def relative_rate_i(self) -> "uint64_t":
        r"""relative_rate_i(constellation_receiver_cb_sptr self) -> uint64_t"""
        return _digital_swig0.constellation_receiver_cb_sptr_relative_rate_i(self)

    def relative_rate_d(self) -> "uint64_t":
        r"""relative_rate_d(constellation_receiver_cb_sptr self) -> uint64_t"""
        return _digital_swig0.constellation_receiver_cb_sptr_relative_rate_d(self)

    def start(self) -> "bool":
        r"""start(constellation_receiver_cb_sptr self) -> bool"""
        return _digital_swig0.constellation_receiver_cb_sptr_start(self)

    def stop(self) -> "bool":
        r"""stop(constellation_receiver_cb_sptr self) -> bool"""
        return _digital_swig0.constellation_receiver_cb_sptr_stop(self)

    def nitems_read(self, which_input: "unsigned int") -> "uint64_t":
        r"""nitems_read(constellation_receiver_cb_sptr self, unsigned int which_input) -> uint64_t"""
        return _digital_swig0.constellation_receiver_cb_sptr_nitems_read(self, which_input)

    def nitems_written(self, which_output: "unsigned int") -> "uint64_t":
        r"""nitems_written(constellation_receiver_cb_sptr self, unsigned int which_output) -> uint64_t"""
        return _digital_swig0.constellation_receiver_cb_sptr_nitems_written(self, which_output)

    def set_log_level(self, level: "std::string") -> "void":
        r"""set_log_level(constellation_receiver_cb_sptr self, std::string level)"""
        return _digital_swig0.constellation_receiver_cb_sptr_set_log_level(self, level)

    def log_level(self) -> "std::string":
        r"""log_level(constellation_receiver_cb_sptr self) -> std::string"""
        return _digital_swig0.constellation_receiver_cb_sptr_log_level(self)

    def max_noutput_items(self) -> "int":
        r"""max_noutput_items(constellation_receiver_cb_sptr self) -> int"""
        return _digital_swig0.constellation_receiver_cb_sptr_max_noutput_items(self)

    def set_max_noutput_items(self, m: "int") -> "void":
        r"""set_max_noutput_items(constellation_receiver_cb_sptr self, int m)"""
        return _digital_swig0.constellation_receiver_cb_sptr_set_max_noutput_items(self, m)

    def unset_max_noutput_items(self) -> "void":
        r"""unset_max_noutput_items(constellation_receiver_cb_sptr self)"""
        return _digital_swig0.constellation_receiver_cb_sptr_unset_max_noutput_items(self)

    def is_set_max_noutput_items(self) -> "bool":
        r"""is_set_max_noutput_items(constellation_receiver_cb_sptr self) -> bool"""
        return _digital_swig0.constellation_receiver_cb_sptr_is_set_max_noutput_items(self)

    def set_min_noutput_items(self, m: "int") -> "void":
        r"""set_min_noutput_items(constellation_receiver_cb_sptr self, int m)"""
        return _digital_swig0.constellation_receiver_cb_sptr_set_min_noutput_items(self, m)

    def min_noutput_items(self) -> "int":
        r"""min_noutput_items(constellation_receiver_cb_sptr self) -> int"""
        return _digital_swig0.constellation_receiver_cb_sptr_min_noutput_items(self)

    def max_output_buffer(self, i: "int") -> "long":
        r"""max_output_buffer(constellation_receiver_cb_sptr self, int i) -> long"""
        return _digital_swig0.constellation_receiver_cb_sptr_max_output_buffer(self, i)

    def set_max_output_buffer(self, *args) -> "void":
        r"""
        set_max_output_buffer(constellation_receiver_cb_sptr self, long max_output_buffer)
        set_max_output_buffer(constellation_receiver_cb_sptr self, int port, long max_output_buffer)
        """
        return _digital_swig0.constellation_receiver_cb_sptr_set_max_output_buffer(self, *args)

    def min_output_buffer(self, i: "int") -> "long":
        r"""min_output_buffer(constellation_receiver_cb_sptr self, int i) -> long"""
        return _digital_swig0.constellation_receiver_cb_sptr_min_output_buffer(self, i)

    def set_min_output_buffer(self, *args) -> "void":
        r"""
        set_min_output_buffer(constellation_receiver_cb_sptr self, long min_output_buffer)
        set_min_output_buffer(constellation_receiver_cb_sptr self, int port, long min_output_buffer)
        """
        return _digital_swig0.constellation_receiver_cb_sptr_set_min_output_buffer(self, *args)

    def pc_noutput_items(self) -> "float":
        r"""pc_noutput_items(constellation_receiver_cb_sptr self) -> float"""
        return _digital_swig0.constellation_receiver_cb_sptr_pc_noutput_items(self)

    def pc_noutput_items_avg(self) -> "float":
        r"""pc_noutput_items_avg(constellation_receiver_cb_sptr self) -> float"""
        return _digital_swig0.constellation_receiver_cb_sptr_pc_noutput_items_avg(self)

    def pc_noutput_items_var(self) -> "float":
        r"""pc_noutput_items_var(constellation_receiver_cb_sptr self) -> float"""
        return _digital_swig0.constellation_receiver_cb_sptr_pc_noutput_items_var(self)

    def pc_nproduced(self) -> "float":
        r"""pc_nproduced(constellation_receiver_cb_sptr self) -> float"""
        return _digital_swig0.constellation_receiver_cb_sptr_pc_nproduced(self)

    def pc_nproduced_avg(self) -> "float":
        r"""pc_nproduced_avg(constellation_receiver_cb_sptr self) -> float"""
        return _digital_swig0.constellation_receiver_cb_sptr_pc_nproduced_avg(self)

    def pc_nproduced_var(self) -> "float":
        r"""pc_nproduced_var(constellation_receiver_cb_sptr self) -> float"""
        return _digital_swig0.constellation_receiver_cb_sptr_pc_nproduced_var(self)

    def pc_input_buffers_full(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full(constellation_receiver_cb_sptr self, int which) -> float
        pc_input_buffers_full(constellation_receiver_cb_sptr self) -> pmt_vector_float
        """
        return _digital_swig0.constellation_receiver_cb_sptr_pc_input_buffers_full(self, *args)

    def pc_input_buffers_full_avg(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full_avg(constellation_receiver_cb_sptr self, int which) -> float
        pc_input_buffers_full_avg(constellation_receiver_cb_sptr self) -> pmt_vector_float
        """
        return _digital_swig0.constellation_receiver_cb_sptr_pc_input_buffers_full_avg(self, *args)

    def pc_input_buffers_full_var(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full_var(constellation_receiver_cb_sptr self, int which) -> float
        pc_input_buffers_full_var(constellation_receiver_cb_sptr self) -> pmt_vector_float
        """
        return _digital_swig0.constellation_receiver_cb_sptr_pc_input_buffers_full_var(self, *args)

    def pc_output_buffers_full(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full(constellation_receiver_cb_sptr self, int which) -> float
        pc_output_buffers_full(constellation_receiver_cb_sptr self) -> pmt_vector_float
        """
        return _digital_swig0.constellation_receiver_cb_sptr_pc_output_buffers_full(self, *args)

    def pc_output_buffers_full_avg(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full_avg(constellation_receiver_cb_sptr self, int which) -> float
        pc_output_buffers_full_avg(constellation_receiver_cb_sptr self) -> pmt_vector_float
        """
        return _digital_swig0.constellation_receiver_cb_sptr_pc_output_buffers_full_avg(self, *args)

    def pc_output_buffers_full_var(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full_var(constellation_receiver_cb_sptr self, int which) -> float
        pc_output_buffers_full_var(constellation_receiver_cb_sptr self) -> pmt_vector_float
        """
        return _digital_swig0.constellation_receiver_cb_sptr_pc_output_buffers_full_var(self, *args)

    def pc_work_time(self) -> "float":
        r"""pc_work_time(constellation_receiver_cb_sptr self) -> float"""
        return _digital_swig0.constellation_receiver_cb_sptr_pc_work_time(self)

    def pc_work_time_avg(self) -> "float":
        r"""pc_work_time_avg(constellation_receiver_cb_sptr self) -> float"""
        return _digital_swig0.constellation_receiver_cb_sptr_pc_work_time_avg(self)

    def pc_work_time_var(self) -> "float":
        r"""pc_work_time_var(constellation_receiver_cb_sptr self) -> float"""
        return _digital_swig0.constellation_receiver_cb_sptr_pc_work_time_var(self)

    def pc_work_time_total(self) -> "float":
        r"""pc_work_time_total(constellation_receiver_cb_sptr self) -> float"""
        return _digital_swig0.constellation_receiver_cb_sptr_pc_work_time_total(self)

    def pc_throughput_avg(self) -> "float":
        r"""pc_throughput_avg(constellation_receiver_cb_sptr self) -> float"""
        return _digital_swig0.constellation_receiver_cb_sptr_pc_throughput_avg(self)

    def set_processor_affinity(self, mask: "std::vector< int,std::allocator< int > > const &") -> "void":
        r"""set_processor_affinity(constellation_receiver_cb_sptr self, std::vector< int,std::allocator< int > > const & mask)"""
        return _digital_swig0.constellation_receiver_cb_sptr_set_processor_affinity(self, mask)

    def unset_processor_affinity(self) -> "void":
        r"""unset_processor_affinity(constellation_receiver_cb_sptr self)"""
        return _digital_swig0.constellation_receiver_cb_sptr_unset_processor_affinity(self)

    def processor_affinity(self) -> "std::vector< int,std::allocator< int > >":
        r"""processor_affinity(constellation_receiver_cb_sptr self) -> std::vector< int,std::allocator< int > >"""
        return _digital_swig0.constellation_receiver_cb_sptr_processor_affinity(self)

    def active_thread_priority(self) -> "int":
        r"""active_thread_priority(constellation_receiver_cb_sptr self) -> int"""
        return _digital_swig0.constellation_receiver_cb_sptr_active_thread_priority(self)

    def thread_priority(self) -> "int":
        r"""thread_priority(constellation_receiver_cb_sptr self) -> int"""
        return _digital_swig0.constellation_receiver_cb_sptr_thread_priority(self)

    def set_thread_priority(self, priority: "int") -> "int":
        r"""set_thread_priority(constellation_receiver_cb_sptr self, int priority) -> int"""
        return _digital_swig0.constellation_receiver_cb_sptr_set_thread_priority(self, priority)

    def name(self) -> "std::string":
        r"""name(constellation_receiver_cb_sptr self) -> std::string"""
        return _digital_swig0.constellation_receiver_cb_sptr_name(self)

    def symbol_name(self) -> "std::string":
        r"""symbol_name(constellation_receiver_cb_sptr self) -> std::string"""
        return _digital_swig0.constellation_receiver_cb_sptr_symbol_name(self)

    def input_signature(self) -> "gr::io_signature::sptr":
        r"""input_signature(constellation_receiver_cb_sptr self) -> io_signature_sptr"""
        return _digital_swig0.constellation_receiver_cb_sptr_input_signature(self)

    def output_signature(self) -> "gr::io_signature::sptr":
        r"""output_signature(constellation_receiver_cb_sptr self) -> io_signature_sptr"""
        return _digital_swig0.constellation_receiver_cb_sptr_output_signature(self)

    def unique_id(self) -> "long":
        r"""unique_id(constellation_receiver_cb_sptr self) -> long"""
        return _digital_swig0.constellation_receiver_cb_sptr_unique_id(self)

    def to_basic_block(self) -> "gr::basic_block_sptr":
        r"""to_basic_block(constellation_receiver_cb_sptr self) -> basic_block_sptr"""
        return _digital_swig0.constellation_receiver_cb_sptr_to_basic_block(self)

    def check_topology(self, ninputs: "int", noutputs: "int") -> "bool":
        r"""check_topology(constellation_receiver_cb_sptr self, int ninputs, int noutputs) -> bool"""
        return _digital_swig0.constellation_receiver_cb_sptr_check_topology(self, ninputs, noutputs)

    def alias(self) -> "std::string":
        r"""alias(constellation_receiver_cb_sptr self) -> std::string"""
        return _digital_swig0.constellation_receiver_cb_sptr_alias(self)

    def set_block_alias(self, name: "std::string") -> "void":
        r"""set_block_alias(constellation_receiver_cb_sptr self, std::string name)"""
        return _digital_swig0.constellation_receiver_cb_sptr_set_block_alias(self, name)

    def _post(self, which_port: "swig_pmt_ptr", msg: "swig_pmt_ptr") -> "void":
        r"""_post(constellation_receiver_cb_sptr self, swig_pmt_ptr which_port, swig_pmt_ptr msg)"""
        return _digital_swig0.constellation_receiver_cb_sptr__post(self, which_port, msg)

    def message_ports_in(self) -> "pmt::pmt_t":
        r"""message_ports_in(constellation_receiver_cb_sptr self) -> swig_pmt_ptr"""
        return _digital_swig0.constellation_receiver_cb_sptr_message_ports_in(self)

    def message_ports_out(self) -> "pmt::pmt_t":
        r"""message_ports_out(constellation_receiver_cb_sptr self) -> swig_pmt_ptr"""
        return _digital_swig0.constellation_receiver_cb_sptr_message_ports_out(self)

    def message_subscribers(self, which_port: "swig_pmt_ptr") -> "pmt::pmt_t":
        r"""message_subscribers(constellation_receiver_cb_sptr self, swig_pmt_ptr which_port) -> swig_pmt_ptr"""
        return _digital_swig0.constellation_receiver_cb_sptr_message_subscribers(self, which_port)

    def update_gains(self) -> "void":
        r"""update_gains(constellation_receiver_cb_sptr self)"""
        return _digital_swig0.constellation_receiver_cb_sptr_update_gains(self)

    def advance_loop(self, error: "float") -> "void":
        r"""advance_loop(constellation_receiver_cb_sptr self, float error)"""
        return _digital_swig0.constellation_receiver_cb_sptr_advance_loop(self, error)

    def phase_wrap(self) -> "void":
        r"""phase_wrap(constellation_receiver_cb_sptr self)"""
        return _digital_swig0.constellation_receiver_cb_sptr_phase_wrap(self)

    def frequency_limit(self) -> "void":
        r"""frequency_limit(constellation_receiver_cb_sptr self)"""
        return _digital_swig0.constellation_receiver_cb_sptr_frequency_limit(self)

    def set_loop_bandwidth(self, bw: "float") -> "void":
        r"""set_loop_bandwidth(constellation_receiver_cb_sptr self, float bw)"""
        return _digital_swig0.constellation_receiver_cb_sptr_set_loop_bandwidth(self, bw)

    def set_damping_factor(self, df: "float") -> "void":
        r"""set_damping_factor(constellation_receiver_cb_sptr self, float df)"""
        return _digital_swig0.constellation_receiver_cb_sptr_set_damping_factor(self, df)

    def set_alpha(self, alpha: "float") -> "void":
        r"""set_alpha(constellation_receiver_cb_sptr self, float alpha)"""
        return _digital_swig0.constellation_receiver_cb_sptr_set_alpha(self, alpha)

    def set_beta(self, beta: "float") -> "void":
        r"""set_beta(constellation_receiver_cb_sptr self, float beta)"""
        return _digital_swig0.constellation_receiver_cb_sptr_set_beta(self, beta)

    def set_frequency(self, freq: "float") -> "void":
        r"""set_frequency(constellation_receiver_cb_sptr self, float freq)"""
        return _digital_swig0.constellation_receiver_cb_sptr_set_frequency(self, freq)

    def set_phase(self, phase: "float") -> "void":
        r"""set_phase(constellation_receiver_cb_sptr self, float phase)"""
        return _digital_swig0.constellation_receiver_cb_sptr_set_phase(self, phase)

    def set_max_freq(self, freq: "float") -> "void":
        r"""set_max_freq(constellation_receiver_cb_sptr self, float freq)"""
        return _digital_swig0.constellation_receiver_cb_sptr_set_max_freq(self, freq)

    def set_min_freq(self, freq: "float") -> "void":
        r"""set_min_freq(constellation_receiver_cb_sptr self, float freq)"""
        return _digital_swig0.constellation_receiver_cb_sptr_set_min_freq(self, freq)

    def get_loop_bandwidth(self) -> "float":
        r"""get_loop_bandwidth(constellation_receiver_cb_sptr self) -> float"""
        return _digital_swig0.constellation_receiver_cb_sptr_get_loop_bandwidth(self)

    def get_damping_factor(self) -> "float":
        r"""get_damping_factor(constellation_receiver_cb_sptr self) -> float"""
        return _digital_swig0.constellation_receiver_cb_sptr_get_damping_factor(self)

    def get_alpha(self) -> "float":
        r"""get_alpha(constellation_receiver_cb_sptr self) -> float"""
        return _digital_swig0.constellation_receiver_cb_sptr_get_alpha(self)

    def get_beta(self) -> "float":
        r"""get_beta(constellation_receiver_cb_sptr self) -> float"""
        return _digital_swig0.constellation_receiver_cb_sptr_get_beta(self)

    def get_frequency(self) -> "float":
        r"""get_frequency(constellation_receiver_cb_sptr self) -> float"""
        return _digital_swig0.constellation_receiver_cb_sptr_get_frequency(self)

    def get_phase(self) -> "float":
        r"""get_phase(constellation_receiver_cb_sptr self) -> float"""
        return _digital_swig0.constellation_receiver_cb_sptr_get_phase(self)

    def get_max_freq(self) -> "float":
        r"""get_max_freq(constellation_receiver_cb_sptr self) -> float"""
        return _digital_swig0.constellation_receiver_cb_sptr_get_max_freq(self)

    def get_min_freq(self) -> "float":
        r"""get_min_freq(constellation_receiver_cb_sptr self) -> float"""
        return _digital_swig0.constellation_receiver_cb_sptr_get_min_freq(self)

# Register constellation_receiver_cb_sptr in _digital_swig0:
_digital_swig0.constellation_receiver_cb_sptr_swigregister(constellation_receiver_cb_sptr)

constellation_receiver_cb_sptr.__repr__ = lambda self: "<gr_block %s (%d)>" % (self.name(), self.unique_id())
constellation_receiver_cb = constellation_receiver_cb.make;

class constellation_soft_decoder_cf_sptr(object):
    r"""Proxy of C++ boost::shared_ptr< gr::digital::constellation_soft_decoder_cf > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(constellation_soft_decoder_cf_sptr self) -> constellation_soft_decoder_cf_sptr
        __init__(constellation_soft_decoder_cf_sptr self, constellation_soft_decoder_cf p) -> constellation_soft_decoder_cf_sptr
        """
        _digital_swig0.constellation_soft_decoder_cf_sptr_swiginit(self, _digital_swig0.new_constellation_soft_decoder_cf_sptr(*args))

    def __deref__(self) -> "gr::digital::constellation_soft_decoder_cf *":
        r"""__deref__(constellation_soft_decoder_cf_sptr self) -> constellation_soft_decoder_cf"""
        return _digital_swig0.constellation_soft_decoder_cf_sptr___deref__(self)
    __swig_destroy__ = _digital_swig0.delete_constellation_soft_decoder_cf_sptr

    def make(self, constellation: "constellation_sptr") -> "gr::digital::constellation_soft_decoder_cf::sptr":
        r"""
        make(constellation_soft_decoder_cf_sptr self, constellation_sptr constellation) -> constellation_soft_decoder_cf_sptr
        Constellation Decoder.

        Decode a constellation's points from a complex space to soft bits based on the map and soft decision LUT of the  object.

        Constructor Specific Documentation:

        Make constellation decoder block.

        Args:
            constellation : A constellation derived from class 'constellation'. Use base() method to get a shared pointer to this base class type.
        """
        return _digital_swig0.constellation_soft_decoder_cf_sptr_make(self, constellation)

    def history(self) -> "unsigned int":
        r"""history(constellation_soft_decoder_cf_sptr self) -> unsigned int"""
        return _digital_swig0.constellation_soft_decoder_cf_sptr_history(self)

    def declare_sample_delay(self, *args) -> "void":
        r"""
        declare_sample_delay(constellation_soft_decoder_cf_sptr self, int which, int delay)
        declare_sample_delay(constellation_soft_decoder_cf_sptr self, unsigned int delay)
        """
        return _digital_swig0.constellation_soft_decoder_cf_sptr_declare_sample_delay(self, *args)

    def sample_delay(self, which: "int") -> "unsigned int":
        r"""sample_delay(constellation_soft_decoder_cf_sptr self, int which) -> unsigned int"""
        return _digital_swig0.constellation_soft_decoder_cf_sptr_sample_delay(self, which)

    def set_output_multiple(self, multiple: "int") -> "void":
        r"""set_output_multiple(constellation_soft_decoder_cf_sptr self, int multiple)"""
        return _digital_swig0.constellation_soft_decoder_cf_sptr_set_output_multiple(self, multiple)

    def output_multiple(self) -> "int":
        r"""output_multiple(constellation_soft_decoder_cf_sptr self) -> int"""
        return _digital_swig0.constellation_soft_decoder_cf_sptr_output_multiple(self)

    def relative_rate(self) -> "double":
        r"""relative_rate(constellation_soft_decoder_cf_sptr self) -> double"""
        return _digital_swig0.constellation_soft_decoder_cf_sptr_relative_rate(self)

    def relative_rate_i(self) -> "uint64_t":
        r"""relative_rate_i(constellation_soft_decoder_cf_sptr self) -> uint64_t"""
        return _digital_swig0.constellation_soft_decoder_cf_sptr_relative_rate_i(self)

    def relative_rate_d(self) -> "uint64_t":
        r"""relative_rate_d(constellation_soft_decoder_cf_sptr self) -> uint64_t"""
        return _digital_swig0.constellation_soft_decoder_cf_sptr_relative_rate_d(self)

    def start(self) -> "bool":
        r"""start(constellation_soft_decoder_cf_sptr self) -> bool"""
        return _digital_swig0.constellation_soft_decoder_cf_sptr_start(self)

    def stop(self) -> "bool":
        r"""stop(constellation_soft_decoder_cf_sptr self) -> bool"""
        return _digital_swig0.constellation_soft_decoder_cf_sptr_stop(self)

    def nitems_read(self, which_input: "unsigned int") -> "uint64_t":
        r"""nitems_read(constellation_soft_decoder_cf_sptr self, unsigned int which_input) -> uint64_t"""
        return _digital_swig0.constellation_soft_decoder_cf_sptr_nitems_read(self, which_input)

    def nitems_written(self, which_output: "unsigned int") -> "uint64_t":
        r"""nitems_written(constellation_soft_decoder_cf_sptr self, unsigned int which_output) -> uint64_t"""
        return _digital_swig0.constellation_soft_decoder_cf_sptr_nitems_written(self, which_output)

    def set_log_level(self, level: "std::string") -> "void":
        r"""set_log_level(constellation_soft_decoder_cf_sptr self, std::string level)"""
        return _digital_swig0.constellation_soft_decoder_cf_sptr_set_log_level(self, level)

    def log_level(self) -> "std::string":
        r"""log_level(constellation_soft_decoder_cf_sptr self) -> std::string"""
        return _digital_swig0.constellation_soft_decoder_cf_sptr_log_level(self)

    def max_noutput_items(self) -> "int":
        r"""max_noutput_items(constellation_soft_decoder_cf_sptr self) -> int"""
        return _digital_swig0.constellation_soft_decoder_cf_sptr_max_noutput_items(self)

    def set_max_noutput_items(self, m: "int") -> "void":
        r"""set_max_noutput_items(constellation_soft_decoder_cf_sptr self, int m)"""
        return _digital_swig0.constellation_soft_decoder_cf_sptr_set_max_noutput_items(self, m)

    def unset_max_noutput_items(self) -> "void":
        r"""unset_max_noutput_items(constellation_soft_decoder_cf_sptr self)"""
        return _digital_swig0.constellation_soft_decoder_cf_sptr_unset_max_noutput_items(self)

    def is_set_max_noutput_items(self) -> "bool":
        r"""is_set_max_noutput_items(constellation_soft_decoder_cf_sptr self) -> bool"""
        return _digital_swig0.constellation_soft_decoder_cf_sptr_is_set_max_noutput_items(self)

    def set_min_noutput_items(self, m: "int") -> "void":
        r"""set_min_noutput_items(constellation_soft_decoder_cf_sptr self, int m)"""
        return _digital_swig0.constellation_soft_decoder_cf_sptr_set_min_noutput_items(self, m)

    def min_noutput_items(self) -> "int":
        r"""min_noutput_items(constellation_soft_decoder_cf_sptr self) -> int"""
        return _digital_swig0.constellation_soft_decoder_cf_sptr_min_noutput_items(self)

    def max_output_buffer(self, i: "int") -> "long":
        r"""max_output_buffer(constellation_soft_decoder_cf_sptr self, int i) -> long"""
        return _digital_swig0.constellation_soft_decoder_cf_sptr_max_output_buffer(self, i)

    def set_max_output_buffer(self, *args) -> "void":
        r"""
        set_max_output_buffer(constellation_soft_decoder_cf_sptr self, long max_output_buffer)
        set_max_output_buffer(constellation_soft_decoder_cf_sptr self, int port, long max_output_buffer)
        """
        return _digital_swig0.constellation_soft_decoder_cf_sptr_set_max_output_buffer(self, *args)

    def min_output_buffer(self, i: "int") -> "long":
        r"""min_output_buffer(constellation_soft_decoder_cf_sptr self, int i) -> long"""
        return _digital_swig0.constellation_soft_decoder_cf_sptr_min_output_buffer(self, i)

    def set_min_output_buffer(self, *args) -> "void":
        r"""
        set_min_output_buffer(constellation_soft_decoder_cf_sptr self, long min_output_buffer)
        set_min_output_buffer(constellation_soft_decoder_cf_sptr self, int port, long min_output_buffer)
        """
        return _digital_swig0.constellation_soft_decoder_cf_sptr_set_min_output_buffer(self, *args)

    def pc_noutput_items(self) -> "float":
        r"""pc_noutput_items(constellation_soft_decoder_cf_sptr self) -> float"""
        return _digital_swig0.constellation_soft_decoder_cf_sptr_pc_noutput_items(self)

    def pc_noutput_items_avg(self) -> "float":
        r"""pc_noutput_items_avg(constellation_soft_decoder_cf_sptr self) -> float"""
        return _digital_swig0.constellation_soft_decoder_cf_sptr_pc_noutput_items_avg(self)

    def pc_noutput_items_var(self) -> "float":
        r"""pc_noutput_items_var(constellation_soft_decoder_cf_sptr self) -> float"""
        return _digital_swig0.constellation_soft_decoder_cf_sptr_pc_noutput_items_var(self)

    def pc_nproduced(self) -> "float":
        r"""pc_nproduced(constellation_soft_decoder_cf_sptr self) -> float"""
        return _digital_swig0.constellation_soft_decoder_cf_sptr_pc_nproduced(self)

    def pc_nproduced_avg(self) -> "float":
        r"""pc_nproduced_avg(constellation_soft_decoder_cf_sptr self) -> float"""
        return _digital_swig0.constellation_soft_decoder_cf_sptr_pc_nproduced_avg(self)

    def pc_nproduced_var(self) -> "float":
        r"""pc_nproduced_var(constellation_soft_decoder_cf_sptr self) -> float"""
        return _digital_swig0.constellation_soft_decoder_cf_sptr_pc_nproduced_var(self)

    def pc_input_buffers_full(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full(constellation_soft_decoder_cf_sptr self, int which) -> float
        pc_input_buffers_full(constellation_soft_decoder_cf_sptr self) -> pmt_vector_float
        """
        return _digital_swig0.constellation_soft_decoder_cf_sptr_pc_input_buffers_full(self, *args)

    def pc_input_buffers_full_avg(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full_avg(constellation_soft_decoder_cf_sptr self, int which) -> float
        pc_input_buffers_full_avg(constellation_soft_decoder_cf_sptr self) -> pmt_vector_float
        """
        return _digital_swig0.constellation_soft_decoder_cf_sptr_pc_input_buffers_full_avg(self, *args)

    def pc_input_buffers_full_var(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full_var(constellation_soft_decoder_cf_sptr self, int which) -> float
        pc_input_buffers_full_var(constellation_soft_decoder_cf_sptr self) -> pmt_vector_float
        """
        return _digital_swig0.constellation_soft_decoder_cf_sptr_pc_input_buffers_full_var(self, *args)

    def pc_output_buffers_full(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full(constellation_soft_decoder_cf_sptr self, int which) -> float
        pc_output_buffers_full(constellation_soft_decoder_cf_sptr self) -> pmt_vector_float
        """
        return _digital_swig0.constellation_soft_decoder_cf_sptr_pc_output_buffers_full(self, *args)

    def pc_output_buffers_full_avg(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full_avg(constellation_soft_decoder_cf_sptr self, int which) -> float
        pc_output_buffers_full_avg(constellation_soft_decoder_cf_sptr self) -> pmt_vector_float
        """
        return _digital_swig0.constellation_soft_decoder_cf_sptr_pc_output_buffers_full_avg(self, *args)

    def pc_output_buffers_full_var(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full_var(constellation_soft_decoder_cf_sptr self, int which) -> float
        pc_output_buffers_full_var(constellation_soft_decoder_cf_sptr self) -> pmt_vector_float
        """
        return _digital_swig0.constellation_soft_decoder_cf_sptr_pc_output_buffers_full_var(self, *args)

    def pc_work_time(self) -> "float":
        r"""pc_work_time(constellation_soft_decoder_cf_sptr self) -> float"""
        return _digital_swig0.constellation_soft_decoder_cf_sptr_pc_work_time(self)

    def pc_work_time_avg(self) -> "float":
        r"""pc_work_time_avg(constellation_soft_decoder_cf_sptr self) -> float"""
        return _digital_swig0.constellation_soft_decoder_cf_sptr_pc_work_time_avg(self)

    def pc_work_time_var(self) -> "float":
        r"""pc_work_time_var(constellation_soft_decoder_cf_sptr self) -> float"""
        return _digital_swig0.constellation_soft_decoder_cf_sptr_pc_work_time_var(self)

    def pc_work_time_total(self) -> "float":
        r"""pc_work_time_total(constellation_soft_decoder_cf_sptr self) -> float"""
        return _digital_swig0.constellation_soft_decoder_cf_sptr_pc_work_time_total(self)

    def pc_throughput_avg(self) -> "float":
        r"""pc_throughput_avg(constellation_soft_decoder_cf_sptr self) -> float"""
        return _digital_swig0.constellation_soft_decoder_cf_sptr_pc_throughput_avg(self)

    def set_processor_affinity(self, mask: "std::vector< int,std::allocator< int > > const &") -> "void":
        r"""set_processor_affinity(constellation_soft_decoder_cf_sptr self, std::vector< int,std::allocator< int > > const & mask)"""
        return _digital_swig0.constellation_soft_decoder_cf_sptr_set_processor_affinity(self, mask)

    def unset_processor_affinity(self) -> "void":
        r"""unset_processor_affinity(constellation_soft_decoder_cf_sptr self)"""
        return _digital_swig0.constellation_soft_decoder_cf_sptr_unset_processor_affinity(self)

    def processor_affinity(self) -> "std::vector< int,std::allocator< int > >":
        r"""processor_affinity(constellation_soft_decoder_cf_sptr self) -> std::vector< int,std::allocator< int > >"""
        return _digital_swig0.constellation_soft_decoder_cf_sptr_processor_affinity(self)

    def active_thread_priority(self) -> "int":
        r"""active_thread_priority(constellation_soft_decoder_cf_sptr self) -> int"""
        return _digital_swig0.constellation_soft_decoder_cf_sptr_active_thread_priority(self)

    def thread_priority(self) -> "int":
        r"""thread_priority(constellation_soft_decoder_cf_sptr self) -> int"""
        return _digital_swig0.constellation_soft_decoder_cf_sptr_thread_priority(self)

    def set_thread_priority(self, priority: "int") -> "int":
        r"""set_thread_priority(constellation_soft_decoder_cf_sptr self, int priority) -> int"""
        return _digital_swig0.constellation_soft_decoder_cf_sptr_set_thread_priority(self, priority)

    def name(self) -> "std::string":
        r"""name(constellation_soft_decoder_cf_sptr self) -> std::string"""
        return _digital_swig0.constellation_soft_decoder_cf_sptr_name(self)

    def symbol_name(self) -> "std::string":
        r"""symbol_name(constellation_soft_decoder_cf_sptr self) -> std::string"""
        return _digital_swig0.constellation_soft_decoder_cf_sptr_symbol_name(self)

    def input_signature(self) -> "gr::io_signature::sptr":
        r"""input_signature(constellation_soft_decoder_cf_sptr self) -> io_signature_sptr"""
        return _digital_swig0.constellation_soft_decoder_cf_sptr_input_signature(self)

    def output_signature(self) -> "gr::io_signature::sptr":
        r"""output_signature(constellation_soft_decoder_cf_sptr self) -> io_signature_sptr"""
        return _digital_swig0.constellation_soft_decoder_cf_sptr_output_signature(self)

    def unique_id(self) -> "long":
        r"""unique_id(constellation_soft_decoder_cf_sptr self) -> long"""
        return _digital_swig0.constellation_soft_decoder_cf_sptr_unique_id(self)

    def to_basic_block(self) -> "gr::basic_block_sptr":
        r"""to_basic_block(constellation_soft_decoder_cf_sptr self) -> basic_block_sptr"""
        return _digital_swig0.constellation_soft_decoder_cf_sptr_to_basic_block(self)

    def check_topology(self, ninputs: "int", noutputs: "int") -> "bool":
        r"""check_topology(constellation_soft_decoder_cf_sptr self, int ninputs, int noutputs) -> bool"""
        return _digital_swig0.constellation_soft_decoder_cf_sptr_check_topology(self, ninputs, noutputs)

    def alias(self) -> "std::string":
        r"""alias(constellation_soft_decoder_cf_sptr self) -> std::string"""
        return _digital_swig0.constellation_soft_decoder_cf_sptr_alias(self)

    def set_block_alias(self, name: "std::string") -> "void":
        r"""set_block_alias(constellation_soft_decoder_cf_sptr self, std::string name)"""
        return _digital_swig0.constellation_soft_decoder_cf_sptr_set_block_alias(self, name)

    def _post(self, which_port: "swig_pmt_ptr", msg: "swig_pmt_ptr") -> "void":
        r"""_post(constellation_soft_decoder_cf_sptr self, swig_pmt_ptr which_port, swig_pmt_ptr msg)"""
        return _digital_swig0.constellation_soft_decoder_cf_sptr__post(self, which_port, msg)

    def message_ports_in(self) -> "pmt::pmt_t":
        r"""message_ports_in(constellation_soft_decoder_cf_sptr self) -> swig_pmt_ptr"""
        return _digital_swig0.constellation_soft_decoder_cf_sptr_message_ports_in(self)

    def message_ports_out(self) -> "pmt::pmt_t":
        r"""message_ports_out(constellation_soft_decoder_cf_sptr self) -> swig_pmt_ptr"""
        return _digital_swig0.constellation_soft_decoder_cf_sptr_message_ports_out(self)

    def message_subscribers(self, which_port: "swig_pmt_ptr") -> "pmt::pmt_t":
        r"""message_subscribers(constellation_soft_decoder_cf_sptr self, swig_pmt_ptr which_port) -> swig_pmt_ptr"""
        return _digital_swig0.constellation_soft_decoder_cf_sptr_message_subscribers(self, which_port)

# Register constellation_soft_decoder_cf_sptr in _digital_swig0:
_digital_swig0.constellation_soft_decoder_cf_sptr_swigregister(constellation_soft_decoder_cf_sptr)

constellation_soft_decoder_cf_sptr.__repr__ = lambda self: "<gr_block %s (%d)>" % (self.name(), self.unique_id())
constellation_soft_decoder_cf = constellation_soft_decoder_cf.make;

class corr_est_cc_sptr(object):
    r"""Proxy of C++ boost::shared_ptr< gr::digital::corr_est_cc > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(corr_est_cc_sptr self) -> corr_est_cc_sptr
        __init__(corr_est_cc_sptr self, corr_est_cc p) -> corr_est_cc_sptr
        """
        _digital_swig0.corr_est_cc_sptr_swiginit(self, _digital_swig0.new_corr_est_cc_sptr(*args))

    def __deref__(self) -> "gr::digital::corr_est_cc *":
        r"""__deref__(corr_est_cc_sptr self) -> corr_est_cc"""
        return _digital_swig0.corr_est_cc_sptr___deref__(self)
    __swig_destroy__ = _digital_swig0.delete_corr_est_cc_sptr

    def make(self, *args, **kwargs) -> "gr::digital::corr_est_cc::sptr":
        r"""
        make(corr_est_cc_sptr self, pmt_vector_cfloat symbols, float sps, unsigned int mark_delay, float threshold=0.9, gr::digital::tm_type threshold_method=THRESHOLD_ABSOLUTE) -> corr_est_cc_sptr


        Constructor Specific Documentation:

        Make a block that correlates against the  vector and outputs a phase and symbol timing estimate.

        Args:
            symbols : Set of symbols to correlate against (e.g., a sync word).
            sps : Samples per symbol
            mark_delay : tag marking delay in samples after the corr_start tag
            threshold : Threshold of correlator, relative to a 100% correlation (1.0). Default is 0.9.
            threshold_method : Method for computing threshold.
        """
        return _digital_swig0.corr_est_cc_sptr_make(self, *args, **kwargs)

    def symbols(self) -> "std::vector< gr_complex,std::allocator< gr_complex > >":
        r"""symbols(corr_est_cc_sptr self) -> pmt_vector_cfloat"""
        return _digital_swig0.corr_est_cc_sptr_symbols(self)

    def set_symbols(self, symbols: "pmt_vector_cfloat") -> "void":
        r"""set_symbols(corr_est_cc_sptr self, pmt_vector_cfloat symbols)"""
        return _digital_swig0.corr_est_cc_sptr_set_symbols(self, symbols)

    def mark_delay(self) -> "unsigned int":
        r"""mark_delay(corr_est_cc_sptr self) -> unsigned int"""
        return _digital_swig0.corr_est_cc_sptr_mark_delay(self)

    def set_mark_delay(self, mark_delay: "unsigned int") -> "void":
        r"""set_mark_delay(corr_est_cc_sptr self, unsigned int mark_delay)"""
        return _digital_swig0.corr_est_cc_sptr_set_mark_delay(self, mark_delay)

    def threshold(self) -> "float":
        r"""threshold(corr_est_cc_sptr self) -> float"""
        return _digital_swig0.corr_est_cc_sptr_threshold(self)

    def set_threshold(self, threshold: "float") -> "void":
        r"""set_threshold(corr_est_cc_sptr self, float threshold)"""
        return _digital_swig0.corr_est_cc_sptr_set_threshold(self, threshold)

    def history(self) -> "unsigned int":
        r"""history(corr_est_cc_sptr self) -> unsigned int"""
        return _digital_swig0.corr_est_cc_sptr_history(self)

    def declare_sample_delay(self, *args) -> "void":
        r"""
        declare_sample_delay(corr_est_cc_sptr self, int which, int delay)
        declare_sample_delay(corr_est_cc_sptr self, unsigned int delay)
        """
        return _digital_swig0.corr_est_cc_sptr_declare_sample_delay(self, *args)

    def sample_delay(self, which: "int") -> "unsigned int":
        r"""sample_delay(corr_est_cc_sptr self, int which) -> unsigned int"""
        return _digital_swig0.corr_est_cc_sptr_sample_delay(self, which)

    def set_output_multiple(self, multiple: "int") -> "void":
        r"""set_output_multiple(corr_est_cc_sptr self, int multiple)"""
        return _digital_swig0.corr_est_cc_sptr_set_output_multiple(self, multiple)

    def output_multiple(self) -> "int":
        r"""output_multiple(corr_est_cc_sptr self) -> int"""
        return _digital_swig0.corr_est_cc_sptr_output_multiple(self)

    def relative_rate(self) -> "double":
        r"""relative_rate(corr_est_cc_sptr self) -> double"""
        return _digital_swig0.corr_est_cc_sptr_relative_rate(self)

    def relative_rate_i(self) -> "uint64_t":
        r"""relative_rate_i(corr_est_cc_sptr self) -> uint64_t"""
        return _digital_swig0.corr_est_cc_sptr_relative_rate_i(self)

    def relative_rate_d(self) -> "uint64_t":
        r"""relative_rate_d(corr_est_cc_sptr self) -> uint64_t"""
        return _digital_swig0.corr_est_cc_sptr_relative_rate_d(self)

    def start(self) -> "bool":
        r"""start(corr_est_cc_sptr self) -> bool"""
        return _digital_swig0.corr_est_cc_sptr_start(self)

    def stop(self) -> "bool":
        r"""stop(corr_est_cc_sptr self) -> bool"""
        return _digital_swig0.corr_est_cc_sptr_stop(self)

    def nitems_read(self, which_input: "unsigned int") -> "uint64_t":
        r"""nitems_read(corr_est_cc_sptr self, unsigned int which_input) -> uint64_t"""
        return _digital_swig0.corr_est_cc_sptr_nitems_read(self, which_input)

    def nitems_written(self, which_output: "unsigned int") -> "uint64_t":
        r"""nitems_written(corr_est_cc_sptr self, unsigned int which_output) -> uint64_t"""
        return _digital_swig0.corr_est_cc_sptr_nitems_written(self, which_output)

    def set_log_level(self, level: "std::string") -> "void":
        r"""set_log_level(corr_est_cc_sptr self, std::string level)"""
        return _digital_swig0.corr_est_cc_sptr_set_log_level(self, level)

    def log_level(self) -> "std::string":
        r"""log_level(corr_est_cc_sptr self) -> std::string"""
        return _digital_swig0.corr_est_cc_sptr_log_level(self)

    def max_noutput_items(self) -> "int":
        r"""max_noutput_items(corr_est_cc_sptr self) -> int"""
        return _digital_swig0.corr_est_cc_sptr_max_noutput_items(self)

    def set_max_noutput_items(self, m: "int") -> "void":
        r"""set_max_noutput_items(corr_est_cc_sptr self, int m)"""
        return _digital_swig0.corr_est_cc_sptr_set_max_noutput_items(self, m)

    def unset_max_noutput_items(self) -> "void":
        r"""unset_max_noutput_items(corr_est_cc_sptr self)"""
        return _digital_swig0.corr_est_cc_sptr_unset_max_noutput_items(self)

    def is_set_max_noutput_items(self) -> "bool":
        r"""is_set_max_noutput_items(corr_est_cc_sptr self) -> bool"""
        return _digital_swig0.corr_est_cc_sptr_is_set_max_noutput_items(self)

    def set_min_noutput_items(self, m: "int") -> "void":
        r"""set_min_noutput_items(corr_est_cc_sptr self, int m)"""
        return _digital_swig0.corr_est_cc_sptr_set_min_noutput_items(self, m)

    def min_noutput_items(self) -> "int":
        r"""min_noutput_items(corr_est_cc_sptr self) -> int"""
        return _digital_swig0.corr_est_cc_sptr_min_noutput_items(self)

    def max_output_buffer(self, i: "int") -> "long":
        r"""max_output_buffer(corr_est_cc_sptr self, int i) -> long"""
        return _digital_swig0.corr_est_cc_sptr_max_output_buffer(self, i)

    def set_max_output_buffer(self, *args) -> "void":
        r"""
        set_max_output_buffer(corr_est_cc_sptr self, long max_output_buffer)
        set_max_output_buffer(corr_est_cc_sptr self, int port, long max_output_buffer)
        """
        return _digital_swig0.corr_est_cc_sptr_set_max_output_buffer(self, *args)

    def min_output_buffer(self, i: "int") -> "long":
        r"""min_output_buffer(corr_est_cc_sptr self, int i) -> long"""
        return _digital_swig0.corr_est_cc_sptr_min_output_buffer(self, i)

    def set_min_output_buffer(self, *args) -> "void":
        r"""
        set_min_output_buffer(corr_est_cc_sptr self, long min_output_buffer)
        set_min_output_buffer(corr_est_cc_sptr self, int port, long min_output_buffer)
        """
        return _digital_swig0.corr_est_cc_sptr_set_min_output_buffer(self, *args)

    def pc_noutput_items(self) -> "float":
        r"""pc_noutput_items(corr_est_cc_sptr self) -> float"""
        return _digital_swig0.corr_est_cc_sptr_pc_noutput_items(self)

    def pc_noutput_items_avg(self) -> "float":
        r"""pc_noutput_items_avg(corr_est_cc_sptr self) -> float"""
        return _digital_swig0.corr_est_cc_sptr_pc_noutput_items_avg(self)

    def pc_noutput_items_var(self) -> "float":
        r"""pc_noutput_items_var(corr_est_cc_sptr self) -> float"""
        return _digital_swig0.corr_est_cc_sptr_pc_noutput_items_var(self)

    def pc_nproduced(self) -> "float":
        r"""pc_nproduced(corr_est_cc_sptr self) -> float"""
        return _digital_swig0.corr_est_cc_sptr_pc_nproduced(self)

    def pc_nproduced_avg(self) -> "float":
        r"""pc_nproduced_avg(corr_est_cc_sptr self) -> float"""
        return _digital_swig0.corr_est_cc_sptr_pc_nproduced_avg(self)

    def pc_nproduced_var(self) -> "float":
        r"""pc_nproduced_var(corr_est_cc_sptr self) -> float"""
        return _digital_swig0.corr_est_cc_sptr_pc_nproduced_var(self)

    def pc_input_buffers_full(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full(corr_est_cc_sptr self, int which) -> float
        pc_input_buffers_full(corr_est_cc_sptr self) -> pmt_vector_float
        """
        return _digital_swig0.corr_est_cc_sptr_pc_input_buffers_full(self, *args)

    def pc_input_buffers_full_avg(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full_avg(corr_est_cc_sptr self, int which) -> float
        pc_input_buffers_full_avg(corr_est_cc_sptr self) -> pmt_vector_float
        """
        return _digital_swig0.corr_est_cc_sptr_pc_input_buffers_full_avg(self, *args)

    def pc_input_buffers_full_var(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full_var(corr_est_cc_sptr self, int which) -> float
        pc_input_buffers_full_var(corr_est_cc_sptr self) -> pmt_vector_float
        """
        return _digital_swig0.corr_est_cc_sptr_pc_input_buffers_full_var(self, *args)

    def pc_output_buffers_full(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full(corr_est_cc_sptr self, int which) -> float
        pc_output_buffers_full(corr_est_cc_sptr self) -> pmt_vector_float
        """
        return _digital_swig0.corr_est_cc_sptr_pc_output_buffers_full(self, *args)

    def pc_output_buffers_full_avg(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full_avg(corr_est_cc_sptr self, int which) -> float
        pc_output_buffers_full_avg(corr_est_cc_sptr self) -> pmt_vector_float
        """
        return _digital_swig0.corr_est_cc_sptr_pc_output_buffers_full_avg(self, *args)

    def pc_output_buffers_full_var(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full_var(corr_est_cc_sptr self, int which) -> float
        pc_output_buffers_full_var(corr_est_cc_sptr self) -> pmt_vector_float
        """
        return _digital_swig0.corr_est_cc_sptr_pc_output_buffers_full_var(self, *args)

    def pc_work_time(self) -> "float":
        r"""pc_work_time(corr_est_cc_sptr self) -> float"""
        return _digital_swig0.corr_est_cc_sptr_pc_work_time(self)

    def pc_work_time_avg(self) -> "float":
        r"""pc_work_time_avg(corr_est_cc_sptr self) -> float"""
        return _digital_swig0.corr_est_cc_sptr_pc_work_time_avg(self)

    def pc_work_time_var(self) -> "float":
        r"""pc_work_time_var(corr_est_cc_sptr self) -> float"""
        return _digital_swig0.corr_est_cc_sptr_pc_work_time_var(self)

    def pc_work_time_total(self) -> "float":
        r"""pc_work_time_total(corr_est_cc_sptr self) -> float"""
        return _digital_swig0.corr_est_cc_sptr_pc_work_time_total(self)

    def pc_throughput_avg(self) -> "float":
        r"""pc_throughput_avg(corr_est_cc_sptr self) -> float"""
        return _digital_swig0.corr_est_cc_sptr_pc_throughput_avg(self)

    def set_processor_affinity(self, mask: "std::vector< int,std::allocator< int > > const &") -> "void":
        r"""set_processor_affinity(corr_est_cc_sptr self, std::vector< int,std::allocator< int > > const & mask)"""
        return _digital_swig0.corr_est_cc_sptr_set_processor_affinity(self, mask)

    def unset_processor_affinity(self) -> "void":
        r"""unset_processor_affinity(corr_est_cc_sptr self)"""
        return _digital_swig0.corr_est_cc_sptr_unset_processor_affinity(self)

    def processor_affinity(self) -> "std::vector< int,std::allocator< int > >":
        r"""processor_affinity(corr_est_cc_sptr self) -> std::vector< int,std::allocator< int > >"""
        return _digital_swig0.corr_est_cc_sptr_processor_affinity(self)

    def active_thread_priority(self) -> "int":
        r"""active_thread_priority(corr_est_cc_sptr self) -> int"""
        return _digital_swig0.corr_est_cc_sptr_active_thread_priority(self)

    def thread_priority(self) -> "int":
        r"""thread_priority(corr_est_cc_sptr self) -> int"""
        return _digital_swig0.corr_est_cc_sptr_thread_priority(self)

    def set_thread_priority(self, priority: "int") -> "int":
        r"""set_thread_priority(corr_est_cc_sptr self, int priority) -> int"""
        return _digital_swig0.corr_est_cc_sptr_set_thread_priority(self, priority)

    def name(self) -> "std::string":
        r"""name(corr_est_cc_sptr self) -> std::string"""
        return _digital_swig0.corr_est_cc_sptr_name(self)

    def symbol_name(self) -> "std::string":
        r"""symbol_name(corr_est_cc_sptr self) -> std::string"""
        return _digital_swig0.corr_est_cc_sptr_symbol_name(self)

    def input_signature(self) -> "gr::io_signature::sptr":
        r"""input_signature(corr_est_cc_sptr self) -> io_signature_sptr"""
        return _digital_swig0.corr_est_cc_sptr_input_signature(self)

    def output_signature(self) -> "gr::io_signature::sptr":
        r"""output_signature(corr_est_cc_sptr self) -> io_signature_sptr"""
        return _digital_swig0.corr_est_cc_sptr_output_signature(self)

    def unique_id(self) -> "long":
        r"""unique_id(corr_est_cc_sptr self) -> long"""
        return _digital_swig0.corr_est_cc_sptr_unique_id(self)

    def to_basic_block(self) -> "gr::basic_block_sptr":
        r"""to_basic_block(corr_est_cc_sptr self) -> basic_block_sptr"""
        return _digital_swig0.corr_est_cc_sptr_to_basic_block(self)

    def check_topology(self, ninputs: "int", noutputs: "int") -> "bool":
        r"""check_topology(corr_est_cc_sptr self, int ninputs, int noutputs) -> bool"""
        return _digital_swig0.corr_est_cc_sptr_check_topology(self, ninputs, noutputs)

    def alias(self) -> "std::string":
        r"""alias(corr_est_cc_sptr self) -> std::string"""
        return _digital_swig0.corr_est_cc_sptr_alias(self)

    def set_block_alias(self, name: "std::string") -> "void":
        r"""set_block_alias(corr_est_cc_sptr self, std::string name)"""
        return _digital_swig0.corr_est_cc_sptr_set_block_alias(self, name)

    def _post(self, which_port: "swig_pmt_ptr", msg: "swig_pmt_ptr") -> "void":
        r"""_post(corr_est_cc_sptr self, swig_pmt_ptr which_port, swig_pmt_ptr msg)"""
        return _digital_swig0.corr_est_cc_sptr__post(self, which_port, msg)

    def message_ports_in(self) -> "pmt::pmt_t":
        r"""message_ports_in(corr_est_cc_sptr self) -> swig_pmt_ptr"""
        return _digital_swig0.corr_est_cc_sptr_message_ports_in(self)

    def message_ports_out(self) -> "pmt::pmt_t":
        r"""message_ports_out(corr_est_cc_sptr self) -> swig_pmt_ptr"""
        return _digital_swig0.corr_est_cc_sptr_message_ports_out(self)

    def message_subscribers(self, which_port: "swig_pmt_ptr") -> "pmt::pmt_t":
        r"""message_subscribers(corr_est_cc_sptr self, swig_pmt_ptr which_port) -> swig_pmt_ptr"""
        return _digital_swig0.corr_est_cc_sptr_message_subscribers(self, which_port)

# Register corr_est_cc_sptr in _digital_swig0:
_digital_swig0.corr_est_cc_sptr_swigregister(corr_est_cc_sptr)

corr_est_cc_sptr.__repr__ = lambda self: "<gr_block %s (%d)>" % (self.name(), self.unique_id())
corr_est_cc = corr_est_cc.make;

class correlate_access_code_bb_sptr(object):
    r"""Proxy of C++ boost::shared_ptr< gr::digital::correlate_access_code_bb > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(correlate_access_code_bb_sptr self) -> correlate_access_code_bb_sptr
        __init__(correlate_access_code_bb_sptr self, correlate_access_code_bb p) -> correlate_access_code_bb_sptr
        """
        _digital_swig0.correlate_access_code_bb_sptr_swiginit(self, _digital_swig0.new_correlate_access_code_bb_sptr(*args))

    def __deref__(self) -> "gr::digital::correlate_access_code_bb *":
        r"""__deref__(correlate_access_code_bb_sptr self) -> correlate_access_code_bb"""
        return _digital_swig0.correlate_access_code_bb_sptr___deref__(self)
    __swig_destroy__ = _digital_swig0.delete_correlate_access_code_bb_sptr

    def make(self, access_code: "std::string const &", threshold: "int") -> "gr::digital::correlate_access_code_bb::sptr":
        r"""
        make(correlate_access_code_bb_sptr self, std::string const & access_code, int threshold) -> correlate_access_code_bb_sptr
        Examine input for specified access code, one bit at a time.

        input: stream of bits, 1 bit per input byte (data in LSB) output: stream of bits, 2 bits per output byte (data in LSB, flag in next higher bit)


        Each output byte contains two valid bits, the data bit, and the flag bit. The LSB (bit 0) is the data bit, and is the original input data, delayed 64 bits. Bit 1 is the flag bit and is 1 if the corresponding data bit is the first data bit following the access code. Otherwise the flag bit is 0.

        Constructor Specific Documentation:

        Make a correlate_access_code block.

        Args:
            access_code : is represented with 1 byte per bit, e.g., "010101010111000100"
            threshold : maximum number of bits that may be wrong
        """
        return _digital_swig0.correlate_access_code_bb_sptr_make(self, access_code, threshold)

    def set_access_code(self, access_code: "std::string const &") -> "bool":
        r"""
        set_access_code(correlate_access_code_bb_sptr self, std::string const & access_code) -> bool
        Set a new access code.
        """
        return _digital_swig0.correlate_access_code_bb_sptr_set_access_code(self, access_code)

    def history(self) -> "unsigned int":
        r"""history(correlate_access_code_bb_sptr self) -> unsigned int"""
        return _digital_swig0.correlate_access_code_bb_sptr_history(self)

    def declare_sample_delay(self, *args) -> "void":
        r"""
        declare_sample_delay(correlate_access_code_bb_sptr self, int which, int delay)
        declare_sample_delay(correlate_access_code_bb_sptr self, unsigned int delay)
        """
        return _digital_swig0.correlate_access_code_bb_sptr_declare_sample_delay(self, *args)

    def sample_delay(self, which: "int") -> "unsigned int":
        r"""sample_delay(correlate_access_code_bb_sptr self, int which) -> unsigned int"""
        return _digital_swig0.correlate_access_code_bb_sptr_sample_delay(self, which)

    def set_output_multiple(self, multiple: "int") -> "void":
        r"""set_output_multiple(correlate_access_code_bb_sptr self, int multiple)"""
        return _digital_swig0.correlate_access_code_bb_sptr_set_output_multiple(self, multiple)

    def output_multiple(self) -> "int":
        r"""output_multiple(correlate_access_code_bb_sptr self) -> int"""
        return _digital_swig0.correlate_access_code_bb_sptr_output_multiple(self)

    def relative_rate(self) -> "double":
        r"""relative_rate(correlate_access_code_bb_sptr self) -> double"""
        return _digital_swig0.correlate_access_code_bb_sptr_relative_rate(self)

    def relative_rate_i(self) -> "uint64_t":
        r"""relative_rate_i(correlate_access_code_bb_sptr self) -> uint64_t"""
        return _digital_swig0.correlate_access_code_bb_sptr_relative_rate_i(self)

    def relative_rate_d(self) -> "uint64_t":
        r"""relative_rate_d(correlate_access_code_bb_sptr self) -> uint64_t"""
        return _digital_swig0.correlate_access_code_bb_sptr_relative_rate_d(self)

    def start(self) -> "bool":
        r"""start(correlate_access_code_bb_sptr self) -> bool"""
        return _digital_swig0.correlate_access_code_bb_sptr_start(self)

    def stop(self) -> "bool":
        r"""stop(correlate_access_code_bb_sptr self) -> bool"""
        return _digital_swig0.correlate_access_code_bb_sptr_stop(self)

    def nitems_read(self, which_input: "unsigned int") -> "uint64_t":
        r"""nitems_read(correlate_access_code_bb_sptr self, unsigned int which_input) -> uint64_t"""
        return _digital_swig0.correlate_access_code_bb_sptr_nitems_read(self, which_input)

    def nitems_written(self, which_output: "unsigned int") -> "uint64_t":
        r"""nitems_written(correlate_access_code_bb_sptr self, unsigned int which_output) -> uint64_t"""
        return _digital_swig0.correlate_access_code_bb_sptr_nitems_written(self, which_output)

    def set_log_level(self, level: "std::string") -> "void":
        r"""set_log_level(correlate_access_code_bb_sptr self, std::string level)"""
        return _digital_swig0.correlate_access_code_bb_sptr_set_log_level(self, level)

    def log_level(self) -> "std::string":
        r"""log_level(correlate_access_code_bb_sptr self) -> std::string"""
        return _digital_swig0.correlate_access_code_bb_sptr_log_level(self)

    def max_noutput_items(self) -> "int":
        r"""max_noutput_items(correlate_access_code_bb_sptr self) -> int"""
        return _digital_swig0.correlate_access_code_bb_sptr_max_noutput_items(self)

    def set_max_noutput_items(self, m: "int") -> "void":
        r"""set_max_noutput_items(correlate_access_code_bb_sptr self, int m)"""
        return _digital_swig0.correlate_access_code_bb_sptr_set_max_noutput_items(self, m)

    def unset_max_noutput_items(self) -> "void":
        r"""unset_max_noutput_items(correlate_access_code_bb_sptr self)"""
        return _digital_swig0.correlate_access_code_bb_sptr_unset_max_noutput_items(self)

    def is_set_max_noutput_items(self) -> "bool":
        r"""is_set_max_noutput_items(correlate_access_code_bb_sptr self) -> bool"""
        return _digital_swig0.correlate_access_code_bb_sptr_is_set_max_noutput_items(self)

    def set_min_noutput_items(self, m: "int") -> "void":
        r"""set_min_noutput_items(correlate_access_code_bb_sptr self, int m)"""
        return _digital_swig0.correlate_access_code_bb_sptr_set_min_noutput_items(self, m)

    def min_noutput_items(self) -> "int":
        r"""min_noutput_items(correlate_access_code_bb_sptr self) -> int"""
        return _digital_swig0.correlate_access_code_bb_sptr_min_noutput_items(self)

    def max_output_buffer(self, i: "int") -> "long":
        r"""max_output_buffer(correlate_access_code_bb_sptr self, int i) -> long"""
        return _digital_swig0.correlate_access_code_bb_sptr_max_output_buffer(self, i)

    def set_max_output_buffer(self, *args) -> "void":
        r"""
        set_max_output_buffer(correlate_access_code_bb_sptr self, long max_output_buffer)
        set_max_output_buffer(correlate_access_code_bb_sptr self, int port, long max_output_buffer)
        """
        return _digital_swig0.correlate_access_code_bb_sptr_set_max_output_buffer(self, *args)

    def min_output_buffer(self, i: "int") -> "long":
        r"""min_output_buffer(correlate_access_code_bb_sptr self, int i) -> long"""
        return _digital_swig0.correlate_access_code_bb_sptr_min_output_buffer(self, i)

    def set_min_output_buffer(self, *args) -> "void":
        r"""
        set_min_output_buffer(correlate_access_code_bb_sptr self, long min_output_buffer)
        set_min_output_buffer(correlate_access_code_bb_sptr self, int port, long min_output_buffer)
        """
        return _digital_swig0.correlate_access_code_bb_sptr_set_min_output_buffer(self, *args)

    def pc_noutput_items(self) -> "float":
        r"""pc_noutput_items(correlate_access_code_bb_sptr self) -> float"""
        return _digital_swig0.correlate_access_code_bb_sptr_pc_noutput_items(self)

    def pc_noutput_items_avg(self) -> "float":
        r"""pc_noutput_items_avg(correlate_access_code_bb_sptr self) -> float"""
        return _digital_swig0.correlate_access_code_bb_sptr_pc_noutput_items_avg(self)

    def pc_noutput_items_var(self) -> "float":
        r"""pc_noutput_items_var(correlate_access_code_bb_sptr self) -> float"""
        return _digital_swig0.correlate_access_code_bb_sptr_pc_noutput_items_var(self)

    def pc_nproduced(self) -> "float":
        r"""pc_nproduced(correlate_access_code_bb_sptr self) -> float"""
        return _digital_swig0.correlate_access_code_bb_sptr_pc_nproduced(self)

    def pc_nproduced_avg(self) -> "float":
        r"""pc_nproduced_avg(correlate_access_code_bb_sptr self) -> float"""
        return _digital_swig0.correlate_access_code_bb_sptr_pc_nproduced_avg(self)

    def pc_nproduced_var(self) -> "float":
        r"""pc_nproduced_var(correlate_access_code_bb_sptr self) -> float"""
        return _digital_swig0.correlate_access_code_bb_sptr_pc_nproduced_var(self)

    def pc_input_buffers_full(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full(correlate_access_code_bb_sptr self, int which) -> float
        pc_input_buffers_full(correlate_access_code_bb_sptr self) -> pmt_vector_float
        """
        return _digital_swig0.correlate_access_code_bb_sptr_pc_input_buffers_full(self, *args)

    def pc_input_buffers_full_avg(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full_avg(correlate_access_code_bb_sptr self, int which) -> float
        pc_input_buffers_full_avg(correlate_access_code_bb_sptr self) -> pmt_vector_float
        """
        return _digital_swig0.correlate_access_code_bb_sptr_pc_input_buffers_full_avg(self, *args)

    def pc_input_buffers_full_var(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full_var(correlate_access_code_bb_sptr self, int which) -> float
        pc_input_buffers_full_var(correlate_access_code_bb_sptr self) -> pmt_vector_float
        """
        return _digital_swig0.correlate_access_code_bb_sptr_pc_input_buffers_full_var(self, *args)

    def pc_output_buffers_full(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full(correlate_access_code_bb_sptr self, int which) -> float
        pc_output_buffers_full(correlate_access_code_bb_sptr self) -> pmt_vector_float
        """
        return _digital_swig0.correlate_access_code_bb_sptr_pc_output_buffers_full(self, *args)

    def pc_output_buffers_full_avg(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full_avg(correlate_access_code_bb_sptr self, int which) -> float
        pc_output_buffers_full_avg(correlate_access_code_bb_sptr self) -> pmt_vector_float
        """
        return _digital_swig0.correlate_access_code_bb_sptr_pc_output_buffers_full_avg(self, *args)

    def pc_output_buffers_full_var(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full_var(correlate_access_code_bb_sptr self, int which) -> float
        pc_output_buffers_full_var(correlate_access_code_bb_sptr self) -> pmt_vector_float
        """
        return _digital_swig0.correlate_access_code_bb_sptr_pc_output_buffers_full_var(self, *args)

    def pc_work_time(self) -> "float":
        r"""pc_work_time(correlate_access_code_bb_sptr self) -> float"""
        return _digital_swig0.correlate_access_code_bb_sptr_pc_work_time(self)

    def pc_work_time_avg(self) -> "float":
        r"""pc_work_time_avg(correlate_access_code_bb_sptr self) -> float"""
        return _digital_swig0.correlate_access_code_bb_sptr_pc_work_time_avg(self)

    def pc_work_time_var(self) -> "float":
        r"""pc_work_time_var(correlate_access_code_bb_sptr self) -> float"""
        return _digital_swig0.correlate_access_code_bb_sptr_pc_work_time_var(self)

    def pc_work_time_total(self) -> "float":
        r"""pc_work_time_total(correlate_access_code_bb_sptr self) -> float"""
        return _digital_swig0.correlate_access_code_bb_sptr_pc_work_time_total(self)

    def pc_throughput_avg(self) -> "float":
        r"""pc_throughput_avg(correlate_access_code_bb_sptr self) -> float"""
        return _digital_swig0.correlate_access_code_bb_sptr_pc_throughput_avg(self)

    def set_processor_affinity(self, mask: "std::vector< int,std::allocator< int > > const &") -> "void":
        r"""set_processor_affinity(correlate_access_code_bb_sptr self, std::vector< int,std::allocator< int > > const & mask)"""
        return _digital_swig0.correlate_access_code_bb_sptr_set_processor_affinity(self, mask)

    def unset_processor_affinity(self) -> "void":
        r"""unset_processor_affinity(correlate_access_code_bb_sptr self)"""
        return _digital_swig0.correlate_access_code_bb_sptr_unset_processor_affinity(self)

    def processor_affinity(self) -> "std::vector< int,std::allocator< int > >":
        r"""processor_affinity(correlate_access_code_bb_sptr self) -> std::vector< int,std::allocator< int > >"""
        return _digital_swig0.correlate_access_code_bb_sptr_processor_affinity(self)

    def active_thread_priority(self) -> "int":
        r"""active_thread_priority(correlate_access_code_bb_sptr self) -> int"""
        return _digital_swig0.correlate_access_code_bb_sptr_active_thread_priority(self)

    def thread_priority(self) -> "int":
        r"""thread_priority(correlate_access_code_bb_sptr self) -> int"""
        return _digital_swig0.correlate_access_code_bb_sptr_thread_priority(self)

    def set_thread_priority(self, priority: "int") -> "int":
        r"""set_thread_priority(correlate_access_code_bb_sptr self, int priority) -> int"""
        return _digital_swig0.correlate_access_code_bb_sptr_set_thread_priority(self, priority)

    def name(self) -> "std::string":
        r"""name(correlate_access_code_bb_sptr self) -> std::string"""
        return _digital_swig0.correlate_access_code_bb_sptr_name(self)

    def symbol_name(self) -> "std::string":
        r"""symbol_name(correlate_access_code_bb_sptr self) -> std::string"""
        return _digital_swig0.correlate_access_code_bb_sptr_symbol_name(self)

    def input_signature(self) -> "gr::io_signature::sptr":
        r"""input_signature(correlate_access_code_bb_sptr self) -> io_signature_sptr"""
        return _digital_swig0.correlate_access_code_bb_sptr_input_signature(self)

    def output_signature(self) -> "gr::io_signature::sptr":
        r"""output_signature(correlate_access_code_bb_sptr self) -> io_signature_sptr"""
        return _digital_swig0.correlate_access_code_bb_sptr_output_signature(self)

    def unique_id(self) -> "long":
        r"""unique_id(correlate_access_code_bb_sptr self) -> long"""
        return _digital_swig0.correlate_access_code_bb_sptr_unique_id(self)

    def to_basic_block(self) -> "gr::basic_block_sptr":
        r"""to_basic_block(correlate_access_code_bb_sptr self) -> basic_block_sptr"""
        return _digital_swig0.correlate_access_code_bb_sptr_to_basic_block(self)

    def check_topology(self, ninputs: "int", noutputs: "int") -> "bool":
        r"""check_topology(correlate_access_code_bb_sptr self, int ninputs, int noutputs) -> bool"""
        return _digital_swig0.correlate_access_code_bb_sptr_check_topology(self, ninputs, noutputs)

    def alias(self) -> "std::string":
        r"""alias(correlate_access_code_bb_sptr self) -> std::string"""
        return _digital_swig0.correlate_access_code_bb_sptr_alias(self)

    def set_block_alias(self, name: "std::string") -> "void":
        r"""set_block_alias(correlate_access_code_bb_sptr self, std::string name)"""
        return _digital_swig0.correlate_access_code_bb_sptr_set_block_alias(self, name)

    def _post(self, which_port: "swig_pmt_ptr", msg: "swig_pmt_ptr") -> "void":
        r"""_post(correlate_access_code_bb_sptr self, swig_pmt_ptr which_port, swig_pmt_ptr msg)"""
        return _digital_swig0.correlate_access_code_bb_sptr__post(self, which_port, msg)

    def message_ports_in(self) -> "pmt::pmt_t":
        r"""message_ports_in(correlate_access_code_bb_sptr self) -> swig_pmt_ptr"""
        return _digital_swig0.correlate_access_code_bb_sptr_message_ports_in(self)

    def message_ports_out(self) -> "pmt::pmt_t":
        r"""message_ports_out(correlate_access_code_bb_sptr self) -> swig_pmt_ptr"""
        return _digital_swig0.correlate_access_code_bb_sptr_message_ports_out(self)

    def message_subscribers(self, which_port: "swig_pmt_ptr") -> "pmt::pmt_t":
        r"""message_subscribers(correlate_access_code_bb_sptr self, swig_pmt_ptr which_port) -> swig_pmt_ptr"""
        return _digital_swig0.correlate_access_code_bb_sptr_message_subscribers(self, which_port)

# Register correlate_access_code_bb_sptr in _digital_swig0:
_digital_swig0.correlate_access_code_bb_sptr_swigregister(correlate_access_code_bb_sptr)

correlate_access_code_bb_sptr.__repr__ = lambda self: "<gr_block %s (%d)>" % (self.name(), self.unique_id())
correlate_access_code_bb = correlate_access_code_bb.make;

class correlate_access_code_tag_bb_sptr(object):
    r"""Proxy of C++ boost::shared_ptr< gr::digital::correlate_access_code_tag_bb > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(correlate_access_code_tag_bb_sptr self) -> correlate_access_code_tag_bb_sptr
        __init__(correlate_access_code_tag_bb_sptr self, correlate_access_code_tag_bb p) -> correlate_access_code_tag_bb_sptr
        """
        _digital_swig0.correlate_access_code_tag_bb_sptr_swiginit(self, _digital_swig0.new_correlate_access_code_tag_bb_sptr(*args))

    def __deref__(self) -> "gr::digital::correlate_access_code_tag_bb *":
        r"""__deref__(correlate_access_code_tag_bb_sptr self) -> correlate_access_code_tag_bb"""
        return _digital_swig0.correlate_access_code_tag_bb_sptr___deref__(self)
    __swig_destroy__ = _digital_swig0.delete_correlate_access_code_tag_bb_sptr

    def make(self, access_code: "std::string const &", threshold: "int", tag_name: "std::string const &") -> "gr::digital::correlate_access_code_tag_bb::sptr":
        r"""
        make(correlate_access_code_tag_bb_sptr self, std::string const & access_code, int threshold, std::string const & tag_name) -> correlate_access_code_tag_bb_sptr
        Examine input for specified access code, one bit at a time.

        input: stream of bits, 1 bit per input byte (data in LSB) output: unaltered stream of bits (plus tags)


        This block annotates the input stream with tags. The tags have key name [tag_name], specified in the constructor. Used for searching an input data stream for preambles, etc.

        Constructor Specific Documentation:



        Args:
            access_code : is represented with 1 byte per bit, e.g., "010101010111000100"
            threshold : maximum number of bits that may be wrong
            tag_name : key of the tag inserted into the tag stream
        """
        return _digital_swig0.correlate_access_code_tag_bb_sptr_make(self, access_code, threshold, tag_name)

    def set_access_code(self, access_code: "std::string const &") -> "bool":
        r"""set_access_code(correlate_access_code_tag_bb_sptr self, std::string const & access_code) -> bool"""
        return _digital_swig0.correlate_access_code_tag_bb_sptr_set_access_code(self, access_code)

    def set_threshold(self, threshold: "int") -> "void":
        r"""set_threshold(correlate_access_code_tag_bb_sptr self, int threshold)"""
        return _digital_swig0.correlate_access_code_tag_bb_sptr_set_threshold(self, threshold)

    def set_tagname(self, tagname: "std::string const &") -> "void":
        r"""set_tagname(correlate_access_code_tag_bb_sptr self, std::string const & tagname)"""
        return _digital_swig0.correlate_access_code_tag_bb_sptr_set_tagname(self, tagname)

    def history(self) -> "unsigned int":
        r"""history(correlate_access_code_tag_bb_sptr self) -> unsigned int"""
        return _digital_swig0.correlate_access_code_tag_bb_sptr_history(self)

    def declare_sample_delay(self, *args) -> "void":
        r"""
        declare_sample_delay(correlate_access_code_tag_bb_sptr self, int which, int delay)
        declare_sample_delay(correlate_access_code_tag_bb_sptr self, unsigned int delay)
        """
        return _digital_swig0.correlate_access_code_tag_bb_sptr_declare_sample_delay(self, *args)

    def sample_delay(self, which: "int") -> "unsigned int":
        r"""sample_delay(correlate_access_code_tag_bb_sptr self, int which) -> unsigned int"""
        return _digital_swig0.correlate_access_code_tag_bb_sptr_sample_delay(self, which)

    def set_output_multiple(self, multiple: "int") -> "void":
        r"""set_output_multiple(correlate_access_code_tag_bb_sptr self, int multiple)"""
        return _digital_swig0.correlate_access_code_tag_bb_sptr_set_output_multiple(self, multiple)

    def output_multiple(self) -> "int":
        r"""output_multiple(correlate_access_code_tag_bb_sptr self) -> int"""
        return _digital_swig0.correlate_access_code_tag_bb_sptr_output_multiple(self)

    def relative_rate(self) -> "double":
        r"""relative_rate(correlate_access_code_tag_bb_sptr self) -> double"""
        return _digital_swig0.correlate_access_code_tag_bb_sptr_relative_rate(self)

    def relative_rate_i(self) -> "uint64_t":
        r"""relative_rate_i(correlate_access_code_tag_bb_sptr self) -> uint64_t"""
        return _digital_swig0.correlate_access_code_tag_bb_sptr_relative_rate_i(self)

    def relative_rate_d(self) -> "uint64_t":
        r"""relative_rate_d(correlate_access_code_tag_bb_sptr self) -> uint64_t"""
        return _digital_swig0.correlate_access_code_tag_bb_sptr_relative_rate_d(self)

    def start(self) -> "bool":
        r"""start(correlate_access_code_tag_bb_sptr self) -> bool"""
        return _digital_swig0.correlate_access_code_tag_bb_sptr_start(self)

    def stop(self) -> "bool":
        r"""stop(correlate_access_code_tag_bb_sptr self) -> bool"""
        return _digital_swig0.correlate_access_code_tag_bb_sptr_stop(self)

    def nitems_read(self, which_input: "unsigned int") -> "uint64_t":
        r"""nitems_read(correlate_access_code_tag_bb_sptr self, unsigned int which_input) -> uint64_t"""
        return _digital_swig0.correlate_access_code_tag_bb_sptr_nitems_read(self, which_input)

    def nitems_written(self, which_output: "unsigned int") -> "uint64_t":
        r"""nitems_written(correlate_access_code_tag_bb_sptr self, unsigned int which_output) -> uint64_t"""
        return _digital_swig0.correlate_access_code_tag_bb_sptr_nitems_written(self, which_output)

    def set_log_level(self, level: "std::string") -> "void":
        r"""set_log_level(correlate_access_code_tag_bb_sptr self, std::string level)"""
        return _digital_swig0.correlate_access_code_tag_bb_sptr_set_log_level(self, level)

    def log_level(self) -> "std::string":
        r"""log_level(correlate_access_code_tag_bb_sptr self) -> std::string"""
        return _digital_swig0.correlate_access_code_tag_bb_sptr_log_level(self)

    def max_noutput_items(self) -> "int":
        r"""max_noutput_items(correlate_access_code_tag_bb_sptr self) -> int"""
        return _digital_swig0.correlate_access_code_tag_bb_sptr_max_noutput_items(self)

    def set_max_noutput_items(self, m: "int") -> "void":
        r"""set_max_noutput_items(correlate_access_code_tag_bb_sptr self, int m)"""
        return _digital_swig0.correlate_access_code_tag_bb_sptr_set_max_noutput_items(self, m)

    def unset_max_noutput_items(self) -> "void":
        r"""unset_max_noutput_items(correlate_access_code_tag_bb_sptr self)"""
        return _digital_swig0.correlate_access_code_tag_bb_sptr_unset_max_noutput_items(self)

    def is_set_max_noutput_items(self) -> "bool":
        r"""is_set_max_noutput_items(correlate_access_code_tag_bb_sptr self) -> bool"""
        return _digital_swig0.correlate_access_code_tag_bb_sptr_is_set_max_noutput_items(self)

    def set_min_noutput_items(self, m: "int") -> "void":
        r"""set_min_noutput_items(correlate_access_code_tag_bb_sptr self, int m)"""
        return _digital_swig0.correlate_access_code_tag_bb_sptr_set_min_noutput_items(self, m)

    def min_noutput_items(self) -> "int":
        r"""min_noutput_items(correlate_access_code_tag_bb_sptr self) -> int"""
        return _digital_swig0.correlate_access_code_tag_bb_sptr_min_noutput_items(self)

    def max_output_buffer(self, i: "int") -> "long":
        r"""max_output_buffer(correlate_access_code_tag_bb_sptr self, int i) -> long"""
        return _digital_swig0.correlate_access_code_tag_bb_sptr_max_output_buffer(self, i)

    def set_max_output_buffer(self, *args) -> "void":
        r"""
        set_max_output_buffer(correlate_access_code_tag_bb_sptr self, long max_output_buffer)
        set_max_output_buffer(correlate_access_code_tag_bb_sptr self, int port, long max_output_buffer)
        """
        return _digital_swig0.correlate_access_code_tag_bb_sptr_set_max_output_buffer(self, *args)

    def min_output_buffer(self, i: "int") -> "long":
        r"""min_output_buffer(correlate_access_code_tag_bb_sptr self, int i) -> long"""
        return _digital_swig0.correlate_access_code_tag_bb_sptr_min_output_buffer(self, i)

    def set_min_output_buffer(self, *args) -> "void":
        r"""
        set_min_output_buffer(correlate_access_code_tag_bb_sptr self, long min_output_buffer)
        set_min_output_buffer(correlate_access_code_tag_bb_sptr self, int port, long min_output_buffer)
        """
        return _digital_swig0.correlate_access_code_tag_bb_sptr_set_min_output_buffer(self, *args)

    def pc_noutput_items(self) -> "float":
        r"""pc_noutput_items(correlate_access_code_tag_bb_sptr self) -> float"""
        return _digital_swig0.correlate_access_code_tag_bb_sptr_pc_noutput_items(self)

    def pc_noutput_items_avg(self) -> "float":
        r"""pc_noutput_items_avg(correlate_access_code_tag_bb_sptr self) -> float"""
        return _digital_swig0.correlate_access_code_tag_bb_sptr_pc_noutput_items_avg(self)

    def pc_noutput_items_var(self) -> "float":
        r"""pc_noutput_items_var(correlate_access_code_tag_bb_sptr self) -> float"""
        return _digital_swig0.correlate_access_code_tag_bb_sptr_pc_noutput_items_var(self)

    def pc_nproduced(self) -> "float":
        r"""pc_nproduced(correlate_access_code_tag_bb_sptr self) -> float"""
        return _digital_swig0.correlate_access_code_tag_bb_sptr_pc_nproduced(self)

    def pc_nproduced_avg(self) -> "float":
        r"""pc_nproduced_avg(correlate_access_code_tag_bb_sptr self) -> float"""
        return _digital_swig0.correlate_access_code_tag_bb_sptr_pc_nproduced_avg(self)

    def pc_nproduced_var(self) -> "float":
        r"""pc_nproduced_var(correlate_access_code_tag_bb_sptr self) -> float"""
        return _digital_swig0.correlate_access_code_tag_bb_sptr_pc_nproduced_var(self)

    def pc_input_buffers_full(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full(correlate_access_code_tag_bb_sptr self, int which) -> float
        pc_input_buffers_full(correlate_access_code_tag_bb_sptr self) -> pmt_vector_float
        """
        return _digital_swig0.correlate_access_code_tag_bb_sptr_pc_input_buffers_full(self, *args)

    def pc_input_buffers_full_avg(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full_avg(correlate_access_code_tag_bb_sptr self, int which) -> float
        pc_input_buffers_full_avg(correlate_access_code_tag_bb_sptr self) -> pmt_vector_float
        """
        return _digital_swig0.correlate_access_code_tag_bb_sptr_pc_input_buffers_full_avg(self, *args)

    def pc_input_buffers_full_var(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full_var(correlate_access_code_tag_bb_sptr self, int which) -> float
        pc_input_buffers_full_var(correlate_access_code_tag_bb_sptr self) -> pmt_vector_float
        """
        return _digital_swig0.correlate_access_code_tag_bb_sptr_pc_input_buffers_full_var(self, *args)

    def pc_output_buffers_full(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full(correlate_access_code_tag_bb_sptr self, int which) -> float
        pc_output_buffers_full(correlate_access_code_tag_bb_sptr self) -> pmt_vector_float
        """
        return _digital_swig0.correlate_access_code_tag_bb_sptr_pc_output_buffers_full(self, *args)

    def pc_output_buffers_full_avg(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full_avg(correlate_access_code_tag_bb_sptr self, int which) -> float
        pc_output_buffers_full_avg(correlate_access_code_tag_bb_sptr self) -> pmt_vector_float
        """
        return _digital_swig0.correlate_access_code_tag_bb_sptr_pc_output_buffers_full_avg(self, *args)

    def pc_output_buffers_full_var(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full_var(correlate_access_code_tag_bb_sptr self, int which) -> float
        pc_output_buffers_full_var(correlate_access_code_tag_bb_sptr self) -> pmt_vector_float
        """
        return _digital_swig0.correlate_access_code_tag_bb_sptr_pc_output_buffers_full_var(self, *args)

    def pc_work_time(self) -> "float":
        r"""pc_work_time(correlate_access_code_tag_bb_sptr self) -> float"""
        return _digital_swig0.correlate_access_code_tag_bb_sptr_pc_work_time(self)

    def pc_work_time_avg(self) -> "float":
        r"""pc_work_time_avg(correlate_access_code_tag_bb_sptr self) -> float"""
        return _digital_swig0.correlate_access_code_tag_bb_sptr_pc_work_time_avg(self)

    def pc_work_time_var(self) -> "float":
        r"""pc_work_time_var(correlate_access_code_tag_bb_sptr self) -> float"""
        return _digital_swig0.correlate_access_code_tag_bb_sptr_pc_work_time_var(self)

    def pc_work_time_total(self) -> "float":
        r"""pc_work_time_total(correlate_access_code_tag_bb_sptr self) -> float"""
        return _digital_swig0.correlate_access_code_tag_bb_sptr_pc_work_time_total(self)

    def pc_throughput_avg(self) -> "float":
        r"""pc_throughput_avg(correlate_access_code_tag_bb_sptr self) -> float"""
        return _digital_swig0.correlate_access_code_tag_bb_sptr_pc_throughput_avg(self)

    def set_processor_affinity(self, mask: "std::vector< int,std::allocator< int > > const &") -> "void":
        r"""set_processor_affinity(correlate_access_code_tag_bb_sptr self, std::vector< int,std::allocator< int > > const & mask)"""
        return _digital_swig0.correlate_access_code_tag_bb_sptr_set_processor_affinity(self, mask)

    def unset_processor_affinity(self) -> "void":
        r"""unset_processor_affinity(correlate_access_code_tag_bb_sptr self)"""
        return _digital_swig0.correlate_access_code_tag_bb_sptr_unset_processor_affinity(self)

    def processor_affinity(self) -> "std::vector< int,std::allocator< int > >":
        r"""processor_affinity(correlate_access_code_tag_bb_sptr self) -> std::vector< int,std::allocator< int > >"""
        return _digital_swig0.correlate_access_code_tag_bb_sptr_processor_affinity(self)

    def active_thread_priority(self) -> "int":
        r"""active_thread_priority(correlate_access_code_tag_bb_sptr self) -> int"""
        return _digital_swig0.correlate_access_code_tag_bb_sptr_active_thread_priority(self)

    def thread_priority(self) -> "int":
        r"""thread_priority(correlate_access_code_tag_bb_sptr self) -> int"""
        return _digital_swig0.correlate_access_code_tag_bb_sptr_thread_priority(self)

    def set_thread_priority(self, priority: "int") -> "int":
        r"""set_thread_priority(correlate_access_code_tag_bb_sptr self, int priority) -> int"""
        return _digital_swig0.correlate_access_code_tag_bb_sptr_set_thread_priority(self, priority)

    def name(self) -> "std::string":
        r"""name(correlate_access_code_tag_bb_sptr self) -> std::string"""
        return _digital_swig0.correlate_access_code_tag_bb_sptr_name(self)

    def symbol_name(self) -> "std::string":
        r"""symbol_name(correlate_access_code_tag_bb_sptr self) -> std::string"""
        return _digital_swig0.correlate_access_code_tag_bb_sptr_symbol_name(self)

    def input_signature(self) -> "gr::io_signature::sptr":
        r"""input_signature(correlate_access_code_tag_bb_sptr self) -> io_signature_sptr"""
        return _digital_swig0.correlate_access_code_tag_bb_sptr_input_signature(self)

    def output_signature(self) -> "gr::io_signature::sptr":
        r"""output_signature(correlate_access_code_tag_bb_sptr self) -> io_signature_sptr"""
        return _digital_swig0.correlate_access_code_tag_bb_sptr_output_signature(self)

    def unique_id(self) -> "long":
        r"""unique_id(correlate_access_code_tag_bb_sptr self) -> long"""
        return _digital_swig0.correlate_access_code_tag_bb_sptr_unique_id(self)

    def to_basic_block(self) -> "gr::basic_block_sptr":
        r"""to_basic_block(correlate_access_code_tag_bb_sptr self) -> basic_block_sptr"""
        return _digital_swig0.correlate_access_code_tag_bb_sptr_to_basic_block(self)

    def check_topology(self, ninputs: "int", noutputs: "int") -> "bool":
        r"""check_topology(correlate_access_code_tag_bb_sptr self, int ninputs, int noutputs) -> bool"""
        return _digital_swig0.correlate_access_code_tag_bb_sptr_check_topology(self, ninputs, noutputs)

    def alias(self) -> "std::string":
        r"""alias(correlate_access_code_tag_bb_sptr self) -> std::string"""
        return _digital_swig0.correlate_access_code_tag_bb_sptr_alias(self)

    def set_block_alias(self, name: "std::string") -> "void":
        r"""set_block_alias(correlate_access_code_tag_bb_sptr self, std::string name)"""
        return _digital_swig0.correlate_access_code_tag_bb_sptr_set_block_alias(self, name)

    def _post(self, which_port: "swig_pmt_ptr", msg: "swig_pmt_ptr") -> "void":
        r"""_post(correlate_access_code_tag_bb_sptr self, swig_pmt_ptr which_port, swig_pmt_ptr msg)"""
        return _digital_swig0.correlate_access_code_tag_bb_sptr__post(self, which_port, msg)

    def message_ports_in(self) -> "pmt::pmt_t":
        r"""message_ports_in(correlate_access_code_tag_bb_sptr self) -> swig_pmt_ptr"""
        return _digital_swig0.correlate_access_code_tag_bb_sptr_message_ports_in(self)

    def message_ports_out(self) -> "pmt::pmt_t":
        r"""message_ports_out(correlate_access_code_tag_bb_sptr self) -> swig_pmt_ptr"""
        return _digital_swig0.correlate_access_code_tag_bb_sptr_message_ports_out(self)

    def message_subscribers(self, which_port: "swig_pmt_ptr") -> "pmt::pmt_t":
        r"""message_subscribers(correlate_access_code_tag_bb_sptr self, swig_pmt_ptr which_port) -> swig_pmt_ptr"""
        return _digital_swig0.correlate_access_code_tag_bb_sptr_message_subscribers(self, which_port)

# Register correlate_access_code_tag_bb_sptr in _digital_swig0:
_digital_swig0.correlate_access_code_tag_bb_sptr_swigregister(correlate_access_code_tag_bb_sptr)

correlate_access_code_tag_bb_sptr.__repr__ = lambda self: "<gr_block %s (%d)>" % (self.name(), self.unique_id())
correlate_access_code_tag_bb = correlate_access_code_tag_bb.make;

class correlate_access_code_tag_ff_sptr(object):
    r"""Proxy of C++ boost::shared_ptr< gr::digital::correlate_access_code_tag_ff > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(correlate_access_code_tag_ff_sptr self) -> correlate_access_code_tag_ff_sptr
        __init__(correlate_access_code_tag_ff_sptr self, correlate_access_code_tag_ff p) -> correlate_access_code_tag_ff_sptr
        """
        _digital_swig0.correlate_access_code_tag_ff_sptr_swiginit(self, _digital_swig0.new_correlate_access_code_tag_ff_sptr(*args))

    def __deref__(self) -> "gr::digital::correlate_access_code_tag_ff *":
        r"""__deref__(correlate_access_code_tag_ff_sptr self) -> correlate_access_code_tag_ff"""
        return _digital_swig0.correlate_access_code_tag_ff_sptr___deref__(self)
    __swig_destroy__ = _digital_swig0.delete_correlate_access_code_tag_ff_sptr

    def make(self, access_code: "std::string const &", threshold: "int", tag_name: "std::string const &") -> "gr::digital::correlate_access_code_tag_ff::sptr":
        r"""
        make(correlate_access_code_tag_ff_sptr self, std::string const & access_code, int threshold, std::string const & tag_name) -> correlate_access_code_tag_ff_sptr
        Examine input for specified access code, one bit at a time.

        input: stream of floats (generally, soft decisions) output: unaltered stream of bits (plus tags)


        This block annotates the input stream with tags. The tags have key name [tag_name], specified in the constructor. Used for searching an input data stream for preambles, etc., by slicing the soft decision symbol inputs.

        Constructor Specific Documentation:



        Args:
            access_code : is represented with 1 byte per bit, e.g., "010101010111000100"
            threshold : maximum number of bits that may be wrong
            tag_name : key of the tag inserted into the tag stream
        """
        return _digital_swig0.correlate_access_code_tag_ff_sptr_make(self, access_code, threshold, tag_name)

    def set_access_code(self, access_code: "std::string const &") -> "bool":
        r"""set_access_code(correlate_access_code_tag_ff_sptr self, std::string const & access_code) -> bool"""
        return _digital_swig0.correlate_access_code_tag_ff_sptr_set_access_code(self, access_code)

    def set_threshold(self, threshold: "int") -> "void":
        r"""set_threshold(correlate_access_code_tag_ff_sptr self, int threshold)"""
        return _digital_swig0.correlate_access_code_tag_ff_sptr_set_threshold(self, threshold)

    def set_tagname(self, tagname: "std::string const &") -> "void":
        r"""set_tagname(correlate_access_code_tag_ff_sptr self, std::string const & tagname)"""
        return _digital_swig0.correlate_access_code_tag_ff_sptr_set_tagname(self, tagname)

    def history(self) -> "unsigned int":
        r"""history(correlate_access_code_tag_ff_sptr self) -> unsigned int"""
        return _digital_swig0.correlate_access_code_tag_ff_sptr_history(self)

    def declare_sample_delay(self, *args) -> "void":
        r"""
        declare_sample_delay(correlate_access_code_tag_ff_sptr self, int which, int delay)
        declare_sample_delay(correlate_access_code_tag_ff_sptr self, unsigned int delay)
        """
        return _digital_swig0.correlate_access_code_tag_ff_sptr_declare_sample_delay(self, *args)

    def sample_delay(self, which: "int") -> "unsigned int":
        r"""sample_delay(correlate_access_code_tag_ff_sptr self, int which) -> unsigned int"""
        return _digital_swig0.correlate_access_code_tag_ff_sptr_sample_delay(self, which)

    def set_output_multiple(self, multiple: "int") -> "void":
        r"""set_output_multiple(correlate_access_code_tag_ff_sptr self, int multiple)"""
        return _digital_swig0.correlate_access_code_tag_ff_sptr_set_output_multiple(self, multiple)

    def output_multiple(self) -> "int":
        r"""output_multiple(correlate_access_code_tag_ff_sptr self) -> int"""
        return _digital_swig0.correlate_access_code_tag_ff_sptr_output_multiple(self)

    def relative_rate(self) -> "double":
        r"""relative_rate(correlate_access_code_tag_ff_sptr self) -> double"""
        return _digital_swig0.correlate_access_code_tag_ff_sptr_relative_rate(self)

    def relative_rate_i(self) -> "uint64_t":
        r"""relative_rate_i(correlate_access_code_tag_ff_sptr self) -> uint64_t"""
        return _digital_swig0.correlate_access_code_tag_ff_sptr_relative_rate_i(self)

    def relative_rate_d(self) -> "uint64_t":
        r"""relative_rate_d(correlate_access_code_tag_ff_sptr self) -> uint64_t"""
        return _digital_swig0.correlate_access_code_tag_ff_sptr_relative_rate_d(self)

    def start(self) -> "bool":
        r"""start(correlate_access_code_tag_ff_sptr self) -> bool"""
        return _digital_swig0.correlate_access_code_tag_ff_sptr_start(self)

    def stop(self) -> "bool":
        r"""stop(correlate_access_code_tag_ff_sptr self) -> bool"""
        return _digital_swig0.correlate_access_code_tag_ff_sptr_stop(self)

    def nitems_read(self, which_input: "unsigned int") -> "uint64_t":
        r"""nitems_read(correlate_access_code_tag_ff_sptr self, unsigned int which_input) -> uint64_t"""
        return _digital_swig0.correlate_access_code_tag_ff_sptr_nitems_read(self, which_input)

    def nitems_written(self, which_output: "unsigned int") -> "uint64_t":
        r"""nitems_written(correlate_access_code_tag_ff_sptr self, unsigned int which_output) -> uint64_t"""
        return _digital_swig0.correlate_access_code_tag_ff_sptr_nitems_written(self, which_output)

    def set_log_level(self, level: "std::string") -> "void":
        r"""set_log_level(correlate_access_code_tag_ff_sptr self, std::string level)"""
        return _digital_swig0.correlate_access_code_tag_ff_sptr_set_log_level(self, level)

    def log_level(self) -> "std::string":
        r"""log_level(correlate_access_code_tag_ff_sptr self) -> std::string"""
        return _digital_swig0.correlate_access_code_tag_ff_sptr_log_level(self)

    def max_noutput_items(self) -> "int":
        r"""max_noutput_items(correlate_access_code_tag_ff_sptr self) -> int"""
        return _digital_swig0.correlate_access_code_tag_ff_sptr_max_noutput_items(self)

    def set_max_noutput_items(self, m: "int") -> "void":
        r"""set_max_noutput_items(correlate_access_code_tag_ff_sptr self, int m)"""
        return _digital_swig0.correlate_access_code_tag_ff_sptr_set_max_noutput_items(self, m)

    def unset_max_noutput_items(self) -> "void":
        r"""unset_max_noutput_items(correlate_access_code_tag_ff_sptr self)"""
        return _digital_swig0.correlate_access_code_tag_ff_sptr_unset_max_noutput_items(self)

    def is_set_max_noutput_items(self) -> "bool":
        r"""is_set_max_noutput_items(correlate_access_code_tag_ff_sptr self) -> bool"""
        return _digital_swig0.correlate_access_code_tag_ff_sptr_is_set_max_noutput_items(self)

    def set_min_noutput_items(self, m: "int") -> "void":
        r"""set_min_noutput_items(correlate_access_code_tag_ff_sptr self, int m)"""
        return _digital_swig0.correlate_access_code_tag_ff_sptr_set_min_noutput_items(self, m)

    def min_noutput_items(self) -> "int":
        r"""min_noutput_items(correlate_access_code_tag_ff_sptr self) -> int"""
        return _digital_swig0.correlate_access_code_tag_ff_sptr_min_noutput_items(self)

    def max_output_buffer(self, i: "int") -> "long":
        r"""max_output_buffer(correlate_access_code_tag_ff_sptr self, int i) -> long"""
        return _digital_swig0.correlate_access_code_tag_ff_sptr_max_output_buffer(self, i)

    def set_max_output_buffer(self, *args) -> "void":
        r"""
        set_max_output_buffer(correlate_access_code_tag_ff_sptr self, long max_output_buffer)
        set_max_output_buffer(correlate_access_code_tag_ff_sptr self, int port, long max_output_buffer)
        """
        return _digital_swig0.correlate_access_code_tag_ff_sptr_set_max_output_buffer(self, *args)

    def min_output_buffer(self, i: "int") -> "long":
        r"""min_output_buffer(correlate_access_code_tag_ff_sptr self, int i) -> long"""
        return _digital_swig0.correlate_access_code_tag_ff_sptr_min_output_buffer(self, i)

    def set_min_output_buffer(self, *args) -> "void":
        r"""
        set_min_output_buffer(correlate_access_code_tag_ff_sptr self, long min_output_buffer)
        set_min_output_buffer(correlate_access_code_tag_ff_sptr self, int port, long min_output_buffer)
        """
        return _digital_swig0.correlate_access_code_tag_ff_sptr_set_min_output_buffer(self, *args)

    def pc_noutput_items(self) -> "float":
        r"""pc_noutput_items(correlate_access_code_tag_ff_sptr self) -> float"""
        return _digital_swig0.correlate_access_code_tag_ff_sptr_pc_noutput_items(self)

    def pc_noutput_items_avg(self) -> "float":
        r"""pc_noutput_items_avg(correlate_access_code_tag_ff_sptr self) -> float"""
        return _digital_swig0.correlate_access_code_tag_ff_sptr_pc_noutput_items_avg(self)

    def pc_noutput_items_var(self) -> "float":
        r"""pc_noutput_items_var(correlate_access_code_tag_ff_sptr self) -> float"""
        return _digital_swig0.correlate_access_code_tag_ff_sptr_pc_noutput_items_var(self)

    def pc_nproduced(self) -> "float":
        r"""pc_nproduced(correlate_access_code_tag_ff_sptr self) -> float"""
        return _digital_swig0.correlate_access_code_tag_ff_sptr_pc_nproduced(self)

    def pc_nproduced_avg(self) -> "float":
        r"""pc_nproduced_avg(correlate_access_code_tag_ff_sptr self) -> float"""
        return _digital_swig0.correlate_access_code_tag_ff_sptr_pc_nproduced_avg(self)

    def pc_nproduced_var(self) -> "float":
        r"""pc_nproduced_var(correlate_access_code_tag_ff_sptr self) -> float"""
        return _digital_swig0.correlate_access_code_tag_ff_sptr_pc_nproduced_var(self)

    def pc_input_buffers_full(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full(correlate_access_code_tag_ff_sptr self, int which) -> float
        pc_input_buffers_full(correlate_access_code_tag_ff_sptr self) -> pmt_vector_float
        """
        return _digital_swig0.correlate_access_code_tag_ff_sptr_pc_input_buffers_full(self, *args)

    def pc_input_buffers_full_avg(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full_avg(correlate_access_code_tag_ff_sptr self, int which) -> float
        pc_input_buffers_full_avg(correlate_access_code_tag_ff_sptr self) -> pmt_vector_float
        """
        return _digital_swig0.correlate_access_code_tag_ff_sptr_pc_input_buffers_full_avg(self, *args)

    def pc_input_buffers_full_var(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full_var(correlate_access_code_tag_ff_sptr self, int which) -> float
        pc_input_buffers_full_var(correlate_access_code_tag_ff_sptr self) -> pmt_vector_float
        """
        return _digital_swig0.correlate_access_code_tag_ff_sptr_pc_input_buffers_full_var(self, *args)

    def pc_output_buffers_full(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full(correlate_access_code_tag_ff_sptr self, int which) -> float
        pc_output_buffers_full(correlate_access_code_tag_ff_sptr self) -> pmt_vector_float
        """
        return _digital_swig0.correlate_access_code_tag_ff_sptr_pc_output_buffers_full(self, *args)

    def pc_output_buffers_full_avg(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full_avg(correlate_access_code_tag_ff_sptr self, int which) -> float
        pc_output_buffers_full_avg(correlate_access_code_tag_ff_sptr self) -> pmt_vector_float
        """
        return _digital_swig0.correlate_access_code_tag_ff_sptr_pc_output_buffers_full_avg(self, *args)

    def pc_output_buffers_full_var(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full_var(correlate_access_code_tag_ff_sptr self, int which) -> float
        pc_output_buffers_full_var(correlate_access_code_tag_ff_sptr self) -> pmt_vector_float
        """
        return _digital_swig0.correlate_access_code_tag_ff_sptr_pc_output_buffers_full_var(self, *args)

    def pc_work_time(self) -> "float":
        r"""pc_work_time(correlate_access_code_tag_ff_sptr self) -> float"""
        return _digital_swig0.correlate_access_code_tag_ff_sptr_pc_work_time(self)

    def pc_work_time_avg(self) -> "float":
        r"""pc_work_time_avg(correlate_access_code_tag_ff_sptr self) -> float"""
        return _digital_swig0.correlate_access_code_tag_ff_sptr_pc_work_time_avg(self)

    def pc_work_time_var(self) -> "float":
        r"""pc_work_time_var(correlate_access_code_tag_ff_sptr self) -> float"""
        return _digital_swig0.correlate_access_code_tag_ff_sptr_pc_work_time_var(self)

    def pc_work_time_total(self) -> "float":
        r"""pc_work_time_total(correlate_access_code_tag_ff_sptr self) -> float"""
        return _digital_swig0.correlate_access_code_tag_ff_sptr_pc_work_time_total(self)

    def pc_throughput_avg(self) -> "float":
        r"""pc_throughput_avg(correlate_access_code_tag_ff_sptr self) -> float"""
        return _digital_swig0.correlate_access_code_tag_ff_sptr_pc_throughput_avg(self)

    def set_processor_affinity(self, mask: "std::vector< int,std::allocator< int > > const &") -> "void":
        r"""set_processor_affinity(correlate_access_code_tag_ff_sptr self, std::vector< int,std::allocator< int > > const & mask)"""
        return _digital_swig0.correlate_access_code_tag_ff_sptr_set_processor_affinity(self, mask)

    def unset_processor_affinity(self) -> "void":
        r"""unset_processor_affinity(correlate_access_code_tag_ff_sptr self)"""
        return _digital_swig0.correlate_access_code_tag_ff_sptr_unset_processor_affinity(self)

    def processor_affinity(self) -> "std::vector< int,std::allocator< int > >":
        r"""processor_affinity(correlate_access_code_tag_ff_sptr self) -> std::vector< int,std::allocator< int > >"""
        return _digital_swig0.correlate_access_code_tag_ff_sptr_processor_affinity(self)

    def active_thread_priority(self) -> "int":
        r"""active_thread_priority(correlate_access_code_tag_ff_sptr self) -> int"""
        return _digital_swig0.correlate_access_code_tag_ff_sptr_active_thread_priority(self)

    def thread_priority(self) -> "int":
        r"""thread_priority(correlate_access_code_tag_ff_sptr self) -> int"""
        return _digital_swig0.correlate_access_code_tag_ff_sptr_thread_priority(self)

    def set_thread_priority(self, priority: "int") -> "int":
        r"""set_thread_priority(correlate_access_code_tag_ff_sptr self, int priority) -> int"""
        return _digital_swig0.correlate_access_code_tag_ff_sptr_set_thread_priority(self, priority)

    def name(self) -> "std::string":
        r"""name(correlate_access_code_tag_ff_sptr self) -> std::string"""
        return _digital_swig0.correlate_access_code_tag_ff_sptr_name(self)

    def symbol_name(self) -> "std::string":
        r"""symbol_name(correlate_access_code_tag_ff_sptr self) -> std::string"""
        return _digital_swig0.correlate_access_code_tag_ff_sptr_symbol_name(self)

    def input_signature(self) -> "gr::io_signature::sptr":
        r"""input_signature(correlate_access_code_tag_ff_sptr self) -> io_signature_sptr"""
        return _digital_swig0.correlate_access_code_tag_ff_sptr_input_signature(self)

    def output_signature(self) -> "gr::io_signature::sptr":
        r"""output_signature(correlate_access_code_tag_ff_sptr self) -> io_signature_sptr"""
        return _digital_swig0.correlate_access_code_tag_ff_sptr_output_signature(self)

    def unique_id(self) -> "long":
        r"""unique_id(correlate_access_code_tag_ff_sptr self) -> long"""
        return _digital_swig0.correlate_access_code_tag_ff_sptr_unique_id(self)

    def to_basic_block(self) -> "gr::basic_block_sptr":
        r"""to_basic_block(correlate_access_code_tag_ff_sptr self) -> basic_block_sptr"""
        return _digital_swig0.correlate_access_code_tag_ff_sptr_to_basic_block(self)

    def check_topology(self, ninputs: "int", noutputs: "int") -> "bool":
        r"""check_topology(correlate_access_code_tag_ff_sptr self, int ninputs, int noutputs) -> bool"""
        return _digital_swig0.correlate_access_code_tag_ff_sptr_check_topology(self, ninputs, noutputs)

    def alias(self) -> "std::string":
        r"""alias(correlate_access_code_tag_ff_sptr self) -> std::string"""
        return _digital_swig0.correlate_access_code_tag_ff_sptr_alias(self)

    def set_block_alias(self, name: "std::string") -> "void":
        r"""set_block_alias(correlate_access_code_tag_ff_sptr self, std::string name)"""
        return _digital_swig0.correlate_access_code_tag_ff_sptr_set_block_alias(self, name)

    def _post(self, which_port: "swig_pmt_ptr", msg: "swig_pmt_ptr") -> "void":
        r"""_post(correlate_access_code_tag_ff_sptr self, swig_pmt_ptr which_port, swig_pmt_ptr msg)"""
        return _digital_swig0.correlate_access_code_tag_ff_sptr__post(self, which_port, msg)

    def message_ports_in(self) -> "pmt::pmt_t":
        r"""message_ports_in(correlate_access_code_tag_ff_sptr self) -> swig_pmt_ptr"""
        return _digital_swig0.correlate_access_code_tag_ff_sptr_message_ports_in(self)

    def message_ports_out(self) -> "pmt::pmt_t":
        r"""message_ports_out(correlate_access_code_tag_ff_sptr self) -> swig_pmt_ptr"""
        return _digital_swig0.correlate_access_code_tag_ff_sptr_message_ports_out(self)

    def message_subscribers(self, which_port: "swig_pmt_ptr") -> "pmt::pmt_t":
        r"""message_subscribers(correlate_access_code_tag_ff_sptr self, swig_pmt_ptr which_port) -> swig_pmt_ptr"""
        return _digital_swig0.correlate_access_code_tag_ff_sptr_message_subscribers(self, which_port)

# Register correlate_access_code_tag_ff_sptr in _digital_swig0:
_digital_swig0.correlate_access_code_tag_ff_sptr_swigregister(correlate_access_code_tag_ff_sptr)

correlate_access_code_tag_ff_sptr.__repr__ = lambda self: "<gr_block %s (%d)>" % (self.name(), self.unique_id())
correlate_access_code_tag_ff = correlate_access_code_tag_ff.make;

class correlate_access_code_bb_ts_sptr(object):
    r"""Proxy of C++ boost::shared_ptr< gr::digital::correlate_access_code_bb_ts > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(correlate_access_code_bb_ts_sptr self) -> correlate_access_code_bb_ts_sptr
        __init__(correlate_access_code_bb_ts_sptr self, correlate_access_code_bb_ts p) -> correlate_access_code_bb_ts_sptr
        """
        _digital_swig0.correlate_access_code_bb_ts_sptr_swiginit(self, _digital_swig0.new_correlate_access_code_bb_ts_sptr(*args))

    def __deref__(self) -> "gr::digital::correlate_access_code_bb_ts *":
        r"""__deref__(correlate_access_code_bb_ts_sptr self) -> correlate_access_code_bb_ts"""
        return _digital_swig0.correlate_access_code_bb_ts_sptr___deref__(self)
    __swig_destroy__ = _digital_swig0.delete_correlate_access_code_bb_ts_sptr

    def make(self, access_code: "std::string const &", threshold: "int", tag_name: "std::string const &") -> "gr::digital::correlate_access_code_bb_ts::sptr":
        r"""
        make(correlate_access_code_bb_ts_sptr self, std::string const & access_code, int threshold, std::string const & tag_name) -> correlate_access_code_bb_ts_sptr
        Examine input for specified access code, one bit at a time.

        input: stream of bits (unpacked bytes) output: a tagged stream set of bits from the payload following the access code and header.


        This block searches for the given access code by reading in the input bits. Once found, it expects the following 32 samples to contain a header that includes the frame length (16 bits for the length, repeated). It decodes the header to get the frame length in order to set up the the tagged stream key information.


        The output of this block is appropriate for use with tagged stream blocks.

        Constructor Specific Documentation:



        Args:
            access_code : is represented with 1 byte per bit, e.g., "010101010111000100"
            threshold : maximum number of bits that may be wrong
            tag_name : key of the tag inserted into the tag stream
        """
        return _digital_swig0.correlate_access_code_bb_ts_sptr_make(self, access_code, threshold, tag_name)

    def set_access_code(self, access_code: "std::string const &") -> "bool":
        r"""set_access_code(correlate_access_code_bb_ts_sptr self, std::string const & access_code) -> bool"""
        return _digital_swig0.correlate_access_code_bb_ts_sptr_set_access_code(self, access_code)

    def access_code(self) -> "unsigned long long":
        r"""access_code(correlate_access_code_bb_ts_sptr self) -> unsigned long long"""
        return _digital_swig0.correlate_access_code_bb_ts_sptr_access_code(self)

    def history(self) -> "unsigned int":
        r"""history(correlate_access_code_bb_ts_sptr self) -> unsigned int"""
        return _digital_swig0.correlate_access_code_bb_ts_sptr_history(self)

    def declare_sample_delay(self, *args) -> "void":
        r"""
        declare_sample_delay(correlate_access_code_bb_ts_sptr self, int which, int delay)
        declare_sample_delay(correlate_access_code_bb_ts_sptr self, unsigned int delay)
        """
        return _digital_swig0.correlate_access_code_bb_ts_sptr_declare_sample_delay(self, *args)

    def sample_delay(self, which: "int") -> "unsigned int":
        r"""sample_delay(correlate_access_code_bb_ts_sptr self, int which) -> unsigned int"""
        return _digital_swig0.correlate_access_code_bb_ts_sptr_sample_delay(self, which)

    def set_output_multiple(self, multiple: "int") -> "void":
        r"""set_output_multiple(correlate_access_code_bb_ts_sptr self, int multiple)"""
        return _digital_swig0.correlate_access_code_bb_ts_sptr_set_output_multiple(self, multiple)

    def output_multiple(self) -> "int":
        r"""output_multiple(correlate_access_code_bb_ts_sptr self) -> int"""
        return _digital_swig0.correlate_access_code_bb_ts_sptr_output_multiple(self)

    def relative_rate(self) -> "double":
        r"""relative_rate(correlate_access_code_bb_ts_sptr self) -> double"""
        return _digital_swig0.correlate_access_code_bb_ts_sptr_relative_rate(self)

    def relative_rate_i(self) -> "uint64_t":
        r"""relative_rate_i(correlate_access_code_bb_ts_sptr self) -> uint64_t"""
        return _digital_swig0.correlate_access_code_bb_ts_sptr_relative_rate_i(self)

    def relative_rate_d(self) -> "uint64_t":
        r"""relative_rate_d(correlate_access_code_bb_ts_sptr self) -> uint64_t"""
        return _digital_swig0.correlate_access_code_bb_ts_sptr_relative_rate_d(self)

    def start(self) -> "bool":
        r"""start(correlate_access_code_bb_ts_sptr self) -> bool"""
        return _digital_swig0.correlate_access_code_bb_ts_sptr_start(self)

    def stop(self) -> "bool":
        r"""stop(correlate_access_code_bb_ts_sptr self) -> bool"""
        return _digital_swig0.correlate_access_code_bb_ts_sptr_stop(self)

    def nitems_read(self, which_input: "unsigned int") -> "uint64_t":
        r"""nitems_read(correlate_access_code_bb_ts_sptr self, unsigned int which_input) -> uint64_t"""
        return _digital_swig0.correlate_access_code_bb_ts_sptr_nitems_read(self, which_input)

    def nitems_written(self, which_output: "unsigned int") -> "uint64_t":
        r"""nitems_written(correlate_access_code_bb_ts_sptr self, unsigned int which_output) -> uint64_t"""
        return _digital_swig0.correlate_access_code_bb_ts_sptr_nitems_written(self, which_output)

    def set_log_level(self, level: "std::string") -> "void":
        r"""set_log_level(correlate_access_code_bb_ts_sptr self, std::string level)"""
        return _digital_swig0.correlate_access_code_bb_ts_sptr_set_log_level(self, level)

    def log_level(self) -> "std::string":
        r"""log_level(correlate_access_code_bb_ts_sptr self) -> std::string"""
        return _digital_swig0.correlate_access_code_bb_ts_sptr_log_level(self)

    def max_noutput_items(self) -> "int":
        r"""max_noutput_items(correlate_access_code_bb_ts_sptr self) -> int"""
        return _digital_swig0.correlate_access_code_bb_ts_sptr_max_noutput_items(self)

    def set_max_noutput_items(self, m: "int") -> "void":
        r"""set_max_noutput_items(correlate_access_code_bb_ts_sptr self, int m)"""
        return _digital_swig0.correlate_access_code_bb_ts_sptr_set_max_noutput_items(self, m)

    def unset_max_noutput_items(self) -> "void":
        r"""unset_max_noutput_items(correlate_access_code_bb_ts_sptr self)"""
        return _digital_swig0.correlate_access_code_bb_ts_sptr_unset_max_noutput_items(self)

    def is_set_max_noutput_items(self) -> "bool":
        r"""is_set_max_noutput_items(correlate_access_code_bb_ts_sptr self) -> bool"""
        return _digital_swig0.correlate_access_code_bb_ts_sptr_is_set_max_noutput_items(self)

    def set_min_noutput_items(self, m: "int") -> "void":
        r"""set_min_noutput_items(correlate_access_code_bb_ts_sptr self, int m)"""
        return _digital_swig0.correlate_access_code_bb_ts_sptr_set_min_noutput_items(self, m)

    def min_noutput_items(self) -> "int":
        r"""min_noutput_items(correlate_access_code_bb_ts_sptr self) -> int"""
        return _digital_swig0.correlate_access_code_bb_ts_sptr_min_noutput_items(self)

    def max_output_buffer(self, i: "int") -> "long":
        r"""max_output_buffer(correlate_access_code_bb_ts_sptr self, int i) -> long"""
        return _digital_swig0.correlate_access_code_bb_ts_sptr_max_output_buffer(self, i)

    def set_max_output_buffer(self, *args) -> "void":
        r"""
        set_max_output_buffer(correlate_access_code_bb_ts_sptr self, long max_output_buffer)
        set_max_output_buffer(correlate_access_code_bb_ts_sptr self, int port, long max_output_buffer)
        """
        return _digital_swig0.correlate_access_code_bb_ts_sptr_set_max_output_buffer(self, *args)

    def min_output_buffer(self, i: "int") -> "long":
        r"""min_output_buffer(correlate_access_code_bb_ts_sptr self, int i) -> long"""
        return _digital_swig0.correlate_access_code_bb_ts_sptr_min_output_buffer(self, i)

    def set_min_output_buffer(self, *args) -> "void":
        r"""
        set_min_output_buffer(correlate_access_code_bb_ts_sptr self, long min_output_buffer)
        set_min_output_buffer(correlate_access_code_bb_ts_sptr self, int port, long min_output_buffer)
        """
        return _digital_swig0.correlate_access_code_bb_ts_sptr_set_min_output_buffer(self, *args)

    def pc_noutput_items(self) -> "float":
        r"""pc_noutput_items(correlate_access_code_bb_ts_sptr self) -> float"""
        return _digital_swig0.correlate_access_code_bb_ts_sptr_pc_noutput_items(self)

    def pc_noutput_items_avg(self) -> "float":
        r"""pc_noutput_items_avg(correlate_access_code_bb_ts_sptr self) -> float"""
        return _digital_swig0.correlate_access_code_bb_ts_sptr_pc_noutput_items_avg(self)

    def pc_noutput_items_var(self) -> "float":
        r"""pc_noutput_items_var(correlate_access_code_bb_ts_sptr self) -> float"""
        return _digital_swig0.correlate_access_code_bb_ts_sptr_pc_noutput_items_var(self)

    def pc_nproduced(self) -> "float":
        r"""pc_nproduced(correlate_access_code_bb_ts_sptr self) -> float"""
        return _digital_swig0.correlate_access_code_bb_ts_sptr_pc_nproduced(self)

    def pc_nproduced_avg(self) -> "float":
        r"""pc_nproduced_avg(correlate_access_code_bb_ts_sptr self) -> float"""
        return _digital_swig0.correlate_access_code_bb_ts_sptr_pc_nproduced_avg(self)

    def pc_nproduced_var(self) -> "float":
        r"""pc_nproduced_var(correlate_access_code_bb_ts_sptr self) -> float"""
        return _digital_swig0.correlate_access_code_bb_ts_sptr_pc_nproduced_var(self)

    def pc_input_buffers_full(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full(correlate_access_code_bb_ts_sptr self, int which) -> float
        pc_input_buffers_full(correlate_access_code_bb_ts_sptr self) -> pmt_vector_float
        """
        return _digital_swig0.correlate_access_code_bb_ts_sptr_pc_input_buffers_full(self, *args)

    def pc_input_buffers_full_avg(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full_avg(correlate_access_code_bb_ts_sptr self, int which) -> float
        pc_input_buffers_full_avg(correlate_access_code_bb_ts_sptr self) -> pmt_vector_float
        """
        return _digital_swig0.correlate_access_code_bb_ts_sptr_pc_input_buffers_full_avg(self, *args)

    def pc_input_buffers_full_var(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full_var(correlate_access_code_bb_ts_sptr self, int which) -> float
        pc_input_buffers_full_var(correlate_access_code_bb_ts_sptr self) -> pmt_vector_float
        """
        return _digital_swig0.correlate_access_code_bb_ts_sptr_pc_input_buffers_full_var(self, *args)

    def pc_output_buffers_full(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full(correlate_access_code_bb_ts_sptr self, int which) -> float
        pc_output_buffers_full(correlate_access_code_bb_ts_sptr self) -> pmt_vector_float
        """
        return _digital_swig0.correlate_access_code_bb_ts_sptr_pc_output_buffers_full(self, *args)

    def pc_output_buffers_full_avg(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full_avg(correlate_access_code_bb_ts_sptr self, int which) -> float
        pc_output_buffers_full_avg(correlate_access_code_bb_ts_sptr self) -> pmt_vector_float
        """
        return _digital_swig0.correlate_access_code_bb_ts_sptr_pc_output_buffers_full_avg(self, *args)

    def pc_output_buffers_full_var(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full_var(correlate_access_code_bb_ts_sptr self, int which) -> float
        pc_output_buffers_full_var(correlate_access_code_bb_ts_sptr self) -> pmt_vector_float
        """
        return _digital_swig0.correlate_access_code_bb_ts_sptr_pc_output_buffers_full_var(self, *args)

    def pc_work_time(self) -> "float":
        r"""pc_work_time(correlate_access_code_bb_ts_sptr self) -> float"""
        return _digital_swig0.correlate_access_code_bb_ts_sptr_pc_work_time(self)

    def pc_work_time_avg(self) -> "float":
        r"""pc_work_time_avg(correlate_access_code_bb_ts_sptr self) -> float"""
        return _digital_swig0.correlate_access_code_bb_ts_sptr_pc_work_time_avg(self)

    def pc_work_time_var(self) -> "float":
        r"""pc_work_time_var(correlate_access_code_bb_ts_sptr self) -> float"""
        return _digital_swig0.correlate_access_code_bb_ts_sptr_pc_work_time_var(self)

    def pc_work_time_total(self) -> "float":
        r"""pc_work_time_total(correlate_access_code_bb_ts_sptr self) -> float"""
        return _digital_swig0.correlate_access_code_bb_ts_sptr_pc_work_time_total(self)

    def pc_throughput_avg(self) -> "float":
        r"""pc_throughput_avg(correlate_access_code_bb_ts_sptr self) -> float"""
        return _digital_swig0.correlate_access_code_bb_ts_sptr_pc_throughput_avg(self)

    def set_processor_affinity(self, mask: "std::vector< int,std::allocator< int > > const &") -> "void":
        r"""set_processor_affinity(correlate_access_code_bb_ts_sptr self, std::vector< int,std::allocator< int > > const & mask)"""
        return _digital_swig0.correlate_access_code_bb_ts_sptr_set_processor_affinity(self, mask)

    def unset_processor_affinity(self) -> "void":
        r"""unset_processor_affinity(correlate_access_code_bb_ts_sptr self)"""
        return _digital_swig0.correlate_access_code_bb_ts_sptr_unset_processor_affinity(self)

    def processor_affinity(self) -> "std::vector< int,std::allocator< int > >":
        r"""processor_affinity(correlate_access_code_bb_ts_sptr self) -> std::vector< int,std::allocator< int > >"""
        return _digital_swig0.correlate_access_code_bb_ts_sptr_processor_affinity(self)

    def active_thread_priority(self) -> "int":
        r"""active_thread_priority(correlate_access_code_bb_ts_sptr self) -> int"""
        return _digital_swig0.correlate_access_code_bb_ts_sptr_active_thread_priority(self)

    def thread_priority(self) -> "int":
        r"""thread_priority(correlate_access_code_bb_ts_sptr self) -> int"""
        return _digital_swig0.correlate_access_code_bb_ts_sptr_thread_priority(self)

    def set_thread_priority(self, priority: "int") -> "int":
        r"""set_thread_priority(correlate_access_code_bb_ts_sptr self, int priority) -> int"""
        return _digital_swig0.correlate_access_code_bb_ts_sptr_set_thread_priority(self, priority)

    def name(self) -> "std::string":
        r"""name(correlate_access_code_bb_ts_sptr self) -> std::string"""
        return _digital_swig0.correlate_access_code_bb_ts_sptr_name(self)

    def symbol_name(self) -> "std::string":
        r"""symbol_name(correlate_access_code_bb_ts_sptr self) -> std::string"""
        return _digital_swig0.correlate_access_code_bb_ts_sptr_symbol_name(self)

    def input_signature(self) -> "gr::io_signature::sptr":
        r"""input_signature(correlate_access_code_bb_ts_sptr self) -> io_signature_sptr"""
        return _digital_swig0.correlate_access_code_bb_ts_sptr_input_signature(self)

    def output_signature(self) -> "gr::io_signature::sptr":
        r"""output_signature(correlate_access_code_bb_ts_sptr self) -> io_signature_sptr"""
        return _digital_swig0.correlate_access_code_bb_ts_sptr_output_signature(self)

    def unique_id(self) -> "long":
        r"""unique_id(correlate_access_code_bb_ts_sptr self) -> long"""
        return _digital_swig0.correlate_access_code_bb_ts_sptr_unique_id(self)

    def to_basic_block(self) -> "gr::basic_block_sptr":
        r"""to_basic_block(correlate_access_code_bb_ts_sptr self) -> basic_block_sptr"""
        return _digital_swig0.correlate_access_code_bb_ts_sptr_to_basic_block(self)

    def check_topology(self, ninputs: "int", noutputs: "int") -> "bool":
        r"""check_topology(correlate_access_code_bb_ts_sptr self, int ninputs, int noutputs) -> bool"""
        return _digital_swig0.correlate_access_code_bb_ts_sptr_check_topology(self, ninputs, noutputs)

    def alias(self) -> "std::string":
        r"""alias(correlate_access_code_bb_ts_sptr self) -> std::string"""
        return _digital_swig0.correlate_access_code_bb_ts_sptr_alias(self)

    def set_block_alias(self, name: "std::string") -> "void":
        r"""set_block_alias(correlate_access_code_bb_ts_sptr self, std::string name)"""
        return _digital_swig0.correlate_access_code_bb_ts_sptr_set_block_alias(self, name)

    def _post(self, which_port: "swig_pmt_ptr", msg: "swig_pmt_ptr") -> "void":
        r"""_post(correlate_access_code_bb_ts_sptr self, swig_pmt_ptr which_port, swig_pmt_ptr msg)"""
        return _digital_swig0.correlate_access_code_bb_ts_sptr__post(self, which_port, msg)

    def message_ports_in(self) -> "pmt::pmt_t":
        r"""message_ports_in(correlate_access_code_bb_ts_sptr self) -> swig_pmt_ptr"""
        return _digital_swig0.correlate_access_code_bb_ts_sptr_message_ports_in(self)

    def message_ports_out(self) -> "pmt::pmt_t":
        r"""message_ports_out(correlate_access_code_bb_ts_sptr self) -> swig_pmt_ptr"""
        return _digital_swig0.correlate_access_code_bb_ts_sptr_message_ports_out(self)

    def message_subscribers(self, which_port: "swig_pmt_ptr") -> "pmt::pmt_t":
        r"""message_subscribers(correlate_access_code_bb_ts_sptr self, swig_pmt_ptr which_port) -> swig_pmt_ptr"""
        return _digital_swig0.correlate_access_code_bb_ts_sptr_message_subscribers(self, which_port)

# Register correlate_access_code_bb_ts_sptr in _digital_swig0:
_digital_swig0.correlate_access_code_bb_ts_sptr_swigregister(correlate_access_code_bb_ts_sptr)

correlate_access_code_bb_ts_sptr.__repr__ = lambda self: "<gr_block %s (%d)>" % (self.name(), self.unique_id())
correlate_access_code_bb_ts = correlate_access_code_bb_ts.make;

class correlate_access_code_ff_ts_sptr(object):
    r"""Proxy of C++ boost::shared_ptr< gr::digital::correlate_access_code_ff_ts > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(correlate_access_code_ff_ts_sptr self) -> correlate_access_code_ff_ts_sptr
        __init__(correlate_access_code_ff_ts_sptr self, correlate_access_code_ff_ts p) -> correlate_access_code_ff_ts_sptr
        """
        _digital_swig0.correlate_access_code_ff_ts_sptr_swiginit(self, _digital_swig0.new_correlate_access_code_ff_ts_sptr(*args))

    def __deref__(self) -> "gr::digital::correlate_access_code_ff_ts *":
        r"""__deref__(correlate_access_code_ff_ts_sptr self) -> correlate_access_code_ff_ts"""
        return _digital_swig0.correlate_access_code_ff_ts_sptr___deref__(self)
    __swig_destroy__ = _digital_swig0.delete_correlate_access_code_ff_ts_sptr

    def make(self, access_code: "std::string const &", threshold: "int", tag_name: "std::string const &") -> "gr::digital::correlate_access_code_ff_ts::sptr":
        r"""
        make(correlate_access_code_ff_ts_sptr self, std::string const & access_code, int threshold, std::string const & tag_name) -> correlate_access_code_ff_ts_sptr
        Examine input for specified access code, one bit at a time.

        input: stream of floats (generally, soft decisions) output: a tagged stream set of samples from the payload following the access code and header.


        This block searches for the given access code by slicing the soft decision symbol inputs. Once found, it expects the following 32 samples to contain a header that includes the frame length (16 bits for the length, repeated). It decodes the header to get the frame length in order to set up the the tagged stream key information.


        The output of this block is appropriate for use with tagged stream blocks.

        Constructor Specific Documentation:



        Args:
            access_code : is represented with 1 byte per bit, e.g., "010101010111000100"
            threshold : maximum number of bits that may be wrong
            tag_name : key of the tag inserted into the tag stream
        """
        return _digital_swig0.correlate_access_code_ff_ts_sptr_make(self, access_code, threshold, tag_name)

    def set_access_code(self, access_code: "std::string const &") -> "bool":
        r"""set_access_code(correlate_access_code_ff_ts_sptr self, std::string const & access_code) -> bool"""
        return _digital_swig0.correlate_access_code_ff_ts_sptr_set_access_code(self, access_code)

    def access_code(self) -> "unsigned long long":
        r"""access_code(correlate_access_code_ff_ts_sptr self) -> unsigned long long"""
        return _digital_swig0.correlate_access_code_ff_ts_sptr_access_code(self)

    def history(self) -> "unsigned int":
        r"""history(correlate_access_code_ff_ts_sptr self) -> unsigned int"""
        return _digital_swig0.correlate_access_code_ff_ts_sptr_history(self)

    def declare_sample_delay(self, *args) -> "void":
        r"""
        declare_sample_delay(correlate_access_code_ff_ts_sptr self, int which, int delay)
        declare_sample_delay(correlate_access_code_ff_ts_sptr self, unsigned int delay)
        """
        return _digital_swig0.correlate_access_code_ff_ts_sptr_declare_sample_delay(self, *args)

    def sample_delay(self, which: "int") -> "unsigned int":
        r"""sample_delay(correlate_access_code_ff_ts_sptr self, int which) -> unsigned int"""
        return _digital_swig0.correlate_access_code_ff_ts_sptr_sample_delay(self, which)

    def set_output_multiple(self, multiple: "int") -> "void":
        r"""set_output_multiple(correlate_access_code_ff_ts_sptr self, int multiple)"""
        return _digital_swig0.correlate_access_code_ff_ts_sptr_set_output_multiple(self, multiple)

    def output_multiple(self) -> "int":
        r"""output_multiple(correlate_access_code_ff_ts_sptr self) -> int"""
        return _digital_swig0.correlate_access_code_ff_ts_sptr_output_multiple(self)

    def relative_rate(self) -> "double":
        r"""relative_rate(correlate_access_code_ff_ts_sptr self) -> double"""
        return _digital_swig0.correlate_access_code_ff_ts_sptr_relative_rate(self)

    def relative_rate_i(self) -> "uint64_t":
        r"""relative_rate_i(correlate_access_code_ff_ts_sptr self) -> uint64_t"""
        return _digital_swig0.correlate_access_code_ff_ts_sptr_relative_rate_i(self)

    def relative_rate_d(self) -> "uint64_t":
        r"""relative_rate_d(correlate_access_code_ff_ts_sptr self) -> uint64_t"""
        return _digital_swig0.correlate_access_code_ff_ts_sptr_relative_rate_d(self)

    def start(self) -> "bool":
        r"""start(correlate_access_code_ff_ts_sptr self) -> bool"""
        return _digital_swig0.correlate_access_code_ff_ts_sptr_start(self)

    def stop(self) -> "bool":
        r"""stop(correlate_access_code_ff_ts_sptr self) -> bool"""
        return _digital_swig0.correlate_access_code_ff_ts_sptr_stop(self)

    def nitems_read(self, which_input: "unsigned int") -> "uint64_t":
        r"""nitems_read(correlate_access_code_ff_ts_sptr self, unsigned int which_input) -> uint64_t"""
        return _digital_swig0.correlate_access_code_ff_ts_sptr_nitems_read(self, which_input)

    def nitems_written(self, which_output: "unsigned int") -> "uint64_t":
        r"""nitems_written(correlate_access_code_ff_ts_sptr self, unsigned int which_output) -> uint64_t"""
        return _digital_swig0.correlate_access_code_ff_ts_sptr_nitems_written(self, which_output)

    def set_log_level(self, level: "std::string") -> "void":
        r"""set_log_level(correlate_access_code_ff_ts_sptr self, std::string level)"""
        return _digital_swig0.correlate_access_code_ff_ts_sptr_set_log_level(self, level)

    def log_level(self) -> "std::string":
        r"""log_level(correlate_access_code_ff_ts_sptr self) -> std::string"""
        return _digital_swig0.correlate_access_code_ff_ts_sptr_log_level(self)

    def max_noutput_items(self) -> "int":
        r"""max_noutput_items(correlate_access_code_ff_ts_sptr self) -> int"""
        return _digital_swig0.correlate_access_code_ff_ts_sptr_max_noutput_items(self)

    def set_max_noutput_items(self, m: "int") -> "void":
        r"""set_max_noutput_items(correlate_access_code_ff_ts_sptr self, int m)"""
        return _digital_swig0.correlate_access_code_ff_ts_sptr_set_max_noutput_items(self, m)

    def unset_max_noutput_items(self) -> "void":
        r"""unset_max_noutput_items(correlate_access_code_ff_ts_sptr self)"""
        return _digital_swig0.correlate_access_code_ff_ts_sptr_unset_max_noutput_items(self)

    def is_set_max_noutput_items(self) -> "bool":
        r"""is_set_max_noutput_items(correlate_access_code_ff_ts_sptr self) -> bool"""
        return _digital_swig0.correlate_access_code_ff_ts_sptr_is_set_max_noutput_items(self)

    def set_min_noutput_items(self, m: "int") -> "void":
        r"""set_min_noutput_items(correlate_access_code_ff_ts_sptr self, int m)"""
        return _digital_swig0.correlate_access_code_ff_ts_sptr_set_min_noutput_items(self, m)

    def min_noutput_items(self) -> "int":
        r"""min_noutput_items(correlate_access_code_ff_ts_sptr self) -> int"""
        return _digital_swig0.correlate_access_code_ff_ts_sptr_min_noutput_items(self)

    def max_output_buffer(self, i: "int") -> "long":
        r"""max_output_buffer(correlate_access_code_ff_ts_sptr self, int i) -> long"""
        return _digital_swig0.correlate_access_code_ff_ts_sptr_max_output_buffer(self, i)

    def set_max_output_buffer(self, *args) -> "void":
        r"""
        set_max_output_buffer(correlate_access_code_ff_ts_sptr self, long max_output_buffer)
        set_max_output_buffer(correlate_access_code_ff_ts_sptr self, int port, long max_output_buffer)
        """
        return _digital_swig0.correlate_access_code_ff_ts_sptr_set_max_output_buffer(self, *args)

    def min_output_buffer(self, i: "int") -> "long":
        r"""min_output_buffer(correlate_access_code_ff_ts_sptr self, int i) -> long"""
        return _digital_swig0.correlate_access_code_ff_ts_sptr_min_output_buffer(self, i)

    def set_min_output_buffer(self, *args) -> "void":
        r"""
        set_min_output_buffer(correlate_access_code_ff_ts_sptr self, long min_output_buffer)
        set_min_output_buffer(correlate_access_code_ff_ts_sptr self, int port, long min_output_buffer)
        """
        return _digital_swig0.correlate_access_code_ff_ts_sptr_set_min_output_buffer(self, *args)

    def pc_noutput_items(self) -> "float":
        r"""pc_noutput_items(correlate_access_code_ff_ts_sptr self) -> float"""
        return _digital_swig0.correlate_access_code_ff_ts_sptr_pc_noutput_items(self)

    def pc_noutput_items_avg(self) -> "float":
        r"""pc_noutput_items_avg(correlate_access_code_ff_ts_sptr self) -> float"""
        return _digital_swig0.correlate_access_code_ff_ts_sptr_pc_noutput_items_avg(self)

    def pc_noutput_items_var(self) -> "float":
        r"""pc_noutput_items_var(correlate_access_code_ff_ts_sptr self) -> float"""
        return _digital_swig0.correlate_access_code_ff_ts_sptr_pc_noutput_items_var(self)

    def pc_nproduced(self) -> "float":
        r"""pc_nproduced(correlate_access_code_ff_ts_sptr self) -> float"""
        return _digital_swig0.correlate_access_code_ff_ts_sptr_pc_nproduced(self)

    def pc_nproduced_avg(self) -> "float":
        r"""pc_nproduced_avg(correlate_access_code_ff_ts_sptr self) -> float"""
        return _digital_swig0.correlate_access_code_ff_ts_sptr_pc_nproduced_avg(self)

    def pc_nproduced_var(self) -> "float":
        r"""pc_nproduced_var(correlate_access_code_ff_ts_sptr self) -> float"""
        return _digital_swig0.correlate_access_code_ff_ts_sptr_pc_nproduced_var(self)

    def pc_input_buffers_full(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full(correlate_access_code_ff_ts_sptr self, int which) -> float
        pc_input_buffers_full(correlate_access_code_ff_ts_sptr self) -> pmt_vector_float
        """
        return _digital_swig0.correlate_access_code_ff_ts_sptr_pc_input_buffers_full(self, *args)

    def pc_input_buffers_full_avg(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full_avg(correlate_access_code_ff_ts_sptr self, int which) -> float
        pc_input_buffers_full_avg(correlate_access_code_ff_ts_sptr self) -> pmt_vector_float
        """
        return _digital_swig0.correlate_access_code_ff_ts_sptr_pc_input_buffers_full_avg(self, *args)

    def pc_input_buffers_full_var(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full_var(correlate_access_code_ff_ts_sptr self, int which) -> float
        pc_input_buffers_full_var(correlate_access_code_ff_ts_sptr self) -> pmt_vector_float
        """
        return _digital_swig0.correlate_access_code_ff_ts_sptr_pc_input_buffers_full_var(self, *args)

    def pc_output_buffers_full(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full(correlate_access_code_ff_ts_sptr self, int which) -> float
        pc_output_buffers_full(correlate_access_code_ff_ts_sptr self) -> pmt_vector_float
        """
        return _digital_swig0.correlate_access_code_ff_ts_sptr_pc_output_buffers_full(self, *args)

    def pc_output_buffers_full_avg(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full_avg(correlate_access_code_ff_ts_sptr self, int which) -> float
        pc_output_buffers_full_avg(correlate_access_code_ff_ts_sptr self) -> pmt_vector_float
        """
        return _digital_swig0.correlate_access_code_ff_ts_sptr_pc_output_buffers_full_avg(self, *args)

    def pc_output_buffers_full_var(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full_var(correlate_access_code_ff_ts_sptr self, int which) -> float
        pc_output_buffers_full_var(correlate_access_code_ff_ts_sptr self) -> pmt_vector_float
        """
        return _digital_swig0.correlate_access_code_ff_ts_sptr_pc_output_buffers_full_var(self, *args)

    def pc_work_time(self) -> "float":
        r"""pc_work_time(correlate_access_code_ff_ts_sptr self) -> float"""
        return _digital_swig0.correlate_access_code_ff_ts_sptr_pc_work_time(self)

    def pc_work_time_avg(self) -> "float":
        r"""pc_work_time_avg(correlate_access_code_ff_ts_sptr self) -> float"""
        return _digital_swig0.correlate_access_code_ff_ts_sptr_pc_work_time_avg(self)

    def pc_work_time_var(self) -> "float":
        r"""pc_work_time_var(correlate_access_code_ff_ts_sptr self) -> float"""
        return _digital_swig0.correlate_access_code_ff_ts_sptr_pc_work_time_var(self)

    def pc_work_time_total(self) -> "float":
        r"""pc_work_time_total(correlate_access_code_ff_ts_sptr self) -> float"""
        return _digital_swig0.correlate_access_code_ff_ts_sptr_pc_work_time_total(self)

    def pc_throughput_avg(self) -> "float":
        r"""pc_throughput_avg(correlate_access_code_ff_ts_sptr self) -> float"""
        return _digital_swig0.correlate_access_code_ff_ts_sptr_pc_throughput_avg(self)

    def set_processor_affinity(self, mask: "std::vector< int,std::allocator< int > > const &") -> "void":
        r"""set_processor_affinity(correlate_access_code_ff_ts_sptr self, std::vector< int,std::allocator< int > > const & mask)"""
        return _digital_swig0.correlate_access_code_ff_ts_sptr_set_processor_affinity(self, mask)

    def unset_processor_affinity(self) -> "void":
        r"""unset_processor_affinity(correlate_access_code_ff_ts_sptr self)"""
        return _digital_swig0.correlate_access_code_ff_ts_sptr_unset_processor_affinity(self)

    def processor_affinity(self) -> "std::vector< int,std::allocator< int > >":
        r"""processor_affinity(correlate_access_code_ff_ts_sptr self) -> std::vector< int,std::allocator< int > >"""
        return _digital_swig0.correlate_access_code_ff_ts_sptr_processor_affinity(self)

    def active_thread_priority(self) -> "int":
        r"""active_thread_priority(correlate_access_code_ff_ts_sptr self) -> int"""
        return _digital_swig0.correlate_access_code_ff_ts_sptr_active_thread_priority(self)

    def thread_priority(self) -> "int":
        r"""thread_priority(correlate_access_code_ff_ts_sptr self) -> int"""
        return _digital_swig0.correlate_access_code_ff_ts_sptr_thread_priority(self)

    def set_thread_priority(self, priority: "int") -> "int":
        r"""set_thread_priority(correlate_access_code_ff_ts_sptr self, int priority) -> int"""
        return _digital_swig0.correlate_access_code_ff_ts_sptr_set_thread_priority(self, priority)

    def name(self) -> "std::string":
        r"""name(correlate_access_code_ff_ts_sptr self) -> std::string"""
        return _digital_swig0.correlate_access_code_ff_ts_sptr_name(self)

    def symbol_name(self) -> "std::string":
        r"""symbol_name(correlate_access_code_ff_ts_sptr self) -> std::string"""
        return _digital_swig0.correlate_access_code_ff_ts_sptr_symbol_name(self)

    def input_signature(self) -> "gr::io_signature::sptr":
        r"""input_signature(correlate_access_code_ff_ts_sptr self) -> io_signature_sptr"""
        return _digital_swig0.correlate_access_code_ff_ts_sptr_input_signature(self)

    def output_signature(self) -> "gr::io_signature::sptr":
        r"""output_signature(correlate_access_code_ff_ts_sptr self) -> io_signature_sptr"""
        return _digital_swig0.correlate_access_code_ff_ts_sptr_output_signature(self)

    def unique_id(self) -> "long":
        r"""unique_id(correlate_access_code_ff_ts_sptr self) -> long"""
        return _digital_swig0.correlate_access_code_ff_ts_sptr_unique_id(self)

    def to_basic_block(self) -> "gr::basic_block_sptr":
        r"""to_basic_block(correlate_access_code_ff_ts_sptr self) -> basic_block_sptr"""
        return _digital_swig0.correlate_access_code_ff_ts_sptr_to_basic_block(self)

    def check_topology(self, ninputs: "int", noutputs: "int") -> "bool":
        r"""check_topology(correlate_access_code_ff_ts_sptr self, int ninputs, int noutputs) -> bool"""
        return _digital_swig0.correlate_access_code_ff_ts_sptr_check_topology(self, ninputs, noutputs)

    def alias(self) -> "std::string":
        r"""alias(correlate_access_code_ff_ts_sptr self) -> std::string"""
        return _digital_swig0.correlate_access_code_ff_ts_sptr_alias(self)

    def set_block_alias(self, name: "std::string") -> "void":
        r"""set_block_alias(correlate_access_code_ff_ts_sptr self, std::string name)"""
        return _digital_swig0.correlate_access_code_ff_ts_sptr_set_block_alias(self, name)

    def _post(self, which_port: "swig_pmt_ptr", msg: "swig_pmt_ptr") -> "void":
        r"""_post(correlate_access_code_ff_ts_sptr self, swig_pmt_ptr which_port, swig_pmt_ptr msg)"""
        return _digital_swig0.correlate_access_code_ff_ts_sptr__post(self, which_port, msg)

    def message_ports_in(self) -> "pmt::pmt_t":
        r"""message_ports_in(correlate_access_code_ff_ts_sptr self) -> swig_pmt_ptr"""
        return _digital_swig0.correlate_access_code_ff_ts_sptr_message_ports_in(self)

    def message_ports_out(self) -> "pmt::pmt_t":
        r"""message_ports_out(correlate_access_code_ff_ts_sptr self) -> swig_pmt_ptr"""
        return _digital_swig0.correlate_access_code_ff_ts_sptr_message_ports_out(self)

    def message_subscribers(self, which_port: "swig_pmt_ptr") -> "pmt::pmt_t":
        r"""message_subscribers(correlate_access_code_ff_ts_sptr self, swig_pmt_ptr which_port) -> swig_pmt_ptr"""
        return _digital_swig0.correlate_access_code_ff_ts_sptr_message_subscribers(self, which_port)

# Register correlate_access_code_ff_ts_sptr in _digital_swig0:
_digital_swig0.correlate_access_code_ff_ts_sptr_swigregister(correlate_access_code_ff_ts_sptr)

correlate_access_code_ff_ts_sptr.__repr__ = lambda self: "<gr_block %s (%d)>" % (self.name(), self.unique_id())
correlate_access_code_ff_ts = correlate_access_code_ff_ts.make;

class costas_loop_cc_sptr(object):
    r"""Proxy of C++ boost::shared_ptr< gr::digital::costas_loop_cc > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(costas_loop_cc_sptr self) -> costas_loop_cc_sptr
        __init__(costas_loop_cc_sptr self, costas_loop_cc p) -> costas_loop_cc_sptr
        """
        _digital_swig0.costas_loop_cc_sptr_swiginit(self, _digital_swig0.new_costas_loop_cc_sptr(*args))

    def __deref__(self) -> "gr::digital::costas_loop_cc *":
        r"""__deref__(costas_loop_cc_sptr self) -> costas_loop_cc"""
        return _digital_swig0.costas_loop_cc_sptr___deref__(self)
    __swig_destroy__ = _digital_swig0.delete_costas_loop_cc_sptr

    def make(self, loop_bw: "float", order: "int", use_snr: "bool"=False) -> "gr::digital::costas_loop_cc::sptr":
        r"""
        make(costas_loop_cc_sptr self, float loop_bw, int order, bool use_snr=False) -> costas_loop_cc_sptr
        A Costas loop carrier recovery module.

        The Costas loop locks to the center frequency of a signal and downconverts it to baseband.





        More details can be found online:


        J. Feigin, "Practical Costas loop design: Designing a simple
        and inexpensive BPSK Costas loop carrier recovery circuit," RF signal processing, pp. 20-36, 2002.





        The Costas loop can have two output streams: 
        There is a single optional message input:

        Constructor Specific Documentation:

        Make a Costas loop carrier recovery block.

        Args:
            loop_bw : internal 2nd order loop bandwidth (~ 2pi/100)
            order : the loop order, either 2, 4, or 8
            use_snr : Use or ignore SNR estimates (from noise message port) in measurements; also uses tanh instead of slicing.
        """
        return _digital_swig0.costas_loop_cc_sptr_make(self, loop_bw, order, use_snr)

    def error(self) -> "float":
        r"""
        error(costas_loop_cc_sptr self) -> float
        Returns the current value of the loop error.
        """
        return _digital_swig0.costas_loop_cc_sptr_error(self)

    def history(self) -> "unsigned int":
        r"""history(costas_loop_cc_sptr self) -> unsigned int"""
        return _digital_swig0.costas_loop_cc_sptr_history(self)

    def declare_sample_delay(self, *args) -> "void":
        r"""
        declare_sample_delay(costas_loop_cc_sptr self, int which, int delay)
        declare_sample_delay(costas_loop_cc_sptr self, unsigned int delay)
        """
        return _digital_swig0.costas_loop_cc_sptr_declare_sample_delay(self, *args)

    def sample_delay(self, which: "int") -> "unsigned int":
        r"""sample_delay(costas_loop_cc_sptr self, int which) -> unsigned int"""
        return _digital_swig0.costas_loop_cc_sptr_sample_delay(self, which)

    def set_output_multiple(self, multiple: "int") -> "void":
        r"""set_output_multiple(costas_loop_cc_sptr self, int multiple)"""
        return _digital_swig0.costas_loop_cc_sptr_set_output_multiple(self, multiple)

    def output_multiple(self) -> "int":
        r"""output_multiple(costas_loop_cc_sptr self) -> int"""
        return _digital_swig0.costas_loop_cc_sptr_output_multiple(self)

    def relative_rate(self) -> "double":
        r"""relative_rate(costas_loop_cc_sptr self) -> double"""
        return _digital_swig0.costas_loop_cc_sptr_relative_rate(self)

    def relative_rate_i(self) -> "uint64_t":
        r"""relative_rate_i(costas_loop_cc_sptr self) -> uint64_t"""
        return _digital_swig0.costas_loop_cc_sptr_relative_rate_i(self)

    def relative_rate_d(self) -> "uint64_t":
        r"""relative_rate_d(costas_loop_cc_sptr self) -> uint64_t"""
        return _digital_swig0.costas_loop_cc_sptr_relative_rate_d(self)

    def start(self) -> "bool":
        r"""start(costas_loop_cc_sptr self) -> bool"""
        return _digital_swig0.costas_loop_cc_sptr_start(self)

    def stop(self) -> "bool":
        r"""stop(costas_loop_cc_sptr self) -> bool"""
        return _digital_swig0.costas_loop_cc_sptr_stop(self)

    def nitems_read(self, which_input: "unsigned int") -> "uint64_t":
        r"""nitems_read(costas_loop_cc_sptr self, unsigned int which_input) -> uint64_t"""
        return _digital_swig0.costas_loop_cc_sptr_nitems_read(self, which_input)

    def nitems_written(self, which_output: "unsigned int") -> "uint64_t":
        r"""nitems_written(costas_loop_cc_sptr self, unsigned int which_output) -> uint64_t"""
        return _digital_swig0.costas_loop_cc_sptr_nitems_written(self, which_output)

    def set_log_level(self, level: "std::string") -> "void":
        r"""set_log_level(costas_loop_cc_sptr self, std::string level)"""
        return _digital_swig0.costas_loop_cc_sptr_set_log_level(self, level)

    def log_level(self) -> "std::string":
        r"""log_level(costas_loop_cc_sptr self) -> std::string"""
        return _digital_swig0.costas_loop_cc_sptr_log_level(self)

    def max_noutput_items(self) -> "int":
        r"""max_noutput_items(costas_loop_cc_sptr self) -> int"""
        return _digital_swig0.costas_loop_cc_sptr_max_noutput_items(self)

    def set_max_noutput_items(self, m: "int") -> "void":
        r"""set_max_noutput_items(costas_loop_cc_sptr self, int m)"""
        return _digital_swig0.costas_loop_cc_sptr_set_max_noutput_items(self, m)

    def unset_max_noutput_items(self) -> "void":
        r"""unset_max_noutput_items(costas_loop_cc_sptr self)"""
        return _digital_swig0.costas_loop_cc_sptr_unset_max_noutput_items(self)

    def is_set_max_noutput_items(self) -> "bool":
        r"""is_set_max_noutput_items(costas_loop_cc_sptr self) -> bool"""
        return _digital_swig0.costas_loop_cc_sptr_is_set_max_noutput_items(self)

    def set_min_noutput_items(self, m: "int") -> "void":
        r"""set_min_noutput_items(costas_loop_cc_sptr self, int m)"""
        return _digital_swig0.costas_loop_cc_sptr_set_min_noutput_items(self, m)

    def min_noutput_items(self) -> "int":
        r"""min_noutput_items(costas_loop_cc_sptr self) -> int"""
        return _digital_swig0.costas_loop_cc_sptr_min_noutput_items(self)

    def max_output_buffer(self, i: "int") -> "long":
        r"""max_output_buffer(costas_loop_cc_sptr self, int i) -> long"""
        return _digital_swig0.costas_loop_cc_sptr_max_output_buffer(self, i)

    def set_max_output_buffer(self, *args) -> "void":
        r"""
        set_max_output_buffer(costas_loop_cc_sptr self, long max_output_buffer)
        set_max_output_buffer(costas_loop_cc_sptr self, int port, long max_output_buffer)
        """
        return _digital_swig0.costas_loop_cc_sptr_set_max_output_buffer(self, *args)

    def min_output_buffer(self, i: "int") -> "long":
        r"""min_output_buffer(costas_loop_cc_sptr self, int i) -> long"""
        return _digital_swig0.costas_loop_cc_sptr_min_output_buffer(self, i)

    def set_min_output_buffer(self, *args) -> "void":
        r"""
        set_min_output_buffer(costas_loop_cc_sptr self, long min_output_buffer)
        set_min_output_buffer(costas_loop_cc_sptr self, int port, long min_output_buffer)
        """
        return _digital_swig0.costas_loop_cc_sptr_set_min_output_buffer(self, *args)

    def pc_noutput_items(self) -> "float":
        r"""pc_noutput_items(costas_loop_cc_sptr self) -> float"""
        return _digital_swig0.costas_loop_cc_sptr_pc_noutput_items(self)

    def pc_noutput_items_avg(self) -> "float":
        r"""pc_noutput_items_avg(costas_loop_cc_sptr self) -> float"""
        return _digital_swig0.costas_loop_cc_sptr_pc_noutput_items_avg(self)

    def pc_noutput_items_var(self) -> "float":
        r"""pc_noutput_items_var(costas_loop_cc_sptr self) -> float"""
        return _digital_swig0.costas_loop_cc_sptr_pc_noutput_items_var(self)

    def pc_nproduced(self) -> "float":
        r"""pc_nproduced(costas_loop_cc_sptr self) -> float"""
        return _digital_swig0.costas_loop_cc_sptr_pc_nproduced(self)

    def pc_nproduced_avg(self) -> "float":
        r"""pc_nproduced_avg(costas_loop_cc_sptr self) -> float"""
        return _digital_swig0.costas_loop_cc_sptr_pc_nproduced_avg(self)

    def pc_nproduced_var(self) -> "float":
        r"""pc_nproduced_var(costas_loop_cc_sptr self) -> float"""
        return _digital_swig0.costas_loop_cc_sptr_pc_nproduced_var(self)

    def pc_input_buffers_full(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full(costas_loop_cc_sptr self, int which) -> float
        pc_input_buffers_full(costas_loop_cc_sptr self) -> pmt_vector_float
        """
        return _digital_swig0.costas_loop_cc_sptr_pc_input_buffers_full(self, *args)

    def pc_input_buffers_full_avg(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full_avg(costas_loop_cc_sptr self, int which) -> float
        pc_input_buffers_full_avg(costas_loop_cc_sptr self) -> pmt_vector_float
        """
        return _digital_swig0.costas_loop_cc_sptr_pc_input_buffers_full_avg(self, *args)

    def pc_input_buffers_full_var(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full_var(costas_loop_cc_sptr self, int which) -> float
        pc_input_buffers_full_var(costas_loop_cc_sptr self) -> pmt_vector_float
        """
        return _digital_swig0.costas_loop_cc_sptr_pc_input_buffers_full_var(self, *args)

    def pc_output_buffers_full(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full(costas_loop_cc_sptr self, int which) -> float
        pc_output_buffers_full(costas_loop_cc_sptr self) -> pmt_vector_float
        """
        return _digital_swig0.costas_loop_cc_sptr_pc_output_buffers_full(self, *args)

    def pc_output_buffers_full_avg(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full_avg(costas_loop_cc_sptr self, int which) -> float
        pc_output_buffers_full_avg(costas_loop_cc_sptr self) -> pmt_vector_float
        """
        return _digital_swig0.costas_loop_cc_sptr_pc_output_buffers_full_avg(self, *args)

    def pc_output_buffers_full_var(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full_var(costas_loop_cc_sptr self, int which) -> float
        pc_output_buffers_full_var(costas_loop_cc_sptr self) -> pmt_vector_float
        """
        return _digital_swig0.costas_loop_cc_sptr_pc_output_buffers_full_var(self, *args)

    def pc_work_time(self) -> "float":
        r"""pc_work_time(costas_loop_cc_sptr self) -> float"""
        return _digital_swig0.costas_loop_cc_sptr_pc_work_time(self)

    def pc_work_time_avg(self) -> "float":
        r"""pc_work_time_avg(costas_loop_cc_sptr self) -> float"""
        return _digital_swig0.costas_loop_cc_sptr_pc_work_time_avg(self)

    def pc_work_time_var(self) -> "float":
        r"""pc_work_time_var(costas_loop_cc_sptr self) -> float"""
        return _digital_swig0.costas_loop_cc_sptr_pc_work_time_var(self)

    def pc_work_time_total(self) -> "float":
        r"""pc_work_time_total(costas_loop_cc_sptr self) -> float"""
        return _digital_swig0.costas_loop_cc_sptr_pc_work_time_total(self)

    def pc_throughput_avg(self) -> "float":
        r"""pc_throughput_avg(costas_loop_cc_sptr self) -> float"""
        return _digital_swig0.costas_loop_cc_sptr_pc_throughput_avg(self)

    def set_processor_affinity(self, mask: "std::vector< int,std::allocator< int > > const &") -> "void":
        r"""set_processor_affinity(costas_loop_cc_sptr self, std::vector< int,std::allocator< int > > const & mask)"""
        return _digital_swig0.costas_loop_cc_sptr_set_processor_affinity(self, mask)

    def unset_processor_affinity(self) -> "void":
        r"""unset_processor_affinity(costas_loop_cc_sptr self)"""
        return _digital_swig0.costas_loop_cc_sptr_unset_processor_affinity(self)

    def processor_affinity(self) -> "std::vector< int,std::allocator< int > >":
        r"""processor_affinity(costas_loop_cc_sptr self) -> std::vector< int,std::allocator< int > >"""
        return _digital_swig0.costas_loop_cc_sptr_processor_affinity(self)

    def active_thread_priority(self) -> "int":
        r"""active_thread_priority(costas_loop_cc_sptr self) -> int"""
        return _digital_swig0.costas_loop_cc_sptr_active_thread_priority(self)

    def thread_priority(self) -> "int":
        r"""thread_priority(costas_loop_cc_sptr self) -> int"""
        return _digital_swig0.costas_loop_cc_sptr_thread_priority(self)

    def set_thread_priority(self, priority: "int") -> "int":
        r"""set_thread_priority(costas_loop_cc_sptr self, int priority) -> int"""
        return _digital_swig0.costas_loop_cc_sptr_set_thread_priority(self, priority)

    def name(self) -> "std::string":
        r"""name(costas_loop_cc_sptr self) -> std::string"""
        return _digital_swig0.costas_loop_cc_sptr_name(self)

    def symbol_name(self) -> "std::string":
        r"""symbol_name(costas_loop_cc_sptr self) -> std::string"""
        return _digital_swig0.costas_loop_cc_sptr_symbol_name(self)

    def input_signature(self) -> "gr::io_signature::sptr":
        r"""input_signature(costas_loop_cc_sptr self) -> io_signature_sptr"""
        return _digital_swig0.costas_loop_cc_sptr_input_signature(self)

    def output_signature(self) -> "gr::io_signature::sptr":
        r"""output_signature(costas_loop_cc_sptr self) -> io_signature_sptr"""
        return _digital_swig0.costas_loop_cc_sptr_output_signature(self)

    def unique_id(self) -> "long":
        r"""unique_id(costas_loop_cc_sptr self) -> long"""
        return _digital_swig0.costas_loop_cc_sptr_unique_id(self)

    def to_basic_block(self) -> "gr::basic_block_sptr":
        r"""to_basic_block(costas_loop_cc_sptr self) -> basic_block_sptr"""
        return _digital_swig0.costas_loop_cc_sptr_to_basic_block(self)

    def check_topology(self, ninputs: "int", noutputs: "int") -> "bool":
        r"""check_topology(costas_loop_cc_sptr self, int ninputs, int noutputs) -> bool"""
        return _digital_swig0.costas_loop_cc_sptr_check_topology(self, ninputs, noutputs)

    def alias(self) -> "std::string":
        r"""alias(costas_loop_cc_sptr self) -> std::string"""
        return _digital_swig0.costas_loop_cc_sptr_alias(self)

    def set_block_alias(self, name: "std::string") -> "void":
        r"""set_block_alias(costas_loop_cc_sptr self, std::string name)"""
        return _digital_swig0.costas_loop_cc_sptr_set_block_alias(self, name)

    def _post(self, which_port: "swig_pmt_ptr", msg: "swig_pmt_ptr") -> "void":
        r"""_post(costas_loop_cc_sptr self, swig_pmt_ptr which_port, swig_pmt_ptr msg)"""
        return _digital_swig0.costas_loop_cc_sptr__post(self, which_port, msg)

    def message_ports_in(self) -> "pmt::pmt_t":
        r"""message_ports_in(costas_loop_cc_sptr self) -> swig_pmt_ptr"""
        return _digital_swig0.costas_loop_cc_sptr_message_ports_in(self)

    def message_ports_out(self) -> "pmt::pmt_t":
        r"""message_ports_out(costas_loop_cc_sptr self) -> swig_pmt_ptr"""
        return _digital_swig0.costas_loop_cc_sptr_message_ports_out(self)

    def message_subscribers(self, which_port: "swig_pmt_ptr") -> "pmt::pmt_t":
        r"""message_subscribers(costas_loop_cc_sptr self, swig_pmt_ptr which_port) -> swig_pmt_ptr"""
        return _digital_swig0.costas_loop_cc_sptr_message_subscribers(self, which_port)

    def update_gains(self) -> "void":
        r"""update_gains(costas_loop_cc_sptr self)"""
        return _digital_swig0.costas_loop_cc_sptr_update_gains(self)

    def advance_loop(self, error: "float") -> "void":
        r"""advance_loop(costas_loop_cc_sptr self, float error)"""
        return _digital_swig0.costas_loop_cc_sptr_advance_loop(self, error)

    def phase_wrap(self) -> "void":
        r"""phase_wrap(costas_loop_cc_sptr self)"""
        return _digital_swig0.costas_loop_cc_sptr_phase_wrap(self)

    def frequency_limit(self) -> "void":
        r"""frequency_limit(costas_loop_cc_sptr self)"""
        return _digital_swig0.costas_loop_cc_sptr_frequency_limit(self)

    def set_loop_bandwidth(self, bw: "float") -> "void":
        r"""set_loop_bandwidth(costas_loop_cc_sptr self, float bw)"""
        return _digital_swig0.costas_loop_cc_sptr_set_loop_bandwidth(self, bw)

    def set_damping_factor(self, df: "float") -> "void":
        r"""set_damping_factor(costas_loop_cc_sptr self, float df)"""
        return _digital_swig0.costas_loop_cc_sptr_set_damping_factor(self, df)

    def set_alpha(self, alpha: "float") -> "void":
        r"""set_alpha(costas_loop_cc_sptr self, float alpha)"""
        return _digital_swig0.costas_loop_cc_sptr_set_alpha(self, alpha)

    def set_beta(self, beta: "float") -> "void":
        r"""set_beta(costas_loop_cc_sptr self, float beta)"""
        return _digital_swig0.costas_loop_cc_sptr_set_beta(self, beta)

    def set_frequency(self, freq: "float") -> "void":
        r"""set_frequency(costas_loop_cc_sptr self, float freq)"""
        return _digital_swig0.costas_loop_cc_sptr_set_frequency(self, freq)

    def set_phase(self, phase: "float") -> "void":
        r"""set_phase(costas_loop_cc_sptr self, float phase)"""
        return _digital_swig0.costas_loop_cc_sptr_set_phase(self, phase)

    def set_max_freq(self, freq: "float") -> "void":
        r"""set_max_freq(costas_loop_cc_sptr self, float freq)"""
        return _digital_swig0.costas_loop_cc_sptr_set_max_freq(self, freq)

    def set_min_freq(self, freq: "float") -> "void":
        r"""set_min_freq(costas_loop_cc_sptr self, float freq)"""
        return _digital_swig0.costas_loop_cc_sptr_set_min_freq(self, freq)

    def get_loop_bandwidth(self) -> "float":
        r"""get_loop_bandwidth(costas_loop_cc_sptr self) -> float"""
        return _digital_swig0.costas_loop_cc_sptr_get_loop_bandwidth(self)

    def get_damping_factor(self) -> "float":
        r"""get_damping_factor(costas_loop_cc_sptr self) -> float"""
        return _digital_swig0.costas_loop_cc_sptr_get_damping_factor(self)

    def get_alpha(self) -> "float":
        r"""get_alpha(costas_loop_cc_sptr self) -> float"""
        return _digital_swig0.costas_loop_cc_sptr_get_alpha(self)

    def get_beta(self) -> "float":
        r"""get_beta(costas_loop_cc_sptr self) -> float"""
        return _digital_swig0.costas_loop_cc_sptr_get_beta(self)

    def get_frequency(self) -> "float":
        r"""get_frequency(costas_loop_cc_sptr self) -> float"""
        return _digital_swig0.costas_loop_cc_sptr_get_frequency(self)

    def get_phase(self) -> "float":
        r"""get_phase(costas_loop_cc_sptr self) -> float"""
        return _digital_swig0.costas_loop_cc_sptr_get_phase(self)

    def get_max_freq(self) -> "float":
        r"""get_max_freq(costas_loop_cc_sptr self) -> float"""
        return _digital_swig0.costas_loop_cc_sptr_get_max_freq(self)

    def get_min_freq(self) -> "float":
        r"""get_min_freq(costas_loop_cc_sptr self) -> float"""
        return _digital_swig0.costas_loop_cc_sptr_get_min_freq(self)

# Register costas_loop_cc_sptr in _digital_swig0:
_digital_swig0.costas_loop_cc_sptr_swigregister(costas_loop_cc_sptr)

costas_loop_cc_sptr.__repr__ = lambda self: "<gr_block %s (%d)>" % (self.name(), self.unique_id())
costas_loop_cc = costas_loop_cc.make;

class crc32_bb_sptr(object):
    r"""Proxy of C++ boost::shared_ptr< gr::digital::crc32_bb > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(crc32_bb_sptr self) -> crc32_bb_sptr
        __init__(crc32_bb_sptr self, crc32_bb p) -> crc32_bb_sptr
        """
        _digital_swig0.crc32_bb_sptr_swiginit(self, _digital_swig0.new_crc32_bb_sptr(*args))

    def __deref__(self) -> "gr::digital::crc32_bb *":
        r"""__deref__(crc32_bb_sptr self) -> crc32_bb"""
        return _digital_swig0.crc32_bb_sptr___deref__(self)
    __swig_destroy__ = _digital_swig0.delete_crc32_bb_sptr

    def make(self, *args, **kwargs) -> "gr::digital::crc32_bb::sptr":
        r"""
        make(crc32_bb_sptr self, bool check=False, std::string const & lengthtagname="packet_len", bool packed=True) -> crc32_bb_sptr
        Byte-stream CRC block.

        Input: stream of bytes, which form a packet. The first byte of the packet has a tag with key "length" and the value being the number of bytes in the packet.


        Output: The same bytes as incoming, but trailing a CRC32 of the packet. The tag is re-set to the new length.

        Constructor Specific Documentation:



        Args:
            check : Set to true if you want to check CRC, false to create CRC.
            lengthtagname : Length tag key for the tagged stream.
            packed : If the data is packed or unpacked bits (default=true).
        """
        return _digital_swig0.crc32_bb_sptr_make(self, *args, **kwargs)

    def history(self) -> "unsigned int":
        r"""history(crc32_bb_sptr self) -> unsigned int"""
        return _digital_swig0.crc32_bb_sptr_history(self)

    def declare_sample_delay(self, *args) -> "void":
        r"""
        declare_sample_delay(crc32_bb_sptr self, int which, int delay)
        declare_sample_delay(crc32_bb_sptr self, unsigned int delay)
        """
        return _digital_swig0.crc32_bb_sptr_declare_sample_delay(self, *args)

    def sample_delay(self, which: "int") -> "unsigned int":
        r"""sample_delay(crc32_bb_sptr self, int which) -> unsigned int"""
        return _digital_swig0.crc32_bb_sptr_sample_delay(self, which)

    def set_output_multiple(self, multiple: "int") -> "void":
        r"""set_output_multiple(crc32_bb_sptr self, int multiple)"""
        return _digital_swig0.crc32_bb_sptr_set_output_multiple(self, multiple)

    def output_multiple(self) -> "int":
        r"""output_multiple(crc32_bb_sptr self) -> int"""
        return _digital_swig0.crc32_bb_sptr_output_multiple(self)

    def relative_rate(self) -> "double":
        r"""relative_rate(crc32_bb_sptr self) -> double"""
        return _digital_swig0.crc32_bb_sptr_relative_rate(self)

    def relative_rate_i(self) -> "uint64_t":
        r"""relative_rate_i(crc32_bb_sptr self) -> uint64_t"""
        return _digital_swig0.crc32_bb_sptr_relative_rate_i(self)

    def relative_rate_d(self) -> "uint64_t":
        r"""relative_rate_d(crc32_bb_sptr self) -> uint64_t"""
        return _digital_swig0.crc32_bb_sptr_relative_rate_d(self)

    def start(self) -> "bool":
        r"""start(crc32_bb_sptr self) -> bool"""
        return _digital_swig0.crc32_bb_sptr_start(self)

    def stop(self) -> "bool":
        r"""stop(crc32_bb_sptr self) -> bool"""
        return _digital_swig0.crc32_bb_sptr_stop(self)

    def nitems_read(self, which_input: "unsigned int") -> "uint64_t":
        r"""nitems_read(crc32_bb_sptr self, unsigned int which_input) -> uint64_t"""
        return _digital_swig0.crc32_bb_sptr_nitems_read(self, which_input)

    def nitems_written(self, which_output: "unsigned int") -> "uint64_t":
        r"""nitems_written(crc32_bb_sptr self, unsigned int which_output) -> uint64_t"""
        return _digital_swig0.crc32_bb_sptr_nitems_written(self, which_output)

    def set_log_level(self, level: "std::string") -> "void":
        r"""set_log_level(crc32_bb_sptr self, std::string level)"""
        return _digital_swig0.crc32_bb_sptr_set_log_level(self, level)

    def log_level(self) -> "std::string":
        r"""log_level(crc32_bb_sptr self) -> std::string"""
        return _digital_swig0.crc32_bb_sptr_log_level(self)

    def max_noutput_items(self) -> "int":
        r"""max_noutput_items(crc32_bb_sptr self) -> int"""
        return _digital_swig0.crc32_bb_sptr_max_noutput_items(self)

    def set_max_noutput_items(self, m: "int") -> "void":
        r"""set_max_noutput_items(crc32_bb_sptr self, int m)"""
        return _digital_swig0.crc32_bb_sptr_set_max_noutput_items(self, m)

    def unset_max_noutput_items(self) -> "void":
        r"""unset_max_noutput_items(crc32_bb_sptr self)"""
        return _digital_swig0.crc32_bb_sptr_unset_max_noutput_items(self)

    def is_set_max_noutput_items(self) -> "bool":
        r"""is_set_max_noutput_items(crc32_bb_sptr self) -> bool"""
        return _digital_swig0.crc32_bb_sptr_is_set_max_noutput_items(self)

    def set_min_noutput_items(self, m: "int") -> "void":
        r"""set_min_noutput_items(crc32_bb_sptr self, int m)"""
        return _digital_swig0.crc32_bb_sptr_set_min_noutput_items(self, m)

    def min_noutput_items(self) -> "int":
        r"""min_noutput_items(crc32_bb_sptr self) -> int"""
        return _digital_swig0.crc32_bb_sptr_min_noutput_items(self)

    def max_output_buffer(self, i: "int") -> "long":
        r"""max_output_buffer(crc32_bb_sptr self, int i) -> long"""
        return _digital_swig0.crc32_bb_sptr_max_output_buffer(self, i)

    def set_max_output_buffer(self, *args) -> "void":
        r"""
        set_max_output_buffer(crc32_bb_sptr self, long max_output_buffer)
        set_max_output_buffer(crc32_bb_sptr self, int port, long max_output_buffer)
        """
        return _digital_swig0.crc32_bb_sptr_set_max_output_buffer(self, *args)

    def min_output_buffer(self, i: "int") -> "long":
        r"""min_output_buffer(crc32_bb_sptr self, int i) -> long"""
        return _digital_swig0.crc32_bb_sptr_min_output_buffer(self, i)

    def set_min_output_buffer(self, *args) -> "void":
        r"""
        set_min_output_buffer(crc32_bb_sptr self, long min_output_buffer)
        set_min_output_buffer(crc32_bb_sptr self, int port, long min_output_buffer)
        """
        return _digital_swig0.crc32_bb_sptr_set_min_output_buffer(self, *args)

    def pc_noutput_items(self) -> "float":
        r"""pc_noutput_items(crc32_bb_sptr self) -> float"""
        return _digital_swig0.crc32_bb_sptr_pc_noutput_items(self)

    def pc_noutput_items_avg(self) -> "float":
        r"""pc_noutput_items_avg(crc32_bb_sptr self) -> float"""
        return _digital_swig0.crc32_bb_sptr_pc_noutput_items_avg(self)

    def pc_noutput_items_var(self) -> "float":
        r"""pc_noutput_items_var(crc32_bb_sptr self) -> float"""
        return _digital_swig0.crc32_bb_sptr_pc_noutput_items_var(self)

    def pc_nproduced(self) -> "float":
        r"""pc_nproduced(crc32_bb_sptr self) -> float"""
        return _digital_swig0.crc32_bb_sptr_pc_nproduced(self)

    def pc_nproduced_avg(self) -> "float":
        r"""pc_nproduced_avg(crc32_bb_sptr self) -> float"""
        return _digital_swig0.crc32_bb_sptr_pc_nproduced_avg(self)

    def pc_nproduced_var(self) -> "float":
        r"""pc_nproduced_var(crc32_bb_sptr self) -> float"""
        return _digital_swig0.crc32_bb_sptr_pc_nproduced_var(self)

    def pc_input_buffers_full(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full(crc32_bb_sptr self, int which) -> float
        pc_input_buffers_full(crc32_bb_sptr self) -> pmt_vector_float
        """
        return _digital_swig0.crc32_bb_sptr_pc_input_buffers_full(self, *args)

    def pc_input_buffers_full_avg(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full_avg(crc32_bb_sptr self, int which) -> float
        pc_input_buffers_full_avg(crc32_bb_sptr self) -> pmt_vector_float
        """
        return _digital_swig0.crc32_bb_sptr_pc_input_buffers_full_avg(self, *args)

    def pc_input_buffers_full_var(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full_var(crc32_bb_sptr self, int which) -> float
        pc_input_buffers_full_var(crc32_bb_sptr self) -> pmt_vector_float
        """
        return _digital_swig0.crc32_bb_sptr_pc_input_buffers_full_var(self, *args)

    def pc_output_buffers_full(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full(crc32_bb_sptr self, int which) -> float
        pc_output_buffers_full(crc32_bb_sptr self) -> pmt_vector_float
        """
        return _digital_swig0.crc32_bb_sptr_pc_output_buffers_full(self, *args)

    def pc_output_buffers_full_avg(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full_avg(crc32_bb_sptr self, int which) -> float
        pc_output_buffers_full_avg(crc32_bb_sptr self) -> pmt_vector_float
        """
        return _digital_swig0.crc32_bb_sptr_pc_output_buffers_full_avg(self, *args)

    def pc_output_buffers_full_var(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full_var(crc32_bb_sptr self, int which) -> float
        pc_output_buffers_full_var(crc32_bb_sptr self) -> pmt_vector_float
        """
        return _digital_swig0.crc32_bb_sptr_pc_output_buffers_full_var(self, *args)

    def pc_work_time(self) -> "float":
        r"""pc_work_time(crc32_bb_sptr self) -> float"""
        return _digital_swig0.crc32_bb_sptr_pc_work_time(self)

    def pc_work_time_avg(self) -> "float":
        r"""pc_work_time_avg(crc32_bb_sptr self) -> float"""
        return _digital_swig0.crc32_bb_sptr_pc_work_time_avg(self)

    def pc_work_time_var(self) -> "float":
        r"""pc_work_time_var(crc32_bb_sptr self) -> float"""
        return _digital_swig0.crc32_bb_sptr_pc_work_time_var(self)

    def pc_work_time_total(self) -> "float":
        r"""pc_work_time_total(crc32_bb_sptr self) -> float"""
        return _digital_swig0.crc32_bb_sptr_pc_work_time_total(self)

    def pc_throughput_avg(self) -> "float":
        r"""pc_throughput_avg(crc32_bb_sptr self) -> float"""
        return _digital_swig0.crc32_bb_sptr_pc_throughput_avg(self)

    def set_processor_affinity(self, mask: "std::vector< int,std::allocator< int > > const &") -> "void":
        r"""set_processor_affinity(crc32_bb_sptr self, std::vector< int,std::allocator< int > > const & mask)"""
        return _digital_swig0.crc32_bb_sptr_set_processor_affinity(self, mask)

    def unset_processor_affinity(self) -> "void":
        r"""unset_processor_affinity(crc32_bb_sptr self)"""
        return _digital_swig0.crc32_bb_sptr_unset_processor_affinity(self)

    def processor_affinity(self) -> "std::vector< int,std::allocator< int > >":
        r"""processor_affinity(crc32_bb_sptr self) -> std::vector< int,std::allocator< int > >"""
        return _digital_swig0.crc32_bb_sptr_processor_affinity(self)

    def active_thread_priority(self) -> "int":
        r"""active_thread_priority(crc32_bb_sptr self) -> int"""
        return _digital_swig0.crc32_bb_sptr_active_thread_priority(self)

    def thread_priority(self) -> "int":
        r"""thread_priority(crc32_bb_sptr self) -> int"""
        return _digital_swig0.crc32_bb_sptr_thread_priority(self)

    def set_thread_priority(self, priority: "int") -> "int":
        r"""set_thread_priority(crc32_bb_sptr self, int priority) -> int"""
        return _digital_swig0.crc32_bb_sptr_set_thread_priority(self, priority)

    def name(self) -> "std::string":
        r"""name(crc32_bb_sptr self) -> std::string"""
        return _digital_swig0.crc32_bb_sptr_name(self)

    def symbol_name(self) -> "std::string":
        r"""symbol_name(crc32_bb_sptr self) -> std::string"""
        return _digital_swig0.crc32_bb_sptr_symbol_name(self)

    def input_signature(self) -> "gr::io_signature::sptr":
        r"""input_signature(crc32_bb_sptr self) -> io_signature_sptr"""
        return _digital_swig0.crc32_bb_sptr_input_signature(self)

    def output_signature(self) -> "gr::io_signature::sptr":
        r"""output_signature(crc32_bb_sptr self) -> io_signature_sptr"""
        return _digital_swig0.crc32_bb_sptr_output_signature(self)

    def unique_id(self) -> "long":
        r"""unique_id(crc32_bb_sptr self) -> long"""
        return _digital_swig0.crc32_bb_sptr_unique_id(self)

    def to_basic_block(self) -> "gr::basic_block_sptr":
        r"""to_basic_block(crc32_bb_sptr self) -> basic_block_sptr"""
        return _digital_swig0.crc32_bb_sptr_to_basic_block(self)

    def check_topology(self, ninputs: "int", noutputs: "int") -> "bool":
        r"""check_topology(crc32_bb_sptr self, int ninputs, int noutputs) -> bool"""
        return _digital_swig0.crc32_bb_sptr_check_topology(self, ninputs, noutputs)

    def alias(self) -> "std::string":
        r"""alias(crc32_bb_sptr self) -> std::string"""
        return _digital_swig0.crc32_bb_sptr_alias(self)

    def set_block_alias(self, name: "std::string") -> "void":
        r"""set_block_alias(crc32_bb_sptr self, std::string name)"""
        return _digital_swig0.crc32_bb_sptr_set_block_alias(self, name)

    def _post(self, which_port: "swig_pmt_ptr", msg: "swig_pmt_ptr") -> "void":
        r"""_post(crc32_bb_sptr self, swig_pmt_ptr which_port, swig_pmt_ptr msg)"""
        return _digital_swig0.crc32_bb_sptr__post(self, which_port, msg)

    def message_ports_in(self) -> "pmt::pmt_t":
        r"""message_ports_in(crc32_bb_sptr self) -> swig_pmt_ptr"""
        return _digital_swig0.crc32_bb_sptr_message_ports_in(self)

    def message_ports_out(self) -> "pmt::pmt_t":
        r"""message_ports_out(crc32_bb_sptr self) -> swig_pmt_ptr"""
        return _digital_swig0.crc32_bb_sptr_message_ports_out(self)

    def message_subscribers(self, which_port: "swig_pmt_ptr") -> "pmt::pmt_t":
        r"""message_subscribers(crc32_bb_sptr self, swig_pmt_ptr which_port) -> swig_pmt_ptr"""
        return _digital_swig0.crc32_bb_sptr_message_subscribers(self, which_port)

# Register crc32_bb_sptr in _digital_swig0:
_digital_swig0.crc32_bb_sptr_swigregister(crc32_bb_sptr)

crc32_bb_sptr.__repr__ = lambda self: "<gr_block %s (%d)>" % (self.name(), self.unique_id())
crc32_bb = crc32_bb.make;

class crc32_async_bb_sptr(object):
    r"""Proxy of C++ boost::shared_ptr< gr::digital::crc32_async_bb > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(crc32_async_bb_sptr self) -> crc32_async_bb_sptr
        __init__(crc32_async_bb_sptr self, crc32_async_bb p) -> crc32_async_bb_sptr
        """
        _digital_swig0.crc32_async_bb_sptr_swiginit(self, _digital_swig0.new_crc32_async_bb_sptr(*args))

    def __deref__(self) -> "gr::digital::crc32_async_bb *":
        r"""__deref__(crc32_async_bb_sptr self) -> crc32_async_bb"""
        return _digital_swig0.crc32_async_bb_sptr___deref__(self)
    __swig_destroy__ = _digital_swig0.delete_crc32_async_bb_sptr

    def make(self, check: "bool"=False) -> "gr::digital::crc32_async_bb::sptr":
        r"""
        make(crc32_async_bb_sptr self, bool check=False) -> crc32_async_bb_sptr
        Byte-stream CRC block for async messages.

        Processes packets (as async PDU messages) for CRC32. The  parameter determines if the block acts to check and strip the CRC or to calculate and append the CRC32.


        The input PDU is expected to be a message of packet bytes.


        When using check mode, if the CRC passes, the output is a payload of the message with the CRC stripped, so the output will be 4 bytes smaller than the input.


        When using calculate mode (check == false), then the CRC is calculated on the PDU and appended to it. The output is then 4 bytes longer than the input.


        This block implements the CRC32 using the Boost crc_optimal class for 32-bit CRCs with the standard generator 0x04C11DB7.

        Constructor Specific Documentation:



        Args:
            check : Set to true if you want to check CRC, false to create CRC.
        """
        return _digital_swig0.crc32_async_bb_sptr_make(self, check)

    def history(self) -> "unsigned int":
        r"""history(crc32_async_bb_sptr self) -> unsigned int"""
        return _digital_swig0.crc32_async_bb_sptr_history(self)

    def declare_sample_delay(self, *args) -> "void":
        r"""
        declare_sample_delay(crc32_async_bb_sptr self, int which, int delay)
        declare_sample_delay(crc32_async_bb_sptr self, unsigned int delay)
        """
        return _digital_swig0.crc32_async_bb_sptr_declare_sample_delay(self, *args)

    def sample_delay(self, which: "int") -> "unsigned int":
        r"""sample_delay(crc32_async_bb_sptr self, int which) -> unsigned int"""
        return _digital_swig0.crc32_async_bb_sptr_sample_delay(self, which)

    def set_output_multiple(self, multiple: "int") -> "void":
        r"""set_output_multiple(crc32_async_bb_sptr self, int multiple)"""
        return _digital_swig0.crc32_async_bb_sptr_set_output_multiple(self, multiple)

    def output_multiple(self) -> "int":
        r"""output_multiple(crc32_async_bb_sptr self) -> int"""
        return _digital_swig0.crc32_async_bb_sptr_output_multiple(self)

    def relative_rate(self) -> "double":
        r"""relative_rate(crc32_async_bb_sptr self) -> double"""
        return _digital_swig0.crc32_async_bb_sptr_relative_rate(self)

    def relative_rate_i(self) -> "uint64_t":
        r"""relative_rate_i(crc32_async_bb_sptr self) -> uint64_t"""
        return _digital_swig0.crc32_async_bb_sptr_relative_rate_i(self)

    def relative_rate_d(self) -> "uint64_t":
        r"""relative_rate_d(crc32_async_bb_sptr self) -> uint64_t"""
        return _digital_swig0.crc32_async_bb_sptr_relative_rate_d(self)

    def start(self) -> "bool":
        r"""start(crc32_async_bb_sptr self) -> bool"""
        return _digital_swig0.crc32_async_bb_sptr_start(self)

    def stop(self) -> "bool":
        r"""stop(crc32_async_bb_sptr self) -> bool"""
        return _digital_swig0.crc32_async_bb_sptr_stop(self)

    def nitems_read(self, which_input: "unsigned int") -> "uint64_t":
        r"""nitems_read(crc32_async_bb_sptr self, unsigned int which_input) -> uint64_t"""
        return _digital_swig0.crc32_async_bb_sptr_nitems_read(self, which_input)

    def nitems_written(self, which_output: "unsigned int") -> "uint64_t":
        r"""nitems_written(crc32_async_bb_sptr self, unsigned int which_output) -> uint64_t"""
        return _digital_swig0.crc32_async_bb_sptr_nitems_written(self, which_output)

    def set_log_level(self, level: "std::string") -> "void":
        r"""set_log_level(crc32_async_bb_sptr self, std::string level)"""
        return _digital_swig0.crc32_async_bb_sptr_set_log_level(self, level)

    def log_level(self) -> "std::string":
        r"""log_level(crc32_async_bb_sptr self) -> std::string"""
        return _digital_swig0.crc32_async_bb_sptr_log_level(self)

    def max_noutput_items(self) -> "int":
        r"""max_noutput_items(crc32_async_bb_sptr self) -> int"""
        return _digital_swig0.crc32_async_bb_sptr_max_noutput_items(self)

    def set_max_noutput_items(self, m: "int") -> "void":
        r"""set_max_noutput_items(crc32_async_bb_sptr self, int m)"""
        return _digital_swig0.crc32_async_bb_sptr_set_max_noutput_items(self, m)

    def unset_max_noutput_items(self) -> "void":
        r"""unset_max_noutput_items(crc32_async_bb_sptr self)"""
        return _digital_swig0.crc32_async_bb_sptr_unset_max_noutput_items(self)

    def is_set_max_noutput_items(self) -> "bool":
        r"""is_set_max_noutput_items(crc32_async_bb_sptr self) -> bool"""
        return _digital_swig0.crc32_async_bb_sptr_is_set_max_noutput_items(self)

    def set_min_noutput_items(self, m: "int") -> "void":
        r"""set_min_noutput_items(crc32_async_bb_sptr self, int m)"""
        return _digital_swig0.crc32_async_bb_sptr_set_min_noutput_items(self, m)

    def min_noutput_items(self) -> "int":
        r"""min_noutput_items(crc32_async_bb_sptr self) -> int"""
        return _digital_swig0.crc32_async_bb_sptr_min_noutput_items(self)

    def max_output_buffer(self, i: "int") -> "long":
        r"""max_output_buffer(crc32_async_bb_sptr self, int i) -> long"""
        return _digital_swig0.crc32_async_bb_sptr_max_output_buffer(self, i)

    def set_max_output_buffer(self, *args) -> "void":
        r"""
        set_max_output_buffer(crc32_async_bb_sptr self, long max_output_buffer)
        set_max_output_buffer(crc32_async_bb_sptr self, int port, long max_output_buffer)
        """
        return _digital_swig0.crc32_async_bb_sptr_set_max_output_buffer(self, *args)

    def min_output_buffer(self, i: "int") -> "long":
        r"""min_output_buffer(crc32_async_bb_sptr self, int i) -> long"""
        return _digital_swig0.crc32_async_bb_sptr_min_output_buffer(self, i)

    def set_min_output_buffer(self, *args) -> "void":
        r"""
        set_min_output_buffer(crc32_async_bb_sptr self, long min_output_buffer)
        set_min_output_buffer(crc32_async_bb_sptr self, int port, long min_output_buffer)
        """
        return _digital_swig0.crc32_async_bb_sptr_set_min_output_buffer(self, *args)

    def pc_noutput_items(self) -> "float":
        r"""pc_noutput_items(crc32_async_bb_sptr self) -> float"""
        return _digital_swig0.crc32_async_bb_sptr_pc_noutput_items(self)

    def pc_noutput_items_avg(self) -> "float":
        r"""pc_noutput_items_avg(crc32_async_bb_sptr self) -> float"""
        return _digital_swig0.crc32_async_bb_sptr_pc_noutput_items_avg(self)

    def pc_noutput_items_var(self) -> "float":
        r"""pc_noutput_items_var(crc32_async_bb_sptr self) -> float"""
        return _digital_swig0.crc32_async_bb_sptr_pc_noutput_items_var(self)

    def pc_nproduced(self) -> "float":
        r"""pc_nproduced(crc32_async_bb_sptr self) -> float"""
        return _digital_swig0.crc32_async_bb_sptr_pc_nproduced(self)

    def pc_nproduced_avg(self) -> "float":
        r"""pc_nproduced_avg(crc32_async_bb_sptr self) -> float"""
        return _digital_swig0.crc32_async_bb_sptr_pc_nproduced_avg(self)

    def pc_nproduced_var(self) -> "float":
        r"""pc_nproduced_var(crc32_async_bb_sptr self) -> float"""
        return _digital_swig0.crc32_async_bb_sptr_pc_nproduced_var(self)

    def pc_input_buffers_full(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full(crc32_async_bb_sptr self, int which) -> float
        pc_input_buffers_full(crc32_async_bb_sptr self) -> pmt_vector_float
        """
        return _digital_swig0.crc32_async_bb_sptr_pc_input_buffers_full(self, *args)

    def pc_input_buffers_full_avg(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full_avg(crc32_async_bb_sptr self, int which) -> float
        pc_input_buffers_full_avg(crc32_async_bb_sptr self) -> pmt_vector_float
        """
        return _digital_swig0.crc32_async_bb_sptr_pc_input_buffers_full_avg(self, *args)

    def pc_input_buffers_full_var(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full_var(crc32_async_bb_sptr self, int which) -> float
        pc_input_buffers_full_var(crc32_async_bb_sptr self) -> pmt_vector_float
        """
        return _digital_swig0.crc32_async_bb_sptr_pc_input_buffers_full_var(self, *args)

    def pc_output_buffers_full(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full(crc32_async_bb_sptr self, int which) -> float
        pc_output_buffers_full(crc32_async_bb_sptr self) -> pmt_vector_float
        """
        return _digital_swig0.crc32_async_bb_sptr_pc_output_buffers_full(self, *args)

    def pc_output_buffers_full_avg(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full_avg(crc32_async_bb_sptr self, int which) -> float
        pc_output_buffers_full_avg(crc32_async_bb_sptr self) -> pmt_vector_float
        """
        return _digital_swig0.crc32_async_bb_sptr_pc_output_buffers_full_avg(self, *args)

    def pc_output_buffers_full_var(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full_var(crc32_async_bb_sptr self, int which) -> float
        pc_output_buffers_full_var(crc32_async_bb_sptr self) -> pmt_vector_float
        """
        return _digital_swig0.crc32_async_bb_sptr_pc_output_buffers_full_var(self, *args)

    def pc_work_time(self) -> "float":
        r"""pc_work_time(crc32_async_bb_sptr self) -> float"""
        return _digital_swig0.crc32_async_bb_sptr_pc_work_time(self)

    def pc_work_time_avg(self) -> "float":
        r"""pc_work_time_avg(crc32_async_bb_sptr self) -> float"""
        return _digital_swig0.crc32_async_bb_sptr_pc_work_time_avg(self)

    def pc_work_time_var(self) -> "float":
        r"""pc_work_time_var(crc32_async_bb_sptr self) -> float"""
        return _digital_swig0.crc32_async_bb_sptr_pc_work_time_var(self)

    def pc_work_time_total(self) -> "float":
        r"""pc_work_time_total(crc32_async_bb_sptr self) -> float"""
        return _digital_swig0.crc32_async_bb_sptr_pc_work_time_total(self)

    def pc_throughput_avg(self) -> "float":
        r"""pc_throughput_avg(crc32_async_bb_sptr self) -> float"""
        return _digital_swig0.crc32_async_bb_sptr_pc_throughput_avg(self)

    def set_processor_affinity(self, mask: "std::vector< int,std::allocator< int > > const &") -> "void":
        r"""set_processor_affinity(crc32_async_bb_sptr self, std::vector< int,std::allocator< int > > const & mask)"""
        return _digital_swig0.crc32_async_bb_sptr_set_processor_affinity(self, mask)

    def unset_processor_affinity(self) -> "void":
        r"""unset_processor_affinity(crc32_async_bb_sptr self)"""
        return _digital_swig0.crc32_async_bb_sptr_unset_processor_affinity(self)

    def processor_affinity(self) -> "std::vector< int,std::allocator< int > >":
        r"""processor_affinity(crc32_async_bb_sptr self) -> std::vector< int,std::allocator< int > >"""
        return _digital_swig0.crc32_async_bb_sptr_processor_affinity(self)

    def active_thread_priority(self) -> "int":
        r"""active_thread_priority(crc32_async_bb_sptr self) -> int"""
        return _digital_swig0.crc32_async_bb_sptr_active_thread_priority(self)

    def thread_priority(self) -> "int":
        r"""thread_priority(crc32_async_bb_sptr self) -> int"""
        return _digital_swig0.crc32_async_bb_sptr_thread_priority(self)

    def set_thread_priority(self, priority: "int") -> "int":
        r"""set_thread_priority(crc32_async_bb_sptr self, int priority) -> int"""
        return _digital_swig0.crc32_async_bb_sptr_set_thread_priority(self, priority)

    def name(self) -> "std::string":
        r"""name(crc32_async_bb_sptr self) -> std::string"""
        return _digital_swig0.crc32_async_bb_sptr_name(self)

    def symbol_name(self) -> "std::string":
        r"""symbol_name(crc32_async_bb_sptr self) -> std::string"""
        return _digital_swig0.crc32_async_bb_sptr_symbol_name(self)

    def input_signature(self) -> "gr::io_signature::sptr":
        r"""input_signature(crc32_async_bb_sptr self) -> io_signature_sptr"""
        return _digital_swig0.crc32_async_bb_sptr_input_signature(self)

    def output_signature(self) -> "gr::io_signature::sptr":
        r"""output_signature(crc32_async_bb_sptr self) -> io_signature_sptr"""
        return _digital_swig0.crc32_async_bb_sptr_output_signature(self)

    def unique_id(self) -> "long":
        r"""unique_id(crc32_async_bb_sptr self) -> long"""
        return _digital_swig0.crc32_async_bb_sptr_unique_id(self)

    def to_basic_block(self) -> "gr::basic_block_sptr":
        r"""to_basic_block(crc32_async_bb_sptr self) -> basic_block_sptr"""
        return _digital_swig0.crc32_async_bb_sptr_to_basic_block(self)

    def check_topology(self, ninputs: "int", noutputs: "int") -> "bool":
        r"""check_topology(crc32_async_bb_sptr self, int ninputs, int noutputs) -> bool"""
        return _digital_swig0.crc32_async_bb_sptr_check_topology(self, ninputs, noutputs)

    def alias(self) -> "std::string":
        r"""alias(crc32_async_bb_sptr self) -> std::string"""
        return _digital_swig0.crc32_async_bb_sptr_alias(self)

    def set_block_alias(self, name: "std::string") -> "void":
        r"""set_block_alias(crc32_async_bb_sptr self, std::string name)"""
        return _digital_swig0.crc32_async_bb_sptr_set_block_alias(self, name)

    def _post(self, which_port: "swig_pmt_ptr", msg: "swig_pmt_ptr") -> "void":
        r"""_post(crc32_async_bb_sptr self, swig_pmt_ptr which_port, swig_pmt_ptr msg)"""
        return _digital_swig0.crc32_async_bb_sptr__post(self, which_port, msg)

    def message_ports_in(self) -> "pmt::pmt_t":
        r"""message_ports_in(crc32_async_bb_sptr self) -> swig_pmt_ptr"""
        return _digital_swig0.crc32_async_bb_sptr_message_ports_in(self)

    def message_ports_out(self) -> "pmt::pmt_t":
        r"""message_ports_out(crc32_async_bb_sptr self) -> swig_pmt_ptr"""
        return _digital_swig0.crc32_async_bb_sptr_message_ports_out(self)

    def message_subscribers(self, which_port: "swig_pmt_ptr") -> "pmt::pmt_t":
        r"""message_subscribers(crc32_async_bb_sptr self, swig_pmt_ptr which_port) -> swig_pmt_ptr"""
        return _digital_swig0.crc32_async_bb_sptr_message_subscribers(self, which_port)

# Register crc32_async_bb_sptr in _digital_swig0:
_digital_swig0.crc32_async_bb_sptr_swigregister(crc32_async_bb_sptr)

crc32_async_bb_sptr.__repr__ = lambda self: "<gr_block %s (%d)>" % (self.name(), self.unique_id())
crc32_async_bb = crc32_async_bb.make;

class cpmmod_bc_sptr(object):
    r"""Proxy of C++ boost::shared_ptr< gr::digital::cpmmod_bc > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(cpmmod_bc_sptr self) -> cpmmod_bc_sptr
        __init__(cpmmod_bc_sptr self, cpmmod_bc p) -> cpmmod_bc_sptr
        """
        _digital_swig0.cpmmod_bc_sptr_swiginit(self, _digital_swig0.new_cpmmod_bc_sptr(*args))

    def __deref__(self) -> "gr::digital::cpmmod_bc *":
        r"""__deref__(cpmmod_bc_sptr self) -> cpmmod_bc"""
        return _digital_swig0.cpmmod_bc_sptr___deref__(self)
    __swig_destroy__ = _digital_swig0.delete_cpmmod_bc_sptr

    def make(self, type: "gr::analog::cpm::cpm_type", h: "float", samples_per_sym: "int", L: "int", beta: "double"=0.3) -> "gr::digital::cpmmod_bc::sptr":
        r"""
        make(cpmmod_bc_sptr self, gr::analog::cpm::cpm_type type, float h, int samples_per_sym, int L, double beta=0.3) -> cpmmod_bc_sptr
        Generic CPM modulator.

        Examples:



        The input of this block are symbols from an M-ary alphabet +/-1, +/-3, ..., +/-(M-1). Usually, M = 2 and therefore, the valid inputs are +/-1. The modulator will silently accept any other inputs, though. The output is the phase-modulated signal.

        Constructor Specific Documentation:

        Make CPM modulator block.

        Args:
            type : The modulation type. Can be one of LREC, LRC, LSRC, TFM or GAUSSIAN. See gr_cpm::phase_response() for a detailed description.
            h : The modulation index.  is the maximum phase change that can occur between two symbols, i.e., if you only send ones, the phase will increase by   every  samples. Set this to 0.5 for Minimum Shift Keying variants.
            samples_per_sym : Samples per symbol.
            L : The length of the phase duration in symbols. For L=1, this yields full- response CPM symbols, for L > 1, partial-response.
            beta : For LSRC, this is the rolloff factor. For Gaussian pulses, this is the 3 dB time-bandwidth product.
        """
        return _digital_swig0.cpmmod_bc_sptr_make(self, type, h, samples_per_sym, L, beta)

    def make_gmskmod_bc(self, samples_per_sym: "int"=2, L: "int"=4, beta: "double"=0.3) -> "gr::digital::cpmmod_bc::sptr":
        r"""
        make_gmskmod_bc(cpmmod_bc_sptr self, int samples_per_sym=2, int L=4, double beta=0.3) -> cpmmod_bc_sptr
        Make GMSK modulator block.


        The type is GAUSSIAN and the modulation index for GMSK is 0.5. This are populated automatically by this factory function.
        """
        return _digital_swig0.cpmmod_bc_sptr_make_gmskmod_bc(self, samples_per_sym, L, beta)

    def taps(self) -> "std::vector< float,std::allocator< float > >":
        r"""
        taps(cpmmod_bc_sptr self) -> pmt_vector_float
        Return the phase response FIR taps.
        """
        return _digital_swig0.cpmmod_bc_sptr_taps(self)

    def type(self) -> "int":
        r"""
        type(cpmmod_bc_sptr self) -> int
        Return the type of CPM modulator.
        """
        return _digital_swig0.cpmmod_bc_sptr_type(self)

    def index(self) -> "float":
        r"""
        index(cpmmod_bc_sptr self) -> float
        Return the modulation index of the modulator.
        """
        return _digital_swig0.cpmmod_bc_sptr_index(self)

    def samples_per_sym(self) -> "int":
        r"""
        samples_per_sym(cpmmod_bc_sptr self) -> int
        Return the number of samples per symbol.
        """
        return _digital_swig0.cpmmod_bc_sptr_samples_per_sym(self)

    def length(self) -> "int":
        r"""
        length(cpmmod_bc_sptr self) -> int
        Return the length of the phase duration (in symbols)
        """
        return _digital_swig0.cpmmod_bc_sptr_length(self)

    def beta(self) -> "double":
        r"""
        beta(cpmmod_bc_sptr self) -> double
        Return the value of beta for the modulator.
        """
        return _digital_swig0.cpmmod_bc_sptr_beta(self)

    def primitive_connect(self, *args) -> "void":
        r"""
        primitive_connect(cpmmod_bc_sptr self, basic_block_sptr block)
        primitive_connect(cpmmod_bc_sptr self, basic_block_sptr src, int src_port, basic_block_sptr dst, int dst_port)
        """
        return _digital_swig0.cpmmod_bc_sptr_primitive_connect(self, *args)

    def primitive_msg_connect(self, *args) -> "void":
        r"""
        primitive_msg_connect(cpmmod_bc_sptr self, basic_block_sptr src, swig_pmt_ptr srcport, basic_block_sptr dst, swig_pmt_ptr dstport)
        primitive_msg_connect(cpmmod_bc_sptr self, basic_block_sptr src, std::string srcport, basic_block_sptr dst, std::string dstport)
        """
        return _digital_swig0.cpmmod_bc_sptr_primitive_msg_connect(self, *args)

    def primitive_msg_disconnect(self, *args) -> "void":
        r"""
        primitive_msg_disconnect(cpmmod_bc_sptr self, basic_block_sptr src, swig_pmt_ptr srcport, basic_block_sptr dst, swig_pmt_ptr dstport)
        primitive_msg_disconnect(cpmmod_bc_sptr self, basic_block_sptr src, std::string srcport, basic_block_sptr dst, std::string dstport)
        """
        return _digital_swig0.cpmmod_bc_sptr_primitive_msg_disconnect(self, *args)

    def primitive_disconnect(self, *args) -> "void":
        r"""
        primitive_disconnect(cpmmod_bc_sptr self, basic_block_sptr block)
        primitive_disconnect(cpmmod_bc_sptr self, basic_block_sptr src, int src_port, basic_block_sptr dst, int dst_port)
        """
        return _digital_swig0.cpmmod_bc_sptr_primitive_disconnect(self, *args)

    def disconnect_all(self) -> "void":
        r"""disconnect_all(cpmmod_bc_sptr self)"""
        return _digital_swig0.cpmmod_bc_sptr_disconnect_all(self)

    def lock(self) -> "void":
        r"""lock(cpmmod_bc_sptr self)"""
        return _digital_swig0.cpmmod_bc_sptr_lock(self)

    def unlock(self) -> "void":
        r"""unlock(cpmmod_bc_sptr self)"""
        return _digital_swig0.cpmmod_bc_sptr_unlock(self)

    def primitive_message_port_register_hier_in(self, port_id: "swig_pmt_ptr") -> "void":
        r"""primitive_message_port_register_hier_in(cpmmod_bc_sptr self, swig_pmt_ptr port_id)"""
        return _digital_swig0.cpmmod_bc_sptr_primitive_message_port_register_hier_in(self, port_id)

    def primitive_message_port_register_hier_out(self, port_id: "swig_pmt_ptr") -> "void":
        r"""primitive_message_port_register_hier_out(cpmmod_bc_sptr self, swig_pmt_ptr port_id)"""
        return _digital_swig0.cpmmod_bc_sptr_primitive_message_port_register_hier_out(self, port_id)

    def set_processor_affinity(self, mask: "std::vector< int,std::allocator< int > > const &") -> "void":
        r"""set_processor_affinity(cpmmod_bc_sptr self, std::vector< int,std::allocator< int > > const & mask)"""
        return _digital_swig0.cpmmod_bc_sptr_set_processor_affinity(self, mask)

    def unset_processor_affinity(self) -> "void":
        r"""unset_processor_affinity(cpmmod_bc_sptr self)"""
        return _digital_swig0.cpmmod_bc_sptr_unset_processor_affinity(self)

    def processor_affinity(self) -> "std::vector< int,std::allocator< int > >":
        r"""processor_affinity(cpmmod_bc_sptr self) -> std::vector< int,std::allocator< int > >"""
        return _digital_swig0.cpmmod_bc_sptr_processor_affinity(self)

    def set_log_level(self, level: "std::string") -> "void":
        r"""set_log_level(cpmmod_bc_sptr self, std::string level)"""
        return _digital_swig0.cpmmod_bc_sptr_set_log_level(self, level)

    def log_level(self) -> "std::string":
        r"""log_level(cpmmod_bc_sptr self) -> std::string"""
        return _digital_swig0.cpmmod_bc_sptr_log_level(self)

    def max_output_buffer(self, i: "int") -> "size_t":
        r"""max_output_buffer(cpmmod_bc_sptr self, int i) -> size_t"""
        return _digital_swig0.cpmmod_bc_sptr_max_output_buffer(self, i)

    def set_max_output_buffer(self, *args) -> "void":
        r"""
        set_max_output_buffer(cpmmod_bc_sptr self, size_t max_output_buffer)
        set_max_output_buffer(cpmmod_bc_sptr self, int port, size_t max_output_buffer)
        """
        return _digital_swig0.cpmmod_bc_sptr_set_max_output_buffer(self, *args)

    def min_output_buffer(self, i: "int") -> "size_t":
        r"""min_output_buffer(cpmmod_bc_sptr self, int i) -> size_t"""
        return _digital_swig0.cpmmod_bc_sptr_min_output_buffer(self, i)

    def set_min_output_buffer(self, *args) -> "void":
        r"""
        set_min_output_buffer(cpmmod_bc_sptr self, size_t min_output_buffer)
        set_min_output_buffer(cpmmod_bc_sptr self, int port, size_t min_output_buffer)
        """
        return _digital_swig0.cpmmod_bc_sptr_set_min_output_buffer(self, *args)

    def to_hier_block2(self) -> "gr::hier_block2_sptr":
        r"""to_hier_block2(cpmmod_bc_sptr self) -> hier_block2_sptr"""
        return _digital_swig0.cpmmod_bc_sptr_to_hier_block2(self)

    def name(self) -> "std::string":
        r"""name(cpmmod_bc_sptr self) -> std::string"""
        return _digital_swig0.cpmmod_bc_sptr_name(self)

    def symbol_name(self) -> "std::string":
        r"""symbol_name(cpmmod_bc_sptr self) -> std::string"""
        return _digital_swig0.cpmmod_bc_sptr_symbol_name(self)

    def input_signature(self) -> "gr::io_signature::sptr":
        r"""input_signature(cpmmod_bc_sptr self) -> io_signature_sptr"""
        return _digital_swig0.cpmmod_bc_sptr_input_signature(self)

    def output_signature(self) -> "gr::io_signature::sptr":
        r"""output_signature(cpmmod_bc_sptr self) -> io_signature_sptr"""
        return _digital_swig0.cpmmod_bc_sptr_output_signature(self)

    def unique_id(self) -> "long":
        r"""unique_id(cpmmod_bc_sptr self) -> long"""
        return _digital_swig0.cpmmod_bc_sptr_unique_id(self)

    def to_basic_block(self) -> "gr::basic_block_sptr":
        r"""to_basic_block(cpmmod_bc_sptr self) -> basic_block_sptr"""
        return _digital_swig0.cpmmod_bc_sptr_to_basic_block(self)

    def check_topology(self, ninputs: "int", noutputs: "int") -> "bool":
        r"""check_topology(cpmmod_bc_sptr self, int ninputs, int noutputs) -> bool"""
        return _digital_swig0.cpmmod_bc_sptr_check_topology(self, ninputs, noutputs)

    def alias(self) -> "std::string":
        r"""alias(cpmmod_bc_sptr self) -> std::string"""
        return _digital_swig0.cpmmod_bc_sptr_alias(self)

    def set_block_alias(self, name: "std::string") -> "void":
        r"""set_block_alias(cpmmod_bc_sptr self, std::string name)"""
        return _digital_swig0.cpmmod_bc_sptr_set_block_alias(self, name)

    def _post(self, which_port: "swig_pmt_ptr", msg: "swig_pmt_ptr") -> "void":
        r"""_post(cpmmod_bc_sptr self, swig_pmt_ptr which_port, swig_pmt_ptr msg)"""
        return _digital_swig0.cpmmod_bc_sptr__post(self, which_port, msg)

    def message_ports_in(self) -> "pmt::pmt_t":
        r"""message_ports_in(cpmmod_bc_sptr self) -> swig_pmt_ptr"""
        return _digital_swig0.cpmmod_bc_sptr_message_ports_in(self)

    def message_ports_out(self) -> "pmt::pmt_t":
        r"""message_ports_out(cpmmod_bc_sptr self) -> swig_pmt_ptr"""
        return _digital_swig0.cpmmod_bc_sptr_message_ports_out(self)

    def message_subscribers(self, which_port: "swig_pmt_ptr") -> "pmt::pmt_t":
        r"""message_subscribers(cpmmod_bc_sptr self, swig_pmt_ptr which_port) -> swig_pmt_ptr"""
        return _digital_swig0.cpmmod_bc_sptr_message_subscribers(self, which_port)

# Register cpmmod_bc_sptr in _digital_swig0:
_digital_swig0.cpmmod_bc_sptr_swigregister(cpmmod_bc_sptr)

cpmmod_bc_sptr.__repr__ = lambda self: "<gr_block %s (%d)>" % (self.name(), self.unique_id())
cpmmod_bc = cpmmod_bc.make;

class descrambler_bb_sptr(object):
    r"""Proxy of C++ boost::shared_ptr< gr::digital::descrambler_bb > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(descrambler_bb_sptr self) -> descrambler_bb_sptr
        __init__(descrambler_bb_sptr self, descrambler_bb p) -> descrambler_bb_sptr
        """
        _digital_swig0.descrambler_bb_sptr_swiginit(self, _digital_swig0.new_descrambler_bb_sptr(*args))

    def __deref__(self) -> "gr::digital::descrambler_bb *":
        r"""__deref__(descrambler_bb_sptr self) -> descrambler_bb"""
        return _digital_swig0.descrambler_bb_sptr___deref__(self)
    __swig_destroy__ = _digital_swig0.delete_descrambler_bb_sptr

    def make(self, mask: "int", seed: "int", len: "int") -> "gr::digital::descrambler_bb::sptr":
        r"""
        make(descrambler_bb_sptr self, int mask, int seed, int len) -> descrambler_bb_sptr
        Descramber an input stream using an LFSR.

        Descramble an input stream using an LFSR. This block works on the LSB only of the input data stream, i.e., on an "unpacked
        binary" stream, and produces the same format on its output.

        Constructor Specific Documentation:

        Make a descrambler block.

        Args:
            mask : Polynomial mask for LFSR
            seed : Initial shift register contents
            len : Shift register length
        """
        return _digital_swig0.descrambler_bb_sptr_make(self, mask, seed, len)

    def history(self) -> "unsigned int":
        r"""history(descrambler_bb_sptr self) -> unsigned int"""
        return _digital_swig0.descrambler_bb_sptr_history(self)

    def declare_sample_delay(self, *args) -> "void":
        r"""
        declare_sample_delay(descrambler_bb_sptr self, int which, int delay)
        declare_sample_delay(descrambler_bb_sptr self, unsigned int delay)
        """
        return _digital_swig0.descrambler_bb_sptr_declare_sample_delay(self, *args)

    def sample_delay(self, which: "int") -> "unsigned int":
        r"""sample_delay(descrambler_bb_sptr self, int which) -> unsigned int"""
        return _digital_swig0.descrambler_bb_sptr_sample_delay(self, which)

    def set_output_multiple(self, multiple: "int") -> "void":
        r"""set_output_multiple(descrambler_bb_sptr self, int multiple)"""
        return _digital_swig0.descrambler_bb_sptr_set_output_multiple(self, multiple)

    def output_multiple(self) -> "int":
        r"""output_multiple(descrambler_bb_sptr self) -> int"""
        return _digital_swig0.descrambler_bb_sptr_output_multiple(self)

    def relative_rate(self) -> "double":
        r"""relative_rate(descrambler_bb_sptr self) -> double"""
        return _digital_swig0.descrambler_bb_sptr_relative_rate(self)

    def relative_rate_i(self) -> "uint64_t":
        r"""relative_rate_i(descrambler_bb_sptr self) -> uint64_t"""
        return _digital_swig0.descrambler_bb_sptr_relative_rate_i(self)

    def relative_rate_d(self) -> "uint64_t":
        r"""relative_rate_d(descrambler_bb_sptr self) -> uint64_t"""
        return _digital_swig0.descrambler_bb_sptr_relative_rate_d(self)

    def start(self) -> "bool":
        r"""start(descrambler_bb_sptr self) -> bool"""
        return _digital_swig0.descrambler_bb_sptr_start(self)

    def stop(self) -> "bool":
        r"""stop(descrambler_bb_sptr self) -> bool"""
        return _digital_swig0.descrambler_bb_sptr_stop(self)

    def nitems_read(self, which_input: "unsigned int") -> "uint64_t":
        r"""nitems_read(descrambler_bb_sptr self, unsigned int which_input) -> uint64_t"""
        return _digital_swig0.descrambler_bb_sptr_nitems_read(self, which_input)

    def nitems_written(self, which_output: "unsigned int") -> "uint64_t":
        r"""nitems_written(descrambler_bb_sptr self, unsigned int which_output) -> uint64_t"""
        return _digital_swig0.descrambler_bb_sptr_nitems_written(self, which_output)

    def set_log_level(self, level: "std::string") -> "void":
        r"""set_log_level(descrambler_bb_sptr self, std::string level)"""
        return _digital_swig0.descrambler_bb_sptr_set_log_level(self, level)

    def log_level(self) -> "std::string":
        r"""log_level(descrambler_bb_sptr self) -> std::string"""
        return _digital_swig0.descrambler_bb_sptr_log_level(self)

    def max_noutput_items(self) -> "int":
        r"""max_noutput_items(descrambler_bb_sptr self) -> int"""
        return _digital_swig0.descrambler_bb_sptr_max_noutput_items(self)

    def set_max_noutput_items(self, m: "int") -> "void":
        r"""set_max_noutput_items(descrambler_bb_sptr self, int m)"""
        return _digital_swig0.descrambler_bb_sptr_set_max_noutput_items(self, m)

    def unset_max_noutput_items(self) -> "void":
        r"""unset_max_noutput_items(descrambler_bb_sptr self)"""
        return _digital_swig0.descrambler_bb_sptr_unset_max_noutput_items(self)

    def is_set_max_noutput_items(self) -> "bool":
        r"""is_set_max_noutput_items(descrambler_bb_sptr self) -> bool"""
        return _digital_swig0.descrambler_bb_sptr_is_set_max_noutput_items(self)

    def set_min_noutput_items(self, m: "int") -> "void":
        r"""set_min_noutput_items(descrambler_bb_sptr self, int m)"""
        return _digital_swig0.descrambler_bb_sptr_set_min_noutput_items(self, m)

    def min_noutput_items(self) -> "int":
        r"""min_noutput_items(descrambler_bb_sptr self) -> int"""
        return _digital_swig0.descrambler_bb_sptr_min_noutput_items(self)

    def max_output_buffer(self, i: "int") -> "long":
        r"""max_output_buffer(descrambler_bb_sptr self, int i) -> long"""
        return _digital_swig0.descrambler_bb_sptr_max_output_buffer(self, i)

    def set_max_output_buffer(self, *args) -> "void":
        r"""
        set_max_output_buffer(descrambler_bb_sptr self, long max_output_buffer)
        set_max_output_buffer(descrambler_bb_sptr self, int port, long max_output_buffer)
        """
        return _digital_swig0.descrambler_bb_sptr_set_max_output_buffer(self, *args)

    def min_output_buffer(self, i: "int") -> "long":
        r"""min_output_buffer(descrambler_bb_sptr self, int i) -> long"""
        return _digital_swig0.descrambler_bb_sptr_min_output_buffer(self, i)

    def set_min_output_buffer(self, *args) -> "void":
        r"""
        set_min_output_buffer(descrambler_bb_sptr self, long min_output_buffer)
        set_min_output_buffer(descrambler_bb_sptr self, int port, long min_output_buffer)
        """
        return _digital_swig0.descrambler_bb_sptr_set_min_output_buffer(self, *args)

    def pc_noutput_items(self) -> "float":
        r"""pc_noutput_items(descrambler_bb_sptr self) -> float"""
        return _digital_swig0.descrambler_bb_sptr_pc_noutput_items(self)

    def pc_noutput_items_avg(self) -> "float":
        r"""pc_noutput_items_avg(descrambler_bb_sptr self) -> float"""
        return _digital_swig0.descrambler_bb_sptr_pc_noutput_items_avg(self)

    def pc_noutput_items_var(self) -> "float":
        r"""pc_noutput_items_var(descrambler_bb_sptr self) -> float"""
        return _digital_swig0.descrambler_bb_sptr_pc_noutput_items_var(self)

    def pc_nproduced(self) -> "float":
        r"""pc_nproduced(descrambler_bb_sptr self) -> float"""
        return _digital_swig0.descrambler_bb_sptr_pc_nproduced(self)

    def pc_nproduced_avg(self) -> "float":
        r"""pc_nproduced_avg(descrambler_bb_sptr self) -> float"""
        return _digital_swig0.descrambler_bb_sptr_pc_nproduced_avg(self)

    def pc_nproduced_var(self) -> "float":
        r"""pc_nproduced_var(descrambler_bb_sptr self) -> float"""
        return _digital_swig0.descrambler_bb_sptr_pc_nproduced_var(self)

    def pc_input_buffers_full(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full(descrambler_bb_sptr self, int which) -> float
        pc_input_buffers_full(descrambler_bb_sptr self) -> pmt_vector_float
        """
        return _digital_swig0.descrambler_bb_sptr_pc_input_buffers_full(self, *args)

    def pc_input_buffers_full_avg(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full_avg(descrambler_bb_sptr self, int which) -> float
        pc_input_buffers_full_avg(descrambler_bb_sptr self) -> pmt_vector_float
        """
        return _digital_swig0.descrambler_bb_sptr_pc_input_buffers_full_avg(self, *args)

    def pc_input_buffers_full_var(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full_var(descrambler_bb_sptr self, int which) -> float
        pc_input_buffers_full_var(descrambler_bb_sptr self) -> pmt_vector_float
        """
        return _digital_swig0.descrambler_bb_sptr_pc_input_buffers_full_var(self, *args)

    def pc_output_buffers_full(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full(descrambler_bb_sptr self, int which) -> float
        pc_output_buffers_full(descrambler_bb_sptr self) -> pmt_vector_float
        """
        return _digital_swig0.descrambler_bb_sptr_pc_output_buffers_full(self, *args)

    def pc_output_buffers_full_avg(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full_avg(descrambler_bb_sptr self, int which) -> float
        pc_output_buffers_full_avg(descrambler_bb_sptr self) -> pmt_vector_float
        """
        return _digital_swig0.descrambler_bb_sptr_pc_output_buffers_full_avg(self, *args)

    def pc_output_buffers_full_var(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full_var(descrambler_bb_sptr self, int which) -> float
        pc_output_buffers_full_var(descrambler_bb_sptr self) -> pmt_vector_float
        """
        return _digital_swig0.descrambler_bb_sptr_pc_output_buffers_full_var(self, *args)

    def pc_work_time(self) -> "float":
        r"""pc_work_time(descrambler_bb_sptr self) -> float"""
        return _digital_swig0.descrambler_bb_sptr_pc_work_time(self)

    def pc_work_time_avg(self) -> "float":
        r"""pc_work_time_avg(descrambler_bb_sptr self) -> float"""
        return _digital_swig0.descrambler_bb_sptr_pc_work_time_avg(self)

    def pc_work_time_var(self) -> "float":
        r"""pc_work_time_var(descrambler_bb_sptr self) -> float"""
        return _digital_swig0.descrambler_bb_sptr_pc_work_time_var(self)

    def pc_work_time_total(self) -> "float":
        r"""pc_work_time_total(descrambler_bb_sptr self) -> float"""
        return _digital_swig0.descrambler_bb_sptr_pc_work_time_total(self)

    def pc_throughput_avg(self) -> "float":
        r"""pc_throughput_avg(descrambler_bb_sptr self) -> float"""
        return _digital_swig0.descrambler_bb_sptr_pc_throughput_avg(self)

    def set_processor_affinity(self, mask: "std::vector< int,std::allocator< int > > const &") -> "void":
        r"""set_processor_affinity(descrambler_bb_sptr self, std::vector< int,std::allocator< int > > const & mask)"""
        return _digital_swig0.descrambler_bb_sptr_set_processor_affinity(self, mask)

    def unset_processor_affinity(self) -> "void":
        r"""unset_processor_affinity(descrambler_bb_sptr self)"""
        return _digital_swig0.descrambler_bb_sptr_unset_processor_affinity(self)

    def processor_affinity(self) -> "std::vector< int,std::allocator< int > >":
        r"""processor_affinity(descrambler_bb_sptr self) -> std::vector< int,std::allocator< int > >"""
        return _digital_swig0.descrambler_bb_sptr_processor_affinity(self)

    def active_thread_priority(self) -> "int":
        r"""active_thread_priority(descrambler_bb_sptr self) -> int"""
        return _digital_swig0.descrambler_bb_sptr_active_thread_priority(self)

    def thread_priority(self) -> "int":
        r"""thread_priority(descrambler_bb_sptr self) -> int"""
        return _digital_swig0.descrambler_bb_sptr_thread_priority(self)

    def set_thread_priority(self, priority: "int") -> "int":
        r"""set_thread_priority(descrambler_bb_sptr self, int priority) -> int"""
        return _digital_swig0.descrambler_bb_sptr_set_thread_priority(self, priority)

    def name(self) -> "std::string":
        r"""name(descrambler_bb_sptr self) -> std::string"""
        return _digital_swig0.descrambler_bb_sptr_name(self)

    def symbol_name(self) -> "std::string":
        r"""symbol_name(descrambler_bb_sptr self) -> std::string"""
        return _digital_swig0.descrambler_bb_sptr_symbol_name(self)

    def input_signature(self) -> "gr::io_signature::sptr":
        r"""input_signature(descrambler_bb_sptr self) -> io_signature_sptr"""
        return _digital_swig0.descrambler_bb_sptr_input_signature(self)

    def output_signature(self) -> "gr::io_signature::sptr":
        r"""output_signature(descrambler_bb_sptr self) -> io_signature_sptr"""
        return _digital_swig0.descrambler_bb_sptr_output_signature(self)

    def unique_id(self) -> "long":
        r"""unique_id(descrambler_bb_sptr self) -> long"""
        return _digital_swig0.descrambler_bb_sptr_unique_id(self)

    def to_basic_block(self) -> "gr::basic_block_sptr":
        r"""to_basic_block(descrambler_bb_sptr self) -> basic_block_sptr"""
        return _digital_swig0.descrambler_bb_sptr_to_basic_block(self)

    def check_topology(self, ninputs: "int", noutputs: "int") -> "bool":
        r"""check_topology(descrambler_bb_sptr self, int ninputs, int noutputs) -> bool"""
        return _digital_swig0.descrambler_bb_sptr_check_topology(self, ninputs, noutputs)

    def alias(self) -> "std::string":
        r"""alias(descrambler_bb_sptr self) -> std::string"""
        return _digital_swig0.descrambler_bb_sptr_alias(self)

    def set_block_alias(self, name: "std::string") -> "void":
        r"""set_block_alias(descrambler_bb_sptr self, std::string name)"""
        return _digital_swig0.descrambler_bb_sptr_set_block_alias(self, name)

    def _post(self, which_port: "swig_pmt_ptr", msg: "swig_pmt_ptr") -> "void":
        r"""_post(descrambler_bb_sptr self, swig_pmt_ptr which_port, swig_pmt_ptr msg)"""
        return _digital_swig0.descrambler_bb_sptr__post(self, which_port, msg)

    def message_ports_in(self) -> "pmt::pmt_t":
        r"""message_ports_in(descrambler_bb_sptr self) -> swig_pmt_ptr"""
        return _digital_swig0.descrambler_bb_sptr_message_ports_in(self)

    def message_ports_out(self) -> "pmt::pmt_t":
        r"""message_ports_out(descrambler_bb_sptr self) -> swig_pmt_ptr"""
        return _digital_swig0.descrambler_bb_sptr_message_ports_out(self)

    def message_subscribers(self, which_port: "swig_pmt_ptr") -> "pmt::pmt_t":
        r"""message_subscribers(descrambler_bb_sptr self, swig_pmt_ptr which_port) -> swig_pmt_ptr"""
        return _digital_swig0.descrambler_bb_sptr_message_subscribers(self, which_port)

# Register descrambler_bb_sptr in _digital_swig0:
_digital_swig0.descrambler_bb_sptr_swigregister(descrambler_bb_sptr)

descrambler_bb_sptr.__repr__ = lambda self: "<gr_block %s (%d)>" % (self.name(), self.unique_id())
descrambler_bb = descrambler_bb.make;

class lms_dd_equalizer_cc_sptr(object):
    r"""Proxy of C++ boost::shared_ptr< gr::digital::lms_dd_equalizer_cc > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(lms_dd_equalizer_cc_sptr self) -> lms_dd_equalizer_cc_sptr
        __init__(lms_dd_equalizer_cc_sptr self, lms_dd_equalizer_cc p) -> lms_dd_equalizer_cc_sptr
        """
        _digital_swig0.lms_dd_equalizer_cc_sptr_swiginit(self, _digital_swig0.new_lms_dd_equalizer_cc_sptr(*args))

    def __deref__(self) -> "gr::digital::lms_dd_equalizer_cc *":
        r"""__deref__(lms_dd_equalizer_cc_sptr self) -> lms_dd_equalizer_cc"""
        return _digital_swig0.lms_dd_equalizer_cc_sptr___deref__(self)
    __swig_destroy__ = _digital_swig0.delete_lms_dd_equalizer_cc_sptr

    def make(self, num_taps: "int", mu: "float", sps: "int", cnst: "constellation_sptr") -> "gr::digital::lms_dd_equalizer_cc::sptr":
        r"""
        make(lms_dd_equalizer_cc_sptr self, int num_taps, float mu, int sps, constellation_sptr cnst) -> lms_dd_equalizer_cc_sptr
        Least-Mean-Square Decision Directed Equalizer (complex in/out)

        This block implements an LMS-based decision-directed equalizer. It uses a set of weights, w, to correlate against the inputs, u, and a decisions is then made from this output. The error in the decision is used to update the weight vector.


        y[n] = conj(w[n]) u[n] d[n] = decision(y[n]) e[n] = d[n] - y[n] w[n+1] = w[n] + mu u[n] conj(e[n])


        Where mu is a gain value (between 0 and 1 and usually small, around 0.001 - 0.01.


        This block uses the digital_constellation object for making the decision from y[n]. Create the constellation object for whatever constellation is to be used and pass in the object. In Python, you can use something like:


        self.constellation = digital.constellation_qpsk()


        To create a QPSK constellation (see the digital_constellation block for more details as to what constellations are available or how to create your own). You then pass the object to this block as an sptr, or using "self.constellation.base()".


        The theory for this algorithm can be found in Chapter 9 of: S. Haykin, Adaptive Filter Theory, Upper Saddle River, NJ: Prentice Hall, 1996.

        Constructor Specific Documentation:

        Make an LMS decision-directed equalizer

        Args:
            num_taps : Number of taps in the equalizer (channel size)
            mu : Gain of the update loop
            sps : Number of samples per symbol of the input signal
            cnst : A constellation derived from class 'constellation'. Use base() method to get a shared pointer to this base class type.
        """
        return _digital_swig0.lms_dd_equalizer_cc_sptr_make(self, num_taps, mu, sps, cnst)

    def set_taps(self, taps: "pmt_vector_cfloat") -> "void":
        r"""set_taps(lms_dd_equalizer_cc_sptr self, pmt_vector_cfloat taps)"""
        return _digital_swig0.lms_dd_equalizer_cc_sptr_set_taps(self, taps)

    def taps(self) -> "std::vector< gr_complex,std::allocator< gr_complex > >":
        r"""taps(lms_dd_equalizer_cc_sptr self) -> pmt_vector_cfloat"""
        return _digital_swig0.lms_dd_equalizer_cc_sptr_taps(self)

    def gain(self) -> "float":
        r"""gain(lms_dd_equalizer_cc_sptr self) -> float"""
        return _digital_swig0.lms_dd_equalizer_cc_sptr_gain(self)

    def set_gain(self, mu: "float") -> "void":
        r"""set_gain(lms_dd_equalizer_cc_sptr self, float mu)"""
        return _digital_swig0.lms_dd_equalizer_cc_sptr_set_gain(self, mu)

    def history(self) -> "unsigned int":
        r"""history(lms_dd_equalizer_cc_sptr self) -> unsigned int"""
        return _digital_swig0.lms_dd_equalizer_cc_sptr_history(self)

    def declare_sample_delay(self, *args) -> "void":
        r"""
        declare_sample_delay(lms_dd_equalizer_cc_sptr self, int which, int delay)
        declare_sample_delay(lms_dd_equalizer_cc_sptr self, unsigned int delay)
        """
        return _digital_swig0.lms_dd_equalizer_cc_sptr_declare_sample_delay(self, *args)

    def sample_delay(self, which: "int") -> "unsigned int":
        r"""sample_delay(lms_dd_equalizer_cc_sptr self, int which) -> unsigned int"""
        return _digital_swig0.lms_dd_equalizer_cc_sptr_sample_delay(self, which)

    def set_output_multiple(self, multiple: "int") -> "void":
        r"""set_output_multiple(lms_dd_equalizer_cc_sptr self, int multiple)"""
        return _digital_swig0.lms_dd_equalizer_cc_sptr_set_output_multiple(self, multiple)

    def output_multiple(self) -> "int":
        r"""output_multiple(lms_dd_equalizer_cc_sptr self) -> int"""
        return _digital_swig0.lms_dd_equalizer_cc_sptr_output_multiple(self)

    def relative_rate(self) -> "double":
        r"""relative_rate(lms_dd_equalizer_cc_sptr self) -> double"""
        return _digital_swig0.lms_dd_equalizer_cc_sptr_relative_rate(self)

    def relative_rate_i(self) -> "uint64_t":
        r"""relative_rate_i(lms_dd_equalizer_cc_sptr self) -> uint64_t"""
        return _digital_swig0.lms_dd_equalizer_cc_sptr_relative_rate_i(self)

    def relative_rate_d(self) -> "uint64_t":
        r"""relative_rate_d(lms_dd_equalizer_cc_sptr self) -> uint64_t"""
        return _digital_swig0.lms_dd_equalizer_cc_sptr_relative_rate_d(self)

    def start(self) -> "bool":
        r"""start(lms_dd_equalizer_cc_sptr self) -> bool"""
        return _digital_swig0.lms_dd_equalizer_cc_sptr_start(self)

    def stop(self) -> "bool":
        r"""stop(lms_dd_equalizer_cc_sptr self) -> bool"""
        return _digital_swig0.lms_dd_equalizer_cc_sptr_stop(self)

    def nitems_read(self, which_input: "unsigned int") -> "uint64_t":
        r"""nitems_read(lms_dd_equalizer_cc_sptr self, unsigned int which_input) -> uint64_t"""
        return _digital_swig0.lms_dd_equalizer_cc_sptr_nitems_read(self, which_input)

    def nitems_written(self, which_output: "unsigned int") -> "uint64_t":
        r"""nitems_written(lms_dd_equalizer_cc_sptr self, unsigned int which_output) -> uint64_t"""
        return _digital_swig0.lms_dd_equalizer_cc_sptr_nitems_written(self, which_output)

    def set_log_level(self, level: "std::string") -> "void":
        r"""set_log_level(lms_dd_equalizer_cc_sptr self, std::string level)"""
        return _digital_swig0.lms_dd_equalizer_cc_sptr_set_log_level(self, level)

    def log_level(self) -> "std::string":
        r"""log_level(lms_dd_equalizer_cc_sptr self) -> std::string"""
        return _digital_swig0.lms_dd_equalizer_cc_sptr_log_level(self)

    def max_noutput_items(self) -> "int":
        r"""max_noutput_items(lms_dd_equalizer_cc_sptr self) -> int"""
        return _digital_swig0.lms_dd_equalizer_cc_sptr_max_noutput_items(self)

    def set_max_noutput_items(self, m: "int") -> "void":
        r"""set_max_noutput_items(lms_dd_equalizer_cc_sptr self, int m)"""
        return _digital_swig0.lms_dd_equalizer_cc_sptr_set_max_noutput_items(self, m)

    def unset_max_noutput_items(self) -> "void":
        r"""unset_max_noutput_items(lms_dd_equalizer_cc_sptr self)"""
        return _digital_swig0.lms_dd_equalizer_cc_sptr_unset_max_noutput_items(self)

    def is_set_max_noutput_items(self) -> "bool":
        r"""is_set_max_noutput_items(lms_dd_equalizer_cc_sptr self) -> bool"""
        return _digital_swig0.lms_dd_equalizer_cc_sptr_is_set_max_noutput_items(self)

    def set_min_noutput_items(self, m: "int") -> "void":
        r"""set_min_noutput_items(lms_dd_equalizer_cc_sptr self, int m)"""
        return _digital_swig0.lms_dd_equalizer_cc_sptr_set_min_noutput_items(self, m)

    def min_noutput_items(self) -> "int":
        r"""min_noutput_items(lms_dd_equalizer_cc_sptr self) -> int"""
        return _digital_swig0.lms_dd_equalizer_cc_sptr_min_noutput_items(self)

    def max_output_buffer(self, i: "int") -> "long":
        r"""max_output_buffer(lms_dd_equalizer_cc_sptr self, int i) -> long"""
        return _digital_swig0.lms_dd_equalizer_cc_sptr_max_output_buffer(self, i)

    def set_max_output_buffer(self, *args) -> "void":
        r"""
        set_max_output_buffer(lms_dd_equalizer_cc_sptr self, long max_output_buffer)
        set_max_output_buffer(lms_dd_equalizer_cc_sptr self, int port, long max_output_buffer)
        """
        return _digital_swig0.lms_dd_equalizer_cc_sptr_set_max_output_buffer(self, *args)

    def min_output_buffer(self, i: "int") -> "long":
        r"""min_output_buffer(lms_dd_equalizer_cc_sptr self, int i) -> long"""
        return _digital_swig0.lms_dd_equalizer_cc_sptr_min_output_buffer(self, i)

    def set_min_output_buffer(self, *args) -> "void":
        r"""
        set_min_output_buffer(lms_dd_equalizer_cc_sptr self, long min_output_buffer)
        set_min_output_buffer(lms_dd_equalizer_cc_sptr self, int port, long min_output_buffer)
        """
        return _digital_swig0.lms_dd_equalizer_cc_sptr_set_min_output_buffer(self, *args)

    def pc_noutput_items(self) -> "float":
        r"""pc_noutput_items(lms_dd_equalizer_cc_sptr self) -> float"""
        return _digital_swig0.lms_dd_equalizer_cc_sptr_pc_noutput_items(self)

    def pc_noutput_items_avg(self) -> "float":
        r"""pc_noutput_items_avg(lms_dd_equalizer_cc_sptr self) -> float"""
        return _digital_swig0.lms_dd_equalizer_cc_sptr_pc_noutput_items_avg(self)

    def pc_noutput_items_var(self) -> "float":
        r"""pc_noutput_items_var(lms_dd_equalizer_cc_sptr self) -> float"""
        return _digital_swig0.lms_dd_equalizer_cc_sptr_pc_noutput_items_var(self)

    def pc_nproduced(self) -> "float":
        r"""pc_nproduced(lms_dd_equalizer_cc_sptr self) -> float"""
        return _digital_swig0.lms_dd_equalizer_cc_sptr_pc_nproduced(self)

    def pc_nproduced_avg(self) -> "float":
        r"""pc_nproduced_avg(lms_dd_equalizer_cc_sptr self) -> float"""
        return _digital_swig0.lms_dd_equalizer_cc_sptr_pc_nproduced_avg(self)

    def pc_nproduced_var(self) -> "float":
        r"""pc_nproduced_var(lms_dd_equalizer_cc_sptr self) -> float"""
        return _digital_swig0.lms_dd_equalizer_cc_sptr_pc_nproduced_var(self)

    def pc_input_buffers_full(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full(lms_dd_equalizer_cc_sptr self, int which) -> float
        pc_input_buffers_full(lms_dd_equalizer_cc_sptr self) -> pmt_vector_float
        """
        return _digital_swig0.lms_dd_equalizer_cc_sptr_pc_input_buffers_full(self, *args)

    def pc_input_buffers_full_avg(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full_avg(lms_dd_equalizer_cc_sptr self, int which) -> float
        pc_input_buffers_full_avg(lms_dd_equalizer_cc_sptr self) -> pmt_vector_float
        """
        return _digital_swig0.lms_dd_equalizer_cc_sptr_pc_input_buffers_full_avg(self, *args)

    def pc_input_buffers_full_var(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full_var(lms_dd_equalizer_cc_sptr self, int which) -> float
        pc_input_buffers_full_var(lms_dd_equalizer_cc_sptr self) -> pmt_vector_float
        """
        return _digital_swig0.lms_dd_equalizer_cc_sptr_pc_input_buffers_full_var(self, *args)

    def pc_output_buffers_full(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full(lms_dd_equalizer_cc_sptr self, int which) -> float
        pc_output_buffers_full(lms_dd_equalizer_cc_sptr self) -> pmt_vector_float
        """
        return _digital_swig0.lms_dd_equalizer_cc_sptr_pc_output_buffers_full(self, *args)

    def pc_output_buffers_full_avg(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full_avg(lms_dd_equalizer_cc_sptr self, int which) -> float
        pc_output_buffers_full_avg(lms_dd_equalizer_cc_sptr self) -> pmt_vector_float
        """
        return _digital_swig0.lms_dd_equalizer_cc_sptr_pc_output_buffers_full_avg(self, *args)

    def pc_output_buffers_full_var(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full_var(lms_dd_equalizer_cc_sptr self, int which) -> float
        pc_output_buffers_full_var(lms_dd_equalizer_cc_sptr self) -> pmt_vector_float
        """
        return _digital_swig0.lms_dd_equalizer_cc_sptr_pc_output_buffers_full_var(self, *args)

    def pc_work_time(self) -> "float":
        r"""pc_work_time(lms_dd_equalizer_cc_sptr self) -> float"""
        return _digital_swig0.lms_dd_equalizer_cc_sptr_pc_work_time(self)

    def pc_work_time_avg(self) -> "float":
        r"""pc_work_time_avg(lms_dd_equalizer_cc_sptr self) -> float"""
        return _digital_swig0.lms_dd_equalizer_cc_sptr_pc_work_time_avg(self)

    def pc_work_time_var(self) -> "float":
        r"""pc_work_time_var(lms_dd_equalizer_cc_sptr self) -> float"""
        return _digital_swig0.lms_dd_equalizer_cc_sptr_pc_work_time_var(self)

    def pc_work_time_total(self) -> "float":
        r"""pc_work_time_total(lms_dd_equalizer_cc_sptr self) -> float"""
        return _digital_swig0.lms_dd_equalizer_cc_sptr_pc_work_time_total(self)

    def pc_throughput_avg(self) -> "float":
        r"""pc_throughput_avg(lms_dd_equalizer_cc_sptr self) -> float"""
        return _digital_swig0.lms_dd_equalizer_cc_sptr_pc_throughput_avg(self)

    def set_processor_affinity(self, mask: "std::vector< int,std::allocator< int > > const &") -> "void":
        r"""set_processor_affinity(lms_dd_equalizer_cc_sptr self, std::vector< int,std::allocator< int > > const & mask)"""
        return _digital_swig0.lms_dd_equalizer_cc_sptr_set_processor_affinity(self, mask)

    def unset_processor_affinity(self) -> "void":
        r"""unset_processor_affinity(lms_dd_equalizer_cc_sptr self)"""
        return _digital_swig0.lms_dd_equalizer_cc_sptr_unset_processor_affinity(self)

    def processor_affinity(self) -> "std::vector< int,std::allocator< int > >":
        r"""processor_affinity(lms_dd_equalizer_cc_sptr self) -> std::vector< int,std::allocator< int > >"""
        return _digital_swig0.lms_dd_equalizer_cc_sptr_processor_affinity(self)

    def active_thread_priority(self) -> "int":
        r"""active_thread_priority(lms_dd_equalizer_cc_sptr self) -> int"""
        return _digital_swig0.lms_dd_equalizer_cc_sptr_active_thread_priority(self)

    def thread_priority(self) -> "int":
        r"""thread_priority(lms_dd_equalizer_cc_sptr self) -> int"""
        return _digital_swig0.lms_dd_equalizer_cc_sptr_thread_priority(self)

    def set_thread_priority(self, priority: "int") -> "int":
        r"""set_thread_priority(lms_dd_equalizer_cc_sptr self, int priority) -> int"""
        return _digital_swig0.lms_dd_equalizer_cc_sptr_set_thread_priority(self, priority)

    def name(self) -> "std::string":
        r"""name(lms_dd_equalizer_cc_sptr self) -> std::string"""
        return _digital_swig0.lms_dd_equalizer_cc_sptr_name(self)

    def symbol_name(self) -> "std::string":
        r"""symbol_name(lms_dd_equalizer_cc_sptr self) -> std::string"""
        return _digital_swig0.lms_dd_equalizer_cc_sptr_symbol_name(self)

    def input_signature(self) -> "gr::io_signature::sptr":
        r"""input_signature(lms_dd_equalizer_cc_sptr self) -> io_signature_sptr"""
        return _digital_swig0.lms_dd_equalizer_cc_sptr_input_signature(self)

    def output_signature(self) -> "gr::io_signature::sptr":
        r"""output_signature(lms_dd_equalizer_cc_sptr self) -> io_signature_sptr"""
        return _digital_swig0.lms_dd_equalizer_cc_sptr_output_signature(self)

    def unique_id(self) -> "long":
        r"""unique_id(lms_dd_equalizer_cc_sptr self) -> long"""
        return _digital_swig0.lms_dd_equalizer_cc_sptr_unique_id(self)

    def to_basic_block(self) -> "gr::basic_block_sptr":
        r"""to_basic_block(lms_dd_equalizer_cc_sptr self) -> basic_block_sptr"""
        return _digital_swig0.lms_dd_equalizer_cc_sptr_to_basic_block(self)

    def check_topology(self, ninputs: "int", noutputs: "int") -> "bool":
        r"""check_topology(lms_dd_equalizer_cc_sptr self, int ninputs, int noutputs) -> bool"""
        return _digital_swig0.lms_dd_equalizer_cc_sptr_check_topology(self, ninputs, noutputs)

    def alias(self) -> "std::string":
        r"""alias(lms_dd_equalizer_cc_sptr self) -> std::string"""
        return _digital_swig0.lms_dd_equalizer_cc_sptr_alias(self)

    def set_block_alias(self, name: "std::string") -> "void":
        r"""set_block_alias(lms_dd_equalizer_cc_sptr self, std::string name)"""
        return _digital_swig0.lms_dd_equalizer_cc_sptr_set_block_alias(self, name)

    def _post(self, which_port: "swig_pmt_ptr", msg: "swig_pmt_ptr") -> "void":
        r"""_post(lms_dd_equalizer_cc_sptr self, swig_pmt_ptr which_port, swig_pmt_ptr msg)"""
        return _digital_swig0.lms_dd_equalizer_cc_sptr__post(self, which_port, msg)

    def message_ports_in(self) -> "pmt::pmt_t":
        r"""message_ports_in(lms_dd_equalizer_cc_sptr self) -> swig_pmt_ptr"""
        return _digital_swig0.lms_dd_equalizer_cc_sptr_message_ports_in(self)

    def message_ports_out(self) -> "pmt::pmt_t":
        r"""message_ports_out(lms_dd_equalizer_cc_sptr self) -> swig_pmt_ptr"""
        return _digital_swig0.lms_dd_equalizer_cc_sptr_message_ports_out(self)

    def message_subscribers(self, which_port: "swig_pmt_ptr") -> "pmt::pmt_t":
        r"""message_subscribers(lms_dd_equalizer_cc_sptr self, swig_pmt_ptr which_port) -> swig_pmt_ptr"""
        return _digital_swig0.lms_dd_equalizer_cc_sptr_message_subscribers(self, which_port)

# Register lms_dd_equalizer_cc_sptr in _digital_swig0:
_digital_swig0.lms_dd_equalizer_cc_sptr_swigregister(lms_dd_equalizer_cc_sptr)

lms_dd_equalizer_cc_sptr.__repr__ = lambda self: "<gr_block %s (%d)>" % (self.name(), self.unique_id())
lms_dd_equalizer_cc = lms_dd_equalizer_cc.make;

class ofdm_carrier_allocator_cvc_sptr(object):
    r"""Proxy of C++ boost::shared_ptr< gr::digital::ofdm_carrier_allocator_cvc > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(ofdm_carrier_allocator_cvc_sptr self) -> ofdm_carrier_allocator_cvc_sptr
        __init__(ofdm_carrier_allocator_cvc_sptr self, ofdm_carrier_allocator_cvc p) -> ofdm_carrier_allocator_cvc_sptr
        """
        _digital_swig0.ofdm_carrier_allocator_cvc_sptr_swiginit(self, _digital_swig0.new_ofdm_carrier_allocator_cvc_sptr(*args))

    def __deref__(self) -> "gr::digital::ofdm_carrier_allocator_cvc *":
        r"""__deref__(ofdm_carrier_allocator_cvc_sptr self) -> ofdm_carrier_allocator_cvc"""
        return _digital_swig0.ofdm_carrier_allocator_cvc_sptr___deref__(self)
    __swig_destroy__ = _digital_swig0.delete_ofdm_carrier_allocator_cvc_sptr

    def len_tag_key(self) -> "std::string":
        r"""len_tag_key(ofdm_carrier_allocator_cvc_sptr self) -> std::string"""
        return _digital_swig0.ofdm_carrier_allocator_cvc_sptr_len_tag_key(self)

    def fft_len(self) -> "int const":
        r"""fft_len(ofdm_carrier_allocator_cvc_sptr self) -> int const"""
        return _digital_swig0.ofdm_carrier_allocator_cvc_sptr_fft_len(self)

    def occupied_carriers(self) -> "std::vector< std::vector< int,std::allocator< int > >,std::allocator< std::vector< int,std::allocator< int > > > >":
        r"""occupied_carriers(ofdm_carrier_allocator_cvc_sptr self) -> std::vector< std::vector< int,std::allocator< int > >,std::allocator< std::vector< int,std::allocator< int > > > >"""
        return _digital_swig0.ofdm_carrier_allocator_cvc_sptr_occupied_carriers(self)

    def make(self, *args, **kwargs) -> "gr::digital::ofdm_carrier_allocator_cvc::sptr":
        r"""
        make(ofdm_carrier_allocator_cvc_sptr self, int fft_len, std::vector< std::vector< int,std::allocator< int > >,std::allocator< std::vector< int,std::allocator< int > > > > const & occupied_carriers, std::vector< std::vector< int,std::allocator< int > >,std::allocator< std::vector< int,std::allocator< int > > > > const & pilot_carriers, gr_vector_vector_complexf pilot_symbols, gr_vector_vector_complexf sync_words, std::string const & len_tag_key="packet_len", bool const output_is_shifted=True) -> ofdm_carrier_allocator_cvc_sptr
        Create frequency domain OFDM symbols from complex values, add pilots.

        This block turns a stream of complex, scalar modulation symbols into vectors which are the input for an IFFT in an OFDM transmitter. It also supports the possibility of placing pilot symbols onto the carriers.


        The carriers can be allocated freely, if a carrier is not allocated, it is set to zero. This allows doing OFDMA-style carrier allocations.


        Input: A tagged stream of complex scalars. The first item must have a tag containing the number of complex symbols in this frame. Output: A tagged stream of complex vectors of length fft_len. This can directly be connected to an FFT block. Make sure to set this block to 'reverse' for the IFFT. If  is true, the FFT block must activate FFT shifting, otherwise, set shifting to false. If given, sync words are prepended to the output. Note that sync words are prepended verbatim, make sure they are shifted (or not).


        Carrier indexes are always such that index 0 is the DC carrier (note: you should not allocate this carrier). The carriers below the DC carrier are either indexed with negative numbers, or with indexes larger than . Index -1 and index  both identify the carrier below the DC carrier.


        There are some basic checks in place during initialization which check that the carrier allocation table is valid. However, it is possible to overwrite data symbols with pilot symbols, or provide a carrier allocation that has mismatching pilot symbol positions and -values.


        Tags are propagated such that a tag on an incoming complex symbol is mapped to the corresponding OFDM symbol. There is one exception: If a tag is on the first OFDM symbol, it is assumed that this tag should stay there, so it is moved to the front even if a sync word is included (any other tags will never be attached to the sync word). This allows tags to control the transmit timing to pass through in the correct position.

        Constructor Specific Documentation:



        Args:
            fft_len : 
            occupied_carriers : 
            pilot_carriers : 
            pilot_symbols : 
            sync_words : 
            len_tag_key : 
            output_is_shifted : 
        """
        return _digital_swig0.ofdm_carrier_allocator_cvc_sptr_make(self, *args, **kwargs)

    def history(self) -> "unsigned int":
        r"""history(ofdm_carrier_allocator_cvc_sptr self) -> unsigned int"""
        return _digital_swig0.ofdm_carrier_allocator_cvc_sptr_history(self)

    def declare_sample_delay(self, *args) -> "void":
        r"""
        declare_sample_delay(ofdm_carrier_allocator_cvc_sptr self, int which, int delay)
        declare_sample_delay(ofdm_carrier_allocator_cvc_sptr self, unsigned int delay)
        """
        return _digital_swig0.ofdm_carrier_allocator_cvc_sptr_declare_sample_delay(self, *args)

    def sample_delay(self, which: "int") -> "unsigned int":
        r"""sample_delay(ofdm_carrier_allocator_cvc_sptr self, int which) -> unsigned int"""
        return _digital_swig0.ofdm_carrier_allocator_cvc_sptr_sample_delay(self, which)

    def set_output_multiple(self, multiple: "int") -> "void":
        r"""set_output_multiple(ofdm_carrier_allocator_cvc_sptr self, int multiple)"""
        return _digital_swig0.ofdm_carrier_allocator_cvc_sptr_set_output_multiple(self, multiple)

    def output_multiple(self) -> "int":
        r"""output_multiple(ofdm_carrier_allocator_cvc_sptr self) -> int"""
        return _digital_swig0.ofdm_carrier_allocator_cvc_sptr_output_multiple(self)

    def relative_rate(self) -> "double":
        r"""relative_rate(ofdm_carrier_allocator_cvc_sptr self) -> double"""
        return _digital_swig0.ofdm_carrier_allocator_cvc_sptr_relative_rate(self)

    def relative_rate_i(self) -> "uint64_t":
        r"""relative_rate_i(ofdm_carrier_allocator_cvc_sptr self) -> uint64_t"""
        return _digital_swig0.ofdm_carrier_allocator_cvc_sptr_relative_rate_i(self)

    def relative_rate_d(self) -> "uint64_t":
        r"""relative_rate_d(ofdm_carrier_allocator_cvc_sptr self) -> uint64_t"""
        return _digital_swig0.ofdm_carrier_allocator_cvc_sptr_relative_rate_d(self)

    def start(self) -> "bool":
        r"""start(ofdm_carrier_allocator_cvc_sptr self) -> bool"""
        return _digital_swig0.ofdm_carrier_allocator_cvc_sptr_start(self)

    def stop(self) -> "bool":
        r"""stop(ofdm_carrier_allocator_cvc_sptr self) -> bool"""
        return _digital_swig0.ofdm_carrier_allocator_cvc_sptr_stop(self)

    def nitems_read(self, which_input: "unsigned int") -> "uint64_t":
        r"""nitems_read(ofdm_carrier_allocator_cvc_sptr self, unsigned int which_input) -> uint64_t"""
        return _digital_swig0.ofdm_carrier_allocator_cvc_sptr_nitems_read(self, which_input)

    def nitems_written(self, which_output: "unsigned int") -> "uint64_t":
        r"""nitems_written(ofdm_carrier_allocator_cvc_sptr self, unsigned int which_output) -> uint64_t"""
        return _digital_swig0.ofdm_carrier_allocator_cvc_sptr_nitems_written(self, which_output)

    def set_log_level(self, level: "std::string") -> "void":
        r"""set_log_level(ofdm_carrier_allocator_cvc_sptr self, std::string level)"""
        return _digital_swig0.ofdm_carrier_allocator_cvc_sptr_set_log_level(self, level)

    def log_level(self) -> "std::string":
        r"""log_level(ofdm_carrier_allocator_cvc_sptr self) -> std::string"""
        return _digital_swig0.ofdm_carrier_allocator_cvc_sptr_log_level(self)

    def max_noutput_items(self) -> "int":
        r"""max_noutput_items(ofdm_carrier_allocator_cvc_sptr self) -> int"""
        return _digital_swig0.ofdm_carrier_allocator_cvc_sptr_max_noutput_items(self)

    def set_max_noutput_items(self, m: "int") -> "void":
        r"""set_max_noutput_items(ofdm_carrier_allocator_cvc_sptr self, int m)"""
        return _digital_swig0.ofdm_carrier_allocator_cvc_sptr_set_max_noutput_items(self, m)

    def unset_max_noutput_items(self) -> "void":
        r"""unset_max_noutput_items(ofdm_carrier_allocator_cvc_sptr self)"""
        return _digital_swig0.ofdm_carrier_allocator_cvc_sptr_unset_max_noutput_items(self)

    def is_set_max_noutput_items(self) -> "bool":
        r"""is_set_max_noutput_items(ofdm_carrier_allocator_cvc_sptr self) -> bool"""
        return _digital_swig0.ofdm_carrier_allocator_cvc_sptr_is_set_max_noutput_items(self)

    def set_min_noutput_items(self, m: "int") -> "void":
        r"""set_min_noutput_items(ofdm_carrier_allocator_cvc_sptr self, int m)"""
        return _digital_swig0.ofdm_carrier_allocator_cvc_sptr_set_min_noutput_items(self, m)

    def min_noutput_items(self) -> "int":
        r"""min_noutput_items(ofdm_carrier_allocator_cvc_sptr self) -> int"""
        return _digital_swig0.ofdm_carrier_allocator_cvc_sptr_min_noutput_items(self)

    def max_output_buffer(self, i: "int") -> "long":
        r"""max_output_buffer(ofdm_carrier_allocator_cvc_sptr self, int i) -> long"""
        return _digital_swig0.ofdm_carrier_allocator_cvc_sptr_max_output_buffer(self, i)

    def set_max_output_buffer(self, *args) -> "void":
        r"""
        set_max_output_buffer(ofdm_carrier_allocator_cvc_sptr self, long max_output_buffer)
        set_max_output_buffer(ofdm_carrier_allocator_cvc_sptr self, int port, long max_output_buffer)
        """
        return _digital_swig0.ofdm_carrier_allocator_cvc_sptr_set_max_output_buffer(self, *args)

    def min_output_buffer(self, i: "int") -> "long":
        r"""min_output_buffer(ofdm_carrier_allocator_cvc_sptr self, int i) -> long"""
        return _digital_swig0.ofdm_carrier_allocator_cvc_sptr_min_output_buffer(self, i)

    def set_min_output_buffer(self, *args) -> "void":
        r"""
        set_min_output_buffer(ofdm_carrier_allocator_cvc_sptr self, long min_output_buffer)
        set_min_output_buffer(ofdm_carrier_allocator_cvc_sptr self, int port, long min_output_buffer)
        """
        return _digital_swig0.ofdm_carrier_allocator_cvc_sptr_set_min_output_buffer(self, *args)

    def pc_noutput_items(self) -> "float":
        r"""pc_noutput_items(ofdm_carrier_allocator_cvc_sptr self) -> float"""
        return _digital_swig0.ofdm_carrier_allocator_cvc_sptr_pc_noutput_items(self)

    def pc_noutput_items_avg(self) -> "float":
        r"""pc_noutput_items_avg(ofdm_carrier_allocator_cvc_sptr self) -> float"""
        return _digital_swig0.ofdm_carrier_allocator_cvc_sptr_pc_noutput_items_avg(self)

    def pc_noutput_items_var(self) -> "float":
        r"""pc_noutput_items_var(ofdm_carrier_allocator_cvc_sptr self) -> float"""
        return _digital_swig0.ofdm_carrier_allocator_cvc_sptr_pc_noutput_items_var(self)

    def pc_nproduced(self) -> "float":
        r"""pc_nproduced(ofdm_carrier_allocator_cvc_sptr self) -> float"""
        return _digital_swig0.ofdm_carrier_allocator_cvc_sptr_pc_nproduced(self)

    def pc_nproduced_avg(self) -> "float":
        r"""pc_nproduced_avg(ofdm_carrier_allocator_cvc_sptr self) -> float"""
        return _digital_swig0.ofdm_carrier_allocator_cvc_sptr_pc_nproduced_avg(self)

    def pc_nproduced_var(self) -> "float":
        r"""pc_nproduced_var(ofdm_carrier_allocator_cvc_sptr self) -> float"""
        return _digital_swig0.ofdm_carrier_allocator_cvc_sptr_pc_nproduced_var(self)

    def pc_input_buffers_full(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full(ofdm_carrier_allocator_cvc_sptr self, int which) -> float
        pc_input_buffers_full(ofdm_carrier_allocator_cvc_sptr self) -> pmt_vector_float
        """
        return _digital_swig0.ofdm_carrier_allocator_cvc_sptr_pc_input_buffers_full(self, *args)

    def pc_input_buffers_full_avg(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full_avg(ofdm_carrier_allocator_cvc_sptr self, int which) -> float
        pc_input_buffers_full_avg(ofdm_carrier_allocator_cvc_sptr self) -> pmt_vector_float
        """
        return _digital_swig0.ofdm_carrier_allocator_cvc_sptr_pc_input_buffers_full_avg(self, *args)

    def pc_input_buffers_full_var(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full_var(ofdm_carrier_allocator_cvc_sptr self, int which) -> float
        pc_input_buffers_full_var(ofdm_carrier_allocator_cvc_sptr self) -> pmt_vector_float
        """
        return _digital_swig0.ofdm_carrier_allocator_cvc_sptr_pc_input_buffers_full_var(self, *args)

    def pc_output_buffers_full(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full(ofdm_carrier_allocator_cvc_sptr self, int which) -> float
        pc_output_buffers_full(ofdm_carrier_allocator_cvc_sptr self) -> pmt_vector_float
        """
        return _digital_swig0.ofdm_carrier_allocator_cvc_sptr_pc_output_buffers_full(self, *args)

    def pc_output_buffers_full_avg(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full_avg(ofdm_carrier_allocator_cvc_sptr self, int which) -> float
        pc_output_buffers_full_avg(ofdm_carrier_allocator_cvc_sptr self) -> pmt_vector_float
        """
        return _digital_swig0.ofdm_carrier_allocator_cvc_sptr_pc_output_buffers_full_avg(self, *args)

    def pc_output_buffers_full_var(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full_var(ofdm_carrier_allocator_cvc_sptr self, int which) -> float
        pc_output_buffers_full_var(ofdm_carrier_allocator_cvc_sptr self) -> pmt_vector_float
        """
        return _digital_swig0.ofdm_carrier_allocator_cvc_sptr_pc_output_buffers_full_var(self, *args)

    def pc_work_time(self) -> "float":
        r"""pc_work_time(ofdm_carrier_allocator_cvc_sptr self) -> float"""
        return _digital_swig0.ofdm_carrier_allocator_cvc_sptr_pc_work_time(self)

    def pc_work_time_avg(self) -> "float":
        r"""pc_work_time_avg(ofdm_carrier_allocator_cvc_sptr self) -> float"""
        return _digital_swig0.ofdm_carrier_allocator_cvc_sptr_pc_work_time_avg(self)

    def pc_work_time_var(self) -> "float":
        r"""pc_work_time_var(ofdm_carrier_allocator_cvc_sptr self) -> float"""
        return _digital_swig0.ofdm_carrier_allocator_cvc_sptr_pc_work_time_var(self)

    def pc_work_time_total(self) -> "float":
        r"""pc_work_time_total(ofdm_carrier_allocator_cvc_sptr self) -> float"""
        return _digital_swig0.ofdm_carrier_allocator_cvc_sptr_pc_work_time_total(self)

    def pc_throughput_avg(self) -> "float":
        r"""pc_throughput_avg(ofdm_carrier_allocator_cvc_sptr self) -> float"""
        return _digital_swig0.ofdm_carrier_allocator_cvc_sptr_pc_throughput_avg(self)

    def set_processor_affinity(self, mask: "std::vector< int,std::allocator< int > > const &") -> "void":
        r"""set_processor_affinity(ofdm_carrier_allocator_cvc_sptr self, std::vector< int,std::allocator< int > > const & mask)"""
        return _digital_swig0.ofdm_carrier_allocator_cvc_sptr_set_processor_affinity(self, mask)

    def unset_processor_affinity(self) -> "void":
        r"""unset_processor_affinity(ofdm_carrier_allocator_cvc_sptr self)"""
        return _digital_swig0.ofdm_carrier_allocator_cvc_sptr_unset_processor_affinity(self)

    def processor_affinity(self) -> "std::vector< int,std::allocator< int > >":
        r"""processor_affinity(ofdm_carrier_allocator_cvc_sptr self) -> std::vector< int,std::allocator< int > >"""
        return _digital_swig0.ofdm_carrier_allocator_cvc_sptr_processor_affinity(self)

    def active_thread_priority(self) -> "int":
        r"""active_thread_priority(ofdm_carrier_allocator_cvc_sptr self) -> int"""
        return _digital_swig0.ofdm_carrier_allocator_cvc_sptr_active_thread_priority(self)

    def thread_priority(self) -> "int":
        r"""thread_priority(ofdm_carrier_allocator_cvc_sptr self) -> int"""
        return _digital_swig0.ofdm_carrier_allocator_cvc_sptr_thread_priority(self)

    def set_thread_priority(self, priority: "int") -> "int":
        r"""set_thread_priority(ofdm_carrier_allocator_cvc_sptr self, int priority) -> int"""
        return _digital_swig0.ofdm_carrier_allocator_cvc_sptr_set_thread_priority(self, priority)

    def name(self) -> "std::string":
        r"""name(ofdm_carrier_allocator_cvc_sptr self) -> std::string"""
        return _digital_swig0.ofdm_carrier_allocator_cvc_sptr_name(self)

    def symbol_name(self) -> "std::string":
        r"""symbol_name(ofdm_carrier_allocator_cvc_sptr self) -> std::string"""
        return _digital_swig0.ofdm_carrier_allocator_cvc_sptr_symbol_name(self)

    def input_signature(self) -> "gr::io_signature::sptr":
        r"""input_signature(ofdm_carrier_allocator_cvc_sptr self) -> io_signature_sptr"""
        return _digital_swig0.ofdm_carrier_allocator_cvc_sptr_input_signature(self)

    def output_signature(self) -> "gr::io_signature::sptr":
        r"""output_signature(ofdm_carrier_allocator_cvc_sptr self) -> io_signature_sptr"""
        return _digital_swig0.ofdm_carrier_allocator_cvc_sptr_output_signature(self)

    def unique_id(self) -> "long":
        r"""unique_id(ofdm_carrier_allocator_cvc_sptr self) -> long"""
        return _digital_swig0.ofdm_carrier_allocator_cvc_sptr_unique_id(self)

    def to_basic_block(self) -> "gr::basic_block_sptr":
        r"""to_basic_block(ofdm_carrier_allocator_cvc_sptr self) -> basic_block_sptr"""
        return _digital_swig0.ofdm_carrier_allocator_cvc_sptr_to_basic_block(self)

    def check_topology(self, ninputs: "int", noutputs: "int") -> "bool":
        r"""check_topology(ofdm_carrier_allocator_cvc_sptr self, int ninputs, int noutputs) -> bool"""
        return _digital_swig0.ofdm_carrier_allocator_cvc_sptr_check_topology(self, ninputs, noutputs)

    def alias(self) -> "std::string":
        r"""alias(ofdm_carrier_allocator_cvc_sptr self) -> std::string"""
        return _digital_swig0.ofdm_carrier_allocator_cvc_sptr_alias(self)

    def set_block_alias(self, name: "std::string") -> "void":
        r"""set_block_alias(ofdm_carrier_allocator_cvc_sptr self, std::string name)"""
        return _digital_swig0.ofdm_carrier_allocator_cvc_sptr_set_block_alias(self, name)

    def _post(self, which_port: "swig_pmt_ptr", msg: "swig_pmt_ptr") -> "void":
        r"""_post(ofdm_carrier_allocator_cvc_sptr self, swig_pmt_ptr which_port, swig_pmt_ptr msg)"""
        return _digital_swig0.ofdm_carrier_allocator_cvc_sptr__post(self, which_port, msg)

    def message_ports_in(self) -> "pmt::pmt_t":
        r"""message_ports_in(ofdm_carrier_allocator_cvc_sptr self) -> swig_pmt_ptr"""
        return _digital_swig0.ofdm_carrier_allocator_cvc_sptr_message_ports_in(self)

    def message_ports_out(self) -> "pmt::pmt_t":
        r"""message_ports_out(ofdm_carrier_allocator_cvc_sptr self) -> swig_pmt_ptr"""
        return _digital_swig0.ofdm_carrier_allocator_cvc_sptr_message_ports_out(self)

    def message_subscribers(self, which_port: "swig_pmt_ptr") -> "pmt::pmt_t":
        r"""message_subscribers(ofdm_carrier_allocator_cvc_sptr self, swig_pmt_ptr which_port) -> swig_pmt_ptr"""
        return _digital_swig0.ofdm_carrier_allocator_cvc_sptr_message_subscribers(self, which_port)

# Register ofdm_carrier_allocator_cvc_sptr in _digital_swig0:
_digital_swig0.ofdm_carrier_allocator_cvc_sptr_swigregister(ofdm_carrier_allocator_cvc_sptr)

ofdm_carrier_allocator_cvc_sptr.__repr__ = lambda self: "<gr_block %s (%d)>" % (self.name(), self.unique_id())
ofdm_carrier_allocator_cvc = ofdm_carrier_allocator_cvc.make;

class ofdm_chanest_vcvc_sptr(object):
    r"""Proxy of C++ boost::shared_ptr< gr::digital::ofdm_chanest_vcvc > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(ofdm_chanest_vcvc_sptr self) -> ofdm_chanest_vcvc_sptr
        __init__(ofdm_chanest_vcvc_sptr self, ofdm_chanest_vcvc p) -> ofdm_chanest_vcvc_sptr
        """
        _digital_swig0.ofdm_chanest_vcvc_sptr_swiginit(self, _digital_swig0.new_ofdm_chanest_vcvc_sptr(*args))

    def __deref__(self) -> "gr::digital::ofdm_chanest_vcvc *":
        r"""__deref__(ofdm_chanest_vcvc_sptr self) -> ofdm_chanest_vcvc"""
        return _digital_swig0.ofdm_chanest_vcvc_sptr___deref__(self)
    __swig_destroy__ = _digital_swig0.delete_ofdm_chanest_vcvc_sptr

    def make(self, sync_symbol1: "pmt_vector_cfloat", sync_symbol2: "pmt_vector_cfloat", n_data_symbols: "int", eq_noise_red_len: "int"=0, max_carr_offset: "int"=-1, force_one_sync_symbol: "bool"=False) -> "gr::digital::ofdm_chanest_vcvc::sptr":
        r"""
        make(ofdm_chanest_vcvc_sptr self, pmt_vector_cfloat sync_symbol1, pmt_vector_cfloat sync_symbol2, int n_data_symbols, int eq_noise_red_len=0, int max_carr_offset=-1, bool force_one_sync_symbol=False) -> ofdm_chanest_vcvc_sptr
        Estimate channel and coarse frequency offset for OFDM from preambles.

        Input: OFDM symbols (in frequency domain). The first one (or two) symbols are expected to be synchronisation symbols, which are used to estimate the coarse freq offset and the initial equalizer taps (these symbols are removed from the stream). The following  are passed through unmodified (the actual equalisation must be done elsewhere). Output: The data symbols, without the synchronisation symbols. The first data symbol passed through has two tags: 'ofdm_sync_carr_offset' (integer), the coarse frequency offset as number of carriers, and 'ofdm_sync_eq_taps' (complex vector). Any tags attached to the synchronisation symbols are attached to the first data symbol. All other tags are propagated as expected.


        Note: The vector on ofdm_sync_eq_taps is already frequency-corrected, whereas the rest is not.


        This block assumes the frequency offset is even (i.e. an integer multiple of 2).


        [1] Schmidl, T.M. and Cox, D.C., "Robust frequency and timing synchronization for
        OFDM", Communications, IEEE Transactions on, 1997. [2] K.D. Kammeyer, "Nachrichtenuebertragung," Chapter. 16.3.2.

        Constructor Specific Documentation:



        Args:
            sync_symbol1 : First synchronisation symbol in the frequency domain. Its length must be the FFT length. For Schmidl & Cox synchronisation, every second sub-carrier has to be zero.
            sync_symbol2 : Second synchronisation symbol in the frequency domain. Must be equal to the FFT length, or zero length if only one synchronisation symbol is used. Using this symbol is how synchronisation is described in [1]. Leaving this empty forces us to interpolate the equalizer taps. If you are using an unusual sub-carrier configuration (e.g. because of OFDMA), this sync symbol is used to identify the active sub-carriers. If you only have one synchronisation symbol, set the active sub-carriers to a non-zero value in here, and also set  parameter to true.
            n_data_symbols : The number of data symbols following each set of synchronisation symbols. Must be at least 1.
            eq_noise_red_len : If non-zero, noise reduction for the equalizer taps is done according to [2]. In this case, it is the channel influence time in number of samples. A good value is usually the length of the cyclic prefix.
            max_carr_offset : Limit the number of sub-carriers the frequency offset can maximally be. Leave this zero to try all possibilities.
            force_one_sync_symbol : See .
        """
        return _digital_swig0.ofdm_chanest_vcvc_sptr_make(self, sync_symbol1, sync_symbol2, n_data_symbols, eq_noise_red_len, max_carr_offset, force_one_sync_symbol)

    def history(self) -> "unsigned int":
        r"""history(ofdm_chanest_vcvc_sptr self) -> unsigned int"""
        return _digital_swig0.ofdm_chanest_vcvc_sptr_history(self)

    def declare_sample_delay(self, *args) -> "void":
        r"""
        declare_sample_delay(ofdm_chanest_vcvc_sptr self, int which, int delay)
        declare_sample_delay(ofdm_chanest_vcvc_sptr self, unsigned int delay)
        """
        return _digital_swig0.ofdm_chanest_vcvc_sptr_declare_sample_delay(self, *args)

    def sample_delay(self, which: "int") -> "unsigned int":
        r"""sample_delay(ofdm_chanest_vcvc_sptr self, int which) -> unsigned int"""
        return _digital_swig0.ofdm_chanest_vcvc_sptr_sample_delay(self, which)

    def set_output_multiple(self, multiple: "int") -> "void":
        r"""set_output_multiple(ofdm_chanest_vcvc_sptr self, int multiple)"""
        return _digital_swig0.ofdm_chanest_vcvc_sptr_set_output_multiple(self, multiple)

    def output_multiple(self) -> "int":
        r"""output_multiple(ofdm_chanest_vcvc_sptr self) -> int"""
        return _digital_swig0.ofdm_chanest_vcvc_sptr_output_multiple(self)

    def relative_rate(self) -> "double":
        r"""relative_rate(ofdm_chanest_vcvc_sptr self) -> double"""
        return _digital_swig0.ofdm_chanest_vcvc_sptr_relative_rate(self)

    def relative_rate_i(self) -> "uint64_t":
        r"""relative_rate_i(ofdm_chanest_vcvc_sptr self) -> uint64_t"""
        return _digital_swig0.ofdm_chanest_vcvc_sptr_relative_rate_i(self)

    def relative_rate_d(self) -> "uint64_t":
        r"""relative_rate_d(ofdm_chanest_vcvc_sptr self) -> uint64_t"""
        return _digital_swig0.ofdm_chanest_vcvc_sptr_relative_rate_d(self)

    def start(self) -> "bool":
        r"""start(ofdm_chanest_vcvc_sptr self) -> bool"""
        return _digital_swig0.ofdm_chanest_vcvc_sptr_start(self)

    def stop(self) -> "bool":
        r"""stop(ofdm_chanest_vcvc_sptr self) -> bool"""
        return _digital_swig0.ofdm_chanest_vcvc_sptr_stop(self)

    def nitems_read(self, which_input: "unsigned int") -> "uint64_t":
        r"""nitems_read(ofdm_chanest_vcvc_sptr self, unsigned int which_input) -> uint64_t"""
        return _digital_swig0.ofdm_chanest_vcvc_sptr_nitems_read(self, which_input)

    def nitems_written(self, which_output: "unsigned int") -> "uint64_t":
        r"""nitems_written(ofdm_chanest_vcvc_sptr self, unsigned int which_output) -> uint64_t"""
        return _digital_swig0.ofdm_chanest_vcvc_sptr_nitems_written(self, which_output)

    def set_log_level(self, level: "std::string") -> "void":
        r"""set_log_level(ofdm_chanest_vcvc_sptr self, std::string level)"""
        return _digital_swig0.ofdm_chanest_vcvc_sptr_set_log_level(self, level)

    def log_level(self) -> "std::string":
        r"""log_level(ofdm_chanest_vcvc_sptr self) -> std::string"""
        return _digital_swig0.ofdm_chanest_vcvc_sptr_log_level(self)

    def max_noutput_items(self) -> "int":
        r"""max_noutput_items(ofdm_chanest_vcvc_sptr self) -> int"""
        return _digital_swig0.ofdm_chanest_vcvc_sptr_max_noutput_items(self)

    def set_max_noutput_items(self, m: "int") -> "void":
        r"""set_max_noutput_items(ofdm_chanest_vcvc_sptr self, int m)"""
        return _digital_swig0.ofdm_chanest_vcvc_sptr_set_max_noutput_items(self, m)

    def unset_max_noutput_items(self) -> "void":
        r"""unset_max_noutput_items(ofdm_chanest_vcvc_sptr self)"""
        return _digital_swig0.ofdm_chanest_vcvc_sptr_unset_max_noutput_items(self)

    def is_set_max_noutput_items(self) -> "bool":
        r"""is_set_max_noutput_items(ofdm_chanest_vcvc_sptr self) -> bool"""
        return _digital_swig0.ofdm_chanest_vcvc_sptr_is_set_max_noutput_items(self)

    def set_min_noutput_items(self, m: "int") -> "void":
        r"""set_min_noutput_items(ofdm_chanest_vcvc_sptr self, int m)"""
        return _digital_swig0.ofdm_chanest_vcvc_sptr_set_min_noutput_items(self, m)

    def min_noutput_items(self) -> "int":
        r"""min_noutput_items(ofdm_chanest_vcvc_sptr self) -> int"""
        return _digital_swig0.ofdm_chanest_vcvc_sptr_min_noutput_items(self)

    def max_output_buffer(self, i: "int") -> "long":
        r"""max_output_buffer(ofdm_chanest_vcvc_sptr self, int i) -> long"""
        return _digital_swig0.ofdm_chanest_vcvc_sptr_max_output_buffer(self, i)

    def set_max_output_buffer(self, *args) -> "void":
        r"""
        set_max_output_buffer(ofdm_chanest_vcvc_sptr self, long max_output_buffer)
        set_max_output_buffer(ofdm_chanest_vcvc_sptr self, int port, long max_output_buffer)
        """
        return _digital_swig0.ofdm_chanest_vcvc_sptr_set_max_output_buffer(self, *args)

    def min_output_buffer(self, i: "int") -> "long":
        r"""min_output_buffer(ofdm_chanest_vcvc_sptr self, int i) -> long"""
        return _digital_swig0.ofdm_chanest_vcvc_sptr_min_output_buffer(self, i)

    def set_min_output_buffer(self, *args) -> "void":
        r"""
        set_min_output_buffer(ofdm_chanest_vcvc_sptr self, long min_output_buffer)
        set_min_output_buffer(ofdm_chanest_vcvc_sptr self, int port, long min_output_buffer)
        """
        return _digital_swig0.ofdm_chanest_vcvc_sptr_set_min_output_buffer(self, *args)

    def pc_noutput_items(self) -> "float":
        r"""pc_noutput_items(ofdm_chanest_vcvc_sptr self) -> float"""
        return _digital_swig0.ofdm_chanest_vcvc_sptr_pc_noutput_items(self)

    def pc_noutput_items_avg(self) -> "float":
        r"""pc_noutput_items_avg(ofdm_chanest_vcvc_sptr self) -> float"""
        return _digital_swig0.ofdm_chanest_vcvc_sptr_pc_noutput_items_avg(self)

    def pc_noutput_items_var(self) -> "float":
        r"""pc_noutput_items_var(ofdm_chanest_vcvc_sptr self) -> float"""
        return _digital_swig0.ofdm_chanest_vcvc_sptr_pc_noutput_items_var(self)

    def pc_nproduced(self) -> "float":
        r"""pc_nproduced(ofdm_chanest_vcvc_sptr self) -> float"""
        return _digital_swig0.ofdm_chanest_vcvc_sptr_pc_nproduced(self)

    def pc_nproduced_avg(self) -> "float":
        r"""pc_nproduced_avg(ofdm_chanest_vcvc_sptr self) -> float"""
        return _digital_swig0.ofdm_chanest_vcvc_sptr_pc_nproduced_avg(self)

    def pc_nproduced_var(self) -> "float":
        r"""pc_nproduced_var(ofdm_chanest_vcvc_sptr self) -> float"""
        return _digital_swig0.ofdm_chanest_vcvc_sptr_pc_nproduced_var(self)

    def pc_input_buffers_full(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full(ofdm_chanest_vcvc_sptr self, int which) -> float
        pc_input_buffers_full(ofdm_chanest_vcvc_sptr self) -> pmt_vector_float
        """
        return _digital_swig0.ofdm_chanest_vcvc_sptr_pc_input_buffers_full(self, *args)

    def pc_input_buffers_full_avg(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full_avg(ofdm_chanest_vcvc_sptr self, int which) -> float
        pc_input_buffers_full_avg(ofdm_chanest_vcvc_sptr self) -> pmt_vector_float
        """
        return _digital_swig0.ofdm_chanest_vcvc_sptr_pc_input_buffers_full_avg(self, *args)

    def pc_input_buffers_full_var(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full_var(ofdm_chanest_vcvc_sptr self, int which) -> float
        pc_input_buffers_full_var(ofdm_chanest_vcvc_sptr self) -> pmt_vector_float
        """
        return _digital_swig0.ofdm_chanest_vcvc_sptr_pc_input_buffers_full_var(self, *args)

    def pc_output_buffers_full(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full(ofdm_chanest_vcvc_sptr self, int which) -> float
        pc_output_buffers_full(ofdm_chanest_vcvc_sptr self) -> pmt_vector_float
        """
        return _digital_swig0.ofdm_chanest_vcvc_sptr_pc_output_buffers_full(self, *args)

    def pc_output_buffers_full_avg(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full_avg(ofdm_chanest_vcvc_sptr self, int which) -> float
        pc_output_buffers_full_avg(ofdm_chanest_vcvc_sptr self) -> pmt_vector_float
        """
        return _digital_swig0.ofdm_chanest_vcvc_sptr_pc_output_buffers_full_avg(self, *args)

    def pc_output_buffers_full_var(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full_var(ofdm_chanest_vcvc_sptr self, int which) -> float
        pc_output_buffers_full_var(ofdm_chanest_vcvc_sptr self) -> pmt_vector_float
        """
        return _digital_swig0.ofdm_chanest_vcvc_sptr_pc_output_buffers_full_var(self, *args)

    def pc_work_time(self) -> "float":
        r"""pc_work_time(ofdm_chanest_vcvc_sptr self) -> float"""
        return _digital_swig0.ofdm_chanest_vcvc_sptr_pc_work_time(self)

    def pc_work_time_avg(self) -> "float":
        r"""pc_work_time_avg(ofdm_chanest_vcvc_sptr self) -> float"""
        return _digital_swig0.ofdm_chanest_vcvc_sptr_pc_work_time_avg(self)

    def pc_work_time_var(self) -> "float":
        r"""pc_work_time_var(ofdm_chanest_vcvc_sptr self) -> float"""
        return _digital_swig0.ofdm_chanest_vcvc_sptr_pc_work_time_var(self)

    def pc_work_time_total(self) -> "float":
        r"""pc_work_time_total(ofdm_chanest_vcvc_sptr self) -> float"""
        return _digital_swig0.ofdm_chanest_vcvc_sptr_pc_work_time_total(self)

    def pc_throughput_avg(self) -> "float":
        r"""pc_throughput_avg(ofdm_chanest_vcvc_sptr self) -> float"""
        return _digital_swig0.ofdm_chanest_vcvc_sptr_pc_throughput_avg(self)

    def set_processor_affinity(self, mask: "std::vector< int,std::allocator< int > > const &") -> "void":
        r"""set_processor_affinity(ofdm_chanest_vcvc_sptr self, std::vector< int,std::allocator< int > > const & mask)"""
        return _digital_swig0.ofdm_chanest_vcvc_sptr_set_processor_affinity(self, mask)

    def unset_processor_affinity(self) -> "void":
        r"""unset_processor_affinity(ofdm_chanest_vcvc_sptr self)"""
        return _digital_swig0.ofdm_chanest_vcvc_sptr_unset_processor_affinity(self)

    def processor_affinity(self) -> "std::vector< int,std::allocator< int > >":
        r"""processor_affinity(ofdm_chanest_vcvc_sptr self) -> std::vector< int,std::allocator< int > >"""
        return _digital_swig0.ofdm_chanest_vcvc_sptr_processor_affinity(self)

    def active_thread_priority(self) -> "int":
        r"""active_thread_priority(ofdm_chanest_vcvc_sptr self) -> int"""
        return _digital_swig0.ofdm_chanest_vcvc_sptr_active_thread_priority(self)

    def thread_priority(self) -> "int":
        r"""thread_priority(ofdm_chanest_vcvc_sptr self) -> int"""
        return _digital_swig0.ofdm_chanest_vcvc_sptr_thread_priority(self)

    def set_thread_priority(self, priority: "int") -> "int":
        r"""set_thread_priority(ofdm_chanest_vcvc_sptr self, int priority) -> int"""
        return _digital_swig0.ofdm_chanest_vcvc_sptr_set_thread_priority(self, priority)

    def name(self) -> "std::string":
        r"""name(ofdm_chanest_vcvc_sptr self) -> std::string"""
        return _digital_swig0.ofdm_chanest_vcvc_sptr_name(self)

    def symbol_name(self) -> "std::string":
        r"""symbol_name(ofdm_chanest_vcvc_sptr self) -> std::string"""
        return _digital_swig0.ofdm_chanest_vcvc_sptr_symbol_name(self)

    def input_signature(self) -> "gr::io_signature::sptr":
        r"""input_signature(ofdm_chanest_vcvc_sptr self) -> io_signature_sptr"""
        return _digital_swig0.ofdm_chanest_vcvc_sptr_input_signature(self)

    def output_signature(self) -> "gr::io_signature::sptr":
        r"""output_signature(ofdm_chanest_vcvc_sptr self) -> io_signature_sptr"""
        return _digital_swig0.ofdm_chanest_vcvc_sptr_output_signature(self)

    def unique_id(self) -> "long":
        r"""unique_id(ofdm_chanest_vcvc_sptr self) -> long"""
        return _digital_swig0.ofdm_chanest_vcvc_sptr_unique_id(self)

    def to_basic_block(self) -> "gr::basic_block_sptr":
        r"""to_basic_block(ofdm_chanest_vcvc_sptr self) -> basic_block_sptr"""
        return _digital_swig0.ofdm_chanest_vcvc_sptr_to_basic_block(self)

    def check_topology(self, ninputs: "int", noutputs: "int") -> "bool":
        r"""check_topology(ofdm_chanest_vcvc_sptr self, int ninputs, int noutputs) -> bool"""
        return _digital_swig0.ofdm_chanest_vcvc_sptr_check_topology(self, ninputs, noutputs)

    def alias(self) -> "std::string":
        r"""alias(ofdm_chanest_vcvc_sptr self) -> std::string"""
        return _digital_swig0.ofdm_chanest_vcvc_sptr_alias(self)

    def set_block_alias(self, name: "std::string") -> "void":
        r"""set_block_alias(ofdm_chanest_vcvc_sptr self, std::string name)"""
        return _digital_swig0.ofdm_chanest_vcvc_sptr_set_block_alias(self, name)

    def _post(self, which_port: "swig_pmt_ptr", msg: "swig_pmt_ptr") -> "void":
        r"""_post(ofdm_chanest_vcvc_sptr self, swig_pmt_ptr which_port, swig_pmt_ptr msg)"""
        return _digital_swig0.ofdm_chanest_vcvc_sptr__post(self, which_port, msg)

    def message_ports_in(self) -> "pmt::pmt_t":
        r"""message_ports_in(ofdm_chanest_vcvc_sptr self) -> swig_pmt_ptr"""
        return _digital_swig0.ofdm_chanest_vcvc_sptr_message_ports_in(self)

    def message_ports_out(self) -> "pmt::pmt_t":
        r"""message_ports_out(ofdm_chanest_vcvc_sptr self) -> swig_pmt_ptr"""
        return _digital_swig0.ofdm_chanest_vcvc_sptr_message_ports_out(self)

    def message_subscribers(self, which_port: "swig_pmt_ptr") -> "pmt::pmt_t":
        r"""message_subscribers(ofdm_chanest_vcvc_sptr self, swig_pmt_ptr which_port) -> swig_pmt_ptr"""
        return _digital_swig0.ofdm_chanest_vcvc_sptr_message_subscribers(self, which_port)

# Register ofdm_chanest_vcvc_sptr in _digital_swig0:
_digital_swig0.ofdm_chanest_vcvc_sptr_swigregister(ofdm_chanest_vcvc_sptr)

ofdm_chanest_vcvc_sptr.__repr__ = lambda self: "<gr_block %s (%d)>" % (self.name(), self.unique_id())
ofdm_chanest_vcvc = ofdm_chanest_vcvc.make;

class ofdm_cyclic_prefixer_sptr(object):
    r"""Proxy of C++ boost::shared_ptr< gr::digital::ofdm_cyclic_prefixer > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(ofdm_cyclic_prefixer_sptr self) -> ofdm_cyclic_prefixer_sptr
        __init__(ofdm_cyclic_prefixer_sptr self, ofdm_cyclic_prefixer p) -> ofdm_cyclic_prefixer_sptr
        """
        _digital_swig0.ofdm_cyclic_prefixer_sptr_swiginit(self, _digital_swig0.new_ofdm_cyclic_prefixer_sptr(*args))

    def __deref__(self) -> "gr::digital::ofdm_cyclic_prefixer *":
        r"""__deref__(ofdm_cyclic_prefixer_sptr self) -> ofdm_cyclic_prefixer"""
        return _digital_swig0.ofdm_cyclic_prefixer_sptr___deref__(self)
    __swig_destroy__ = _digital_swig0.delete_ofdm_cyclic_prefixer_sptr

    def make(self, *args, **kwargs) -> "gr::digital::ofdm_cyclic_prefixer::sptr":
        r"""
        make(ofdm_cyclic_prefixer_sptr self, size_t input_size, size_t output_size, int rolloff_len=0, std::string const & len_tag_key="") -> ofdm_cyclic_prefixer_sptr
        Adds a cyclic prefix and performs pulse shaping on OFDM symbols.

        Input: OFDM symbols (in the time domain, i.e. after the IFFT). Optionally, entire frames can be processed. In this case,  must be specified which holds the key of the tag that denotes how many OFDM symbols are in a frame. Output: A stream of (scalar) complex symbols, which include the cyclic prefix and the pulse shaping. Note: If complete frames are processed, and  is greater than zero, the final OFDM symbol is followed by the delay line of the pulse shaping.


        The pulse shape is a raised cosine in the time domain.

        Constructor Specific Documentation:



        Args:
            input_size : FFT length (i.e. length of the OFDM symbols)
            output_size : FFT length + cyclic prefix length (in samples)
            rolloff_len : Length of the rolloff flank in samples
            len_tag_key : For framed processing the key of the length tag
        """
        return _digital_swig0.ofdm_cyclic_prefixer_sptr_make(self, *args, **kwargs)

    def history(self) -> "unsigned int":
        r"""history(ofdm_cyclic_prefixer_sptr self) -> unsigned int"""
        return _digital_swig0.ofdm_cyclic_prefixer_sptr_history(self)

    def declare_sample_delay(self, *args) -> "void":
        r"""
        declare_sample_delay(ofdm_cyclic_prefixer_sptr self, int which, int delay)
        declare_sample_delay(ofdm_cyclic_prefixer_sptr self, unsigned int delay)
        """
        return _digital_swig0.ofdm_cyclic_prefixer_sptr_declare_sample_delay(self, *args)

    def sample_delay(self, which: "int") -> "unsigned int":
        r"""sample_delay(ofdm_cyclic_prefixer_sptr self, int which) -> unsigned int"""
        return _digital_swig0.ofdm_cyclic_prefixer_sptr_sample_delay(self, which)

    def set_output_multiple(self, multiple: "int") -> "void":
        r"""set_output_multiple(ofdm_cyclic_prefixer_sptr self, int multiple)"""
        return _digital_swig0.ofdm_cyclic_prefixer_sptr_set_output_multiple(self, multiple)

    def output_multiple(self) -> "int":
        r"""output_multiple(ofdm_cyclic_prefixer_sptr self) -> int"""
        return _digital_swig0.ofdm_cyclic_prefixer_sptr_output_multiple(self)

    def relative_rate(self) -> "double":
        r"""relative_rate(ofdm_cyclic_prefixer_sptr self) -> double"""
        return _digital_swig0.ofdm_cyclic_prefixer_sptr_relative_rate(self)

    def relative_rate_i(self) -> "uint64_t":
        r"""relative_rate_i(ofdm_cyclic_prefixer_sptr self) -> uint64_t"""
        return _digital_swig0.ofdm_cyclic_prefixer_sptr_relative_rate_i(self)

    def relative_rate_d(self) -> "uint64_t":
        r"""relative_rate_d(ofdm_cyclic_prefixer_sptr self) -> uint64_t"""
        return _digital_swig0.ofdm_cyclic_prefixer_sptr_relative_rate_d(self)

    def start(self) -> "bool":
        r"""start(ofdm_cyclic_prefixer_sptr self) -> bool"""
        return _digital_swig0.ofdm_cyclic_prefixer_sptr_start(self)

    def stop(self) -> "bool":
        r"""stop(ofdm_cyclic_prefixer_sptr self) -> bool"""
        return _digital_swig0.ofdm_cyclic_prefixer_sptr_stop(self)

    def nitems_read(self, which_input: "unsigned int") -> "uint64_t":
        r"""nitems_read(ofdm_cyclic_prefixer_sptr self, unsigned int which_input) -> uint64_t"""
        return _digital_swig0.ofdm_cyclic_prefixer_sptr_nitems_read(self, which_input)

    def nitems_written(self, which_output: "unsigned int") -> "uint64_t":
        r"""nitems_written(ofdm_cyclic_prefixer_sptr self, unsigned int which_output) -> uint64_t"""
        return _digital_swig0.ofdm_cyclic_prefixer_sptr_nitems_written(self, which_output)

    def set_log_level(self, level: "std::string") -> "void":
        r"""set_log_level(ofdm_cyclic_prefixer_sptr self, std::string level)"""
        return _digital_swig0.ofdm_cyclic_prefixer_sptr_set_log_level(self, level)

    def log_level(self) -> "std::string":
        r"""log_level(ofdm_cyclic_prefixer_sptr self) -> std::string"""
        return _digital_swig0.ofdm_cyclic_prefixer_sptr_log_level(self)

    def max_noutput_items(self) -> "int":
        r"""max_noutput_items(ofdm_cyclic_prefixer_sptr self) -> int"""
        return _digital_swig0.ofdm_cyclic_prefixer_sptr_max_noutput_items(self)

    def set_max_noutput_items(self, m: "int") -> "void":
        r"""set_max_noutput_items(ofdm_cyclic_prefixer_sptr self, int m)"""
        return _digital_swig0.ofdm_cyclic_prefixer_sptr_set_max_noutput_items(self, m)

    def unset_max_noutput_items(self) -> "void":
        r"""unset_max_noutput_items(ofdm_cyclic_prefixer_sptr self)"""
        return _digital_swig0.ofdm_cyclic_prefixer_sptr_unset_max_noutput_items(self)

    def is_set_max_noutput_items(self) -> "bool":
        r"""is_set_max_noutput_items(ofdm_cyclic_prefixer_sptr self) -> bool"""
        return _digital_swig0.ofdm_cyclic_prefixer_sptr_is_set_max_noutput_items(self)

    def set_min_noutput_items(self, m: "int") -> "void":
        r"""set_min_noutput_items(ofdm_cyclic_prefixer_sptr self, int m)"""
        return _digital_swig0.ofdm_cyclic_prefixer_sptr_set_min_noutput_items(self, m)

    def min_noutput_items(self) -> "int":
        r"""min_noutput_items(ofdm_cyclic_prefixer_sptr self) -> int"""
        return _digital_swig0.ofdm_cyclic_prefixer_sptr_min_noutput_items(self)

    def max_output_buffer(self, i: "int") -> "long":
        r"""max_output_buffer(ofdm_cyclic_prefixer_sptr self, int i) -> long"""
        return _digital_swig0.ofdm_cyclic_prefixer_sptr_max_output_buffer(self, i)

    def set_max_output_buffer(self, *args) -> "void":
        r"""
        set_max_output_buffer(ofdm_cyclic_prefixer_sptr self, long max_output_buffer)
        set_max_output_buffer(ofdm_cyclic_prefixer_sptr self, int port, long max_output_buffer)
        """
        return _digital_swig0.ofdm_cyclic_prefixer_sptr_set_max_output_buffer(self, *args)

    def min_output_buffer(self, i: "int") -> "long":
        r"""min_output_buffer(ofdm_cyclic_prefixer_sptr self, int i) -> long"""
        return _digital_swig0.ofdm_cyclic_prefixer_sptr_min_output_buffer(self, i)

    def set_min_output_buffer(self, *args) -> "void":
        r"""
        set_min_output_buffer(ofdm_cyclic_prefixer_sptr self, long min_output_buffer)
        set_min_output_buffer(ofdm_cyclic_prefixer_sptr self, int port, long min_output_buffer)
        """
        return _digital_swig0.ofdm_cyclic_prefixer_sptr_set_min_output_buffer(self, *args)

    def pc_noutput_items(self) -> "float":
        r"""pc_noutput_items(ofdm_cyclic_prefixer_sptr self) -> float"""
        return _digital_swig0.ofdm_cyclic_prefixer_sptr_pc_noutput_items(self)

    def pc_noutput_items_avg(self) -> "float":
        r"""pc_noutput_items_avg(ofdm_cyclic_prefixer_sptr self) -> float"""
        return _digital_swig0.ofdm_cyclic_prefixer_sptr_pc_noutput_items_avg(self)

    def pc_noutput_items_var(self) -> "float":
        r"""pc_noutput_items_var(ofdm_cyclic_prefixer_sptr self) -> float"""
        return _digital_swig0.ofdm_cyclic_prefixer_sptr_pc_noutput_items_var(self)

    def pc_nproduced(self) -> "float":
        r"""pc_nproduced(ofdm_cyclic_prefixer_sptr self) -> float"""
        return _digital_swig0.ofdm_cyclic_prefixer_sptr_pc_nproduced(self)

    def pc_nproduced_avg(self) -> "float":
        r"""pc_nproduced_avg(ofdm_cyclic_prefixer_sptr self) -> float"""
        return _digital_swig0.ofdm_cyclic_prefixer_sptr_pc_nproduced_avg(self)

    def pc_nproduced_var(self) -> "float":
        r"""pc_nproduced_var(ofdm_cyclic_prefixer_sptr self) -> float"""
        return _digital_swig0.ofdm_cyclic_prefixer_sptr_pc_nproduced_var(self)

    def pc_input_buffers_full(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full(ofdm_cyclic_prefixer_sptr self, int which) -> float
        pc_input_buffers_full(ofdm_cyclic_prefixer_sptr self) -> pmt_vector_float
        """
        return _digital_swig0.ofdm_cyclic_prefixer_sptr_pc_input_buffers_full(self, *args)

    def pc_input_buffers_full_avg(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full_avg(ofdm_cyclic_prefixer_sptr self, int which) -> float
        pc_input_buffers_full_avg(ofdm_cyclic_prefixer_sptr self) -> pmt_vector_float
        """
        return _digital_swig0.ofdm_cyclic_prefixer_sptr_pc_input_buffers_full_avg(self, *args)

    def pc_input_buffers_full_var(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full_var(ofdm_cyclic_prefixer_sptr self, int which) -> float
        pc_input_buffers_full_var(ofdm_cyclic_prefixer_sptr self) -> pmt_vector_float
        """
        return _digital_swig0.ofdm_cyclic_prefixer_sptr_pc_input_buffers_full_var(self, *args)

    def pc_output_buffers_full(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full(ofdm_cyclic_prefixer_sptr self, int which) -> float
        pc_output_buffers_full(ofdm_cyclic_prefixer_sptr self) -> pmt_vector_float
        """
        return _digital_swig0.ofdm_cyclic_prefixer_sptr_pc_output_buffers_full(self, *args)

    def pc_output_buffers_full_avg(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full_avg(ofdm_cyclic_prefixer_sptr self, int which) -> float
        pc_output_buffers_full_avg(ofdm_cyclic_prefixer_sptr self) -> pmt_vector_float
        """
        return _digital_swig0.ofdm_cyclic_prefixer_sptr_pc_output_buffers_full_avg(self, *args)

    def pc_output_buffers_full_var(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full_var(ofdm_cyclic_prefixer_sptr self, int which) -> float
        pc_output_buffers_full_var(ofdm_cyclic_prefixer_sptr self) -> pmt_vector_float
        """
        return _digital_swig0.ofdm_cyclic_prefixer_sptr_pc_output_buffers_full_var(self, *args)

    def pc_work_time(self) -> "float":
        r"""pc_work_time(ofdm_cyclic_prefixer_sptr self) -> float"""
        return _digital_swig0.ofdm_cyclic_prefixer_sptr_pc_work_time(self)

    def pc_work_time_avg(self) -> "float":
        r"""pc_work_time_avg(ofdm_cyclic_prefixer_sptr self) -> float"""
        return _digital_swig0.ofdm_cyclic_prefixer_sptr_pc_work_time_avg(self)

    def pc_work_time_var(self) -> "float":
        r"""pc_work_time_var(ofdm_cyclic_prefixer_sptr self) -> float"""
        return _digital_swig0.ofdm_cyclic_prefixer_sptr_pc_work_time_var(self)

    def pc_work_time_total(self) -> "float":
        r"""pc_work_time_total(ofdm_cyclic_prefixer_sptr self) -> float"""
        return _digital_swig0.ofdm_cyclic_prefixer_sptr_pc_work_time_total(self)

    def pc_throughput_avg(self) -> "float":
        r"""pc_throughput_avg(ofdm_cyclic_prefixer_sptr self) -> float"""
        return _digital_swig0.ofdm_cyclic_prefixer_sptr_pc_throughput_avg(self)

    def set_processor_affinity(self, mask: "std::vector< int,std::allocator< int > > const &") -> "void":
        r"""set_processor_affinity(ofdm_cyclic_prefixer_sptr self, std::vector< int,std::allocator< int > > const & mask)"""
        return _digital_swig0.ofdm_cyclic_prefixer_sptr_set_processor_affinity(self, mask)

    def unset_processor_affinity(self) -> "void":
        r"""unset_processor_affinity(ofdm_cyclic_prefixer_sptr self)"""
        return _digital_swig0.ofdm_cyclic_prefixer_sptr_unset_processor_affinity(self)

    def processor_affinity(self) -> "std::vector< int,std::allocator< int > >":
        r"""processor_affinity(ofdm_cyclic_prefixer_sptr self) -> std::vector< int,std::allocator< int > >"""
        return _digital_swig0.ofdm_cyclic_prefixer_sptr_processor_affinity(self)

    def active_thread_priority(self) -> "int":
        r"""active_thread_priority(ofdm_cyclic_prefixer_sptr self) -> int"""
        return _digital_swig0.ofdm_cyclic_prefixer_sptr_active_thread_priority(self)

    def thread_priority(self) -> "int":
        r"""thread_priority(ofdm_cyclic_prefixer_sptr self) -> int"""
        return _digital_swig0.ofdm_cyclic_prefixer_sptr_thread_priority(self)

    def set_thread_priority(self, priority: "int") -> "int":
        r"""set_thread_priority(ofdm_cyclic_prefixer_sptr self, int priority) -> int"""
        return _digital_swig0.ofdm_cyclic_prefixer_sptr_set_thread_priority(self, priority)

    def name(self) -> "std::string":
        r"""name(ofdm_cyclic_prefixer_sptr self) -> std::string"""
        return _digital_swig0.ofdm_cyclic_prefixer_sptr_name(self)

    def symbol_name(self) -> "std::string":
        r"""symbol_name(ofdm_cyclic_prefixer_sptr self) -> std::string"""
        return _digital_swig0.ofdm_cyclic_prefixer_sptr_symbol_name(self)

    def input_signature(self) -> "gr::io_signature::sptr":
        r"""input_signature(ofdm_cyclic_prefixer_sptr self) -> io_signature_sptr"""
        return _digital_swig0.ofdm_cyclic_prefixer_sptr_input_signature(self)

    def output_signature(self) -> "gr::io_signature::sptr":
        r"""output_signature(ofdm_cyclic_prefixer_sptr self) -> io_signature_sptr"""
        return _digital_swig0.ofdm_cyclic_prefixer_sptr_output_signature(self)

    def unique_id(self) -> "long":
        r"""unique_id(ofdm_cyclic_prefixer_sptr self) -> long"""
        return _digital_swig0.ofdm_cyclic_prefixer_sptr_unique_id(self)

    def to_basic_block(self) -> "gr::basic_block_sptr":
        r"""to_basic_block(ofdm_cyclic_prefixer_sptr self) -> basic_block_sptr"""
        return _digital_swig0.ofdm_cyclic_prefixer_sptr_to_basic_block(self)

    def check_topology(self, ninputs: "int", noutputs: "int") -> "bool":
        r"""check_topology(ofdm_cyclic_prefixer_sptr self, int ninputs, int noutputs) -> bool"""
        return _digital_swig0.ofdm_cyclic_prefixer_sptr_check_topology(self, ninputs, noutputs)

    def alias(self) -> "std::string":
        r"""alias(ofdm_cyclic_prefixer_sptr self) -> std::string"""
        return _digital_swig0.ofdm_cyclic_prefixer_sptr_alias(self)

    def set_block_alias(self, name: "std::string") -> "void":
        r"""set_block_alias(ofdm_cyclic_prefixer_sptr self, std::string name)"""
        return _digital_swig0.ofdm_cyclic_prefixer_sptr_set_block_alias(self, name)

    def _post(self, which_port: "swig_pmt_ptr", msg: "swig_pmt_ptr") -> "void":
        r"""_post(ofdm_cyclic_prefixer_sptr self, swig_pmt_ptr which_port, swig_pmt_ptr msg)"""
        return _digital_swig0.ofdm_cyclic_prefixer_sptr__post(self, which_port, msg)

    def message_ports_in(self) -> "pmt::pmt_t":
        r"""message_ports_in(ofdm_cyclic_prefixer_sptr self) -> swig_pmt_ptr"""
        return _digital_swig0.ofdm_cyclic_prefixer_sptr_message_ports_in(self)

    def message_ports_out(self) -> "pmt::pmt_t":
        r"""message_ports_out(ofdm_cyclic_prefixer_sptr self) -> swig_pmt_ptr"""
        return _digital_swig0.ofdm_cyclic_prefixer_sptr_message_ports_out(self)

    def message_subscribers(self, which_port: "swig_pmt_ptr") -> "pmt::pmt_t":
        r"""message_subscribers(ofdm_cyclic_prefixer_sptr self, swig_pmt_ptr which_port) -> swig_pmt_ptr"""
        return _digital_swig0.ofdm_cyclic_prefixer_sptr_message_subscribers(self, which_port)

# Register ofdm_cyclic_prefixer_sptr in _digital_swig0:
_digital_swig0.ofdm_cyclic_prefixer_sptr_swigregister(ofdm_cyclic_prefixer_sptr)

ofdm_cyclic_prefixer_sptr.__repr__ = lambda self: "<gr_block %s (%d)>" % (self.name(), self.unique_id())
ofdm_cyclic_prefixer = ofdm_cyclic_prefixer.make;

class ofdm_frame_equalizer_vcvc_sptr(object):
    r"""Proxy of C++ boost::shared_ptr< gr::digital::ofdm_frame_equalizer_vcvc > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(ofdm_frame_equalizer_vcvc_sptr self) -> ofdm_frame_equalizer_vcvc_sptr
        __init__(ofdm_frame_equalizer_vcvc_sptr self, ofdm_frame_equalizer_vcvc p) -> ofdm_frame_equalizer_vcvc_sptr
        """
        _digital_swig0.ofdm_frame_equalizer_vcvc_sptr_swiginit(self, _digital_swig0.new_ofdm_frame_equalizer_vcvc_sptr(*args))

    def __deref__(self) -> "gr::digital::ofdm_frame_equalizer_vcvc *":
        r"""__deref__(ofdm_frame_equalizer_vcvc_sptr self) -> ofdm_frame_equalizer_vcvc"""
        return _digital_swig0.ofdm_frame_equalizer_vcvc_sptr___deref__(self)
    __swig_destroy__ = _digital_swig0.delete_ofdm_frame_equalizer_vcvc_sptr

    def make(self, *args, **kwargs) -> "gr::digital::ofdm_frame_equalizer_vcvc::sptr":
        r"""
        make(ofdm_frame_equalizer_vcvc_sptr self, ofdm_equalizer_base_sptr equalizer, int cp_len, std::string const & tsb_key="frame_len", bool propagate_channel_state=False, int fixed_frame_len=0) -> ofdm_frame_equalizer_vcvc_sptr
        OFDM frame equalizer.

        Performs equalization in one or two dimensions on a tagged OFDM frame.


        This does two things: First, it removes the coarse carrier offset. If a tag is found on the first item with the key 'ofdm_sync_carr_offset', this is interpreted as the coarse frequency offset in number of carriers. Next, it performs equalization in one or two dimensions on a tagged OFDM frame. The actual equalization is done by a ofdm_frame_equalizer object, outside of the block.


        Note that the tag with the coarse carrier offset is not removed. Blocks downstream from this block must not attempt to also correct this offset.


        Input: a tagged series of OFDM symbols. Output: The same as the input, but equalized and frequency-corrected.

        Constructor Specific Documentation:



        Args:
            equalizer : The equalizer object that will do the actual work
            cp_len : Length of the cyclic prefix in samples (required to correct the frequency offset)
            tsb_key : TSB key
            propagate_channel_state : If true, the channel state after the last symbol will be added to the first symbol as a tag
            fixed_frame_len : Set if the frame length is fixed. When this value is given, the TSB tag key can be left empty, but it is useful even when using tagged streams at the input.
        """
        return _digital_swig0.ofdm_frame_equalizer_vcvc_sptr_make(self, *args, **kwargs)

    def history(self) -> "unsigned int":
        r"""history(ofdm_frame_equalizer_vcvc_sptr self) -> unsigned int"""
        return _digital_swig0.ofdm_frame_equalizer_vcvc_sptr_history(self)

    def declare_sample_delay(self, *args) -> "void":
        r"""
        declare_sample_delay(ofdm_frame_equalizer_vcvc_sptr self, int which, int delay)
        declare_sample_delay(ofdm_frame_equalizer_vcvc_sptr self, unsigned int delay)
        """
        return _digital_swig0.ofdm_frame_equalizer_vcvc_sptr_declare_sample_delay(self, *args)

    def sample_delay(self, which: "int") -> "unsigned int":
        r"""sample_delay(ofdm_frame_equalizer_vcvc_sptr self, int which) -> unsigned int"""
        return _digital_swig0.ofdm_frame_equalizer_vcvc_sptr_sample_delay(self, which)

    def set_output_multiple(self, multiple: "int") -> "void":
        r"""set_output_multiple(ofdm_frame_equalizer_vcvc_sptr self, int multiple)"""
        return _digital_swig0.ofdm_frame_equalizer_vcvc_sptr_set_output_multiple(self, multiple)

    def output_multiple(self) -> "int":
        r"""output_multiple(ofdm_frame_equalizer_vcvc_sptr self) -> int"""
        return _digital_swig0.ofdm_frame_equalizer_vcvc_sptr_output_multiple(self)

    def relative_rate(self) -> "double":
        r"""relative_rate(ofdm_frame_equalizer_vcvc_sptr self) -> double"""
        return _digital_swig0.ofdm_frame_equalizer_vcvc_sptr_relative_rate(self)

    def relative_rate_i(self) -> "uint64_t":
        r"""relative_rate_i(ofdm_frame_equalizer_vcvc_sptr self) -> uint64_t"""
        return _digital_swig0.ofdm_frame_equalizer_vcvc_sptr_relative_rate_i(self)

    def relative_rate_d(self) -> "uint64_t":
        r"""relative_rate_d(ofdm_frame_equalizer_vcvc_sptr self) -> uint64_t"""
        return _digital_swig0.ofdm_frame_equalizer_vcvc_sptr_relative_rate_d(self)

    def start(self) -> "bool":
        r"""start(ofdm_frame_equalizer_vcvc_sptr self) -> bool"""
        return _digital_swig0.ofdm_frame_equalizer_vcvc_sptr_start(self)

    def stop(self) -> "bool":
        r"""stop(ofdm_frame_equalizer_vcvc_sptr self) -> bool"""
        return _digital_swig0.ofdm_frame_equalizer_vcvc_sptr_stop(self)

    def nitems_read(self, which_input: "unsigned int") -> "uint64_t":
        r"""nitems_read(ofdm_frame_equalizer_vcvc_sptr self, unsigned int which_input) -> uint64_t"""
        return _digital_swig0.ofdm_frame_equalizer_vcvc_sptr_nitems_read(self, which_input)

    def nitems_written(self, which_output: "unsigned int") -> "uint64_t":
        r"""nitems_written(ofdm_frame_equalizer_vcvc_sptr self, unsigned int which_output) -> uint64_t"""
        return _digital_swig0.ofdm_frame_equalizer_vcvc_sptr_nitems_written(self, which_output)

    def set_log_level(self, level: "std::string") -> "void":
        r"""set_log_level(ofdm_frame_equalizer_vcvc_sptr self, std::string level)"""
        return _digital_swig0.ofdm_frame_equalizer_vcvc_sptr_set_log_level(self, level)

    def log_level(self) -> "std::string":
        r"""log_level(ofdm_frame_equalizer_vcvc_sptr self) -> std::string"""
        return _digital_swig0.ofdm_frame_equalizer_vcvc_sptr_log_level(self)

    def max_noutput_items(self) -> "int":
        r"""max_noutput_items(ofdm_frame_equalizer_vcvc_sptr self) -> int"""
        return _digital_swig0.ofdm_frame_equalizer_vcvc_sptr_max_noutput_items(self)

    def set_max_noutput_items(self, m: "int") -> "void":
        r"""set_max_noutput_items(ofdm_frame_equalizer_vcvc_sptr self, int m)"""
        return _digital_swig0.ofdm_frame_equalizer_vcvc_sptr_set_max_noutput_items(self, m)

    def unset_max_noutput_items(self) -> "void":
        r"""unset_max_noutput_items(ofdm_frame_equalizer_vcvc_sptr self)"""
        return _digital_swig0.ofdm_frame_equalizer_vcvc_sptr_unset_max_noutput_items(self)

    def is_set_max_noutput_items(self) -> "bool":
        r"""is_set_max_noutput_items(ofdm_frame_equalizer_vcvc_sptr self) -> bool"""
        return _digital_swig0.ofdm_frame_equalizer_vcvc_sptr_is_set_max_noutput_items(self)

    def set_min_noutput_items(self, m: "int") -> "void":
        r"""set_min_noutput_items(ofdm_frame_equalizer_vcvc_sptr self, int m)"""
        return _digital_swig0.ofdm_frame_equalizer_vcvc_sptr_set_min_noutput_items(self, m)

    def min_noutput_items(self) -> "int":
        r"""min_noutput_items(ofdm_frame_equalizer_vcvc_sptr self) -> int"""
        return _digital_swig0.ofdm_frame_equalizer_vcvc_sptr_min_noutput_items(self)

    def max_output_buffer(self, i: "int") -> "long":
        r"""max_output_buffer(ofdm_frame_equalizer_vcvc_sptr self, int i) -> long"""
        return _digital_swig0.ofdm_frame_equalizer_vcvc_sptr_max_output_buffer(self, i)

    def set_max_output_buffer(self, *args) -> "void":
        r"""
        set_max_output_buffer(ofdm_frame_equalizer_vcvc_sptr self, long max_output_buffer)
        set_max_output_buffer(ofdm_frame_equalizer_vcvc_sptr self, int port, long max_output_buffer)
        """
        return _digital_swig0.ofdm_frame_equalizer_vcvc_sptr_set_max_output_buffer(self, *args)

    def min_output_buffer(self, i: "int") -> "long":
        r"""min_output_buffer(ofdm_frame_equalizer_vcvc_sptr self, int i) -> long"""
        return _digital_swig0.ofdm_frame_equalizer_vcvc_sptr_min_output_buffer(self, i)

    def set_min_output_buffer(self, *args) -> "void":
        r"""
        set_min_output_buffer(ofdm_frame_equalizer_vcvc_sptr self, long min_output_buffer)
        set_min_output_buffer(ofdm_frame_equalizer_vcvc_sptr self, int port, long min_output_buffer)
        """
        return _digital_swig0.ofdm_frame_equalizer_vcvc_sptr_set_min_output_buffer(self, *args)

    def pc_noutput_items(self) -> "float":
        r"""pc_noutput_items(ofdm_frame_equalizer_vcvc_sptr self) -> float"""
        return _digital_swig0.ofdm_frame_equalizer_vcvc_sptr_pc_noutput_items(self)

    def pc_noutput_items_avg(self) -> "float":
        r"""pc_noutput_items_avg(ofdm_frame_equalizer_vcvc_sptr self) -> float"""
        return _digital_swig0.ofdm_frame_equalizer_vcvc_sptr_pc_noutput_items_avg(self)

    def pc_noutput_items_var(self) -> "float":
        r"""pc_noutput_items_var(ofdm_frame_equalizer_vcvc_sptr self) -> float"""
        return _digital_swig0.ofdm_frame_equalizer_vcvc_sptr_pc_noutput_items_var(self)

    def pc_nproduced(self) -> "float":
        r"""pc_nproduced(ofdm_frame_equalizer_vcvc_sptr self) -> float"""
        return _digital_swig0.ofdm_frame_equalizer_vcvc_sptr_pc_nproduced(self)

    def pc_nproduced_avg(self) -> "float":
        r"""pc_nproduced_avg(ofdm_frame_equalizer_vcvc_sptr self) -> float"""
        return _digital_swig0.ofdm_frame_equalizer_vcvc_sptr_pc_nproduced_avg(self)

    def pc_nproduced_var(self) -> "float":
        r"""pc_nproduced_var(ofdm_frame_equalizer_vcvc_sptr self) -> float"""
        return _digital_swig0.ofdm_frame_equalizer_vcvc_sptr_pc_nproduced_var(self)

    def pc_input_buffers_full(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full(ofdm_frame_equalizer_vcvc_sptr self, int which) -> float
        pc_input_buffers_full(ofdm_frame_equalizer_vcvc_sptr self) -> pmt_vector_float
        """
        return _digital_swig0.ofdm_frame_equalizer_vcvc_sptr_pc_input_buffers_full(self, *args)

    def pc_input_buffers_full_avg(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full_avg(ofdm_frame_equalizer_vcvc_sptr self, int which) -> float
        pc_input_buffers_full_avg(ofdm_frame_equalizer_vcvc_sptr self) -> pmt_vector_float
        """
        return _digital_swig0.ofdm_frame_equalizer_vcvc_sptr_pc_input_buffers_full_avg(self, *args)

    def pc_input_buffers_full_var(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full_var(ofdm_frame_equalizer_vcvc_sptr self, int which) -> float
        pc_input_buffers_full_var(ofdm_frame_equalizer_vcvc_sptr self) -> pmt_vector_float
        """
        return _digital_swig0.ofdm_frame_equalizer_vcvc_sptr_pc_input_buffers_full_var(self, *args)

    def pc_output_buffers_full(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full(ofdm_frame_equalizer_vcvc_sptr self, int which) -> float
        pc_output_buffers_full(ofdm_frame_equalizer_vcvc_sptr self) -> pmt_vector_float
        """
        return _digital_swig0.ofdm_frame_equalizer_vcvc_sptr_pc_output_buffers_full(self, *args)

    def pc_output_buffers_full_avg(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full_avg(ofdm_frame_equalizer_vcvc_sptr self, int which) -> float
        pc_output_buffers_full_avg(ofdm_frame_equalizer_vcvc_sptr self) -> pmt_vector_float
        """
        return _digital_swig0.ofdm_frame_equalizer_vcvc_sptr_pc_output_buffers_full_avg(self, *args)

    def pc_output_buffers_full_var(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full_var(ofdm_frame_equalizer_vcvc_sptr self, int which) -> float
        pc_output_buffers_full_var(ofdm_frame_equalizer_vcvc_sptr self) -> pmt_vector_float
        """
        return _digital_swig0.ofdm_frame_equalizer_vcvc_sptr_pc_output_buffers_full_var(self, *args)

    def pc_work_time(self) -> "float":
        r"""pc_work_time(ofdm_frame_equalizer_vcvc_sptr self) -> float"""
        return _digital_swig0.ofdm_frame_equalizer_vcvc_sptr_pc_work_time(self)

    def pc_work_time_avg(self) -> "float":
        r"""pc_work_time_avg(ofdm_frame_equalizer_vcvc_sptr self) -> float"""
        return _digital_swig0.ofdm_frame_equalizer_vcvc_sptr_pc_work_time_avg(self)

    def pc_work_time_var(self) -> "float":
        r"""pc_work_time_var(ofdm_frame_equalizer_vcvc_sptr self) -> float"""
        return _digital_swig0.ofdm_frame_equalizer_vcvc_sptr_pc_work_time_var(self)

    def pc_work_time_total(self) -> "float":
        r"""pc_work_time_total(ofdm_frame_equalizer_vcvc_sptr self) -> float"""
        return _digital_swig0.ofdm_frame_equalizer_vcvc_sptr_pc_work_time_total(self)

    def pc_throughput_avg(self) -> "float":
        r"""pc_throughput_avg(ofdm_frame_equalizer_vcvc_sptr self) -> float"""
        return _digital_swig0.ofdm_frame_equalizer_vcvc_sptr_pc_throughput_avg(self)

    def set_processor_affinity(self, mask: "std::vector< int,std::allocator< int > > const &") -> "void":
        r"""set_processor_affinity(ofdm_frame_equalizer_vcvc_sptr self, std::vector< int,std::allocator< int > > const & mask)"""
        return _digital_swig0.ofdm_frame_equalizer_vcvc_sptr_set_processor_affinity(self, mask)

    def unset_processor_affinity(self) -> "void":
        r"""unset_processor_affinity(ofdm_frame_equalizer_vcvc_sptr self)"""
        return _digital_swig0.ofdm_frame_equalizer_vcvc_sptr_unset_processor_affinity(self)

    def processor_affinity(self) -> "std::vector< int,std::allocator< int > >":
        r"""processor_affinity(ofdm_frame_equalizer_vcvc_sptr self) -> std::vector< int,std::allocator< int > >"""
        return _digital_swig0.ofdm_frame_equalizer_vcvc_sptr_processor_affinity(self)

    def active_thread_priority(self) -> "int":
        r"""active_thread_priority(ofdm_frame_equalizer_vcvc_sptr self) -> int"""
        return _digital_swig0.ofdm_frame_equalizer_vcvc_sptr_active_thread_priority(self)

    def thread_priority(self) -> "int":
        r"""thread_priority(ofdm_frame_equalizer_vcvc_sptr self) -> int"""
        return _digital_swig0.ofdm_frame_equalizer_vcvc_sptr_thread_priority(self)

    def set_thread_priority(self, priority: "int") -> "int":
        r"""set_thread_priority(ofdm_frame_equalizer_vcvc_sptr self, int priority) -> int"""
        return _digital_swig0.ofdm_frame_equalizer_vcvc_sptr_set_thread_priority(self, priority)

    def name(self) -> "std::string":
        r"""name(ofdm_frame_equalizer_vcvc_sptr self) -> std::string"""
        return _digital_swig0.ofdm_frame_equalizer_vcvc_sptr_name(self)

    def symbol_name(self) -> "std::string":
        r"""symbol_name(ofdm_frame_equalizer_vcvc_sptr self) -> std::string"""
        return _digital_swig0.ofdm_frame_equalizer_vcvc_sptr_symbol_name(self)

    def input_signature(self) -> "gr::io_signature::sptr":
        r"""input_signature(ofdm_frame_equalizer_vcvc_sptr self) -> io_signature_sptr"""
        return _digital_swig0.ofdm_frame_equalizer_vcvc_sptr_input_signature(self)

    def output_signature(self) -> "gr::io_signature::sptr":
        r"""output_signature(ofdm_frame_equalizer_vcvc_sptr self) -> io_signature_sptr"""
        return _digital_swig0.ofdm_frame_equalizer_vcvc_sptr_output_signature(self)

    def unique_id(self) -> "long":
        r"""unique_id(ofdm_frame_equalizer_vcvc_sptr self) -> long"""
        return _digital_swig0.ofdm_frame_equalizer_vcvc_sptr_unique_id(self)

    def to_basic_block(self) -> "gr::basic_block_sptr":
        r"""to_basic_block(ofdm_frame_equalizer_vcvc_sptr self) -> basic_block_sptr"""
        return _digital_swig0.ofdm_frame_equalizer_vcvc_sptr_to_basic_block(self)

    def check_topology(self, ninputs: "int", noutputs: "int") -> "bool":
        r"""check_topology(ofdm_frame_equalizer_vcvc_sptr self, int ninputs, int noutputs) -> bool"""
        return _digital_swig0.ofdm_frame_equalizer_vcvc_sptr_check_topology(self, ninputs, noutputs)

    def alias(self) -> "std::string":
        r"""alias(ofdm_frame_equalizer_vcvc_sptr self) -> std::string"""
        return _digital_swig0.ofdm_frame_equalizer_vcvc_sptr_alias(self)

    def set_block_alias(self, name: "std::string") -> "void":
        r"""set_block_alias(ofdm_frame_equalizer_vcvc_sptr self, std::string name)"""
        return _digital_swig0.ofdm_frame_equalizer_vcvc_sptr_set_block_alias(self, name)

    def _post(self, which_port: "swig_pmt_ptr", msg: "swig_pmt_ptr") -> "void":
        r"""_post(ofdm_frame_equalizer_vcvc_sptr self, swig_pmt_ptr which_port, swig_pmt_ptr msg)"""
        return _digital_swig0.ofdm_frame_equalizer_vcvc_sptr__post(self, which_port, msg)

    def message_ports_in(self) -> "pmt::pmt_t":
        r"""message_ports_in(ofdm_frame_equalizer_vcvc_sptr self) -> swig_pmt_ptr"""
        return _digital_swig0.ofdm_frame_equalizer_vcvc_sptr_message_ports_in(self)

    def message_ports_out(self) -> "pmt::pmt_t":
        r"""message_ports_out(ofdm_frame_equalizer_vcvc_sptr self) -> swig_pmt_ptr"""
        return _digital_swig0.ofdm_frame_equalizer_vcvc_sptr_message_ports_out(self)

    def message_subscribers(self, which_port: "swig_pmt_ptr") -> "pmt::pmt_t":
        r"""message_subscribers(ofdm_frame_equalizer_vcvc_sptr self, swig_pmt_ptr which_port) -> swig_pmt_ptr"""
        return _digital_swig0.ofdm_frame_equalizer_vcvc_sptr_message_subscribers(self, which_port)

# Register ofdm_frame_equalizer_vcvc_sptr in _digital_swig0:
_digital_swig0.ofdm_frame_equalizer_vcvc_sptr_swigregister(ofdm_frame_equalizer_vcvc_sptr)

ofdm_frame_equalizer_vcvc_sptr.__repr__ = lambda self: "<gr_block %s (%d)>" % (self.name(), self.unique_id())
ofdm_frame_equalizer_vcvc = ofdm_frame_equalizer_vcvc.make;

class ofdm_serializer_vcc_sptr(object):
    r"""Proxy of C++ boost::shared_ptr< gr::digital::ofdm_serializer_vcc > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(ofdm_serializer_vcc_sptr self) -> ofdm_serializer_vcc_sptr
        __init__(ofdm_serializer_vcc_sptr self, ofdm_serializer_vcc p) -> ofdm_serializer_vcc_sptr
        """
        _digital_swig0.ofdm_serializer_vcc_sptr_swiginit(self, _digital_swig0.new_ofdm_serializer_vcc_sptr(*args))

    def __deref__(self) -> "gr::digital::ofdm_serializer_vcc *":
        r"""__deref__(ofdm_serializer_vcc_sptr self) -> ofdm_serializer_vcc"""
        return _digital_swig0.ofdm_serializer_vcc_sptr___deref__(self)
    __swig_destroy__ = _digital_swig0.delete_ofdm_serializer_vcc_sptr

    def make(self, *args) -> "gr::digital::ofdm_serializer_vcc::sptr":
        r"""
        make(ofdm_serializer_vcc_sptr self, int fft_len, std::vector< std::vector< int,std::allocator< int > >,std::allocator< std::vector< int,std::allocator< int > > > > const & occupied_carriers, std::string const & len_tag_key="frame_len", std::string const & packet_len_tag_key="", int symbols_skipped=0, std::string const & carr_offset_key="", bool input_is_shifted=True) -> ofdm_serializer_vcc_sptr
        make(ofdm_serializer_vcc_sptr self, ofdm_carrier_allocator_cvc_sptr allocator, std::string const & packet_len_tag_key="", int symbols_skipped=0, std::string const & carr_offset_key="", bool input_is_shifted=True) -> ofdm_serializer_vcc_sptr
        Serializes complex modulations symbols from OFDM sub-carriers.

        This is the inverse block to the carrier_allocator_cvc. It outputs the complex data symbols as a tagged stream, discarding the pilot symbols.


        If given, two different tags are parsed: The first key () specifies the number of OFDM symbols in the frame at the input. The second key () specifies the number of complex symbols that are coded into this frame. If given, this second key is then used at the output, otherwise,  is used. If both are given, the packet length specifies the maximum number of output items, and the frame length specifies the exact number of consumed input items.


        It is possible to correct a carrier offset in this function by passing another tag with said offset.


        Input: Complex vectors of length  Output: Complex scalars, in the same order as specified in occupied_carriers.

        Constructor Specific Documentation:



        Args:
            fft_len : FFT length
            occupied_carriers : See ofdm_carrier_allocator_cvc.
            len_tag_key : The key of the tag identifying the length of the input frame in OFDM symbols.
            packet_len_tag_key : The key of the tag identifying the number of complex symbols in this packet.
            symbols_skipped : If the first symbol is not allocated as in [0], set this
            carr_offset_key : When this block should correct a carrier offset, specify the tag key of the offset here (not necessary if following an ofdm_frame_equalizer_vcvc)
            input_is_shifted : If the input has the DC carrier on index 0 (i.e. it is not FFT shifted), set this to false
        """
        return _digital_swig0.ofdm_serializer_vcc_sptr_make(self, *args)

    def history(self) -> "unsigned int":
        r"""history(ofdm_serializer_vcc_sptr self) -> unsigned int"""
        return _digital_swig0.ofdm_serializer_vcc_sptr_history(self)

    def declare_sample_delay(self, *args) -> "void":
        r"""
        declare_sample_delay(ofdm_serializer_vcc_sptr self, int which, int delay)
        declare_sample_delay(ofdm_serializer_vcc_sptr self, unsigned int delay)
        """
        return _digital_swig0.ofdm_serializer_vcc_sptr_declare_sample_delay(self, *args)

    def sample_delay(self, which: "int") -> "unsigned int":
        r"""sample_delay(ofdm_serializer_vcc_sptr self, int which) -> unsigned int"""
        return _digital_swig0.ofdm_serializer_vcc_sptr_sample_delay(self, which)

    def set_output_multiple(self, multiple: "int") -> "void":
        r"""set_output_multiple(ofdm_serializer_vcc_sptr self, int multiple)"""
        return _digital_swig0.ofdm_serializer_vcc_sptr_set_output_multiple(self, multiple)

    def output_multiple(self) -> "int":
        r"""output_multiple(ofdm_serializer_vcc_sptr self) -> int"""
        return _digital_swig0.ofdm_serializer_vcc_sptr_output_multiple(self)

    def relative_rate(self) -> "double":
        r"""relative_rate(ofdm_serializer_vcc_sptr self) -> double"""
        return _digital_swig0.ofdm_serializer_vcc_sptr_relative_rate(self)

    def relative_rate_i(self) -> "uint64_t":
        r"""relative_rate_i(ofdm_serializer_vcc_sptr self) -> uint64_t"""
        return _digital_swig0.ofdm_serializer_vcc_sptr_relative_rate_i(self)

    def relative_rate_d(self) -> "uint64_t":
        r"""relative_rate_d(ofdm_serializer_vcc_sptr self) -> uint64_t"""
        return _digital_swig0.ofdm_serializer_vcc_sptr_relative_rate_d(self)

    def start(self) -> "bool":
        r"""start(ofdm_serializer_vcc_sptr self) -> bool"""
        return _digital_swig0.ofdm_serializer_vcc_sptr_start(self)

    def stop(self) -> "bool":
        r"""stop(ofdm_serializer_vcc_sptr self) -> bool"""
        return _digital_swig0.ofdm_serializer_vcc_sptr_stop(self)

    def nitems_read(self, which_input: "unsigned int") -> "uint64_t":
        r"""nitems_read(ofdm_serializer_vcc_sptr self, unsigned int which_input) -> uint64_t"""
        return _digital_swig0.ofdm_serializer_vcc_sptr_nitems_read(self, which_input)

    def nitems_written(self, which_output: "unsigned int") -> "uint64_t":
        r"""nitems_written(ofdm_serializer_vcc_sptr self, unsigned int which_output) -> uint64_t"""
        return _digital_swig0.ofdm_serializer_vcc_sptr_nitems_written(self, which_output)

    def set_log_level(self, level: "std::string") -> "void":
        r"""set_log_level(ofdm_serializer_vcc_sptr self, std::string level)"""
        return _digital_swig0.ofdm_serializer_vcc_sptr_set_log_level(self, level)

    def log_level(self) -> "std::string":
        r"""log_level(ofdm_serializer_vcc_sptr self) -> std::string"""
        return _digital_swig0.ofdm_serializer_vcc_sptr_log_level(self)

    def max_noutput_items(self) -> "int":
        r"""max_noutput_items(ofdm_serializer_vcc_sptr self) -> int"""
        return _digital_swig0.ofdm_serializer_vcc_sptr_max_noutput_items(self)

    def set_max_noutput_items(self, m: "int") -> "void":
        r"""set_max_noutput_items(ofdm_serializer_vcc_sptr self, int m)"""
        return _digital_swig0.ofdm_serializer_vcc_sptr_set_max_noutput_items(self, m)

    def unset_max_noutput_items(self) -> "void":
        r"""unset_max_noutput_items(ofdm_serializer_vcc_sptr self)"""
        return _digital_swig0.ofdm_serializer_vcc_sptr_unset_max_noutput_items(self)

    def is_set_max_noutput_items(self) -> "bool":
        r"""is_set_max_noutput_items(ofdm_serializer_vcc_sptr self) -> bool"""
        return _digital_swig0.ofdm_serializer_vcc_sptr_is_set_max_noutput_items(self)

    def set_min_noutput_items(self, m: "int") -> "void":
        r"""set_min_noutput_items(ofdm_serializer_vcc_sptr self, int m)"""
        return _digital_swig0.ofdm_serializer_vcc_sptr_set_min_noutput_items(self, m)

    def min_noutput_items(self) -> "int":
        r"""min_noutput_items(ofdm_serializer_vcc_sptr self) -> int"""
        return _digital_swig0.ofdm_serializer_vcc_sptr_min_noutput_items(self)

    def max_output_buffer(self, i: "int") -> "long":
        r"""max_output_buffer(ofdm_serializer_vcc_sptr self, int i) -> long"""
        return _digital_swig0.ofdm_serializer_vcc_sptr_max_output_buffer(self, i)

    def set_max_output_buffer(self, *args) -> "void":
        r"""
        set_max_output_buffer(ofdm_serializer_vcc_sptr self, long max_output_buffer)
        set_max_output_buffer(ofdm_serializer_vcc_sptr self, int port, long max_output_buffer)
        """
        return _digital_swig0.ofdm_serializer_vcc_sptr_set_max_output_buffer(self, *args)

    def min_output_buffer(self, i: "int") -> "long":
        r"""min_output_buffer(ofdm_serializer_vcc_sptr self, int i) -> long"""
        return _digital_swig0.ofdm_serializer_vcc_sptr_min_output_buffer(self, i)

    def set_min_output_buffer(self, *args) -> "void":
        r"""
        set_min_output_buffer(ofdm_serializer_vcc_sptr self, long min_output_buffer)
        set_min_output_buffer(ofdm_serializer_vcc_sptr self, int port, long min_output_buffer)
        """
        return _digital_swig0.ofdm_serializer_vcc_sptr_set_min_output_buffer(self, *args)

    def pc_noutput_items(self) -> "float":
        r"""pc_noutput_items(ofdm_serializer_vcc_sptr self) -> float"""
        return _digital_swig0.ofdm_serializer_vcc_sptr_pc_noutput_items(self)

    def pc_noutput_items_avg(self) -> "float":
        r"""pc_noutput_items_avg(ofdm_serializer_vcc_sptr self) -> float"""
        return _digital_swig0.ofdm_serializer_vcc_sptr_pc_noutput_items_avg(self)

    def pc_noutput_items_var(self) -> "float":
        r"""pc_noutput_items_var(ofdm_serializer_vcc_sptr self) -> float"""
        return _digital_swig0.ofdm_serializer_vcc_sptr_pc_noutput_items_var(self)

    def pc_nproduced(self) -> "float":
        r"""pc_nproduced(ofdm_serializer_vcc_sptr self) -> float"""
        return _digital_swig0.ofdm_serializer_vcc_sptr_pc_nproduced(self)

    def pc_nproduced_avg(self) -> "float":
        r"""pc_nproduced_avg(ofdm_serializer_vcc_sptr self) -> float"""
        return _digital_swig0.ofdm_serializer_vcc_sptr_pc_nproduced_avg(self)

    def pc_nproduced_var(self) -> "float":
        r"""pc_nproduced_var(ofdm_serializer_vcc_sptr self) -> float"""
        return _digital_swig0.ofdm_serializer_vcc_sptr_pc_nproduced_var(self)

    def pc_input_buffers_full(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full(ofdm_serializer_vcc_sptr self, int which) -> float
        pc_input_buffers_full(ofdm_serializer_vcc_sptr self) -> pmt_vector_float
        """
        return _digital_swig0.ofdm_serializer_vcc_sptr_pc_input_buffers_full(self, *args)

    def pc_input_buffers_full_avg(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full_avg(ofdm_serializer_vcc_sptr self, int which) -> float
        pc_input_buffers_full_avg(ofdm_serializer_vcc_sptr self) -> pmt_vector_float
        """
        return _digital_swig0.ofdm_serializer_vcc_sptr_pc_input_buffers_full_avg(self, *args)

    def pc_input_buffers_full_var(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_input_buffers_full_var(ofdm_serializer_vcc_sptr self, int which) -> float
        pc_input_buffers_full_var(ofdm_serializer_vcc_sptr self) -> pmt_vector_float
        """
        return _digital_swig0.ofdm_serializer_vcc_sptr_pc_input_buffers_full_var(self, *args)

    def pc_output_buffers_full(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full(ofdm_serializer_vcc_sptr self, int which) -> float
        pc_output_buffers_full(ofdm_serializer_vcc_sptr self) -> pmt_vector_float
        """
        return _digital_swig0.ofdm_serializer_vcc_sptr_pc_output_buffers_full(self, *args)

    def pc_output_buffers_full_avg(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full_avg(ofdm_serializer_vcc_sptr self, int which) -> float
        pc_output_buffers_full_avg(ofdm_serializer_vcc_sptr self) -> pmt_vector_float
        """
        return _digital_swig0.ofdm_serializer_vcc_sptr_pc_output_buffers_full_avg(self, *args)

    def pc_output_buffers_full_var(self, *args) -> "std::vector< float,std::allocator< float > >":
        r"""
        pc_output_buffers_full_var(ofdm_serializer_vcc_sptr self, int which) -> float
        pc_output_buffers_full_var(ofdm_serializer_vcc_sptr self) -> pmt_vector_float
        """
        return _digital_swig0.ofdm_serializer_vcc_sptr_pc_output_buffers_full_var(self, *args)

    def pc_work_time(self) -> "float":
        r"""pc_work_time(ofdm_serializer_vcc_sptr self) -> float"""
        return _digital_swig0.ofdm_serializer_vcc_sptr_pc_work_time(self)

    def pc_work_time_avg(self) -> "float":
        r"""pc_work_time_avg(ofdm_serializer_vcc_sptr self) -> float"""
        return _digital_swig0.ofdm_serializer_vcc_sptr_pc_work_time_avg(self)

    def pc_work_time_var(self) -> "float":
        r"""pc_work_time_var(ofdm_serializer_vcc_sptr self) -> float"""
        return _digital_swig0.ofdm_serializer_vcc_sptr_pc_work_time_var(self)

    def pc_work_time_total(self) -> "float":
        r"""pc_work_time_total(ofdm_serializer_vcc_sptr self) -> float"""
        return _digital_swig0.ofdm_serializer_vcc_sptr_pc_work_time_total(self)

    def pc_throughput_avg(self) -> "float":
        r"""pc_throughput_avg(ofdm_serializer_vcc_sptr self) -> float"""
        return _digital_swig0.ofdm_serializer_vcc_sptr_pc_throughput_avg(self)

    def set_processor_affinity(self, mask: "std::vector< int,std::allocator< int > > const &") -> "void":
        r"""set_processor_affinity(ofdm_serializer_vcc_sptr self, std::vector< int,std::allocator< int > > const & mask)"""
        return _digital_swig0.ofdm_serializer_vcc_sptr_set_processor_affinity(self, mask)

    def unset_processor_affinity(self) -> "void":
        r"""unset_processor_affinity(ofdm_serializer_vcc_sptr self)"""
        return _digital_swig0.ofdm_serializer_vcc_sptr_unset_processor_affinity(self)

    def processor_affinity(self) -> "std::vector< int,std::allocator< int > >":
        r"""processor_affinity(ofdm_serializer_vcc_sptr self) -> std::vector< int,std::allocator< int > >"""
        return _digital_swig0.ofdm_serializer_vcc_sptr_processor_affinity(self)

    def active_thread_priority(self) -> "int":
        r"""active_thread_priority(ofdm_serializer_vcc_sptr self) -> int"""
        return _digital_swig0.ofdm_serializer_vcc_sptr_active_thread_priority(self)

    def thread_priority(self) -> "int":
        r"""thread_priority(ofdm_serializer_vcc_sptr self) -> int"""
        return _digital_swig0.ofdm_serializer_vcc_sptr_thread_priority(self)

    def set_thread_priority(self, priority: "int") -> "int":
        r"""set_thread_priority(ofdm_serializer_vcc_sptr self, int priority) -> int"""
        return _digital_swig0.ofdm_serializer_vcc_sptr_set_thread_priority(self, priority)

    def name(self) -> "std::string":
        r"""name(ofdm_serializer_vcc_sptr self) -> std::string"""
        return _digital_swig0.ofdm_serializer_vcc_sptr_name(self)

    def symbol_name(self) -> "std::string":
        r"""symbol_name(ofdm_serializer_vcc_sptr self) -> std::string"""
        return _digital_swig0.ofdm_serializer_vcc_sptr_symbol_name(self)

    def input_signature(self) -> "gr::io_signature::sptr":
        r"""input_signature(ofdm_serializer_vcc_sptr self) -> io_signature_sptr"""
        return _digital_swig0.ofdm_serializer_vcc_sptr_input_signature(self)

    def output_signature(self) -> "gr::io_signature::sptr":
        r"""output_signature(ofdm_serializer_vcc_sptr self) -> io_signature_sptr"""
        return _digital_swig0.ofdm_serializer_vcc_sptr_output_signature(self)

    def unique_id(self) -> "long":
        r"""unique_id(ofdm_serializer_vcc_sptr self) -> long"""
        return _digital_swig0.ofdm_serializer_vcc_sptr_unique_id(self)

    def to_basic_block(self) -> "gr::basic_block_sptr":
        r"""to_basic_block(ofdm_serializer_vcc_sptr self) -> basic_block_sptr"""
        return _digital_swig0.ofdm_serializer_vcc_sptr_to_basic_block(self)

    def check_topology(self, ninputs: "int", noutputs: "int") -> "bool":
        r"""check_topology(ofdm_serializer_vcc_sptr self, int ninputs, int noutputs) -> bool"""
        return _digital_swig0.ofdm_serializer_vcc_sptr_check_topology(self, ninputs, noutputs)

    def alias(self) -> "std::string":
        r"""alias(ofdm_serializer_vcc_sptr self) -> std::string"""
        return _digital_swig0.ofdm_serializer_vcc_sptr_alias(self)

    def set_block_alias(self, name: "std::string") -> "void":
        r"""set_block_alias(ofdm_serializer_vcc_sptr self, std::string name)"""
        return _digital_swig0.ofdm_serializer_vcc_sptr_set_block_alias(self, name)

    def _post(self, which_port: "swig_pmt_ptr", msg: "swig_pmt_ptr") -> "void":
        r"""_post(ofdm_serializer_vcc_sptr self, swig_pmt_ptr which_port, swig_pmt_ptr msg)"""
        return _digital_swig0.ofdm_serializer_vcc_sptr__post(self, which_port, msg)

    def message_ports_in(self) -> "pmt::pmt_t":
        r"""message_ports_in(ofdm_serializer_vcc_sptr self) -> swig_pmt_ptr"""
        return _digital_swig0.ofdm_serializer_vcc_sptr_message_ports_in(self)

    def message_ports_out(self) -> "pmt::pmt_t":
        r"""message_ports_out(ofdm_serializer_vcc_sptr self) -> swig_pmt_ptr"""
        return _digital_swig0.ofdm_serializer_vcc_sptr_message_ports_out(self)

    def message_subscribers(self, which_port: "swig_pmt_ptr") -> "pmt::pmt_t":
        r"""message_subscribers(ofdm_serializer_vcc_sptr self, swig_pmt_ptr which_port) -> swig_pmt_ptr"""
        return _digital_swig0.ofdm_serializer_vcc_sptr_message_subscribers(self, which_port)

# Register ofdm_serializer_vcc_sptr in _digital_swig0:
_digital_swig0.ofdm_serializer_vcc_sptr_swigregister(ofdm_serializer_vcc_sptr)

ofdm_serializer_vcc_sptr.__repr__ = lambda self: "<gr_block %s (%d)>" % (self.name(), self.unique_id())
ofdm_serializer_vcc = ofdm_serializer_vcc.make;

class ofdm_sync_sc_cfb_sptr(object):
    r"""Proxy of C++ boost::shared_ptr< gr::digital::ofdm_sync_sc_cfb > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(ofdm_sync_sc_cfb_sptr self) -> ofdm_sync_sc_cfb_sptr
        __init__(ofdm_sync_sc_cfb_sptr self, ofdm_sync_sc_cfb p) -> ofdm_sync_sc_cfb_sptr
        """
        _digital_swig0.ofdm_sync_sc_cfb_sptr_swiginit(self, _digital_swig0.new_ofdm_sync_sc_cfb_sptr(*args))

    def __deref__(self) -> "gr::digital::ofdm_sync_sc_cfb *":
        r"""__deref__(ofdm_sync_sc_cfb_sptr self) -> ofdm_sync_sc_cfb"""
        return _digital_swig0.ofdm_sync_sc_cfb_sptr___deref__(self)
    __swig_destroy__ = _digital_swig0.delete_ofdm_sync_sc_cfb_sptr

    def make(self, fft_len: "int", cp_len: "int", use_even_carriers: "bool"=False, threshold: "float"=0.9) -> "gr::digital::ofdm_sync_sc_cfb::sptr":
        r"""
        make(ofdm_sync_sc_cfb_sptr self, int fft_len, int cp_len, bool use_even_carriers=False, float threshold=0.9) -> ofdm_sync_sc_cfb_sptr
        Schmidl & Cox synchronisation for OFDM.

        Input: complex samples. Output 0: Fine frequency offset, scaled by the OFDM symbol duration. This is  in [1]. The normalized frequency offset is then 2.0*output0/fft_len. Output 1: Beginning of the first OFDM symbol after the first (doubled) OFDM symbol. The beginning is marked with a 1 (it's 0 everywhere else).


        The evaluation of the coarse frequency offset is  done in this block. Also, the initial equalizer taps are not calculated here.


        Note that we use a different normalization factor in the timing metric than the authors do in their original work[1]. If the timing metric (8) is    we calculate the normalization as    i.e., we estimate the energy from  half-symbols. This avoids spurious detects at the end of a burst, when the energy level suddenly drops.


        [1] Schmidl, T.M. and Cox, D.C., "Robust frequency and timing synchronization for
        OFDM", Communications, IEEE Transactions on, 1997.

        Constructor Specific Documentation:



        Args:
            fft_len : FFT length
            cp_len : Length of the guard interval (cyclic prefix) in samples
            use_even_carriers : If true, the carriers in the sync preamble are occupied such that the even carriers are used (0, 2, 4, ...). If you use all carriers, that would include the DC carrier, so be careful.
            threshold : detection threshold. Default is 0.9.
        """
        return _digital_swig0.ofdm_sync_sc_cfb_sptr_make(self, fft_len, cp_len, use_even_carriers, threshold)

    def set_threshold(self, threshold: "float") -> "void":
        r"""set_threshold(ofdm_sync_sc_cfb_sptr self, float threshold)"""
        return _digital_swig0.ofdm_sync_sc_cfb_sptr_set_threshold(self, threshold)

    def threshold(self) -> "float":
        r"""threshold(ofdm_sync_sc_cfb_sptr self) -> float"""
        return _digital_swig0.ofdm_sync_sc_cfb_sptr_threshold(self)

    def primitive_connect(self, *args) -> "void":
        r"""
        primitive_connect(ofdm_sync_sc_cfb_sptr self, basic_block_sptr block)
        primitive_connect(ofdm_sync_sc_cfb_sptr self, basic_block_sptr src, int src_port, basic_block_sptr dst, int dst_port)
        """
        return _digital_swig0.ofdm_sync_sc_cfb_sptr_primitive_connect(self, *args)

    def primitive_msg_connect(self, *args) -> "void":
        r"""
        primitive_msg_connect(ofdm_sync_sc_cfb_sptr self, basic_block_sptr src, swig_pmt_ptr srcport, basic_block_sptr dst, swig_pmt_ptr dstport)
        primitive_msg_connect(ofdm_sync_sc_cfb_sptr self, basic_block_sptr src, std::string srcport, basic_block_sptr dst, std::string dstport)
        """
        return _digital_swig0.ofdm_sync_sc_cfb_sptr_primitive_msg_connect(self, *args)

    def primitive_msg_disconnect(self, *args) -> "void":
        r"""
        primitive_msg_disconnect(ofdm_sync_sc_cfb_sptr self, basic_block_sptr src, swig_pmt_ptr srcport, basic_block_sptr dst, swig_pmt_ptr dstport)
        primitive_msg_disconnect(ofdm_sync_sc_cfb_sptr self, basic_block_sptr src, std::string srcport, basic_block_sptr dst, std::string dstport)
        """
        return _digital_swig0.ofdm_sync_sc_cfb_sptr_primitive_msg_disconnect(self, *args)

    def primitive_disconnect(self, *args) -> "void":
        r"""
        primitive_disconnect(ofdm_sync_sc_cfb_sptr self, basic_block_sptr block)
        primitive_disconnect(ofdm_sync_sc_cfb_sptr self, basic_block_sptr src, int src_port, basic_block_sptr dst, int dst_port)
        """
        return _digital_swig0.ofdm_sync_sc_cfb_sptr_primitive_disconnect(self, *args)

    def disconnect_all(self) -> "void":
        r"""disconnect_all(ofdm_sync_sc_cfb_sptr self)"""
        return _digital_swig0.ofdm_sync_sc_cfb_sptr_disconnect_all(self)

    def lock(self) -> "void":
        r"""lock(ofdm_sync_sc_cfb_sptr self)"""
        return _digital_swig0.ofdm_sync_sc_cfb_sptr_lock(self)

    def unlock(self) -> "void":
        r"""unlock(ofdm_sync_sc_cfb_sptr self)"""
        return _digital_swig0.ofdm_sync_sc_cfb_sptr_unlock(self)

    def primitive_message_port_register_hier_in(self, port_id: "swig_pmt_ptr") -> "void":
        r"""primitive_message_port_register_hier_in(ofdm_sync_sc_cfb_sptr self, swig_pmt_ptr port_id)"""
        return _digital_swig0.ofdm_sync_sc_cfb_sptr_primitive_message_port_register_hier_in(self, port_id)

    def primitive_message_port_register_hier_out(self, port_id: "swig_pmt_ptr") -> "void":
        r"""primitive_message_port_register_hier_out(ofdm_sync_sc_cfb_sptr self, swig_pmt_ptr port_id)"""
        return _digital_swig0.ofdm_sync_sc_cfb_sptr_primitive_message_port_register_hier_out(self, port_id)

    def set_processor_affinity(self, mask: "std::vector< int,std::allocator< int > > const &") -> "void":
        r"""set_processor_affinity(ofdm_sync_sc_cfb_sptr self, std::vector< int,std::allocator< int > > const & mask)"""
        return _digital_swig0.ofdm_sync_sc_cfb_sptr_set_processor_affinity(self, mask)

    def unset_processor_affinity(self) -> "void":
        r"""unset_processor_affinity(ofdm_sync_sc_cfb_sptr self)"""
        return _digital_swig0.ofdm_sync_sc_cfb_sptr_unset_processor_affinity(self)

    def processor_affinity(self) -> "std::vector< int,std::allocator< int > >":
        r"""processor_affinity(ofdm_sync_sc_cfb_sptr self) -> std::vector< int,std::allocator< int > >"""
        return _digital_swig0.ofdm_sync_sc_cfb_sptr_processor_affinity(self)

    def set_log_level(self, level: "std::string") -> "void":
        r"""set_log_level(ofdm_sync_sc_cfb_sptr self, std::string level)"""
        return _digital_swig0.ofdm_sync_sc_cfb_sptr_set_log_level(self, level)

    def log_level(self) -> "std::string":
        r"""log_level(ofdm_sync_sc_cfb_sptr self) -> std::string"""
        return _digital_swig0.ofdm_sync_sc_cfb_sptr_log_level(self)

    def max_output_buffer(self, i: "int") -> "size_t":
        r"""max_output_buffer(ofdm_sync_sc_cfb_sptr self, int i) -> size_t"""
        return _digital_swig0.ofdm_sync_sc_cfb_sptr_max_output_buffer(self, i)

    def set_max_output_buffer(self, *args) -> "void":
        r"""
        set_max_output_buffer(ofdm_sync_sc_cfb_sptr self, size_t max_output_buffer)
        set_max_output_buffer(ofdm_sync_sc_cfb_sptr self, int port, size_t max_output_buffer)
        """
        return _digital_swig0.ofdm_sync_sc_cfb_sptr_set_max_output_buffer(self, *args)

    def min_output_buffer(self, i: "int") -> "size_t":
        r"""min_output_buffer(ofdm_sync_sc_cfb_sptr self, int i) -> size_t"""
        return _digital_swig0.ofdm_sync_sc_cfb_sptr_min_output_buffer(self, i)

    def set_min_output_buffer(self, *args) -> "void":
        r"""
        set_min_output_buffer(ofdm_sync_sc_cfb_sptr self, size_t min_output_buffer)
        set_min_output_buffer(ofdm_sync_sc_cfb_sptr self, int port, size_t min_output_buffer)
        """
        return _digital_swig0.ofdm_sync_sc_cfb_sptr_set_min_output_buffer(self, *args)

    def to_hier_block2(self) -> "gr::hier_block2_sptr":
        r"""to_hier_block2(ofdm_sync_sc_cfb_sptr self) -> hier_block2_sptr"""
        return _digital_swig0.ofdm_sync_sc_cfb_sptr_to_hier_block2(self)

    def name(self) -> "std::string":
        r"""name(ofdm_sync_sc_cfb_sptr self) -> std::string"""
        return _digital_swig0.ofdm_sync_sc_cfb_sptr_name(self)

    def symbol_name(self) -> "std::string":
        r"""symbol_name(ofdm_sync_sc_cfb_sptr self) -> std::string"""
        return _digital_swig0.ofdm_sync_sc_cfb_sptr_symbol_name(self)

    def input_signature(self) -> "gr::io_signature::sptr":
        r"""input_signature(ofdm_sync_sc_cfb_sptr self) -> io_signature_sptr"""
        return _digital_swig0.ofdm_sync_sc_cfb_sptr_input_signature(self)

    def output_signature(self) -> "gr::io_signature::sptr":
        r"""output_signature(ofdm_sync_sc_cfb_sptr self) -> io_signature_sptr"""
        return _digital_swig0.ofdm_sync_sc_cfb_sptr_output_signature(self)

    def unique_id(self) -> "long":
        r"""unique_id(ofdm_sync_sc_cfb_sptr self) -> long"""
        return _digital_swig0.ofdm_sync_sc_cfb_sptr_unique_id(self)

    def to_basic_block(self) -> "gr::basic_block_sptr":
        r"""to_basic_block(ofdm_sync_sc_cfb_sptr self) -> basic_block_sptr"""
        return _digital_swig0.ofdm_sync_sc_cfb_sptr_to_basic_block(self)

    def check_topology(self, ninputs: "int", noutputs: "int") -> "bool":
        r"""check_topology(ofdm_sync_sc_cfb_sptr self, int ninputs, int noutputs) -> bool"""
        return _digital_swig0.ofdm_sync_sc_cfb_sptr_check_topology(self, ninputs, noutputs)

    def alias(self) -> "std::string":
        r"""alias(ofdm_sync_sc_cfb_sptr self) -> std::string"""
        return _digital_swig0.ofdm_sync_sc_cfb_sptr_alias(self)

    def set_block_alias(self, name: "std::string") -> "void":
        r"""set_block_alias(ofdm_sync_sc_cfb_sptr self, std::string name)"""
        return _digital_swig0.ofdm_sync_sc_cfb_sptr_set_block_alias(self, name)

    def _post(self, which_port: "swig_pmt_ptr", msg: "swig_pmt_ptr") -> "void":
        r"""_post(ofdm_sync_sc_cfb_sptr self, swig_pmt_ptr which_port, swig_pmt_ptr msg)"""
        return _digital_swig0.ofdm_sync_sc_cfb_sptr__post(self, which_port, msg)

    def message_ports_in(self) -> "pmt::pmt_t":
        r"""message_ports_in(ofdm_sync_sc_cfb_sptr self) -> swig_pmt_ptr"""
        return _digital_swig0.ofdm_sync_sc_cfb_sptr_message_ports_in(self)

    def message_ports_out(self) -> "pmt::pmt_t":
        r"""message_ports_out(ofdm_sync_sc_cfb_sptr self) -> swig_pmt_ptr"""
        return _digital_swig0.ofdm_sync_sc_cfb_sptr_message_ports_out(self)

    def message_subscribers(self, which_port: "swig_pmt_ptr") -> "pmt::pmt_t":
        r"""message_subscribers(ofdm_sync_sc_cfb_sptr self, swig_pmt_ptr which_port) -> swig_pmt_ptr"""
        return _digital_swig0.ofdm_sync_sc_cfb_sptr_message_subscribers(self, which_port)

# Register ofdm_sync_sc_cfb_sptr in _digital_swig0:
_digital_swig0.ofdm_sync_sc_cfb_sptr_swigregister(ofdm_sync_sc_cfb_sptr)

ofdm_sync_sc_cfb_sptr.__repr__ = lambda self: "<gr_block %s (%d)>" % (self.name(), self.unique_id())
ofdm_sync_sc_cfb = ofdm_sync_sc_cfb.make;


gmskmod_bc_sptr.__repr__ = lambda self: "<gr_block %s (%d)>" % (self.name(), self.unique_id())
gmskmod_bc = cpmmod_bc_make_gmskmod_bc;

class constellation_sptr(object):
    r"""Proxy of C++ boost::shared_ptr< gr::digital::constellation > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(constellation_sptr self) -> constellation_sptr
        __init__(constellation_sptr self, constellation p) -> constellation_sptr
        """
        _digital_swig0.constellation_sptr_swiginit(self, _digital_swig0.new_constellation_sptr(*args))

    def __deref__(self) -> "gr::digital::constellation *":
        r"""__deref__(constellation_sptr self) -> constellation"""
        return _digital_swig0.constellation_sptr___deref__(self)
    __swig_destroy__ = _digital_swig0.delete_constellation_sptr

    def map_to_points(self, value: "unsigned int", points: "gr_complex *") -> "void":
        r"""
        map_to_points(constellation_sptr self, unsigned int value, gr_complex * points)
        Returns the constellation points for a symbol value.
        """
        return _digital_swig0.constellation_sptr_map_to_points(self, value, points)

    def map_to_points_v(self, value: "unsigned int") -> "std::vector< gr_complex,std::allocator< gr_complex > >":
        r"""map_to_points_v(constellation_sptr self, unsigned int value) -> pmt_vector_cfloat"""
        return _digital_swig0.constellation_sptr_map_to_points_v(self, value)

    def decision_maker(self, sample: "gr_complex const *") -> "unsigned int":
        r"""
        decision_maker(constellation_sptr self, gr_complex const * sample) -> unsigned int
        Returns the constellation point that matches best.
        """
        return _digital_swig0.constellation_sptr_decision_maker(self, sample)

    def decision_maker_v(self, sample: "pmt_vector_cfloat") -> "unsigned int":
        r"""
        decision_maker_v(constellation_sptr self, pmt_vector_cfloat sample) -> unsigned int
        Takes a vector rather than a pointer. Better for SWIG wrapping.
        """
        return _digital_swig0.constellation_sptr_decision_maker_v(self, sample)

    def decision_maker_pe(self, sample: "gr_complex const *", phase_error: "float *") -> "unsigned int":
        r"""
        decision_maker_pe(constellation_sptr self, gr_complex const * sample, float * phase_error) -> unsigned int
        Also calculates the phase error.
        """
        return _digital_swig0.constellation_sptr_decision_maker_pe(self, sample, phase_error)

    def calc_metric(self, sample: "gr_complex const *", metric: "float *", type: "gr::digital::trellis_metric_type_t") -> "void":
        r"""
        calc_metric(constellation_sptr self, gr_complex const * sample, float * metric, gr::digital::trellis_metric_type_t type)
        Calculates distance.

        Calculates metrics for all points in the constellation. For use with the viterbi algorithm.
        """
        return _digital_swig0.constellation_sptr_calc_metric(self, sample, metric, type)

    def calc_euclidean_metric(self, sample: "gr_complex const *", metric: "float *") -> "void":
        r"""calc_euclidean_metric(constellation_sptr self, gr_complex const * sample, float * metric)"""
        return _digital_swig0.constellation_sptr_calc_euclidean_metric(self, sample, metric)

    def calc_hard_symbol_metric(self, sample: "gr_complex const *", metric: "float *") -> "void":
        r"""calc_hard_symbol_metric(constellation_sptr self, gr_complex const * sample, float * metric)"""
        return _digital_swig0.constellation_sptr_calc_hard_symbol_metric(self, sample, metric)

    def points(self) -> "std::vector< gr_complex,std::allocator< gr_complex > >":
        r"""
        points(constellation_sptr self) -> pmt_vector_cfloat
        Returns the set of points in this constellation.
        """
        return _digital_swig0.constellation_sptr_points(self)

    def s_points(self) -> "std::vector< gr_complex,std::allocator< gr_complex > >":
        r"""
        s_points(constellation_sptr self) -> pmt_vector_cfloat
        Returns the vector of points in this constellation. Raise error if dimensionality is not one.
        """
        return _digital_swig0.constellation_sptr_s_points(self)

    def v_points(self) -> "std::vector< std::vector< gr_complex,std::allocator< gr_complex > >,std::allocator< std::vector< gr_complex,std::allocator< gr_complex > > > >":
        r"""
        v_points(constellation_sptr self) -> gr_vector_vector_complexf
        Returns a vector of vectors of points.
        """
        return _digital_swig0.constellation_sptr_v_points(self)

    def apply_pre_diff_code(self) -> "bool":
        r"""
        apply_pre_diff_code(constellation_sptr self) -> bool
        Whether to apply an encoding before doing differential encoding. (e.g. gray coding)
        """
        return _digital_swig0.constellation_sptr_apply_pre_diff_code(self)

    def set_pre_diff_code(self, a: "bool") -> "void":
        r"""
        set_pre_diff_code(constellation_sptr self, bool a)
        Whether to apply an encoding before doing differential encoding. (e.g. gray coding)
        """
        return _digital_swig0.constellation_sptr_set_pre_diff_code(self, a)

    def pre_diff_code(self) -> "std::vector< int,std::allocator< int > >":
        r"""
        pre_diff_code(constellation_sptr self) -> std::vector< int,std::allocator< int > >
        Returns the encoding to apply before differential encoding.
        """
        return _digital_swig0.constellation_sptr_pre_diff_code(self)

    def rotational_symmetry(self) -> "unsigned int":
        r"""
        rotational_symmetry(constellation_sptr self) -> unsigned int
        Returns the order of rotational symmetry.
        """
        return _digital_swig0.constellation_sptr_rotational_symmetry(self)

    def dimensionality(self) -> "unsigned int":
        r"""
        dimensionality(constellation_sptr self) -> unsigned int
        Returns the number of complex numbers in a single symbol.
        """
        return _digital_swig0.constellation_sptr_dimensionality(self)

    def bits_per_symbol(self) -> "unsigned int":
        r"""bits_per_symbol(constellation_sptr self) -> unsigned int"""
        return _digital_swig0.constellation_sptr_bits_per_symbol(self)

    def arity(self) -> "unsigned int":
        r"""arity(constellation_sptr self) -> unsigned int"""
        return _digital_swig0.constellation_sptr_arity(self)

    def base(self) -> "gr::digital::constellation_sptr":
        r"""base(constellation_sptr self) -> constellation_sptr"""
        return _digital_swig0.constellation_sptr_base(self)

    def as_pmt(self) -> "pmt::pmt_t":
        r"""as_pmt(constellation_sptr self) -> swig_pmt_ptr"""
        return _digital_swig0.constellation_sptr_as_pmt(self)

    def gen_soft_dec_lut(self, precision: "int", npwr: "float"=1.0) -> "void":
        r"""
        gen_soft_dec_lut(constellation_sptr self, int precision, float npwr=1.0)
        Generates the soft decision LUT based on constellation and symbol map.

        Generates the soft decision LUT based on constellation and symbol map. It can be given a estimate of the noise power in the channel as .



        This is expensive to compute.
        """
        return _digital_swig0.constellation_sptr_gen_soft_dec_lut(self, precision, npwr)

    def calc_soft_dec(self, sample: "gr_complex", npwr: "float"=1.0) -> "std::vector< float,std::allocator< float > >":
        r"""
        calc_soft_dec(constellation_sptr self, gr_complex sample, float npwr=1.0) -> pmt_vector_float
        Calculate soft decisions for the given .

        Calculate the soft decisions from the given  at the given noise power .


        This is a very costly algorithm (especially for higher order modulations) and should be used sparingly. It uses the gen_soft_dec_lut function to generate the LUT, which should be done once or if a large change in the noise floor is detected.


        Instead of using this function, generate the LUT using the gen_soft_dec_lut after creating the constellation object and then use the soft_decision_maker function to return the answer from the LUT.
        """
        return _digital_swig0.constellation_sptr_calc_soft_dec(self, sample, npwr)

    def set_soft_dec_lut(self, soft_dec_lut: "std::vector< std::vector< float,std::allocator< float > >,std::allocator< std::vector< float,std::allocator< float > > > > const &", precision: "int") -> "void":
        r"""
        set_soft_dec_lut(constellation_sptr self, std::vector< std::vector< float,std::allocator< float > >,std::allocator< std::vector< float,std::allocator< float > > > > const & soft_dec_lut, int precision)
        Define a soft decision look-up table.

        Define a soft decision look-up table (LUT). Because soft decisions can be calculated in various ways with various levels of accuracy and complexity, this function allows users to create a LUT in their own way.


        Setting the LUT here means that has_soft_dec_lut will return true. Decision vectors returned by soft_decision_maker will be calculated using this LUT.
        """
        return _digital_swig0.constellation_sptr_set_soft_dec_lut(self, soft_dec_lut, precision)

    def has_soft_dec_lut(self) -> "bool":
        r"""
        has_soft_dec_lut(constellation_sptr self) -> bool
        Returns True if the soft decision LUT has been defined, False otherwise.
        """
        return _digital_swig0.constellation_sptr_has_soft_dec_lut(self)

    def soft_dec_lut(self) -> "std::vector< std::vector< float,std::allocator< float > >,std::allocator< std::vector< float,std::allocator< float > > > >":
        r"""soft_dec_lut(constellation_sptr self) -> std::vector< std::vector< float,std::allocator< float > >,std::allocator< std::vector< float,std::allocator< float > > > >"""
        return _digital_swig0.constellation_sptr_soft_dec_lut(self)

    def soft_decision_maker(self, sample: "gr_complex") -> "std::vector< float,std::allocator< float > >":
        r"""
        soft_decision_maker(constellation_sptr self, gr_complex sample) -> pmt_vector_float
        Returns the soft decisions for the given .

        Returns the soft decisions for the given . If a LUT is defined for the object, the decisions will be calculated from there. Otherwise, this function will call calc_soft_dec directly to calculate the soft decisions.
        """
        return _digital_swig0.constellation_sptr_soft_decision_maker(self, sample)

# Register constellation_sptr in _digital_swig0:
_digital_swig0.constellation_sptr_swigregister(constellation_sptr)
class constellation_calcdist_sptr(object):
    r"""Proxy of C++ boost::shared_ptr< gr::digital::constellation_calcdist > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(constellation_calcdist_sptr self) -> constellation_calcdist_sptr
        __init__(constellation_calcdist_sptr self, constellation_calcdist p) -> constellation_calcdist_sptr
        """
        _digital_swig0.constellation_calcdist_sptr_swiginit(self, _digital_swig0.new_constellation_calcdist_sptr(*args))

    def __deref__(self) -> "gr::digital::constellation_calcdist *":
        r"""__deref__(constellation_calcdist_sptr self) -> constellation_calcdist"""
        return _digital_swig0.constellation_calcdist_sptr___deref__(self)
    __swig_destroy__ = _digital_swig0.delete_constellation_calcdist_sptr

    def make(self, constell: "pmt_vector_cfloat", pre_diff_code: "std::vector< int,std::allocator< int > >", rotational_symmetry: "unsigned int", dimensionality: "unsigned int", normalize_points: "bool"=True) -> "gr::digital::constellation_calcdist::sptr":
        r"""
        make(constellation_calcdist_sptr self, pmt_vector_cfloat constell, std::vector< int,std::allocator< int > > pre_diff_code, unsigned int rotational_symmetry, unsigned int dimensionality, bool normalize_points=True) -> constellation_calcdist_sptr
        Calculate Euclidean distance for any constellation.

        Constellation which calculates the distance to each point in the constellation for decision making. Inefficient for large constellations.

        Constructor Specific Documentation:

        Make a general constellation object that calculates the Euclidean distance for hard decisions.

        Args:
            constell : List of constellation points (order of list matches pre_diff_code)
            pre_diff_code : List of alphabet symbols (before applying any differential coding) (order of list matches constell)
            rotational_symmetry : Number of rotations around unit circle that have the same representation.
            dimensionality : Number of dimensions to the constellation.
            normalize_points : Normalize constellation points to mean(abs(points))=1 (default is true)
        """
        return _digital_swig0.constellation_calcdist_sptr_make(self, constell, pre_diff_code, rotational_symmetry, dimensionality, normalize_points)

    def map_to_points(self, value: "unsigned int", points: "gr_complex *") -> "void":
        r"""
        map_to_points(constellation_calcdist_sptr self, unsigned int value, gr_complex * points)
        Returns the constellation points for a symbol value.
        """
        return _digital_swig0.constellation_calcdist_sptr_map_to_points(self, value, points)

    def map_to_points_v(self, value: "unsigned int") -> "std::vector< gr_complex,std::allocator< gr_complex > >":
        r"""map_to_points_v(constellation_calcdist_sptr self, unsigned int value) -> pmt_vector_cfloat"""
        return _digital_swig0.constellation_calcdist_sptr_map_to_points_v(self, value)

    def decision_maker(self, sample: "gr_complex const *") -> "unsigned int":
        r"""
        decision_maker(constellation_calcdist_sptr self, gr_complex const * sample) -> unsigned int
        Returns the constellation point that matches best.
        """
        return _digital_swig0.constellation_calcdist_sptr_decision_maker(self, sample)

    def decision_maker_v(self, sample: "pmt_vector_cfloat") -> "unsigned int":
        r"""
        decision_maker_v(constellation_calcdist_sptr self, pmt_vector_cfloat sample) -> unsigned int
        Takes a vector rather than a pointer. Better for SWIG wrapping.
        """
        return _digital_swig0.constellation_calcdist_sptr_decision_maker_v(self, sample)

    def decision_maker_pe(self, sample: "gr_complex const *", phase_error: "float *") -> "unsigned int":
        r"""
        decision_maker_pe(constellation_calcdist_sptr self, gr_complex const * sample, float * phase_error) -> unsigned int
        Also calculates the phase error.
        """
        return _digital_swig0.constellation_calcdist_sptr_decision_maker_pe(self, sample, phase_error)

    def calc_metric(self, sample: "gr_complex const *", metric: "float *", type: "gr::digital::trellis_metric_type_t") -> "void":
        r"""
        calc_metric(constellation_calcdist_sptr self, gr_complex const * sample, float * metric, gr::digital::trellis_metric_type_t type)
        Calculates distance.

        Calculates metrics for all points in the constellation. For use with the viterbi algorithm.
        """
        return _digital_swig0.constellation_calcdist_sptr_calc_metric(self, sample, metric, type)

    def calc_euclidean_metric(self, sample: "gr_complex const *", metric: "float *") -> "void":
        r"""calc_euclidean_metric(constellation_calcdist_sptr self, gr_complex const * sample, float * metric)"""
        return _digital_swig0.constellation_calcdist_sptr_calc_euclidean_metric(self, sample, metric)

    def calc_hard_symbol_metric(self, sample: "gr_complex const *", metric: "float *") -> "void":
        r"""calc_hard_symbol_metric(constellation_calcdist_sptr self, gr_complex const * sample, float * metric)"""
        return _digital_swig0.constellation_calcdist_sptr_calc_hard_symbol_metric(self, sample, metric)

    def points(self) -> "std::vector< gr_complex,std::allocator< gr_complex > >":
        r"""
        points(constellation_calcdist_sptr self) -> pmt_vector_cfloat
        Returns the set of points in this constellation.
        """
        return _digital_swig0.constellation_calcdist_sptr_points(self)

    def s_points(self) -> "std::vector< gr_complex,std::allocator< gr_complex > >":
        r"""
        s_points(constellation_calcdist_sptr self) -> pmt_vector_cfloat
        Returns the vector of points in this constellation. Raise error if dimensionality is not one.
        """
        return _digital_swig0.constellation_calcdist_sptr_s_points(self)

    def v_points(self) -> "std::vector< std::vector< gr_complex,std::allocator< gr_complex > >,std::allocator< std::vector< gr_complex,std::allocator< gr_complex > > > >":
        r"""
        v_points(constellation_calcdist_sptr self) -> gr_vector_vector_complexf
        Returns a vector of vectors of points.
        """
        return _digital_swig0.constellation_calcdist_sptr_v_points(self)

    def apply_pre_diff_code(self) -> "bool":
        r"""
        apply_pre_diff_code(constellation_calcdist_sptr self) -> bool
        Whether to apply an encoding before doing differential encoding. (e.g. gray coding)
        """
        return _digital_swig0.constellation_calcdist_sptr_apply_pre_diff_code(self)

    def set_pre_diff_code(self, a: "bool") -> "void":
        r"""
        set_pre_diff_code(constellation_calcdist_sptr self, bool a)
        Whether to apply an encoding before doing differential encoding. (e.g. gray coding)
        """
        return _digital_swig0.constellation_calcdist_sptr_set_pre_diff_code(self, a)

    def pre_diff_code(self) -> "std::vector< int,std::allocator< int > >":
        r"""
        pre_diff_code(constellation_calcdist_sptr self) -> std::vector< int,std::allocator< int > >
        Returns the encoding to apply before differential encoding.
        """
        return _digital_swig0.constellation_calcdist_sptr_pre_diff_code(self)

    def rotational_symmetry(self) -> "unsigned int":
        r"""
        rotational_symmetry(constellation_calcdist_sptr self) -> unsigned int
        Returns the order of rotational symmetry.
        """
        return _digital_swig0.constellation_calcdist_sptr_rotational_symmetry(self)

    def dimensionality(self) -> "unsigned int":
        r"""
        dimensionality(constellation_calcdist_sptr self) -> unsigned int
        Returns the number of complex numbers in a single symbol.
        """
        return _digital_swig0.constellation_calcdist_sptr_dimensionality(self)

    def bits_per_symbol(self) -> "unsigned int":
        r"""bits_per_symbol(constellation_calcdist_sptr self) -> unsigned int"""
        return _digital_swig0.constellation_calcdist_sptr_bits_per_symbol(self)

    def arity(self) -> "unsigned int":
        r"""arity(constellation_calcdist_sptr self) -> unsigned int"""
        return _digital_swig0.constellation_calcdist_sptr_arity(self)

    def base(self) -> "gr::digital::constellation_sptr":
        r"""base(constellation_calcdist_sptr self) -> constellation_sptr"""
        return _digital_swig0.constellation_calcdist_sptr_base(self)

    def as_pmt(self) -> "pmt::pmt_t":
        r"""as_pmt(constellation_calcdist_sptr self) -> swig_pmt_ptr"""
        return _digital_swig0.constellation_calcdist_sptr_as_pmt(self)

    def gen_soft_dec_lut(self, precision: "int", npwr: "float"=1.0) -> "void":
        r"""
        gen_soft_dec_lut(constellation_calcdist_sptr self, int precision, float npwr=1.0)
        Generates the soft decision LUT based on constellation and symbol map.

        Generates the soft decision LUT based on constellation and symbol map. It can be given a estimate of the noise power in the channel as .



        This is expensive to compute.
        """
        return _digital_swig0.constellation_calcdist_sptr_gen_soft_dec_lut(self, precision, npwr)

    def calc_soft_dec(self, sample: "gr_complex", npwr: "float"=1.0) -> "std::vector< float,std::allocator< float > >":
        r"""
        calc_soft_dec(constellation_calcdist_sptr self, gr_complex sample, float npwr=1.0) -> pmt_vector_float
        Calculate soft decisions for the given .

        Calculate the soft decisions from the given  at the given noise power .


        This is a very costly algorithm (especially for higher order modulations) and should be used sparingly. It uses the gen_soft_dec_lut function to generate the LUT, which should be done once or if a large change in the noise floor is detected.


        Instead of using this function, generate the LUT using the gen_soft_dec_lut after creating the constellation object and then use the soft_decision_maker function to return the answer from the LUT.
        """
        return _digital_swig0.constellation_calcdist_sptr_calc_soft_dec(self, sample, npwr)

    def set_soft_dec_lut(self, soft_dec_lut: "std::vector< std::vector< float,std::allocator< float > >,std::allocator< std::vector< float,std::allocator< float > > > > const &", precision: "int") -> "void":
        r"""
        set_soft_dec_lut(constellation_calcdist_sptr self, std::vector< std::vector< float,std::allocator< float > >,std::allocator< std::vector< float,std::allocator< float > > > > const & soft_dec_lut, int precision)
        Define a soft decision look-up table.

        Define a soft decision look-up table (LUT). Because soft decisions can be calculated in various ways with various levels of accuracy and complexity, this function allows users to create a LUT in their own way.


        Setting the LUT here means that has_soft_dec_lut will return true. Decision vectors returned by soft_decision_maker will be calculated using this LUT.
        """
        return _digital_swig0.constellation_calcdist_sptr_set_soft_dec_lut(self, soft_dec_lut, precision)

    def has_soft_dec_lut(self) -> "bool":
        r"""
        has_soft_dec_lut(constellation_calcdist_sptr self) -> bool
        Returns True if the soft decision LUT has been defined, False otherwise.
        """
        return _digital_swig0.constellation_calcdist_sptr_has_soft_dec_lut(self)

    def soft_dec_lut(self) -> "std::vector< std::vector< float,std::allocator< float > >,std::allocator< std::vector< float,std::allocator< float > > > >":
        r"""soft_dec_lut(constellation_calcdist_sptr self) -> std::vector< std::vector< float,std::allocator< float > >,std::allocator< std::vector< float,std::allocator< float > > > >"""
        return _digital_swig0.constellation_calcdist_sptr_soft_dec_lut(self)

    def soft_decision_maker(self, sample: "gr_complex") -> "std::vector< float,std::allocator< float > >":
        r"""
        soft_decision_maker(constellation_calcdist_sptr self, gr_complex sample) -> pmt_vector_float
        Returns the soft decisions for the given .

        Returns the soft decisions for the given . If a LUT is defined for the object, the decisions will be calculated from there. Otherwise, this function will call calc_soft_dec directly to calculate the soft decisions.
        """
        return _digital_swig0.constellation_calcdist_sptr_soft_decision_maker(self, sample)

# Register constellation_calcdist_sptr in _digital_swig0:
_digital_swig0.constellation_calcdist_sptr_swigregister(constellation_calcdist_sptr)

constellation_calcdist_sptr.__repr__ = lambda self: "<constellation calcdist (m=%d)>" % (len(self.points()))
constellation_calcdist = constellation_calcdist.make;

class constellation_rect_sptr(object):
    r"""Proxy of C++ boost::shared_ptr< gr::digital::constellation_rect > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(constellation_rect_sptr self) -> constellation_rect_sptr
        __init__(constellation_rect_sptr self, constellation_rect p) -> constellation_rect_sptr
        """
        _digital_swig0.constellation_rect_sptr_swiginit(self, _digital_swig0.new_constellation_rect_sptr(*args))

    def __deref__(self) -> "gr::digital::constellation_rect *":
        r"""__deref__(constellation_rect_sptr self) -> constellation_rect"""
        return _digital_swig0.constellation_rect_sptr___deref__(self)
    __swig_destroy__ = _digital_swig0.delete_constellation_rect_sptr

    def make(self, constell: "pmt_vector_cfloat", pre_diff_code: "std::vector< int,std::allocator< int > >", rotational_symmetry: "unsigned int", real_sectors: "unsigned int", imag_sectors: "unsigned int", width_real_sectors: "float", width_imag_sectors: "float") -> "gr::digital::constellation_rect::sptr":
        r"""
        make(constellation_rect_sptr self, pmt_vector_cfloat constell, std::vector< int,std::allocator< int > > pre_diff_code, unsigned int rotational_symmetry, unsigned int real_sectors, unsigned int imag_sectors, float width_real_sectors, float width_imag_sectors) -> constellation_rect_sptr
        Rectangular digital constellation.

        Only implemented for 1-(complex)dimensional constellation.


        Constellation space is divided into rectangular sectors. Each sector is associated with the nearest constellation point.


        Works well for square QAM.


        Works for any generic constellation provided sectors are not too large.

        Constructor Specific Documentation:

        Make a rectangular constellation object.

        Args:
            constell : List of constellation points (order of list matches pre_diff_code)
            pre_diff_code : List of alphabet symbols (before applying any differential coding) (order of list matches constell)
            rotational_symmetry : Number of rotations around unit circle that have the same representation.
            real_sectors : Number of sectors the real axis is split in to.
            imag_sectors : Number of sectors the imag axis is split in to.
            width_real_sectors : width of each real sector to calculate decision boundaries.
            width_imag_sectors : width of each imag sector to calculate decision boundaries.
        """
        return _digital_swig0.constellation_rect_sptr_make(self, constell, pre_diff_code, rotational_symmetry, real_sectors, imag_sectors, width_real_sectors, width_imag_sectors)

    def map_to_points(self, value: "unsigned int", points: "gr_complex *") -> "void":
        r"""
        map_to_points(constellation_rect_sptr self, unsigned int value, gr_complex * points)
        Returns the constellation points for a symbol value.
        """
        return _digital_swig0.constellation_rect_sptr_map_to_points(self, value, points)

    def map_to_points_v(self, value: "unsigned int") -> "std::vector< gr_complex,std::allocator< gr_complex > >":
        r"""map_to_points_v(constellation_rect_sptr self, unsigned int value) -> pmt_vector_cfloat"""
        return _digital_swig0.constellation_rect_sptr_map_to_points_v(self, value)

    def decision_maker(self, sample: "gr_complex const *") -> "unsigned int":
        r"""
        decision_maker(constellation_rect_sptr self, gr_complex const * sample) -> unsigned int
        Returns the constellation point that matches best.
        """
        return _digital_swig0.constellation_rect_sptr_decision_maker(self, sample)

    def decision_maker_v(self, sample: "pmt_vector_cfloat") -> "unsigned int":
        r"""
        decision_maker_v(constellation_rect_sptr self, pmt_vector_cfloat sample) -> unsigned int
        Takes a vector rather than a pointer. Better for SWIG wrapping.
        """
        return _digital_swig0.constellation_rect_sptr_decision_maker_v(self, sample)

    def decision_maker_pe(self, sample: "gr_complex const *", phase_error: "float *") -> "unsigned int":
        r"""
        decision_maker_pe(constellation_rect_sptr self, gr_complex const * sample, float * phase_error) -> unsigned int
        Also calculates the phase error.
        """
        return _digital_swig0.constellation_rect_sptr_decision_maker_pe(self, sample, phase_error)

    def calc_metric(self, sample: "gr_complex const *", metric: "float *", type: "gr::digital::trellis_metric_type_t") -> "void":
        r"""
        calc_metric(constellation_rect_sptr self, gr_complex const * sample, float * metric, gr::digital::trellis_metric_type_t type)
        Calculates distance.

        Calculates metrics for all points in the constellation. For use with the viterbi algorithm.
        """
        return _digital_swig0.constellation_rect_sptr_calc_metric(self, sample, metric, type)

    def calc_euclidean_metric(self, sample: "gr_complex const *", metric: "float *") -> "void":
        r"""calc_euclidean_metric(constellation_rect_sptr self, gr_complex const * sample, float * metric)"""
        return _digital_swig0.constellation_rect_sptr_calc_euclidean_metric(self, sample, metric)

    def calc_hard_symbol_metric(self, sample: "gr_complex const *", metric: "float *") -> "void":
        r"""calc_hard_symbol_metric(constellation_rect_sptr self, gr_complex const * sample, float * metric)"""
        return _digital_swig0.constellation_rect_sptr_calc_hard_symbol_metric(self, sample, metric)

    def points(self) -> "std::vector< gr_complex,std::allocator< gr_complex > >":
        r"""
        points(constellation_rect_sptr self) -> pmt_vector_cfloat
        Returns the set of points in this constellation.
        """
        return _digital_swig0.constellation_rect_sptr_points(self)

    def s_points(self) -> "std::vector< gr_complex,std::allocator< gr_complex > >":
        r"""
        s_points(constellation_rect_sptr self) -> pmt_vector_cfloat
        Returns the vector of points in this constellation. Raise error if dimensionality is not one.
        """
        return _digital_swig0.constellation_rect_sptr_s_points(self)

    def v_points(self) -> "std::vector< std::vector< gr_complex,std::allocator< gr_complex > >,std::allocator< std::vector< gr_complex,std::allocator< gr_complex > > > >":
        r"""
        v_points(constellation_rect_sptr self) -> gr_vector_vector_complexf
        Returns a vector of vectors of points.
        """
        return _digital_swig0.constellation_rect_sptr_v_points(self)

    def apply_pre_diff_code(self) -> "bool":
        r"""
        apply_pre_diff_code(constellation_rect_sptr self) -> bool
        Whether to apply an encoding before doing differential encoding. (e.g. gray coding)
        """
        return _digital_swig0.constellation_rect_sptr_apply_pre_diff_code(self)

    def set_pre_diff_code(self, a: "bool") -> "void":
        r"""
        set_pre_diff_code(constellation_rect_sptr self, bool a)
        Whether to apply an encoding before doing differential encoding. (e.g. gray coding)
        """
        return _digital_swig0.constellation_rect_sptr_set_pre_diff_code(self, a)

    def pre_diff_code(self) -> "std::vector< int,std::allocator< int > >":
        r"""
        pre_diff_code(constellation_rect_sptr self) -> std::vector< int,std::allocator< int > >
        Returns the encoding to apply before differential encoding.
        """
        return _digital_swig0.constellation_rect_sptr_pre_diff_code(self)

    def rotational_symmetry(self) -> "unsigned int":
        r"""
        rotational_symmetry(constellation_rect_sptr self) -> unsigned int
        Returns the order of rotational symmetry.
        """
        return _digital_swig0.constellation_rect_sptr_rotational_symmetry(self)

    def dimensionality(self) -> "unsigned int":
        r"""
        dimensionality(constellation_rect_sptr self) -> unsigned int
        Returns the number of complex numbers in a single symbol.
        """
        return _digital_swig0.constellation_rect_sptr_dimensionality(self)

    def bits_per_symbol(self) -> "unsigned int":
        r"""bits_per_symbol(constellation_rect_sptr self) -> unsigned int"""
        return _digital_swig0.constellation_rect_sptr_bits_per_symbol(self)

    def arity(self) -> "unsigned int":
        r"""arity(constellation_rect_sptr self) -> unsigned int"""
        return _digital_swig0.constellation_rect_sptr_arity(self)

    def base(self) -> "gr::digital::constellation_sptr":
        r"""base(constellation_rect_sptr self) -> constellation_sptr"""
        return _digital_swig0.constellation_rect_sptr_base(self)

    def as_pmt(self) -> "pmt::pmt_t":
        r"""as_pmt(constellation_rect_sptr self) -> swig_pmt_ptr"""
        return _digital_swig0.constellation_rect_sptr_as_pmt(self)

    def gen_soft_dec_lut(self, precision: "int", npwr: "float"=1.0) -> "void":
        r"""
        gen_soft_dec_lut(constellation_rect_sptr self, int precision, float npwr=1.0)
        Generates the soft decision LUT based on constellation and symbol map.

        Generates the soft decision LUT based on constellation and symbol map. It can be given a estimate of the noise power in the channel as .



        This is expensive to compute.
        """
        return _digital_swig0.constellation_rect_sptr_gen_soft_dec_lut(self, precision, npwr)

    def calc_soft_dec(self, sample: "gr_complex", npwr: "float"=1.0) -> "std::vector< float,std::allocator< float > >":
        r"""
        calc_soft_dec(constellation_rect_sptr self, gr_complex sample, float npwr=1.0) -> pmt_vector_float
        Calculate soft decisions for the given .

        Calculate the soft decisions from the given  at the given noise power .


        This is a very costly algorithm (especially for higher order modulations) and should be used sparingly. It uses the gen_soft_dec_lut function to generate the LUT, which should be done once or if a large change in the noise floor is detected.


        Instead of using this function, generate the LUT using the gen_soft_dec_lut after creating the constellation object and then use the soft_decision_maker function to return the answer from the LUT.
        """
        return _digital_swig0.constellation_rect_sptr_calc_soft_dec(self, sample, npwr)

    def set_soft_dec_lut(self, soft_dec_lut: "std::vector< std::vector< float,std::allocator< float > >,std::allocator< std::vector< float,std::allocator< float > > > > const &", precision: "int") -> "void":
        r"""
        set_soft_dec_lut(constellation_rect_sptr self, std::vector< std::vector< float,std::allocator< float > >,std::allocator< std::vector< float,std::allocator< float > > > > const & soft_dec_lut, int precision)
        Define a soft decision look-up table.

        Define a soft decision look-up table (LUT). Because soft decisions can be calculated in various ways with various levels of accuracy and complexity, this function allows users to create a LUT in their own way.


        Setting the LUT here means that has_soft_dec_lut will return true. Decision vectors returned by soft_decision_maker will be calculated using this LUT.
        """
        return _digital_swig0.constellation_rect_sptr_set_soft_dec_lut(self, soft_dec_lut, precision)

    def has_soft_dec_lut(self) -> "bool":
        r"""
        has_soft_dec_lut(constellation_rect_sptr self) -> bool
        Returns True if the soft decision LUT has been defined, False otherwise.
        """
        return _digital_swig0.constellation_rect_sptr_has_soft_dec_lut(self)

    def soft_dec_lut(self) -> "std::vector< std::vector< float,std::allocator< float > >,std::allocator< std::vector< float,std::allocator< float > > > >":
        r"""soft_dec_lut(constellation_rect_sptr self) -> std::vector< std::vector< float,std::allocator< float > >,std::allocator< std::vector< float,std::allocator< float > > > >"""
        return _digital_swig0.constellation_rect_sptr_soft_dec_lut(self)

    def soft_decision_maker(self, sample: "gr_complex") -> "std::vector< float,std::allocator< float > >":
        r"""
        soft_decision_maker(constellation_rect_sptr self, gr_complex sample) -> pmt_vector_float
        Returns the soft decisions for the given .

        Returns the soft decisions for the given . If a LUT is defined for the object, the decisions will be calculated from there. Otherwise, this function will call calc_soft_dec directly to calculate the soft decisions.
        """
        return _digital_swig0.constellation_rect_sptr_soft_decision_maker(self, sample)

# Register constellation_rect_sptr in _digital_swig0:
_digital_swig0.constellation_rect_sptr_swigregister(constellation_rect_sptr)

constellation_rect_sptr.__repr__ = lambda self: "<constellation rect (m=%d)>" % (len(self.points()))
constellation_rect = constellation_rect.make;

class constellation_expl_rect_sptr(object):
    r"""Proxy of C++ boost::shared_ptr< gr::digital::constellation_expl_rect > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(constellation_expl_rect_sptr self) -> constellation_expl_rect_sptr
        __init__(constellation_expl_rect_sptr self, constellation_expl_rect p) -> constellation_expl_rect_sptr
        """
        _digital_swig0.constellation_expl_rect_sptr_swiginit(self, _digital_swig0.new_constellation_expl_rect_sptr(*args))

    def __deref__(self) -> "gr::digital::constellation_expl_rect *":
        r"""__deref__(constellation_expl_rect_sptr self) -> constellation_expl_rect"""
        return _digital_swig0.constellation_expl_rect_sptr___deref__(self)
    __swig_destroy__ = _digital_swig0.delete_constellation_expl_rect_sptr

    def make(self, constellation: "pmt_vector_cfloat", pre_diff_code: "std::vector< int,std::allocator< int > >", rotational_symmetry: "unsigned int", real_sectors: "unsigned int", imag_sectors: "unsigned int", width_real_sectors: "float", width_imag_sectors: "float", sector_values: "std::vector< unsigned int,std::allocator< unsigned int > >") -> "gr::digital::constellation_expl_rect::sptr":
        r"""
        make(constellation_expl_rect_sptr self, pmt_vector_cfloat constellation, std::vector< int,std::allocator< int > > pre_diff_code, unsigned int rotational_symmetry, unsigned int real_sectors, unsigned int imag_sectors, float width_real_sectors, float width_imag_sectors, std::vector< unsigned int,std::allocator< unsigned int > > sector_values) -> constellation_expl_rect_sptr
        Rectangular digital constellation.

        Only implemented for 1-(complex)dimensional constellation.


        Constellation space is divided into rectangular sectors. Each sector is associated with the nearest constellation point.


        This class is different from constellation_rect in that the mapping from sector to constellation point is explicitly passed into the constructor as sector_values. Usually we do not need this, since we want each sector to be automatically mapped to the closest constellation point, however sometimes it's nice to have the flexibility.

        Constructor Specific Documentation:



        Args:
            constellation : 
            pre_diff_code : 
            rotational_symmetry : 
            real_sectors : 
            imag_sectors : 
            width_real_sectors : 
            width_imag_sectors : 
            sector_values : 
        """
        return _digital_swig0.constellation_expl_rect_sptr_make(self, constellation, pre_diff_code, rotational_symmetry, real_sectors, imag_sectors, width_real_sectors, width_imag_sectors, sector_values)

    def map_to_points(self, value: "unsigned int", points: "gr_complex *") -> "void":
        r"""
        map_to_points(constellation_expl_rect_sptr self, unsigned int value, gr_complex * points)
        Returns the constellation points for a symbol value.
        """
        return _digital_swig0.constellation_expl_rect_sptr_map_to_points(self, value, points)

    def map_to_points_v(self, value: "unsigned int") -> "std::vector< gr_complex,std::allocator< gr_complex > >":
        r"""map_to_points_v(constellation_expl_rect_sptr self, unsigned int value) -> pmt_vector_cfloat"""
        return _digital_swig0.constellation_expl_rect_sptr_map_to_points_v(self, value)

    def decision_maker(self, sample: "gr_complex const *") -> "unsigned int":
        r"""
        decision_maker(constellation_expl_rect_sptr self, gr_complex const * sample) -> unsigned int
        Returns the constellation point that matches best.
        """
        return _digital_swig0.constellation_expl_rect_sptr_decision_maker(self, sample)

    def decision_maker_v(self, sample: "pmt_vector_cfloat") -> "unsigned int":
        r"""
        decision_maker_v(constellation_expl_rect_sptr self, pmt_vector_cfloat sample) -> unsigned int
        Takes a vector rather than a pointer. Better for SWIG wrapping.
        """
        return _digital_swig0.constellation_expl_rect_sptr_decision_maker_v(self, sample)

    def decision_maker_pe(self, sample: "gr_complex const *", phase_error: "float *") -> "unsigned int":
        r"""
        decision_maker_pe(constellation_expl_rect_sptr self, gr_complex const * sample, float * phase_error) -> unsigned int
        Also calculates the phase error.
        """
        return _digital_swig0.constellation_expl_rect_sptr_decision_maker_pe(self, sample, phase_error)

    def calc_metric(self, sample: "gr_complex const *", metric: "float *", type: "gr::digital::trellis_metric_type_t") -> "void":
        r"""
        calc_metric(constellation_expl_rect_sptr self, gr_complex const * sample, float * metric, gr::digital::trellis_metric_type_t type)
        Calculates distance.

        Calculates metrics for all points in the constellation. For use with the viterbi algorithm.
        """
        return _digital_swig0.constellation_expl_rect_sptr_calc_metric(self, sample, metric, type)

    def calc_euclidean_metric(self, sample: "gr_complex const *", metric: "float *") -> "void":
        r"""calc_euclidean_metric(constellation_expl_rect_sptr self, gr_complex const * sample, float * metric)"""
        return _digital_swig0.constellation_expl_rect_sptr_calc_euclidean_metric(self, sample, metric)

    def calc_hard_symbol_metric(self, sample: "gr_complex const *", metric: "float *") -> "void":
        r"""calc_hard_symbol_metric(constellation_expl_rect_sptr self, gr_complex const * sample, float * metric)"""
        return _digital_swig0.constellation_expl_rect_sptr_calc_hard_symbol_metric(self, sample, metric)

    def points(self) -> "std::vector< gr_complex,std::allocator< gr_complex > >":
        r"""
        points(constellation_expl_rect_sptr self) -> pmt_vector_cfloat
        Returns the set of points in this constellation.
        """
        return _digital_swig0.constellation_expl_rect_sptr_points(self)

    def s_points(self) -> "std::vector< gr_complex,std::allocator< gr_complex > >":
        r"""
        s_points(constellation_expl_rect_sptr self) -> pmt_vector_cfloat
        Returns the vector of points in this constellation. Raise error if dimensionality is not one.
        """
        return _digital_swig0.constellation_expl_rect_sptr_s_points(self)

    def v_points(self) -> "std::vector< std::vector< gr_complex,std::allocator< gr_complex > >,std::allocator< std::vector< gr_complex,std::allocator< gr_complex > > > >":
        r"""
        v_points(constellation_expl_rect_sptr self) -> gr_vector_vector_complexf
        Returns a vector of vectors of points.
        """
        return _digital_swig0.constellation_expl_rect_sptr_v_points(self)

    def apply_pre_diff_code(self) -> "bool":
        r"""
        apply_pre_diff_code(constellation_expl_rect_sptr self) -> bool
        Whether to apply an encoding before doing differential encoding. (e.g. gray coding)
        """
        return _digital_swig0.constellation_expl_rect_sptr_apply_pre_diff_code(self)

    def set_pre_diff_code(self, a: "bool") -> "void":
        r"""
        set_pre_diff_code(constellation_expl_rect_sptr self, bool a)
        Whether to apply an encoding before doing differential encoding. (e.g. gray coding)
        """
        return _digital_swig0.constellation_expl_rect_sptr_set_pre_diff_code(self, a)

    def pre_diff_code(self) -> "std::vector< int,std::allocator< int > >":
        r"""
        pre_diff_code(constellation_expl_rect_sptr self) -> std::vector< int,std::allocator< int > >
        Returns the encoding to apply before differential encoding.
        """
        return _digital_swig0.constellation_expl_rect_sptr_pre_diff_code(self)

    def rotational_symmetry(self) -> "unsigned int":
        r"""
        rotational_symmetry(constellation_expl_rect_sptr self) -> unsigned int
        Returns the order of rotational symmetry.
        """
        return _digital_swig0.constellation_expl_rect_sptr_rotational_symmetry(self)

    def dimensionality(self) -> "unsigned int":
        r"""
        dimensionality(constellation_expl_rect_sptr self) -> unsigned int
        Returns the number of complex numbers in a single symbol.
        """
        return _digital_swig0.constellation_expl_rect_sptr_dimensionality(self)

    def bits_per_symbol(self) -> "unsigned int":
        r"""bits_per_symbol(constellation_expl_rect_sptr self) -> unsigned int"""
        return _digital_swig0.constellation_expl_rect_sptr_bits_per_symbol(self)

    def arity(self) -> "unsigned int":
        r"""arity(constellation_expl_rect_sptr self) -> unsigned int"""
        return _digital_swig0.constellation_expl_rect_sptr_arity(self)

    def base(self) -> "gr::digital::constellation_sptr":
        r"""base(constellation_expl_rect_sptr self) -> constellation_sptr"""
        return _digital_swig0.constellation_expl_rect_sptr_base(self)

    def as_pmt(self) -> "pmt::pmt_t":
        r"""as_pmt(constellation_expl_rect_sptr self) -> swig_pmt_ptr"""
        return _digital_swig0.constellation_expl_rect_sptr_as_pmt(self)

    def gen_soft_dec_lut(self, precision: "int", npwr: "float"=1.0) -> "void":
        r"""
        gen_soft_dec_lut(constellation_expl_rect_sptr self, int precision, float npwr=1.0)
        Generates the soft decision LUT based on constellation and symbol map.

        Generates the soft decision LUT based on constellation and symbol map. It can be given a estimate of the noise power in the channel as .



        This is expensive to compute.
        """
        return _digital_swig0.constellation_expl_rect_sptr_gen_soft_dec_lut(self, precision, npwr)

    def calc_soft_dec(self, sample: "gr_complex", npwr: "float"=1.0) -> "std::vector< float,std::allocator< float > >":
        r"""
        calc_soft_dec(constellation_expl_rect_sptr self, gr_complex sample, float npwr=1.0) -> pmt_vector_float
        Calculate soft decisions for the given .

        Calculate the soft decisions from the given  at the given noise power .


        This is a very costly algorithm (especially for higher order modulations) and should be used sparingly. It uses the gen_soft_dec_lut function to generate the LUT, which should be done once or if a large change in the noise floor is detected.


        Instead of using this function, generate the LUT using the gen_soft_dec_lut after creating the constellation object and then use the soft_decision_maker function to return the answer from the LUT.
        """
        return _digital_swig0.constellation_expl_rect_sptr_calc_soft_dec(self, sample, npwr)

    def set_soft_dec_lut(self, soft_dec_lut: "std::vector< std::vector< float,std::allocator< float > >,std::allocator< std::vector< float,std::allocator< float > > > > const &", precision: "int") -> "void":
        r"""
        set_soft_dec_lut(constellation_expl_rect_sptr self, std::vector< std::vector< float,std::allocator< float > >,std::allocator< std::vector< float,std::allocator< float > > > > const & soft_dec_lut, int precision)
        Define a soft decision look-up table.

        Define a soft decision look-up table (LUT). Because soft decisions can be calculated in various ways with various levels of accuracy and complexity, this function allows users to create a LUT in their own way.


        Setting the LUT here means that has_soft_dec_lut will return true. Decision vectors returned by soft_decision_maker will be calculated using this LUT.
        """
        return _digital_swig0.constellation_expl_rect_sptr_set_soft_dec_lut(self, soft_dec_lut, precision)

    def has_soft_dec_lut(self) -> "bool":
        r"""
        has_soft_dec_lut(constellation_expl_rect_sptr self) -> bool
        Returns True if the soft decision LUT has been defined, False otherwise.
        """
        return _digital_swig0.constellation_expl_rect_sptr_has_soft_dec_lut(self)

    def soft_dec_lut(self) -> "std::vector< std::vector< float,std::allocator< float > >,std::allocator< std::vector< float,std::allocator< float > > > >":
        r"""soft_dec_lut(constellation_expl_rect_sptr self) -> std::vector< std::vector< float,std::allocator< float > >,std::allocator< std::vector< float,std::allocator< float > > > >"""
        return _digital_swig0.constellation_expl_rect_sptr_soft_dec_lut(self)

    def soft_decision_maker(self, sample: "gr_complex") -> "std::vector< float,std::allocator< float > >":
        r"""
        soft_decision_maker(constellation_expl_rect_sptr self, gr_complex sample) -> pmt_vector_float
        Returns the soft decisions for the given .

        Returns the soft decisions for the given . If a LUT is defined for the object, the decisions will be calculated from there. Otherwise, this function will call calc_soft_dec directly to calculate the soft decisions.
        """
        return _digital_swig0.constellation_expl_rect_sptr_soft_decision_maker(self, sample)

# Register constellation_expl_rect_sptr in _digital_swig0:
_digital_swig0.constellation_expl_rect_sptr_swigregister(constellation_expl_rect_sptr)

constellation_expl_rect_sptr.__repr__ = lambda self: "<constellation expl rect (m=%d)>" % (len(self.points()))
constellation_expl_rect = constellation_expl_rect.make;

class constellation_psk_sptr(object):
    r"""Proxy of C++ boost::shared_ptr< gr::digital::constellation_psk > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(constellation_psk_sptr self) -> constellation_psk_sptr
        __init__(constellation_psk_sptr self, constellation_psk p) -> constellation_psk_sptr
        """
        _digital_swig0.constellation_psk_sptr_swiginit(self, _digital_swig0.new_constellation_psk_sptr(*args))

    def __deref__(self) -> "gr::digital::constellation_psk *":
        r"""__deref__(constellation_psk_sptr self) -> constellation_psk"""
        return _digital_swig0.constellation_psk_sptr___deref__(self)
    __swig_destroy__ = _digital_swig0.delete_constellation_psk_sptr

    def make(self, constell: "pmt_vector_cfloat", pre_diff_code: "std::vector< int,std::allocator< int > >", n_sectors: "unsigned int") -> "gr::digital::constellation_psk::sptr":
        r"""
        make(constellation_psk_sptr self, pmt_vector_cfloat constell, std::vector< int,std::allocator< int > > pre_diff_code, unsigned int n_sectors) -> constellation_psk_sptr
        constellation_psk

        Constellation space is divided into pie slices sectors.


        Each slice is associated with the nearest constellation point.


        Works well for PSK but nothing else.


        Assumes that there is a constellation point at 1.x

        Constructor Specific Documentation:



        Args:
            constell : 
            pre_diff_code : 
            n_sectors : 
        """
        return _digital_swig0.constellation_psk_sptr_make(self, constell, pre_diff_code, n_sectors)

    def map_to_points(self, value: "unsigned int", points: "gr_complex *") -> "void":
        r"""
        map_to_points(constellation_psk_sptr self, unsigned int value, gr_complex * points)
        Returns the constellation points for a symbol value.
        """
        return _digital_swig0.constellation_psk_sptr_map_to_points(self, value, points)

    def map_to_points_v(self, value: "unsigned int") -> "std::vector< gr_complex,std::allocator< gr_complex > >":
        r"""map_to_points_v(constellation_psk_sptr self, unsigned int value) -> pmt_vector_cfloat"""
        return _digital_swig0.constellation_psk_sptr_map_to_points_v(self, value)

    def decision_maker(self, sample: "gr_complex const *") -> "unsigned int":
        r"""
        decision_maker(constellation_psk_sptr self, gr_complex const * sample) -> unsigned int
        Returns the constellation point that matches best.
        """
        return _digital_swig0.constellation_psk_sptr_decision_maker(self, sample)

    def decision_maker_v(self, sample: "pmt_vector_cfloat") -> "unsigned int":
        r"""
        decision_maker_v(constellation_psk_sptr self, pmt_vector_cfloat sample) -> unsigned int
        Takes a vector rather than a pointer. Better for SWIG wrapping.
        """
        return _digital_swig0.constellation_psk_sptr_decision_maker_v(self, sample)

    def decision_maker_pe(self, sample: "gr_complex const *", phase_error: "float *") -> "unsigned int":
        r"""
        decision_maker_pe(constellation_psk_sptr self, gr_complex const * sample, float * phase_error) -> unsigned int
        Also calculates the phase error.
        """
        return _digital_swig0.constellation_psk_sptr_decision_maker_pe(self, sample, phase_error)

    def calc_metric(self, sample: "gr_complex const *", metric: "float *", type: "gr::digital::trellis_metric_type_t") -> "void":
        r"""
        calc_metric(constellation_psk_sptr self, gr_complex const * sample, float * metric, gr::digital::trellis_metric_type_t type)
        Calculates distance.

        Calculates metrics for all points in the constellation. For use with the viterbi algorithm.
        """
        return _digital_swig0.constellation_psk_sptr_calc_metric(self, sample, metric, type)

    def calc_euclidean_metric(self, sample: "gr_complex const *", metric: "float *") -> "void":
        r"""calc_euclidean_metric(constellation_psk_sptr self, gr_complex const * sample, float * metric)"""
        return _digital_swig0.constellation_psk_sptr_calc_euclidean_metric(self, sample, metric)

    def calc_hard_symbol_metric(self, sample: "gr_complex const *", metric: "float *") -> "void":
        r"""calc_hard_symbol_metric(constellation_psk_sptr self, gr_complex const * sample, float * metric)"""
        return _digital_swig0.constellation_psk_sptr_calc_hard_symbol_metric(self, sample, metric)

    def points(self) -> "std::vector< gr_complex,std::allocator< gr_complex > >":
        r"""
        points(constellation_psk_sptr self) -> pmt_vector_cfloat
        Returns the set of points in this constellation.
        """
        return _digital_swig0.constellation_psk_sptr_points(self)

    def s_points(self) -> "std::vector< gr_complex,std::allocator< gr_complex > >":
        r"""
        s_points(constellation_psk_sptr self) -> pmt_vector_cfloat
        Returns the vector of points in this constellation. Raise error if dimensionality is not one.
        """
        return _digital_swig0.constellation_psk_sptr_s_points(self)

    def v_points(self) -> "std::vector< std::vector< gr_complex,std::allocator< gr_complex > >,std::allocator< std::vector< gr_complex,std::allocator< gr_complex > > > >":
        r"""
        v_points(constellation_psk_sptr self) -> gr_vector_vector_complexf
        Returns a vector of vectors of points.
        """
        return _digital_swig0.constellation_psk_sptr_v_points(self)

    def apply_pre_diff_code(self) -> "bool":
        r"""
        apply_pre_diff_code(constellation_psk_sptr self) -> bool
        Whether to apply an encoding before doing differential encoding. (e.g. gray coding)
        """
        return _digital_swig0.constellation_psk_sptr_apply_pre_diff_code(self)

    def set_pre_diff_code(self, a: "bool") -> "void":
        r"""
        set_pre_diff_code(constellation_psk_sptr self, bool a)
        Whether to apply an encoding before doing differential encoding. (e.g. gray coding)
        """
        return _digital_swig0.constellation_psk_sptr_set_pre_diff_code(self, a)

    def pre_diff_code(self) -> "std::vector< int,std::allocator< int > >":
        r"""
        pre_diff_code(constellation_psk_sptr self) -> std::vector< int,std::allocator< int > >
        Returns the encoding to apply before differential encoding.
        """
        return _digital_swig0.constellation_psk_sptr_pre_diff_code(self)

    def rotational_symmetry(self) -> "unsigned int":
        r"""
        rotational_symmetry(constellation_psk_sptr self) -> unsigned int
        Returns the order of rotational symmetry.
        """
        return _digital_swig0.constellation_psk_sptr_rotational_symmetry(self)

    def dimensionality(self) -> "unsigned int":
        r"""
        dimensionality(constellation_psk_sptr self) -> unsigned int
        Returns the number of complex numbers in a single symbol.
        """
        return _digital_swig0.constellation_psk_sptr_dimensionality(self)

    def bits_per_symbol(self) -> "unsigned int":
        r"""bits_per_symbol(constellation_psk_sptr self) -> unsigned int"""
        return _digital_swig0.constellation_psk_sptr_bits_per_symbol(self)

    def arity(self) -> "unsigned int":
        r"""arity(constellation_psk_sptr self) -> unsigned int"""
        return _digital_swig0.constellation_psk_sptr_arity(self)

    def base(self) -> "gr::digital::constellation_sptr":
        r"""base(constellation_psk_sptr self) -> constellation_sptr"""
        return _digital_swig0.constellation_psk_sptr_base(self)

    def as_pmt(self) -> "pmt::pmt_t":
        r"""as_pmt(constellation_psk_sptr self) -> swig_pmt_ptr"""
        return _digital_swig0.constellation_psk_sptr_as_pmt(self)

    def gen_soft_dec_lut(self, precision: "int", npwr: "float"=1.0) -> "void":
        r"""
        gen_soft_dec_lut(constellation_psk_sptr self, int precision, float npwr=1.0)
        Generates the soft decision LUT based on constellation and symbol map.

        Generates the soft decision LUT based on constellation and symbol map. It can be given a estimate of the noise power in the channel as .



        This is expensive to compute.
        """
        return _digital_swig0.constellation_psk_sptr_gen_soft_dec_lut(self, precision, npwr)

    def calc_soft_dec(self, sample: "gr_complex", npwr: "float"=1.0) -> "std::vector< float,std::allocator< float > >":
        r"""
        calc_soft_dec(constellation_psk_sptr self, gr_complex sample, float npwr=1.0) -> pmt_vector_float
        Calculate soft decisions for the given .

        Calculate the soft decisions from the given  at the given noise power .


        This is a very costly algorithm (especially for higher order modulations) and should be used sparingly. It uses the gen_soft_dec_lut function to generate the LUT, which should be done once or if a large change in the noise floor is detected.


        Instead of using this function, generate the LUT using the gen_soft_dec_lut after creating the constellation object and then use the soft_decision_maker function to return the answer from the LUT.
        """
        return _digital_swig0.constellation_psk_sptr_calc_soft_dec(self, sample, npwr)

    def set_soft_dec_lut(self, soft_dec_lut: "std::vector< std::vector< float,std::allocator< float > >,std::allocator< std::vector< float,std::allocator< float > > > > const &", precision: "int") -> "void":
        r"""
        set_soft_dec_lut(constellation_psk_sptr self, std::vector< std::vector< float,std::allocator< float > >,std::allocator< std::vector< float,std::allocator< float > > > > const & soft_dec_lut, int precision)
        Define a soft decision look-up table.

        Define a soft decision look-up table (LUT). Because soft decisions can be calculated in various ways with various levels of accuracy and complexity, this function allows users to create a LUT in their own way.


        Setting the LUT here means that has_soft_dec_lut will return true. Decision vectors returned by soft_decision_maker will be calculated using this LUT.
        """
        return _digital_swig0.constellation_psk_sptr_set_soft_dec_lut(self, soft_dec_lut, precision)

    def has_soft_dec_lut(self) -> "bool":
        r"""
        has_soft_dec_lut(constellation_psk_sptr self) -> bool
        Returns True if the soft decision LUT has been defined, False otherwise.
        """
        return _digital_swig0.constellation_psk_sptr_has_soft_dec_lut(self)

    def soft_dec_lut(self) -> "std::vector< std::vector< float,std::allocator< float > >,std::allocator< std::vector< float,std::allocator< float > > > >":
        r"""soft_dec_lut(constellation_psk_sptr self) -> std::vector< std::vector< float,std::allocator< float > >,std::allocator< std::vector< float,std::allocator< float > > > >"""
        return _digital_swig0.constellation_psk_sptr_soft_dec_lut(self)

    def soft_decision_maker(self, sample: "gr_complex") -> "std::vector< float,std::allocator< float > >":
        r"""
        soft_decision_maker(constellation_psk_sptr self, gr_complex sample) -> pmt_vector_float
        Returns the soft decisions for the given .

        Returns the soft decisions for the given . If a LUT is defined for the object, the decisions will be calculated from there. Otherwise, this function will call calc_soft_dec directly to calculate the soft decisions.
        """
        return _digital_swig0.constellation_psk_sptr_soft_decision_maker(self, sample)

# Register constellation_psk_sptr in _digital_swig0:
_digital_swig0.constellation_psk_sptr_swigregister(constellation_psk_sptr)

constellation_psk_sptr.__repr__ = lambda self: "<constellation PSK (m=%d)>" % (len(self.points()))
constellation_psk = constellation_psk.make;

class constellation_bpsk_sptr(object):
    r"""Proxy of C++ boost::shared_ptr< gr::digital::constellation_bpsk > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(constellation_bpsk_sptr self) -> constellation_bpsk_sptr
        __init__(constellation_bpsk_sptr self, constellation_bpsk p) -> constellation_bpsk_sptr
        """
        _digital_swig0.constellation_bpsk_sptr_swiginit(self, _digital_swig0.new_constellation_bpsk_sptr(*args))

    def __deref__(self) -> "gr::digital::constellation_bpsk *":
        r"""__deref__(constellation_bpsk_sptr self) -> constellation_bpsk"""
        return _digital_swig0.constellation_bpsk_sptr___deref__(self)
    __swig_destroy__ = _digital_swig0.delete_constellation_bpsk_sptr

    def make(self) -> "gr::digital::constellation_bpsk::sptr":
        r"""
        make(constellation_bpsk_sptr self) -> constellation_bpsk_sptr
        Digital constellation for BPSK .

        Constructor Specific Documentation:


        """
        return _digital_swig0.constellation_bpsk_sptr_make(self)

    def map_to_points(self, value: "unsigned int", points: "gr_complex *") -> "void":
        r"""
        map_to_points(constellation_bpsk_sptr self, unsigned int value, gr_complex * points)
        Returns the constellation points for a symbol value.
        """
        return _digital_swig0.constellation_bpsk_sptr_map_to_points(self, value, points)

    def map_to_points_v(self, value: "unsigned int") -> "std::vector< gr_complex,std::allocator< gr_complex > >":
        r"""map_to_points_v(constellation_bpsk_sptr self, unsigned int value) -> pmt_vector_cfloat"""
        return _digital_swig0.constellation_bpsk_sptr_map_to_points_v(self, value)

    def decision_maker(self, sample: "gr_complex const *") -> "unsigned int":
        r"""
        decision_maker(constellation_bpsk_sptr self, gr_complex const * sample) -> unsigned int
        Returns the constellation point that matches best.
        """
        return _digital_swig0.constellation_bpsk_sptr_decision_maker(self, sample)

    def decision_maker_v(self, sample: "pmt_vector_cfloat") -> "unsigned int":
        r"""
        decision_maker_v(constellation_bpsk_sptr self, pmt_vector_cfloat sample) -> unsigned int
        Takes a vector rather than a pointer. Better for SWIG wrapping.
        """
        return _digital_swig0.constellation_bpsk_sptr_decision_maker_v(self, sample)

    def decision_maker_pe(self, sample: "gr_complex const *", phase_error: "float *") -> "unsigned int":
        r"""
        decision_maker_pe(constellation_bpsk_sptr self, gr_complex const * sample, float * phase_error) -> unsigned int
        Also calculates the phase error.
        """
        return _digital_swig0.constellation_bpsk_sptr_decision_maker_pe(self, sample, phase_error)

    def calc_metric(self, sample: "gr_complex const *", metric: "float *", type: "gr::digital::trellis_metric_type_t") -> "void":
        r"""
        calc_metric(constellation_bpsk_sptr self, gr_complex const * sample, float * metric, gr::digital::trellis_metric_type_t type)
        Calculates distance.

        Calculates metrics for all points in the constellation. For use with the viterbi algorithm.
        """
        return _digital_swig0.constellation_bpsk_sptr_calc_metric(self, sample, metric, type)

    def calc_euclidean_metric(self, sample: "gr_complex const *", metric: "float *") -> "void":
        r"""calc_euclidean_metric(constellation_bpsk_sptr self, gr_complex const * sample, float * metric)"""
        return _digital_swig0.constellation_bpsk_sptr_calc_euclidean_metric(self, sample, metric)

    def calc_hard_symbol_metric(self, sample: "gr_complex const *", metric: "float *") -> "void":
        r"""calc_hard_symbol_metric(constellation_bpsk_sptr self, gr_complex const * sample, float * metric)"""
        return _digital_swig0.constellation_bpsk_sptr_calc_hard_symbol_metric(self, sample, metric)

    def points(self) -> "std::vector< gr_complex,std::allocator< gr_complex > >":
        r"""
        points(constellation_bpsk_sptr self) -> pmt_vector_cfloat
        Returns the set of points in this constellation.
        """
        return _digital_swig0.constellation_bpsk_sptr_points(self)

    def s_points(self) -> "std::vector< gr_complex,std::allocator< gr_complex > >":
        r"""
        s_points(constellation_bpsk_sptr self) -> pmt_vector_cfloat
        Returns the vector of points in this constellation. Raise error if dimensionality is not one.
        """
        return _digital_swig0.constellation_bpsk_sptr_s_points(self)

    def v_points(self) -> "std::vector< std::vector< gr_complex,std::allocator< gr_complex > >,std::allocator< std::vector< gr_complex,std::allocator< gr_complex > > > >":
        r"""
        v_points(constellation_bpsk_sptr self) -> gr_vector_vector_complexf
        Returns a vector of vectors of points.
        """
        return _digital_swig0.constellation_bpsk_sptr_v_points(self)

    def apply_pre_diff_code(self) -> "bool":
        r"""
        apply_pre_diff_code(constellation_bpsk_sptr self) -> bool
        Whether to apply an encoding before doing differential encoding. (e.g. gray coding)
        """
        return _digital_swig0.constellation_bpsk_sptr_apply_pre_diff_code(self)

    def set_pre_diff_code(self, a: "bool") -> "void":
        r"""
        set_pre_diff_code(constellation_bpsk_sptr self, bool a)
        Whether to apply an encoding before doing differential encoding. (e.g. gray coding)
        """
        return _digital_swig0.constellation_bpsk_sptr_set_pre_diff_code(self, a)

    def pre_diff_code(self) -> "std::vector< int,std::allocator< int > >":
        r"""
        pre_diff_code(constellation_bpsk_sptr self) -> std::vector< int,std::allocator< int > >
        Returns the encoding to apply before differential encoding.
        """
        return _digital_swig0.constellation_bpsk_sptr_pre_diff_code(self)

    def rotational_symmetry(self) -> "unsigned int":
        r"""
        rotational_symmetry(constellation_bpsk_sptr self) -> unsigned int
        Returns the order of rotational symmetry.
        """
        return _digital_swig0.constellation_bpsk_sptr_rotational_symmetry(self)

    def dimensionality(self) -> "unsigned int":
        r"""
        dimensionality(constellation_bpsk_sptr self) -> unsigned int
        Returns the number of complex numbers in a single symbol.
        """
        return _digital_swig0.constellation_bpsk_sptr_dimensionality(self)

    def bits_per_symbol(self) -> "unsigned int":
        r"""bits_per_symbol(constellation_bpsk_sptr self) -> unsigned int"""
        return _digital_swig0.constellation_bpsk_sptr_bits_per_symbol(self)

    def arity(self) -> "unsigned int":
        r"""arity(constellation_bpsk_sptr self) -> unsigned int"""
        return _digital_swig0.constellation_bpsk_sptr_arity(self)

    def base(self) -> "gr::digital::constellation_sptr":
        r"""base(constellation_bpsk_sptr self) -> constellation_sptr"""
        return _digital_swig0.constellation_bpsk_sptr_base(self)

    def as_pmt(self) -> "pmt::pmt_t":
        r"""as_pmt(constellation_bpsk_sptr self) -> swig_pmt_ptr"""
        return _digital_swig0.constellation_bpsk_sptr_as_pmt(self)

    def gen_soft_dec_lut(self, precision: "int", npwr: "float"=1.0) -> "void":
        r"""
        gen_soft_dec_lut(constellation_bpsk_sptr self, int precision, float npwr=1.0)
        Generates the soft decision LUT based on constellation and symbol map.

        Generates the soft decision LUT based on constellation and symbol map. It can be given a estimate of the noise power in the channel as .



        This is expensive to compute.
        """
        return _digital_swig0.constellation_bpsk_sptr_gen_soft_dec_lut(self, precision, npwr)

    def calc_soft_dec(self, sample: "gr_complex", npwr: "float"=1.0) -> "std::vector< float,std::allocator< float > >":
        r"""
        calc_soft_dec(constellation_bpsk_sptr self, gr_complex sample, float npwr=1.0) -> pmt_vector_float
        Calculate soft decisions for the given .

        Calculate the soft decisions from the given  at the given noise power .


        This is a very costly algorithm (especially for higher order modulations) and should be used sparingly. It uses the gen_soft_dec_lut function to generate the LUT, which should be done once or if a large change in the noise floor is detected.


        Instead of using this function, generate the LUT using the gen_soft_dec_lut after creating the constellation object and then use the soft_decision_maker function to return the answer from the LUT.
        """
        return _digital_swig0.constellation_bpsk_sptr_calc_soft_dec(self, sample, npwr)

    def set_soft_dec_lut(self, soft_dec_lut: "std::vector< std::vector< float,std::allocator< float > >,std::allocator< std::vector< float,std::allocator< float > > > > const &", precision: "int") -> "void":
        r"""
        set_soft_dec_lut(constellation_bpsk_sptr self, std::vector< std::vector< float,std::allocator< float > >,std::allocator< std::vector< float,std::allocator< float > > > > const & soft_dec_lut, int precision)
        Define a soft decision look-up table.

        Define a soft decision look-up table (LUT). Because soft decisions can be calculated in various ways with various levels of accuracy and complexity, this function allows users to create a LUT in their own way.


        Setting the LUT here means that has_soft_dec_lut will return true. Decision vectors returned by soft_decision_maker will be calculated using this LUT.
        """
        return _digital_swig0.constellation_bpsk_sptr_set_soft_dec_lut(self, soft_dec_lut, precision)

    def has_soft_dec_lut(self) -> "bool":
        r"""
        has_soft_dec_lut(constellation_bpsk_sptr self) -> bool
        Returns True if the soft decision LUT has been defined, False otherwise.
        """
        return _digital_swig0.constellation_bpsk_sptr_has_soft_dec_lut(self)

    def soft_dec_lut(self) -> "std::vector< std::vector< float,std::allocator< float > >,std::allocator< std::vector< float,std::allocator< float > > > >":
        r"""soft_dec_lut(constellation_bpsk_sptr self) -> std::vector< std::vector< float,std::allocator< float > >,std::allocator< std::vector< float,std::allocator< float > > > >"""
        return _digital_swig0.constellation_bpsk_sptr_soft_dec_lut(self)

    def soft_decision_maker(self, sample: "gr_complex") -> "std::vector< float,std::allocator< float > >":
        r"""
        soft_decision_maker(constellation_bpsk_sptr self, gr_complex sample) -> pmt_vector_float
        Returns the soft decisions for the given .

        Returns the soft decisions for the given . If a LUT is defined for the object, the decisions will be calculated from there. Otherwise, this function will call calc_soft_dec directly to calculate the soft decisions.
        """
        return _digital_swig0.constellation_bpsk_sptr_soft_decision_maker(self, sample)

# Register constellation_bpsk_sptr in _digital_swig0:
_digital_swig0.constellation_bpsk_sptr_swigregister(constellation_bpsk_sptr)

constellation_bpsk_sptr.__repr__ = lambda self: "<constellation BPSK>"
constellation_bpsk = constellation_bpsk.make;

class constellation_qpsk_sptr(object):
    r"""Proxy of C++ boost::shared_ptr< gr::digital::constellation_qpsk > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(constellation_qpsk_sptr self) -> constellation_qpsk_sptr
        __init__(constellation_qpsk_sptr self, constellation_qpsk p) -> constellation_qpsk_sptr
        """
        _digital_swig0.constellation_qpsk_sptr_swiginit(self, _digital_swig0.new_constellation_qpsk_sptr(*args))

    def __deref__(self) -> "gr::digital::constellation_qpsk *":
        r"""__deref__(constellation_qpsk_sptr self) -> constellation_qpsk"""
        return _digital_swig0.constellation_qpsk_sptr___deref__(self)
    __swig_destroy__ = _digital_swig0.delete_constellation_qpsk_sptr

    def make(self) -> "gr::digital::constellation_qpsk::sptr":
        r"""
        make(constellation_qpsk_sptr self) -> constellation_qpsk_sptr
        Digital constellation for QPSK.

        Constellation diagram assumes little endian format e.g. top, left means 2 not 1.

        Constructor Specific Documentation:


        """
        return _digital_swig0.constellation_qpsk_sptr_make(self)

    def map_to_points(self, value: "unsigned int", points: "gr_complex *") -> "void":
        r"""
        map_to_points(constellation_qpsk_sptr self, unsigned int value, gr_complex * points)
        Returns the constellation points for a symbol value.
        """
        return _digital_swig0.constellation_qpsk_sptr_map_to_points(self, value, points)

    def map_to_points_v(self, value: "unsigned int") -> "std::vector< gr_complex,std::allocator< gr_complex > >":
        r"""map_to_points_v(constellation_qpsk_sptr self, unsigned int value) -> pmt_vector_cfloat"""
        return _digital_swig0.constellation_qpsk_sptr_map_to_points_v(self, value)

    def decision_maker(self, sample: "gr_complex const *") -> "unsigned int":
        r"""
        decision_maker(constellation_qpsk_sptr self, gr_complex const * sample) -> unsigned int
        Returns the constellation point that matches best.
        """
        return _digital_swig0.constellation_qpsk_sptr_decision_maker(self, sample)

    def decision_maker_v(self, sample: "pmt_vector_cfloat") -> "unsigned int":
        r"""
        decision_maker_v(constellation_qpsk_sptr self, pmt_vector_cfloat sample) -> unsigned int
        Takes a vector rather than a pointer. Better for SWIG wrapping.
        """
        return _digital_swig0.constellation_qpsk_sptr_decision_maker_v(self, sample)

    def decision_maker_pe(self, sample: "gr_complex const *", phase_error: "float *") -> "unsigned int":
        r"""
        decision_maker_pe(constellation_qpsk_sptr self, gr_complex const * sample, float * phase_error) -> unsigned int
        Also calculates the phase error.
        """
        return _digital_swig0.constellation_qpsk_sptr_decision_maker_pe(self, sample, phase_error)

    def calc_metric(self, sample: "gr_complex const *", metric: "float *", type: "gr::digital::trellis_metric_type_t") -> "void":
        r"""
        calc_metric(constellation_qpsk_sptr self, gr_complex const * sample, float * metric, gr::digital::trellis_metric_type_t type)
        Calculates distance.

        Calculates metrics for all points in the constellation. For use with the viterbi algorithm.
        """
        return _digital_swig0.constellation_qpsk_sptr_calc_metric(self, sample, metric, type)

    def calc_euclidean_metric(self, sample: "gr_complex const *", metric: "float *") -> "void":
        r"""calc_euclidean_metric(constellation_qpsk_sptr self, gr_complex const * sample, float * metric)"""
        return _digital_swig0.constellation_qpsk_sptr_calc_euclidean_metric(self, sample, metric)

    def calc_hard_symbol_metric(self, sample: "gr_complex const *", metric: "float *") -> "void":
        r"""calc_hard_symbol_metric(constellation_qpsk_sptr self, gr_complex const * sample, float * metric)"""
        return _digital_swig0.constellation_qpsk_sptr_calc_hard_symbol_metric(self, sample, metric)

    def points(self) -> "std::vector< gr_complex,std::allocator< gr_complex > >":
        r"""
        points(constellation_qpsk_sptr self) -> pmt_vector_cfloat
        Returns the set of points in this constellation.
        """
        return _digital_swig0.constellation_qpsk_sptr_points(self)

    def s_points(self) -> "std::vector< gr_complex,std::allocator< gr_complex > >":
        r"""
        s_points(constellation_qpsk_sptr self) -> pmt_vector_cfloat
        Returns the vector of points in this constellation. Raise error if dimensionality is not one.
        """
        return _digital_swig0.constellation_qpsk_sptr_s_points(self)

    def v_points(self) -> "std::vector< std::vector< gr_complex,std::allocator< gr_complex > >,std::allocator< std::vector< gr_complex,std::allocator< gr_complex > > > >":
        r"""
        v_points(constellation_qpsk_sptr self) -> gr_vector_vector_complexf
        Returns a vector of vectors of points.
        """
        return _digital_swig0.constellation_qpsk_sptr_v_points(self)

    def apply_pre_diff_code(self) -> "bool":
        r"""
        apply_pre_diff_code(constellation_qpsk_sptr self) -> bool
        Whether to apply an encoding before doing differential encoding. (e.g. gray coding)
        """
        return _digital_swig0.constellation_qpsk_sptr_apply_pre_diff_code(self)

    def set_pre_diff_code(self, a: "bool") -> "void":
        r"""
        set_pre_diff_code(constellation_qpsk_sptr self, bool a)
        Whether to apply an encoding before doing differential encoding. (e.g. gray coding)
        """
        return _digital_swig0.constellation_qpsk_sptr_set_pre_diff_code(self, a)

    def pre_diff_code(self) -> "std::vector< int,std::allocator< int > >":
        r"""
        pre_diff_code(constellation_qpsk_sptr self) -> std::vector< int,std::allocator< int > >
        Returns the encoding to apply before differential encoding.
        """
        return _digital_swig0.constellation_qpsk_sptr_pre_diff_code(self)

    def rotational_symmetry(self) -> "unsigned int":
        r"""
        rotational_symmetry(constellation_qpsk_sptr self) -> unsigned int
        Returns the order of rotational symmetry.
        """
        return _digital_swig0.constellation_qpsk_sptr_rotational_symmetry(self)

    def dimensionality(self) -> "unsigned int":
        r"""
        dimensionality(constellation_qpsk_sptr self) -> unsigned int
        Returns the number of complex numbers in a single symbol.
        """
        return _digital_swig0.constellation_qpsk_sptr_dimensionality(self)

    def bits_per_symbol(self) -> "unsigned int":
        r"""bits_per_symbol(constellation_qpsk_sptr self) -> unsigned int"""
        return _digital_swig0.constellation_qpsk_sptr_bits_per_symbol(self)

    def arity(self) -> "unsigned int":
        r"""arity(constellation_qpsk_sptr self) -> unsigned int"""
        return _digital_swig0.constellation_qpsk_sptr_arity(self)

    def base(self) -> "gr::digital::constellation_sptr":
        r"""base(constellation_qpsk_sptr self) -> constellation_sptr"""
        return _digital_swig0.constellation_qpsk_sptr_base(self)

    def as_pmt(self) -> "pmt::pmt_t":
        r"""as_pmt(constellation_qpsk_sptr self) -> swig_pmt_ptr"""
        return _digital_swig0.constellation_qpsk_sptr_as_pmt(self)

    def gen_soft_dec_lut(self, precision: "int", npwr: "float"=1.0) -> "void":
        r"""
        gen_soft_dec_lut(constellation_qpsk_sptr self, int precision, float npwr=1.0)
        Generates the soft decision LUT based on constellation and symbol map.

        Generates the soft decision LUT based on constellation and symbol map. It can be given a estimate of the noise power in the channel as .



        This is expensive to compute.
        """
        return _digital_swig0.constellation_qpsk_sptr_gen_soft_dec_lut(self, precision, npwr)

    def calc_soft_dec(self, sample: "gr_complex", npwr: "float"=1.0) -> "std::vector< float,std::allocator< float > >":
        r"""
        calc_soft_dec(constellation_qpsk_sptr self, gr_complex sample, float npwr=1.0) -> pmt_vector_float
        Calculate soft decisions for the given .

        Calculate the soft decisions from the given  at the given noise power .


        This is a very costly algorithm (especially for higher order modulations) and should be used sparingly. It uses the gen_soft_dec_lut function to generate the LUT, which should be done once or if a large change in the noise floor is detected.


        Instead of using this function, generate the LUT using the gen_soft_dec_lut after creating the constellation object and then use the soft_decision_maker function to return the answer from the LUT.
        """
        return _digital_swig0.constellation_qpsk_sptr_calc_soft_dec(self, sample, npwr)

    def set_soft_dec_lut(self, soft_dec_lut: "std::vector< std::vector< float,std::allocator< float > >,std::allocator< std::vector< float,std::allocator< float > > > > const &", precision: "int") -> "void":
        r"""
        set_soft_dec_lut(constellation_qpsk_sptr self, std::vector< std::vector< float,std::allocator< float > >,std::allocator< std::vector< float,std::allocator< float > > > > const & soft_dec_lut, int precision)
        Define a soft decision look-up table.

        Define a soft decision look-up table (LUT). Because soft decisions can be calculated in various ways with various levels of accuracy and complexity, this function allows users to create a LUT in their own way.


        Setting the LUT here means that has_soft_dec_lut will return true. Decision vectors returned by soft_decision_maker will be calculated using this LUT.
        """
        return _digital_swig0.constellation_qpsk_sptr_set_soft_dec_lut(self, soft_dec_lut, precision)

    def has_soft_dec_lut(self) -> "bool":
        r"""
        has_soft_dec_lut(constellation_qpsk_sptr self) -> bool
        Returns True if the soft decision LUT has been defined, False otherwise.
        """
        return _digital_swig0.constellation_qpsk_sptr_has_soft_dec_lut(self)

    def soft_dec_lut(self) -> "std::vector< std::vector< float,std::allocator< float > >,std::allocator< std::vector< float,std::allocator< float > > > >":
        r"""soft_dec_lut(constellation_qpsk_sptr self) -> std::vector< std::vector< float,std::allocator< float > >,std::allocator< std::vector< float,std::allocator< float > > > >"""
        return _digital_swig0.constellation_qpsk_sptr_soft_dec_lut(self)

    def soft_decision_maker(self, sample: "gr_complex") -> "std::vector< float,std::allocator< float > >":
        r"""
        soft_decision_maker(constellation_qpsk_sptr self, gr_complex sample) -> pmt_vector_float
        Returns the soft decisions for the given .

        Returns the soft decisions for the given . If a LUT is defined for the object, the decisions will be calculated from there. Otherwise, this function will call calc_soft_dec directly to calculate the soft decisions.
        """
        return _digital_swig0.constellation_qpsk_sptr_soft_decision_maker(self, sample)

# Register constellation_qpsk_sptr in _digital_swig0:
_digital_swig0.constellation_qpsk_sptr_swigregister(constellation_qpsk_sptr)

constellation_qpsk_sptr.__repr__ = lambda self: "<constellation QPSK>"
constellation_qpsk = constellation_qpsk.make;

class constellation_dqpsk_sptr(object):
    r"""Proxy of C++ boost::shared_ptr< gr::digital::constellation_dqpsk > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(constellation_dqpsk_sptr self) -> constellation_dqpsk_sptr
        __init__(constellation_dqpsk_sptr self, constellation_dqpsk p) -> constellation_dqpsk_sptr
        """
        _digital_swig0.constellation_dqpsk_sptr_swiginit(self, _digital_swig0.new_constellation_dqpsk_sptr(*args))

    def __deref__(self) -> "gr::digital::constellation_dqpsk *":
        r"""__deref__(constellation_dqpsk_sptr self) -> constellation_dqpsk"""
        return _digital_swig0.constellation_dqpsk_sptr___deref__(self)
    __swig_destroy__ = _digital_swig0.delete_constellation_dqpsk_sptr

    def make(self) -> "gr::digital::constellation_dqpsk::sptr":
        r"""
        make(constellation_dqpsk_sptr self) -> constellation_dqpsk_sptr
        Digital constellation for DQPSK.

        Constructor Specific Documentation:


        """
        return _digital_swig0.constellation_dqpsk_sptr_make(self)

    def map_to_points(self, value: "unsigned int", points: "gr_complex *") -> "void":
        r"""
        map_to_points(constellation_dqpsk_sptr self, unsigned int value, gr_complex * points)
        Returns the constellation points for a symbol value.
        """
        return _digital_swig0.constellation_dqpsk_sptr_map_to_points(self, value, points)

    def map_to_points_v(self, value: "unsigned int") -> "std::vector< gr_complex,std::allocator< gr_complex > >":
        r"""map_to_points_v(constellation_dqpsk_sptr self, unsigned int value) -> pmt_vector_cfloat"""
        return _digital_swig0.constellation_dqpsk_sptr_map_to_points_v(self, value)

    def decision_maker(self, sample: "gr_complex const *") -> "unsigned int":
        r"""
        decision_maker(constellation_dqpsk_sptr self, gr_complex const * sample) -> unsigned int
        Returns the constellation point that matches best.
        """
        return _digital_swig0.constellation_dqpsk_sptr_decision_maker(self, sample)

    def decision_maker_v(self, sample: "pmt_vector_cfloat") -> "unsigned int":
        r"""
        decision_maker_v(constellation_dqpsk_sptr self, pmt_vector_cfloat sample) -> unsigned int
        Takes a vector rather than a pointer. Better for SWIG wrapping.
        """
        return _digital_swig0.constellation_dqpsk_sptr_decision_maker_v(self, sample)

    def decision_maker_pe(self, sample: "gr_complex const *", phase_error: "float *") -> "unsigned int":
        r"""
        decision_maker_pe(constellation_dqpsk_sptr self, gr_complex const * sample, float * phase_error) -> unsigned int
        Also calculates the phase error.
        """
        return _digital_swig0.constellation_dqpsk_sptr_decision_maker_pe(self, sample, phase_error)

    def calc_metric(self, sample: "gr_complex const *", metric: "float *", type: "gr::digital::trellis_metric_type_t") -> "void":
        r"""
        calc_metric(constellation_dqpsk_sptr self, gr_complex const * sample, float * metric, gr::digital::trellis_metric_type_t type)
        Calculates distance.

        Calculates metrics for all points in the constellation. For use with the viterbi algorithm.
        """
        return _digital_swig0.constellation_dqpsk_sptr_calc_metric(self, sample, metric, type)

    def calc_euclidean_metric(self, sample: "gr_complex const *", metric: "float *") -> "void":
        r"""calc_euclidean_metric(constellation_dqpsk_sptr self, gr_complex const * sample, float * metric)"""
        return _digital_swig0.constellation_dqpsk_sptr_calc_euclidean_metric(self, sample, metric)

    def calc_hard_symbol_metric(self, sample: "gr_complex const *", metric: "float *") -> "void":
        r"""calc_hard_symbol_metric(constellation_dqpsk_sptr self, gr_complex const * sample, float * metric)"""
        return _digital_swig0.constellation_dqpsk_sptr_calc_hard_symbol_metric(self, sample, metric)

    def points(self) -> "std::vector< gr_complex,std::allocator< gr_complex > >":
        r"""
        points(constellation_dqpsk_sptr self) -> pmt_vector_cfloat
        Returns the set of points in this constellation.
        """
        return _digital_swig0.constellation_dqpsk_sptr_points(self)

    def s_points(self) -> "std::vector< gr_complex,std::allocator< gr_complex > >":
        r"""
        s_points(constellation_dqpsk_sptr self) -> pmt_vector_cfloat
        Returns the vector of points in this constellation. Raise error if dimensionality is not one.
        """
        return _digital_swig0.constellation_dqpsk_sptr_s_points(self)

    def v_points(self) -> "std::vector< std::vector< gr_complex,std::allocator< gr_complex > >,std::allocator< std::vector< gr_complex,std::allocator< gr_complex > > > >":
        r"""
        v_points(constellation_dqpsk_sptr self) -> gr_vector_vector_complexf
        Returns a vector of vectors of points.
        """
        return _digital_swig0.constellation_dqpsk_sptr_v_points(self)

    def apply_pre_diff_code(self) -> "bool":
        r"""
        apply_pre_diff_code(constellation_dqpsk_sptr self) -> bool
        Whether to apply an encoding before doing differential encoding. (e.g. gray coding)
        """
        return _digital_swig0.constellation_dqpsk_sptr_apply_pre_diff_code(self)

    def set_pre_diff_code(self, a: "bool") -> "void":
        r"""
        set_pre_diff_code(constellation_dqpsk_sptr self, bool a)
        Whether to apply an encoding before doing differential encoding. (e.g. gray coding)
        """
        return _digital_swig0.constellation_dqpsk_sptr_set_pre_diff_code(self, a)

    def pre_diff_code(self) -> "std::vector< int,std::allocator< int > >":
        r"""
        pre_diff_code(constellation_dqpsk_sptr self) -> std::vector< int,std::allocator< int > >
        Returns the encoding to apply before differential encoding.
        """
        return _digital_swig0.constellation_dqpsk_sptr_pre_diff_code(self)

    def rotational_symmetry(self) -> "unsigned int":
        r"""
        rotational_symmetry(constellation_dqpsk_sptr self) -> unsigned int
        Returns the order of rotational symmetry.
        """
        return _digital_swig0.constellation_dqpsk_sptr_rotational_symmetry(self)

    def dimensionality(self) -> "unsigned int":
        r"""
        dimensionality(constellation_dqpsk_sptr self) -> unsigned int
        Returns the number of complex numbers in a single symbol.
        """
        return _digital_swig0.constellation_dqpsk_sptr_dimensionality(self)

    def bits_per_symbol(self) -> "unsigned int":
        r"""bits_per_symbol(constellation_dqpsk_sptr self) -> unsigned int"""
        return _digital_swig0.constellation_dqpsk_sptr_bits_per_symbol(self)

    def arity(self) -> "unsigned int":
        r"""arity(constellation_dqpsk_sptr self) -> unsigned int"""
        return _digital_swig0.constellation_dqpsk_sptr_arity(self)

    def base(self) -> "gr::digital::constellation_sptr":
        r"""base(constellation_dqpsk_sptr self) -> constellation_sptr"""
        return _digital_swig0.constellation_dqpsk_sptr_base(self)

    def as_pmt(self) -> "pmt::pmt_t":
        r"""as_pmt(constellation_dqpsk_sptr self) -> swig_pmt_ptr"""
        return _digital_swig0.constellation_dqpsk_sptr_as_pmt(self)

    def gen_soft_dec_lut(self, precision: "int", npwr: "float"=1.0) -> "void":
        r"""
        gen_soft_dec_lut(constellation_dqpsk_sptr self, int precision, float npwr=1.0)
        Generates the soft decision LUT based on constellation and symbol map.

        Generates the soft decision LUT based on constellation and symbol map. It can be given a estimate of the noise power in the channel as .



        This is expensive to compute.
        """
        return _digital_swig0.constellation_dqpsk_sptr_gen_soft_dec_lut(self, precision, npwr)

    def calc_soft_dec(self, sample: "gr_complex", npwr: "float"=1.0) -> "std::vector< float,std::allocator< float > >":
        r"""
        calc_soft_dec(constellation_dqpsk_sptr self, gr_complex sample, float npwr=1.0) -> pmt_vector_float
        Calculate soft decisions for the given .

        Calculate the soft decisions from the given  at the given noise power .


        This is a very costly algorithm (especially for higher order modulations) and should be used sparingly. It uses the gen_soft_dec_lut function to generate the LUT, which should be done once or if a large change in the noise floor is detected.


        Instead of using this function, generate the LUT using the gen_soft_dec_lut after creating the constellation object and then use the soft_decision_maker function to return the answer from the LUT.
        """
        return _digital_swig0.constellation_dqpsk_sptr_calc_soft_dec(self, sample, npwr)

    def set_soft_dec_lut(self, soft_dec_lut: "std::vector< std::vector< float,std::allocator< float > >,std::allocator< std::vector< float,std::allocator< float > > > > const &", precision: "int") -> "void":
        r"""
        set_soft_dec_lut(constellation_dqpsk_sptr self, std::vector< std::vector< float,std::allocator< float > >,std::allocator< std::vector< float,std::allocator< float > > > > const & soft_dec_lut, int precision)
        Define a soft decision look-up table.

        Define a soft decision look-up table (LUT). Because soft decisions can be calculated in various ways with various levels of accuracy and complexity, this function allows users to create a LUT in their own way.


        Setting the LUT here means that has_soft_dec_lut will return true. Decision vectors returned by soft_decision_maker will be calculated using this LUT.
        """
        return _digital_swig0.constellation_dqpsk_sptr_set_soft_dec_lut(self, soft_dec_lut, precision)

    def has_soft_dec_lut(self) -> "bool":
        r"""
        has_soft_dec_lut(constellation_dqpsk_sptr self) -> bool
        Returns True if the soft decision LUT has been defined, False otherwise.
        """
        return _digital_swig0.constellation_dqpsk_sptr_has_soft_dec_lut(self)

    def soft_dec_lut(self) -> "std::vector< std::vector< float,std::allocator< float > >,std::allocator< std::vector< float,std::allocator< float > > > >":
        r"""soft_dec_lut(constellation_dqpsk_sptr self) -> std::vector< std::vector< float,std::allocator< float > >,std::allocator< std::vector< float,std::allocator< float > > > >"""
        return _digital_swig0.constellation_dqpsk_sptr_soft_dec_lut(self)

    def soft_decision_maker(self, sample: "gr_complex") -> "std::vector< float,std::allocator< float > >":
        r"""
        soft_decision_maker(constellation_dqpsk_sptr self, gr_complex sample) -> pmt_vector_float
        Returns the soft decisions for the given .

        Returns the soft decisions for the given . If a LUT is defined for the object, the decisions will be calculated from there. Otherwise, this function will call calc_soft_dec directly to calculate the soft decisions.
        """
        return _digital_swig0.constellation_dqpsk_sptr_soft_decision_maker(self, sample)

# Register constellation_dqpsk_sptr in _digital_swig0:
_digital_swig0.constellation_dqpsk_sptr_swigregister(constellation_dqpsk_sptr)

constellation_dqpsk_sptr.__repr__ = lambda self: "<constellation DQPSK>"
constellation_dqpsk = constellation_dqpsk.make;

class constellation_8psk_sptr(object):
    r"""Proxy of C++ boost::shared_ptr< gr::digital::constellation_8psk > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(constellation_8psk_sptr self) -> constellation_8psk_sptr
        __init__(constellation_8psk_sptr self, constellation_8psk p) -> constellation_8psk_sptr
        """
        _digital_swig0.constellation_8psk_sptr_swiginit(self, _digital_swig0.new_constellation_8psk_sptr(*args))

    def __deref__(self) -> "gr::digital::constellation_8psk *":
        r"""__deref__(constellation_8psk_sptr self) -> constellation_8psk"""
        return _digital_swig0.constellation_8psk_sptr___deref__(self)
    __swig_destroy__ = _digital_swig0.delete_constellation_8psk_sptr

    def make(self) -> "gr::digital::constellation_8psk::sptr":
        r"""
        make(constellation_8psk_sptr self) -> constellation_8psk_sptr
        Digital constellation for 8PSK.

        Constructor Specific Documentation:


        """
        return _digital_swig0.constellation_8psk_sptr_make(self)

    def map_to_points(self, value: "unsigned int", points: "gr_complex *") -> "void":
        r"""
        map_to_points(constellation_8psk_sptr self, unsigned int value, gr_complex * points)
        Returns the constellation points for a symbol value.
        """
        return _digital_swig0.constellation_8psk_sptr_map_to_points(self, value, points)

    def map_to_points_v(self, value: "unsigned int") -> "std::vector< gr_complex,std::allocator< gr_complex > >":
        r"""map_to_points_v(constellation_8psk_sptr self, unsigned int value) -> pmt_vector_cfloat"""
        return _digital_swig0.constellation_8psk_sptr_map_to_points_v(self, value)

    def decision_maker(self, sample: "gr_complex const *") -> "unsigned int":
        r"""
        decision_maker(constellation_8psk_sptr self, gr_complex const * sample) -> unsigned int
        Returns the constellation point that matches best.
        """
        return _digital_swig0.constellation_8psk_sptr_decision_maker(self, sample)

    def decision_maker_v(self, sample: "pmt_vector_cfloat") -> "unsigned int":
        r"""
        decision_maker_v(constellation_8psk_sptr self, pmt_vector_cfloat sample) -> unsigned int
        Takes a vector rather than a pointer. Better for SWIG wrapping.
        """
        return _digital_swig0.constellation_8psk_sptr_decision_maker_v(self, sample)

    def decision_maker_pe(self, sample: "gr_complex const *", phase_error: "float *") -> "unsigned int":
        r"""
        decision_maker_pe(constellation_8psk_sptr self, gr_complex const * sample, float * phase_error) -> unsigned int
        Also calculates the phase error.
        """
        return _digital_swig0.constellation_8psk_sptr_decision_maker_pe(self, sample, phase_error)

    def calc_metric(self, sample: "gr_complex const *", metric: "float *", type: "gr::digital::trellis_metric_type_t") -> "void":
        r"""
        calc_metric(constellation_8psk_sptr self, gr_complex const * sample, float * metric, gr::digital::trellis_metric_type_t type)
        Calculates distance.

        Calculates metrics for all points in the constellation. For use with the viterbi algorithm.
        """
        return _digital_swig0.constellation_8psk_sptr_calc_metric(self, sample, metric, type)

    def calc_euclidean_metric(self, sample: "gr_complex const *", metric: "float *") -> "void":
        r"""calc_euclidean_metric(constellation_8psk_sptr self, gr_complex const * sample, float * metric)"""
        return _digital_swig0.constellation_8psk_sptr_calc_euclidean_metric(self, sample, metric)

    def calc_hard_symbol_metric(self, sample: "gr_complex const *", metric: "float *") -> "void":
        r"""calc_hard_symbol_metric(constellation_8psk_sptr self, gr_complex const * sample, float * metric)"""
        return _digital_swig0.constellation_8psk_sptr_calc_hard_symbol_metric(self, sample, metric)

    def points(self) -> "std::vector< gr_complex,std::allocator< gr_complex > >":
        r"""
        points(constellation_8psk_sptr self) -> pmt_vector_cfloat
        Returns the set of points in this constellation.
        """
        return _digital_swig0.constellation_8psk_sptr_points(self)

    def s_points(self) -> "std::vector< gr_complex,std::allocator< gr_complex > >":
        r"""
        s_points(constellation_8psk_sptr self) -> pmt_vector_cfloat
        Returns the vector of points in this constellation. Raise error if dimensionality is not one.
        """
        return _digital_swig0.constellation_8psk_sptr_s_points(self)

    def v_points(self) -> "std::vector< std::vector< gr_complex,std::allocator< gr_complex > >,std::allocator< std::vector< gr_complex,std::allocator< gr_complex > > > >":
        r"""
        v_points(constellation_8psk_sptr self) -> gr_vector_vector_complexf
        Returns a vector of vectors of points.
        """
        return _digital_swig0.constellation_8psk_sptr_v_points(self)

    def apply_pre_diff_code(self) -> "bool":
        r"""
        apply_pre_diff_code(constellation_8psk_sptr self) -> bool
        Whether to apply an encoding before doing differential encoding. (e.g. gray coding)
        """
        return _digital_swig0.constellation_8psk_sptr_apply_pre_diff_code(self)

    def set_pre_diff_code(self, a: "bool") -> "void":
        r"""
        set_pre_diff_code(constellation_8psk_sptr self, bool a)
        Whether to apply an encoding before doing differential encoding. (e.g. gray coding)
        """
        return _digital_swig0.constellation_8psk_sptr_set_pre_diff_code(self, a)

    def pre_diff_code(self) -> "std::vector< int,std::allocator< int > >":
        r"""
        pre_diff_code(constellation_8psk_sptr self) -> std::vector< int,std::allocator< int > >
        Returns the encoding to apply before differential encoding.
        """
        return _digital_swig0.constellation_8psk_sptr_pre_diff_code(self)

    def rotational_symmetry(self) -> "unsigned int":
        r"""
        rotational_symmetry(constellation_8psk_sptr self) -> unsigned int
        Returns the order of rotational symmetry.
        """
        return _digital_swig0.constellation_8psk_sptr_rotational_symmetry(self)

    def dimensionality(self) -> "unsigned int":
        r"""
        dimensionality(constellation_8psk_sptr self) -> unsigned int
        Returns the number of complex numbers in a single symbol.
        """
        return _digital_swig0.constellation_8psk_sptr_dimensionality(self)

    def bits_per_symbol(self) -> "unsigned int":
        r"""bits_per_symbol(constellation_8psk_sptr self) -> unsigned int"""
        return _digital_swig0.constellation_8psk_sptr_bits_per_symbol(self)

    def arity(self) -> "unsigned int":
        r"""arity(constellation_8psk_sptr self) -> unsigned int"""
        return _digital_swig0.constellation_8psk_sptr_arity(self)

    def base(self) -> "gr::digital::constellation_sptr":
        r"""base(constellation_8psk_sptr self) -> constellation_sptr"""
        return _digital_swig0.constellation_8psk_sptr_base(self)

    def as_pmt(self) -> "pmt::pmt_t":
        r"""as_pmt(constellation_8psk_sptr self) -> swig_pmt_ptr"""
        return _digital_swig0.constellation_8psk_sptr_as_pmt(self)

    def gen_soft_dec_lut(self, precision: "int", npwr: "float"=1.0) -> "void":
        r"""
        gen_soft_dec_lut(constellation_8psk_sptr self, int precision, float npwr=1.0)
        Generates the soft decision LUT based on constellation and symbol map.

        Generates the soft decision LUT based on constellation and symbol map. It can be given a estimate of the noise power in the channel as .



        This is expensive to compute.
        """
        return _digital_swig0.constellation_8psk_sptr_gen_soft_dec_lut(self, precision, npwr)

    def calc_soft_dec(self, sample: "gr_complex", npwr: "float"=1.0) -> "std::vector< float,std::allocator< float > >":
        r"""
        calc_soft_dec(constellation_8psk_sptr self, gr_complex sample, float npwr=1.0) -> pmt_vector_float
        Calculate soft decisions for the given .

        Calculate the soft decisions from the given  at the given noise power .


        This is a very costly algorithm (especially for higher order modulations) and should be used sparingly. It uses the gen_soft_dec_lut function to generate the LUT, which should be done once or if a large change in the noise floor is detected.


        Instead of using this function, generate the LUT using the gen_soft_dec_lut after creating the constellation object and then use the soft_decision_maker function to return the answer from the LUT.
        """
        return _digital_swig0.constellation_8psk_sptr_calc_soft_dec(self, sample, npwr)

    def set_soft_dec_lut(self, soft_dec_lut: "std::vector< std::vector< float,std::allocator< float > >,std::allocator< std::vector< float,std::allocator< float > > > > const &", precision: "int") -> "void":
        r"""
        set_soft_dec_lut(constellation_8psk_sptr self, std::vector< std::vector< float,std::allocator< float > >,std::allocator< std::vector< float,std::allocator< float > > > > const & soft_dec_lut, int precision)
        Define a soft decision look-up table.

        Define a soft decision look-up table (LUT). Because soft decisions can be calculated in various ways with various levels of accuracy and complexity, this function allows users to create a LUT in their own way.


        Setting the LUT here means that has_soft_dec_lut will return true. Decision vectors returned by soft_decision_maker will be calculated using this LUT.
        """
        return _digital_swig0.constellation_8psk_sptr_set_soft_dec_lut(self, soft_dec_lut, precision)

    def has_soft_dec_lut(self) -> "bool":
        r"""
        has_soft_dec_lut(constellation_8psk_sptr self) -> bool
        Returns True if the soft decision LUT has been defined, False otherwise.
        """
        return _digital_swig0.constellation_8psk_sptr_has_soft_dec_lut(self)

    def soft_dec_lut(self) -> "std::vector< std::vector< float,std::allocator< float > >,std::allocator< std::vector< float,std::allocator< float > > > >":
        r"""soft_dec_lut(constellation_8psk_sptr self) -> std::vector< std::vector< float,std::allocator< float > >,std::allocator< std::vector< float,std::allocator< float > > > >"""
        return _digital_swig0.constellation_8psk_sptr_soft_dec_lut(self)

    def soft_decision_maker(self, sample: "gr_complex") -> "std::vector< float,std::allocator< float > >":
        r"""
        soft_decision_maker(constellation_8psk_sptr self, gr_complex sample) -> pmt_vector_float
        Returns the soft decisions for the given .

        Returns the soft decisions for the given . If a LUT is defined for the object, the decisions will be calculated from there. Otherwise, this function will call calc_soft_dec directly to calculate the soft decisions.
        """
        return _digital_swig0.constellation_8psk_sptr_soft_decision_maker(self, sample)

# Register constellation_8psk_sptr in _digital_swig0:
_digital_swig0.constellation_8psk_sptr_swigregister(constellation_8psk_sptr)

constellation_8psk_sptr.__repr__ = lambda self: "<constellation 8PSK>"
constellation_8psk = constellation_8psk.make;

class constellation_8psk_natural_sptr(object):
    r"""Proxy of C++ boost::shared_ptr< gr::digital::constellation_8psk_natural > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(constellation_8psk_natural_sptr self) -> constellation_8psk_natural_sptr
        __init__(constellation_8psk_natural_sptr self, constellation_8psk_natural p) -> constellation_8psk_natural_sptr
        """
        _digital_swig0.constellation_8psk_natural_sptr_swiginit(self, _digital_swig0.new_constellation_8psk_natural_sptr(*args))

    def __deref__(self) -> "gr::digital::constellation_8psk_natural *":
        r"""__deref__(constellation_8psk_natural_sptr self) -> constellation_8psk_natural"""
        return _digital_swig0.constellation_8psk_natural_sptr___deref__(self)
    __swig_destroy__ = _digital_swig0.delete_constellation_8psk_natural_sptr

    def make(self) -> "gr::digital::constellation_8psk_natural::sptr":
        r"""
        make(constellation_8psk_natural_sptr self) -> constellation_8psk_natural_sptr
        Digital constellation for natually mapped 8PSK.

        Constructor Specific Documentation:


        """
        return _digital_swig0.constellation_8psk_natural_sptr_make(self)

    def map_to_points(self, value: "unsigned int", points: "gr_complex *") -> "void":
        r"""
        map_to_points(constellation_8psk_natural_sptr self, unsigned int value, gr_complex * points)
        Returns the constellation points for a symbol value.
        """
        return _digital_swig0.constellation_8psk_natural_sptr_map_to_points(self, value, points)

    def map_to_points_v(self, value: "unsigned int") -> "std::vector< gr_complex,std::allocator< gr_complex > >":
        r"""map_to_points_v(constellation_8psk_natural_sptr self, unsigned int value) -> pmt_vector_cfloat"""
        return _digital_swig0.constellation_8psk_natural_sptr_map_to_points_v(self, value)

    def decision_maker(self, sample: "gr_complex const *") -> "unsigned int":
        r"""
        decision_maker(constellation_8psk_natural_sptr self, gr_complex const * sample) -> unsigned int
        Returns the constellation point that matches best.
        """
        return _digital_swig0.constellation_8psk_natural_sptr_decision_maker(self, sample)

    def decision_maker_v(self, sample: "pmt_vector_cfloat") -> "unsigned int":
        r"""
        decision_maker_v(constellation_8psk_natural_sptr self, pmt_vector_cfloat sample) -> unsigned int
        Takes a vector rather than a pointer. Better for SWIG wrapping.
        """
        return _digital_swig0.constellation_8psk_natural_sptr_decision_maker_v(self, sample)

    def decision_maker_pe(self, sample: "gr_complex const *", phase_error: "float *") -> "unsigned int":
        r"""
        decision_maker_pe(constellation_8psk_natural_sptr self, gr_complex const * sample, float * phase_error) -> unsigned int
        Also calculates the phase error.
        """
        return _digital_swig0.constellation_8psk_natural_sptr_decision_maker_pe(self, sample, phase_error)

    def calc_metric(self, sample: "gr_complex const *", metric: "float *", type: "gr::digital::trellis_metric_type_t") -> "void":
        r"""
        calc_metric(constellation_8psk_natural_sptr self, gr_complex const * sample, float * metric, gr::digital::trellis_metric_type_t type)
        Calculates distance.

        Calculates metrics for all points in the constellation. For use with the viterbi algorithm.
        """
        return _digital_swig0.constellation_8psk_natural_sptr_calc_metric(self, sample, metric, type)

    def calc_euclidean_metric(self, sample: "gr_complex const *", metric: "float *") -> "void":
        r"""calc_euclidean_metric(constellation_8psk_natural_sptr self, gr_complex const * sample, float * metric)"""
        return _digital_swig0.constellation_8psk_natural_sptr_calc_euclidean_metric(self, sample, metric)

    def calc_hard_symbol_metric(self, sample: "gr_complex const *", metric: "float *") -> "void":
        r"""calc_hard_symbol_metric(constellation_8psk_natural_sptr self, gr_complex const * sample, float * metric)"""
        return _digital_swig0.constellation_8psk_natural_sptr_calc_hard_symbol_metric(self, sample, metric)

    def points(self) -> "std::vector< gr_complex,std::allocator< gr_complex > >":
        r"""
        points(constellation_8psk_natural_sptr self) -> pmt_vector_cfloat
        Returns the set of points in this constellation.
        """
        return _digital_swig0.constellation_8psk_natural_sptr_points(self)

    def s_points(self) -> "std::vector< gr_complex,std::allocator< gr_complex > >":
        r"""
        s_points(constellation_8psk_natural_sptr self) -> pmt_vector_cfloat
        Returns the vector of points in this constellation. Raise error if dimensionality is not one.
        """
        return _digital_swig0.constellation_8psk_natural_sptr_s_points(self)

    def v_points(self) -> "std::vector< std::vector< gr_complex,std::allocator< gr_complex > >,std::allocator< std::vector< gr_complex,std::allocator< gr_complex > > > >":
        r"""
        v_points(constellation_8psk_natural_sptr self) -> gr_vector_vector_complexf
        Returns a vector of vectors of points.
        """
        return _digital_swig0.constellation_8psk_natural_sptr_v_points(self)

    def apply_pre_diff_code(self) -> "bool":
        r"""
        apply_pre_diff_code(constellation_8psk_natural_sptr self) -> bool
        Whether to apply an encoding before doing differential encoding. (e.g. gray coding)
        """
        return _digital_swig0.constellation_8psk_natural_sptr_apply_pre_diff_code(self)

    def set_pre_diff_code(self, a: "bool") -> "void":
        r"""
        set_pre_diff_code(constellation_8psk_natural_sptr self, bool a)
        Whether to apply an encoding before doing differential encoding. (e.g. gray coding)
        """
        return _digital_swig0.constellation_8psk_natural_sptr_set_pre_diff_code(self, a)

    def pre_diff_code(self) -> "std::vector< int,std::allocator< int > >":
        r"""
        pre_diff_code(constellation_8psk_natural_sptr self) -> std::vector< int,std::allocator< int > >
        Returns the encoding to apply before differential encoding.
        """
        return _digital_swig0.constellation_8psk_natural_sptr_pre_diff_code(self)

    def rotational_symmetry(self) -> "unsigned int":
        r"""
        rotational_symmetry(constellation_8psk_natural_sptr self) -> unsigned int
        Returns the order of rotational symmetry.
        """
        return _digital_swig0.constellation_8psk_natural_sptr_rotational_symmetry(self)

    def dimensionality(self) -> "unsigned int":
        r"""
        dimensionality(constellation_8psk_natural_sptr self) -> unsigned int
        Returns the number of complex numbers in a single symbol.
        """
        return _digital_swig0.constellation_8psk_natural_sptr_dimensionality(self)

    def bits_per_symbol(self) -> "unsigned int":
        r"""bits_per_symbol(constellation_8psk_natural_sptr self) -> unsigned int"""
        return _digital_swig0.constellation_8psk_natural_sptr_bits_per_symbol(self)

    def arity(self) -> "unsigned int":
        r"""arity(constellation_8psk_natural_sptr self) -> unsigned int"""
        return _digital_swig0.constellation_8psk_natural_sptr_arity(self)

    def base(self) -> "gr::digital::constellation_sptr":
        r"""base(constellation_8psk_natural_sptr self) -> constellation_sptr"""
        return _digital_swig0.constellation_8psk_natural_sptr_base(self)

    def as_pmt(self) -> "pmt::pmt_t":
        r"""as_pmt(constellation_8psk_natural_sptr self) -> swig_pmt_ptr"""
        return _digital_swig0.constellation_8psk_natural_sptr_as_pmt(self)

    def gen_soft_dec_lut(self, precision: "int", npwr: "float"=1.0) -> "void":
        r"""
        gen_soft_dec_lut(constellation_8psk_natural_sptr self, int precision, float npwr=1.0)
        Generates the soft decision LUT based on constellation and symbol map.

        Generates the soft decision LUT based on constellation and symbol map. It can be given a estimate of the noise power in the channel as .



        This is expensive to compute.
        """
        return _digital_swig0.constellation_8psk_natural_sptr_gen_soft_dec_lut(self, precision, npwr)

    def calc_soft_dec(self, sample: "gr_complex", npwr: "float"=1.0) -> "std::vector< float,std::allocator< float > >":
        r"""
        calc_soft_dec(constellation_8psk_natural_sptr self, gr_complex sample, float npwr=1.0) -> pmt_vector_float
        Calculate soft decisions for the given .

        Calculate the soft decisions from the given  at the given noise power .


        This is a very costly algorithm (especially for higher order modulations) and should be used sparingly. It uses the gen_soft_dec_lut function to generate the LUT, which should be done once or if a large change in the noise floor is detected.


        Instead of using this function, generate the LUT using the gen_soft_dec_lut after creating the constellation object and then use the soft_decision_maker function to return the answer from the LUT.
        """
        return _digital_swig0.constellation_8psk_natural_sptr_calc_soft_dec(self, sample, npwr)

    def set_soft_dec_lut(self, soft_dec_lut: "std::vector< std::vector< float,std::allocator< float > >,std::allocator< std::vector< float,std::allocator< float > > > > const &", precision: "int") -> "void":
        r"""
        set_soft_dec_lut(constellation_8psk_natural_sptr self, std::vector< std::vector< float,std::allocator< float > >,std::allocator< std::vector< float,std::allocator< float > > > > const & soft_dec_lut, int precision)
        Define a soft decision look-up table.

        Define a soft decision look-up table (LUT). Because soft decisions can be calculated in various ways with various levels of accuracy and complexity, this function allows users to create a LUT in their own way.


        Setting the LUT here means that has_soft_dec_lut will return true. Decision vectors returned by soft_decision_maker will be calculated using this LUT.
        """
        return _digital_swig0.constellation_8psk_natural_sptr_set_soft_dec_lut(self, soft_dec_lut, precision)

    def has_soft_dec_lut(self) -> "bool":
        r"""
        has_soft_dec_lut(constellation_8psk_natural_sptr self) -> bool
        Returns True if the soft decision LUT has been defined, False otherwise.
        """
        return _digital_swig0.constellation_8psk_natural_sptr_has_soft_dec_lut(self)

    def soft_dec_lut(self) -> "std::vector< std::vector< float,std::allocator< float > >,std::allocator< std::vector< float,std::allocator< float > > > >":
        r"""soft_dec_lut(constellation_8psk_natural_sptr self) -> std::vector< std::vector< float,std::allocator< float > >,std::allocator< std::vector< float,std::allocator< float > > > >"""
        return _digital_swig0.constellation_8psk_natural_sptr_soft_dec_lut(self)

    def soft_decision_maker(self, sample: "gr_complex") -> "std::vector< float,std::allocator< float > >":
        r"""
        soft_decision_maker(constellation_8psk_natural_sptr self, gr_complex sample) -> pmt_vector_float
        Returns the soft decisions for the given .

        Returns the soft decisions for the given . If a LUT is defined for the object, the decisions will be calculated from there. Otherwise, this function will call calc_soft_dec directly to calculate the soft decisions.
        """
        return _digital_swig0.constellation_8psk_natural_sptr_soft_decision_maker(self, sample)

# Register constellation_8psk_natural_sptr in _digital_swig0:
_digital_swig0.constellation_8psk_natural_sptr_swigregister(constellation_8psk_natural_sptr)

constellation_8psk_natural_sptr.__repr__ = lambda self: "<constellation 8PSK_natural>"
constellation_8psk_natural = constellation_8psk_natural.make;

class constellation_16qam_sptr(object):
    r"""Proxy of C++ boost::shared_ptr< gr::digital::constellation_16qam > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(constellation_16qam_sptr self) -> constellation_16qam_sptr
        __init__(constellation_16qam_sptr self, constellation_16qam p) -> constellation_16qam_sptr
        """
        _digital_swig0.constellation_16qam_sptr_swiginit(self, _digital_swig0.new_constellation_16qam_sptr(*args))

    def __deref__(self) -> "gr::digital::constellation_16qam *":
        r"""__deref__(constellation_16qam_sptr self) -> constellation_16qam"""
        return _digital_swig0.constellation_16qam_sptr___deref__(self)
    __swig_destroy__ = _digital_swig0.delete_constellation_16qam_sptr

    def make(self) -> "gr::digital::constellation_16qam::sptr":
        r"""
        make(constellation_16qam_sptr self) -> constellation_16qam_sptr
        Digital constellation for 16qam.

        Constructor Specific Documentation:


        """
        return _digital_swig0.constellation_16qam_sptr_make(self)

    def map_to_points(self, value: "unsigned int", points: "gr_complex *") -> "void":
        r"""
        map_to_points(constellation_16qam_sptr self, unsigned int value, gr_complex * points)
        Returns the constellation points for a symbol value.
        """
        return _digital_swig0.constellation_16qam_sptr_map_to_points(self, value, points)

    def map_to_points_v(self, value: "unsigned int") -> "std::vector< gr_complex,std::allocator< gr_complex > >":
        r"""map_to_points_v(constellation_16qam_sptr self, unsigned int value) -> pmt_vector_cfloat"""
        return _digital_swig0.constellation_16qam_sptr_map_to_points_v(self, value)

    def decision_maker(self, sample: "gr_complex const *") -> "unsigned int":
        r"""
        decision_maker(constellation_16qam_sptr self, gr_complex const * sample) -> unsigned int
        Returns the constellation point that matches best.
        """
        return _digital_swig0.constellation_16qam_sptr_decision_maker(self, sample)

    def decision_maker_v(self, sample: "pmt_vector_cfloat") -> "unsigned int":
        r"""
        decision_maker_v(constellation_16qam_sptr self, pmt_vector_cfloat sample) -> unsigned int
        Takes a vector rather than a pointer. Better for SWIG wrapping.
        """
        return _digital_swig0.constellation_16qam_sptr_decision_maker_v(self, sample)

    def decision_maker_pe(self, sample: "gr_complex const *", phase_error: "float *") -> "unsigned int":
        r"""
        decision_maker_pe(constellation_16qam_sptr self, gr_complex const * sample, float * phase_error) -> unsigned int
        Also calculates the phase error.
        """
        return _digital_swig0.constellation_16qam_sptr_decision_maker_pe(self, sample, phase_error)

    def calc_metric(self, sample: "gr_complex const *", metric: "float *", type: "gr::digital::trellis_metric_type_t") -> "void":
        r"""
        calc_metric(constellation_16qam_sptr self, gr_complex const * sample, float * metric, gr::digital::trellis_metric_type_t type)
        Calculates distance.

        Calculates metrics for all points in the constellation. For use with the viterbi algorithm.
        """
        return _digital_swig0.constellation_16qam_sptr_calc_metric(self, sample, metric, type)

    def calc_euclidean_metric(self, sample: "gr_complex const *", metric: "float *") -> "void":
        r"""calc_euclidean_metric(constellation_16qam_sptr self, gr_complex const * sample, float * metric)"""
        return _digital_swig0.constellation_16qam_sptr_calc_euclidean_metric(self, sample, metric)

    def calc_hard_symbol_metric(self, sample: "gr_complex const *", metric: "float *") -> "void":
        r"""calc_hard_symbol_metric(constellation_16qam_sptr self, gr_complex const * sample, float * metric)"""
        return _digital_swig0.constellation_16qam_sptr_calc_hard_symbol_metric(self, sample, metric)

    def points(self) -> "std::vector< gr_complex,std::allocator< gr_complex > >":
        r"""
        points(constellation_16qam_sptr self) -> pmt_vector_cfloat
        Returns the set of points in this constellation.
        """
        return _digital_swig0.constellation_16qam_sptr_points(self)

    def s_points(self) -> "std::vector< gr_complex,std::allocator< gr_complex > >":
        r"""
        s_points(constellation_16qam_sptr self) -> pmt_vector_cfloat
        Returns the vector of points in this constellation. Raise error if dimensionality is not one.
        """
        return _digital_swig0.constellation_16qam_sptr_s_points(self)

    def v_points(self) -> "std::vector< std::vector< gr_complex,std::allocator< gr_complex > >,std::allocator< std::vector< gr_complex,std::allocator< gr_complex > > > >":
        r"""
        v_points(constellation_16qam_sptr self) -> gr_vector_vector_complexf
        Returns a vector of vectors of points.
        """
        return _digital_swig0.constellation_16qam_sptr_v_points(self)

    def apply_pre_diff_code(self) -> "bool":
        r"""
        apply_pre_diff_code(constellation_16qam_sptr self) -> bool
        Whether to apply an encoding before doing differential encoding. (e.g. gray coding)
        """
        return _digital_swig0.constellation_16qam_sptr_apply_pre_diff_code(self)

    def set_pre_diff_code(self, a: "bool") -> "void":
        r"""
        set_pre_diff_code(constellation_16qam_sptr self, bool a)
        Whether to apply an encoding before doing differential encoding. (e.g. gray coding)
        """
        return _digital_swig0.constellation_16qam_sptr_set_pre_diff_code(self, a)

    def pre_diff_code(self) -> "std::vector< int,std::allocator< int > >":
        r"""
        pre_diff_code(constellation_16qam_sptr self) -> std::vector< int,std::allocator< int > >
        Returns the encoding to apply before differential encoding.
        """
        return _digital_swig0.constellation_16qam_sptr_pre_diff_code(self)

    def rotational_symmetry(self) -> "unsigned int":
        r"""
        rotational_symmetry(constellation_16qam_sptr self) -> unsigned int
        Returns the order of rotational symmetry.
        """
        return _digital_swig0.constellation_16qam_sptr_rotational_symmetry(self)

    def dimensionality(self) -> "unsigned int":
        r"""
        dimensionality(constellation_16qam_sptr self) -> unsigned int
        Returns the number of complex numbers in a single symbol.
        """
        return _digital_swig0.constellation_16qam_sptr_dimensionality(self)

    def bits_per_symbol(self) -> "unsigned int":
        r"""bits_per_symbol(constellation_16qam_sptr self) -> unsigned int"""
        return _digital_swig0.constellation_16qam_sptr_bits_per_symbol(self)

    def arity(self) -> "unsigned int":
        r"""arity(constellation_16qam_sptr self) -> unsigned int"""
        return _digital_swig0.constellation_16qam_sptr_arity(self)

    def base(self) -> "gr::digital::constellation_sptr":
        r"""base(constellation_16qam_sptr self) -> constellation_sptr"""
        return _digital_swig0.constellation_16qam_sptr_base(self)

    def as_pmt(self) -> "pmt::pmt_t":
        r"""as_pmt(constellation_16qam_sptr self) -> swig_pmt_ptr"""
        return _digital_swig0.constellation_16qam_sptr_as_pmt(self)

    def gen_soft_dec_lut(self, precision: "int", npwr: "float"=1.0) -> "void":
        r"""
        gen_soft_dec_lut(constellation_16qam_sptr self, int precision, float npwr=1.0)
        Generates the soft decision LUT based on constellation and symbol map.

        Generates the soft decision LUT based on constellation and symbol map. It can be given a estimate of the noise power in the channel as .



        This is expensive to compute.
        """
        return _digital_swig0.constellation_16qam_sptr_gen_soft_dec_lut(self, precision, npwr)

    def calc_soft_dec(self, sample: "gr_complex", npwr: "float"=1.0) -> "std::vector< float,std::allocator< float > >":
        r"""
        calc_soft_dec(constellation_16qam_sptr self, gr_complex sample, float npwr=1.0) -> pmt_vector_float
        Calculate soft decisions for the given .

        Calculate the soft decisions from the given  at the given noise power .


        This is a very costly algorithm (especially for higher order modulations) and should be used sparingly. It uses the gen_soft_dec_lut function to generate the LUT, which should be done once or if a large change in the noise floor is detected.


        Instead of using this function, generate the LUT using the gen_soft_dec_lut after creating the constellation object and then use the soft_decision_maker function to return the answer from the LUT.
        """
        return _digital_swig0.constellation_16qam_sptr_calc_soft_dec(self, sample, npwr)

    def set_soft_dec_lut(self, soft_dec_lut: "std::vector< std::vector< float,std::allocator< float > >,std::allocator< std::vector< float,std::allocator< float > > > > const &", precision: "int") -> "void":
        r"""
        set_soft_dec_lut(constellation_16qam_sptr self, std::vector< std::vector< float,std::allocator< float > >,std::allocator< std::vector< float,std::allocator< float > > > > const & soft_dec_lut, int precision)
        Define a soft decision look-up table.

        Define a soft decision look-up table (LUT). Because soft decisions can be calculated in various ways with various levels of accuracy and complexity, this function allows users to create a LUT in their own way.


        Setting the LUT here means that has_soft_dec_lut will return true. Decision vectors returned by soft_decision_maker will be calculated using this LUT.
        """
        return _digital_swig0.constellation_16qam_sptr_set_soft_dec_lut(self, soft_dec_lut, precision)

    def has_soft_dec_lut(self) -> "bool":
        r"""
        has_soft_dec_lut(constellation_16qam_sptr self) -> bool
        Returns True if the soft decision LUT has been defined, False otherwise.
        """
        return _digital_swig0.constellation_16qam_sptr_has_soft_dec_lut(self)

    def soft_dec_lut(self) -> "std::vector< std::vector< float,std::allocator< float > >,std::allocator< std::vector< float,std::allocator< float > > > >":
        r"""soft_dec_lut(constellation_16qam_sptr self) -> std::vector< std::vector< float,std::allocator< float > >,std::allocator< std::vector< float,std::allocator< float > > > >"""
        return _digital_swig0.constellation_16qam_sptr_soft_dec_lut(self)

    def soft_decision_maker(self, sample: "gr_complex") -> "std::vector< float,std::allocator< float > >":
        r"""
        soft_decision_maker(constellation_16qam_sptr self, gr_complex sample) -> pmt_vector_float
        Returns the soft decisions for the given .

        Returns the soft decisions for the given . If a LUT is defined for the object, the decisions will be calculated from there. Otherwise, this function will call calc_soft_dec directly to calculate the soft decisions.
        """
        return _digital_swig0.constellation_16qam_sptr_soft_decision_maker(self, sample)

# Register constellation_16qam_sptr in _digital_swig0:
_digital_swig0.constellation_16qam_sptr_swigregister(constellation_16qam_sptr)

constellation_16qam_sptr.__repr__ = lambda self: "<constellation 16qam>"
constellation_16qam = constellation_16qam.make;

class ofdm_equalizer_base_sptr(object):
    r"""Proxy of C++ boost::shared_ptr< gr::digital::ofdm_equalizer_base > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(ofdm_equalizer_base_sptr self) -> ofdm_equalizer_base_sptr
        __init__(ofdm_equalizer_base_sptr self, ofdm_equalizer_base p) -> ofdm_equalizer_base_sptr
        """
        _digital_swig0.ofdm_equalizer_base_sptr_swiginit(self, _digital_swig0.new_ofdm_equalizer_base_sptr(*args))

    def __deref__(self) -> "gr::digital::ofdm_equalizer_base *":
        r"""__deref__(ofdm_equalizer_base_sptr self) -> ofdm_equalizer_base"""
        return _digital_swig0.ofdm_equalizer_base_sptr___deref__(self)
    __swig_destroy__ = _digital_swig0.delete_ofdm_equalizer_base_sptr

    def reset(self) -> "void":
        r"""
        reset(ofdm_equalizer_base_sptr self)
        Reset the channel information state knowledge.
        """
        return _digital_swig0.ofdm_equalizer_base_sptr_reset(self)

    def equalize(self, *args, **kwargs) -> "void":
        r"""
        equalize(ofdm_equalizer_base_sptr self, gr_complex * frame, int n_sym, pmt_vector_cfloat initial_taps=std::vector< gr_complex >(), tags_vector_t tags=std::vector< gr::tag_t >())
        Run the actual equalization.
        """
        return _digital_swig0.ofdm_equalizer_base_sptr_equalize(self, *args, **kwargs)

    def get_channel_state(self, taps: "pmt_vector_cfloat") -> "void":
        r"""
        get_channel_state(ofdm_equalizer_base_sptr self, pmt_vector_cfloat taps)
        Return the current channel state.
        """
        return _digital_swig0.ofdm_equalizer_base_sptr_get_channel_state(self, taps)

    def fft_len(self) -> "int":
        r"""fft_len(ofdm_equalizer_base_sptr self) -> int"""
        return _digital_swig0.ofdm_equalizer_base_sptr_fft_len(self)

    def base(self) -> "gr::digital::ofdm_equalizer_base::sptr":
        r"""base(ofdm_equalizer_base_sptr self) -> ofdm_equalizer_base_sptr"""
        return _digital_swig0.ofdm_equalizer_base_sptr_base(self)

# Register ofdm_equalizer_base_sptr in _digital_swig0:
_digital_swig0.ofdm_equalizer_base_sptr_swigregister(ofdm_equalizer_base_sptr)
class ofdm_equalizer_1d_pilots_sptr(object):
    r"""Proxy of C++ boost::shared_ptr< gr::digital::ofdm_equalizer_1d_pilots > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(ofdm_equalizer_1d_pilots_sptr self) -> ofdm_equalizer_1d_pilots_sptr
        __init__(ofdm_equalizer_1d_pilots_sptr self, ofdm_equalizer_1d_pilots p) -> ofdm_equalizer_1d_pilots_sptr
        """
        _digital_swig0.ofdm_equalizer_1d_pilots_sptr_swiginit(self, _digital_swig0.new_ofdm_equalizer_1d_pilots_sptr(*args))

    def __deref__(self) -> "gr::digital::ofdm_equalizer_1d_pilots *":
        r"""__deref__(ofdm_equalizer_1d_pilots_sptr self) -> ofdm_equalizer_1d_pilots"""
        return _digital_swig0.ofdm_equalizer_1d_pilots_sptr___deref__(self)
    __swig_destroy__ = _digital_swig0.delete_ofdm_equalizer_1d_pilots_sptr

    def reset(self) -> "void":
        r"""
        reset(ofdm_equalizer_1d_pilots_sptr self)
        Reset the channel information state knowledge.
        """
        return _digital_swig0.ofdm_equalizer_1d_pilots_sptr_reset(self)

    def equalize(self, *args, **kwargs) -> "void":
        r"""
        equalize(ofdm_equalizer_1d_pilots_sptr self, gr_complex * frame, int n_sym, pmt_vector_cfloat initial_taps=std::vector< gr_complex >(), tags_vector_t tags=std::vector< gr::tag_t >())
        Run the actual equalization.
        """
        return _digital_swig0.ofdm_equalizer_1d_pilots_sptr_equalize(self, *args, **kwargs)

    def get_channel_state(self, taps: "pmt_vector_cfloat") -> "void":
        r"""
        get_channel_state(ofdm_equalizer_1d_pilots_sptr self, pmt_vector_cfloat taps)
        Return the current channel state.
        """
        return _digital_swig0.ofdm_equalizer_1d_pilots_sptr_get_channel_state(self, taps)

    def fft_len(self) -> "int":
        r"""fft_len(ofdm_equalizer_1d_pilots_sptr self) -> int"""
        return _digital_swig0.ofdm_equalizer_1d_pilots_sptr_fft_len(self)

    def base(self) -> "gr::digital::ofdm_equalizer_base::sptr":
        r"""base(ofdm_equalizer_1d_pilots_sptr self) -> ofdm_equalizer_base_sptr"""
        return _digital_swig0.ofdm_equalizer_1d_pilots_sptr_base(self)

# Register ofdm_equalizer_1d_pilots_sptr in _digital_swig0:
_digital_swig0.ofdm_equalizer_1d_pilots_sptr_swigregister(ofdm_equalizer_1d_pilots_sptr)

ofdm_equalizer_1d_pilots_sptr.__repr__ = lambda self: "<OFDM equalizer 1D base class>"

class ofdm_equalizer_simpledfe_sptr(object):
    r"""Proxy of C++ boost::shared_ptr< gr::digital::ofdm_equalizer_simpledfe > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(ofdm_equalizer_simpledfe_sptr self) -> ofdm_equalizer_simpledfe_sptr
        __init__(ofdm_equalizer_simpledfe_sptr self, ofdm_equalizer_simpledfe p) -> ofdm_equalizer_simpledfe_sptr
        """
        _digital_swig0.ofdm_equalizer_simpledfe_sptr_swiginit(self, _digital_swig0.new_ofdm_equalizer_simpledfe_sptr(*args))

    def __deref__(self) -> "gr::digital::ofdm_equalizer_simpledfe *":
        r"""__deref__(ofdm_equalizer_simpledfe_sptr self) -> ofdm_equalizer_simpledfe"""
        return _digital_swig0.ofdm_equalizer_simpledfe_sptr___deref__(self)
    __swig_destroy__ = _digital_swig0.delete_ofdm_equalizer_simpledfe_sptr

    def make(self, *args, **kwargs) -> "gr::digital::ofdm_equalizer_simpledfe::sptr":
        r"""
        make(ofdm_equalizer_simpledfe_sptr self, int fft_len, constellation_sptr constellation, std::vector< std::vector< int,std::allocator< int > >,std::allocator< std::vector< int,std::allocator< int > > > > const & occupied_carriers=std::vector< std::vector< int > >(), std::vector< std::vector< int,std::allocator< int > >,std::allocator< std::vector< int,std::allocator< int > > > > const & pilot_carriers=std::vector< std::vector< int > >(), gr_vector_vector_complexf pilot_symbols=std::vector< std::vector< gr_complex > >(), int symbols_skipped=0, float alpha=0.1, bool input_is_shifted=True) -> ofdm_equalizer_simpledfe_sptr
        Simple decision feedback equalizer for OFDM.

        Equalizes an OFDM signal symbol by symbol using knowledge of the complex modulations symbols. For every symbol, the following steps are performed:



        This equalizer makes a lot of assumptions:



        Note that the equalized symbols are  on the constellation. This means soft information of the modulation symbols is lost after the equalization, which is suboptimal for channel codes that use soft decision.

        Constructor Specific Documentation:



        Args:
            fft_len : 
            constellation : 
            occupied_carriers : 
            pilot_carriers : 
            pilot_symbols : 
            symbols_skipped : 
            alpha : 
            input_is_shifted : 
        """
        return _digital_swig0.ofdm_equalizer_simpledfe_sptr_make(self, *args, **kwargs)

    def reset(self) -> "void":
        r"""
        reset(ofdm_equalizer_simpledfe_sptr self)
        Reset the channel information state knowledge.
        """
        return _digital_swig0.ofdm_equalizer_simpledfe_sptr_reset(self)

    def equalize(self, *args, **kwargs) -> "void":
        r"""
        equalize(ofdm_equalizer_simpledfe_sptr self, gr_complex * frame, int n_sym, pmt_vector_cfloat initial_taps=std::vector< gr_complex >(), tags_vector_t tags=std::vector< gr::tag_t >())
        Run the actual equalization.
        """
        return _digital_swig0.ofdm_equalizer_simpledfe_sptr_equalize(self, *args, **kwargs)

    def get_channel_state(self, taps: "pmt_vector_cfloat") -> "void":
        r"""
        get_channel_state(ofdm_equalizer_simpledfe_sptr self, pmt_vector_cfloat taps)
        Return the current channel state.
        """
        return _digital_swig0.ofdm_equalizer_simpledfe_sptr_get_channel_state(self, taps)

    def fft_len(self) -> "int":
        r"""fft_len(ofdm_equalizer_simpledfe_sptr self) -> int"""
        return _digital_swig0.ofdm_equalizer_simpledfe_sptr_fft_len(self)

    def base(self) -> "gr::digital::ofdm_equalizer_base::sptr":
        r"""base(ofdm_equalizer_simpledfe_sptr self) -> ofdm_equalizer_base_sptr"""
        return _digital_swig0.ofdm_equalizer_simpledfe_sptr_base(self)

# Register ofdm_equalizer_simpledfe_sptr in _digital_swig0:
_digital_swig0.ofdm_equalizer_simpledfe_sptr_swigregister(ofdm_equalizer_simpledfe_sptr)

ofdm_equalizer_simpledfe_sptr.__repr__ = lambda self: "<OFDM equalizer simpledfe>"
ofdm_equalizer_simpledfe = ofdm_equalizer_simpledfe.make;

class ofdm_equalizer_static_sptr(object):
    r"""Proxy of C++ boost::shared_ptr< gr::digital::ofdm_equalizer_static > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(ofdm_equalizer_static_sptr self) -> ofdm_equalizer_static_sptr
        __init__(ofdm_equalizer_static_sptr self, ofdm_equalizer_static p) -> ofdm_equalizer_static_sptr
        """
        _digital_swig0.ofdm_equalizer_static_sptr_swiginit(self, _digital_swig0.new_ofdm_equalizer_static_sptr(*args))

    def __deref__(self) -> "gr::digital::ofdm_equalizer_static *":
        r"""__deref__(ofdm_equalizer_static_sptr self) -> ofdm_equalizer_static"""
        return _digital_swig0.ofdm_equalizer_static_sptr___deref__(self)
    __swig_destroy__ = _digital_swig0.delete_ofdm_equalizer_static_sptr

    def make(self, *args, **kwargs) -> "gr::digital::ofdm_equalizer_static::sptr":
        r"""
        make(ofdm_equalizer_static_sptr self, int fft_len, std::vector< std::vector< int,std::allocator< int > >,std::allocator< std::vector< int,std::allocator< int > > > > const & occupied_carriers=std::vector< std::vector< int > >(), std::vector< std::vector< int,std::allocator< int > >,std::allocator< std::vector< int,std::allocator< int > > > > const & pilot_carriers=std::vector< std::vector< int > >(), gr_vector_vector_complexf pilot_symbols=std::vector< std::vector< gr_complex > >(), int symbols_skipped=0, bool input_is_shifted=True) -> ofdm_equalizer_static_sptr
        Very simple static equalizer for OFDM.

        This is an extremely simple equalizer. It will only work for high-SNR, very, very slowly changing channels.


        It simply divides the signal with the currently known channel state. Whenever a pilot symbol comes around, it updates the channel state on that particular carrier by dividing the received symbol with the known pilot symbol.

        Constructor Specific Documentation:



        Args:
            fft_len : 
            occupied_carriers : 
            pilot_carriers : 
            pilot_symbols : 
            symbols_skipped : 
            input_is_shifted : 
        """
        return _digital_swig0.ofdm_equalizer_static_sptr_make(self, *args, **kwargs)

    def reset(self) -> "void":
        r"""
        reset(ofdm_equalizer_static_sptr self)
        Reset the channel information state knowledge.
        """
        return _digital_swig0.ofdm_equalizer_static_sptr_reset(self)

    def equalize(self, *args, **kwargs) -> "void":
        r"""
        equalize(ofdm_equalizer_static_sptr self, gr_complex * frame, int n_sym, pmt_vector_cfloat initial_taps=std::vector< gr_complex >(), tags_vector_t tags=std::vector< gr::tag_t >())
        Run the actual equalization.
        """
        return _digital_swig0.ofdm_equalizer_static_sptr_equalize(self, *args, **kwargs)

    def get_channel_state(self, taps: "pmt_vector_cfloat") -> "void":
        r"""
        get_channel_state(ofdm_equalizer_static_sptr self, pmt_vector_cfloat taps)
        Return the current channel state.
        """
        return _digital_swig0.ofdm_equalizer_static_sptr_get_channel_state(self, taps)

    def fft_len(self) -> "int":
        r"""fft_len(ofdm_equalizer_static_sptr self) -> int"""
        return _digital_swig0.ofdm_equalizer_static_sptr_fft_len(self)

    def base(self) -> "gr::digital::ofdm_equalizer_base::sptr":
        r"""base(ofdm_equalizer_static_sptr self) -> ofdm_equalizer_base_sptr"""
        return _digital_swig0.ofdm_equalizer_static_sptr_base(self)

# Register ofdm_equalizer_static_sptr in _digital_swig0:
_digital_swig0.ofdm_equalizer_static_sptr_swigregister(ofdm_equalizer_static_sptr)

ofdm_equalizer_static_sptr.__repr__ = lambda self: "<OFDM equalizer static>"
ofdm_equalizer_static = ofdm_equalizer_static.make;


