// Code generated by 'go run genfiles.go'; DO NOT EDIT.

//go:build goexperiment.simd

// This file contains functions testing simd methods that compare two operands.
// Each function in this file is specialized for a
// particular simd type <BaseType><Width>x<Count>.

package simd_test

import (
	"simd/archsimd"
	"testing"
)

// testInt8x16Compare tests the simd comparison method f against the expected behavior generated by want
func testInt8x16Compare(t *testing.T, f func(_, _ archsimd.Int8x16) archsimd.Mask8x16, want func(_, _ []int8) []int64) {
	n := 16
	t.Helper()
	forSlicePair(t, int8s, n, func(x, y []int8) bool {
		t.Helper()
		a := archsimd.LoadInt8x16Slice(x)
		b := archsimd.LoadInt8x16Slice(y)
		g := make([]int8, n)
		f(a, b).ToInt8x16().StoreSlice(g)
		w := want(x, y)
		return checkSlicesLogInput(t, s64(g), w, 0.0, func() { t.Helper(); t.Logf("x=%v", x); t.Logf("y=%v", y) })
	})
}

// testInt16x8Compare tests the simd comparison method f against the expected behavior generated by want
func testInt16x8Compare(t *testing.T, f func(_, _ archsimd.Int16x8) archsimd.Mask16x8, want func(_, _ []int16) []int64) {
	n := 8
	t.Helper()
	forSlicePair(t, int16s, n, func(x, y []int16) bool {
		t.Helper()
		a := archsimd.LoadInt16x8Slice(x)
		b := archsimd.LoadInt16x8Slice(y)
		g := make([]int16, n)
		f(a, b).ToInt16x8().StoreSlice(g)
		w := want(x, y)
		return checkSlicesLogInput(t, s64(g), w, 0.0, func() { t.Helper(); t.Logf("x=%v", x); t.Logf("y=%v", y) })
	})
}

// testInt32x4Compare tests the simd comparison method f against the expected behavior generated by want
func testInt32x4Compare(t *testing.T, f func(_, _ archsimd.Int32x4) archsimd.Mask32x4, want func(_, _ []int32) []int64) {
	n := 4
	t.Helper()
	forSlicePair(t, int32s, n, func(x, y []int32) bool {
		t.Helper()
		a := archsimd.LoadInt32x4Slice(x)
		b := archsimd.LoadInt32x4Slice(y)
		g := make([]int32, n)
		f(a, b).ToInt32x4().StoreSlice(g)
		w := want(x, y)
		return checkSlicesLogInput(t, s64(g), w, 0.0, func() { t.Helper(); t.Logf("x=%v", x); t.Logf("y=%v", y) })
	})
}

// testInt64x2Compare tests the simd comparison method f against the expected behavior generated by want
func testInt64x2Compare(t *testing.T, f func(_, _ archsimd.Int64x2) archsimd.Mask64x2, want func(_, _ []int64) []int64) {
	n := 2
	t.Helper()
	forSlicePair(t, int64s, n, func(x, y []int64) bool {
		t.Helper()
		a := archsimd.LoadInt64x2Slice(x)
		b := archsimd.LoadInt64x2Slice(y)
		g := make([]int64, n)
		f(a, b).ToInt64x2().StoreSlice(g)
		w := want(x, y)
		return checkSlicesLogInput(t, s64(g), w, 0.0, func() { t.Helper(); t.Logf("x=%v", x); t.Logf("y=%v", y) })
	})
}

// testUint8x16Compare tests the simd comparison method f against the expected behavior generated by want
func testUint8x16Compare(t *testing.T, f func(_, _ archsimd.Uint8x16) archsimd.Mask8x16, want func(_, _ []uint8) []int64) {
	n := 16
	t.Helper()
	forSlicePair(t, uint8s, n, func(x, y []uint8) bool {
		t.Helper()
		a := archsimd.LoadUint8x16Slice(x)
		b := archsimd.LoadUint8x16Slice(y)
		g := make([]int8, n)
		f(a, b).ToInt8x16().StoreSlice(g)
		w := want(x, y)
		return checkSlicesLogInput(t, s64(g), w, 0.0, func() { t.Helper(); t.Logf("x=%v", x); t.Logf("y=%v", y) })
	})
}

// testUint16x8Compare tests the simd comparison method f against the expected behavior generated by want
func testUint16x8Compare(t *testing.T, f func(_, _ archsimd.Uint16x8) archsimd.Mask16x8, want func(_, _ []uint16) []int64) {
	n := 8
	t.Helper()
	forSlicePair(t, uint16s, n, func(x, y []uint16) bool {
		t.Helper()
		a := archsimd.LoadUint16x8Slice(x)
		b := archsimd.LoadUint16x8Slice(y)
		g := make([]int16, n)
		f(a, b).ToInt16x8().StoreSlice(g)
		w := want(x, y)
		return checkSlicesLogInput(t, s64(g), w, 0.0, func() { t.Helper(); t.Logf("x=%v", x); t.Logf("y=%v", y) })
	})
}

// testUint32x4Compare tests the simd comparison method f against the expected behavior generated by want
func testUint32x4Compare(t *testing.T, f func(_, _ archsimd.Uint32x4) archsimd.Mask32x4, want func(_, _ []uint32) []int64) {
	n := 4
	t.Helper()
	forSlicePair(t, uint32s, n, func(x, y []uint32) bool {
		t.Helper()
		a := archsimd.LoadUint32x4Slice(x)
		b := archsimd.LoadUint32x4Slice(y)
		g := make([]int32, n)
		f(a, b).ToInt32x4().StoreSlice(g)
		w := want(x, y)
		return checkSlicesLogInput(t, s64(g), w, 0.0, func() { t.Helper(); t.Logf("x=%v", x); t.Logf("y=%v", y) })
	})
}

// testUint64x2Compare tests the simd comparison method f against the expected behavior generated by want
func testUint64x2Compare(t *testing.T, f func(_, _ archsimd.Uint64x2) archsimd.Mask64x2, want func(_, _ []uint64) []int64) {
	n := 2
	t.Helper()
	forSlicePair(t, uint64s, n, func(x, y []uint64) bool {
		t.Helper()
		a := archsimd.LoadUint64x2Slice(x)
		b := archsimd.LoadUint64x2Slice(y)
		g := make([]int64, n)
		f(a, b).ToInt64x2().StoreSlice(g)
		w := want(x, y)
		return checkSlicesLogInput(t, s64(g), w, 0.0, func() { t.Helper(); t.Logf("x=%v", x); t.Logf("y=%v", y) })
	})
}

// testFloat32x4Compare tests the simd comparison method f against the expected behavior generated by want
func testFloat32x4Compare(t *testing.T, f func(_, _ archsimd.Float32x4) archsimd.Mask32x4, want func(_, _ []float32) []int64) {
	n := 4
	t.Helper()
	forSlicePair(t, float32s, n, func(x, y []float32) bool {
		t.Helper()
		a := archsimd.LoadFloat32x4Slice(x)
		b := archsimd.LoadFloat32x4Slice(y)
		g := make([]int32, n)
		f(a, b).ToInt32x4().StoreSlice(g)
		w := want(x, y)
		return checkSlicesLogInput(t, s64(g), w, 0.0, func() { t.Helper(); t.Logf("x=%v", x); t.Logf("y=%v", y) })
	})
}

// testFloat64x2Compare tests the simd comparison method f against the expected behavior generated by want
func testFloat64x2Compare(t *testing.T, f func(_, _ archsimd.Float64x2) archsimd.Mask64x2, want func(_, _ []float64) []int64) {
	n := 2
	t.Helper()
	forSlicePair(t, float64s, n, func(x, y []float64) bool {
		t.Helper()
		a := archsimd.LoadFloat64x2Slice(x)
		b := archsimd.LoadFloat64x2Slice(y)
		g := make([]int64, n)
		f(a, b).ToInt64x2().StoreSlice(g)
		w := want(x, y)
		return checkSlicesLogInput(t, s64(g), w, 0.0, func() { t.Helper(); t.Logf("x=%v", x); t.Logf("y=%v", y) })
	})
}

// testInt8x32Compare tests the simd comparison method f against the expected behavior generated by want
func testInt8x32Compare(t *testing.T, f func(_, _ archsimd.Int8x32) archsimd.Mask8x32, want func(_, _ []int8) []int64) {
	n := 32
	t.Helper()
	forSlicePair(t, int8s, n, func(x, y []int8) bool {
		t.Helper()
		a := archsimd.LoadInt8x32Slice(x)
		b := archsimd.LoadInt8x32Slice(y)
		g := make([]int8, n)
		f(a, b).ToInt8x32().StoreSlice(g)
		w := want(x, y)
		return checkSlicesLogInput(t, s64(g), w, 0.0, func() { t.Helper(); t.Logf("x=%v", x); t.Logf("y=%v", y) })
	})
}

// testInt16x16Compare tests the simd comparison method f against the expected behavior generated by want
func testInt16x16Compare(t *testing.T, f func(_, _ archsimd.Int16x16) archsimd.Mask16x16, want func(_, _ []int16) []int64) {
	n := 16
	t.Helper()
	forSlicePair(t, int16s, n, func(x, y []int16) bool {
		t.Helper()
		a := archsimd.LoadInt16x16Slice(x)
		b := archsimd.LoadInt16x16Slice(y)
		g := make([]int16, n)
		f(a, b).ToInt16x16().StoreSlice(g)
		w := want(x, y)
		return checkSlicesLogInput(t, s64(g), w, 0.0, func() { t.Helper(); t.Logf("x=%v", x); t.Logf("y=%v", y) })
	})
}

// testInt32x8Compare tests the simd comparison method f against the expected behavior generated by want
func testInt32x8Compare(t *testing.T, f func(_, _ archsimd.Int32x8) archsimd.Mask32x8, want func(_, _ []int32) []int64) {
	n := 8
	t.Helper()
	forSlicePair(t, int32s, n, func(x, y []int32) bool {
		t.Helper()
		a := archsimd.LoadInt32x8Slice(x)
		b := archsimd.LoadInt32x8Slice(y)
		g := make([]int32, n)
		f(a, b).ToInt32x8().StoreSlice(g)
		w := want(x, y)
		return checkSlicesLogInput(t, s64(g), w, 0.0, func() { t.Helper(); t.Logf("x=%v", x); t.Logf("y=%v", y) })
	})
}

// testInt64x4Compare tests the simd comparison method f against the expected behavior generated by want
func testInt64x4Compare(t *testing.T, f func(_, _ archsimd.Int64x4) archsimd.Mask64x4, want func(_, _ []int64) []int64) {
	n := 4
	t.Helper()
	forSlicePair(t, int64s, n, func(x, y []int64) bool {
		t.Helper()
		a := archsimd.LoadInt64x4Slice(x)
		b := archsimd.LoadInt64x4Slice(y)
		g := make([]int64, n)
		f(a, b).ToInt64x4().StoreSlice(g)
		w := want(x, y)
		return checkSlicesLogInput(t, s64(g), w, 0.0, func() { t.Helper(); t.Logf("x=%v", x); t.Logf("y=%v", y) })
	})
}

// testUint8x32Compare tests the simd comparison method f against the expected behavior generated by want
func testUint8x32Compare(t *testing.T, f func(_, _ archsimd.Uint8x32) archsimd.Mask8x32, want func(_, _ []uint8) []int64) {
	n := 32
	t.Helper()
	forSlicePair(t, uint8s, n, func(x, y []uint8) bool {
		t.Helper()
		a := archsimd.LoadUint8x32Slice(x)
		b := archsimd.LoadUint8x32Slice(y)
		g := make([]int8, n)
		f(a, b).ToInt8x32().StoreSlice(g)
		w := want(x, y)
		return checkSlicesLogInput(t, s64(g), w, 0.0, func() { t.Helper(); t.Logf("x=%v", x); t.Logf("y=%v", y) })
	})
}

// testUint16x16Compare tests the simd comparison method f against the expected behavior generated by want
func testUint16x16Compare(t *testing.T, f func(_, _ archsimd.Uint16x16) archsimd.Mask16x16, want func(_, _ []uint16) []int64) {
	n := 16
	t.Helper()
	forSlicePair(t, uint16s, n, func(x, y []uint16) bool {
		t.Helper()
		a := archsimd.LoadUint16x16Slice(x)
		b := archsimd.LoadUint16x16Slice(y)
		g := make([]int16, n)
		f(a, b).ToInt16x16().StoreSlice(g)
		w := want(x, y)
		return checkSlicesLogInput(t, s64(g), w, 0.0, func() { t.Helper(); t.Logf("x=%v", x); t.Logf("y=%v", y) })
	})
}

// testUint32x8Compare tests the simd comparison method f against the expected behavior generated by want
func testUint32x8Compare(t *testing.T, f func(_, _ archsimd.Uint32x8) archsimd.Mask32x8, want func(_, _ []uint32) []int64) {
	n := 8
	t.Helper()
	forSlicePair(t, uint32s, n, func(x, y []uint32) bool {
		t.Helper()
		a := archsimd.LoadUint32x8Slice(x)
		b := archsimd.LoadUint32x8Slice(y)
		g := make([]int32, n)
		f(a, b).ToInt32x8().StoreSlice(g)
		w := want(x, y)
		return checkSlicesLogInput(t, s64(g), w, 0.0, func() { t.Helper(); t.Logf("x=%v", x); t.Logf("y=%v", y) })
	})
}

// testUint64x4Compare tests the simd comparison method f against the expected behavior generated by want
func testUint64x4Compare(t *testing.T, f func(_, _ archsimd.Uint64x4) archsimd.Mask64x4, want func(_, _ []uint64) []int64) {
	n := 4
	t.Helper()
	forSlicePair(t, uint64s, n, func(x, y []uint64) bool {
		t.Helper()
		a := archsimd.LoadUint64x4Slice(x)
		b := archsimd.LoadUint64x4Slice(y)
		g := make([]int64, n)
		f(a, b).ToInt64x4().StoreSlice(g)
		w := want(x, y)
		return checkSlicesLogInput(t, s64(g), w, 0.0, func() { t.Helper(); t.Logf("x=%v", x); t.Logf("y=%v", y) })
	})
}

// testFloat32x8Compare tests the simd comparison method f against the expected behavior generated by want
func testFloat32x8Compare(t *testing.T, f func(_, _ archsimd.Float32x8) archsimd.Mask32x8, want func(_, _ []float32) []int64) {
	n := 8
	t.Helper()
	forSlicePair(t, float32s, n, func(x, y []float32) bool {
		t.Helper()
		a := archsimd.LoadFloat32x8Slice(x)
		b := archsimd.LoadFloat32x8Slice(y)
		g := make([]int32, n)
		f(a, b).ToInt32x8().StoreSlice(g)
		w := want(x, y)
		return checkSlicesLogInput(t, s64(g), w, 0.0, func() { t.Helper(); t.Logf("x=%v", x); t.Logf("y=%v", y) })
	})
}

// testFloat64x4Compare tests the simd comparison method f against the expected behavior generated by want
func testFloat64x4Compare(t *testing.T, f func(_, _ archsimd.Float64x4) archsimd.Mask64x4, want func(_, _ []float64) []int64) {
	n := 4
	t.Helper()
	forSlicePair(t, float64s, n, func(x, y []float64) bool {
		t.Helper()
		a := archsimd.LoadFloat64x4Slice(x)
		b := archsimd.LoadFloat64x4Slice(y)
		g := make([]int64, n)
		f(a, b).ToInt64x4().StoreSlice(g)
		w := want(x, y)
		return checkSlicesLogInput(t, s64(g), w, 0.0, func() { t.Helper(); t.Logf("x=%v", x); t.Logf("y=%v", y) })
	})
}

// testInt8x64Compare tests the simd comparison method f against the expected behavior generated by want
func testInt8x64Compare(t *testing.T, f func(_, _ archsimd.Int8x64) archsimd.Mask8x64, want func(_, _ []int8) []int64) {
	n := 64
	t.Helper()
	forSlicePair(t, int8s, n, func(x, y []int8) bool {
		t.Helper()
		a := archsimd.LoadInt8x64Slice(x)
		b := archsimd.LoadInt8x64Slice(y)
		g := make([]int8, n)
		f(a, b).ToInt8x64().StoreSlice(g)
		w := want(x, y)
		return checkSlicesLogInput(t, s64(g), w, 0.0, func() { t.Helper(); t.Logf("x=%v", x); t.Logf("y=%v", y) })
	})
}

// testInt16x32Compare tests the simd comparison method f against the expected behavior generated by want
func testInt16x32Compare(t *testing.T, f func(_, _ archsimd.Int16x32) archsimd.Mask16x32, want func(_, _ []int16) []int64) {
	n := 32
	t.Helper()
	forSlicePair(t, int16s, n, func(x, y []int16) bool {
		t.Helper()
		a := archsimd.LoadInt16x32Slice(x)
		b := archsimd.LoadInt16x32Slice(y)
		g := make([]int16, n)
		f(a, b).ToInt16x32().StoreSlice(g)
		w := want(x, y)
		return checkSlicesLogInput(t, s64(g), w, 0.0, func() { t.Helper(); t.Logf("x=%v", x); t.Logf("y=%v", y) })
	})
}

// testInt32x16Compare tests the simd comparison method f against the expected behavior generated by want
func testInt32x16Compare(t *testing.T, f func(_, _ archsimd.Int32x16) archsimd.Mask32x16, want func(_, _ []int32) []int64) {
	n := 16
	t.Helper()
	forSlicePair(t, int32s, n, func(x, y []int32) bool {
		t.Helper()
		a := archsimd.LoadInt32x16Slice(x)
		b := archsimd.LoadInt32x16Slice(y)
		g := make([]int32, n)
		f(a, b).ToInt32x16().StoreSlice(g)
		w := want(x, y)
		return checkSlicesLogInput(t, s64(g), w, 0.0, func() { t.Helper(); t.Logf("x=%v", x); t.Logf("y=%v", y) })
	})
}

// testInt64x8Compare tests the simd comparison method f against the expected behavior generated by want
func testInt64x8Compare(t *testing.T, f func(_, _ archsimd.Int64x8) archsimd.Mask64x8, want func(_, _ []int64) []int64) {
	n := 8
	t.Helper()
	forSlicePair(t, int64s, n, func(x, y []int64) bool {
		t.Helper()
		a := archsimd.LoadInt64x8Slice(x)
		b := archsimd.LoadInt64x8Slice(y)
		g := make([]int64, n)
		f(a, b).ToInt64x8().StoreSlice(g)
		w := want(x, y)
		return checkSlicesLogInput(t, s64(g), w, 0.0, func() { t.Helper(); t.Logf("x=%v", x); t.Logf("y=%v", y) })
	})
}

// testUint8x64Compare tests the simd comparison method f against the expected behavior generated by want
func testUint8x64Compare(t *testing.T, f func(_, _ archsimd.Uint8x64) archsimd.Mask8x64, want func(_, _ []uint8) []int64) {
	n := 64
	t.Helper()
	forSlicePair(t, uint8s, n, func(x, y []uint8) bool {
		t.Helper()
		a := archsimd.LoadUint8x64Slice(x)
		b := archsimd.LoadUint8x64Slice(y)
		g := make([]int8, n)
		f(a, b).ToInt8x64().StoreSlice(g)
		w := want(x, y)
		return checkSlicesLogInput(t, s64(g), w, 0.0, func() { t.Helper(); t.Logf("x=%v", x); t.Logf("y=%v", y) })
	})
}

// testUint16x32Compare tests the simd comparison method f against the expected behavior generated by want
func testUint16x32Compare(t *testing.T, f func(_, _ archsimd.Uint16x32) archsimd.Mask16x32, want func(_, _ []uint16) []int64) {
	n := 32
	t.Helper()
	forSlicePair(t, uint16s, n, func(x, y []uint16) bool {
		t.Helper()
		a := archsimd.LoadUint16x32Slice(x)
		b := archsimd.LoadUint16x32Slice(y)
		g := make([]int16, n)
		f(a, b).ToInt16x32().StoreSlice(g)
		w := want(x, y)
		return checkSlicesLogInput(t, s64(g), w, 0.0, func() { t.Helper(); t.Logf("x=%v", x); t.Logf("y=%v", y) })
	})
}

// testUint32x16Compare tests the simd comparison method f against the expected behavior generated by want
func testUint32x16Compare(t *testing.T, f func(_, _ archsimd.Uint32x16) archsimd.Mask32x16, want func(_, _ []uint32) []int64) {
	n := 16
	t.Helper()
	forSlicePair(t, uint32s, n, func(x, y []uint32) bool {
		t.Helper()
		a := archsimd.LoadUint32x16Slice(x)
		b := archsimd.LoadUint32x16Slice(y)
		g := make([]int32, n)
		f(a, b).ToInt32x16().StoreSlice(g)
		w := want(x, y)
		return checkSlicesLogInput(t, s64(g), w, 0.0, func() { t.Helper(); t.Logf("x=%v", x); t.Logf("y=%v", y) })
	})
}

// testUint64x8Compare tests the simd comparison method f against the expected behavior generated by want
func testUint64x8Compare(t *testing.T, f func(_, _ archsimd.Uint64x8) archsimd.Mask64x8, want func(_, _ []uint64) []int64) {
	n := 8
	t.Helper()
	forSlicePair(t, uint64s, n, func(x, y []uint64) bool {
		t.Helper()
		a := archsimd.LoadUint64x8Slice(x)
		b := archsimd.LoadUint64x8Slice(y)
		g := make([]int64, n)
		f(a, b).ToInt64x8().StoreSlice(g)
		w := want(x, y)
		return checkSlicesLogInput(t, s64(g), w, 0.0, func() { t.Helper(); t.Logf("x=%v", x); t.Logf("y=%v", y) })
	})
}

// testFloat32x16Compare tests the simd comparison method f against the expected behavior generated by want
func testFloat32x16Compare(t *testing.T, f func(_, _ archsimd.Float32x16) archsimd.Mask32x16, want func(_, _ []float32) []int64) {
	n := 16
	t.Helper()
	forSlicePair(t, float32s, n, func(x, y []float32) bool {
		t.Helper()
		a := archsimd.LoadFloat32x16Slice(x)
		b := archsimd.LoadFloat32x16Slice(y)
		g := make([]int32, n)
		f(a, b).ToInt32x16().StoreSlice(g)
		w := want(x, y)
		return checkSlicesLogInput(t, s64(g), w, 0.0, func() { t.Helper(); t.Logf("x=%v", x); t.Logf("y=%v", y) })
	})
}

// testFloat64x8Compare tests the simd comparison method f against the expected behavior generated by want
func testFloat64x8Compare(t *testing.T, f func(_, _ archsimd.Float64x8) archsimd.Mask64x8, want func(_, _ []float64) []int64) {
	n := 8
	t.Helper()
	forSlicePair(t, float64s, n, func(x, y []float64) bool {
		t.Helper()
		a := archsimd.LoadFloat64x8Slice(x)
		b := archsimd.LoadFloat64x8Slice(y)
		g := make([]int64, n)
		f(a, b).ToInt64x8().StoreSlice(g)
		w := want(x, y)
		return checkSlicesLogInput(t, s64(g), w, 0.0, func() { t.Helper(); t.Logf("x=%v", x); t.Logf("y=%v", y) })
	})
}
