// Code generated by 'simdgen -o godefs -goroot $GOROOT -xedPath $XED_PATH go.yaml types.yaml categories.yaml'; DO NOT EDIT.

//go:build goexperiment.simd

package archsimd

import "internal/cpu"

type X86Features struct{}

var X86 X86Features

// AES returns whether the CPU supports the AES feature.
//
// AES is defined on all GOARCHes, but will only return true on
// GOARCH amd64.
func (X86Features) AES() bool {
	return cpu.X86.HasAES
}

// AVX returns whether the CPU supports the AVX feature.
//
// AVX is defined on all GOARCHes, but will only return true on
// GOARCH amd64.
func (X86Features) AVX() bool {
	return cpu.X86.HasAVX
}

// AVX2 returns whether the CPU supports the AVX2 feature.
//
// AVX2 is defined on all GOARCHes, but will only return true on
// GOARCH amd64.
func (X86Features) AVX2() bool {
	return cpu.X86.HasAVX2
}

// AVX512 returns whether the CPU supports the AVX512F+CD+BW+DQ+VL features.
//
// These five CPU features are bundled together, and no use of AVX-512
// is allowed unless all of these features are supported together.
// Nearly every CPU that has shipped with any support for AVX-512 has
// supported all five of these features.
//
// AVX512 is defined on all GOARCHes, but will only return true on
// GOARCH amd64.
func (X86Features) AVX512() bool {
	return cpu.X86.HasAVX512
}

// AVX512BITALG returns whether the CPU supports the AVX512BITALG feature.
//
// AVX512BITALG is defined on all GOARCHes, but will only return true on
// GOARCH amd64.
func (X86Features) AVX512BITALG() bool {
	return cpu.X86.HasAVX512BITALG
}

// AVX512GFNI returns whether the CPU supports the AVX512GFNI feature.
//
// AVX512GFNI is defined on all GOARCHes, but will only return true on
// GOARCH amd64.
func (X86Features) AVX512GFNI() bool {
	return cpu.X86.HasAVX512GFNI
}

// AVX512VAES returns whether the CPU supports the AVX512VAES feature.
//
// AVX512VAES is defined on all GOARCHes, but will only return true on
// GOARCH amd64.
func (X86Features) AVX512VAES() bool {
	return cpu.X86.HasAVX512VAES
}

// AVX512VBMI returns whether the CPU supports the AVX512VBMI feature.
//
// AVX512VBMI is defined on all GOARCHes, but will only return true on
// GOARCH amd64.
func (X86Features) AVX512VBMI() bool {
	return cpu.X86.HasAVX512VBMI
}

// AVX512VBMI2 returns whether the CPU supports the AVX512VBMI2 feature.
//
// AVX512VBMI2 is defined on all GOARCHes, but will only return true on
// GOARCH amd64.
func (X86Features) AVX512VBMI2() bool {
	return cpu.X86.HasAVX512VBMI2
}

// AVX512VNNI returns whether the CPU supports the AVX512VNNI feature.
//
// AVX512VNNI is defined on all GOARCHes, but will only return true on
// GOARCH amd64.
func (X86Features) AVX512VNNI() bool {
	return cpu.X86.HasAVX512VNNI
}

// AVX512VPCLMULQDQ returns whether the CPU supports the AVX512VPCLMULQDQ feature.
//
// AVX512VPCLMULQDQ is defined on all GOARCHes, but will only return true on
// GOARCH amd64.
func (X86Features) AVX512VPCLMULQDQ() bool {
	return cpu.X86.HasAVX512VPCLMULQDQ
}

// AVX512VPOPCNTDQ returns whether the CPU supports the AVX512VPOPCNTDQ feature.
//
// AVX512VPOPCNTDQ is defined on all GOARCHes, but will only return true on
// GOARCH amd64.
func (X86Features) AVX512VPOPCNTDQ() bool {
	return cpu.X86.HasAVX512VPOPCNTDQ
}

// AVXVNNI returns whether the CPU supports the AVXVNNI feature.
//
// AVXVNNI is defined on all GOARCHes, but will only return true on
// GOARCH amd64.
func (X86Features) AVXVNNI() bool {
	return cpu.X86.HasAVXVNNI
}

// SHA returns whether the CPU supports the SHA feature.
//
// SHA is defined on all GOARCHes, but will only return true on
// GOARCH amd64.
func (X86Features) SHA() bool {
	return cpu.X86.HasSHA
}
