/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.incremental.classpathDiff;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.build.report.metrics.GradleBuildPerformanceMetric;
import org.jetbrains.kotlin.incremental.classpathDiff.ClasspathEntrySnapshot;
import org.jetbrains.kotlin.incremental.classpathDiff.ClasspathEntrySnapshotExternalizer;
import org.jetbrains.kotlin.incremental.classpathDiff.ClasspathSnapshot;
import org.jetbrains.kotlin.incremental.classpathDiff.ClasspathSnapshotBuildReporter;
import org.jetbrains.kotlin.incremental.classpathDiff.InMemoryCacheWithEviction;
import org.jetbrains.kotlin.incremental.storage.ExternalizersKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00060\u000b2\u0006\u0010\f\u001a\u00020\rR\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/incremental/classpathDiff/CachedClasspathSnapshotSerializer;", "", "<init>", "()V", "cache", "Lorg/jetbrains/kotlin/incremental/classpathDiff/InMemoryCacheWithEviction;", "Ljava/io/File;", "Lorg/jetbrains/kotlin/incremental/classpathDiff/ClasspathEntrySnapshot;", "load", "Lorg/jetbrains/kotlin/incremental/classpathDiff/ClasspathSnapshot;", "classpathEntrySnapshotFiles", "", "reporter", "Lorg/jetbrains/kotlin/incremental/classpathDiff/ClasspathSnapshotBuildReporter;", "incremental-compilation-impl"})
@SourceDebugExtension(value={"SMAP\nClasspathSnapshotSerializer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClasspathSnapshotSerializer.kt\norg/jetbrains/kotlin/incremental/classpathDiff/CachedClasspathSnapshotSerializer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,290:1\n1563#2:291\n1634#2,3:292\n*S KotlinDebug\n*F\n+ 1 ClasspathSnapshotSerializer.kt\norg/jetbrains/kotlin/incremental/classpathDiff/CachedClasspathSnapshotSerializer\n*L\n40#1:291\n40#1:292,3\n*E\n"})
public final class CachedClasspathSnapshotSerializer {
    @NotNull
    public static final CachedClasspathSnapshotSerializer INSTANCE = new CachedClasspathSnapshotSerializer();
    @NotNull
    private static final InMemoryCacheWithEviction<File, ClasspathEntrySnapshot> cache = new InMemoryCacheWithEviction(20, 1000, 0.8, null, 8, null);

    private CachedClasspathSnapshotSerializer() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ClasspathSnapshot load(@NotNull List<? extends File> classpathEntrySnapshotFiles, @NotNull ClasspathSnapshotBuildReporter reporter) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(classpathEntrySnapshotFiles, (String)"classpathEntrySnapshotFiles");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        cache.newTimePeriod();
        Ref.LongRef cacheMisses = new Ref.LongRef();
        Iterable $this$map$iv = classpathEntrySnapshotFiles;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void snapshotFile;
            File file = (File)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(cache.computeIfAbsent((File)snapshotFile, (Function1<File, ClasspathEntrySnapshot>)((Function1)arg_0 -> CachedClasspathSnapshotSerializer.load$lambda$0$0(cacheMisses, arg_0))));
        }
        List list = (List)destination$iv$iv;
        ClasspathSnapshot classpathSnapshot = new ClasspathSnapshot(list);
        cache.evictEntries();
        reporter.addMetric(GradleBuildPerformanceMetric.LOAD_CLASSPATH_SNAPSHOT_EXECUTION_COUNT, 1L);
        reporter.addMetric(GradleBuildPerformanceMetric.LOAD_CLASSPATH_ENTRY_SNAPSHOT_CACHE_HITS, (long)classpathEntrySnapshotFiles.size() - cacheMisses.element);
        reporter.addMetric(GradleBuildPerformanceMetric.LOAD_CLASSPATH_ENTRY_SNAPSHOT_CACHE_MISSES, cacheMisses.element);
        return classpathSnapshot;
    }

    private static final ClasspathEntrySnapshot load$lambda$0$0(Ref.LongRef $cacheMisses, File it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        long l2 = $cacheMisses.element;
        $cacheMisses.element = l2 + 1L;
        return (ClasspathEntrySnapshot)ExternalizersKt.loadFromFile(ClasspathEntrySnapshotExternalizer.INSTANCE, it);
    }
}

